/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.openapi.swagger.core.util.ObjectMapperFactory;

public final class OpenApiUtils {
    public static final String OPENAPI_31_VERSION = "3.1.0";
    public static final ObjectMapper JSON_MAPPER = ObjectMapperFactory.createJson().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
    public static final ObjectMapper JSON_MAPPER_31 = ObjectMapperFactory.createJson31().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
    public static final ObjectMapper CONVERT_JSON_MAPPER = ObjectMapperFactory.buildStrictGenericObjectMapper().enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS, new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING, new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).enable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
    public static final ObjectMapper YAML_MAPPER = ObjectMapperFactory.createYaml();
    public static final ObjectMapper YAML_MAPPER_31 = ObjectMapperFactory.createYaml31();

    private OpenApiUtils() {
    }

    public static ObjectMapper getJsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper getJsonMapper31() {
        return JSON_MAPPER_31;
    }

    public static ObjectMapper getConvertJsonMapper() {
        return CONVERT_JSON_MAPPER;
    }

    public static ObjectMapper getYamlMapper() {
        return YAML_MAPPER;
    }

    public static ObjectMapper getYamlMapper31() {
        return YAML_MAPPER_31;
    }
}

