/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.JavaMicronautClientOptionsBuilder;
import java.util.Arrays;
import java.util.List;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;

class JavaMicronautClientCodegen
extends AbstractMicronautJavaCodegen<JavaMicronautClientOptionsBuilder> {
    public static final String OPT_CONFIGURE_AUTH = "configureAuth";
    public static final String OPT_CONFIGURE_AUTH_FILTER_PATTERN = "configureAuthFilterPattern";
    public static final String OPT_CONFIGURE_CLIENT_ID = "configureClientId";
    public static final String ADDITIONAL_CLIENT_TYPE_ANNOTATIONS = "additionalClientTypeAnnotations";
    public static final String AUTHORIZATION_FILTER_PATTERN = "authorizationFilterPattern";
    public static final String BASE_PATH_SEPARATOR = "basePathSeparator";
    public static final String CLIENT_ID = "clientId";
    public static final String NAME = "java-micronaut-client";
    protected boolean configureAuthorization;
    protected List<String> additionalClientTypeAnnotations;
    protected String authorizationFilterPattern;
    protected String basePathSeparator = "-";
    protected String clientId;

    public JavaMicronautClientCodegen() {
        this.title = "OpenAPI Micronaut Client";
        this.configureAuthorization = false;
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.additionalProperties.put("client", "true");
        this.cliOptions.add(CliOption.newBoolean((String)OPT_CONFIGURE_AUTH, (String)"Configure all the authorization methods as specified in the file", (boolean)this.configureAuthorization));
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_CLIENT_TYPE_ANNOTATIONS, (String)"Additional annotations for client type(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newString((String)AUTHORIZATION_FILTER_PATTERN, (String)"Configure the authorization filter pattern for the client. Generally defined when generating clients from multiple specification files"));
        this.cliOptions.add(CliOption.newString((String)BASE_PATH_SEPARATOR, (String)"Configure the separator to use between the application name and base path when referencing the property").defaultValue(this.basePathSeparator));
        this.cliOptions.add(CliOption.newString((String)CLIENT_ID, (String)"Configure the service ID for the Client"));
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a Java Micronaut Client.";
    }

    public boolean isConfigureAuthorization() {
        return this.configureAuthorization;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_CONFIGURE_AUTH)) {
            this.configureAuthorization = this.convertPropertyToBoolean(OPT_CONFIGURE_AUTH);
        }
        this.writePropertyBack(OPT_CONFIGURE_AUTH, this.configureAuthorization);
        this.writePropertyBack("useAuth", true);
        this.writePropertyBack(OPT_CONFIGURE_AUTH_FILTER_PATTERN, false);
        this.writePropertyBack(OPT_CONFIGURE_CLIENT_ID, false);
        if (this.additionalProperties.containsKey(BASE_PATH_SEPARATOR)) {
            this.basePathSeparator = this.additionalProperties.get(BASE_PATH_SEPARATOR).toString();
        }
        this.writePropertyBack(BASE_PATH_SEPARATOR, this.basePathSeparator);
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        if (this.configureAuthorization) {
            String authFolder = invokerFolder + "/auth";
            this.supportingFiles.add(new SupportingFile("client/auth/Authorization.mustache", authFolder, "Authorization.java"));
            this.supportingFiles.add(new SupportingFile("client/auth/AuthorizationBinder.mustache", authFolder, "AuthorizationBinder.java"));
            this.supportingFiles.add(new SupportingFile("client/auth/Authorizations.mustache", authFolder, "Authorizations.java"));
            this.supportingFiles.add(new SupportingFile("client/auth/AuthorizationFilter.mustache", authFolder, "AuthorizationFilter.java"));
            String authConfigurationFolder = authFolder + "/configuration";
            this.supportingFiles.add(new SupportingFile("client/auth/configuration/ApiKeyAuthConfiguration.mustache", authConfigurationFolder, "ApiKeyAuthConfiguration.java"));
            this.supportingFiles.add(new SupportingFile("client/auth/configuration/ConfigurableAuthorization.mustache", authConfigurationFolder, "ConfigurableAuthorization.java"));
            this.supportingFiles.add(new SupportingFile("client/auth/configuration/HttpBasicAuthConfiguration.mustache", authConfigurationFolder, "HttpBasicAuthConfiguration.java"));
            if (this.additionalProperties.containsKey(AUTHORIZATION_FILTER_PATTERN)) {
                String pattern = this.additionalProperties.get(AUTHORIZATION_FILTER_PATTERN).toString();
                this.setAuthorizationFilterPattern(pattern);
                this.additionalProperties.put(AUTHORIZATION_FILTER_PATTERN, this.authorizationFilterPattern);
            }
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS)) {
            String additionalClientAnnotationsList = this.additionalProperties.get(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS).toString();
            this.setAdditionalClientTypeAnnotations(Arrays.asList(additionalClientAnnotationsList.trim().split("\\s*(;|\\r?\\n)\\s*")));
            this.additionalProperties.put(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS, this.additionalClientTypeAnnotations);
        }
        if (this.additionalProperties.containsKey(CLIENT_ID)) {
            String id = this.additionalProperties.get(CLIENT_ID).toString();
            this.setClientId(id);
            this.additionalProperties.put(CLIENT_ID, this.clientId);
        }
        if (this.additionalProperties.containsKey(BASE_PATH_SEPARATOR)) {
            String separator = this.additionalProperties.get(BASE_PATH_SEPARATOR).toString();
            this.setBasePathSeparator(separator);
            this.additionalProperties.put(BASE_PATH_SEPARATOR, this.basePathSeparator);
        }
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("client/api.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        if (this.testTool.equals("junit")) {
            this.apiTestTemplateFiles.put("client/test/api_test.mustache", ".java");
        } else if (this.testTool.equals("spock")) {
            this.apiTestTemplateFiles.put("client/test/api_test.groovy.mustache", ".groovy");
        }
        this.supportingFiles.add(new SupportingFile("client/doc/README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("client/doc/auth.mustache", this.apiDocPath, "auth.md"));
        this.apiDocTemplateFiles.clear();
        this.apiDocTemplateFiles.put("client/doc/api_doc.mustache", ".md");
    }

    public void setAdditionalClientTypeAnnotations(List<String> additionalClientTypeAnnotations) {
        this.additionalClientTypeAnnotations = additionalClientTypeAnnotations;
    }

    public void setAuthorizationFilterPattern(String pattern) {
        this.writePropertyBack(OPT_CONFIGURE_AUTH_FILTER_PATTERN, true);
        this.authorizationFilterPattern = pattern;
    }

    public void setClientId(String id) {
        this.writePropertyBack(OPT_CONFIGURE_CLIENT_ID, true);
        this.clientId = id;
    }

    public void setBasePathSeparator(String separator) {
        this.basePathSeparator = separator;
    }

    public void setConfigureAuthorization(boolean configureAuthorization) {
        this.configureAuthorization = configureAuthorization;
    }

    @Override
    public JavaMicronautClientOptionsBuilder optionsBuilder() {
        return new DefaultClientOptionsBuilder();
    }

    static class DefaultClientOptionsBuilder
    implements JavaMicronautClientOptionsBuilder {
        private List<String> additionalClientTypeAnnotations;
        private String authorizationFilterPattern;
        private String basePathSeparator;
        private String clientId;
        private boolean useAuth;

        DefaultClientOptionsBuilder() {
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthorization(boolean useAuth) {
            this.useAuth = useAuth;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthorizationFilterPattern(String authorizationFilterPattern) {
            this.authorizationFilterPattern = authorizationFilterPattern;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAdditionalClientTypeAnnotations(List<String> additionalClientTypeAnnotations) {
            this.additionalClientTypeAnnotations = additionalClientTypeAnnotations;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withBasePathSeparator(String basePathSeparator) {
            this.basePathSeparator = basePathSeparator;
            return this;
        }

        ClientOptions build() {
            return new ClientOptions(this.additionalClientTypeAnnotations, this.authorizationFilterPattern, this.basePathSeparator, this.clientId, this.useAuth);
        }
    }

    record ClientOptions(List<String> additionalClientTypeAnnotations, String authorizationFilterPattern, String basePathSeparator, String clientId, boolean useAuth) {
    }
}

