/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerOptionsBuilder;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;

class JavaMicronautServerCodegen
extends AbstractMicronautJavaCodegen<JavaMicronautServerOptionsBuilder> {
    public static final String OPT_CONTROLLER_PACKAGE = "controllerPackage";
    public static final String OPT_GENERATE_CONTROLLER_FROM_EXAMPLES = "generateControllerFromExamples";
    public static final String OPT_GENERATE_IMPLEMENTATION_FILES = "generateImplementationFiles";
    public static final String OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED = "generateOperationsToReturnNotImplemented";
    public static final String EXTENSION_ROLES = "x-roles";
    public static final String ANONYMOUS_ROLE_KEY = "isAnonymous()";
    public static final String ANONYMOUS_ROLE = "SecurityRule.IS_ANONYMOUS";
    public static final String AUTHORIZED_ROLE_KEY = "isAuthorized()";
    public static final String AUTHORIZED_ROLE = "SecurityRule.IS_AUTHENTICATED";
    public static final String DENY_ALL_ROLE_KEY = "denyAll()";
    public static final String DENY_ALL_ROLE = "SecurityRule.DENY_ALL";
    public static final String NAME = "java-micronaut-server";
    protected static final String CONTROLLER_PREFIX = "";
    protected static final String CONTROLLER_SUFFIX = "Controller";
    protected static final String API_PREFIX = "";
    protected static final String API_SUFFIX = "Api";
    protected String apiPackage = "org.openapitools.api";
    protected String controllerPackage = "org.openapitools.controller";
    protected boolean generateImplementationFiles = true;
    protected boolean generateOperationsToReturnNotImplemented = true;
    protected boolean generateControllerFromExamples = false;
    protected boolean useAuth = true;

    public JavaMicronautServerCodegen() {
        this.title = "OpenAPI Micronaut Server";
        this.apiPackage = "org.openapitools.api";
        this.apiDocPath = "docs/controllers";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.additionalProperties.put("server", "true");
        this.cliOptions.add(new CliOption(OPT_CONTROLLER_PACKAGE, "The package in which api implementations (controllers) will be generated.").defaultValue(this.apiPackage));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, (String)"Generate the implementation of controller and tests from parameter and return examples that will verify that the api works as desired (for testing).", (boolean)this.generateControllerFromExamples));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_IMPLEMENTATION_FILES, (String)"Whether to generate controller implementations that need to be filled in.", (boolean)this.generateImplementationFiles));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, (String)"Return HTTP 501 Not Implemented instead of an empty response in the generated controller methods.", (boolean)this.generateOperationsToReturnNotImplemented));
        this.cliOptions.add(CliOption.newBoolean((String)"useAuth", (String)"Whether to import authorization and to annotate controller methods accordingly", (boolean)this.useAuth));
        this.typeMapping.put("file", "CompletedFileUpload");
        this.importMapping.put("CompletedFileUpload", "io.micronaut.http.multipart.CompletedFileUpload");
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a Java Micronaut Server.";
    }

    public void setControllerPackage(String controllerPackage) {
        this.controllerPackage = controllerPackage;
    }

    public void setGenerateImplementationFiles(boolean generateImplementationFiles) {
        this.generateImplementationFiles = generateImplementationFiles;
    }

    public void setGenerateOperationsToReturnNotImplemented(boolean generateOperationsToReturnNotImplemented) {
        this.generateOperationsToReturnNotImplemented = generateOperationsToReturnNotImplemented;
    }

    public void setGenerateControllerFromExamples(boolean generateControllerFromExamples) {
        this.generateControllerFromExamples = generateControllerFromExamples;
    }

    public void setUseAuth(boolean useAuth) {
        this.useAuth = useAuth;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_GENERATE_IMPLEMENTATION_FILES)) {
            this.generateImplementationFiles = this.convertPropertyToBoolean(OPT_GENERATE_IMPLEMENTATION_FILES);
        }
        this.writePropertyBack(OPT_GENERATE_IMPLEMENTATION_FILES, this.generateImplementationFiles);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED)) {
            this.generateOperationsToReturnNotImplemented = this.convertPropertyToBoolean(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, this.generateOperationsToReturnNotImplemented);
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = (String)this.additionalProperties.get("apiPackage");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage);
        if (this.additionalProperties.containsKey(OPT_CONTROLLER_PACKAGE)) {
            this.controllerPackage = (String)this.additionalProperties.get(OPT_CONTROLLER_PACKAGE);
        }
        this.additionalProperties.put(OPT_CONTROLLER_PACKAGE, this.controllerPackage);
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES)) {
            this.generateControllerFromExamples = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, this.generateControllerFromExamples);
        if (this.additionalProperties.containsKey("useAuth")) {
            this.useAuth = this.convertPropertyToBoolean("useAuth");
        }
        this.writePropertyBack("useAuth", this.useAuth);
        this.apiTemplateFiles.clear();
        this.setApiNamePrefix("");
        this.setApiNameSuffix(API_SUFFIX);
        this.apiTemplateFiles.put("server/controller-interface.mustache", ".java");
        this.supportingFiles.add(new SupportingFile("server/doc/README.mustache", "", "README.md").doNotOverwrite());
        this.apiDocTemplateFiles.clear();
        this.apiDocTemplateFiles.put("server/doc/controller_doc.mustache", ".md");
        this.apiTestTemplateFiles.clear();
        if (this.generateImplementationFiles) {
            this.apiTestTemplateFiles.put("server/controller-implementation.mustache", ".java");
            if (this.testTool.equals("junit")) {
                this.apiTestTemplateFiles.put("server/test/controller_test.mustache", ".java");
            } else if (this.testTool.equals("spock")) {
                this.apiTestTemplateFiles.put("server/test/controller_test.groovy.mustache", ".groovy");
            }
        }
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace('.', '/');
        this.supportingFiles.add(new SupportingFile("common/configuration/Application.mustache", invokerFolder, "Application.java").doNotOverwrite());
    }

    @Override
    public String apiTestFileFolder() {
        return super.getOutputDir();
    }

    public String apiTestFilename(String templateName, String tag) {
        String controllerName = StringUtils.camelize((String)("_" + tag + "_Controller"));
        if (this.generateImplementationFiles && templateName.contains("controller-implementation")) {
            String implementationFolder = this.outputFolder + File.separator + this.sourceFolder + File.separator + this.controllerPackage.replace('.', File.separatorChar);
            return (implementationFolder + File.separator + controllerName + ".java").replace('/', File.separatorChar);
        }
        String suffix = (String)this.apiTestTemplateFiles().get(templateName);
        return super.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        super.setParameterExampleValue(p);
        if (p.isFile) {
            p.example = "null";
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        String controllerClassname = StringUtils.camelize((String)("_" + operations.getPathPrefix() + "_Controller"));
        objs.put((Object)"controllerClassname", (Object)controllerClassname);
        List allOperations = (List)operations.get((Object)"operation");
        if (this.useAuth) {
            for (CodegenOperation operation : allOperations) {
                if (!operation.vendorExtensions.containsKey(EXTENSION_ROLES)) {
                    String role2 = operation.hasAuthMethods ? AUTHORIZED_ROLE : ANONYMOUS_ROLE;
                    operation.vendorExtensions.put(EXTENSION_ROLES, Collections.singletonList(role2));
                    continue;
                }
                List roles = (List)operation.vendorExtensions.get(EXTENSION_ROLES);
                roles = roles.stream().map(role -> {
                    switch (role) {
                        case "isAnonymous()": {
                            return ANONYMOUS_ROLE;
                        }
                        case "isAuthorized()": {
                            return AUTHORIZED_ROLE;
                        }
                        case "denyAll()": {
                            return DENY_ALL_ROLE;
                        }
                    }
                    return "\"" + this.escapeText((String)role) + "\"";
                }).collect(Collectors.toList());
                operation.vendorExtensions.put(EXTENSION_ROLES, roles);
            }
        }
        return objs;
    }

    @Override
    public JavaMicronautServerOptionsBuilder optionsBuilder() {
        return new DefaultServerOptionsBuilder();
    }

    static class DefaultServerOptionsBuilder
    implements JavaMicronautServerOptionsBuilder {
        private String controllerPackage;
        private boolean generateAbstractClasses;
        private boolean generateControllerFromExamples;
        private boolean generateOperationsToReturnNotImplemented = true;
        private boolean useAuth = true;

        DefaultServerOptionsBuilder() {
        }

        @Override
        public JavaMicronautServerOptionsBuilder withControllerPackage(String controllerPackage) {
            this.controllerPackage = controllerPackage;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateAbstractClasses(boolean abstractClasses) {
            this.generateAbstractClasses = abstractClasses;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateOperationsToReturnNotImplemented(boolean generateOperationsToReturnNotImplemented) {
            this.generateOperationsToReturnNotImplemented = generateOperationsToReturnNotImplemented;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateControllerFromExamples(boolean generateControllerFromExamples) {
            this.generateControllerFromExamples = generateControllerFromExamples;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withAuthentication(boolean useAuth) {
            this.useAuth = useAuth;
            return this;
        }

        ServerOptions build() {
            return new ServerOptions(this.controllerPackage, this.generateAbstractClasses, this.generateOperationsToReturnNotImplemented, this.generateControllerFromExamples, this.useAuth);
        }
    }

    record ServerOptions(String controllerPackage, boolean generateAbstractClasses, boolean generateOperationsToReturnNotImplemented, boolean generateControllerFromExamples, boolean useAuth) {
    }
}

