/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautClientCodegen;
import io.micronaut.openapi.generator.JavaMicronautClientOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautServerCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerOptionsBuilder;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import io.micronaut.openapi.generator.MicronautCodeGeneratorOptionsBuilder;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.DefaultGenerator;

public final class MicronautCodeGeneratorEntryPoint {
    private final URI definitionFile;
    private final File outputDirectory;
    private final AbstractMicronautJavaCodegen<?> codeGenerator;
    private final EnumSet<OutputKind> outputs;
    private final Options options;
    private final JavaMicronautServerCodegen.ServerOptions serverOptions;
    private final JavaMicronautClientCodegen.ClientOptions clientOptions;

    private MicronautCodeGeneratorEntryPoint(URI definitionFile, File outputDirectory, AbstractMicronautJavaCodegen<?> codeGenerator, EnumSet<OutputKind> outputs, Options options, JavaMicronautServerCodegen.ServerOptions serverOptions, JavaMicronautClientCodegen.ClientOptions clientOptions) {
        this.definitionFile = definitionFile;
        this.outputDirectory = outputDirectory;
        this.codeGenerator = codeGenerator;
        this.outputs = outputs;
        this.options = options;
        this.serverOptions = serverOptions;
        this.clientOptions = clientOptions;
    }

    private static void withPath(File file, Consumer<? super String> action) {
        if (file == null) {
            return;
        }
        try {
            String path = file.getCanonicalPath();
            action.accept(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generate() {
        OpenAPI openAPI = new OpenAPIParser().readLocation(this.definitionFile.toString(), null, new ParseOptions()).getOpenAPI();
        MicronautCodeGeneratorEntryPoint.withPath(this.outputDirectory, arg_0 -> this.codeGenerator.setOutputDir(arg_0));
        this.codeGenerator.setHideGenerationTimestamp(true);
        this.configureOptions();
        ClientOptInput input = new ClientOptInput();
        input.openAPI(openAPI);
        input.config(this.codeGenerator);
        DefaultGenerator generator = new DefaultGenerator();
        for (OutputKind outputKind : OutputKind.values()) {
            generator.setGeneratorPropertyDefault(outputKind.generatorProperty, "false");
        }
        for (OutputKind outputKind : this.outputs) {
            generator.setGeneratorPropertyDefault(outputKind.generatorProperty, "true");
        }
        generator.opts(input).generate();
    }

    private void configureOptions() {
        if (this.options == null) {
            return;
        }
        if (this.options.modelPackage != null) {
            this.codeGenerator.setModelPackage(this.options.modelPackage);
        }
        if (this.options.apiPackage != null) {
            this.codeGenerator.setApiPackage(this.options.apiPackage);
        }
        if (this.options.invokerPackage != null) {
            this.codeGenerator.setInvokerPackage(this.options.invokerPackage);
        }
        if (this.options.artifactId != null) {
            this.codeGenerator.setArtifactId(this.options.artifactId);
        }
        this.codeGenerator.setReactive(this.options.reactive);
        this.codeGenerator.setWrapInHttpResponse(this.options.wrapInHttpResponse);
        this.codeGenerator.setUseOptional(this.options.optional);
        this.codeGenerator.setUseBeanValidation(this.options.beanValidation);
        this.codeGenerator.setTestTool(this.options.testFramework.value);
        this.codeGenerator.setSerializationLibrary(this.options.serializationLibraryKind().name());
        this.configureServerOptions();
        this.configureClientOptions();
    }

    private void configureServerOptions() {
        AbstractMicronautJavaCodegen<?> abstractMicronautJavaCodegen;
        if (this.serverOptions != null && (abstractMicronautJavaCodegen = this.codeGenerator) instanceof JavaMicronautServerCodegen) {
            JavaMicronautServerCodegen serverCodegen = (JavaMicronautServerCodegen)abstractMicronautJavaCodegen;
            if (this.serverOptions.controllerPackage() != null) {
                serverCodegen.setControllerPackage(this.serverOptions.controllerPackage());
            }
            serverCodegen.setGenerateImplementationFiles(this.serverOptions.generateAbstractClasses());
            serverCodegen.setGenerateOperationsToReturnNotImplemented(this.serverOptions.generateOperationsToReturnNotImplemented());
            serverCodegen.setGenerateControllerFromExamples(this.serverOptions.generateControllerFromExamples());
            serverCodegen.setUseAuth(serverCodegen.useAuth);
        }
    }

    public void configureClientOptions() {
        AbstractMicronautJavaCodegen<?> abstractMicronautJavaCodegen;
        if (this.clientOptions != null && (abstractMicronautJavaCodegen = this.codeGenerator) instanceof JavaMicronautClientCodegen) {
            JavaMicronautClientCodegen clientCodegen = (JavaMicronautClientCodegen)abstractMicronautJavaCodegen;
            if (this.clientOptions.additionalClientTypeAnnotations() != null) {
                clientCodegen.setAdditionalClientTypeAnnotations(this.clientOptions.additionalClientTypeAnnotations());
            }
            if (this.clientOptions.clientId() != null) {
                clientCodegen.setClientId(clientCodegen.clientId);
            }
            if (this.clientOptions.authorizationFilterPattern() != null) {
                clientCodegen.setAuthorizationFilterPattern(clientCodegen.authorizationFilterPattern);
            }
            if (this.clientOptions.basePathSeparator() != null) {
                clientCodegen.setBasePathSeparator(clientCodegen.basePathSeparator);
            }
            clientCodegen.setConfigureAuthorization(this.clientOptions.useAuth());
        }
    }

    public static MicronautCodeGeneratorBuilder builder() {
        return new DefaultBuilder();
    }

    private record Options(String apiPackage, String modelPackage, String invokerPackage, String artifactId, boolean beanValidation, boolean optional, boolean reactive, boolean wrapInHttpResponse, TestFramework testFramework, SerializationLibraryKind serializationLibraryKind) {
    }

    public static enum OutputKind {
        MODELS("models", DefaultBuilder.HAS_OUTPUT),
        MODEL_TESTS("modelTests", DefaultBuilder.HAS_OUTPUT),
        MODEL_DOCS("modelDocs", DefaultBuilder.HAS_OUTPUT),
        APIS("apis", DefaultBuilder.HAS_OUTPUT),
        API_TESTS("apiTests", DefaultBuilder.HAS_OUTPUT),
        API_DOCS("apiDocs", DefaultBuilder.HAS_OUTPUT),
        SUPPORTING_FILES("supportingFiles", DefaultBuilder.HAS_OUTPUT);

        private final String generatorProperty;
        private final Consumer<DefaultBuilder> validationAction;

        private OutputKind(String generatorProperty, Consumer<DefaultBuilder> validationAction) {
            this.generatorProperty = generatorProperty;
            this.validationAction = validationAction;
        }

        public static OutputKind of(String name) {
            for (OutputKind kind : OutputKind.values()) {
                if (!kind.name().equals(name) && !kind.generatorProperty.equals(name)) continue;
                return kind;
            }
            throw new IllegalArgumentException("Unknown output kind '" + name + "'");
        }
    }

    public static enum TestFramework {
        JUNIT5("junit"),
        SPOCK("spock");

        private final String value;

        private TestFramework(String value) {
            this.value = value;
        }
    }

    private static class DefaultBuilder
    implements MicronautCodeGeneratorBuilder {
        private static final Consumer<DefaultBuilder> HAS_OUTPUT = b -> Objects.requireNonNull(b.outputDirectory, "Sources directory must not be null");
        private Options options;
        private AbstractMicronautJavaCodegen<?> codeGenerator;
        private URI definitionFile;
        private File outputDirectory;
        private final EnumSet<OutputKind> outputs = EnumSet.noneOf(OutputKind.class);
        private JavaMicronautServerCodegen.ServerOptions serverOptions;
        private JavaMicronautClientCodegen.ClientOptions clientOptions;

        private DefaultBuilder() {
        }

        @Override
        public <B extends GeneratorOptionsBuilder, G extends MicronautCodeGenerator<B>> MicronautCodeGeneratorBuilder forCodeGenerator(G generator, Consumer<? super B> configuration) {
            this.codeGenerator = (AbstractMicronautJavaCodegen)generator;
            B builder = generator.optionsBuilder();
            configuration.accept(builder);
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forClient(Consumer<? super JavaMicronautClientOptionsBuilder> clientOptionsSpec) {
            this.codeGenerator = new JavaMicronautClientCodegen();
            JavaMicronautClientCodegen.DefaultClientOptionsBuilder clientOptionsBuilder = new JavaMicronautClientCodegen.DefaultClientOptionsBuilder();
            clientOptionsSpec.accept(clientOptionsBuilder);
            this.clientOptions = clientOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forServer(Consumer<? super JavaMicronautServerOptionsBuilder> serverOptionsSpec) {
            this.codeGenerator = new JavaMicronautServerCodegen();
            JavaMicronautServerCodegen.DefaultServerOptionsBuilder serverOptionsBuilder = new JavaMicronautServerCodegen.DefaultServerOptionsBuilder();
            serverOptionsSpec.accept(serverOptionsBuilder);
            this.serverOptions = serverOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withDefinitionFile(URI definitionFile) {
            this.definitionFile = definitionFile;
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOutputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOutputs(OutputKind ... elements) {
            this.outputs.addAll(Arrays.asList(elements));
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOptions(Consumer<? super MicronautCodeGeneratorOptionsBuilder> optionsConfigurer) {
            DefaultOptionsBuilder builder = new DefaultOptionsBuilder();
            optionsConfigurer.accept(builder);
            this.options = builder.build();
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.definitionFile, "OpenAPI definition file must not be null");
            Objects.requireNonNull(this.codeGenerator, "You must select either server or client generation");
            for (OutputKind output : this.outputs) {
                output.validationAction.accept(this);
            }
        }

        @Override
        public MicronautCodeGeneratorEntryPoint build() {
            this.validate();
            return new MicronautCodeGeneratorEntryPoint(this.definitionFile, this.outputDirectory, this.codeGenerator, this.outputs, this.options, this.serverOptions, this.clientOptions);
        }

        private static class DefaultOptionsBuilder
        implements MicronautCodeGeneratorOptionsBuilder {
            private String apiPackage;
            private String artifactId;
            private boolean beanValidation = true;
            private String invokerPackage;
            private String modelPackage;
            private boolean optional = false;
            private boolean reactive = true;
            private boolean wrapInHttpResponse;
            private TestFramework testFramework = TestFramework.JUNIT5;
            private SerializationLibraryKind serializationLibraryKind = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON;

            private DefaultOptionsBuilder() {
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withApiPackage(String apiPackage) {
                this.apiPackage = apiPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withInvokerPackage(String invokerPackage) {
                this.invokerPackage = invokerPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withModelPackage(String modelPackage) {
                this.modelPackage = modelPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withArtifactId(String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withReactive(boolean reactive) {
                this.reactive = reactive;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withWrapInHttpResponse(boolean wrapInHttpResponse) {
                this.wrapInHttpResponse = wrapInHttpResponse;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withBeanValidation(boolean beanValidation) {
                this.beanValidation = beanValidation;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withOptional(boolean optional) {
                this.optional = optional;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withTestFramework(TestFramework testFramework) {
                this.testFramework = testFramework;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSerializationLibrary(SerializationLibraryKind library) {
                this.serializationLibraryKind = library;
                return this;
            }

            private Options build() {
                return new Options(this.apiPackage, this.modelPackage, this.invokerPackage, this.artifactId, this.beanValidation, this.optional, this.reactive, this.wrapInHttpResponse, this.testFramework, this.serializationLibraryKind);
            }
        }
    }
}

