/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicronautInlineModelResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicronautInlineModelResolver.class);
    private static final ObjectMapper STRUCTURE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).build();
    private OpenAPI openAPI;
    private Map<String, Schema> addedModels = new HashMap<String, Schema>();
    private Map<String, String> generatedSignature = new HashMap<String, String>();
    private Map<String, String> inlineSchemaNameMapping = new HashMap<String, String>();
    private Map<String, String> inlineSchemaOptions = new HashMap<String, String>();
    private Set<String> inlineSchemaNameMappingValues = new HashSet<String>();
    private boolean resolveInlineEnums = true;
    private boolean skipSchemaReuse = false;
    private Boolean refactorAllOfInlineSchemas;
    private Set<String> uniqueNames = new HashSet<String>();

    public MicronautInlineModelResolver(OpenAPI openAPI) {
        this.openAPI = openAPI;
        this.inlineSchemaOptions.put("ARRAY_ITEM_SUFFIX", "_inner");
        this.inlineSchemaOptions.put("MAP_ITEM_SUFFIX", "_value");
    }

    public void setInlineSchemaNameMapping(Map inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping = inlineSchemaNameMapping;
        this.inlineSchemaNameMappingValues = new HashSet(inlineSchemaNameMapping.values());
    }

    public void setInlineSchemaOptions(Map inlineSchemaOptions) {
        this.inlineSchemaOptions.putAll(inlineSchemaOptions);
        if ("true".equalsIgnoreCase(this.inlineSchemaOptions.getOrDefault("SKIP_SCHEMA_REUSE", "false"))) {
            this.skipSchemaReuse = true;
        }
        if (this.inlineSchemaOptions.containsKey("REFACTOR_ALLOF_INLINE_SCHEMAS")) {
            this.refactorAllOfInlineSchemas = Boolean.valueOf(this.inlineSchemaOptions.get("REFACTOR_ALLOF_INLINE_SCHEMAS"));
        }
        if (this.inlineSchemaOptions.containsKey("RESOLVE_INLINE_ENUMS")) {
            this.resolveInlineEnums = Boolean.parseBoolean(this.inlineSchemaOptions.get("RESOLVE_INLINE_ENUMS"));
        }
    }

    public void flatten() {
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new HashMap());
        }
        this.flattenPaths();
        this.flattenComponents();
    }

    public void flattenPaths() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            Operation operation;
            PathItem path = (PathItem)pathsEntry.getValue();
            if (path.get$ref() != null) {
                path = (PathItem)this.openAPI.getComponents().getPathItems().get(path.get$ref().substring("#/components/pathItems/".length()));
            }
            LinkedHashMap operationsMap = new LinkedHashMap(path.readOperationsMap());
            String pathname = (String)pathsEntry.getKey();
            for (Map.Entry operationEntry : new LinkedHashMap(path.readOperationsMap()).entrySet()) {
                operation = (Operation)operationEntry.getValue();
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                for (Map.Entry callbackEntry : callbacks.entrySet()) {
                    Callback callback = (Callback)callbackEntry.getValue();
                    for (Map.Entry pathItemEntry : callback.entrySet()) {
                        PathItem pathItem = (PathItem)pathItemEntry.getValue();
                        operationsMap.putAll(pathItem.readOperationsMap());
                    }
                }
            }
            for (Map.Entry operationEntry : operationsMap.entrySet()) {
                operation = (Operation)operationEntry.getValue();
                String inlineSchemaName = this.getInlineSchemaName((PathItem.HttpMethod)operationEntry.getKey(), pathname);
                this.flattenPathItemParameters(inlineSchemaName, operation, path);
                this.flattenParameters(inlineSchemaName, operation);
                this.flattenRequestBody(inlineSchemaName, operation);
                this.flattenResponses(inlineSchemaName, operation);
            }
        }
    }

    private void flattenResponses(String modelName, Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        for (Map.Entry responsesEntry : responses.entrySet()) {
            String key = (String)responsesEntry.getKey();
            ApiResponse response = (ApiResponse)responsesEntry.getValue();
            if (response.get$ref() != null) {
                response = (ApiResponse)this.openAPI.getComponents().getResponses().get(response.get$ref().substring("#/components/responses/".length()));
            }
            this.flattenContent(response.getContent(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + key + "_response");
        }
    }

    private void flattenRequestBody(String modelName, Operation operation) {
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            return;
        }
        if (requestBody.get$ref() != null) {
            String ref = ModelUtils.getSimpleRef((String)requestBody.get$ref());
            requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(ref);
            if (requestBody == null) {
                return;
            }
        }
        this.flattenContent(requestBody.getContent(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_request");
    }

    private void flattenContent(Content content, String name) {
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String contentType : content.keySet()) {
            Schema schema;
            MediaType mediaType = (MediaType)content.get((Object)contentType);
            if (mediaType == null || (schema = mediaType.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(schema.getTitle(), name);
            this.gatherInlineModels(schema, schemaName);
            if (this.isModelNeeded(schema)) {
                mediaType.setSchema(this.makeSchemaInComponents(schemaName, schema));
            }
            if (schema.getItems() == null || schema.getItems().get$ref() != null) continue;
            String itemsSchemaName = this.resolveModelName(schema.getTitle(), name);
            this.gatherInlineModels(schema, itemsSchemaName);
            if (!this.isModelNeeded(schema)) continue;
            schema.setItems(this.makeSchemaInComponents(itemsSchemaName, schema));
        }
    }

    private void flattenParameters(String modelName, Operation operation) {
        List parameters = operation.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            Schema parameterItemsSchema;
            Schema parameterSchema = parameter.getSchema();
            if (parameterSchema == null && parameter.get$ref() == null) continue;
            if (parameter.get$ref() != null && this.openAPI.getComponents().getParameters() != null) {
                parameter = (Parameter)this.openAPI.getComponents().getParameters().get(parameter.get$ref().substring("#/components/parameters/".length()));
            }
            if ((parameterSchema = parameter.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(parameterSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterSchema, schemaName);
            if (this.isModelNeeded(parameterSchema)) {
                parameter.setSchema(this.makeSchemaInComponents(schemaName, parameterSchema));
            }
            if ((parameterItemsSchema = parameterSchema.getItems()) == null || parameterItemsSchema.get$ref() != null) continue;
            String itemsSchemaName = this.resolveModelName(parameterItemsSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterItemsSchema, itemsSchemaName);
            if (!this.isModelNeeded(parameterItemsSchema)) continue;
            parameterItemsSchema.setItems(this.makeSchemaInComponents(itemsSchemaName, parameterItemsSchema));
        }
    }

    private void flattenPathItemParameters(String modelName, Operation operation, PathItem pathItem) {
        ArrayList parameters = new ArrayList();
        if (pathItem.getParameters() != null) {
            parameters.addAll(pathItem.getParameters());
        }
        if (parameters.isEmpty()) {
            return;
        }
        for (Parameter parameter : parameters) {
            Schema parameterItemsSchema;
            if (parameter.getSchema() == null && parameter.get$ref() == null) continue;
            Schema parameterSchema = null;
            if (parameter.get$ref() != null) {
                if (this.openAPI.getComponents().getParameters() != null) {
                    Parameter param = (Parameter)this.openAPI.getComponents().getParameters().get(parameter.get$ref().substring("#/components/parameters/".length()));
                    parameterSchema = param.getSchema();
                }
            } else {
                parameterSchema = parameter.getSchema();
            }
            if (parameterSchema == null) continue;
            String schemaName = this.resolveModelName(parameterSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterSchema, schemaName);
            if (this.isModelNeeded(parameterSchema)) {
                Schema refSchema = this.makeSchemaInComponents(schemaName, parameterSchema);
                parameter.setSchema(refSchema);
            }
            if ((parameterItemsSchema = parameterSchema.getItems()) == null || parameterItemsSchema.get$ref() != null) continue;
            String itemsSchemaName = this.resolveModelName(parameterItemsSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterItemsSchema, itemsSchemaName);
            if (!this.isModelNeeded(parameterItemsSchema)) continue;
            parameterSchema.setItems(this.makeSchemaInComponents(itemsSchemaName, parameterItemsSchema));
        }
    }

    private void gatherInlineModels(Schema schema, String modelPrefix) {
        Schema not;
        Schema refSchema;
        Schema refSchema2;
        Object schemaName;
        Schema refSchema3;
        String schemaName2;
        if (schema.get$ref() != null) {
            if (this.isModelNeeded(schema) || "object".equals(schema.getType()) || schema.getProperties() != null || schema.getAdditionalProperties() != null || ModelUtils.isComposedSchema((Schema)schema)) {
                LOGGER.error("Illegal schema found with $ref combined with other properties, no properties should be defined alongside a $ref:\n {}", (Object)schema);
            }
            return;
        }
        if (schema.getType() == null || "object".equals(schema.getType())) {
            Object propName2;
            Map props = schema.getProperties();
            if (props != null) {
                for (Object propName2 : props.keySet()) {
                    Schema prop = (Schema)props.get(propName2);
                    if (prop == null) continue;
                    schemaName2 = this.resolveModelName(prop.getTitle(), modelPrefix + "_" + (String)propName2);
                    this.gatherInlineModels(prop, schemaName2);
                    if (this.isModelNeeded(prop)) {
                        refSchema3 = this.makeSchemaInComponents(schemaName2, prop);
                        props.put(propName2, refSchema3);
                        continue;
                    }
                    if (!ModelUtils.isComposedSchema((Schema)prop) || prop.getAllOf() == null || prop.getAllOf().size() != 1 || ((Schema)prop.getAllOf().get(0)).getType() == null || "object".equals(((Schema)prop.getAllOf().get(0)).getType())) continue;
                    LOGGER.info("allOf schema used by the property `{}` replaced by its only item (a type)", propName2);
                    props.put(propName2, (Schema)prop.getAllOf().get(0));
                }
            }
            if (schema.getAdditionalProperties() != null && (propName2 = schema.getAdditionalProperties()) instanceof Schema) {
                Schema inner = (Schema)propName2;
                schemaName = this.resolveModelName(schema.getTitle(), modelPrefix + this.inlineSchemaOptions.get("MAP_ITEM_SUFFIX"));
                this.gatherInlineModels(inner, (String)schemaName);
                if (this.isModelNeeded(inner)) {
                    refSchema2 = this.makeSchemaInComponents((String)schemaName, inner);
                    schema.setAdditionalProperties((Object)refSchema2);
                }
            }
            if (schema.getItems() != null && schema.getItems().get$ref() == null) {
                String schemaName3 = this.resolveModelName(schema.getTitle(), modelPrefix + "Enum");
                this.gatherInlineModels(schema.getItems(), schemaName3);
                if (this.isModelNeeded(schema.getItems())) {
                    refSchema = this.makeSchemaInComponents(schemaName3, schema.getItems());
                    schema.setAdditionalProperties((Object)refSchema);
                }
            }
        } else {
            if (schema.getProperties() != null) {
                LOGGER.error("Illegal schema found with non-object type combined with properties, no properties should be defined:\n {}", (Object)schema);
                return;
            }
            if (schema.getAdditionalProperties() != null) {
                LOGGER.error("Illegal schema found with non-object type combined with additionalProperties, no additionalProperties should be defined:\n {}", (Object)schema);
                return;
            }
        }
        if (schema instanceof ArraySchema) {
            ArraySchema array = (ArraySchema)schema;
            Schema items = array.getItems();
            if (items == null) {
                LOGGER.error("Illegal schema found with array type but no items, items must be defined for array schemas:\n {}", (Object)schema);
                return;
            }
            schemaName = this.resolveModelName(items.getTitle(), modelPrefix + this.inlineSchemaOptions.get("ARRAY_ITEM_SUFFIX"));
            this.gatherInlineModels(items, (String)schemaName);
            if (this.isModelNeeded(items)) {
                refSchema2 = this.makeSchemaInComponents((String)schemaName, items);
                array.setItems(refSchema2);
            }
        }
        if (ModelUtils.isComposedSchema((Schema)schema)) {
            Schema refSchema4;
            String schemaName4;
            if (schema.getAllOf() != null) {
                ArrayList<Schema> newAllOf = new ArrayList<Schema>();
                boolean atLeastOneModel = false;
                for (Object inner : schema.getAllOf()) {
                    if (inner == null) continue;
                    schemaName2 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_allOf");
                    this.gatherInlineModels((Schema)inner, schemaName2);
                    if (this.isModelNeeded((Schema)inner)) {
                        if (Boolean.TRUE.equals(this.refactorAllOfInlineSchemas)) {
                            refSchema3 = this.makeSchemaInComponents(schemaName2, (Schema)inner);
                            newAllOf.add(refSchema3);
                            atLeastOneModel = true;
                            continue;
                        }
                        newAllOf.add((Schema)inner);
                        atLeastOneModel = true;
                        continue;
                    }
                    newAllOf.add((Schema)inner);
                }
                if (atLeastOneModel) {
                    schema.setAllOf(newAllOf);
                } else if (schema.getAllOf().size() > 1) {
                    LOGGER.warn("allOf schema `{}` containing multiple types (not model) is not supported at the moment.", (Object)schema.getName());
                } else if (schema.getAllOf().size() != 1) {
                    LOGGER.error("allOf schema `{}` contains no items.", (Object)schema.getName());
                }
            }
            if (schema.getAnyOf() != null) {
                ArrayList<Schema> newAnyOf = new ArrayList<Schema>();
                for (Object inner : schema.getAnyOf()) {
                    if (inner == null) continue;
                    schemaName4 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_anyOf");
                    this.gatherInlineModels((Schema)inner, schemaName4);
                    if (this.isModelNeeded((Schema)inner)) {
                        refSchema4 = this.makeSchemaInComponents(schemaName4, (Schema)inner);
                        newAnyOf.add(refSchema4);
                        continue;
                    }
                    newAnyOf.add((Schema)inner);
                }
                schema.setAnyOf(newAnyOf);
            }
            if (schema.getOneOf() != null) {
                ArrayList<Schema> newOneOf = new ArrayList<Schema>();
                for (Object inner : schema.getOneOf()) {
                    if (inner == null) continue;
                    schemaName4 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_oneOf");
                    this.gatherInlineModels((Schema)inner, schemaName4);
                    if (this.isModelNeeded((Schema)inner)) {
                        refSchema4 = this.makeSchemaInComponents(schemaName4, (Schema)inner);
                        newOneOf.add(refSchema4);
                        continue;
                    }
                    newOneOf.add((Schema)inner);
                }
                schema.setOneOf(newOneOf);
            }
        }
        if (schema.getNot() != null && (not = schema.getNot()) != null) {
            String schemaName5 = this.resolveModelName(schema.getTitle(), modelPrefix + "_not");
            this.gatherInlineModels(not, schemaName5);
            if (this.isModelNeeded(not)) {
                refSchema = this.makeSchemaInComponents(schemaName5, not);
                schema.setNot(refSchema);
            }
        }
    }

    private String resolveModelName(String title, String key) {
        return title == null ? this.uniqueName(key) : this.uniqueName(title);
    }

    private String getInlineSchemaName(PathItem.HttpMethod httpVerb, String pathname) {
        if (pathname.startsWith("/")) {
            pathname = pathname.substring(1);
        }
        Object name = pathname.replace('/', '_').replaceAll("[{}]", "");
        if (httpVerb == PathItem.HttpMethod.DELETE) {
            name = (String)name + "_delete";
        } else if (httpVerb == PathItem.HttpMethod.GET) {
            name = (String)name + "_get";
        } else if (httpVerb == PathItem.HttpMethod.HEAD) {
            name = (String)name + "_head";
        } else if (httpVerb == PathItem.HttpMethod.OPTIONS) {
            name = (String)name + "_options";
        } else if (httpVerb == PathItem.HttpMethod.PATCH) {
            name = (String)name + "_patch";
        } else if (httpVerb == PathItem.HttpMethod.POST) {
            name = (String)name + "_post";
        } else if (httpVerb == PathItem.HttpMethod.PUT) {
            name = (String)name + "_put";
        } else if (httpVerb == PathItem.HttpMethod.TRACE) {
            name = (String)name + "_trace";
        }
        return name;
    }

    private Schema makeSchemaInComponents(String name, Schema schema) {
        Schema refSchema;
        String existing = this.matchGenerated(schema);
        if (existing != null) {
            refSchema = new Schema().$ref(existing);
        } else {
            if (this.resolveInlineEnums && schema.getEnum() != null && !schema.getEnum().isEmpty()) {
                LOGGER.warn("Model {} promoted to its own schema due to resolveInlineEnums=true", (Object)name);
            }
            name = this.addSchemas(name, schema);
            refSchema = new Schema().$ref(name);
        }
        this.copyVendorExtensions(schema, refSchema);
        return refSchema;
    }

    private void copyVendorExtensions(Schema source, Schema target) {
        Map vendorExtensions = source.getExtensions();
        if (vendorExtensions == null) {
            return;
        }
        for (String extName : vendorExtensions.keySet()) {
            target.addExtension(extName, vendorExtensions.get(extName));
        }
    }

    private String matchGenerated(Schema model) {
        if (this.skipSchemaReuse) {
            return null;
        }
        try {
            String json = STRUCTURE_MAPPER.writeValueAsString((Object)model);
            if (this.generatedSignature.containsKey(json)) {
                return this.generatedSignature.get(json);
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Error: {}", (Object)e.getMessage());
        }
        return null;
    }

    private boolean isModelNeeded(Schema schema) {
        return this.isModelNeeded(schema, new HashSet<Schema>());
    }

    private boolean isModelNeeded(Schema schema, Set<Schema> visitedSchemas) {
        if (visitedSchemas.contains(schema)) {
            return true;
        }
        visitedSchemas.add(schema);
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return true;
        }
        if ((schema.getType() == null || "object".equals(schema.getType())) && schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            return true;
        }
        if (ModelUtils.isComposedSchema((Schema)schema)) {
            boolean isNullable;
            boolean isSingleAllOf = schema.getAllOf() != null && schema.getAllOf().size() == 1;
            boolean isReadOnly = schema.getReadOnly() != null && schema.getReadOnly() != false;
            boolean bl = isNullable = schema.getNullable() != null && schema.getNullable() != false;
            if (isSingleAllOf && (isReadOnly || isNullable)) {
                ComposedSchema c = new ComposedSchema();
                c.setAllOf(schema.getAllOf());
                c.setReadOnly(schema.getReadOnly());
                c.setNullable(schema.getNullable());
                if (schema.equals((Object)c)) {
                    return this.isModelNeeded((Schema)schema.getAllOf().get(0), visitedSchemas);
                }
            } else if (isSingleAllOf && StringUtils.isNotEmpty((CharSequence)((Schema)schema.getAllOf().get(0)).get$ref())) {
                return this.isModelNeeded((Schema)schema.getAllOf().get(0), visitedSchemas);
            }
            if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
                for (Object inner : schema.getAllOf()) {
                    if (!this.isModelNeeded(ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)((Schema)inner)), visitedSchemas)) continue;
                    return true;
                }
                return false;
            }
            if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
                return true;
            }
            return schema.getOneOf() != null && !schema.getOneOf().isEmpty();
        }
        return false;
    }

    private String addSchemas(String name, Schema schema) {
        if (this.inlineSchemaNameMapping.containsKey(name)) {
            name = this.inlineSchemaNameMapping.get(name);
        }
        this.addGenerated(name, schema);
        this.openAPI.getComponents().addSchemas(name, schema);
        if (!name.equals(schema.getTitle()) && !this.inlineSchemaNameMappingValues.contains(name)) {
            LOGGER.info("Inline schema created as {}. To have complete control of the model name, set the `title` field or use the modelNameMapping option (e.g. --model-name-mappings {}=NewModel,ModelA=NewModelA in CLI) or inlineSchemaNameMapping option (--inline-schema-name-mappings {}=NewModel,ModelA=NewModelA in CLI).", new Object[]{name, name, name});
        }
        this.uniqueNames.add(name);
        return name;
    }

    private void addGenerated(String name, Schema model) {
        try {
            String json = STRUCTURE_MAPPER.writeValueAsString((Object)model);
            this.generatedSignature.put(json, name);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error: {}", (Object)e.getMessage());
        }
    }

    private String uniqueName(String name) {
        if (this.openAPI.getComponents().getSchemas() == null) {
            return name;
        }
        Object uniqueName = name;
        int count = 0;
        while (this.openAPI.getComponents().getSchemas().containsKey(uniqueName) || this.uniqueNames.contains(uniqueName)) {
            uniqueName = name + "_" + ++count;
        }
        return uniqueName;
    }

    private void flattenComponents() {
        Map models = this.openAPI.getComponents().getSchemas();
        if (models == null) {
            return;
        }
        ArrayList modelNames = new ArrayList(models.keySet());
        for (String modelName : modelNames) {
            Schema model = (Schema)models.get(modelName);
            if (model == null) continue;
            if (ModelUtils.isAnyOf((Schema)model)) {
                this.gatherInlineModels(model, modelName);
                continue;
            }
            if (ModelUtils.isOneOf((Schema)model)) {
                this.gatherInlineModels(model, modelName);
                continue;
            }
            if (ModelUtils.isComposedSchema((Schema)model)) {
                this.flattenComposedChildren(modelName + "_allOf", model.getAllOf(), !Boolean.TRUE.equals(this.refactorAllOfInlineSchemas));
                this.flattenComposedChildren(modelName + "_anyOf", model.getAnyOf(), false);
                this.flattenComposedChildren(modelName + "_oneOf", model.getOneOf(), false);
                continue;
            }
            this.gatherInlineModels(model, modelName);
        }
    }

    private void flattenComposedChildren(String key, List<Schema> children, boolean skipAllOfInlineSchemas) {
        if (children == null || children.isEmpty()) {
            return;
        }
        ListIterator<Schema> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            Schema component = listIterator.next();
            if (component == null || component.get$ref() != null || (component.getProperties() == null || component.getProperties().isEmpty()) && (component.getEnum() == null || component.getEnum().isEmpty())) continue;
            String innerModelName = this.resolveModelName(component.getTitle(), key);
            Schema innerModel = this.modelFromProperty(this.openAPI, component, innerModelName);
            this.gatherInlineModels(innerModel, innerModelName);
            if (!skipAllOfInlineSchemas) {
                Schema schema;
                String existing = this.matchGenerated(innerModel);
                if (existing == null) {
                    innerModelName = this.addSchemas(innerModelName, innerModel);
                    schema = new Schema().$ref(innerModelName);
                    schema.setRequired(component.getRequired());
                    listIterator.set(schema);
                    continue;
                }
                schema = new Schema().$ref(existing);
                schema.setRequired(component.getRequired());
                listIterator.set(schema);
                continue;
            }
            LOGGER.debug("Inline allOf schema {} not refactored into a separate model using $ref.", (Object)innerModelName);
        }
    }

    private Schema modelFromProperty(OpenAPI openAPI, Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        XML xml = object.getXml();
        Map properties = object.getProperties();
        Schema model = new Schema();
        model.setType(object.getType());
        model.setFormat(object.getFormat());
        if (object.getExample() != null) {
            model.setExample((Object)example);
        }
        model.setDescription(description);
        model.setName(object.getName());
        model.setXml(xml);
        model.setRequired(object.getRequired());
        model.setNullable(object.getNullable());
        model.setEnum(object.getEnum());
        model.setType(object.getType());
        model.setDiscriminator(object.getDiscriminator());
        model.setWriteOnly(object.getWriteOnly());
        model.setUniqueItems(object.getUniqueItems());
        model.setTitle(object.getTitle());
        model.setReadOnly(object.getReadOnly());
        model.setPattern(object.getPattern());
        model.setNot(object.getNot());
        model.setMinProperties(object.getMinProperties());
        model.setMinLength(object.getMinLength());
        model.setMinItems(object.getMinItems());
        model.setMinimum(object.getMinimum());
        model.setMaxProperties(object.getMaxProperties());
        model.setMaxLength(object.getMaxLength());
        model.setMaxItems(object.getMaxItems());
        model.setMaximum(object.getMaximum());
        model.setExternalDocs(object.getExternalDocs());
        model.setExtensions(object.getExtensions());
        model.setExclusiveMinimum(object.getExclusiveMinimum());
        model.setExclusiveMaximum(object.getExclusiveMaximum());
        model.setDeprecated(object.getDeprecated());
        if (properties != null) {
            this.flattenProperties(openAPI, properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    private void flattenProperties(OpenAPI openAPI, Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> propertiesEntry : properties.entrySet()) {
            Schema schema;
            String innerModelName;
            Schema schema2;
            String existing;
            Schema innerModel;
            String modelName;
            Schema op;
            Schema inner;
            String key = propertiesEntry.getKey();
            Schema property = propertiesEntry.getValue();
            if (ModelUtils.isObjectSchema((Schema)property)) {
                Schema schema3;
                Schema op2 = property;
                String modelName2 = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(openAPI, op2, modelName2);
                String existing2 = this.matchGenerated(model);
                if (existing2 != null) {
                    schema3 = new Schema().$ref(existing2);
                    schema3.setRequired(op2.getRequired());
                    propsToUpdate.put(key, schema3);
                    continue;
                }
                modelName2 = this.addSchemas(modelName2, model);
                schema3 = new Schema().$ref(modelName2);
                schema3.setRequired(op2.getRequired());
                propsToUpdate.put(key, schema3);
                modelsToAdd.put(modelName2, model);
                continue;
            }
            if (ModelUtils.isArraySchema((Schema)property)) {
                inner = ModelUtils.getSchemaItems((Schema)property);
                if (ModelUtils.isObjectSchema((Schema)inner)) {
                    op = inner;
                    if (op.getProperties() == null || op.getProperties().size() <= 0) continue;
                    this.flattenProperties(openAPI, op.getProperties(), path);
                    modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
                    innerModel = this.modelFromProperty(openAPI, op, modelName);
                    existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        schema2 = new Schema().$ref(existing);
                        schema2.setRequired(op.getRequired());
                        property.setItems(schema2);
                        continue;
                    }
                    modelName = this.addSchemas(modelName, innerModel);
                    schema2 = new Schema().$ref(modelName);
                    schema2.setRequired(op.getRequired());
                    property.setItems(schema2);
                    continue;
                }
                if (ModelUtils.isComposedSchema((Schema)inner)) {
                    innerModelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
                    this.gatherInlineModels(inner, innerModelName);
                    innerModelName = this.addSchemas(innerModelName, inner);
                    schema = new Schema().$ref(innerModelName);
                    schema.setRequired(inner.getRequired());
                    property.setItems(schema);
                    continue;
                }
                LOGGER.debug("Schema not yet handled in model resolver: {}", (Object)inner);
                continue;
            }
            if (ModelUtils.isMapSchema((Schema)property)) {
                inner = ModelUtils.getAdditionalProperties((Schema)property);
                if (ModelUtils.isObjectSchema((Schema)inner)) {
                    op = inner;
                    if (op.getProperties() == null || op.getProperties().size() <= 0) continue;
                    this.flattenProperties(openAPI, op.getProperties(), path);
                    modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
                    innerModel = this.modelFromProperty(openAPI, op, modelName);
                    existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        schema2 = new Schema().$ref(existing);
                        schema2.setRequired(op.getRequired());
                        property.setAdditionalProperties((Object)schema2);
                        continue;
                    }
                    modelName = this.addSchemas(modelName, innerModel);
                    schema2 = new Schema().$ref(modelName);
                    schema2.setRequired(op.getRequired());
                    property.setAdditionalProperties((Object)schema2);
                    continue;
                }
                if (ModelUtils.isComposedSchema((Schema)inner)) {
                    innerModelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
                    this.gatherInlineModels(inner, innerModelName);
                    innerModelName = this.addSchemas(innerModelName, inner);
                    schema = new Schema().$ref(innerModelName);
                    schema.setRequired(inner.getRequired());
                    property.setAdditionalProperties((Object)schema);
                    continue;
                }
                LOGGER.debug("Schema not yet handled in model resolver: {}", (Object)inner);
                continue;
            }
            if (ModelUtils.isComposedSchema((Schema)property)) {
                if (!(property.getAllOf() == null || property.getAllOf().size() != 1 || property.getOneOf() != null && !property.getOneOf().isEmpty() || property.getAnyOf() != null && !property.getAnyOf().isEmpty() || property.getProperties() != null && !property.getProperties().isEmpty())) {
                    LOGGER.debug("allOf with a single item (which can be handled by default codegen) skipped by inline model resolver: {}", (Object)property);
                    continue;
                }
                String propertyModelName = this.resolveModelName(property.getTitle(), path + "_" + key);
                this.gatherInlineModels(property, propertyModelName);
                propertyModelName = this.addSchemas(propertyModelName, property);
                Schema schema4 = new Schema().$ref(propertyModelName);
                schema4.setRequired(property.getRequired());
                propsToUpdate.put(key, schema4);
                continue;
            }
            LOGGER.debug("Schema not yet handled in model resolver: {}", (Object)property);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    static {
        STRUCTURE_MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

