/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.micronaut.openapi.generator.Formatting;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.KotlinMicronautClientCodegen;
import io.micronaut.openapi.generator.KotlinMicronautServerCodegen;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautInlineModelResolver;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.ResponseBodyMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.micronaut.openapi.generator.Utils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.atteo.evo.inflector.English;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMicronautKotlinCodegen<T extends GeneratorOptionsBuilder>
extends AbstractKotlinCodegen
implements BeanValidationFeatures,
MicronautCodeGenerator<T> {
    public static final String OPT_TITLE = "title";
    public static final String OPT_TEST = "test";
    public static final String OPT_TEST_JUNIT = "junit";
    public static final String OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR = "requiredPropertiesInConstructor";
    public static final String OPT_USE_AUTH = "useAuth";
    public static final String OPT_USE_PLURAL = "plural";
    public static final String OPT_FLUX_FOR_ARRAYS = "fluxForArrays";
    public static final String OPT_GENERATED_ANNOTATION = "generatedAnnotation";
    public static final String OPT_VISITABLE = "visitable";
    public static final String OPT_DATE_LIBRARY_ZONED_DATETIME = "ZONED_DATETIME";
    public static final String OPT_DATE_LIBRARY_OFFSET_DATETIME = "OFFSET_DATETIME";
    public static final String OPT_DATE_LIBRARY_LOCAL_DATETIME = "LOCAL_DATETIME";
    public static final String OPT_DATE_FORMAT = "dateFormat";
    public static final String OPT_DATETIME_FORMAT = "datetimeFormat";
    public static final String OPT_REACTIVE = "reactive";
    public static final String OPT_GENERATE_HTTP_RESPONSE_ALWAYS = "generateHttpResponseAlways";
    public static final String OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED = "generateHttpResponseWhereRequired";
    public static final String OPT_APPLICATION_NAME = "applicationName";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS = "generateSwaggerAnnotations";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2 = "swagger2";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE = "true";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE = "false";
    public static final String OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG = "generateOperationOnlyForFirstTag";
    public static final String OPT_KSP = "ksp";
    public static final String CONTENT_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_ANY = "*/*";
    private static final String MONO_CLASS_NAME = "reactor.core.publisher.Mono";
    private static final String FLUX_CLASS_NAME = "reactor.core.publisher.Flux";
    protected SecureRandom random = new SecureRandom();
    protected String dateLibrary;
    protected String title;
    protected boolean useBeanValidation;
    protected boolean visitable;
    protected boolean plural = true;
    protected boolean fluxForArrays;
    protected boolean generatedAnnotation = true;
    protected String testTool;
    protected boolean requiredPropertiesInConstructor = true;
    protected boolean reactive;
    protected boolean generateHttpResponseAlways;
    protected boolean generateHttpResponseWhereRequired = true;
    protected boolean ksp;
    protected String appName;
    protected String generateSwaggerAnnotations;
    protected boolean generateOperationOnlyForFirstTag;
    protected String serializationLibrary = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name();
    protected List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
    protected List<ResponseBodyMapping> responseBodyMappings = new ArrayList<ResponseBodyMapping>();
    protected Map<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();

    protected AbstractMicronautKotlinCodegen() {
        this.languageSpecificPrimitives = Set.of("Byte", "ByteArray", "Short", "Int", "Long", "Float", "Double", "Boolean", "Char", "String", "Array", "List", "MutableList", "Map", "MutableMap", "Set", "MutableSet", "Any");
        this.defaultIncludes = Set.of("Byte", "ByteArray", "Short", "Int", "Long", "Float", "Double", "Boolean", "Char", "Array", "List", "MutableList", "Set", "MutableSet", "Map", "MutableMap", "Any");
        this.useBeanValidation = true;
        this.visitable = false;
        this.hideGenerationTimestamp = false;
        this.testTool = OPT_TEST_JUNIT;
        this.outputFolder = this instanceof KotlinMicronautClientCodegen ? "generated-code/kotlin-micronaut-client" : "generated-code/kotlin-micronaut";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.packageName = "org.openapitools";
        this.artifactId = this instanceof KotlinMicronautClientCodegen ? "openapi-micronaut-client" : "openapi-micronaut";
        this.templateDir = "templates/kotlin-micronaut";
        this.embeddedTemplateDir = "templates/kotlin-micronaut";
        this.apiDocPath = "docs/apis";
        this.modelDocPath = "docs/models";
        this.dateLibrary = OPT_DATE_LIBRARY_ZONED_DATETIME;
        this.reactive = true;
        this.appName = this.artifactId;
        this.generateSwaggerAnnotations = this instanceof KotlinMicronautClientCodegen ? OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE : OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
        this.generateOperationOnlyForFirstTag = this instanceof KotlinMicronautServerCodegen;
        this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.UPPERCASE;
        this.inlineSchemaOption.put("RESOLVE_INLINE_ENUMS", OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE);
        this.useOneOfInterfaces = true;
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, new SecurityFeature[]{SecurityFeature.BearerToken, SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OpenIDConnect})).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.additionalProperties.put("openbrace", "{");
        this.additionalProperties.put("closebrace", "}");
        this.updateOption("invokerPackage", this.packageName);
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.cliOptions.add(new CliOption(OPT_TITLE, "Client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(OPT_APPLICATION_NAME, "Micronaut application name (Defaults to the artifactId value)").defaultValue(this.appName));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_PLURAL, (String)"Whether or not to use plural for request body parameter name", (boolean)this.plural));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_FLUX_FOR_ARRAYS, (String)"Whether or not to use Flux<?> instead Mono<List<?>> for arrays in generated code", (boolean)this.fluxForArrays));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATED_ANNOTATION, (String)"Generate code with \"@Generated\" annotation", (boolean)this.generatedAnnotation));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_KSP, (String)"Generate code compatible only with KSP", (boolean)this.ksp));
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations", (boolean)this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_VISITABLE, (String)"Generate visitor for subtypes with a discriminator", (boolean)this.visitable));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, (String)"Allow only to create models with all the required properties provided in constructor", (boolean)this.requiredPropertiesInConstructor));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REACTIVE, (String)"Make the responses use Reactor Mono as wrapper", (boolean)this.reactive));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_ALWAYS, (String)"Always wrap the operations response in HttpResponse object", (boolean)this.generateHttpResponseAlways));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, (String)"Wrap the operations response in HttpResponse object where non-200 HTTP status codes or additional headers are defined", (boolean)this.generateHttpResponseWhereRequired));
        this.cliOptions.add(CliOption.newBoolean((String)"hideGenerationTimestamp", (String)"Hides the generation timestamp when files are generated.", (boolean)this.isHideGenerationTimestamp()));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, (String)"When false, the operation method will be duplicated in each of the tags if multiple tags are assigned to this operation. If true, each operation will be generated only once in the first assigned tag.", (boolean)this.generateOperationOnlyForFirstTag));
        CliOption testToolOption = new CliOption(OPT_TEST, "Specify which test tool to generate files for").defaultValue(this.testTool);
        HashMap<String, String> testToolOptionMap = new HashMap<String, String>();
        testToolOptionMap.put(OPT_TEST_JUNIT, "Use JUnit as test tool");
        testToolOption.setEnum(testToolOptionMap);
        this.cliOptions.add(testToolOption);
        CliOption generateSwaggerAnnotationsOption = new CliOption(OPT_GENERATE_SWAGGER_ANNOTATIONS, "Specify if you want to generate swagger annotations and which version").defaultValue(this.generateSwaggerAnnotations);
        HashMap<String, String> generateSwaggerAnnotationsOptionMap = new HashMap<String, String>();
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2, "Use io.swagger.core.v3:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE, "Equivalent to \"swagger2\"");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE, "Do not generate swagger annotations");
        generateSwaggerAnnotationsOption.setEnum(generateSwaggerAnnotationsOptionMap);
        this.cliOptions.add(generateSwaggerAnnotationsOption);
        this.cliOptions.add(new CliOption(OPT_DATE_FORMAT, "Specify the format pattern of date as a string"));
        this.cliOptions.add(new CliOption(OPT_DATETIME_FORMAT, "Specify the format pattern of date-time as a string"));
        this.cliOptions.stream().filter(o -> o.getOpt().equals("dateLibrary")).findFirst().ifPresent(opt -> {
            HashMap<String, String> valuesEnum = new HashMap<String, String>();
            valuesEnum.put(OPT_DATE_LIBRARY_OFFSET_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_OFFSET_DATETIME));
            valuesEnum.put(OPT_DATE_LIBRARY_LOCAL_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_LOCAL_DATETIME));
            opt.setEnum(valuesEnum);
        });
        CliOption serializationLibraryOpt = CliOption.newString((String)"serializationLibrary", (String)"Serialization library for model");
        serializationLibraryOpt.defaultValue(SerializationLibraryKind.JACKSON.name());
        HashMap<String, String> serializationLibraryOptions = new HashMap<String, String>();
        serializationLibraryOptions.put(SerializationLibraryKind.JACKSON.name(), "Jackson as serialization library");
        serializationLibraryOptions.put(SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name(), "Use micronaut-serialization with Jackson annotations");
        serializationLibraryOpt.setEnum(serializationLibraryOptions);
        this.cliOptions.removeIf(opt -> opt.getOpt().equals("serializationLibrary"));
        this.cliOptions.add(serializationLibraryOpt);
        this.reservedWords.addAll(List.of("Client", "Format", "QueryValue", "QueryParam", "PathVariable", "Header", "Cookie", "Authorization", "Body", "application"));
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("ByteArray", "ByteArray");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("binary", "ByteArray");
        this.typeMapping.put("AnyType", "Any");
        this.typeMapping.put("DateTime", "Instant");
        this.typeMapping.put("date-time", "OffsetDateTime");
        this.typeMapping.put("date", "LocalDate");
        this.typeMapping.put("Date", "LocalDate");
        this.typeMapping.put("LocalDateTime", "LocalDateTime");
        this.typeMapping.put("OffsetDateTime", "OffsetDateTime");
        this.typeMapping.put("ZonedDateTime", "ZonedDateTime");
        this.typeMapping.put("LocalDate", "LocalDate");
        this.typeMapping.put("LocalTime", "LocalTime");
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("list", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("DateTime", "java.time.Instant");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
    }

    public void setGenerateHttpResponseAlways(boolean generateHttpResponseAlways) {
        this.generateHttpResponseAlways = generateHttpResponseAlways;
    }

    public void setGenerateHttpResponseWhereRequired(boolean generateHttpResponseWhereRequired) {
        this.generateHttpResponseWhereRequired = generateHttpResponseWhereRequired;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setTestTool(String testTool) {
        this.testTool = testTool;
    }

    public void setArtifactId(String artifactId) {
        super.setArtifactId(artifactId);
        this.updateOption("artifactId", artifactId);
    }

    public void setModelPackage(String modelPackage) {
        super.setModelPackage(modelPackage);
        this.updateOption("modelPackage", modelPackage);
    }

    public void setApiPackage(String apiPackage) {
        super.setApiPackage(apiPackage);
        this.updateOption("apiPackage", apiPackage);
    }

    public void setInvokerPackage(String packageName) {
        this.updateOption("invokerPackage", packageName);
    }

    public void setPlural(boolean plural) {
        this.plural = plural;
    }

    public void setFluxForArrays(boolean fluxForArrays) {
        this.fluxForArrays = fluxForArrays;
    }

    public void setGeneratedAnnotation(boolean generatedAnnotation) {
        this.generatedAnnotation = generatedAnnotation;
    }

    public void setKsp(boolean ksp) {
        this.ksp = ksp;
    }

    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_TITLE)) {
            this.title = (String)this.additionalProperties.get(OPT_TITLE);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.packageName = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.packageName);
        }
        if (this.additionalProperties.containsKey(OPT_APPLICATION_NAME)) {
            this.appName = (String)this.additionalProperties.get(OPT_APPLICATION_NAME);
        } else {
            this.additionalProperties.put(OPT_APPLICATION_NAME, this.artifactId);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.useBeanValidation = this.convertPropertyToBoolean("useBeanValidation");
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(OPT_USE_PLURAL)) {
            this.plural = this.convertPropertyToBoolean(OPT_USE_PLURAL);
        }
        this.writePropertyBack(OPT_USE_PLURAL, this.plural);
        if (this.additionalProperties.containsKey(OPT_FLUX_FOR_ARRAYS)) {
            this.fluxForArrays = this.convertPropertyToBoolean(OPT_FLUX_FOR_ARRAYS);
        }
        this.writePropertyBack(OPT_FLUX_FOR_ARRAYS, this.fluxForArrays);
        if (this.additionalProperties.containsKey(OPT_GENERATED_ANNOTATION)) {
            this.generatedAnnotation = this.convertPropertyToBoolean(OPT_GENERATED_ANNOTATION);
        }
        this.writePropertyBack(OPT_GENERATED_ANNOTATION, this.generatedAnnotation);
        if (this.additionalProperties.containsKey(OPT_KSP)) {
            this.ksp = this.convertPropertyToBoolean(OPT_KSP);
        }
        this.writePropertyBack(OPT_KSP, this.ksp);
        if (this.additionalProperties.containsKey(OPT_VISITABLE)) {
            this.visitable = this.convertPropertyToBoolean(OPT_VISITABLE);
        }
        this.writePropertyBack(OPT_VISITABLE, this.visitable);
        if (this.additionalProperties.containsKey(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR)) {
            this.requiredPropertiesInConstructor = this.convertPropertyToBoolean(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR);
        }
        this.writePropertyBack(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, this.requiredPropertiesInConstructor);
        if (this.additionalProperties.containsKey(OPT_REACTIVE)) {
            this.reactive = this.convertPropertyToBoolean(OPT_REACTIVE);
        }
        this.writePropertyBack(OPT_REACTIVE, this.reactive);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_ALWAYS)) {
            this.generateHttpResponseAlways = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_ALWAYS);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_ALWAYS, this.generateHttpResponseAlways);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED)) {
            this.generateHttpResponseWhereRequired = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, this.generateHttpResponseWhereRequired);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG)) {
            this.generateOperationOnlyForFirstTag = this.convertPropertyToBoolean(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, this.generateOperationOnlyForFirstTag);
        this.maybeSetTestTool();
        this.writePropertyBack(OPT_TEST, this.testTool);
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.additionalProperties.put("isTestJunit", true);
        }
        this.maybeSetSwagger();
        if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
        }
        this.additionalProperties.put(this.serializationLibrary.toLowerCase(Locale.US), true);
        if (SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name().equals(this.serializationLibrary)) {
            this.additionalProperties.put(SerializationLibraryKind.JACKSON.name().toLowerCase(Locale.US), true);
        }
        this.supportingFiles.add(new SupportingFile("common/configuration/application.yml.mustache", this.resourcesFolder, "application.yml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("common/configuration/logback.xml.mustache", this.resourcesFolder, "logback.xml").doNotOverwrite());
        this.additionalProperties.put("javaxPackage", "jakarta");
        switch (this.dateLibrary) {
            case "OFFSET_DATETIME": {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.typeMapping.put("date", "LocalDate");
                break;
            }
            case "ZONED_DATETIME": {
                this.typeMapping.put("DateTime", "ZonedDateTime");
                this.typeMapping.put("date", "LocalDate");
                break;
            }
            case "LOCAL_DATETIME": {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.typeMapping.put("date", "LocalDate");
                break;
            }
        }
        this.modelDocTemplateFiles.clear();
        this.modelDocTemplateFiles.put("common/doc/model_doc.mustache", ".md");
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("common/model/model.mustache", ".kt");
        this.modelTestTemplateFiles.clear();
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.modelTestTemplateFiles.put("common/test/model_test.mustache", ".kt");
        }
        String invokerFolder = (this.sourceFolder + "/" + this.packageName).replace(".", "/");
        String apiFolder = (this.sourceFolder + "/" + this.apiPackage()).replace('.', '/');
        String modelFolder = (this.sourceFolder + "/" + this.modelPackage()).replace('.', '/');
        this.additionalProperties.put("invokerFolder", invokerFolder);
        this.additionalProperties.put("resourceFolder", this.resourcesFolder);
        this.additionalProperties.put("apiFolder", apiFolder);
        this.additionalProperties.put("modelFolder", modelFolder);
        this.additionalProperties.put("formatNoEmptyLines", new Formatting.LineFormatter(0));
        this.additionalProperties.put("formatOneEmptyLine", new Formatting.LineFormatter(1));
        this.additionalProperties.put("formatSingleLine", new Formatting.SingleLineFormatter());
        this.additionalProperties.put("indent", new Formatting.IndentFormatter(4));
    }

    public void addParameterMappings(List<ParameterMapping> parameterMappings) {
        this.parameterMappings.addAll(parameterMappings);
    }

    public void addResponseBodyMappings(List<ResponseBodyMapping> responseBodyMappings) {
        this.responseBodyMappings.addAll(responseBodyMappings);
    }

    public void addSchemaMapping(Map<String, String> schemaMapping) {
        this.schemaMapping.putAll(schemaMapping);
    }

    public void addImportMapping(Map<String, String> importMapping) {
        this.importMapping.putAll(importMapping);
    }

    public void addNameMapping(Map<String, String> nameMapping) {
        this.nameMapping.putAll(nameMapping);
    }

    public void addTypeMapping(Map<String, String> typeMapping) {
        this.typeMapping.putAll(typeMapping);
    }

    public void addEnumNameMapping(Map<String, String> enumNameMapping) {
        this.enumNameMapping.putAll(enumNameMapping);
    }

    public void addModelNameMapping(Map<String, String> modelNameMapping) {
        this.modelNameMapping.putAll(modelNameMapping);
    }

    public void addInlineSchemaNameMapping(Map<String, String> inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping.putAll(inlineSchemaNameMapping);
    }

    public void addInlineSchemaOption(Map<String, String> inlineSchemaOption) {
        this.inlineSchemaOption.putAll(inlineSchemaOption);
    }

    public void addOpenapiNormalizer(Map<String, String> openapiNormalizer) {
        this.openapiNormalizer.putAll(openapiNormalizer);
    }

    private void maybeSetSwagger() {
        if (this.additionalProperties.containsKey(OPT_GENERATE_SWAGGER_ANNOTATIONS)) {
            String value;
            switch (value = String.valueOf(this.additionalProperties.get(OPT_GENERATE_SWAGGER_ANNOTATIONS))) {
                case "swagger2": 
                case "true": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
                    break;
                }
                case "false": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
                    break;
                }
                default: {
                    throw new RuntimeException("Value \"" + value + "\" for the generateSwaggerAnnotations parameter is unsupported or misspelled");
                }
            }
        }
    }

    private void maybeSetTestTool() {
        if (this.additionalProperties.containsKey(OPT_TEST)) {
            if (this.additionalProperties.get(OPT_TEST).equals(OPT_TEST_JUNIT)) {
                this.testTool = (String)this.additionalProperties.get(OPT_TEST);
            } else {
                throw new RuntimeException("Test tool \"" + this.additionalProperties.get(OPT_TEST) + "\" is not supported or misspelled.");
            }
        }
    }

    public String testFileFolder() {
        return (this.getOutputDir() + "/src/test/kotlin/").replace('/', File.separatorChar);
    }

    public abstract boolean isServer();

    public String apiTestFileFolder() {
        return this.testFileFolder() + this.apiPackage().replaceAll("\\.", "/");
    }

    public String modelTestFileFolder() {
        return this.getOutputDir() + "/src/test/kotlin/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setVisitable(boolean visitable) {
        this.visitable = visitable;
    }

    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public String sanitizeTag(String tag) {
        return tag;
    }

    public String superSanitizeTag(String tag) {
        if (((String)(tag = StringUtils.camelize((String)StringUtils.underscore((String)this.sanitizeName((String)tag))))).matches("^\\d.*")) {
            tag = "Class" + (String)tag;
        }
        return tag;
    }

    public String toApiName(String name) {
        return Utils.toApiName(name, this.apiNamePrefix, this.apiNameSuffix);
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.generateOperationOnlyForFirstTag && !((Tag)co.tags.get(0)).getName().equals(tag)) {
            return;
        }
        super.addOperationToGroup(this.superSanitizeTag(tag), resourcePath, operation, co, operations);
    }

    public void preprocessOpenAPI(OpenAPI openApi) {
        if (openApi.getPaths() != null) {
            for (PathItem path : openApi.getPaths().values()) {
                if (path.getParameters() == null || path.getParameters().isEmpty()) continue;
                for (Operation op : path.readOperations()) {
                    if (op.getParameters() == null) {
                        op.setParameters(new ArrayList());
                    }
                    for (Parameter parameter : path.getParameters()) {
                        boolean found = false;
                        for (Parameter opParam : op.getParameters()) {
                            if (!Objects.equals(opParam.getName(), parameter.getName()) || !Objects.equals(opParam.get$ref(), parameter.get$ref())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        op.getParameters().add(parameter);
                    }
                }
            }
        }
        MicronautInlineModelResolver inlineModelResolver = new MicronautInlineModelResolver(openApi);
        inlineModelResolver.setInlineSchemaNameMapping(this.inlineSchemaNameMapping);
        inlineModelResolver.setInlineSchemaOptions(this.inlineSchemaOption);
        inlineModelResolver.flatten();
        Paths pathItems = openApi.getPaths();
        if (pathItems != null) {
            for (Map.Entry pathEntry : pathItems.entrySet()) {
                for (Map.Entry entry : ((PathItem)pathEntry.getValue()).readOperationsMap().entrySet()) {
                    if (((Operation)entry.getValue()).getResponses() == null) continue;
                    for (Map.Entry responseEntry : ((Operation)entry.getValue()).getResponses().entrySet()) {
                        ApiResponse response = (ApiResponse)responseEntry.getValue();
                        ApiResponse refResponse = ModelUtils.getReferencedApiResponse((OpenAPI)openApi, (ApiResponse)response);
                        if (response.getContent() == null) {
                            response.setContent(refResponse.getContent());
                        }
                        if (response.getDescription() == null) {
                            response.setDescription(refResponse.getDescription());
                        }
                        if (response.getHeaders() == null || response.getHeaders().isEmpty()) {
                            response.setHeaders(refResponse.getHeaders());
                        }
                        if (response.getExtensions() == null || response.getExtensions().isEmpty()) {
                            response.setExtensions(refResponse.getExtensions());
                        }
                        if (response.getLinks() != null && !response.getLinks().isEmpty()) continue;
                        response.setLinks(refResponse.getLinks());
                    }
                }
            }
        }
        super.preprocessOpenAPI(openApi);
    }

    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map<String, CodegenModel> models = allModels.stream().map(ModelMap::getModel).collect(Collectors.toMap(v -> v.classname, v -> v));
        OperationMap operations = objs.getOperations();
        List operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("methodAllowsBody", op.httpMethod.equals("PUT") || op.httpMethod.equals("POST") || op.httpMethod.equals("PATCH") || op.httpMethod.equals("OPTIONS") || op.httpMethod.equals("DELETE"));
            Utils.normalizeExtraAnnotations("x-operation-extra-annotation", true, op.vendorExtensions);
            if (op.returnType != null) {
                String example;
                if (models.containsKey(op.returnType)) {
                    CodegenModel m = models.get(op.returnType);
                    List allowableValues = null;
                    if (m.allowableValues != null && m.allowableValues.containsKey("values")) {
                        allowableValues = (List)m.allowableValues.get("values");
                    }
                    example = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, false);
                } else {
                    example = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, false);
                }
                op.vendorExtensions.put("example", example);
            }
            if (CONTENT_TYPE_ANY.equals(op.vendorExtensions.get("x-contentType"))) {
                op.vendorExtensions.put("x-contentType", CONTENT_TYPE_APPLICATION_JSON);
            }
            op.consumes = op.consumes == null ? null : op.consumes.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            List list = op.produces = op.produces == null ? null : op.produces.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            if (op.consumes == null || op.consumes.isEmpty() || op.consumes.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.consumes.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultConsumeOrEmpty", true);
            }
            if (op.produces == null || op.produces.isEmpty() || op.produces.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.produces.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultProduceOrEmpty", true);
            }
            if (CONTENT_TYPE_APPLICATION_FORM_URLENCODED.equals(op.vendorExtensions.get("x-contentType"))) {
                op.formParams.addAll(op.bodyParams);
                op.bodyParams.forEach(p -> {
                    p.isBodyParam = false;
                    p.isFormParam = true;
                });
                op.bodyParams.clear();
            } else if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(op.vendorExtensions.get("x-contentType"))) {
                op.bodyParams.addAll(op.formParams);
                op.formParams.forEach(p -> {
                    p.isBodyParam = true;
                    p.isFormParam = false;
                });
                op.formParams.clear();
            }
            for (CodegenParameter param : op.allParams) {
                Utils.processGenericAnnotations(param, this.useBeanValidation, false, param.isNullable || !param.required, param.required, false, true);
                param.vendorExtensions.put("isString", "string".equalsIgnoreCase(param.dataType));
                param.vendorExtensions.put("withoutExample", param.example == null || param.example.equals("null"));
                if (!this.useBeanValidation || (param.isContainer || !param.isModel) && (!param.getIsArray() || param.getComplexType() == null || !models.containsKey(param.getComplexType()))) continue;
                param.vendorExtensions.put("withValid", true);
            }
            if (op.returnProperty == null) continue;
            Utils.processGenericAnnotations(op.returnProperty, this.useBeanValidation, false, false, false, false, false);
            op.returnType = op.returnProperty.vendorExtensions.get("typeWithEnumWithGenericAnnotations").toString();
        }
        return objs;
    }

    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype) || "Int".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "L";
        }
        if ("Float".equals(datatype)) {
            return value + "F";
        }
        if ("BigDecimal".equals(datatype)) {
            return "BigDecimal(\"" + value + "\")";
        }
        if ("URI".equals(datatype)) {
            return "URI.create(\"" + this.escapeText(value) + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        if ("BigDecimal".equals(codegenModel.dataType)) {
            codegenModel.imports.add("BigDecimal");
        }
        this.allModels.put(name, codegenModel);
        return codegenModel;
    }

    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = this.unaliasSchema(p);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema((Schema)target)) {
            Schema items = ModelUtils.getSchemaItems((Schema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema((Schema)target)) {
            Schema inner = ModelUtils.getAdditionalProperties((Schema)target);
            if (inner == null) {
                this.log.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(target);
    }

    public String toModelName(String name) {
        if (this.schemaKeyToModelNameCache.containsKey(name)) {
            return this.schemaKeyToModelNameCache.get(name);
        }
        if (name.startsWith("kotlin.") || name.startsWith("java.")) {
            return name;
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        String modifiedName = name.replaceAll("\\.", "").replace("-", "_").replace("`", "");
        Object nameWithPrefixSuffix = this.normalizeKotlinSpecificNames(modifiedName);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(modifiedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + modifiedName;
            this.log.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)modifiedName, (Object)modelName);
            return modelName;
        }
        if (modifiedName.matches("^\\d.*")) {
            String modelName = "Model" + modifiedName;
            this.log.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        this.schemaKeyToModelNameCache.put(name, this.firstTitleCase(modifiedName));
        return this.schemaKeyToModelNameCache.get(name);
    }

    public CodegenParameter fromParameter(Parameter p, Set<String> imports) {
        CodegenParameter parameter = super.fromParameter(p, imports);
        String realName = parameter.paramName;
        if (realName.contains("`")) {
            realName = realName.replace("`", "");
        }
        parameter.vendorExtensions.put("realName", realName);
        Utils.addStrValueToEnum(parameter.items);
        return parameter;
    }

    public CodegenProperty fromProperty(String name, Schema p, boolean required, boolean schemaIsFromAdditionalProperties) {
        CodegenProperty property = super.fromProperty(name, p, required, schemaIsFromAdditionalProperties);
        String realName = property.name;
        if (realName.contains("`")) {
            realName = realName.replace("`", "");
            property.nameInCamelCase = StringUtils.camelize((String)realName);
            property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInCamelCase);
        }
        property.vendorExtensions.put("realName", realName);
        return property;
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (op.isResponseFile) {
            op.returnType = (String)this.typeMapping.get("responseFile");
            op.imports.add(op.returnType);
        }
        op.vendorExtensions.put("originalParams", new ArrayList(op.allParams));
        boolean hasMultipleParams = false;
        int notBodyParamsSize = 0;
        for (CodegenParameter param : op.allParams) {
            if (param.isBodyParam || ++notBodyParamsSize <= 1) continue;
            hasMultipleParams = true;
            break;
        }
        for (CodegenParameter param : op.allParams) {
            param.vendorExtensions.put("hasNotBodyParam", notBodyParamsSize > 0);
            param.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
        }
        op.vendorExtensions.put("originReturnProperty", op.returnProperty);
        if (op.responses != null && !op.responses.isEmpty()) {
            for (CodegenResponse resp : op.responses) {
                if (!resp.isDefault) continue;
                resp.code = "default";
            }
        }
        this.processParametersWithAdditionalMappings(op.allParams, op.imports);
        this.processWithResponseBodyMapping(op);
        this.processOperationWithResponseWrappers(op);
        return op;
    }

    public String toEnumVarName(String value, String datatype) {
        if (((String)value).isEmpty()) {
            String modified = "EMPTY";
            return this.normalizeKotlinSpecificNames(modified);
        }
        if (AbstractMicronautKotlinCodegen.isNumeric((String)(value = ((String)value).replaceAll("[^a-zA-Z0-9_]", "_")))) {
            value = "_" + (String)value;
        }
        return super.toEnumVarName((String)value, datatype);
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private void processParametersWithAdditionalMappings(List<CodegenParameter> params, Set<String> imports) {
        LinkedHashMap<String, ParameterMapping> additionalMappings = new LinkedHashMap<String, ParameterMapping>();
        Iterator<CodegenParameter> iter = params.iterator();
        while (iter.hasNext()) {
            CodegenParameter param = iter.next();
            boolean paramWasMapped = false;
            for (ParameterMapping mapping : this.parameterMappings) {
                if (!mapping.doesMatch(param)) continue;
                additionalMappings.put(mapping.mappedName(), mapping);
                paramWasMapped = true;
            }
            if (paramWasMapped) {
                iter.remove();
                continue;
            }
            if (!this.plural || !param.isArray || !param.isBodyParam || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.getRef()) || "requestBody".equals(param.paramName)) continue;
            param.paramName = English.plural((String)param.paramName);
        }
        for (ParameterMapping mapping : additionalMappings.values()) {
            String typeName;
            if (mapping.mappedType() == null) continue;
            CodegenParameter newParam = new CodegenParameter();
            newParam.paramName = mapping.mappedName();
            newParam.required = true;
            newParam.isModel = mapping.isValidated();
            newParam.dataType = typeName = this.makeSureImported(mapping.mappedType(), imports);
            if (newParam.paramName == null) {
                newParam.paramName = this.toParamName(typeName);
            }
            params.add(newParam);
        }
    }

    private void processWithResponseBodyMapping(CodegenOperation op) {
        ResponseBodyMapping bodyMapping = null;
        Iterator iter = op.responseHeaders.iterator();
        while (iter.hasNext()) {
            CodegenProperty header = (CodegenProperty)iter.next();
            boolean headerWasMapped = false;
            for (ResponseBodyMapping mapping : this.responseBodyMappings) {
                if (!mapping.doesMatch(header.baseName, op.isArray)) continue;
                if (mapping.mappedBodyType() != null) {
                    bodyMapping = mapping;
                }
                headerWasMapped = true;
            }
            if (!headerWasMapped) continue;
            iter.remove();
        }
        if (bodyMapping != null) {
            this.wrapOperationReturnType(op, bodyMapping.mappedBodyType(), bodyMapping.isValidated(), bodyMapping.isListWrapper());
        }
    }

    private void wrapOperationReturnType(CodegenOperation op, String wrapperType, boolean isValidated, boolean isListWrapper) {
        CodegenProperty newReturnType = new CodegenProperty();
        newReturnType.required = true;
        newReturnType.isModel = isValidated;
        String typeName = this.makeSureImported(wrapperType, op.imports);
        if ((isListWrapper || this.fluxForArrays) && op.isArray && op.returnProperty.items != null) {
            if (this.fluxForArrays && wrapperType.equals(MONO_CLASS_NAME)) {
                typeName = this.makeSureImported(FLUX_CLASS_NAME, op.imports);
                op.vendorExtensions.put("isReturnFlux", true);
            }
            String originalReturnType = op.returnBaseType;
            newReturnType.dataType = typeName + "<" + op.returnBaseType + ">";
            newReturnType.items = op.returnProperty.items;
        } else {
            String originalReturnType = op.returnType;
            if (originalReturnType == null) {
                originalReturnType = "Void";
                op.returnProperty = new CodegenProperty();
                op.returnProperty.dataType = "Void";
            }
            newReturnType.dataType = typeName + "<" + originalReturnType + ">";
            newReturnType.items = op.returnProperty;
        }
        op.returnType = newReturnType.dataType;
        op.returnContainer = null;
        op.returnProperty = newReturnType;
        op.isArray = op.returnProperty.isArray;
    }

    private void processOperationWithResponseWrappers(CodegenOperation op) {
        boolean requiresHttpResponse;
        boolean hasNon200StatusCodes = op.responses.stream().anyMatch(response -> !"200".equals(response.code) && response.code.startsWith("2"));
        boolean hasNonMappedHeaders = !op.responseHeaders.isEmpty();
        boolean bl = requiresHttpResponse = hasNon200StatusCodes || hasNonMappedHeaders;
        if (this.generateHttpResponseAlways || this.generateHttpResponseWhereRequired && requiresHttpResponse) {
            this.wrapOperationReturnType(op, "io.micronaut.http.HttpResponse", false, false);
        }
        if (this.reactive) {
            this.wrapOperationReturnType(op, MONO_CLASS_NAME, false, false);
        }
    }

    private String makeSureImported(String typeName, Set<String> imports) {
        int firstCapitalIndex = 0;
        for (int i = 0; i < typeName.length(); ++i) {
            if (!Character.isUpperCase(typeName.charAt(i))) continue;
            firstCapitalIndex = i;
            break;
        }
        if (firstCapitalIndex != 0) {
            String dataType = typeName.substring(firstCapitalIndex);
            this.importMapping.put(dataType, typeName);
            typeName = dataType;
        }
        imports.add(typeName);
        return typeName;
    }

    public String toVarName(String name) {
        Object varName = super.toVarName(name);
        if (((String)varName).chars().allMatch(c -> Character.isUpperCase(c) || c == 95)) {
            return varName;
        }
        if (((String)varName).length() >= 2 && Character.isLowerCase(((String)varName).charAt(0)) && Character.isUpperCase(((String)varName).charAt(1))) {
            varName = "" + ((String)varName).charAt(0) + Character.toLowerCase(((String)varName).charAt(1)) + ((String)varName).substring(2);
        }
        return varName;
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        boolean isServer = this.isServer();
        for (ModelsMap models : objs.values()) {
            CodegenModel model = ((ModelMap)models.getModels().get(0)).getModel();
            ArrayList<CodegenProperty> requiredVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> requiredParentVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> allVars = new ArrayList<CodegenProperty>();
            this.processParentModel(model, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars, false);
            model.allVars = allVars;
            this.processOneOfModels(model, objs.values());
            boolean withInheritance = model.hasChildren || model.parent != null;
            model.vendorExtensions.put("withInheritance", withInheritance);
            ArrayList<CodegenProperty> optionalVars = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> requiredVars = new ArrayList<CodegenProperty>();
            for (CodegenProperty v : model.vars) {
                v.vendorExtensions.put("hasChildren", model.hasChildren);
                if (this.containsProp(v, requiredVarsWithoutDiscriminator) || !model.hasChildren || v.required && !v.isDiscriminator) {
                    if (this.containsProp(v, requiredVars)) continue;
                    requiredVars.add(v);
                    continue;
                }
                if (this.containsProp(v, optionalVars)) continue;
                optionalVars.add(v);
            }
            model.vendorExtensions.put("withMultipleVars", model.vars.size() > 1);
            if (!requiredParentVarsWithoutDiscriminator.isEmpty()) {
                model.vendorExtensions.put("requiredParentVarsWithoutDiscriminator", requiredParentVarsWithoutDiscriminator);
            }
            if (!requiredVarsWithoutDiscriminator.isEmpty()) {
                model.vendorExtensions.put("requiredVarsWithoutDiscriminator", requiredVarsWithoutDiscriminator);
            }
            model.vendorExtensions.put("requiredVars", requiredVars);
            model.vendorExtensions.put("withRequiredOrOptionalVars", !requiredVarsWithoutDiscriminator.isEmpty() || !optionalVars.isEmpty());
            model.vendorExtensions.put("optionalVars", optionalVars);
            model.vendorExtensions.put("serialId", this.random.nextLong());
            model.vendorExtensions.put("withRequiredVars", !model.requiredVars.isEmpty());
            Utils.normalizeExtraAnnotations("x-class-extra-annotation", true, model.vendorExtensions);
            if (model.discriminator != null) {
                model.vendorExtensions.put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
                model.discriminator.getVendorExtensions().put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
            }
            for (CodegenProperty property : model.vars) {
                this.processProperty(property, isServer, model, objs);
            }
            for (CodegenProperty property : model.requiredVars) {
                this.processProperty(property, isServer, model, objs);
            }
            Utils.addStrValueToEnum(model);
        }
        return objs;
    }

    private void processOneOfModels(CodegenModel model, Collection<ModelsMap> models) {
        if (!model.vendorExtensions.containsKey("x-is-one-of-interface") || !Boolean.parseBoolean(model.vendorExtensions.get("x-is-one-of-interface").toString())) {
            return;
        }
        CodegenDiscriminator discriminator = model.discriminator;
        if (discriminator == null) {
            return;
        }
        String oneOfInterfaceName = model.name;
        for (ModelsMap modelMap : models) {
            Object xImplements;
            CodegenModel m = ((ModelMap)modelMap.getModels().get(0)).getModel();
            if (!m.vendorExtensions.containsKey("x-implements") || !((xImplements = m.vendorExtensions.get("x-implements")) instanceof List)) continue;
            List xImplementsList = (List)xImplements;
            block1: for (Object implInterface : xImplementsList) {
                if (!oneOfInterfaceName.equalsIgnoreCase(implInterface.toString())) continue;
                for (CodegenProperty prop : m.allVars) {
                    if (!prop.name.equals(discriminator.getPropertyName())) continue;
                    prop.isDiscriminator = true;
                    prop.isOverridden = true;
                    prop.vendorExtensions.put("overridden", true);
                    continue block1;
                }
            }
        }
    }

    private void processProperty(CodegenProperty property, boolean isServer, CodegenModel model, Map<String, ModelsMap> models) {
        property.vendorExtensions.put("withRequiredAndOptionalVars", model.vendorExtensions.get("withRequiredAndOptionalVars"));
        property.vendorExtensions.put("inRequiredArgsConstructor", !property.isReadOnly || isServer);
        property.vendorExtensions.put("isServer", isServer);
        property.vendorExtensions.put("defaultValueIsNotNull", property.defaultValue != null && !property.defaultValue.equals("null"));
        property.vendorExtensions.put("fieldAnnPrefix", this.ksp ? "" : "field:");
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (this.useBeanValidation && (!property.isContainer && property.isModel || property.getIsArray() && property.getComplexType() != null && models.containsKey(property.getComplexType()))) {
            property.vendorExtensions.put("withValid", true);
        }
        Utils.processGenericAnnotations(property, this.useBeanValidation, false, property.isNullable || property.isDiscriminator, property.required, property.isReadOnly, true);
        Utils.normalizeExtraAnnotations("x-field-extra-annotation", true, property.vendorExtensions);
        Utils.normalizeExtraAnnotations("x-setter-extra-annotation", true, property.vendorExtensions);
    }

    private void processParentModel(CodegenModel model, List<CodegenProperty> requiredVarsWithoutDiscriminator, List<CodegenProperty> requiredParentVarsWithoutDiscriminator, List<CodegenProperty> allVars, boolean processParentModel) {
        CodegenModel parent = model.getParentModel();
        boolean hasParent = parent != null;
        allVars.addAll(model.vars);
        if (!processParentModel) {
            this.processVar(model, model.vars, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, processParentModel);
        }
        this.processVar(model, model.requiredVars, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, processParentModel);
        this.requiredParentVarsWithoutDiscriminator(model, requiredParentVarsWithoutDiscriminator);
        if (hasParent) {
            model.parentVars = parent.allVars;
        }
        if (hasParent) {
            this.processParentModel(parent, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars, true);
        }
    }

    private void processVar(CodegenModel model, List<CodegenProperty> vars, List<CodegenProperty> requiredVarsWithoutDiscriminator, List<CodegenProperty> requiredParentVarsWithoutDiscriminator, boolean processParentModel) {
        for (CodegenProperty v : vars) {
            if (!this.isDiscriminator(v, model) && !this.containsProp(v, requiredVarsWithoutDiscriminator)) {
                if (!(v.isOverridden == null || v.isOverridden.booleanValue() || v.vendorExtensions.containsKey("overridden") || this.containsProp(v, vars))) {
                    v.isOverridden = true;
                    v.vendorExtensions.put("overridden", true);
                }
                v.vendorExtensions.put("hasChildren", model.hasChildren);
                if (model.parentModel == null || !this.containsProp(v, (List)model.parentModel.vendorExtensions.get("requiredVarsWithoutDiscriminator"))) {
                    requiredVarsWithoutDiscriminator.add(v);
                }
                if (processParentModel && this.containsProp(v, (List)model.vendorExtensions.get("requiredVarsWithoutDiscriminator"))) {
                    v.isOverridden = true;
                    v.vendorExtensions.put("overridden", true);
                }
            }
            v.isNullable = v.isNullable || v.required && v.isReadOnly && this.isServer() || !v.required;
        }
    }

    private void requiredParentVarsWithoutDiscriminator(CodegenModel model, List<CodegenProperty> requiredParentVarsWithoutDiscriminator) {
        CodegenModel parent = model.parentModel;
        if (parent == null) {
            return;
        }
        for (CodegenProperty v : parent.vars) {
            boolean isDiscriminator = this.isDiscriminator(v, model);
            if (!v.required || isDiscriminator) continue;
            v.vendorExtensions.put("isServerOrNotReadOnly", !v.isReadOnly || this.isServer());
            if (this.containsProp(v, requiredParentVarsWithoutDiscriminator)) continue;
            requiredParentVarsWithoutDiscriminator.add(v);
        }
    }

    private boolean containsProp(CodegenProperty prop, List<CodegenProperty> props) {
        if (props == null) {
            return false;
        }
        for (CodegenProperty p : props) {
            if (!prop.name.equals(p.name)) continue;
            return true;
        }
        return false;
    }

    private boolean isDiscriminator(CodegenProperty prop, CodegenModel model) {
        boolean isDiscriminator = prop.isDiscriminator;
        if (isDiscriminator) {
            return true;
        }
        if (model.parentModel == null) {
            return false;
        }
        CodegenProperty parentProp = null;
        for (CodegenProperty pv : model.parentModel.allVars) {
            if (!pv.required || !pv.name.equals(prop.name)) continue;
            isDiscriminator = pv.isDiscriminator;
            parentProp = pv;
            break;
        }
        if (isDiscriminator) {
            return true;
        }
        return parentProp != null && this.isDiscriminator(parentProp, model.parentModel);
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
            return;
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            Example example = (Example)parameter.getExamples().values().iterator().next();
            if (example.getValue() != null) {
                codegenParameter.example = example.getValue().toString();
            }
        } else {
            Schema schema = parameter.getSchema();
            if (schema != null && schema.getExample() != null) {
                codegenParameter.example = schema.getExample().toString();
            }
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExampleValue(CodegenParameter p) {
        p.example = this.getParameterExampleValue(p);
    }

    protected String getParameterExampleValue(CodegenParameter p) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, p.requiredVars, false);
    }

    protected String getPropertyExampleValue(CodegenProperty p) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        CodegenModel model = this.allModels.get(p.getDataType());
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, model != null ? model.requiredVars : null, true);
    }

    private boolean withExample(String example) {
        return example != null && !example.equals("null");
    }

    public String getExampleValue(String defaultValue, String example, String dataType, Boolean isModel, List<Object> allowableValues, String itemsType, String itemsExample, List<CodegenProperty> requiredVars, boolean isProperty) {
        String containerType;
        example = defaultValue != null ? defaultValue : example;
        String string = containerType = dataType == null ? null : dataType.split("<")[0];
        if ("String".equals(dataType)) {
            example = this.withExample((String)example) ? "\"" + this.escapeText((String)example) + "\"" : "\"example\"";
        } else if ("Int".equals(dataType) || "Short".equals(dataType)) {
            example = this.withExample((String)example) ? example : "56";
        } else if ("Long".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(this.withExample((String)example) ? example : "56"), (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(this.withExample((String)example) ? example : "3.4"), (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(this.withExample((String)example) ? example : "3.4"), (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(dataType)) {
            example = this.withExample((String)example) ? example : OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
        } else if ("File".equals(dataType) || "java.io.File".equals(dataType)) {
            example = null;
        } else if ("OffsetDateTime".equals(dataType)) {
            example = "OffsetDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("LocalDate".equals(dataType)) {
            example = "LocalDate.of(2001, 2, 3)";
        } else if ("LocalDateTime".equals(dataType)) {
            example = "LocalDateTime.of(2001, 2, 3, 4, 5)";
        } else if ("ByteArray".equals(dataType)) {
            example = "ByteArray(10)";
        } else if ("BigDecimal".equals(dataType)) {
            example = "BigDecimal(\"78\")";
        } else if (allowableValues != null && !allowableValues.isEmpty()) {
            Object value = example;
            if (value == null || !allowableValues.contains(value)) {
                value = allowableValues.get(0);
            }
            if (isProperty) {
                dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
            }
            example = dataType + ".fromValue(\"" + value + "\")";
        } else if (isModel != null && isModel.booleanValue() || isModel == null && !this.languageSpecificPrimitives.contains(dataType)) {
            if (requiredVars == null) {
                example = null;
            } else if (this.requiredPropertiesInConstructor) {
                StringBuilder builder = new StringBuilder();
                if (isProperty) {
                    dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
                }
                builder.append(dataType).append("(");
                for (int i = 0; i < requiredVars.size(); ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(this.getPropertyExampleValue(requiredVars.get(i)));
                }
                builder.append(")");
                example = builder.toString();
            } else {
                example = dataType + "()";
            }
        }
        if ("List".equals(containerType)) {
            Object innerExample;
            if ("String".equals(itemsType)) {
                itemsExample = itemsExample != null ? itemsExample : "example";
                innerExample = "\"" + this.escapeText(itemsExample) + "\"";
            } else {
                Object object = innerExample = itemsExample != null ? itemsExample : "";
            }
            example = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)innerExample) ? "listOf(" + (String)innerExample + ")" : "listOf<" + itemsType + ">()";
        } else if ("Set".equals(containerType)) {
            example = "HashSet<Any>()";
        } else if ("Map".equals(containerType)) {
            example = "HashMap<Any, Any>()";
        } else if (example == null) {
            example = "null";
        }
        return example;
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"replaceDotsWithUnderscore", (Object)new Formatting.ReplaceDotsWithUnderscoreLambda());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setSerializationLibrary(String serializationLibrary) {
        try {
            this.serializationLibrary = SerializationLibraryKind.valueOf(serializationLibrary).name();
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(serializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SerializationLibraryKind availableSerializationLibrary : SerializationLibraryKind.values()) {
                sb.append("\n  ").append(availableSerializationLibrary.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public void setDateTimeLibrary(String name) {
        this.dateLibrary = name;
    }

    private String normalizeKotlinSpecificNames(String name) {
        if (this.typeMapping.containsValue(name)) {
            return name;
        }
        Object word = name;
        for (Map.Entry<String, String> entry : this.specialCharReplacements.entrySet()) {
            word = this.replaceSpecialCharacters((String)word, entry);
        }
        word = Pattern.compile("\\W+", 256).matcher((CharSequence)word).replaceAll("_");
        if (((String)word).matches("\\d.*")) {
            word = "_" + (String)word;
        }
        if (((String)word).matches("^_*$")) {
            word = ((String)word).replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    private String replaceSpecialCharacters(String word, Map.Entry<String, String> specialCharacters) {
        String specialChar = specialCharacters.getKey();
        String replacementChar = specialCharacters.getValue();
        if (!specialChar.equals("_") && word.contains(specialChar)) {
            return this.replaceChars(word, specialChar, replacementChar);
        }
        return word;
    }

    private String replaceChars(String word, String oldValue, String newValue) {
        if (!word.contains(oldValue)) {
            return word;
        }
        if (word.equals(oldValue)) {
            return newValue;
        }
        int i = word.indexOf(oldValue);
        String start = word.substring(0, i);
        String end = this.recurseOnEndOfTheWord(word, oldValue, newValue, i);
        return start + newValue + end;
    }

    private String recurseOnEndOfTheWord(String word, String oldValue, String newValue, int lastReplacedValue) {
        String end = word.substring(lastReplacedValue + 1);
        if (!end.isEmpty()) {
            end = this.firstTitleCase(end);
            end = this.replaceChars(end, oldValue, newValue);
        }
        return end;
    }

    private String firstTitleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }
}

