/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.micronaut.openapi.generator.Formatting;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.KotlinMicronautClientCodegen;
import io.micronaut.openapi.generator.KotlinMicronautServerCodegen;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautInlineModelResolver;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.ResponseBodyMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.micronaut.openapi.generator.Utils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import io.swagger.v3.parser.ObjectMapperFactory;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.atteo.evo.inflector.English;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenModelFactory;
import org.openapitools.codegen.CodegenModelType;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMicronautKotlinCodegen<T extends GeneratorOptionsBuilder>
extends AbstractKotlinCodegen
implements BeanValidationFeatures,
MicronautCodeGenerator<T> {
    public static final String OPT_TITLE = "title";
    public static final String OPT_TEST = "test";
    public static final String OPT_TEST_JUNIT = "junit";
    public static final String OPT_USE_AUTH = "useAuth";
    public static final String OPT_GENERATE_ENUM_CONVERTERS = "generateEnumConverters";
    public static final String OPT_USE_PLURAL = "plural";
    public static final String OPT_FLUX_FOR_ARRAYS = "fluxForArrays";
    public static final String OPT_GENERATED_ANNOTATION = "generatedAnnotation";
    public static final String OPT_VISITABLE = "visitable";
    public static final String OPT_DATE_LIBRARY_ZONED_DATETIME = "ZONED_DATETIME";
    public static final String OPT_DATE_LIBRARY_OFFSET_DATETIME = "OFFSET_DATETIME";
    public static final String OPT_DATE_LIBRARY_LOCAL_DATETIME = "LOCAL_DATETIME";
    public static final String OPT_DATE_FORMAT = "dateFormat";
    public static final String OPT_DATE_TIME_FORMAT = "dateTimeFormat";
    public static final String OPT_REACTIVE = "reactive";
    public static final String OPT_COROUTINES = "coroutines";
    public static final String OPT_JVM_OVERLOADS = "jvmOverloads";
    public static final String OPT_JVM_RECORD = "jvmRecord";
    public static final String OPT_JAVA_COMPATIBILITY = "javaCompatibility";
    public static final String OPT_GENERATE_HTTP_RESPONSE_ALWAYS = "generateHttpResponseAlways";
    public static final String OPT_GENERATE_CONTROLLER_AS_ABSTRACT = "generateControllerAsAbstract";
    public static final String OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED = "generateHttpResponseWhereRequired";
    public static final String OPT_APPLICATION_NAME = "applicationName";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS = "generateSwaggerAnnotations";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2 = "swagger2";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE = "true";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE = "false";
    public static final String OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG = "generateOperationOnlyForFirstTag";
    public static final String OPT_IMPLICIT_HEADERS = "implicitHeaders";
    public static final String OPT_IMPLICIT_HEADERS_REGEX = "implicitHeadersRegex";
    public static final String OPT_USE_ENUM_CASE_INSENSITIVE = "useEnumCaseInsensitive";
    public static final String OPT_KSP = "ksp";
    public static final String OPT_USE_TAGS = "useTags";
    public static final String OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS = "jsonIncludeAlwaysForRequiredFields";
    public static final String ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS = "additionalOneOfTypeAnnotations";
    public static final String ADDITIONAL_ENUM_TYPE_ANNOTATIONS = "additionalEnumTypeAnnotations";
    public static final String CONTENT_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_ANY = "*/*";
    private static final String MONO_CLASS_NAME = "reactor.core.publisher.Mono";
    private static final String FLUX_CLASS_NAME = "reactor.core.publisher.Flux";
    protected ObjectMapper objectMapper = ObjectMapperFactory.createJson();
    protected SecureRandom random = new SecureRandom();
    protected String dateLibrary;
    protected String title;
    protected boolean useBeanValidation;
    protected boolean visitable;
    protected boolean useTags = true;
    protected boolean generateEnumConverters = true;
    protected boolean plural = true;
    protected boolean fluxForArrays;
    protected boolean generatedAnnotation = true;
    protected String testTool;
    protected boolean reactive;
    protected boolean coroutines;
    protected boolean generateHttpResponseAlways;
    protected boolean generateHttpResponseWhereRequired = true;
    protected boolean generateControllerAsAbstract;
    protected boolean useEnumCaseInsensitive;
    protected boolean ksp;
    protected boolean jsonIncludeAlwaysForRequiredFields;
    protected boolean implicitHeaders;
    protected boolean jvmOverloads;
    protected boolean jvmRecord;
    protected boolean javaCompatibility = true;
    protected String implicitHeadersRegex;
    protected String appName;
    protected String dateFormat;
    protected String dateTimeFormat;
    protected String generateSwaggerAnnotations;
    protected boolean generateOperationOnlyForFirstTag;
    protected String serializationLibrary = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name();
    protected List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
    protected List<ResponseBodyMapping> responseBodyMappings = new ArrayList<ResponseBodyMapping>();
    protected Map<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
    protected List<String> additionalOneOfTypeAnnotations = new LinkedList<String>();
    protected List<String> additionalEnumTypeAnnotations = new LinkedList<String>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();

    protected AbstractMicronautKotlinCodegen() {
        this.languageSpecificPrimitives = Set.of("Byte", "ByteArray", "Short", "Int", "Long", "Float", "Double", "Boolean", "Char", "String", "Array", "List", "MutableList", "Map", "MutableMap", "Set", "MutableSet", "Any");
        this.defaultIncludes = Set.of("Byte", "ByteArray", "Short", "Int", "Long", "Float", "Double", "Boolean", "Char", "Array", "List", "MutableList", "Set", "MutableSet", "Map", "MutableMap", "Any");
        this.useJakartaEe = true;
        this.useBeanValidation = true;
        this.visitable = false;
        this.hideGenerationTimestamp = false;
        this.testTool = OPT_TEST_JUNIT;
        this.outputFolder = this instanceof KotlinMicronautClientCodegen ? "generated-code/kotlin-micronaut-client" : "generated-code/kotlin-micronaut";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.packageName = "org.openapitools";
        this.artifactId = this instanceof KotlinMicronautClientCodegen ? "openapi-micronaut-client" : "openapi-micronaut";
        this.templateDir = "templates/kotlin-micronaut";
        this.embeddedTemplateDir = "templates/kotlin-micronaut";
        this.apiDocPath = "docs/apis";
        this.modelDocPath = "docs/models";
        this.dateLibrary = OPT_DATE_LIBRARY_ZONED_DATETIME;
        this.reactive = true;
        this.appName = this.artifactId;
        this.generateSwaggerAnnotations = this instanceof KotlinMicronautClientCodegen ? OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE : OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
        this.generateOperationOnlyForFirstTag = this instanceof KotlinMicronautServerCodegen;
        this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.UPPERCASE;
        this.inlineSchemaOption.put("RESOLVE_INLINE_ENUMS", OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE);
        this.useOneOfInterfaces = true;
        GlobalSettings.setProperty((String)"divideOperationsByContentType", (String)OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE);
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, new SecurityFeature[]{SecurityFeature.BearerToken, SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OpenIDConnect, SecurityFeature.SignatureAuth, SecurityFeature.AWSV4Signature})).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.additionalProperties.put("useOneOfInterfaces", this.useOneOfInterfaces);
        this.additionalProperties.put("openbrace", "{");
        this.additionalProperties.put("closebrace", "}");
        this.updateOption("invokerPackage", this.packageName);
        this.updateOption("packageName", this.packageName);
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.cliOptions.add(new CliOption(OPT_TITLE, "Client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(OPT_APPLICATION_NAME, "Micronaut application name (Defaults to the artifactId value)").defaultValue(this.appName));
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_ENUM_TYPE_ANNOTATIONS, (String)"Additional annotations for enum type (class level annotations)"));
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS, (String)"Additional annotations for oneOf interfaces (class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_PLURAL, (String)"Whether or not to use plural for request body parameter name", (boolean)this.plural));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_ENUM_CONVERTERS, (String)"Generate or not custom enum converters for enum query values and path variables", (boolean)this.generateEnumConverters));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_FLUX_FOR_ARRAYS, (String)"Whether or not to use Flux<?> instead Mono<List<?>> for arrays in generated code", (boolean)this.fluxForArrays));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATED_ANNOTATION, (String)"Generate code with \"@Generated\" annotation", (boolean)this.generatedAnnotation));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_KSP, (String)"Generate code compatible only with KSP", (boolean)this.ksp));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_TAGS, (String)"Whether to use tags for creating interface and controller class names", (boolean)this.useTags));
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations", (boolean)this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_VISITABLE, (String)"Generate visitor for subtypes with a discriminator", (boolean)this.visitable));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REACTIVE, (String)"Make the responses use Reactor Mono as wrapper", (boolean)this.reactive));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_COROUTINES, (String)"Make functions suspend", (boolean)this.coroutines));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_IMPLICIT_HEADERS, (String)"Skip header parameters in the generated API methods using @ApiImplicitParams annotation.", (boolean)this.implicitHeaders));
        this.cliOptions.add(CliOption.newString((String)OPT_IMPLICIT_HEADERS_REGEX, (String)"Skip header parameters that matches given regex in the generated API methods using @ApiImplicitParams annotation. Note: this parameter is ignored when implicitHeaders=true"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_ALWAYS, (String)"Always wrap the operations response in HttpResponse object", (boolean)this.generateHttpResponseAlways));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_CONTROLLER_AS_ABSTRACT, (String)"If true, then controller interface will be without @Controller annotation", (boolean)this.generateControllerAsAbstract));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, (String)"Wrap the operations response in HttpResponse object where non-200 HTTP status codes or additional headers are defined", (boolean)this.generateHttpResponseWhereRequired));
        this.cliOptions.add(CliOption.newBoolean((String)"hideGenerationTimestamp", (String)"Hides the generation timestamp when files are generated.", (boolean)this.isHideGenerationTimestamp()));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, (String)"When false, the operation method will be duplicated in each of the tags if multiple tags are assigned to this operation. If true, each operation will be generated only once in the first assigned tag.", (boolean)this.generateOperationOnlyForFirstTag));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_ENUM_CASE_INSENSITIVE, (String)"Use `equalsIgnoreCase` when String for enum comparison", (boolean)this.useEnumCaseInsensitive));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS, (String)"If set to true, @JsonInclude annotation will be with value ALWAYS for required properties in POJO's", (boolean)this.jsonIncludeAlwaysForRequiredFields));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_JVM_OVERLOADS, (String)"Add or not @JvmOverloads annotation for classes with properties with default values.", (boolean)this.jvmOverloads));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_JVM_RECORD, (String)"Add or not @JvmRecord annotation to data classes.", (boolean)this.jvmRecord));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_JAVA_COMPATIBILITY, (String)"Add or not @JvmField, @JvmStatic and @JvmRepeatable annotations to improve java compatibility", (boolean)this.javaCompatibility));
        CliOption testToolOption = new CliOption(OPT_TEST, "Specify which test tool to generate files for").defaultValue(this.testTool);
        HashMap<String, String> testToolOptionMap = new HashMap<String, String>();
        testToolOptionMap.put(OPT_TEST_JUNIT, "Use JUnit as test tool");
        testToolOption.setEnum(testToolOptionMap);
        this.cliOptions.add(testToolOption);
        CliOption generateSwaggerAnnotationsOption = new CliOption(OPT_GENERATE_SWAGGER_ANNOTATIONS, "Specify if you want to generate swagger annotations and which version").defaultValue(this.generateSwaggerAnnotations);
        HashMap<String, String> generateSwaggerAnnotationsOptionMap = new HashMap<String, String>();
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2, "Use io.swagger.core.v3:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE, "Equivalent to \"swagger2\"");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE, "Do not generate swagger annotations");
        generateSwaggerAnnotationsOption.setEnum(generateSwaggerAnnotationsOptionMap);
        this.cliOptions.add(generateSwaggerAnnotationsOption);
        this.cliOptions.add(new CliOption(OPT_DATE_FORMAT, "Specify the format pattern of date as a string"));
        this.cliOptions.add(new CliOption(OPT_DATE_TIME_FORMAT, "Specify the format pattern of date-time as a string"));
        this.cliOptions.stream().filter(o -> o.getOpt().equals("dateLibrary")).findFirst().ifPresent(opt -> {
            HashMap<String, String> valuesEnum = new HashMap<String, String>();
            valuesEnum.put(OPT_DATE_LIBRARY_OFFSET_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_OFFSET_DATETIME));
            valuesEnum.put(OPT_DATE_LIBRARY_LOCAL_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_LOCAL_DATETIME));
            opt.setEnum(valuesEnum);
        });
        CliOption serializationLibraryOpt = CliOption.newString((String)"serializationLibrary", (String)"Serialization library for model");
        serializationLibraryOpt.defaultValue(SerializationLibraryKind.JACKSON.name());
        HashMap<String, String> serializationLibraryOptions = new HashMap<String, String>();
        serializationLibraryOptions.put(SerializationLibraryKind.JACKSON.name(), "Jackson as serialization library");
        serializationLibraryOptions.put(SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name(), "Use micronaut-serialization with Jackson annotations");
        serializationLibraryOpt.setEnum(serializationLibraryOptions);
        this.cliOptions.removeIf(opt -> opt.getOpt().equals("serializationLibrary"));
        this.cliOptions.add(serializationLibraryOpt);
        this.reservedWords.addAll(List.of("Client", "Format", "QueryValue", "QueryParam", "PathVariable", "Header", "Cookie", "Authorization", "Body", "Application"));
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("ByteArray", "ByteArray");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("binary", "ByteArray");
        this.typeMapping.put("AnyType", "Any");
        this.typeMapping.put("DateTime", "Instant");
        this.typeMapping.put("date-time", "Instant");
        this.typeMapping.put("date", "LocalDate");
        this.typeMapping.put("Date", "LocalDate");
        this.typeMapping.put("LocalDateTime", "LocalDateTime");
        this.typeMapping.put("OffsetDateTime", "OffsetDateTime");
        this.typeMapping.put("ZonedDateTime", "ZonedDateTime");
        this.typeMapping.put("LocalDate", "LocalDate");
        this.typeMapping.put("LocalTime", "LocalTime");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("UnsignedInteger", "Int");
        this.typeMapping.put("UnsignedLong", "Long");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "URI");
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("list", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("DateTime", "java.time.Instant");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("MultiValuesConverterFactory", "static io.micronaut.core.convert.converters.MultiValuesConverterFactory.*");
    }

    public void setGenerateHttpResponseAlways(boolean generateHttpResponseAlways) {
        this.generateHttpResponseAlways = generateHttpResponseAlways;
    }

    public void setGenerateHttpResponseWhereRequired(boolean generateHttpResponseWhereRequired) {
        this.generateHttpResponseWhereRequired = generateHttpResponseWhereRequired;
    }

    public void setGenerateControllerAsAbstract(boolean generateControllerAsAbstract) {
        this.generateControllerAsAbstract = generateControllerAsAbstract;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setCoroutines(boolean coroutines) {
        this.coroutines = coroutines;
    }

    public void setImplicitHeaders(boolean implicitHeaders) {
        this.implicitHeaders = implicitHeaders;
    }

    public void setImplicitHeadersRegex(String implicitHeadersRegex) {
        this.implicitHeadersRegex = implicitHeadersRegex;
    }

    public void setTestTool(String testTool) {
        this.testTool = testTool;
    }

    public void setArtifactId(String artifactId) {
        super.setArtifactId(artifactId);
        this.updateOption("artifactId", artifactId);
    }

    public void setModelPackage(String modelPackage) {
        super.setModelPackage(modelPackage);
        this.updateOption("modelPackage", modelPackage);
    }

    public void setApiPackage(String apiPackage) {
        super.setApiPackage(apiPackage);
        this.updateOption("apiPackage", apiPackage);
    }

    public void setPackageName(String packageName) {
        super.setPackageName(packageName);
        this.updateOption("invokerPackage", packageName);
        this.updateOption("packageName", packageName);
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setGenerateOperationOnlyForFirstTag(boolean generateOperationOnlyForFirstTag) {
        this.generateOperationOnlyForFirstTag = generateOperationOnlyForFirstTag;
    }

    public void setGenerateEnumConverters(boolean generateEnumConverters) {
        this.generateEnumConverters = generateEnumConverters;
    }

    public void setPlural(boolean plural) {
        this.plural = plural;
    }

    public void setFluxForArrays(boolean fluxForArrays) {
        this.fluxForArrays = fluxForArrays;
    }

    public void setGeneratedAnnotation(boolean generatedAnnotation) {
        this.generatedAnnotation = generatedAnnotation;
    }

    public void setKsp(boolean ksp) {
        this.ksp = ksp;
    }

    public void processOpts() {
        if (this.additionalProperties.containsKey("additionalModelTypeAnnotations")) {
            this.setAdditionalModelTypeAnnotations(Utils.readListOfStringsProperty("additionalModelTypeAnnotations", this.additionalProperties));
            this.additionalProperties.remove("additionalModelTypeAnnotations");
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS)) {
            this.setAdditionalOneOfTypeAnnotations(Utils.readListOfStringsProperty(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS, this.additionalProperties));
            this.additionalProperties.remove(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS);
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_ENUM_TYPE_ANNOTATIONS)) {
            this.setAdditionalEnumTypeAnnotations(Utils.readListOfStringsProperty(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, this.additionalProperties));
            this.additionalProperties.remove(ADDITIONAL_ENUM_TYPE_ANNOTATIONS);
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_TITLE)) {
            this.title = (String)this.additionalProperties.get(OPT_TITLE);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.packageName = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.packageName);
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = (String)this.additionalProperties.get("apiPackage");
        } else {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = (String)this.additionalProperties.get("modelPackage");
        } else {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (this.additionalProperties.containsKey(OPT_APPLICATION_NAME)) {
            this.appName = (String)this.additionalProperties.get(OPT_APPLICATION_NAME);
        } else {
            this.additionalProperties.put(OPT_APPLICATION_NAME, this.artifactId);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.useBeanValidation = this.convertPropertyToBoolean("useBeanValidation");
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(OPT_GENERATE_ENUM_CONVERTERS)) {
            this.generateEnumConverters = this.convertPropertyToBoolean(OPT_GENERATE_ENUM_CONVERTERS);
        }
        this.writePropertyBack(OPT_GENERATE_ENUM_CONVERTERS, this.generateEnumConverters);
        if (this.additionalProperties.containsKey(OPT_USE_PLURAL)) {
            this.plural = this.convertPropertyToBoolean(OPT_USE_PLURAL);
        }
        this.writePropertyBack(OPT_USE_PLURAL, this.plural);
        if (this.additionalProperties.containsKey(OPT_FLUX_FOR_ARRAYS)) {
            this.fluxForArrays = this.convertPropertyToBoolean(OPT_FLUX_FOR_ARRAYS);
        }
        this.writePropertyBack(OPT_FLUX_FOR_ARRAYS, this.fluxForArrays);
        if (this.additionalProperties.containsKey(OPT_USE_ENUM_CASE_INSENSITIVE)) {
            this.useEnumCaseInsensitive = this.convertPropertyToBoolean(OPT_USE_ENUM_CASE_INSENSITIVE);
        }
        this.writePropertyBack(OPT_USE_ENUM_CASE_INSENSITIVE, this.useEnumCaseInsensitive);
        if (this.additionalProperties.containsKey(OPT_JVM_OVERLOADS)) {
            this.jvmOverloads = this.convertPropertyToBoolean(OPT_JVM_OVERLOADS);
        }
        this.writePropertyBack(OPT_JVM_OVERLOADS, this.jvmOverloads);
        if (this.additionalProperties.containsKey(OPT_JVM_RECORD)) {
            this.jvmRecord = this.convertPropertyToBoolean(OPT_JVM_RECORD);
        }
        this.writePropertyBack(OPT_JVM_RECORD, this.jvmRecord);
        if (this.additionalProperties.containsKey(OPT_JAVA_COMPATIBILITY)) {
            this.javaCompatibility = this.convertPropertyToBoolean(OPT_JAVA_COMPATIBILITY);
        }
        this.writePropertyBack(OPT_JAVA_COMPATIBILITY, this.javaCompatibility);
        if (this.additionalProperties.containsKey(OPT_GENERATED_ANNOTATION)) {
            this.generatedAnnotation = this.convertPropertyToBoolean(OPT_GENERATED_ANNOTATION);
        }
        this.writePropertyBack(OPT_GENERATED_ANNOTATION, this.generatedAnnotation);
        if (this.additionalProperties.containsKey(OPT_KSP)) {
            this.ksp = this.convertPropertyToBoolean(OPT_KSP);
        }
        this.writePropertyBack(OPT_KSP, this.ksp);
        if (this.additionalProperties.containsKey(OPT_USE_TAGS)) {
            this.useTags = this.convertPropertyToBoolean(OPT_USE_TAGS);
        }
        this.writePropertyBack(OPT_USE_TAGS, this.useTags);
        if (this.additionalProperties.containsKey(OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS)) {
            this.jsonIncludeAlwaysForRequiredFields = this.convertPropertyToBoolean(OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS);
        }
        this.writePropertyBack(OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS, this.jsonIncludeAlwaysForRequiredFields);
        if (this.additionalProperties.containsKey(OPT_VISITABLE)) {
            this.visitable = this.convertPropertyToBoolean(OPT_VISITABLE);
        }
        this.writePropertyBack(OPT_VISITABLE, this.visitable);
        if (this.additionalProperties.containsKey(OPT_COROUTINES)) {
            this.coroutines = this.convertPropertyToBoolean(OPT_COROUTINES);
        }
        this.writePropertyBack(OPT_COROUTINES, this.coroutines);
        if (this.coroutines) {
            this.reactive = false;
            this.writePropertyBack(OPT_REACTIVE, false);
        } else {
            if (this.additionalProperties.containsKey(OPT_REACTIVE)) {
                this.reactive = this.convertPropertyToBoolean(OPT_REACTIVE);
            }
            this.writePropertyBack(OPT_REACTIVE, this.reactive);
        }
        if (this.additionalProperties.containsKey(OPT_DATE_FORMAT)) {
            this.dateFormat = (String)this.additionalProperties.get(OPT_DATE_FORMAT);
        }
        this.writePropertyBack(OPT_DATE_FORMAT, this.dateFormat);
        if (this.additionalProperties.containsKey(OPT_DATE_TIME_FORMAT)) {
            this.dateTimeFormat = (String)this.additionalProperties.get(OPT_DATE_TIME_FORMAT);
        }
        this.writePropertyBack(OPT_DATE_TIME_FORMAT, this.dateTimeFormat);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_ALWAYS)) {
            this.generateHttpResponseAlways = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_ALWAYS);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_ALWAYS, this.generateHttpResponseAlways);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED)) {
            this.generateHttpResponseWhereRequired = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, this.generateHttpResponseWhereRequired);
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_AS_ABSTRACT)) {
            this.generateControllerAsAbstract = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_AS_ABSTRACT);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_AS_ABSTRACT, this.generateControllerAsAbstract);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG)) {
            this.generateOperationOnlyForFirstTag = this.convertPropertyToBoolean(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, this.generateOperationOnlyForFirstTag);
        if (this.additionalProperties.containsKey("useJakartaEe")) {
            this.setUseJakartaEe(this.convertPropertyToBoolean("useJakartaEe"));
        }
        this.writePropertyBack("useJakartaEe", this.useJakartaEe);
        this.writePropertyBack("javaxPackage", this.useJakartaEe ? "jakarta" : "javax");
        this.maybeSetTestTool();
        this.writePropertyBack(OPT_TEST, this.testTool);
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.additionalProperties.put("isTestJunit", true);
        }
        this.convertPropertyToBooleanAndWriteBack(OPT_IMPLICIT_HEADERS, this::setImplicitHeaders);
        this.convertPropertyToStringAndWriteBack(OPT_IMPLICIT_HEADERS_REGEX, this::setImplicitHeadersRegex);
        this.maybeSetSwagger();
        if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
        }
        this.additionalProperties.put(this.serializationLibrary.toLowerCase(Locale.US), true);
        if (SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name().equals(this.serializationLibrary)) {
            this.additionalProperties.put(SerializationLibraryKind.JACKSON.name().toLowerCase(Locale.US), true);
        }
        switch (this.dateLibrary) {
            case "OFFSET_DATETIME": {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.typeMapping.put("date-time", "OffsetDateTime");
                this.typeMapping.put("date", "LocalDate");
                this.importMapping.put("DateTime", "java.time.OffsetDateTime");
                this.importMapping.put("date-time", "java.time.OffsetDateTime");
                this.importMapping.put("date", "java.time.LocalDate");
                break;
            }
            case "ZONED_DATETIME": {
                this.typeMapping.put("DateTime", "ZonedDateTime");
                this.typeMapping.put("date-time", "ZonedDateTime");
                this.typeMapping.put("date", "LocalDate");
                this.importMapping.put("DateTime", "java.time.ZonedDateTime");
                this.importMapping.put("date-time", "java.time.ZonedDateTime");
                this.importMapping.put("date", "java.time.LocalDate");
                break;
            }
            case "LOCAL_DATETIME": {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.typeMapping.put("date-time", "LocalDateTime");
                this.typeMapping.put("date", "LocalDate");
                this.importMapping.put("DateTime", "java.time.LocalDateTime");
                this.importMapping.put("date-time", "java.time.LocalDateTime");
                this.importMapping.put("date", "java.time.LocalDate");
                break;
            }
        }
        this.modelDocTemplateFiles.clear();
        this.modelDocTemplateFiles.put("common/doc/model_doc.mustache", ".md");
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("common/model/model.mustache", ".kt");
        this.modelTestTemplateFiles.clear();
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.modelTestTemplateFiles.put("common/test/model_test.mustache", ".kt");
        }
        String invokerFolder = (this.sourceFolder + "/" + this.packageName).replace(".", "/");
        String apiFolder = (this.sourceFolder + "/" + this.apiPackage()).replace('.', '/');
        String modelFolder = (this.sourceFolder + "/" + this.modelPackage()).replace('.', '/');
        this.additionalProperties.put("invokerFolder", invokerFolder);
        this.additionalProperties.put("resourceFolder", this.resourcesFolder);
        this.additionalProperties.put("apiFolder", apiFolder);
        this.additionalProperties.put("modelFolder", modelFolder);
        this.additionalProperties.put("formatNoEmptyLines", new Formatting.LineFormatter(0));
        this.additionalProperties.put("formatOneEmptyLine", new Formatting.LineFormatter(1));
        this.additionalProperties.put("formatSingleLine", new Formatting.SingleLineFormatter());
        this.additionalProperties.put("indent", new Formatting.IndentFormatter(4));
    }

    public void addParameterMappings(List<ParameterMapping> parameterMappings) {
        this.parameterMappings.addAll(parameterMappings);
    }

    public void addResponseBodyMappings(List<ResponseBodyMapping> responseBodyMappings) {
        this.responseBodyMappings.addAll(responseBodyMappings);
    }

    public void addSchemaMapping(Map<String, String> schemaMapping) {
        this.schemaMapping.putAll(schemaMapping);
    }

    public void addImportMapping(Map<String, String> importMapping) {
        this.importMapping.putAll(importMapping);
    }

    public void addNameMapping(Map<String, String> nameMapping) {
        this.nameMapping.putAll(nameMapping);
    }

    public void addTypeMapping(Map<String, String> typeMapping) {
        this.typeMapping.putAll(typeMapping);
    }

    public void addEnumNameMapping(Map<String, String> enumNameMapping) {
        this.enumNameMapping.putAll(enumNameMapping);
    }

    public void addModelNameMapping(Map<String, String> modelNameMapping) {
        this.modelNameMapping.putAll(modelNameMapping);
    }

    public void addInlineSchemaNameMapping(Map<String, String> inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping.putAll(inlineSchemaNameMapping);
    }

    public void addInlineSchemaOption(Map<String, String> inlineSchemaOption) {
        this.inlineSchemaOption.putAll(inlineSchemaOption);
    }

    public void addOpenapiNormalizer(Map<String, String> openapiNormalizer) {
        this.openapiNormalizer.putAll(openapiNormalizer);
    }

    private void maybeSetSwagger() {
        if (this.additionalProperties.containsKey(OPT_GENERATE_SWAGGER_ANNOTATIONS)) {
            String value;
            switch (value = String.valueOf(this.additionalProperties.get(OPT_GENERATE_SWAGGER_ANNOTATIONS))) {
                case "swagger2": 
                case "true": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
                    break;
                }
                case "false": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
                    break;
                }
                default: {
                    throw new RuntimeException("Value \"" + value + "\" for the generateSwaggerAnnotations parameter is unsupported or misspelled");
                }
            }
        }
    }

    private void maybeSetTestTool() {
        if (this.additionalProperties.containsKey(OPT_TEST)) {
            if (this.additionalProperties.get(OPT_TEST).equals(OPT_TEST_JUNIT)) {
                this.testTool = (String)this.additionalProperties.get(OPT_TEST);
            } else {
                throw new RuntimeException("Test tool \"" + this.additionalProperties.get(OPT_TEST) + "\" is not supported or misspelled.");
            }
        }
    }

    public String testFileFolder() {
        return (this.getOutputDir() + "/src/test/kotlin/").replace('/', File.separatorChar);
    }

    public abstract boolean isServer();

    public String apiTestFileFolder() {
        return this.testFileFolder() + this.apiPackage().replace(".", "/");
    }

    public String modelTestFileFolder() {
        return this.getOutputDir() + "/src/test/kotlin/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setVisitable(boolean visitable) {
        this.visitable = visitable;
    }

    protected CodegenDiscriminator createDiscriminator(String schemaName, Schema schema) {
        Object type;
        CodegenDiscriminator discriminator = super.createDiscriminator(schemaName, schema);
        if (discriminator == null) {
            return null;
        }
        if (discriminator.getMapping() != null) {
            for (Map.Entry entry : discriminator.getMapping().entrySet()) {
                if (((String)entry.getValue()).indexOf(47) < 0) continue;
                String name = ModelUtils.getSimpleRef((String)((String)entry.getValue()));
                Schema referencedSchema = ModelUtils.getSchema((OpenAPI)this.openAPI, (String)name);
                if (referencedSchema == null) {
                    OnceLogger.once((Logger)this.log).error("Failed to lookup the schema '{}' when processing the discriminator mapping of oneOf/anyOf. Please check to ensure it's defined properly.", (Object)name);
                    continue;
                }
                if (referencedSchema.getProperties() == null || referencedSchema.getProperties().isEmpty()) continue;
                boolean isDiscriminatorPropTypeFound = false;
                Map props = referencedSchema.getProperties();
                for (Map.Entry propEntry : props.entrySet()) {
                    if (!((String)propEntry.getKey()).equals(discriminator.getPropertyName())) continue;
                    discriminator.setPropertyType(this.getTypeDeclaration((Schema)propEntry.getValue()));
                    isDiscriminatorPropTypeFound = true;
                    break;
                }
                if (!isDiscriminatorPropTypeFound) continue;
                break;
            }
        }
        if ((type = discriminator.getPropertyType()) != null) {
            if (!((String)type).endsWith("?")) {
                type = (String)type + "?";
            }
            discriminator.setPropertyType((String)type);
        }
        return discriminator;
    }

    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public String sanitizeTag(String tag) {
        return tag;
    }

    public String superSanitizeTag(String tag) {
        if (((String)(tag = StringUtils.camelize((String)StringUtils.underscore((String)this.sanitizeName((String)tag))))).matches("^\\d.*")) {
            tag = "Class" + (String)tag;
        }
        return tag;
    }

    public String toApiName(String name) {
        return Utils.toApiName(name, this.apiNamePrefix, this.apiNameSuffix);
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (!this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.isEmpty()) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            basePath = super.sanitizeTag(basePath);
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
            return;
        }
        if (this.generateOperationOnlyForFirstTag && !((Tag)co.tags.get(0)).getName().equals(tag)) {
            return;
        }
        super.addOperationToGroup(this.superSanitizeTag(tag), resourcePath, operation, co, operations);
    }

    public void preprocessOpenAPI(OpenAPI openApi) {
        if (openApi.getPaths() != null) {
            for (PathItem path : openApi.getPaths().values()) {
                if (path.getParameters() == null || path.getParameters().isEmpty()) continue;
                for (Operation op : path.readOperations()) {
                    if (op.getParameters() == null) {
                        op.setParameters(new ArrayList());
                    }
                    for (Parameter parameter : path.getParameters()) {
                        boolean found = false;
                        for (Parameter opParam : op.getParameters()) {
                            if (!Objects.equals(opParam.getName(), parameter.getName()) || !Objects.equals(opParam.get$ref(), parameter.get$ref())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        op.getParameters().add(parameter);
                    }
                }
            }
        }
        MicronautInlineModelResolver inlineModelResolver = new MicronautInlineModelResolver(openApi);
        inlineModelResolver.setInlineSchemaNameMapping(this.inlineSchemaNameMapping);
        inlineModelResolver.setInlineSchemaOptions(this.inlineSchemaOption);
        inlineModelResolver.flatten();
        Paths pathItems = openApi.getPaths();
        if (pathItems != null) {
            for (Map.Entry pathEntry : pathItems.entrySet()) {
                for (Map.Entry entry : ((PathItem)pathEntry.getValue()).readOperationsMap().entrySet()) {
                    if (((Operation)entry.getValue()).getResponses() == null) continue;
                    for (Map.Entry responseEntry : ((Operation)entry.getValue()).getResponses().entrySet()) {
                        ApiResponse response = (ApiResponse)responseEntry.getValue();
                        ApiResponse refResponse = ModelUtils.getReferencedApiResponse((OpenAPI)openApi, (ApiResponse)response);
                        if (response.getContent() == null) {
                            response.setContent(refResponse.getContent());
                        }
                        if (response.getDescription() == null) {
                            response.setDescription(refResponse.getDescription());
                        }
                        if (response.getHeaders() == null || response.getHeaders().isEmpty()) {
                            response.setHeaders(refResponse.getHeaders());
                        }
                        if (response.getExtensions() == null || response.getExtensions().isEmpty()) {
                            response.setExtensions(refResponse.getExtensions());
                        }
                        if (response.getLinks() != null && !response.getLinks().isEmpty()) continue;
                        response.setLinks(refResponse.getLinks());
                    }
                }
            }
        }
        super.preprocessOpenAPI(openApi);
        if (openApi.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openApi.getPaths().entrySet()) {
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                List list = path.readOperations();
                if (list == null || list.isEmpty()) continue;
                for (Operation operation : list) {
                    this.log.info("Processing operation {}", (Object)operation.getOperationId());
                    if (this.hasBodyParameter(operation) || this.hasFormParameter(operation)) {
                        String defaultContentType = this.hasFormParameter(operation) ? CONTENT_TYPE_APPLICATION_FORM_URLENCODED : CONTENT_TYPE_APPLICATION_JSON;
                        ArrayList consumes = new ArrayList(AbstractMicronautKotlinCodegen.getConsumesInfo((OpenAPI)openApi, (Operation)operation));
                        String contentType = consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                        operation.addExtension(VendorExtension.X_CONTENT_TYPE.getName(), (Object)contentType);
                    }
                    String[] accepts = this.getAccepts(openApi, operation);
                    operation.addExtension(VendorExtension.X_ACCEPTS.getName(), (Object)accepts);
                }
            }
        }
    }

    private String[] getAccepts(OpenAPI openAPIArg, Operation operation) {
        Set producesInfo = AbstractMicronautKotlinCodegen.getProducesInfo((OpenAPI)openAPIArg, (Operation)operation);
        if (producesInfo != null && !producesInfo.isEmpty()) {
            return producesInfo.toArray(new String[0]);
        }
        return new String[]{CONTENT_TYPE_APPLICATION_JSON};
    }

    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map<String, CodegenModel> models = allModels.stream().map(ModelMap::getModel).collect(Collectors.toMap(v -> v.classname, v -> v));
        OperationMap operations = objs.getOperations();
        List operationList = operations.getOperation();
        boolean needToAddImportFormat = false;
        HashMap<String, Integer> converterCounters = new HashMap<String, Integer>();
        ArrayList<CodegenParameter> enumParams = new ArrayList<CodegenParameter>();
        ArrayList<CallSite> enumImports = new ArrayList<CallSite>();
        for (CodegenOperation op : operationList) {
            this.handleImplicitHeaders(op);
            this.handleConstantParams(op);
            op.vendorExtensions.put("methodAllowsBody", op.httpMethod.equals("PUT") || op.httpMethod.equals("POST") || op.httpMethod.equals("PATCH") || op.httpMethod.equals("OPTIONS") || op.httpMethod.equals("DELETE"));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)op.notes)) {
                op.notes = op.notes.strip();
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)op.summary)) {
                op.summary = op.summary.strip();
            }
            Utils.normalizeExtraAnnotations("x-operation-extra-annotation", true, op.vendorExtensions);
            if (op.returnType != null) {
                String example;
                if (models.containsKey(op.returnType)) {
                    CodegenModel m = models.get(op.returnType);
                    List allowableValues = null;
                    if (m.allowableValues != null && m.allowableValues.containsKey("values")) {
                        allowableValues = (List)m.allowableValues.get("values");
                    }
                    example = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, false);
                } else {
                    example = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, false);
                }
                op.vendorExtensions.put("example", example);
            }
            if (CONTENT_TYPE_ANY.equals(op.vendorExtensions.get(VendorExtension.X_CONTENT_TYPE.getName()))) {
                op.vendorExtensions.put(VendorExtension.X_CONTENT_TYPE.getName(), CONTENT_TYPE_APPLICATION_JSON);
            }
            op.consumes = op.consumes == null ? null : op.consumes.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            List list = op.produces = op.produces == null ? null : op.produces.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            if (op.consumes == null || op.consumes.isEmpty() || op.consumes.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.consumes.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultConsumeOrEmpty", true);
            }
            if (op.produces == null || op.produces.isEmpty() || op.produces.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.produces.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultProduceOrEmpty", true);
            }
            if (CONTENT_TYPE_APPLICATION_FORM_URLENCODED.equals(op.vendorExtensions.get(VendorExtension.X_CONTENT_TYPE.getName()))) {
                op.formParams.addAll(op.bodyParams);
                op.bodyParams.forEach(p -> {
                    p.isBodyParam = false;
                    p.isFormParam = true;
                });
                op.bodyParams.clear();
            } else if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(op.vendorExtensions.get(VendorExtension.X_CONTENT_TYPE.getName()))) {
                op.bodyParams.addAll(op.formParams);
                for (CodegenParameter param : op.allParams) {
                    if (!param.isFormParam) continue;
                    param.isBodyParam = true;
                    param.isFormParam = false;
                    param.vendorExtensions.put("isPart", true);
                }
                op.formParams.forEach(p -> {
                    p.isBodyParam = true;
                    p.isFormParam = false;
                    p.vendorExtensions.put("isPart", true);
                });
                op.formParams.clear();
            }
            for (CodegenParameter param : op.allParams) {
                if (param.isEnumRef) {
                    param.isEnum = true;
                }
                Utils.processGenericAnnotations(param, this.useBeanValidation, false, param.isNullable || !param.required, param.required, false, true, this.ksp);
                param.vendorExtensions.put("isString", "string".equalsIgnoreCase(param.dataType));
                param.vendorExtensions.put("withoutExample", param.example == null || param.example.equals("null"));
                if (this.useBeanValidation && (!param.isContainer && param.isModel || param.getIsArray() && param.getComplexType() != null && models.containsKey(param.getComplexType()))) {
                    param.vendorExtensions.put("withValid", true);
                }
                if (Utils.isDateType(param.dataType)) {
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)param.pattern)) {
                        param.vendorExtensions.put("formatPattern", param.pattern);
                        param.pattern = null;
                    }
                    param.minItems = null;
                    param.maxItems = null;
                    param.minLength = null;
                    param.maxLength = null;
                }
                String paramDefaultValueInit = (String)param.vendorExtensions.get("defaultValueInit");
                param.vendorExtensions.put("valueWithDefaultValue", this.ksp && paramDefaultValueInit != null && !paramDefaultValueInit.equals("null"));
                String queryValueFormat = Utils.calcQueryValueFormat(param);
                if (queryValueFormat != null) {
                    needToAddImportFormat = true;
                    param.vendorExtensions.put("format", queryValueFormat);
                }
                if (!param.isEnum || param.isBodyParam) continue;
                String converterName = param.dataType;
                boolean alreadyAdded = false;
                for (CodegenParameter enumParam : enumParams) {
                    if (!param.dataType.equals(enumParam.dataType)) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                Integer counter = (Integer)converterCounters.get(converterName);
                if (counter == null) {
                    converterCounters.put(converterName, 0);
                } else {
                    converterCounters.put(converterName, counter + 1);
                }
                param.vendorExtensions.put("converterName", converterName + (Serializable)(counter != null ? counter : ""));
                enumParams.add(param);
                enumImports.add((CallSite)((Object)(this.modelPackage + "." + param.dataType)));
            }
            this.additionalProperties.put("enumImports", enumImports);
            this.additionalProperties.put("enumParams", enumParams);
            if (op.returnProperty == null) continue;
            Utils.processGenericAnnotations(op.returnProperty, this.useBeanValidation, false, false, false, false, false, this.ksp);
            op.returnType = op.returnProperty.vendorExtensions.get("typeWithEnumWithGenericAnnotations").toString();
        }
        if (needToAddImportFormat) {
            objs.getImports().add(Map.of("import", "io.micronaut.core.convert.converters.MultiValuesConverterFactory.*", "classname", "MultiValuesConverterFactory"));
        }
        return objs;
    }

    protected void handleImplicitHeaders(CodegenOperation operation) {
        if (operation.allParams.isEmpty()) {
            return;
        }
        ArrayList copy = new ArrayList(operation.allParams);
        operation.allParams.clear();
        for (CodegenParameter p : copy) {
            if (p.isHeaderParam && (this.implicitHeaders || this.shouldBeImplicitHeader(p))) {
                operation.implicitHeadersParams.add(p);
                operation.headerParams.removeIf(header -> header.baseName.equals(p.baseName));
                OnceLogger.once((Logger)this.log).info("Update operation [{}]. Remove header [{}] because it's marked to be implicit", (Object)operation.operationId, (Object)p.baseName);
                continue;
            }
            operation.allParams.add(p);
        }
        operation.hasParams = !operation.allParams.isEmpty();
    }

    private boolean shouldBeImplicitHeader(CodegenParameter parameter) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.implicitHeadersRegex) && parameter.baseName.matches(this.implicitHeadersRegex);
    }

    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype) || "Int".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "L";
        }
        if ("Float".equals(datatype)) {
            return value + "F";
        }
        if ("BigDecimal".equals(datatype)) {
            return "BigDecimal(\"" + value + "\")";
        }
        if ("URI".equals(datatype)) {
            return "URI.create(\"" + this.escapeText(value) + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    private void checkPrimitives(IJsonSchemaValidationProperties obj, Schema schema) {
        String schemaType;
        String format;
        boolean isFloat;
        boolean isLong;
        boolean isInteger;
        boolean isShort;
        boolean isNumber;
        boolean isNumeric;
        String dataTypeWithEnum;
        String dataType;
        Map extMap;
        if (obj == null) {
            return;
        }
        CodegenModel model = null;
        CodegenParameter param = null;
        CodegenProperty prop = null;
        CodegenResponse response = null;
        if (obj instanceof CodegenModel) {
            CodegenModel m;
            model = m = (CodegenModel)obj;
        } else if (obj instanceof CodegenProperty) {
            CodegenProperty p;
            prop = p = (CodegenProperty)obj;
        } else if (obj instanceof CodegenParameter) {
            CodegenParameter p;
            param = p = (CodegenParameter)obj;
        } else if (obj instanceof CodegenResponse) {
            CodegenResponse r;
            response = r = (CodegenResponse)obj;
        }
        Map map = model != null ? model.vendorExtensions : (param != null ? param.vendorExtensions : (extMap = prop != null ? prop.vendorExtensions : response.vendorExtensions));
        String string = model != null ? model.dataType : (param != null ? param.dataType : (dataType = prop != null ? prop.dataType : response.dataType));
        String string2 = param != null ? param.datatypeWithEnum : (dataTypeWithEnum = prop != null ? prop.datatypeWithEnum : null);
        if (schema == null) {
            extMap.put("baseType", dataType);
            return;
        }
        boolean bl = model != null ? model.isNumeric : (param != null ? param.isNumeric : (isNumeric = prop != null ? prop.isNumeric : response.isNumeric));
        boolean bl2 = model != null ? model.isNumber : (param != null ? param.isNumber : (isNumber = prop != null ? prop.isNumber : response.isNumber));
        boolean bl3 = model != null ? model.isShort : (param != null ? param.isShort : (isShort = prop != null ? prop.isShort : response.isShort));
        boolean bl4 = model != null ? model.isInteger : (param != null ? param.isInteger : (isInteger = prop != null ? prop.isInteger : response.isInteger));
        boolean bl5 = model != null ? model.isLong : (param != null ? param.isLong : (isLong = prop != null ? prop.isLong : response.isLong));
        boolean bl6 = model != null ? model.isFloat : (param != null ? param.isFloat : (isFloat = prop != null ? prop.isFloat : response.isFloat));
        boolean isDouble = model != null ? model.isDouble : (param != null ? param.isDouble : (prop != null ? prop.isDouble : response.isDouble));
        Map extensions = schema.getExtensions();
        String string3 = format = extensions != null ? (String)extensions.get("x-format") : null;
        if (format == null) {
            format = schema.getFormat() == null ? "object" : schema.getFormat();
        }
        String string4 = schemaType = extensions != null ? (String)extensions.get("x-type") : null;
        if (schemaType == null) {
            schemaType = schema.getType() == null ? "object" : schema.getType();
        }
        String baseType = dataType;
        if ("char".equals(schemaType) || "character".equals(schemaType)) {
            baseType = "char";
            dataType = "Char";
            dataTypeWithEnum = "Char";
        } else if ("byte".equals(schemaType)) {
            baseType = "byte";
            dataType = "Byte";
            dataTypeWithEnum = "Byte";
            isNumeric = true;
            isNumber = true;
            isInteger = true;
        } else if ("integer".equals(schemaType) && ("int8".equals(format) || "byte".equals(format))) {
            baseType = "Byte";
            dataType = "Byte";
            dataTypeWithEnum = "Byte";
            isNumeric = true;
            isNumber = true;
            isInteger = true;
        } else if ("short".equals(schemaType)) {
            baseType = "short";
            dataType = "Short";
            dataTypeWithEnum = "Short";
            isNumeric = true;
            isNumber = true;
            isShort = true;
        } else if ("integer".equals(schemaType) && ("int16".equals(format) || "short".equals(format))) {
            baseType = "Short";
            dataType = "Short";
            dataTypeWithEnum = "Short";
            isNumeric = true;
            isNumber = true;
            isShort = true;
        } else if ("int".equals(schemaType)) {
            baseType = "int";
            dataType = "Int";
            dataTypeWithEnum = "Int";
            isNumeric = true;
            isNumber = true;
            isInteger = true;
        } else if ("long".equals(schemaType)) {
            baseType = "long";
            dataType = "Long";
            dataTypeWithEnum = "Long";
            isNumeric = true;
            isNumber = true;
            isLong = true;
        } else if ("float".equals(schemaType)) {
            baseType = "float";
            dataType = "Float";
            dataTypeWithEnum = "Float";
            isNumeric = true;
            isNumber = true;
            isFloat = true;
        } else if ("double".equals(schemaType)) {
            baseType = "double";
            dataType = "Double";
            dataTypeWithEnum = "Double";
            isNumeric = true;
            isNumber = true;
            isDouble = true;
        }
        extMap.put("baseType", baseType);
        extMap.put("isPrimitive", false);
        if (model != null) {
            model.dataType = dataType;
            model.isNumeric = isNumeric;
            model.isNumber = isNumber;
            model.isShort = isShort;
            model.isInteger = isInteger;
            model.isLong = isLong;
            model.isFloat = isFloat;
            model.isDouble = isDouble;
        } else if (prop != null) {
            prop.dataType = dataType;
            prop.datatypeWithEnum = dataTypeWithEnum;
            prop.isNumeric = isNumeric;
            prop.isNumber = isNumber;
            prop.isShort = isShort;
            prop.isInteger = isInteger;
            prop.isLong = isLong;
            prop.isFloat = isFloat;
            prop.isDouble = isDouble;
        } else if (param != null) {
            param.dataType = dataType;
            param.datatypeWithEnum = dataTypeWithEnum;
            param.isNumeric = isNumeric;
            param.isNumber = isNumber;
            param.isShort = isShort;
            param.isInteger = isInteger;
            param.isLong = isLong;
            param.isFloat = isFloat;
            param.isDouble = isDouble;
        } else {
            response.dataType = dataType;
            response.isNumeric = isNumeric;
            response.isNumber = isNumber;
            response.isShort = isShort;
            response.isInteger = isInteger;
            response.isLong = isLong;
            response.isFloat = isFloat;
            response.isDouble = isDouble;
        }
    }

    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel model = super.fromModel(name, schema);
        this.checkPrimitives((IJsonSchemaValidationProperties)model, this.unaliasSchema(schema));
        if (!model.oneOf.isEmpty()) {
            if (this.useOneOfInterfaces) {
                model.vendorExtensions.put("x-is-one-of-interface", true);
            }
            if (ModelUtils.isTypeObjectSchema((Schema)schema)) {
                CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
                this.updateModelForObject(m, schema);
                model.vars = m.vars;
                model.allVars = m.allVars;
                model.requiredVars = m.requiredVars;
                model.readWriteVars = m.readWriteVars;
                model.optionalVars = m.optionalVars;
                model.readOnlyVars = m.readOnlyVars;
                model.parentVars = m.parentVars;
                model.nonNullableVars = m.nonNullableVars;
                model.setRequiredVarsMap(m.getRequiredVarsMap());
                model.mandatory = m.mandatory;
                model.allMandatory = m.allMandatory;
            }
        }
        model.imports.remove("ApiModel");
        model.imports.remove("ApiModelProperty");
        if (this.importMapping.containsKey(model.dataType) && !model.imports.contains(model.dataType)) {
            model.imports.add(model.dataType);
        }
        this.allModels.put(name, model);
        return model;
    }

    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = this.unaliasSchema(p);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema((Schema)target)) {
            Schema items = ModelUtils.getSchemaItems((Schema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema((Schema)target)) {
            Schema inner = ModelUtils.getAdditionalProperties((Schema)target);
            if (inner == null) {
                this.log.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return this.getTypeDeclarationSuper(target);
    }

    private String getTypeDeclarationSuper(Schema schema) {
        if (schema == null) {
            return "NULL_SCHEMA_ERR";
        }
        String oasType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(oasType)) {
            return (String)this.typeMapping.get(oasType);
        }
        return oasType;
    }

    public String getSchemaType(Schema p) {
        String openAPIType = this.getSchemaTypeSuper(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        String type = openAPIType;
        return this.toModelName(type);
    }

    private String getSchemaTypeSuper(Schema schema) {
        if (ModelUtils.isComposedSchema((Schema)schema)) {
            List schemas = ModelUtils.getInterfaces((Schema)schema);
            ArrayList<String> names = new ArrayList<String>();
            for (Schema s : schemas) {
                names.add(this.getSingleSchemaType(s));
            }
            if (schema.getAllOf() != null) {
                return this.toAllOfName(names, schema);
            }
            if (schema.getAnyOf() != null) {
                return this.toAnyOfName(names, schema);
            }
            if (schema.getOneOf() != null) {
                return this.toOneOfName(names, schema);
            }
        }
        return this.getSingleSchemaType(schema);
    }

    public String toModelName(String name) {
        String camelizedName;
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        String origName = name;
        if (this.schemaKeyToModelNameCache.containsKey(origName)) {
            return this.schemaKeyToModelNameCache.get(origName);
        }
        String sanitizedName = name.replace(".", "").replace("-", "_").replace("`", "");
        Object nameWithPrefixSuffix = this.normalizeKotlinSpecificNames(sanitizedName);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            this.schemaKeyToModelNameCache.put(origName, modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.schemaKeyToModelNameCache.put(origName, modelName);
            return modelName;
        }
        this.schemaKeyToModelNameCache.put(origName, this.firstTitleCase(camelizedName));
        return camelizedName;
    }

    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter rqBody = super.fromRequestBody(body, imports, bodyParameterName);
        Schema rqBodySchema = body.getContent() != null && !body.getContent().isEmpty() ? ((MediaType)((Map.Entry)body.getContent().entrySet().iterator().next()).getValue()).getSchema() : null;
        CodegenProperty codegenProperty = this.fromProperty(bodyParameterName, rqBodySchema, false);
        if (rqBodySchema != null) {
            rqBodySchema = this.unaliasSchema(rqBodySchema);
            boolean isRequiredBody = body.getRequired() != null && body.getRequired() != false;
            codegenProperty = this.getUseInlineModelResolver() ? this.fromProperty(bodyParameterName, this.getReferencedSchemaWhenNotEnum(rqBodySchema), isRequiredBody) : this.fromProperty(bodyParameterName, rqBodySchema, isRequiredBody);
            rqBody.setSchema(codegenProperty);
        }
        if (Boolean.TRUE.equals(codegenProperty.isModel)) {
            rqBody.isModel = true;
        }
        rqBody.dataFormat = codegenProperty.dataFormat;
        if (body.getRequired() != null) {
            rqBody.required = body.getRequired();
        }
        if (!rqBody.required) {
            rqBody.vendorExtensions.put("defaultValueInit", "null");
        } else {
            codegenProperty.isNullable = false;
            rqBody.isNullable = false;
        }
        rqBody.containerType = codegenProperty.containerType;
        rqBody.containerTypeMapped = codegenProperty.containerTypeMapped;
        this.updateCodegenPropertyEnum(codegenProperty);
        rqBody.isEnum = codegenProperty.isEnum;
        rqBody.isEnumRef = codegenProperty.isEnumRef;
        rqBody._enum = codegenProperty._enum;
        rqBody.allowableValues = codegenProperty.allowableValues;
        if (codegenProperty.isEnum || codegenProperty.isEnumRef) {
            rqBody.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            rqBody.enumName = codegenProperty.enumName;
            if (codegenProperty.defaultValue != null) {
                rqBody.enumDefaultValue = codegenProperty.defaultValue.replace(codegenProperty.enumName + ".", "");
            }
        }
        return rqBody;
    }

    private Schema getReferencedSchemaWhenNotEnum(Schema parameterSchema) {
        Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)parameterSchema);
        if (referencedSchema.getEnum() != null && !referencedSchema.getEnum().isEmpty()) {
            referencedSchema = parameterSchema;
        }
        return referencedSchema;
    }

    public CodegenParameter fromParameter(Parameter p, Set<String> imports) {
        String enumVarName;
        CodegenProperty items;
        Schema parameterSchema;
        CodegenParameter parameter = super.fromParameter(p, imports);
        if (parameter.isPathParam && !parameter.required) {
            parameter.required = true;
        }
        this.checkPrimitives((IJsonSchemaValidationProperties)parameter, this.unaliasSchema(p.getSchema()));
        String realName = parameter.paramName;
        if (realName.contains("`")) {
            realName = realName.replace("`", "");
        }
        parameter.vendorExtensions.put("realName", realName);
        if (p.getSchema() != null) {
            parameterSchema = this.unaliasSchema(p.getSchema());
        } else if (p.getContent() != null) {
            Content content = p.getContent();
            if (content.size() > 1) {
                OnceLogger.once((Logger)this.log).warn("Multiple schemas found in content, returning only the first one");
            }
            Map.Entry entry = (Map.Entry)content.entrySet().iterator().next();
            parameterSchema = ((MediaType)entry.getValue()).getSchema();
        } else {
            parameterSchema = null;
        }
        if (parameterSchema != null && parameterSchema.get$ref() != null) {
            parameterSchema = (Schema)this.openAPI.getComponents().getSchemas().get(parameterSchema.get$ref().substring("#/components/schemas/".length()));
        }
        Object defaultValueInit = (items = parameter.items) == null ? (String)this.calcDefaultValues(null, null, false, parameterSchema).getLeft() : (String)this.calcDefaultValues(items.datatypeWithEnum, items.dataType, items.getIsEnumOrRef(), parameterSchema).getLeft();
        if (parameterSchema != null && ModelUtils.isEnumSchema((Schema)parameterSchema) && (enumVarName = this.toEnumVarName(parameter.defaultValue, parameter.dataType)) != null) {
            defaultValueInit = parameter.dataType + "." + enumVarName;
        }
        if (defaultValueInit == null && !parameter.required) {
            defaultValueInit = "null";
        }
        if (defaultValueInit != null) {
            if (this.ksp && !((String)defaultValueInit).equals("null")) {
                parameter.isNullable = false;
            }
            parameter.vendorExtensions.put("defaultValueInit", defaultValueInit);
            parameter.vendorExtensions.put("defaultValueIsNotNull", !((String)defaultValueInit).equals("null"));
        }
        Utils.addStrValueToEnum(parameter.items);
        return parameter;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse resp = super.fromResponse(responseCode, response);
        this.checkPrimitives((IJsonSchemaValidationProperties)resp, (Schema)resp.schema);
        return resp;
    }

    public List<CodegenParameter> fromRequestBodyToFormParameters(RequestBody body, Set<String> imports) {
        List params = super.fromRequestBodyToFormParameters(body, imports);
        for (CodegenParameter param : params) {
            if (!param.required || !"null".equals(param.vendorExtensions.get("defaultValueInit"))) continue;
            param.vendorExtensions.put("defaultValueInit", null);
        }
        return params;
    }

    public CodegenProperty fromProperty(String name, Schema schema, boolean required, boolean schemaIsFromAdditionalProperties) {
        String enumVarName;
        CodegenProperty items;
        CodegenProperty property = super.fromProperty(name, schema, required, schemaIsFromAdditionalProperties);
        this.checkPrimitives((IJsonSchemaValidationProperties)property, this.unaliasSchema(schema));
        String realName = property.name;
        if (realName.contains("`")) {
            realName = realName.replace("`", "");
            property.nameInPascalCase = StringUtils.camelize((String)realName);
            property.nameInCamelCase = StringUtils.camelize((String)realName, (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_LETTER);
            property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInCamelCase);
        }
        property.vendorExtensions.put("realName", realName);
        if (schema != null && schema.get$ref() != null) {
            Schema refSchema = ModelUtils.getSchemaFromRefToSchemaWithProperties((OpenAPI)this.openAPI, (String)schema.get$ref());
            if (refSchema == null) {
                refSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)schema);
            }
            schema = refSchema;
        }
        Object defaultValueInit = (items = property.items) == null ? (String)this.calcDefaultValues(null, null, false, schema).getLeft() : (String)this.calcDefaultValues(items.datatypeWithEnum, items.dataType, items.getIsEnumOrRef(), schema).getLeft();
        if (schema != null && ModelUtils.isEnumSchema((Schema)schema) && (enumVarName = this.toEnumVarName(property.defaultValue, property.dataType)) != null) {
            defaultValueInit = property.dataType + "." + enumVarName;
        }
        if (defaultValueInit == null && (property.isDiscriminator || property.isNullable || property.required && property.isReadOnly || !property.required)) {
            defaultValueInit = "null";
        }
        if (defaultValueInit != null) {
            property.vendorExtensions.put("defaultValueInit", defaultValueInit);
        }
        return property;
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (op.isResponseFile) {
            op.returnType = (String)this.typeMapping.get("responseFile");
            op.imports.add(op.returnType);
        }
        ArrayList<CodegenParameter> paramsWithoutImplicitHeaders = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> swaggerParams = new ArrayList<CodegenParameter>();
        boolean hasMultipleParams = false;
        int notBodyParamsSize = 0;
        for (CodegenParameter param : op.allParams) {
            if (!param.isHeaderParam || !this.implicitHeaders && !this.shouldBeImplicitHeader(param)) {
                param.vendorExtensions.computeIfAbsent("realName", k -> param.paramName);
                paramsWithoutImplicitHeaders.add(param);
            }
            if (param.isBodyParam || param.isFormParam) continue;
            swaggerParams.add(param);
            if (++notBodyParamsSize <= 1) continue;
            hasMultipleParams = true;
        }
        op.vendorExtensions.put("swaggerParams", swaggerParams);
        op.vendorExtensions.put("originalParams", paramsWithoutImplicitHeaders);
        op.vendorExtensions.put("hasNotBodyParam", notBodyParamsSize > 0);
        op.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
        for (CodegenParameter param : op.allParams) {
            param.vendorExtensions.put("hasNotBodyParam", notBodyParamsSize > 0);
            param.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
        }
        op.vendorExtensions.put("originReturnProperty", op.returnProperty);
        if (op.responses != null && !op.responses.isEmpty()) {
            for (CodegenResponse resp : op.responses) {
                if (!resp.isDefault) continue;
                resp.code = "default";
            }
        }
        this.processParametersWithAdditionalMappings(op.allParams, op.imports);
        this.processWithResponseBodyMapping(op);
        this.processOperationWithResponseWrappers(op);
        return op;
    }

    public String toEnumVarName(String value, String datatype) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            String modified = "EMPTY";
            return this.normalizeKotlinSpecificNames(modified);
        }
        Object varName = value;
        if ("Int".equalsIgnoreCase(datatype) || "Byte".equalsIgnoreCase(datatype) || "Short".equalsIgnoreCase(datatype) || "Integer".equalsIgnoreCase(datatype) || "Long".equalsIgnoreCase(datatype) || "Float".equalsIgnoreCase(datatype) || "Double".equalsIgnoreCase(datatype) || "BigDecimal".equals(datatype)) {
            varName = "NUMBER_" + (String)varName;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
        }
        if (" ".equals(varName = ((String)varName).replaceAll("[^a-zA-Z0-9_]", "_"))) {
            return "SPACE";
        }
        return super.toEnumVarName((String)varName, datatype);
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private void processParametersWithAdditionalMappings(List<CodegenParameter> params, Set<String> imports) {
        LinkedHashMap<String, ParameterMapping> additionalMappings = new LinkedHashMap<String, ParameterMapping>();
        Iterator<CodegenParameter> iter = params.iterator();
        while (iter.hasNext()) {
            CodegenParameter param = iter.next();
            boolean paramWasMapped = false;
            for (ParameterMapping mapping : this.parameterMappings) {
                if (!mapping.doesMatch(param)) continue;
                additionalMappings.put(mapping.mappedName(), mapping);
                paramWasMapped = true;
            }
            if (paramWasMapped) {
                iter.remove();
                continue;
            }
            if (!this.plural || !param.isArray || !param.isBodyParam || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.getRef()) || "requestBody".equals(param.paramName)) continue;
            param.paramName = English.plural((String)param.paramName);
        }
        for (ParameterMapping mapping : additionalMappings.values()) {
            String typeName;
            if (mapping.mappedType() == null) continue;
            CodegenParameter newParam = new CodegenParameter();
            newParam.paramName = mapping.mappedName();
            newParam.required = true;
            newParam.isModel = mapping.isValidated();
            newParam.dataType = typeName = this.makeSureImported(mapping.mappedType(), imports);
            if (newParam.paramName == null) {
                newParam.paramName = this.toParamName(typeName);
            }
            params.add(newParam);
        }
    }

    private void processWithResponseBodyMapping(CodegenOperation op) {
        ResponseBodyMapping bodyMapping = null;
        Iterator iter = op.responseHeaders.iterator();
        while (iter.hasNext()) {
            CodegenProperty header = (CodegenProperty)iter.next();
            boolean headerWasMapped = false;
            for (ResponseBodyMapping mapping : this.responseBodyMappings) {
                if (!mapping.doesMatch(header.baseName, op.isArray)) continue;
                if (mapping.mappedBodyType() != null) {
                    bodyMapping = mapping;
                }
                headerWasMapped = true;
            }
            if (!headerWasMapped) continue;
            iter.remove();
        }
        if (bodyMapping != null) {
            this.wrapOperationReturnType(op, bodyMapping.mappedBodyType(), bodyMapping.isValidated(), bodyMapping.isListWrapper());
        }
    }

    private void wrapOperationReturnType(CodegenOperation op, String wrapperType, boolean isValidated, boolean isListWrapper) {
        CodegenProperty newReturnType = new CodegenProperty();
        newReturnType.required = true;
        newReturnType.isModel = isValidated;
        String typeName = this.makeSureImported(wrapperType, op.imports);
        if ((isListWrapper || this.fluxForArrays) && op.isArray && op.returnProperty.items != null) {
            if (this.fluxForArrays && wrapperType.equals(MONO_CLASS_NAME)) {
                typeName = this.makeSureImported(FLUX_CLASS_NAME, op.imports);
                op.vendorExtensions.put("isReturnFlux", true);
            }
            String originalReturnType = op.returnBaseType;
            newReturnType.dataType = typeName + "<" + op.returnBaseType + ">";
            newReturnType.items = op.returnProperty.items;
        } else {
            String originalReturnType = op.returnType;
            if (originalReturnType == null) {
                originalReturnType = "Void";
                op.returnProperty = new CodegenProperty();
                op.returnProperty.dataType = "Void";
            }
            newReturnType.dataType = typeName + "<" + originalReturnType + ">";
            newReturnType.items = op.returnProperty;
        }
        op.returnType = newReturnType.dataType;
        op.returnContainer = null;
        op.returnProperty = newReturnType;
        op.isArray = op.returnProperty.isArray;
    }

    private void processOperationWithResponseWrappers(CodegenOperation op) {
        boolean requiresHttpResponse;
        boolean hasNon200StatusCodes = op.responses.stream().anyMatch(response -> !"200".equals(response.code) && response.code.startsWith("2"));
        boolean hasNonMappedHeaders = !op.responseHeaders.isEmpty();
        boolean bl = requiresHttpResponse = hasNon200StatusCodes || hasNonMappedHeaders;
        if (this.generateHttpResponseAlways || this.generateHttpResponseWhereRequired && requiresHttpResponse) {
            this.wrapOperationReturnType(op, "io.micronaut.http.HttpResponse", false, false);
        }
        if (this.reactive) {
            this.wrapOperationReturnType(op, MONO_CLASS_NAME, false, false);
        }
    }

    private String makeSureImported(String typeName, Set<String> imports) {
        int firstCapitalIndex = 0;
        for (int i = 0; i < typeName.length(); ++i) {
            if (!Character.isUpperCase(typeName.charAt(i))) continue;
            firstCapitalIndex = i;
            break;
        }
        if (firstCapitalIndex != 0) {
            String dataType = typeName.substring(firstCapitalIndex);
            this.importMapping.put(dataType, typeName);
            typeName = dataType;
        }
        imports.add(typeName);
        return typeName;
    }

    public String toVarName(String name) {
        Object varName = super.toVarName(name);
        if (((String)varName).chars().allMatch(c -> Character.isUpperCase(c) || c == 95)) {
            return varName;
        }
        if (((String)varName).length() >= 2 && Character.isLowerCase(((String)varName).charAt(0)) && Character.isUpperCase(((String)varName).charAt(1))) {
            varName = "" + ((String)varName).charAt(0) + Character.toLowerCase(((String)varName).charAt(1)) + ((String)varName).substring(2);
        }
        return varName;
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        List<Object> requiredParentVarsWithoutDiscriminator;
        List<Object> requiredVarsWithoutDiscriminator;
        CodegenModel model;
        objs = super.postProcessAllModels(objs);
        if (!this.additionalOneOfTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                Map models2 = (Map)objs.get(modelName);
                models2.put(ADDITIONAL_ONE_OF_TYPE_ANNOTATIONS, this.additionalOneOfTypeAnnotations);
            }
        }
        if (!this.additionalEnumTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                Object models = (Map)objs.get(modelName);
                models.put(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, this.additionalEnumTypeAnnotations);
            }
        }
        boolean isServer = this.isServer();
        for (Object models : objs.values()) {
            model = ((ModelMap)models.getModels().get(0)).getModel();
            requiredVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            requiredParentVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> allVars = new ArrayList<CodegenProperty>();
            this.processParentModel(model, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars, false, objs);
            model.allVars = allVars;
            boolean withInheritance = model.hasChildren || model.parent != null;
            model.vendorExtensions.put("withInheritance", withInheritance);
            ArrayList<CodegenProperty> optionalVars = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> arrayList = new ArrayList<CodegenProperty>();
            for (CodegenProperty codegenProperty : model.vars) {
                codegenProperty.vendorExtensions.put("hasChildren", model.hasChildren);
                if (!this.notContainsProp(codegenProperty, requiredVarsWithoutDiscriminator) || !model.hasChildren || codegenProperty.required) {
                    if (!this.notContainsProp(codegenProperty, arrayList)) continue;
                    arrayList.add(codegenProperty);
                    continue;
                }
                if (!this.notContainsProp(codegenProperty, optionalVars)) continue;
                optionalVars.add(codegenProperty);
            }
            model.vendorExtensions.put("hasOwnVars", !model.vars.isEmpty());
            model.vendorExtensions.put("withMultipleVars", model.vars.size() > 1);
            if (!((ArrayList)requiredParentVarsWithoutDiscriminator).isEmpty()) {
                model.vendorExtensions.put("requiredParentVarsWithoutDiscriminator", requiredParentVarsWithoutDiscriminator);
            }
            model.vendorExtensions.put("requiredVarsWithoutDiscriminator", requiredVarsWithoutDiscriminator);
            model.vendorExtensions.put("requiredVars", arrayList);
            model.vendorExtensions.put("withRequiredOrOptionalVars", !((ArrayList)requiredVarsWithoutDiscriminator).isEmpty() || !optionalVars.isEmpty());
            model.vendorExtensions.put("optionalVars", optionalVars);
            model.vendorExtensions.put("serialId", this.random.nextLong());
            model.vendorExtensions.put("withRequiredVars", !model.requiredVars.isEmpty());
            Utils.normalizeExtraAnnotations("x-class-extra-annotation", true, model.vendorExtensions);
            if (model.discriminator != null) {
                model.vendorExtensions.put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
                model.discriminator.getVendorExtensions().put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
            }
            for (CodegenProperty codegenProperty : model.vars) {
                this.processProperty(codegenProperty, isServer, model, objs);
            }
            for (CodegenProperty codegenProperty : model.requiredVars) {
                this.processProperty(codegenProperty, isServer, model, objs);
            }
            if (model.parentVars != null) {
                for (CodegenProperty codegenProperty : model.parentVars) {
                    this.processProperty(codegenProperty, isServer, model, objs);
                    this.removePropIfContains(codegenProperty, optionalVars);
                }
            }
            for (CodegenProperty codegenProperty : requiredParentVarsWithoutDiscriminator) {
                CodegenProperty codegenProperty2 = this.findProp(codegenProperty, requiredVarsWithoutDiscriminator);
                if (codegenProperty2 == null) continue;
                boolean isParentVar = !this.isParentOneOfInterface(model);
                codegenProperty2.vendorExtensions.put("isParentVar", isParentVar);
                if (!isParentVar) continue;
                codegenProperty2.vendorExtensions.put("fieldAnnPrefix", "");
            }
            boolean bl = model.hasVars = !((ArrayList)requiredVarsWithoutDiscriminator).isEmpty() || withInheritance && !optionalVars.isEmpty();
            if (System.getProperty("micronaut.test.no-vars") != null) {
                model.hasVars = false;
                model.vendorExtensions.put("hasOwnVars", false);
                model.vendorExtensions.put("requiredVarsWithoutDiscriminator", Collections.emptyList());
                model.vendorExtensions.put("optionalVars", Collections.emptyList());
                model.vendorExtensions.put("requiredVars", Collections.emptyList());
                model.vendorExtensions.put("withRequiredVars", false);
                model.vars = Collections.emptyList();
            }
            boolean isDataClass = !model.hasChildren && model.hasVars && (!withInheritance || model.parentVars.isEmpty());
            model.vendorExtensions.put("dataClass", isDataClass ? "data " : "");
            model.vendorExtensions.put("isDataClass", isDataClass);
            Utils.addStrValueToEnum(model);
        }
        for (Object models : objs.values()) {
            model = ((ModelMap)models.getModels().get(0)).getModel();
            this.processOneOfModels(model, objs.values());
        }
        for (Object models : objs.values()) {
            model = ((ModelMap)models.getModels().get(0)).getModel();
            requiredVarsWithoutDiscriminator = (List)model.vendorExtensions.get("requiredVarsWithoutDiscriminator");
            requiredParentVarsWithoutDiscriminator = (List)model.vendorExtensions.get("requiredParentVarsWithoutDiscriminator");
            List optionalVars = (List)model.vendorExtensions.get("optionalVars");
            Boolean withInheritance = (Boolean)model.vendorExtensions.get("withInheritance");
            if (!withInheritance.booleanValue()) continue;
            for (CodegenProperty codegenProperty : requiredVarsWithoutDiscriminator) {
                CodegenModel parent = model.parentModel;
                boolean bl = codegenProperty.vendorExtensions.getOrDefault("isParentVar", false);
                if (!bl || parent == null) continue;
                for (CodegenProperty pVar : (List)parent.vendorExtensions.get("requiredVarsWithoutDiscriminator")) {
                    String type1;
                    if (!pVar.name.equals(codegenProperty.name) || !pVar.isNullable || codegenProperty.isNullable) continue;
                    codegenProperty.isNullable = true;
                    String type = codegenProperty.vendorExtensions.get("typeWithGenericAnnotations").toString();
                    if (!type.endsWith("?")) {
                        codegenProperty.vendorExtensions.put("typeWithGenericAnnotations", type + "?");
                    }
                    if ((type1 = codegenProperty.vendorExtensions.get("typeWithEnumWithGenericAnnotations").toString()).endsWith("?")) continue;
                    codegenProperty.vendorExtensions.put("typeWithEnumWithGenericAnnotations", type1 + "?");
                }
            }
            for (CodegenProperty codegenProperty : optionalVars) {
                boolean found = false;
                for (CodegenProperty codegenProperty3 : requiredVarsWithoutDiscriminator) {
                    if (!codegenProperty.name.equals(codegenProperty3.name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                requiredVarsWithoutDiscriminator.add(codegenProperty);
            }
        }
        for (Object models : objs.values()) {
            model = ((ModelMap)models.getModels().get(0)).getModel();
            List props = (List)model.vendorExtensions.get("requiredVarsWithoutDiscriminator");
            if (props == null || props.isEmpty()) continue;
            for (CodegenProperty prop : props) {
                Object defaultValueInit = prop.vendorExtensions.get("defaultValueInit");
                if (defaultValueInit != null && !defaultValueInit.toString().isEmpty()) {
                    model.vendorExtensions.put("hasDefaultValues", true);
                }
                prop.vendorExtensions.put("isDataClass", model.vendorExtensions.get("isDataClass"));
            }
        }
        return objs;
    }

    protected void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String dataType) {
        super.updateEnumVarsWithExtensions(enumVars, vendorExtensions, dataType);
        if (vendorExtensions == null) {
            return;
        }
        List xDeprecated = (List)vendorExtensions.get("x-deprecated");
        if (xDeprecated != null && !xDeprecated.isEmpty()) {
            for (Object deprecatedItem : xDeprecated) {
                Map<String, Object> foundEnumVar = null;
                for (Map<String, Object> enumVar : enumVars) {
                    boolean isString = (Boolean)enumVar.get("isString");
                    Object value = (String)enumVar.get("value");
                    if (!isString) {
                        String upperValue;
                        int argPos;
                        if (((String)value).startsWith("(short)")) {
                            value = ((String)value).replace("(short) ", "");
                        }
                        if ((argPos = ((String)value).indexOf(40)) >= 0) {
                            value = ((String)value).substring(argPos + 1, ((String)value).indexOf(41));
                        }
                        if ((upperValue = ((String)value).toUpperCase(Locale.ENGLISH)).endsWith("F") || upperValue.endsWith("L") || upperValue.endsWith("D")) {
                            value = ((String)value).substring(0, ((String)value).length() - 1);
                        }
                        if (!((String)value).contains("'")) {
                            value = ((String)value).replace("'", "");
                        }
                        if (!((String)value).contains("\"")) {
                            value = "\"" + (String)value + "\"";
                        }
                    }
                    if (!((String)value).equals("\"" + deprecatedItem + "\"")) continue;
                    foundEnumVar = enumVar;
                    break;
                }
                if (foundEnumVar == null) continue;
                foundEnumVar.put("deprecated", true);
            }
        }
        String baseType = (String)vendorExtensions.get("baseType");
        for (Map<String, Object> enumVar : enumVars) {
            if (((Boolean)enumVar.get("isString")).booleanValue()) continue;
            String value = (String)enumVar.get("value");
            value = value.replace("\"", "");
            if ("char".equals(baseType) && !value.startsWith("'")) {
                enumVar.put("value", "'" + value + "'");
                continue;
            }
            if ("short".equalsIgnoreCase(baseType)) {
                enumVar.put("value", value);
                continue;
            }
            if (!"byte".equalsIgnoreCase(baseType)) continue;
            enumVar.put("value", value);
        }
    }

    private boolean isParentOneOfInterface(CodegenModel model) {
        boolean parentIsOneOfInterface;
        CodegenModel parentModel = model.parentModel;
        boolean bl = parentIsOneOfInterface = parentModel != null && Boolean.TRUE.equals(parentModel.getVendorExtensions().get("x-is-one-of-interface"));
        if (!parentIsOneOfInterface && model.interfaceModels != null) {
            for (CodegenModel interfaceModel : model.interfaceModels) {
                if (!Boolean.TRUE.equals(interfaceModel.getVendorExtensions().get("x-is-one-of-interface"))) continue;
                parentIsOneOfInterface = true;
                break;
            }
        }
        return parentIsOneOfInterface;
    }

    private void processOneOfModels(CodegenModel model, Collection<ModelsMap> models) {
        if (!model.vendorExtensions.containsKey("x-is-one-of-interface") || !Boolean.parseBoolean(model.vendorExtensions.get("x-is-one-of-interface").toString())) {
            return;
        }
        CodegenDiscriminator discriminator = model.discriminator;
        if (discriminator == null) {
            return;
        }
        String oneOfInterfaceName = model.name;
        for (ModelsMap modelMap : models) {
            Object xImplements;
            CodegenModel m = ((ModelMap)modelMap.getModels().get(0)).getModel();
            if (!m.vendorExtensions.containsKey("x-implements") || !((xImplements = m.vendorExtensions.get("x-implements")) instanceof List)) continue;
            List xImplementsList = (List)xImplements;
            for (Object implInterface : xImplementsList) {
                ArrayList properties;
                if (!oneOfInterfaceName.equalsIgnoreCase(implInterface.toString())) continue;
                boolean discriminatorPropFound = false;
                for (Object prop : m.allVars) {
                    if (!((CodegenProperty)prop).name.equals(discriminator.getPropertyName())) continue;
                    ((CodegenProperty)prop).isDiscriminator = true;
                    ((CodegenProperty)prop).isOverridden = true;
                    ((CodegenProperty)prop).isNullable = true;
                    ((CodegenProperty)prop).isOptional = false;
                    ((CodegenProperty)prop).required = true;
                    ((CodegenProperty)prop).isReadOnly = false;
                    ((CodegenProperty)prop).vendorExtensions.put("typeWithEnumWithGenericAnnotations", discriminator.getPropertyType());
                    ((CodegenProperty)prop).vendorExtensions.put("overridden", true);
                    break;
                }
                if ((properties = (ArrayList)m.vendorExtensions.get("requiredVarsWithoutDiscriminator")) != null && !properties.isEmpty()) {
                    for (CodegenProperty prop : properties) {
                        if (!prop.name.equals(discriminator.getPropertyName())) continue;
                        prop.isDiscriminator = true;
                        prop.isOverridden = true;
                        prop.isNullable = true;
                        prop.isOptional = false;
                        prop.required = true;
                        prop.isReadOnly = false;
                        prop.vendorExtensions.put("typeWithEnumWithGenericAnnotations", discriminator.getPropertyType());
                        prop.vendorExtensions.put("overridden", true);
                        discriminatorPropFound = true;
                        break;
                    }
                }
                if (discriminatorPropFound) continue;
                CodegenProperty discriminatorProp = new CodegenProperty();
                discriminatorProp.name = discriminator.getPropertyName();
                discriminatorProp.baseName = discriminator.getPropertyName();
                discriminatorProp.dataType = discriminator.getPropertyType();
                discriminatorProp.vendorExtensions.put("typeWithEnumWithGenericAnnotations", discriminator.getPropertyType());
                discriminatorProp.isDiscriminator = true;
                discriminatorProp.isOverridden = true;
                discriminatorProp.isNullable = true;
                discriminatorProp.isOptional = false;
                discriminatorProp.required = true;
                discriminatorProp.isReadOnly = false;
                discriminatorProp.vendorExtensions.put("overridden", true);
                String realName = discriminatorProp.name;
                realName = realName.replaceFirst("_", "");
                discriminatorProp.nameInPascalCase = StringUtils.camelize((String)realName);
                discriminatorProp.nameInCamelCase = StringUtils.camelize((String)realName, (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_LETTER);
                discriminatorProp.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, discriminatorProp.nameInCamelCase);
                discriminatorProp.getter = "get" + this.getterAndSetterCapitalize(discriminatorProp.name);
                discriminatorProp.setter = "set" + this.getterAndSetterCapitalize(discriminatorProp.name);
                discriminatorProp.vendorExtensions.put("realName", realName);
                m.vars.add(discriminatorProp);
                m.allVars.add(discriminatorProp);
                m.vendorExtensions.put("withMultipleVars", true);
                ((ArrayList)m.vendorExtensions.get("requiredVarsWithoutDiscriminator")).add(discriminatorProp);
            }
        }
    }

    private void processProperty(CodegenProperty property, boolean isServer, CodegenModel model, Map<String, ModelsMap> models) {
        property.vendorExtensions.put("withRequiredAndOptionalVars", model.vendorExtensions.get("withRequiredAndOptionalVars"));
        property.vendorExtensions.put("inRequiredArgsConstructor", !property.isReadOnly || isServer);
        property.vendorExtensions.put("isServer", isServer);
        property.vendorExtensions.put("defaultValueIsNotNull", property.defaultValue != null && !property.defaultValue.equals("null"));
        Boolean isParentVar = (Boolean)property.vendorExtensions.get("isParentVar");
        property.vendorExtensions.put("fieldAnnPrefix", isParentVar != null && isParentVar != false ? "" : "field:");
        property.vendorExtensions.put("x-implements", model.vendorExtensions.get("x-implements"));
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (this.useBeanValidation && (!property.isContainer && property.isModel || property.getIsArray() && property.getComplexType() != null && models.containsKey(property.getComplexType()))) {
            property.vendorExtensions.put("withValid", true);
        }
        if (Utils.isDateType(property.dataType)) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)property.pattern)) {
                property.vendorExtensions.put("formatPattern", property.pattern);
                property.pattern = null;
            }
            property.minItems = null;
            property.maxItems = null;
            property.minLength = null;
            property.maxLength = null;
        }
        if (this.isDiscriminator(property, model)) {
            property.isDiscriminator = true;
        }
        Utils.processGenericAnnotations(property, this.useBeanValidation, false, property.isNullable || property.isDiscriminator, property.required, property.isReadOnly, true, this.ksp);
        Utils.normalizeExtraAnnotations("x-field-extra-annotation", true, property.vendorExtensions);
        Utils.normalizeExtraAnnotations("x-setter-extra-annotation", true, property.vendorExtensions);
        String defaultValueInit = (String)property.vendorExtensions.get("defaultValueInit");
        boolean valueWithDefaultValue = this.ksp && defaultValueInit != null && !defaultValueInit.equals("null");
        property.vendorExtensions.put("valueWithDefaultValue", valueWithDefaultValue);
        if (valueWithDefaultValue) {
            model.vendorExtensions.put("hasDefaultValues", true);
        }
    }

    private void processParentModel(CodegenModel model, List<CodegenProperty> requiredVarsWithoutDiscriminator, List<CodegenProperty> requiredParentVarsWithoutDiscriminator, List<CodegenProperty> allVars, boolean processParentModel, Map<String, ModelsMap> objs) {
        boolean parentIsOneOfInterface;
        CodegenModel parent = model.parentModel;
        boolean hasParent = parent != null;
        for (CodegenProperty variable : model.vars) {
            if (!this.notContainsProp(variable, allVars)) continue;
            allVars.add(variable.clone());
        }
        boolean bl = parentIsOneOfInterface = hasParent && Boolean.TRUE.equals(parent.getVendorExtensions().get("x-is-one-of-interface"));
        if (!processParentModel) {
            this.processVar(model, model.vars, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, processParentModel, objs);
        }
        this.processVar(model, model.vars, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, processParentModel, objs);
        this.requiredParentVarsWithoutDiscriminator(model, requiredParentVarsWithoutDiscriminator);
        if (hasParent) {
            model.parentVars = parent.allVars;
            this.processParentModel(parent, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars, true, objs);
        }
        if (parentIsOneOfInterface) {
            for (CodegenProperty variable : parent.vars) {
                if (!this.notContainsProp(variable, model.vars)) continue;
                if (parent.discriminator != null && parent.discriminator.getPropertyName().equals(variable.name)) {
                    variable.isDiscriminator = true;
                    variable.isOverridden = true;
                }
                model.vars.add(variable.clone());
            }
            for (CodegenProperty variable : parent.requiredVars) {
                if (!this.notContainsProp(variable, model.requiredVars)) continue;
                model.requiredVars.add(variable);
            }
            model.parentModel = null;
            model.parent = null;
            model.parentVars = null;
        }
    }

    private void processVar(CodegenModel model, List<CodegenProperty> vars, List<CodegenProperty> requiredVarsWithoutDiscriminator, List<CodegenProperty> requiredParentVarsWithoutDiscriminator, boolean processParentModel, Map<String, ModelsMap> objs) {
        CodegenModel parent = model.parentModel;
        boolean hasParent = parent != null;
        List parentRequiredVars = hasParent ? (List)parent.vendorExtensions.get("requiredVarsWithoutDiscriminator") : Collections.emptyList();
        boolean parentIsOneOfInterface = this.isParentOneOfInterface(model);
        boolean isParentVar = !parentIsOneOfInterface;
        for (CodegenProperty v : vars) {
            this.processProperty(v, this.isServer(), model, objs);
            if (this.notContainsProp(v, requiredVarsWithoutDiscriminator)) {
                CodegenProperty copyVar = v;
                boolean isDiscriminator = this.isDiscriminator(v, model);
                if (isDiscriminator) {
                    copyVar.isDiscriminator = true;
                }
                if (hasParent && !this.useOneOfInterfaces && !this.notContainsProp(v, parent.allVars) || v.isOverridden != null && !v.isOverridden.booleanValue() && !v.vendorExtensions.containsKey("overridden") && this.notContainsProp(v, vars)) {
                    copyVar = v.clone();
                    copyVar.vendorExtensions.put("isParentVar", isParentVar);
                    if (isParentVar) {
                        copyVar.vendorExtensions.put("fieldAnnPrefix", "");
                    }
                    if (isDiscriminator && !parentIsOneOfInterface) {
                        copyVar.isNullable = true;
                        copyVar.vendorExtensions.put("defaultValueInit", "null");
                    }
                    copyVar.isOverridden = true;
                    copyVar.vendorExtensions.put("overridden", true);
                }
                v.vendorExtensions.put("hasChildren", model.hasChildren);
                if (!hasParent || this.notContainsProp(v, parentRequiredVars) || parentIsOneOfInterface) {
                    if (processParentModel) {
                        copyVar = v.clone();
                        copyVar.isOverridden = true;
                        copyVar.vendorExtensions.put("isParentVar", isParentVar);
                    }
                    if (copyVar.isOverridden != null && copyVar.isOverridden.booleanValue() && (!parentIsOneOfInterface || isDiscriminator) && isDiscriminator && !parentIsOneOfInterface) {
                        copyVar.isNullable = true;
                        copyVar.vendorExtensions.put("defaultValueInit", "null");
                    }
                    requiredVarsWithoutDiscriminator.add(copyVar);
                }
            }
            if (this.isDiscriminator(v, model)) {
                v.isDiscriminator = true;
            }
            v.isNullable = !v.isDiscriminator && (v.isNullable || v.required && v.isReadOnly && this.isServer() || !v.required);
        }
    }

    private void requiredParentVarsWithoutDiscriminator(CodegenModel model, List<CodegenProperty> requiredParentVarsWithoutDiscriminator) {
        CodegenModel parent = model.parentModel;
        if (parent == null) {
            return;
        }
        boolean parentIsOneOfInterface = this.isParentOneOfInterface(model);
        boolean isParentVar = !parentIsOneOfInterface;
        for (CodegenProperty v : parent.vars) {
            if (this.isDiscriminator(v, model)) {
                v.isDiscriminator = true;
                if (!parentIsOneOfInterface) {
                    v.isNullable = true;
                    v.vendorExtensions.put("defaultValueInit", "null");
                }
            }
            v.vendorExtensions.put("isServerOrNotReadOnly", !v.isReadOnly || this.isServer());
            if (!this.notContainsProp(v, requiredParentVarsWithoutDiscriminator)) continue;
            CodegenProperty childVar = v.clone();
            if (!this.useOneOfInterfaces) {
                childVar.vendorExtensions.put("isParentVar", isParentVar);
                if (isParentVar) {
                    childVar.vendorExtensions.put("fieldAnnPrefix", "");
                }
            }
            requiredParentVarsWithoutDiscriminator.add(childVar);
        }
    }

    private void removePropIfContains(CodegenProperty prop, List<CodegenProperty> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        props.removeIf(p -> prop.name.equals(p.name));
    }

    private CodegenProperty findProp(CodegenProperty prop, List<CodegenProperty> props) {
        if (props == null || props.isEmpty()) {
            return null;
        }
        for (CodegenProperty p : props) {
            if (!prop.name.equals(p.name)) continue;
            return p;
        }
        return null;
    }

    private boolean notContainsProp(CodegenProperty prop, List<CodegenProperty> props) {
        if (props == null || props.isEmpty()) {
            return true;
        }
        for (CodegenProperty p : props) {
            if (!prop.name.equals(p.name)) continue;
            return false;
        }
        return true;
    }

    private boolean isDiscriminator(CodegenProperty prop, CodegenModel model) {
        boolean isDiscriminator = prop.isDiscriminator;
        if (isDiscriminator) {
            return true;
        }
        if (model.parentModel == null) {
            return false;
        }
        CodegenProperty parentProp = null;
        for (CodegenProperty pv : model.parentModel.allVars) {
            if (!pv.required || !pv.name.equals(prop.name)) continue;
            isDiscriminator = pv.isDiscriminator;
            parentProp = pv;
            break;
        }
        if (isDiscriminator) {
            return true;
        }
        return parentProp != null && this.isDiscriminator(parentProp, model.parentModel);
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
            return;
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            Example example = (Example)parameter.getExamples().values().iterator().next();
            if (example.getValue() != null) {
                codegenParameter.example = example.getValue().toString();
            }
        } else {
            Schema schema = parameter.getSchema();
            if (schema != null && schema.getExample() != null) {
                codegenParameter.example = schema.getExample().toString();
            }
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExampleValue(CodegenParameter p) {
        p.example = this.getParameterExampleValue(p);
    }

    protected String getParameterExampleValue(CodegenParameter p) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, p.requiredVars, false);
    }

    protected String getPropertyExampleValue(CodegenProperty p) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        CodegenModel model = this.allModels.get(p.getDataType());
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, model != null ? model.requiredVars : null, true);
    }

    private boolean withExample(String example) {
        return example != null && !example.equals("null");
    }

    public String getExampleValue(String defaultValue, String example, String dataType, Boolean isModel, List<Object> allowableValues, String itemsType, String itemsExample, List<CodegenProperty> requiredVars, boolean isProperty) {
        String containerType;
        example = defaultValue != null ? defaultValue : example;
        String string = containerType = dataType == null ? null : dataType.split("<")[0];
        if ("String".equals(dataType)) {
            example = this.withExample((String)example) ? "\"" + this.escapeText((String)example) + "\"" : "\"example\"";
        } else if ("Int".equals(dataType) || "Short".equals(dataType)) {
            example = this.withExample((String)example) ? example : "56";
        } else if ("Long".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(this.withExample((String)example) ? example : "56"), (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(this.withExample((String)example) ? example : "3.4"), (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(this.withExample((String)example) ? example : "3.4"), (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(dataType)) {
            example = this.withExample((String)example) ? example : OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
        } else if ("File".equals(dataType) || "java.io.File".equals(dataType)) {
            example = null;
        } else if ("OffsetDateTime".equals(dataType)) {
            example = "OffsetDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("LocalDate".equals(dataType)) {
            example = "LocalDate.of(2001, 2, 3)";
        } else if ("LocalDateTime".equals(dataType)) {
            example = "LocalDateTime.of(2001, 2, 3, 4, 5)";
        } else if ("ByteArray".equals(dataType)) {
            example = "ByteArray(10)";
        } else if ("BigDecimal".equals(dataType)) {
            example = "BigDecimal(\"78\")";
        } else if ("MultipartBody".equals(dataType)) {
            example = "MultipartBody.builder().build()";
        } else if (allowableValues != null && !allowableValues.isEmpty()) {
            Object value = example;
            if (value == null || !allowableValues.contains(value)) {
                value = allowableValues.get(0);
            }
            if (isProperty) {
                dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
            }
            example = dataType + ".fromValue(\"" + value + "\")";
        } else if (isModel != null && isModel.booleanValue() || isModel == null && !this.languageSpecificPrimitives.contains(dataType)) {
            if (requiredVars == null) {
                example = null;
            } else {
                StringBuilder builder = new StringBuilder();
                if (isProperty) {
                    dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
                }
                builder.append(dataType).append("(");
                for (int i = 0; i < requiredVars.size(); ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(this.getPropertyExampleValue(requiredVars.get(i)));
                }
                builder.append(")");
                example = builder.toString();
            }
        }
        if ("List".equals(containerType)) {
            Object innerExample;
            if ("String".equals(itemsType)) {
                itemsExample = itemsExample != null ? itemsExample : "example";
                innerExample = "\"" + this.escapeText(itemsExample) + "\"";
            } else {
                Object object = innerExample = itemsExample != null ? itemsExample : "";
            }
            example = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)innerExample) ? "listOf(" + (String)innerExample + ")" : "listOf<" + itemsType + ">()";
        } else if ("Set".equals(containerType)) {
            example = "HashSet<Any>()";
        } else if ("Map".equals(containerType)) {
            example = "HashMap<Any, Any>()";
        } else if (example == null) {
            example = "null";
        }
        return example;
    }

    public String toDefaultValue(CodegenProperty cp, Schema schema) {
        if (cp.items != null) {
            return (String)this.calcDefaultValues(cp.items.datatypeWithEnum, cp.items.dataType, cp.items.getIsEnumOrRef(), schema).getRight();
        }
        return (String)this.calcDefaultValues(null, null, false, schema).getRight();
    }

    private Pair<String, String> calcDefaultValues(String itemsDatatypeWithEnum, String itemsDataType, boolean itemsIsEnumOrRef, Schema schema) {
        Object defaultValueInit = null;
        String defaultValueStr = null;
        if (ModelUtils.isBooleanSchema((Schema)(schema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)schema)))) {
            if (schema.getDefault() != null) {
                defaultValueInit = schema.getDefault().toString();
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isDateSchema((Schema)schema)) {
            defaultValueInit = null;
            defaultValueStr = null;
        } else if (ModelUtils.isDateTimeSchema((Schema)schema)) {
            defaultValueInit = null;
            defaultValueStr = null;
        } else if (ModelUtils.isNumberSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = this.fixNumberValue(schema.getDefault().toString(), schema);
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isIntegerSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = this.fixNumberValue(schema.getDefault().toString(), schema);
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isURISchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = (String)this.importMapping.get("URI") + ".create(\"" + schema.getDefault() + "\")";
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isArraySchema((Schema)schema) && itemsDatatypeWithEnum != null) {
            Pair<String, String> pair = this.toArrayDefaultValue(itemsDatatypeWithEnum, itemsDataType, itemsIsEnumOrRef, schema);
            defaultValueInit = (String)pair.getLeft();
            defaultValueStr = (String)pair.getRight();
        } else if (ModelUtils.isStringSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                String def = schema.getDefault().toString();
                if (schema.getEnum() == null) {
                    defaultValueInit = "\"" + this.escapeText(def) + "\"";
                    defaultValueStr = this.escapeText(def);
                } else {
                    defaultValueInit = "\"" + def + "\"";
                    defaultValueStr = def;
                }
            }
        } else if (ModelUtils.isObjectSchema((Schema)schema) && schema.getDefault() != null) {
            defaultValueInit = super.toDefaultValue(schema);
            defaultValueStr = super.toDefaultValue(schema);
        }
        return Pair.of(defaultValueInit, defaultValueStr);
    }

    private String fixNumberValue(String number, Schema p) {
        if (ModelUtils.isFloatSchema((Schema)p)) {
            return number + "F";
        }
        if (ModelUtils.isDoubleSchema((Schema)p)) {
            if (number.contains(".")) {
                return number;
            }
            return number + ".0";
        }
        if (ModelUtils.isLongSchema((Schema)p)) {
            return number + "L";
        }
        return number;
    }

    private Pair<String, String> toArrayDefaultValue(String itemsDatatypeWithEnum, String itemsDataType, boolean itemsIsEnumOrRef, Schema schema) {
        if (schema.getDefault() != null) {
            ArrayNode defaultArrayNode;
            boolean isSet = ModelUtils.isSet((Schema)schema);
            String arrInstantiationType = isSet ? "set" : "arrayList";
            Object object = schema.getDefault();
            if (object instanceof String) {
                String strValue = (String)object;
                try {
                    defaultArrayNode = (ArrayNode)this.objectMapper.readValue(strValue, ArrayNode.class);
                }
                catch (Exception e) {
                    return Pair.of(null, null);
                }
            } else {
                Object object2 = schema.getDefault();
                if (!(object2 instanceof ArrayNode)) {
                    return Pair.of(null, null);
                }
                ArrayNode def = (ArrayNode)object2;
                defaultArrayNode = def;
            }
            if (defaultArrayNode.isEmpty()) {
                return Pair.of((Object)(arrInstantiationType + "Of()"), null);
            }
            StringBuilder defaultContent = new StringBuilder();
            StringBuilder defaultContentInit = new StringBuilder();
            Schema itemsSchema = ModelUtils.getSchemaItems((Schema)schema);
            defaultArrayNode.elements().forEachRemaining(element -> {
                String defaultValue = element.asText();
                if (defaultValue != null) {
                    if (itemsIsEnumOrRef) {
                        String className = itemsDatatypeWithEnum;
                        String enumVarName = this.toEnumVarName(defaultValue, itemsDataType);
                        if (enumVarName != null) {
                            defaultContent.append(className).append(".").append(enumVarName).append(",");
                            defaultContentInit.append(className).append(".").append(enumVarName).append(",");
                        } else {
                            defaultContent.append("null").append(",");
                            defaultContentInit.append("null").append(",");
                        }
                    } else {
                        itemsSchema.setDefault((Object)defaultValue);
                        defaultValue = (String)this.calcDefaultValues(itemsDatatypeWithEnum, itemsDataType, itemsIsEnumOrRef, itemsSchema).getRight();
                        defaultContent.append(defaultValue).append(",");
                        if ("string".equalsIgnoreCase(itemsDataType)) {
                            defaultContentInit.append('\"');
                        }
                        defaultContentInit.append(defaultValue);
                        if ("string".equalsIgnoreCase(itemsDataType)) {
                            defaultContentInit.append('\"');
                        }
                        defaultContentInit.append(",");
                    }
                }
            });
            defaultContent.deleteCharAt(defaultContent.length() - 1);
            defaultContentInit.deleteCharAt(defaultContentInit.length() - 1);
            return Pair.of((Object)(arrInstantiationType + "Of(" + defaultContentInit + ")"), (Object)defaultContent.toString());
        }
        return Pair.of(null, null);
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"replaceDotsWithUnderscore", (Object)new Formatting.ReplaceDotsWithUnderscoreLambda());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setSerializationLibrary(String serializationLibrary) {
        try {
            this.serializationLibrary = SerializationLibraryKind.valueOf(serializationLibrary).name();
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(serializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SerializationLibraryKind availableSerializationLibrary : SerializationLibraryKind.values()) {
                sb.append("\n  ").append(availableSerializationLibrary.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public void setDateTimeLibrary(String name) {
        this.dateLibrary = name;
    }

    private String normalizeKotlinSpecificNames(String name) {
        if (this.typeMapping.containsValue(name)) {
            return name;
        }
        Object word = name;
        for (Map.Entry<String, String> entry : this.specialCharReplacements.entrySet()) {
            word = this.replaceSpecCharacters((String)word, entry);
        }
        word = Pattern.compile("\\W+", 256).matcher((CharSequence)word).replaceAll("_");
        if (((String)word).matches("\\d.*")) {
            word = "_" + (String)word;
        }
        if (((String)word).matches("^_*$")) {
            word = ((String)word).replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    private String replaceSpecCharacters(String word, Map.Entry<String, String> specialCharacters) {
        String specialChar = specialCharacters.getKey();
        String replacementChar = specialCharacters.getValue();
        if (!specialChar.equals("_") && word.contains(specialChar)) {
            return this.replaceChars(word, specialChar, replacementChar);
        }
        return word;
    }

    private String replaceChars(String word, String oldValue, String newValue) {
        if (!word.contains(oldValue)) {
            return word;
        }
        if (word.equals(oldValue)) {
            return newValue;
        }
        int i = word.indexOf(oldValue);
        String start = word.substring(0, i);
        String end = this.recurseOnEndOfTheWord(word, oldValue, newValue, i);
        return start + newValue + end;
    }

    private String recurseOnEndOfTheWord(String word, String oldValue, String newValue, int lastReplacedValue) {
        String end = word.substring(lastReplacedValue + 1);
        if (!end.isEmpty()) {
            end = this.firstTitleCase(end);
            end = this.replaceChars(end, oldValue, newValue);
        }
        return end;
    }

    private String firstTitleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public void setUseOneOfInterfaces(Boolean useOneOfInterfaces) {
        super.setUseOneOfInterfaces(useOneOfInterfaces);
        this.additionalProperties.put("useOneOfInterfaces", useOneOfInterfaces);
    }

    public boolean getUseInlineModelResolver() {
        return false;
    }

    public void setGenerateSwaggerAnnotations(boolean generateSwaggerAnnotations) {
        this.generateSwaggerAnnotations = Boolean.toString(generateSwaggerAnnotations);
        if (generateSwaggerAnnotations) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
    }

    public void setJsonIncludeAlwaysForRequiredFields(boolean jsonIncludeAlwaysForRequiredFields) {
        this.jsonIncludeAlwaysForRequiredFields = jsonIncludeAlwaysForRequiredFields;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.additionalProperties.put(OPT_DATE_FORMAT, dateFormat);
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        this.additionalProperties.put(OPT_DATE_TIME_FORMAT, dateTimeFormat);
    }

    public void setUseEnumCaseInsensitive(boolean useEnumCaseInsensitive) {
        this.useEnumCaseInsensitive = useEnumCaseInsensitive;
    }

    public void setJvmOverloads(boolean jvmOverloads) {
        this.jvmOverloads = jvmOverloads;
    }

    public void setJvmRecord(boolean jvmRecord) {
        this.jvmRecord = jvmRecord;
    }

    public void setJavaCompatibility(boolean javaCompatibility) {
        this.javaCompatibility = javaCompatibility;
    }

    public void setAdditionalOneOfTypeAnnotations(List<String> additionalOneOfTypeAnnotations) {
        this.additionalOneOfTypeAnnotations = additionalOneOfTypeAnnotations;
    }

    public void setAdditionalEnumTypeAnnotations(List<String> additionalEnumTypeAnnotations) {
        this.additionalEnumTypeAnnotations = additionalEnumTypeAnnotations;
    }

    public void postProcess() {
    }
}

