/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerOptionsBuilder;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;

public class JavaMicronautServerCodegen
extends AbstractMicronautJavaCodegen<JavaMicronautServerOptionsBuilder> {
    public static final String OPT_CONTROLLER_PACKAGE = "controllerPackage";
    public static final String OPT_GENERATE_CONTROLLER_FROM_EXAMPLES = "generateControllerFromExamples";
    public static final String OPT_GENERATE_IMPLEMENTATION_FILES = "generateImplementationFiles";
    public static final String OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED = "generateOperationsToReturnNotImplemented";
    public static final String OPT_GENERATE_HARD_NULLABLE = "generateHardNullable";
    public static final String OPT_GENERATE_STREAMING_FILE_UPLOAD = "generateStreamingFileUpload";
    public static final String OPT_AOT = "aot";
    public static final String EXTENSION_ROLES = "x-roles";
    public static final String ANONYMOUS_ROLE_KEY = "isAnonymous()";
    public static final String ANONYMOUS_ROLE = "SecurityRule.IS_ANONYMOUS";
    public static final String AUTHORIZED_ROLE_KEY = "isAuthorized()";
    public static final String AUTHORIZED_ROLE = "SecurityRule.IS_AUTHENTICATED";
    public static final String DENY_ALL_ROLE_KEY = "denyAll()";
    public static final String DENY_ALL_ROLE = "SecurityRule.DENY_ALL";
    public static final String NAME = "java-micronaut-server";
    protected static final String CONTROLLER_PREFIX = "";
    protected static final String CONTROLLER_SUFFIX = "Controller";
    protected static final String API_PREFIX = "";
    protected static final String API_SUFFIX = "Api";
    protected String apiPackage = "org.openapitools.api";
    protected String controllerPackage = "org.openapitools.controller";
    protected boolean generateImplementationFiles = true;
    protected boolean generateOperationsToReturnNotImplemented = true;
    protected boolean generateControllerFromExamples;
    protected boolean useAuth = true;
    protected boolean generateHardNullable = true;
    protected boolean generateStreamingFileUpload;
    protected boolean aot;

    JavaMicronautServerCodegen() {
        this.title = "OpenAPI Micronaut Server";
        this.apiDocPath = "docs/controllers";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.additionalProperties.put("server", "true");
        this.cliOptions.add(new CliOption(OPT_CONTROLLER_PACKAGE, "The package in which api implementations (controllers) will be generated.").defaultValue(this.apiPackage));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, (String)"Generate the implementation of controller and tests from parameter and return examples that will verify that the api works as desired (for testing).", (boolean)this.generateControllerFromExamples));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_IMPLEMENTATION_FILES, (String)"Whether to generate controller implementations that need to be filled in.", (boolean)this.generateImplementationFiles));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, (String)"Return HTTP 501 Not Implemented instead of an empty response in the generated controller methods.", (boolean)this.generateOperationsToReturnNotImplemented));
        this.cliOptions.add(CliOption.newBoolean((String)"useAuth", (String)"Whether to import authorization and to annotate controller methods accordingly", (boolean)this.useAuth));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HARD_NULLABLE, (String)"Whether to generate and use an inherited nullable annotation", (boolean)this.generateHardNullable));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_STREAMING_FILE_UPLOAD, (String)"Whether to generate StreamingFileUpload type for file request body", (boolean)this.generateStreamingFileUpload));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_AOT, (String)"Generate compatible code with micronaut-aot", (boolean)this.aot));
        this.setApiNamePrefix("");
        this.setApiNameSuffix(API_SUFFIX);
        this.typeMapping.put("file", "CompletedFileUpload");
        this.importMapping.put("CompletedFileUpload", "io.micronaut.http.multipart.CompletedFileUpload");
        this.importMapping.put("StreamingFileUpload", "io.micronaut.http.multipart.StreamingFileUpload");
        this.typeMapping.put("responseFile", "FileCustomizableResponseType");
        this.importMapping.put("FileCustomizableResponseType", "io.micronaut.http.server.types.files.FileCustomizableResponseType");
        String resourceFolder = this.projectFolder + "/resources";
        this.supportingFiles.add(new SupportingFile("common/configuration/application.yml.mustache", resourceFolder, "application.yml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("common/configuration/logback.xml.mustache", resourceFolder, "logback.xml").doNotOverwrite());
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a Java Micronaut Server.";
    }

    public void setControllerPackage(String controllerPackage) {
        this.controllerPackage = controllerPackage;
    }

    public void setGenerateImplementationFiles(boolean generateImplementationFiles) {
        this.generateImplementationFiles = generateImplementationFiles;
    }

    public void setGenerateOperationsToReturnNotImplemented(boolean generateOperationsToReturnNotImplemented) {
        this.generateOperationsToReturnNotImplemented = generateOperationsToReturnNotImplemented;
    }

    public void setGenerateControllerFromExamples(boolean generateControllerFromExamples) {
        this.generateControllerFromExamples = generateControllerFromExamples;
    }

    public void setUseAuth(boolean useAuth) {
        this.useAuth = useAuth;
    }

    public void setAot(boolean aot) {
        this.aot = aot;
    }

    public void setGenerateStreamingFileUpload(boolean generateStreamingFileUpload) {
        this.generateStreamingFileUpload = generateStreamingFileUpload;
    }

    public void setGenerateHardNullable(boolean generateHardNullable) {
        this.generateHardNullable = generateHardNullable;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_GENERATE_IMPLEMENTATION_FILES)) {
            this.generateImplementationFiles = this.convertPropertyToBoolean(OPT_GENERATE_IMPLEMENTATION_FILES);
        }
        this.writePropertyBack(OPT_GENERATE_IMPLEMENTATION_FILES, this.generateImplementationFiles);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED)) {
            this.generateOperationsToReturnNotImplemented = this.convertPropertyToBoolean(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, this.generateOperationsToReturnNotImplemented);
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = (String)this.additionalProperties.get("apiPackage");
        }
        this.writePropertyBack("apiPackage", this.apiPackage);
        if (this.additionalProperties.containsKey(OPT_CONTROLLER_PACKAGE)) {
            this.controllerPackage = (String)this.additionalProperties.get(OPT_CONTROLLER_PACKAGE);
        }
        this.writePropertyBack(OPT_CONTROLLER_PACKAGE, this.controllerPackage);
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES)) {
            this.generateControllerFromExamples = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, this.generateControllerFromExamples);
        if (this.additionalProperties.containsKey("useAuth")) {
            this.useAuth = this.convertPropertyToBoolean("useAuth");
        }
        this.writePropertyBack("useAuth", this.useAuth);
        if (this.additionalProperties.containsKey(OPT_AOT)) {
            this.aot = this.convertPropertyToBoolean(OPT_AOT);
        }
        this.writePropertyBack(OPT_AOT, this.aot);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HARD_NULLABLE)) {
            this.generateHardNullable = this.convertPropertyToBoolean(OPT_GENERATE_HARD_NULLABLE);
        }
        this.writePropertyBack(OPT_GENERATE_HARD_NULLABLE, this.generateHardNullable);
        if (this.additionalProperties.containsKey(OPT_GENERATE_STREAMING_FILE_UPLOAD)) {
            this.generateStreamingFileUpload = this.convertPropertyToBoolean(OPT_GENERATE_STREAMING_FILE_UPLOAD);
        }
        this.writePropertyBack(OPT_GENERATE_STREAMING_FILE_UPLOAD, this.generateStreamingFileUpload);
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("server/controller-interface.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        if (this.generateImplementationFiles) {
            this.supportingFiles.add(new SupportingFile("server/doc/README.mustache", "", "README.md").doNotOverwrite());
            this.apiDocTemplateFiles.clear();
            this.apiDocTemplateFiles.put("server/doc/controller_doc.mustache", ".md");
            String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace('.', '/');
            this.supportingFiles.add(new SupportingFile("common/configuration/Application.mustache", invokerFolder, "Application.java").doNotOverwrite());
            this.apiTestTemplateFiles.put("server/controller-implementation.mustache", ".java");
            if (this.testTool.equals("junit")) {
                this.apiTestTemplateFiles.put("server/test/controller_test.mustache", ".java");
            } else if (this.testTool.equals("spock")) {
                this.apiTestTemplateFiles.put("server/test/controller_test.groovy.mustache", ".groovy");
            }
        }
        if (this.generateStreamingFileUpload) {
            this.typeMapping.put("file", "StreamingFileUpload");
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public String apiTestFileFolder() {
        return super.getOutputDir();
    }

    public String apiTestFilename(String templateName, String tag) {
        String controllerName = StringUtils.camelize((String)("_" + tag + "_Controller"));
        if (this.generateImplementationFiles && templateName.contains("controller-implementation")) {
            String implementationFolder = this.outputFolder + File.separator + this.sourceFolder + File.separator + this.controllerPackage.replace('.', File.separatorChar);
            return (implementationFolder + File.separator + controllerName + ".java").replace('/', File.separatorChar);
        }
        String suffix = (String)this.apiTestTemplateFiles().get(templateName);
        return super.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        super.setParameterExampleValue(p);
        if (p.isFile) {
            p.example = null;
        }
    }

    @Override
    public boolean isGenerateHardNullable() {
        return this.generateHardNullable;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        String controllerClassname = StringUtils.camelize((String)("_" + operations.getPathPrefix() + "_Controller"));
        objs.put((Object)"controllerClassname", (Object)controllerClassname);
        List allOperations = (List)operations.get((Object)"operation");
        if (this.useAuth) {
            for (CodegenOperation operation : allOperations) {
                List<Object> roles;
                if (!operation.vendorExtensions.containsKey(EXTENSION_ROLES)) {
                    roles = new ArrayList();
                    List authMethods = operation.authMethods;
                    if (authMethods != null && !authMethods.isEmpty()) {
                        List scopes = ((CodegenSecurity)authMethods.get((int)0)).scopes;
                        if (scopes != null && !scopes.isEmpty()) {
                            for (Map scope : scopes) {
                                ((ArrayList)roles).add((CallSite)((Object)("\"" + this.escapeText(scope.get("scope").toString()) + "\"")));
                            }
                        } else {
                            ((ArrayList)roles).add(AUTHORIZED_ROLE);
                        }
                    } else {
                        ((ArrayList)roles).add(ANONYMOUS_ROLE);
                    }
                    operation.vendorExtensions.put(EXTENSION_ROLES, roles);
                    continue;
                }
                roles = (List)operation.vendorExtensions.get(EXTENSION_ROLES);
                roles = roles.stream().map(role -> switch (role) {
                    case ANONYMOUS_ROLE_KEY -> ANONYMOUS_ROLE;
                    case AUTHORIZED_ROLE_KEY -> AUTHORIZED_ROLE;
                    case DENY_ALL_ROLE_KEY -> DENY_ALL_ROLE;
                    default -> "\"" + this.escapeText((String)role) + "\"";
                }).toList();
                operation.vendorExtensions.put(EXTENSION_ROLES, roles);
            }
        }
        List enumParams = (List)this.additionalProperties.get("enumParams");
        if (this.generateEnumConverters && !enumParams.isEmpty()) {
            String enumConfigName = "Server";
            String enumConfigClassName = "EnumConverter" + enumConfigName + "Config";
            this.additionalProperties.put("enumConfigClassName", enumConfigClassName);
            String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
            this.supportingFiles.add(new SupportingFile("common/EnumConverterConfig.mustache", invokerFolder + "/config", enumConfigClassName + ".java"));
        }
        return objs;
    }

    @Override
    public JavaMicronautServerOptionsBuilder optionsBuilder() {
        return new DefaultServerOptionsBuilder();
    }

    static class DefaultServerOptionsBuilder
    implements JavaMicronautServerOptionsBuilder {
        private String controllerPackage;
        private boolean generateImplementationFiles;
        private boolean generateControllerFromExamples;
        private boolean generateOperationsToReturnNotImplemented = true;
        private boolean useAuth = true;
        private boolean lombok;
        private boolean plural = true;
        private boolean fluxForArrays;
        private boolean generatedAnnotation = true;
        private boolean generateHardNullable = true;
        private boolean generateStreamingFileUpload;
        private boolean aot;
        private boolean noArgsConstructor;

        DefaultServerOptionsBuilder() {
        }

        @Override
        public JavaMicronautServerOptionsBuilder withNoArgsConstructor(boolean noArgsConstructor) {
            this.noArgsConstructor = noArgsConstructor;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withControllerPackage(String controllerPackage) {
            this.controllerPackage = controllerPackage;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateImplementationFiles(boolean generateImplementationFiles) {
            this.generateImplementationFiles = generateImplementationFiles;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateOperationsToReturnNotImplemented(boolean generateOperationsToReturnNotImplemented) {
            this.generateOperationsToReturnNotImplemented = generateOperationsToReturnNotImplemented;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateControllerFromExamples(boolean generateControllerFromExamples) {
            this.generateControllerFromExamples = generateControllerFromExamples;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withAuthentication(boolean useAuth) {
            this.useAuth = useAuth;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withLombok(boolean lombok) {
            this.lombok = lombok;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withPlural(boolean plural) {
            this.plural = plural;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withFluxForArrays(boolean fluxForArrays) {
            this.fluxForArrays = fluxForArrays;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGeneratedAnnotation(boolean generatedAnnotation) {
            this.generatedAnnotation = generatedAnnotation;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateHardNullable(boolean generateHardNullable) {
            this.generateHardNullable = generateHardNullable;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withGenerateStreamingFileUpload(boolean generateStreamingFileUpload) {
            this.generateStreamingFileUpload = generateStreamingFileUpload;
            return this;
        }

        @Override
        public JavaMicronautServerOptionsBuilder withAot(boolean aot) {
            this.aot = aot;
            return this;
        }

        ServerOptions build() {
            return new ServerOptions(this.controllerPackage, this.generateImplementationFiles, this.generateOperationsToReturnNotImplemented, this.generateControllerFromExamples, this.useAuth, this.lombok, this.plural, this.fluxForArrays, this.generatedAnnotation, this.generateHardNullable, this.generateStreamingFileUpload, this.aot, this.noArgsConstructor);
        }
    }

    record ServerOptions(String controllerPackage, boolean generateImplementationFiles, boolean generateOperationsToReturnNotImplemented, boolean generateControllerFromExamples, boolean useAuth, boolean lombok, boolean plural, boolean fluxForArrays, boolean generatedAnnotation, boolean generateHardNullable, boolean generateStreamingFileUpload, boolean aot, boolean noArgsConstructor) {
    }
}

