/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautKotlinCodegen;
import io.micronaut.openapi.generator.KotlinMicronautClientOptionsBuilder;
import java.util.Arrays;
import java.util.List;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;

public class KotlinMicronautClientCodegen
extends AbstractMicronautKotlinCodegen<KotlinMicronautClientOptionsBuilder> {
    public static final String OPT_CONFIGURE_AUTH = "configureAuth";
    public static final String OPT_CONFIGURE_AUTH_FILTER_PATTERN = "configureAuthFilterPattern";
    public static final String OPT_CONFIGURE_CLIENT_ID = "configureClientId";
    public static final String ADDITIONAL_CLIENT_TYPE_ANNOTATIONS = "additionalClientTypeAnnotations";
    public static final String AUTHORIZATION_FILTER_PATTERN = "authorizationFilterPattern";
    public static final String BASE_PATH_SEPARATOR = "basePathSeparator";
    public static final String CLIENT_ID = "clientId";
    public static final String NAME = "kotlin-micronaut-client";
    protected boolean configureAuthorization;
    protected List<String> additionalClientTypeAnnotations;
    protected String authorizationFilterPattern;
    protected String basePathSeparator = "-";
    protected String clientId;

    KotlinMicronautClientCodegen() {
        this.title = "OpenAPI Micronaut Client";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.additionalProperties.put("client", "true");
        this.cliOptions.add(CliOption.newBoolean((String)OPT_CONFIGURE_AUTH, (String)"Configure all the authorization methods as specified in the file", (boolean)this.configureAuthorization));
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_CLIENT_TYPE_ANNOTATIONS, (String)"Additional annotations for client type(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newString((String)AUTHORIZATION_FILTER_PATTERN, (String)"Configure the authorization filter pattern for the client. Generally defined when generating clients from multiple specification files"));
        this.cliOptions.add(CliOption.newString((String)BASE_PATH_SEPARATOR, (String)"Configure the separator to use between the application name and base path when referencing the property").defaultValue(this.basePathSeparator));
        this.cliOptions.add(CliOption.newString((String)CLIENT_ID, (String)"Configure the service ID for the Client"));
        this.typeMapping.put("file", "ByteArray");
        this.typeMapping.put("responseFile", "InputStream");
        this.importMapping.put("InputStream", "java.io.InputStream");
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a Java Micronaut Client.";
    }

    public boolean isConfigureAuthorization() {
        return this.configureAuthorization;
    }

    @Override
    public void processOpts() {
        Object basePathSeparator;
        Object additionalClientAnnotations;
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_CONFIGURE_AUTH)) {
            this.configureAuthorization = this.convertPropertyToBoolean(OPT_CONFIGURE_AUTH);
        }
        this.writePropertyBack(OPT_CONFIGURE_AUTH, this.configureAuthorization);
        this.writePropertyBack("useAuth", true);
        this.writePropertyBack(OPT_CONFIGURE_AUTH_FILTER_PATTERN, false);
        this.writePropertyBack(OPT_CONFIGURE_CLIENT_ID, false);
        String invokerFolder = (this.sourceFolder + "/" + this.packageName).replace(".", "/");
        if (this.configureAuthorization) {
            String authFolder = invokerFolder + "/auth";
            this.supportingFiles.add(new SupportingFile("client/auth/Authorization.mustache", authFolder, "Authorization.kt"));
            this.supportingFiles.add(new SupportingFile("client/auth/AuthorizationBinder.mustache", authFolder, "AuthorizationBinder.kt"));
            this.supportingFiles.add(new SupportingFile("client/auth/Authorizations.mustache", authFolder, "Authorizations.kt"));
            this.supportingFiles.add(new SupportingFile("client/auth/AuthorizationFilter.mustache", authFolder, "AuthorizationFilter.kt"));
            String authConfigurationFolder = authFolder + "/configuration";
            this.supportingFiles.add(new SupportingFile("client/auth/configuration/ApiKeyAuthConfiguration.mustache", authConfigurationFolder, "ApiKeyAuthConfiguration.kt"));
            this.supportingFiles.add(new SupportingFile("client/auth/configuration/ConfigurableAuthorization.mustache", authConfigurationFolder, "ConfigurableAuthorization.kt"));
            this.supportingFiles.add(new SupportingFile("client/auth/configuration/HttpBasicAuthConfiguration.mustache", authConfigurationFolder, "HttpBasicAuthConfiguration.kt"));
            Object authorizationFilterPattern = this.additionalProperties.get(AUTHORIZATION_FILTER_PATTERN);
            if (authorizationFilterPattern != null) {
                this.authorizationFilterPattern = authorizationFilterPattern.toString();
            }
            if (this.authorizationFilterPattern != null) {
                this.writePropertyBack(OPT_CONFIGURE_AUTH_FILTER_PATTERN, true);
            }
            this.writePropertyBack(AUTHORIZATION_FILTER_PATTERN, this.authorizationFilterPattern);
        }
        if ((additionalClientAnnotations = this.additionalProperties.get(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS)) != null) {
            List<Object> additionalClientAnnotationsAsList;
            this.additionalClientTypeAnnotations = additionalClientAnnotations instanceof List ? (additionalClientAnnotationsAsList = (List<Object>)additionalClientAnnotations) : Arrays.asList(additionalClientAnnotations.toString().trim().split("\\s*(;|\\r?\\n)\\s*"));
        }
        this.writePropertyBack(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS, this.additionalClientTypeAnnotations);
        Object clientId = this.additionalProperties.get(CLIENT_ID);
        if (clientId != null) {
            this.clientId = clientId.toString();
        }
        if (this.clientId != null) {
            this.writePropertyBack(OPT_CONFIGURE_CLIENT_ID, true);
            this.writePropertyBack(CLIENT_ID, this.clientId);
        }
        if ((basePathSeparator = this.additionalProperties.get(BASE_PATH_SEPARATOR)) != null) {
            this.basePathSeparator = basePathSeparator.toString();
        }
        this.writePropertyBack(BASE_PATH_SEPARATOR, this.basePathSeparator);
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("client/api.mustache", ".kt");
        this.apiTestTemplateFiles.clear();
        if (this.testTool.equals("junit")) {
            this.apiTestTemplateFiles.put("client/test/api_test.mustache", ".kt");
        }
        this.supportingFiles.add(new SupportingFile("client/doc/README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("client/doc/auth.mustache", this.apiDocPath, "auth.md"));
        this.apiDocTemplateFiles.clear();
        this.apiDocTemplateFiles.put("client/doc/api_doc.mustache", ".md");
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public void setAdditionalClientTypeAnnotations(List<String> additionalClientTypeAnnotations) {
        this.additionalClientTypeAnnotations = additionalClientTypeAnnotations;
    }

    public void setAuthorizationFilterPattern(String authorizationFilterPattern) {
        this.authorizationFilterPattern = authorizationFilterPattern;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setBasePathSeparator(String basePathSeparator) {
        this.basePathSeparator = basePathSeparator;
    }

    public void setConfigureAuthorization(boolean configureAuthorization) {
        this.configureAuthorization = configureAuthorization;
    }

    @Override
    public KotlinMicronautClientOptionsBuilder optionsBuilder() {
        return new DefaultClientOptionsBuilder();
    }

    static class DefaultClientOptionsBuilder
    implements KotlinMicronautClientOptionsBuilder {
        private List<String> additionalClientTypeAnnotations;
        private String authorizationFilterPattern;
        private String basePathSeparator;
        private String clientId;
        private boolean useAuth;
        private boolean fluxForArrays;
        private boolean generatedAnnotation = true;

        DefaultClientOptionsBuilder() {
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withAuthorization(boolean useAuth) {
            this.useAuth = useAuth;
            return this;
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withAuthorizationFilterPattern(String authorizationFilterPattern) {
            this.authorizationFilterPattern = authorizationFilterPattern;
            return this;
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withAdditionalClientTypeAnnotations(List<String> additionalClientTypeAnnotations) {
            this.additionalClientTypeAnnotations = additionalClientTypeAnnotations;
            return this;
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withBasePathSeparator(String basePathSeparator) {
            this.basePathSeparator = basePathSeparator;
            return this;
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withFluxForArrays(boolean fluxForArrays) {
            this.fluxForArrays = fluxForArrays;
            return this;
        }

        @Override
        public KotlinMicronautClientOptionsBuilder withGeneratedAnnotation(boolean generatedAnnotation) {
            this.generatedAnnotation = generatedAnnotation;
            return this;
        }

        ClientOptions build() {
            return new ClientOptions(this.additionalClientTypeAnnotations, this.authorizationFilterPattern, this.basePathSeparator, this.clientId, this.useAuth, this.fluxForArrays, this.generatedAnnotation);
        }
    }

    record ClientOptions(List<String> additionalClientTypeAnnotations, String authorizationFilterPattern, String basePathSeparator, String clientId, boolean useAuth, boolean fluxForArrays, boolean generatedAnnotation) {
    }
}

