/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautKotlinCodegen;
import io.micronaut.openapi.generator.KotlinMicronautServerOptionsBuilder;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;

public class KotlinMicronautServerCodegen
extends AbstractMicronautKotlinCodegen<KotlinMicronautServerOptionsBuilder> {
    public static final String OPT_CONTROLLER_PACKAGE = "controllerPackage";
    public static final String OPT_GENERATE_CONTROLLER_FROM_EXAMPLES = "generateControllerFromExamples";
    public static final String OPT_GENERATE_IMPLEMENTATION_FILES = "generateImplementationFiles";
    public static final String OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED = "generateOperationsToReturnNotImplemented";
    public static final String OPT_GENERATE_STREAMING_FILE_UPLOAD = "generateStreamingFileUpload";
    public static final String OPT_AOT = "aot";
    public static final String EXTENSION_ROLES = "x-roles";
    public static final String ANONYMOUS_ROLE_KEY = "isAnonymous()";
    public static final String ANONYMOUS_ROLE = "SecurityRule.IS_ANONYMOUS";
    public static final String AUTHORIZED_ROLE_KEY = "isAuthorized()";
    public static final String AUTHORIZED_ROLE = "SecurityRule.IS_AUTHENTICATED";
    public static final String DENY_ALL_ROLE_KEY = "denyAll()";
    public static final String DENY_ALL_ROLE = "SecurityRule.DENY_ALL";
    public static final String NAME = "kotlin-micronaut-server";
    protected static final String CONTROLLER_PREFIX = "";
    protected static final String CONTROLLER_SUFFIX = "Controller";
    protected static final String API_PREFIX = "";
    protected static final String API_SUFFIX = "Api";
    protected String apiPackage = "org.openapitools.api";
    protected String controllerPackage = "org.openapitools.controller";
    protected boolean generateImplementationFiles = true;
    protected boolean generateOperationsToReturnNotImplemented = true;
    protected boolean generateControllerFromExamples;
    protected boolean useAuth = true;
    protected boolean generateStreamingFileUpload;
    protected boolean aot;

    KotlinMicronautServerCodegen() {
        this.title = "OpenAPI Micronaut Server";
        this.apiDocPath = "docs/controllers";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.additionalProperties.put("server", "true");
        this.cliOptions.add(new CliOption(OPT_CONTROLLER_PACKAGE, "The package in which api implementations (controllers) will be generated.").defaultValue(this.apiPackage));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, (String)"Generate the implementation of controller and tests from parameter and return examples that will verify that the api works as desired (for testing).", (boolean)this.generateControllerFromExamples));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_IMPLEMENTATION_FILES, (String)"Whether to generate controller implementations that need to be filled in.", (boolean)this.generateImplementationFiles));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, (String)"Return HTTP 501 Not Implemented instead of an empty response in the generated controller methods.", (boolean)this.generateOperationsToReturnNotImplemented));
        this.cliOptions.add(CliOption.newBoolean((String)"useAuth", (String)"Whether to import authorization and to annotate controller methods accordingly", (boolean)this.useAuth));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_STREAMING_FILE_UPLOAD, (String)"Whether to generate StreamingFileUpload type for file request body", (boolean)this.generateStreamingFileUpload));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_AOT, (String)"Generate compatible code with micronaut-aot", (boolean)this.aot));
        this.typeMapping.put("file", "CompletedFileUpload");
        this.importMapping.put("CompletedFileUpload", "io.micronaut.http.multipart.CompletedFileUpload");
        this.importMapping.put("StreamingFileUpload", "io.micronaut.http.multipart.StreamingFileUpload");
        this.typeMapping.put("responseFile", "FileCustomizableResponseType");
        this.importMapping.put("FileCustomizableResponseType", "io.micronaut.http.server.types.files.FileCustomizableResponseType");
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a Java Micronaut Server.";
    }

    public void setControllerPackage(String controllerPackage) {
        this.controllerPackage = controllerPackage;
    }

    public void setGenerateImplementationFiles(boolean generateImplementationFiles) {
        this.generateImplementationFiles = generateImplementationFiles;
    }

    public void setGenerateOperationsToReturnNotImplemented(boolean generateOperationsToReturnNotImplemented) {
        this.generateOperationsToReturnNotImplemented = generateOperationsToReturnNotImplemented;
    }

    public void setGenerateControllerFromExamples(boolean generateControllerFromExamples) {
        this.generateControllerFromExamples = generateControllerFromExamples;
    }

    public void setUseAuth(boolean useAuth) {
        this.useAuth = useAuth;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_GENERATE_IMPLEMENTATION_FILES)) {
            this.generateImplementationFiles = this.convertPropertyToBoolean(OPT_GENERATE_IMPLEMENTATION_FILES);
        }
        this.writePropertyBack(OPT_GENERATE_IMPLEMENTATION_FILES, this.generateImplementationFiles);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED)) {
            this.generateOperationsToReturnNotImplemented = this.convertPropertyToBoolean(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATIONS_TO_RETURN_NOT_IMPLEMENTED, this.generateOperationsToReturnNotImplemented);
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = (String)this.additionalProperties.get("apiPackage");
        }
        this.writePropertyBack("apiPackage", this.apiPackage);
        if (this.additionalProperties.containsKey(OPT_CONTROLLER_PACKAGE)) {
            this.controllerPackage = (String)this.additionalProperties.get(OPT_CONTROLLER_PACKAGE);
        }
        this.writePropertyBack(OPT_CONTROLLER_PACKAGE, this.controllerPackage);
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES)) {
            this.generateControllerFromExamples = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_FROM_EXAMPLES, this.generateControllerFromExamples);
        if (this.additionalProperties.containsKey("useAuth")) {
            this.useAuth = this.convertPropertyToBoolean("useAuth");
        }
        this.writePropertyBack("useAuth", this.useAuth);
        if (this.additionalProperties.containsKey(OPT_AOT)) {
            this.aot = this.convertPropertyToBoolean(OPT_AOT);
        }
        this.writePropertyBack(OPT_AOT, this.aot);
        if (this.additionalProperties.containsKey(OPT_GENERATE_STREAMING_FILE_UPLOAD)) {
            this.generateStreamingFileUpload = this.convertPropertyToBoolean(OPT_GENERATE_STREAMING_FILE_UPLOAD);
        }
        this.writePropertyBack(OPT_GENERATE_STREAMING_FILE_UPLOAD, this.generateStreamingFileUpload);
        this.apiTemplateFiles.clear();
        this.setApiNamePrefix("");
        this.setApiNameSuffix(API_SUFFIX);
        this.apiTemplateFiles.put("server/controller-interface.mustache", ".kt");
        this.apiTestTemplateFiles.clear();
        if (this.generateImplementationFiles) {
            this.supportingFiles.add(new SupportingFile("server/doc/README.mustache", "", "README.md").doNotOverwrite());
            this.apiDocTemplateFiles.clear();
            this.apiDocTemplateFiles.put("server/doc/controller_doc.mustache", ".md");
            String invokerFolder = (this.sourceFolder + "/" + this.packageName).replace('.', '/');
            this.supportingFiles.add(new SupportingFile("common/configuration/Application.mustache", invokerFolder, "Application.kt").doNotOverwrite());
            this.apiTestTemplateFiles.put("server/controller-implementation.mustache", ".kt");
            if (this.testTool.equals("junit")) {
                this.apiTestTemplateFiles.put("server/test/controller_test.mustache", ".kt");
            }
        }
        if (this.generateStreamingFileUpload) {
            this.typeMapping.put("file", "StreamingFileUpload");
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public String apiTestFileFolder() {
        return super.getOutputDir();
    }

    public String apiTestFilename(String templateName, String tag) {
        String controllerName = StringUtils.camelize((String)("_" + tag + "_Controller"));
        if (this.generateImplementationFiles && templateName.contains("controller-implementation")) {
            String implementationFolder = this.outputFolder + File.separator + this.sourceFolder + File.separator + this.controllerPackage.replace('.', File.separatorChar);
            return (implementationFolder + File.separator + controllerName + ".kt").replace('/', File.separatorChar);
        }
        String suffix = (String)this.apiTestTemplateFiles().get(templateName);
        return super.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        super.setParameterExampleValue(p);
        if (p.isFile) {
            p.example = "null";
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        String controllerClassname = StringUtils.camelize((String)("_" + operations.getPathPrefix() + "_Controller"));
        objs.put((Object)"controllerClassname", (Object)controllerClassname);
        List allOperations = (List)operations.get((Object)"operation");
        if (this.useAuth) {
            for (CodegenOperation operation : allOperations) {
                if (!operation.vendorExtensions.containsKey(EXTENSION_ROLES)) {
                    String role2 = operation.hasAuthMethods ? AUTHORIZED_ROLE : ANONYMOUS_ROLE;
                    operation.vendorExtensions.put(EXTENSION_ROLES, Collections.singletonList(role2));
                    continue;
                }
                List<String> roles = (List<String>)operation.vendorExtensions.get(EXTENSION_ROLES);
                roles = roles.stream().map(role -> switch (role) {
                    case ANONYMOUS_ROLE_KEY -> ANONYMOUS_ROLE;
                    case AUTHORIZED_ROLE_KEY -> AUTHORIZED_ROLE;
                    case DENY_ALL_ROLE_KEY -> DENY_ALL_ROLE;
                    default -> "\"" + this.escapeText((String)role) + "\"";
                }).toList();
                operation.vendorExtensions.put(EXTENSION_ROLES, roles);
            }
        }
        return objs;
    }

    @Override
    public KotlinMicronautServerOptionsBuilder optionsBuilder() {
        return new DefaultServerOptionsBuilder();
    }

    static class DefaultServerOptionsBuilder
    implements KotlinMicronautServerOptionsBuilder {
        private String controllerPackage;
        private boolean generateImplementationFiles;
        private boolean generateControllerFromExamples;
        private boolean generateOperationsToReturnNotImplemented = true;
        private boolean plural = true;
        private boolean useAuth = true;
        private boolean fluxForArrays;
        private boolean generatedAnnotation = true;
        private boolean aot;

        DefaultServerOptionsBuilder() {
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withControllerPackage(String controllerPackage) {
            this.controllerPackage = controllerPackage;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withGenerateImplementationFiles(boolean generateImplementationFiles) {
            this.generateImplementationFiles = generateImplementationFiles;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withGenerateOperationsToReturnNotImplemented(boolean generateOperationsToReturnNotImplemented) {
            this.generateOperationsToReturnNotImplemented = generateOperationsToReturnNotImplemented;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withGenerateControllerFromExamples(boolean generateControllerFromExamples) {
            this.generateControllerFromExamples = generateControllerFromExamples;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withAuthentication(boolean useAuth) {
            this.useAuth = useAuth;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withFluxForArrays(boolean fluxForArrays) {
            this.fluxForArrays = fluxForArrays;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withPlural(boolean plural) {
            this.plural = plural;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withGeneratedAnnotation(boolean generatedAnnotation) {
            this.generatedAnnotation = generatedAnnotation;
            return this;
        }

        @Override
        public KotlinMicronautServerOptionsBuilder withAot(boolean aot) {
            this.aot = aot;
            return this;
        }

        ServerOptions build() {
            return new ServerOptions(this.controllerPackage, this.generateImplementationFiles, this.generateOperationsToReturnNotImplemented, this.generateControllerFromExamples, this.useAuth, this.plural, this.fluxForArrays, this.generatedAnnotation, this.aot);
        }
    }

    record ServerOptions(String controllerPackage, boolean generateImplementationFiles, boolean generateOperationsToReturnNotImplemented, boolean generateControllerFromExamples, boolean useAuth, boolean plural, boolean fluxForArrays, boolean generatedAnnotation, boolean aot) {
    }
}

