/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.AbstractMicronautKotlinCodegen;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautClientCodegen;
import io.micronaut.openapi.generator.JavaMicronautClientOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautServerCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerOptionsBuilder;
import io.micronaut.openapi.generator.KotlinMicronautClientCodegen;
import io.micronaut.openapi.generator.KotlinMicronautClientOptionsBuilder;
import io.micronaut.openapi.generator.KotlinMicronautServerCodegen;
import io.micronaut.openapi.generator.KotlinMicronautServerOptionsBuilder;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import io.micronaut.openapi.generator.MicronautCodeGeneratorOptionsBuilder;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.ResponseBodyMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.DefaultGenerator;

public final class MicronautCodeGeneratorEntryPoint {
    private final URI definitionFile;
    private final File outputDirectory;
    private final DefaultCodegen codeGenerator;
    private final EnumSet<OutputKind> outputs;
    private final Options options;
    private final JavaMicronautServerCodegen.ServerOptions javaServerOptions;
    private final JavaMicronautClientCodegen.ClientOptions javaClientOptions;
    private final KotlinMicronautServerCodegen.ServerOptions kotlinServerOptions;
    private final KotlinMicronautClientCodegen.ClientOptions kotlinClientOptions;

    private MicronautCodeGeneratorEntryPoint(URI definitionFile, File outputDirectory, DefaultCodegen codeGenerator, EnumSet<OutputKind> outputs, Options options, JavaMicronautServerCodegen.ServerOptions javaServerOptions, JavaMicronautClientCodegen.ClientOptions javaClientOptions, KotlinMicronautServerCodegen.ServerOptions kotlinServerOptions, KotlinMicronautClientCodegen.ClientOptions kotlinClientOptions) {
        this.definitionFile = definitionFile;
        this.outputDirectory = outputDirectory;
        this.codeGenerator = codeGenerator;
        this.outputs = outputs;
        this.options = options;
        this.javaServerOptions = javaServerOptions;
        this.javaClientOptions = javaClientOptions;
        this.kotlinServerOptions = kotlinServerOptions;
        this.kotlinClientOptions = kotlinClientOptions;
    }

    private static void withPath(File file, Consumer<? super String> action) {
        if (file == null) {
            return;
        }
        try {
            String path = file.getCanonicalPath();
            action.accept(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generate() {
        OpenAPI openAPI = new OpenAPIParser().readLocation(this.definitionFile.toString(), null, new ParseOptions()).getOpenAPI();
        MicronautCodeGeneratorEntryPoint.withPath(this.outputDirectory, arg_0 -> ((DefaultCodegen)this.codeGenerator).setOutputDir(arg_0));
        Object object = this.codeGenerator;
        if (object instanceof AbstractMicronautJavaCodegen) {
            AbstractMicronautJavaCodegen javaCodegen = (AbstractMicronautJavaCodegen)object;
            javaCodegen.setHideGenerationTimestamp(true);
        } else {
            object = this.codeGenerator;
            if (object instanceof AbstractMicronautKotlinCodegen) {
                AbstractMicronautKotlinCodegen kotlinCodegen = (AbstractMicronautKotlinCodegen)object;
                kotlinCodegen.setHideGenerationTimestamp(true);
            }
        }
        this.configureOptions();
        ClientOptInput input = new ClientOptInput();
        input.openAPI(openAPI);
        input.config((CodegenConfig)this.codeGenerator);
        DefaultGenerator generator = new DefaultGenerator();
        for (OutputKind outputKind : OutputKind.values()) {
            generator.setGeneratorPropertyDefault(outputKind.generatorProperty, "false");
        }
        for (OutputKind outputKind : this.outputs) {
            generator.setGeneratorPropertyDefault(outputKind.generatorProperty, "true");
        }
        generator.opts(input).generate();
    }

    private void configureOptions() {
        DefaultCodegen defaultCodegen;
        if (this.options == null) {
            return;
        }
        if (this.options.modelPackage != null) {
            this.codeGenerator.setModelPackage(this.options.modelPackage);
        }
        if (this.options.apiPackage != null) {
            this.codeGenerator.setApiPackage(this.options.apiPackage);
        }
        if ((this.options.lang == null || this.options.lang == MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.JAVA) && (defaultCodegen = this.codeGenerator) instanceof AbstractMicronautJavaCodegen) {
            AbstractMicronautJavaCodegen javaCodeGen = (AbstractMicronautJavaCodegen)defaultCodegen;
            if (this.options.invokerPackage != null) {
                javaCodeGen.setInvokerPackage(this.options.invokerPackage);
            }
            if (this.options.artifactId != null) {
                javaCodeGen.setArtifactId(this.options.artifactId);
            }
            if (this.options.parameterMappings != null) {
                javaCodeGen.addParameterMappings(this.options.parameterMappings);
            }
            if (this.options.responseBodyMappings != null) {
                javaCodeGen.addResponseBodyMappings(this.options.responseBodyMappings);
            }
            javaCodeGen.setReactive(this.options.reactive);
            javaCodeGen.setGenerateHttpResponseAlways(this.options.generateHttpResponseAlways);
            javaCodeGen.setGenerateHttpResponseWhereRequired(this.options.generateHttpResponseWhereRequired);
            javaCodeGen.setUseOptional(this.options.optional);
            javaCodeGen.setUseBeanValidation(this.options.beanValidation);
            javaCodeGen.setTestTool(this.options.testFramework.value);
            javaCodeGen.setSerializationLibrary(this.options.serializationLibraryKind().name());
            javaCodeGen.setDateTimeLibrary(this.options.dateTimeFormat().name());
            this.configureJavaServerOptions();
            this.configureJavaClientOptions();
        } else if (this.options.lang == MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.KOTLIN && (defaultCodegen = this.codeGenerator) instanceof AbstractMicronautKotlinCodegen) {
            AbstractMicronautKotlinCodegen kotlinCodeGen = (AbstractMicronautKotlinCodegen)defaultCodegen;
            if (this.options.invokerPackage != null) {
                kotlinCodeGen.setInvokerPackage(this.options.invokerPackage);
            }
            if (this.options.artifactId != null) {
                kotlinCodeGen.setArtifactId(this.options.artifactId);
            }
            if (this.options.parameterMappings != null) {
                kotlinCodeGen.addParameterMappings(this.options.parameterMappings);
            }
            if (this.options.responseBodyMappings != null) {
                kotlinCodeGen.addResponseBodyMappings(this.options.responseBodyMappings);
            }
            kotlinCodeGen.setReactive(this.options.reactive);
            kotlinCodeGen.setGenerateHttpResponseAlways(this.options.generateHttpResponseAlways);
            kotlinCodeGen.setGenerateHttpResponseWhereRequired(this.options.generateHttpResponseWhereRequired);
            kotlinCodeGen.setUseBeanValidation(this.options.beanValidation);
            kotlinCodeGen.setTestTool(this.options.testFramework.value);
            kotlinCodeGen.setSerializationLibrary(this.options.serializationLibraryKind().name());
            kotlinCodeGen.setDateTimeLibrary(this.options.dateTimeFormat().name());
            this.configureKotlinServerOptions();
            this.configureKotlinClientOptions();
        }
        this.codeGenerator.processOpts();
    }

    private void configureJavaServerOptions() {
        DefaultCodegen defaultCodegen;
        if (this.javaServerOptions != null && (defaultCodegen = this.codeGenerator) instanceof JavaMicronautServerCodegen) {
            JavaMicronautServerCodegen javaServerCodegen = (JavaMicronautServerCodegen)defaultCodegen;
            if (this.javaServerOptions.controllerPackage() != null) {
                javaServerCodegen.setControllerPackage(this.javaServerOptions.controllerPackage());
            }
            javaServerCodegen.setGenerateImplementationFiles(this.javaServerOptions.generateImplementationFiles());
            javaServerCodegen.setGenerateOperationsToReturnNotImplemented(this.javaServerOptions.generateOperationsToReturnNotImplemented());
            javaServerCodegen.setGenerateControllerFromExamples(this.javaServerOptions.generateControllerFromExamples());
            javaServerCodegen.setUseAuth(this.javaServerOptions.useAuth());
            javaServerCodegen.setLombok(this.javaServerOptions.lombok());
            javaServerCodegen.setPlural(this.javaServerOptions.plural());
            javaServerCodegen.setFluxForArrays(this.javaServerOptions.fluxForArrays());
            javaServerCodegen.setGeneratedAnnotation(this.javaServerOptions.generatedAnnotation());
        }
    }

    public void configureJavaClientOptions() {
        DefaultCodegen defaultCodegen;
        if (this.javaClientOptions != null && (defaultCodegen = this.codeGenerator) instanceof JavaMicronautClientCodegen) {
            JavaMicronautClientCodegen javaClientCodegen = (JavaMicronautClientCodegen)defaultCodegen;
            if (this.javaClientOptions.additionalClientTypeAnnotations() != null) {
                javaClientCodegen.setAdditionalClientTypeAnnotations(this.javaClientOptions.additionalClientTypeAnnotations());
            }
            if (this.javaClientOptions.clientId() != null) {
                javaClientCodegen.setClientId(javaClientCodegen.clientId);
            }
            if (this.javaClientOptions.authorizationFilterPattern() != null) {
                javaClientCodegen.setAuthorizationFilterPattern(javaClientCodegen.authorizationFilterPattern);
            }
            if (this.javaClientOptions.basePathSeparator() != null) {
                javaClientCodegen.setBasePathSeparator(javaClientCodegen.basePathSeparator);
            }
            javaClientCodegen.setConfigureAuthorization(this.javaClientOptions.useAuth());
            javaClientCodegen.setLombok(this.javaClientOptions.lombok());
            javaClientCodegen.setPlural(this.javaClientOptions.plural());
            javaClientCodegen.setFluxForArrays(this.javaClientOptions.fluxForArrays());
            javaClientCodegen.setGeneratedAnnotation(this.javaClientOptions.generatedAnnotation());
        }
    }

    private void configureKotlinServerOptions() {
        DefaultCodegen defaultCodegen;
        if (this.kotlinServerOptions != null && (defaultCodegen = this.codeGenerator) instanceof KotlinMicronautServerCodegen) {
            KotlinMicronautServerCodegen kotlinServerCodegen = (KotlinMicronautServerCodegen)defaultCodegen;
            if (this.kotlinServerOptions.controllerPackage() != null) {
                kotlinServerCodegen.setControllerPackage(this.kotlinServerOptions.controllerPackage());
            }
            kotlinServerCodegen.setGenerateImplementationFiles(this.kotlinServerOptions.generateImplementationFiles());
            kotlinServerCodegen.setGenerateOperationsToReturnNotImplemented(this.kotlinServerOptions.generateOperationsToReturnNotImplemented());
            kotlinServerCodegen.setGenerateControllerFromExamples(this.kotlinServerOptions.generateControllerFromExamples());
            kotlinServerCodegen.setGeneratedAnnotation(this.kotlinServerOptions.generatedAnnotation());
            kotlinServerCodegen.setUseAuth(this.kotlinServerOptions.useAuth());
            kotlinServerCodegen.setPlural(this.kotlinServerOptions.plural());
            kotlinServerCodegen.setFluxForArrays(this.kotlinServerOptions.fluxForArrays());
        }
    }

    public void configureKotlinClientOptions() {
        DefaultCodegen defaultCodegen;
        if (this.kotlinClientOptions != null && (defaultCodegen = this.codeGenerator) instanceof KotlinMicronautClientCodegen) {
            KotlinMicronautClientCodegen kotlinClientCodegen = (KotlinMicronautClientCodegen)defaultCodegen;
            if (this.kotlinClientOptions.additionalClientTypeAnnotations() != null) {
                kotlinClientCodegen.setAdditionalClientTypeAnnotations(this.kotlinClientOptions.additionalClientTypeAnnotations());
            }
            if (this.kotlinClientOptions.clientId() != null) {
                kotlinClientCodegen.setClientId(kotlinClientCodegen.clientId);
            }
            if (this.kotlinClientOptions.authorizationFilterPattern() != null) {
                kotlinClientCodegen.setAuthorizationFilterPattern(kotlinClientCodegen.authorizationFilterPattern);
            }
            if (this.kotlinClientOptions.basePathSeparator() != null) {
                kotlinClientCodegen.setBasePathSeparator(kotlinClientCodegen.basePathSeparator);
            }
            kotlinClientCodegen.setGeneratedAnnotation(this.kotlinClientOptions.generatedAnnotation());
            kotlinClientCodegen.setConfigureAuthorization(this.kotlinClientOptions.useAuth());
            kotlinClientCodegen.setPlural(this.kotlinClientOptions.plural());
            kotlinClientCodegen.setFluxForArrays(this.kotlinClientOptions.fluxForArrays());
        }
    }

    public static MicronautCodeGeneratorBuilder builder() {
        return new DefaultBuilder();
    }

    private record Options(MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage lang, String apiPackage, String modelPackage, String invokerPackage, String artifactId, List<ParameterMapping> parameterMappings, List<ResponseBodyMapping> responseBodyMappings, boolean beanValidation, boolean optional, boolean reactive, boolean generateHttpResponseAlways, boolean generateHttpResponseWhereRequired, TestFramework testFramework, SerializationLibraryKind serializationLibraryKind, MicronautCodeGeneratorOptionsBuilder.DateTimeFormat dateTimeFormat) {
    }

    public static enum OutputKind {
        MODELS("models", DefaultBuilder.HAS_OUTPUT),
        MODEL_TESTS("modelTests", DefaultBuilder.HAS_OUTPUT),
        MODEL_DOCS("modelDocs", DefaultBuilder.HAS_OUTPUT),
        APIS("apis", DefaultBuilder.HAS_OUTPUT),
        API_TESTS("apiTests", DefaultBuilder.HAS_OUTPUT),
        API_DOCS("apiDocs", DefaultBuilder.HAS_OUTPUT),
        SUPPORTING_FILES("supportingFiles", DefaultBuilder.HAS_OUTPUT);

        private final String generatorProperty;
        private final Consumer<DefaultBuilder> validationAction;

        private OutputKind(String generatorProperty, Consumer<DefaultBuilder> validationAction) {
            this.generatorProperty = generatorProperty;
            this.validationAction = validationAction;
        }

        public static OutputKind of(String name) {
            for (OutputKind kind : OutputKind.values()) {
                if (!kind.name().equals(name) && !kind.generatorProperty.equals(name)) continue;
                return kind;
            }
            throw new IllegalArgumentException("Unknown output kind '" + name + "'");
        }

        public String getGeneratorProperty() {
            return this.generatorProperty;
        }
    }

    public static enum TestFramework {
        JUNIT5("junit"),
        SPOCK("spock");

        private final String value;

        private TestFramework(String value) {
            this.value = value;
        }
    }

    private static class DefaultBuilder
    implements MicronautCodeGeneratorBuilder {
        private static final Consumer<DefaultBuilder> HAS_OUTPUT = b -> Objects.requireNonNull(b.outputDirectory, "Sources directory must not be null");
        private Options options;
        private DefaultCodegen codeGenerator;
        private URI definitionFile;
        private File outputDirectory;
        private final EnumSet<OutputKind> outputs = EnumSet.noneOf(OutputKind.class);
        private JavaMicronautServerCodegen.ServerOptions javaServerOptions;
        private JavaMicronautClientCodegen.ClientOptions javaClientOptions;
        private KotlinMicronautServerCodegen.ServerOptions kotlinServerOptions;
        private KotlinMicronautClientCodegen.ClientOptions kotlinClientOptions;

        private DefaultBuilder() {
        }

        @Override
        public <B extends GeneratorOptionsBuilder, G extends MicronautCodeGenerator<B>> MicronautCodeGeneratorBuilder forCodeGenerator(G generator, Consumer<? super B> configuration) {
            this.codeGenerator = (DefaultCodegen)generator;
            B builder = generator.optionsBuilder();
            configuration.accept(builder);
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forJavaClient(Consumer<? super JavaMicronautClientOptionsBuilder> clientOptionsSpec) {
            this.codeGenerator = new JavaMicronautClientCodegen();
            JavaMicronautClientCodegen.DefaultClientOptionsBuilder clientOptionsBuilder = new JavaMicronautClientCodegen.DefaultClientOptionsBuilder();
            clientOptionsSpec.accept(clientOptionsBuilder);
            this.javaClientOptions = clientOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forJavaServer(Consumer<? super JavaMicronautServerOptionsBuilder> serverOptionsSpec) {
            this.codeGenerator = new JavaMicronautServerCodegen();
            JavaMicronautServerCodegen.DefaultServerOptionsBuilder serverOptionsBuilder = new JavaMicronautServerCodegen.DefaultServerOptionsBuilder();
            serverOptionsSpec.accept(serverOptionsBuilder);
            this.javaServerOptions = serverOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forKotlinClient(Consumer<? super KotlinMicronautClientOptionsBuilder> clientOptionsSpec) {
            this.codeGenerator = new KotlinMicronautClientCodegen();
            KotlinMicronautClientCodegen.DefaultClientOptionsBuilder clientOptionsBuilder = new KotlinMicronautClientCodegen.DefaultClientOptionsBuilder();
            clientOptionsSpec.accept(clientOptionsBuilder);
            this.kotlinClientOptions = clientOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forKotlinServer(Consumer<? super KotlinMicronautServerOptionsBuilder> serverOptionsSpec) {
            this.codeGenerator = new KotlinMicronautServerCodegen();
            KotlinMicronautServerCodegen.DefaultServerOptionsBuilder serverOptionsBuilder = new KotlinMicronautServerCodegen.DefaultServerOptionsBuilder();
            serverOptionsSpec.accept(serverOptionsBuilder);
            this.kotlinServerOptions = serverOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withDefinitionFile(URI definitionFile) {
            this.definitionFile = definitionFile;
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOutputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOutputs(OutputKind ... elements) {
            this.outputs.addAll(Arrays.asList(elements));
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOptions(Consumer<? super MicronautCodeGeneratorOptionsBuilder> optionsConfigurer) {
            DefaultOptionsBuilder builder = new DefaultOptionsBuilder();
            optionsConfigurer.accept(builder);
            this.options = builder.build();
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.definitionFile, "OpenAPI definition file must not be null");
            Objects.requireNonNull(this.codeGenerator, "You must select either server or client generation");
            for (OutputKind output : this.outputs) {
                output.validationAction.accept(this);
            }
        }

        @Override
        public MicronautCodeGeneratorEntryPoint build() {
            this.validate();
            return new MicronautCodeGeneratorEntryPoint(this.definitionFile, this.outputDirectory, this.codeGenerator, this.outputs, this.options, this.javaServerOptions, this.javaClientOptions, this.kotlinServerOptions, this.kotlinClientOptions);
        }

        private static class DefaultOptionsBuilder
        implements MicronautCodeGeneratorOptionsBuilder {
            private String apiPackage;
            private String artifactId;
            private boolean beanValidation = true;
            private String invokerPackage;
            private String modelPackage;
            private List<ParameterMapping> parameterMappings;
            private List<ResponseBodyMapping> responseBodyMappings;
            private boolean optional;
            private boolean reactive = true;
            private boolean generateHttpResponseAlways;
            private boolean generateHttpResponseWhereRequired = true;
            private TestFramework testFramework = TestFramework.JUNIT5;
            private SerializationLibraryKind serializationLibraryKind = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON;
            private MicronautCodeGeneratorOptionsBuilder.DateTimeFormat dateTimeFormat = MicronautCodeGeneratorOptionsBuilder.DateTimeFormat.ZONED_DATETIME;
            private MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage lang = MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.JAVA;

            private DefaultOptionsBuilder() {
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withLang(MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage lang) {
                this.lang = lang;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withApiPackage(String apiPackage) {
                this.apiPackage = apiPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withInvokerPackage(String invokerPackage) {
                this.invokerPackage = invokerPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withModelPackage(String modelPackage) {
                this.modelPackage = modelPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withArtifactId(String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withParameterMappings(List<ParameterMapping> parameterMappings) {
                this.parameterMappings = parameterMappings;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withResponseBodyMappings(List<ResponseBodyMapping> responseBodyMappings) {
                this.responseBodyMappings = responseBodyMappings;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withReactive(boolean reactive) {
                this.reactive = reactive;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withGenerateHttpResponseAlways(boolean generateHttpResponseAlways) {
                this.generateHttpResponseAlways = generateHttpResponseAlways;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withGenerateHttpResponseWhereRequired(boolean generateHttpResponseWhereRequired) {
                this.generateHttpResponseWhereRequired = generateHttpResponseWhereRequired;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withBeanValidation(boolean beanValidation) {
                this.beanValidation = beanValidation;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withOptional(boolean optional) {
                this.optional = optional;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withTestFramework(TestFramework testFramework) {
                this.testFramework = testFramework;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSerializationLibrary(SerializationLibraryKind library) {
                this.serializationLibraryKind = library;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withDateTimeFormat(MicronautCodeGeneratorOptionsBuilder.DateTimeFormat format) {
                this.dateTimeFormat = format;
                return this;
            }

            private Options build() {
                return new Options(this.lang, this.apiPackage, this.modelPackage, this.invokerPackage, this.artifactId, this.parameterMappings, this.responseBodyMappings, this.beanValidation, this.optional, this.reactive, this.generateHttpResponseAlways, this.generateHttpResponseWhereRequired, this.testFramework, this.serializationLibraryKind, this.dateTimeFormat);
            }
        }
    }
}

