/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicronautInlineModelResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicronautInlineModelResolver.class);
    private static ObjectMapper structureMapper = Json.mapper().copy();
    private OpenAPI openAPI;
    private Map<String, Schema> addedModels = new HashMap<String, Schema>();
    private Map<String, String> generatedSignature = new HashMap<String, String>();
    private Map<String, String> inlineSchemaNameMapping = new HashMap<String, String>();
    private Map<String, String> inlineSchemaOptions = new HashMap<String, String>();
    private Set<String> inlineSchemaNameMappingValues = new HashSet<String>();
    private boolean resolveInlineEnums = true;
    private Boolean refactorAllOfInlineSchemas;
    private Set<String> uniqueNames = new HashSet<String>();

    public MicronautInlineModelResolver(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }

    public void flattenPaths() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            Operation operation;
            PathItem path = (PathItem)pathsEntry.getValue();
            LinkedHashMap operationsMap = new LinkedHashMap(path.readOperationsMap());
            String pathname = (String)pathsEntry.getKey();
            for (Map.Entry operationEntry : new LinkedHashMap(path.readOperationsMap()).entrySet()) {
                operation = (Operation)operationEntry.getValue();
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                for (Map.Entry callbackEntry : callbacks.entrySet()) {
                    Callback callback = (Callback)callbackEntry.getValue();
                    for (Map.Entry pathItemEntry : callback.entrySet()) {
                        PathItem pathItem = (PathItem)pathItemEntry.getValue();
                        operationsMap.putAll(pathItem.readOperationsMap());
                    }
                }
            }
            for (Map.Entry operationEntry : operationsMap.entrySet()) {
                operation = (Operation)operationEntry.getValue();
                String inlineSchemaName = this.getInlineSchemaName((PathItem.HttpMethod)operationEntry.getKey(), pathname);
                this.flattenPathItemParameters(inlineSchemaName, operation, path);
            }
        }
    }

    private void flattenPathItemParameters(String modelName, Operation operation, PathItem pathItem) {
        ArrayList parameters = new ArrayList();
        if (pathItem.getParameters() != null) {
            parameters.addAll(pathItem.getParameters());
        }
        if (parameters.isEmpty()) {
            return;
        }
        for (Parameter parameter : parameters) {
            Schema parameterSchema;
            if (parameter.getSchema() == null || (parameterSchema = parameter.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(parameterSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterSchema, schemaName);
            if (!this.isModelNeeded(parameterSchema)) continue;
            Schema refSchema = this.makeSchemaInComponents(schemaName, parameterSchema);
            parameter.setSchema(refSchema);
        }
    }

    private void gatherInlineModels(Schema schema, String modelPrefix) {
        Schema not;
        Schema refSchema;
        Object schemaName;
        Schema refSchema2;
        String schemaName2;
        if (schema.get$ref() != null) {
            if (this.isModelNeeded(schema) || "object".equals(schema.getType()) || schema.getProperties() != null || schema.getAdditionalProperties() != null || ModelUtils.isComposedSchema((Schema)schema)) {
                LOGGER.error("Illegal schema found with $ref combined with other properties, no properties should be defined alongside a $ref:\n {}", (Object)schema);
            }
            return;
        }
        if (schema.getType() == null || "object".equals(schema.getType())) {
            Schema inner;
            Map props = schema.getProperties();
            if (props != null) {
                for (String propName : props.keySet()) {
                    Schema prop = (Schema)props.get(propName);
                    if (prop == null) continue;
                    schemaName2 = this.resolveModelName(prop.getTitle(), modelPrefix + "_" + propName);
                    this.gatherInlineModels(prop, schemaName2);
                    if (this.isModelNeeded(prop)) {
                        refSchema2 = this.makeSchemaInComponents(schemaName2, prop);
                        props.put(propName, refSchema2);
                        continue;
                    }
                    if (!ModelUtils.isComposedSchema((Schema)prop) || prop.getAllOf() == null || prop.getAllOf().size() != 1 || ((Schema)prop.getAllOf().get(0)).getType() == null || "object".equals(((Schema)prop.getAllOf().get(0)).getType())) continue;
                    LOGGER.info("allOf schema used by the property `{}` replaced by its only item (a type)", (Object)propName);
                    props.put(propName, (Schema)prop.getAllOf().get(0));
                }
            }
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema && (inner = (Schema)schema.getAdditionalProperties()) != null) {
                schemaName = this.resolveModelName(schema.getTitle(), modelPrefix + this.inlineSchemaOptions.get("MAP_ITEM_SUFFIX"));
                this.gatherInlineModels(inner, (String)schemaName);
                if (this.isModelNeeded(inner)) {
                    refSchema = this.makeSchemaInComponents((String)schemaName, inner);
                    schema.setAdditionalProperties((Object)refSchema);
                }
            }
        } else {
            if (schema.getProperties() != null) {
                LOGGER.error("Illegal schema found with non-object type combined with properties, no properties should be defined:\n {}", (Object)schema);
                return;
            }
            if (schema.getAdditionalProperties() != null) {
                LOGGER.error("Illegal schema found with non-object type combined with additionalProperties, no additionalProperties should be defined:\n {}", (Object)schema);
                return;
            }
        }
        if (schema instanceof ArraySchema) {
            ArraySchema array = (ArraySchema)schema;
            Schema items = array.getItems();
            if (items == null) {
                LOGGER.error("Illegal schema found with array type but no items, items must be defined for array schemas:\n {}", (Object)schema);
                return;
            }
            schemaName = this.resolveModelName(items.getTitle(), modelPrefix + this.inlineSchemaOptions.get("ARRAY_ITEM_SUFFIX"));
            this.gatherInlineModels(items, (String)schemaName);
            if (this.isModelNeeded(items)) {
                refSchema = this.makeSchemaInComponents((String)schemaName, items);
                array.setItems(refSchema);
            }
        }
        if (ModelUtils.isComposedSchema((Schema)schema)) {
            Schema refSchema3;
            String schemaName3;
            if (schema.getAllOf() != null) {
                ArrayList<Schema> newAllOf = new ArrayList<Schema>();
                boolean atLeastOneModel = false;
                for (Object inner : schema.getAllOf()) {
                    if (inner == null) continue;
                    schemaName2 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_allOf");
                    this.gatherInlineModels((Schema)inner, schemaName2);
                    if (this.isModelNeeded((Schema)inner)) {
                        if (Boolean.TRUE.equals(this.refactorAllOfInlineSchemas)) {
                            refSchema2 = this.makeSchemaInComponents(schemaName2, (Schema)inner);
                            newAllOf.add(refSchema2);
                            atLeastOneModel = true;
                            continue;
                        }
                        newAllOf.add((Schema)inner);
                        atLeastOneModel = true;
                        continue;
                    }
                    newAllOf.add((Schema)inner);
                }
                if (atLeastOneModel) {
                    schema.setAllOf(newAllOf);
                } else if (schema.getAllOf().size() > 1) {
                    LOGGER.warn("allOf schema `{}` containing multiple types (not model) is not supported at the moment.", (Object)schema.getName());
                } else if (schema.getAllOf().size() != 1) {
                    LOGGER.error("allOf schema `{}` contains no items.", (Object)schema.getName());
                }
            }
            if (schema.getAnyOf() != null) {
                ArrayList<Schema> newAnyOf = new ArrayList<Schema>();
                for (Object inner : schema.getAnyOf()) {
                    if (inner == null) continue;
                    schemaName3 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_anyOf");
                    this.gatherInlineModels((Schema)inner, schemaName3);
                    if (this.isModelNeeded((Schema)inner)) {
                        refSchema3 = this.makeSchemaInComponents(schemaName3, (Schema)inner);
                        newAnyOf.add(refSchema3);
                        continue;
                    }
                    newAnyOf.add((Schema)inner);
                }
                schema.setAnyOf(newAnyOf);
            }
            if (schema.getOneOf() != null) {
                ArrayList<Schema> newOneOf = new ArrayList<Schema>();
                for (Object inner : schema.getOneOf()) {
                    if (inner == null) continue;
                    schemaName3 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_oneOf");
                    this.gatherInlineModels((Schema)inner, schemaName3);
                    if (this.isModelNeeded((Schema)inner)) {
                        refSchema3 = this.makeSchemaInComponents(schemaName3, (Schema)inner);
                        newOneOf.add(refSchema3);
                        continue;
                    }
                    newOneOf.add((Schema)inner);
                }
                schema.setOneOf(newOneOf);
            }
        }
        if (schema.getNot() != null && (not = schema.getNot()) != null) {
            String schemaName4 = this.resolveModelName(schema.getTitle(), modelPrefix + "_not");
            this.gatherInlineModels(not, schemaName4);
            if (this.isModelNeeded(not)) {
                Schema refSchema4 = this.makeSchemaInComponents(schemaName4, not);
                schema.setNot(refSchema4);
            }
        }
    }

    private String resolveModelName(String title, String key) {
        return title == null ? this.uniqueName(key) : this.uniqueName(title);
    }

    private String getInlineSchemaName(PathItem.HttpMethod httpVerb, String pathname) {
        if (pathname.startsWith("/")) {
            pathname = pathname.substring(1);
        }
        Object name = pathname.replace('/', '_').replaceAll("[{}]", "");
        if (httpVerb == PathItem.HttpMethod.DELETE) {
            name = (String)name + "_delete";
        } else if (httpVerb == PathItem.HttpMethod.GET) {
            name = (String)name + "_get";
        } else if (httpVerb == PathItem.HttpMethod.HEAD) {
            name = (String)name + "_head";
        } else if (httpVerb == PathItem.HttpMethod.OPTIONS) {
            name = (String)name + "_options";
        } else if (httpVerb == PathItem.HttpMethod.PATCH) {
            name = (String)name + "_patch";
        } else if (httpVerb == PathItem.HttpMethod.POST) {
            name = (String)name + "_post";
        } else if (httpVerb == PathItem.HttpMethod.PUT) {
            name = (String)name + "_put";
        } else if (httpVerb == PathItem.HttpMethod.TRACE) {
            name = (String)name + "_trace";
        }
        return name;
    }

    private Schema makeSchemaInComponents(String name, Schema schema) {
        Schema refSchema;
        String existing = this.matchGenerated(schema);
        if (existing != null) {
            refSchema = new Schema().$ref(existing);
        } else {
            if (this.resolveInlineEnums && schema.getEnum() != null && schema.getEnum().size() > 0) {
                LOGGER.warn("Model {} promoted to its own schema due to resolveInlineEnums=true", (Object)name);
            }
            name = this.addSchemas(name, schema);
            refSchema = new Schema().$ref(name);
        }
        this.copyVendorExtensions(schema, refSchema);
        return refSchema;
    }

    private void copyVendorExtensions(Schema source, Schema target) {
        Map vendorExtensions = source.getExtensions();
        if (vendorExtensions == null) {
            return;
        }
        for (String extName : vendorExtensions.keySet()) {
            target.addExtension(extName, vendorExtensions.get(extName));
        }
    }

    private String matchGenerated(Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            if (this.generatedSignature.containsKey(json)) {
                return this.generatedSignature.get(json);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isModelNeeded(Schema schema) {
        return this.isModelNeeded(schema, new HashSet<Schema>());
    }

    private boolean isModelNeeded(Schema schema, Set<Schema> visitedSchemas) {
        if (visitedSchemas.contains(schema)) {
            return true;
        }
        visitedSchemas.add(schema);
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return true;
        }
        if ((schema.getType() == null || "object".equals(schema.getType())) && schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            return true;
        }
        if (ModelUtils.isComposedSchema((Schema)schema)) {
            boolean isNullable;
            boolean isSingleAllOf = schema.getAllOf() != null && schema.getAllOf().size() == 1;
            boolean isReadOnly = schema.getReadOnly() != null && schema.getReadOnly() != false;
            boolean bl = isNullable = schema.getNullable() != null && schema.getNullable() != false;
            if (isSingleAllOf && (isReadOnly || isNullable)) {
                ComposedSchema c = new ComposedSchema();
                c.setAllOf(schema.getAllOf());
                c.setReadOnly(schema.getReadOnly());
                c.setNullable(schema.getNullable());
                if (schema.equals((Object)c)) {
                    return this.isModelNeeded((Schema)schema.getAllOf().get(0), visitedSchemas);
                }
            } else if (isSingleAllOf && StringUtils.isNotEmpty((CharSequence)((Schema)schema.getAllOf().get(0)).get$ref())) {
                return this.isModelNeeded((Schema)schema.getAllOf().get(0), visitedSchemas);
            }
            if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
                for (Object inner : schema.getAllOf()) {
                    if (!this.isModelNeeded(ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)((Schema)inner)), visitedSchemas)) continue;
                    return true;
                }
                return false;
            }
            if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
                return true;
            }
            if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private String addSchemas(String name, Schema schema) {
        if (this.inlineSchemaNameMapping.containsKey(name)) {
            name = this.inlineSchemaNameMapping.get(name);
        }
        this.addGenerated(name, schema);
        this.openAPI.getComponents().addSchemas(name, schema);
        if (!name.equals(schema.getTitle()) && !this.inlineSchemaNameMappingValues.contains(name)) {
            LOGGER.info("Inline schema created as {}. To have complete control of the model name, set the `title` field or use the modelNameMapping option (e.g. --model-name-mappings {}=NewModel,ModelA=NewModelA in CLI) or inlineSchemaNameMapping option (--inline-schema-name-mappings {}=NewModel,ModelA=NewModelA in CLI).", new Object[]{name, name, name});
        }
        this.uniqueNames.add(name);
        return name;
    }

    private void addGenerated(String name, Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            this.generatedSignature.put(json, name);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private String uniqueName(String name) {
        if (this.openAPI.getComponents().getSchemas() == null) {
            return name;
        }
        Object uniqueName = name;
        int count = 0;
        while (this.openAPI.getComponents().getSchemas().containsKey(uniqueName) || this.uniqueNames.contains(uniqueName)) {
            uniqueName = name + "_" + ++count;
        }
        return uniqueName;
    }

    static {
        structureMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        structureMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

