/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.micronaut.openapi.generator.Formatting;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautClientCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerCodegen;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautInlineModelResolver;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.ResponseBodyMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.micronaut.openapi.generator.Utils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.atteo.evo.inflector.English;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;

public abstract class AbstractMicronautJavaCodegen<T extends GeneratorOptionsBuilder>
extends AbstractJavaCodegen
implements BeanValidationFeatures,
OptionalFeatures,
MicronautCodeGenerator<T> {
    public static final String OPT_TITLE = "title";
    public static final String OPT_TEST = "test";
    public static final String OPT_TEST_JUNIT = "junit";
    public static final String OPT_TEST_SPOCK = "spock";
    public static final String OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR = "requiredPropertiesInConstructor";
    public static final String OPT_USE_AUTH = "useAuth";
    public static final String OPT_USE_LOMBOK = "lombok";
    public static final String OPT_USE_PLURAL = "plural";
    public static final String OPT_FLUX_FOR_ARRAYS = "fluxForArrays";
    public static final String OPT_GENERATED_ANNOTATION = "generatedAnnotation";
    public static final String OPT_VISITABLE = "visitable";
    public static final String OPT_DATE_LIBRARY_ZONED_DATETIME = "ZONED_DATETIME";
    public static final String OPT_DATE_LIBRARY_OFFSET_DATETIME = "OFFSET_DATETIME";
    public static final String OPT_DATE_LIBRARY_LOCAL_DATETIME = "LOCAL_DATETIME";
    public static final String OPT_DATE_FORMAT = "dateFormat";
    public static final String OPT_DATETIME_FORMAT = "datetimeFormat";
    public static final String OPT_REACTIVE = "reactive";
    public static final String OPT_GENERATE_HTTP_RESPONSE_ALWAYS = "generateHttpResponseAlways";
    public static final String OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED = "generateHttpResponseWhereRequired";
    public static final String OPT_APPLICATION_NAME = "applicationName";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS = "generateSwaggerAnnotations";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1 = "swagger1";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2 = "swagger2";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE = "true";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE = "false";
    public static final String OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG = "generateOperationOnlyForFirstTag";
    public static final String CONTENT_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_ANY = "*/*";
    private static final String MONO_CLASS_NAME = "reactor.core.publisher.Mono";
    private static final String FLUX_CLASS_NAME = "reactor.core.publisher.Flux";
    protected SecureRandom random = new SecureRandom();
    protected String title;
    protected boolean useBeanValidation = true;
    protected boolean useOptional;
    protected boolean visitable;
    protected boolean lombok;
    protected boolean fluxForArrays;
    protected boolean plural = true;
    protected boolean generatedAnnotation = true;
    protected String testTool;
    protected boolean requiredPropertiesInConstructor = true;
    protected boolean reactive;
    protected boolean generateHttpResponseAlways;
    protected boolean generateHttpResponseWhereRequired = true;
    protected String appName;
    protected String generateSwaggerAnnotations;
    protected boolean generateOperationOnlyForFirstTag;
    protected String serializationLibrary = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name();
    protected List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
    protected List<ResponseBodyMapping> responseBodyMappings = new ArrayList<ResponseBodyMapping>();
    protected Map<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();

    protected AbstractMicronautJavaCodegen() {
        this.useJakartaEe = true;
        this.useOptional = false;
        this.visitable = false;
        this.testTool = OPT_TEST_JUNIT;
        this.outputFolder = this instanceof JavaMicronautClientCodegen ? "generated-code/java-micronaut-client" : "generated-code/java-micronaut";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools";
        this.artifactId = this instanceof JavaMicronautClientCodegen ? "openapi-micronaut-client" : "openapi-micronaut";
        this.templateDir = "templates/java-micronaut";
        this.embeddedTemplateDir = "templates/java-micronaut";
        this.apiDocPath = "docs/apis";
        this.modelDocPath = "docs/models";
        this.dateLibrary = OPT_DATE_LIBRARY_ZONED_DATETIME;
        this.reactive = true;
        this.appName = this.artifactId;
        this.generateSwaggerAnnotations = this instanceof JavaMicronautClientCodegen ? OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE : OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
        this.generateOperationOnlyForFirstTag = this instanceof JavaMicronautServerCodegen;
        this.openApiNullable = false;
        this.inlineSchemaOption.put("RESOLVE_INLINE_ENUMS", OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE);
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, new SecurityFeature[]{SecurityFeature.BearerToken, SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OpenIDConnect})));
        this.additionalProperties.put("openbrace", "{");
        this.additionalProperties.put("closebrace", "}");
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.cliOptions.add(new CliOption(OPT_TITLE, "Client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(OPT_APPLICATION_NAME, "Micronaut application name (Defaults to the artifactId value)").defaultValue(this.appName));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_LOMBOK, (String)"Whether or not to use lombok annotations in generated code", (boolean)this.lombok));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_PLURAL, (String)"Whether or not to use plural for request body parameter name", (boolean)this.plural));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_FLUX_FOR_ARRAYS, (String)"Whether or not to use Flux<?> instead Mono<List<?>> for arrays in generated code", (boolean)this.fluxForArrays));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATED_ANNOTATION, (String)"Generate code with \"@Generated\" annotation", (boolean)this.generatedAnnotation));
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations", (boolean)this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)"useOptional", (String)"Use Optional container for optional parameters", (boolean)this.useOptional));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_VISITABLE, (String)"Generate visitor for subtypes with a discriminator", (boolean)this.visitable));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, (String)"Allow only to create models with all the required properties provided in constructor", (boolean)this.requiredPropertiesInConstructor));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REACTIVE, (String)"Make the responses use Reactor Mono as wrapper", (boolean)this.reactive));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_ALWAYS, (String)"Always wrap the operations response in HttpResponse object", (boolean)this.generateHttpResponseAlways));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, (String)"Wrap the operations response in HttpResponse object where non-200 HTTP status codes or additional headers are defined", (boolean)this.generateHttpResponseWhereRequired));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, (String)"When false, the operation method will be duplicated in each of the tags if multiple tags are assigned to this operation. If true, each operation will be generated only once in the first assigned tag.", (boolean)this.generateOperationOnlyForFirstTag));
        CliOption testToolOption = new CliOption(OPT_TEST, "Specify which test tool to generate files for").defaultValue(this.testTool);
        HashMap<String, String> testToolOptionMap = new HashMap<String, String>();
        testToolOptionMap.put(OPT_TEST_JUNIT, "Use JUnit as test tool");
        testToolOptionMap.put(OPT_TEST_SPOCK, "Use Spock as test tool");
        testToolOption.setEnum(testToolOptionMap);
        this.cliOptions.add(testToolOption);
        CliOption generateSwaggerAnnotationsOption = new CliOption(OPT_GENERATE_SWAGGER_ANNOTATIONS, "Specify if you want to generate swagger annotations and which version").defaultValue(this.generateSwaggerAnnotations);
        HashMap<String, String> generateSwaggerAnnotationsOptionMap = new HashMap<String, String>();
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1, "Use io.swagger:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2, "Use io.swagger.core.v3:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE, "Equivalent to \"swagger2\"");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE, "Do not generate swagger annotations");
        generateSwaggerAnnotationsOption.setEnum(generateSwaggerAnnotationsOptionMap);
        this.cliOptions.add(generateSwaggerAnnotationsOption);
        this.cliOptions.add(new CliOption(OPT_DATE_FORMAT, "Specify the format pattern of date as a string"));
        this.cliOptions.add(new CliOption(OPT_DATETIME_FORMAT, "Specify the format pattern of date-time as a string"));
        this.cliOptions.stream().filter(o -> o.getOpt().equals("dateLibrary")).findFirst().ifPresent(opt -> {
            HashMap<String, String> valuesEnum = new HashMap<String, String>();
            valuesEnum.put(OPT_DATE_LIBRARY_OFFSET_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_OFFSET_DATETIME));
            valuesEnum.put(OPT_DATE_LIBRARY_LOCAL_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_LOCAL_DATETIME));
            opt.setEnum(valuesEnum);
        });
        CliOption serializationLibraryOpt = CliOption.newString((String)"serializationLibrary", (String)"Serialization library for model");
        serializationLibraryOpt.defaultValue(SerializationLibraryKind.JACKSON.name());
        HashMap<String, String> serializationLibraryOptions = new HashMap<String, String>();
        serializationLibraryOptions.put(SerializationLibraryKind.JACKSON.name(), "Jackson as serialization library");
        serializationLibraryOptions.put(SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name(), "Use micronaut-serialization with Jackson annotations");
        serializationLibraryOpt.setEnum(serializationLibraryOptions);
        this.cliOptions.add(serializationLibraryOpt);
        List<String> micronautReservedWords = List.of("Object", "List", "File", "OffsetDateTime", "LocalDate", "LocalTime", "Client", "Format", "QueryValue", "QueryParam", "PathVariable", "Header", "Cookie", "Authorization", "Body", "application");
        this.reservedWords.addAll(micronautReservedWords);
        List.of("object", "list", "file", "offsetdatetime", "localdate", "localtime").forEach(this.reservedWords::remove);
        this.importMapping.put("DateTime", "java.time.Instant");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("Function", "java.util.function.Function");
    }

    public void setGenerateHttpResponseAlways(boolean generateHttpResponseAlways) {
        this.generateHttpResponseAlways = generateHttpResponseAlways;
    }

    public void setGenerateHttpResponseWhereRequired(boolean generateHttpResponseWhereRequired) {
        this.generateHttpResponseWhereRequired = generateHttpResponseWhereRequired;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setTestTool(String testTool) {
        this.testTool = testTool;
    }

    public void setArtifactId(String artifactId) {
        super.setArtifactId(artifactId);
        this.updateOption("artifactId", artifactId);
    }

    public void setModelPackage(String modelPackage) {
        super.setModelPackage(modelPackage);
        this.updateOption("modelPackage", modelPackage);
    }

    public void setApiPackage(String apiPackage) {
        super.setApiPackage(apiPackage);
        this.updateOption("apiPackage", apiPackage);
    }

    public void setApiNamePrefix(String apiNamePrefix) {
        super.setApiNamePrefix(apiNamePrefix);
        this.updateOption("apiNamePrefix", apiNamePrefix);
    }

    public void setApiNameSuffix(String apiNameSuffix) {
        super.setApiNameSuffix(apiNameSuffix);
        this.updateOption("apiNameSuffix", apiNameSuffix);
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        super.setModelNamePrefix(modelNamePrefix);
        this.updateOption("modelNamePrefix", modelNamePrefix);
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        super.setModelNameSuffix(modelNameSuffix);
        this.updateOption("modelNameSuffix", modelNameSuffix);
    }

    public void setInvokerPackage(String invokerPackage) {
        super.setInvokerPackage(invokerPackage);
        this.updateOption("invokerPackage", this.getInvokerPackage());
    }

    public void setLombok(boolean lombok) {
        this.lombok = lombok;
    }

    public void setPlural(boolean plural) {
        this.plural = plural;
    }

    public void setFluxForArrays(boolean fluxForArrays) {
        this.fluxForArrays = fluxForArrays;
    }

    public void setGeneratedAnnotation(boolean generatedAnnotation) {
        this.generatedAnnotation = generatedAnnotation;
    }

    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_TITLE)) {
            this.title = (String)this.additionalProperties.get(OPT_TITLE);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.invokerPackage = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey(OPT_APPLICATION_NAME)) {
            this.appName = (String)this.additionalProperties.get(OPT_APPLICATION_NAME);
        } else {
            this.additionalProperties.put(OPT_APPLICATION_NAME, this.artifactId);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.useBeanValidation = this.convertPropertyToBoolean("useBeanValidation");
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(OPT_USE_LOMBOK)) {
            this.lombok = this.convertPropertyToBoolean(OPT_USE_LOMBOK);
        }
        this.writePropertyBack(OPT_USE_LOMBOK, this.lombok);
        if (this.additionalProperties.containsKey(OPT_USE_PLURAL)) {
            this.plural = this.convertPropertyToBoolean(OPT_USE_PLURAL);
        }
        this.writePropertyBack(OPT_USE_PLURAL, this.plural);
        if (this.additionalProperties.containsKey(OPT_FLUX_FOR_ARRAYS)) {
            this.fluxForArrays = this.convertPropertyToBoolean(OPT_FLUX_FOR_ARRAYS);
        }
        this.writePropertyBack(OPT_FLUX_FOR_ARRAYS, this.fluxForArrays);
        if (this.additionalProperties.containsKey(OPT_GENERATED_ANNOTATION)) {
            this.generatedAnnotation = this.convertPropertyToBoolean(OPT_GENERATED_ANNOTATION);
        }
        this.writePropertyBack(OPT_GENERATED_ANNOTATION, this.generatedAnnotation);
        if (this.additionalProperties.containsKey("useOptional")) {
            this.useOptional = this.convertPropertyToBoolean("useOptional");
        }
        this.writePropertyBack("useOptional", this.useOptional);
        if (this.additionalProperties.containsKey(OPT_VISITABLE)) {
            this.visitable = this.convertPropertyToBoolean(OPT_VISITABLE);
        }
        this.writePropertyBack(OPT_VISITABLE, this.visitable);
        if (this.additionalProperties.containsKey(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR)) {
            this.requiredPropertiesInConstructor = this.convertPropertyToBoolean(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR);
        }
        this.writePropertyBack(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, this.requiredPropertiesInConstructor);
        if (this.additionalProperties.containsKey(OPT_REACTIVE)) {
            this.reactive = this.convertPropertyToBoolean(OPT_REACTIVE);
        }
        this.writePropertyBack(OPT_REACTIVE, this.reactive);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_ALWAYS)) {
            this.generateHttpResponseAlways = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_ALWAYS);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_ALWAYS, this.generateHttpResponseAlways);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED)) {
            this.generateHttpResponseWhereRequired = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, this.generateHttpResponseWhereRequired);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG)) {
            this.generateOperationOnlyForFirstTag = this.convertPropertyToBoolean(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, this.generateOperationOnlyForFirstTag);
        this.maybeSetTestTool();
        this.writePropertyBack(OPT_TEST, this.testTool);
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.additionalProperties.put("isTestJunit", true);
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.additionalProperties.put("isTestSpock", true);
        }
        this.maybeSetSwagger();
        if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger1Annotations", true);
        } else if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
        }
        this.additionalProperties.put(this.serializationLibrary.toLowerCase(Locale.US), true);
        if (SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name().equals(this.serializationLibrary)) {
            this.additionalProperties.put(SerializationLibraryKind.JACKSON.name().toLowerCase(Locale.US), true);
        }
        String resourceFolder = this.projectFolder + "/resources";
        this.supportingFiles.add(new SupportingFile("common/configuration/application.yml.mustache", resourceFolder, "application.yml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("common/configuration/logback.xml.mustache", resourceFolder, "logback.xml").doNotOverwrite());
        this.additionalProperties.put("javaxPackage", "jakarta");
        switch (this.dateLibrary) {
            case "OFFSET_DATETIME": {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.typeMapping.put("date", "LocalDate");
                break;
            }
            case "ZONED_DATETIME": {
                this.typeMapping.put("DateTime", "ZonedDateTime");
                this.typeMapping.put("date", "LocalDate");
                break;
            }
            case "LOCAL_DATETIME": {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.typeMapping.put("date", "LocalDate");
                break;
            }
        }
        this.modelDocTemplateFiles.clear();
        this.modelDocTemplateFiles.put("common/doc/model_doc.mustache", ".md");
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("common/model/model.mustache", ".java");
        this.modelTestTemplateFiles.clear();
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.modelTestTemplateFiles.put("common/test/model_test.mustache", ".java");
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.modelTestTemplateFiles.put("common/test/model_test.groovy.mustache", ".groovy");
        }
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        String apiFolder = (this.sourceFolder + "/" + this.apiPackage()).replace('.', '/');
        String modelFolder = (this.sourceFolder + "/" + this.modelPackage()).replace('.', '/');
        this.additionalProperties.put("invokerFolder", invokerFolder);
        this.additionalProperties.put("resourceFolder", resourceFolder);
        this.additionalProperties.put("apiFolder", apiFolder);
        this.additionalProperties.put("modelFolder", modelFolder);
        this.additionalProperties.put("formatNoEmptyLines", new Formatting.LineFormatter(0));
        this.additionalProperties.put("formatOneEmptyLine", new Formatting.LineFormatter(1));
        this.additionalProperties.put("formatSingleLine", new Formatting.SingleLineFormatter());
        this.additionalProperties.put("indent", new Formatting.IndentFormatter(4));
    }

    public void addParameterMappings(List<ParameterMapping> parameterMappings) {
        this.parameterMappings.addAll(parameterMappings);
    }

    public void addResponseBodyMappings(List<ResponseBodyMapping> responseBodyMappings) {
        this.responseBodyMappings.addAll(responseBodyMappings);
    }

    public void addSchemaMapping(Map<String, String> schemaMapping) {
        this.schemaMapping.putAll(schemaMapping);
    }

    public void addImportMapping(Map<String, String> importMapping) {
        this.importMapping.putAll(importMapping);
    }

    public void addNameMapping(Map<String, String> nameMapping) {
        this.nameMapping.putAll(nameMapping);
    }

    public void addTypeMapping(Map<String, String> typeMapping) {
        this.typeMapping.putAll(typeMapping);
    }

    public void addEnumNameMapping(Map<String, String> enumNameMapping) {
        this.enumNameMapping.putAll(enumNameMapping);
    }

    public void addModelNameMapping(Map<String, String> modelNameMapping) {
        this.modelNameMapping.putAll(modelNameMapping);
    }

    public void addInlineSchemaNameMapping(Map<String, String> inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping.putAll(inlineSchemaNameMapping);
    }

    public void addInlineSchemaOption(Map<String, String> inlineSchemaOption) {
        this.inlineSchemaOption.putAll(inlineSchemaOption);
    }

    public void addOpenapiNormalizer(Map<String, String> openapiNormalizer) {
        this.openapiNormalizer.putAll(openapiNormalizer);
    }

    private void maybeSetSwagger() {
        if (this.additionalProperties.containsKey(OPT_GENERATE_SWAGGER_ANNOTATIONS)) {
            String value;
            switch (value = String.valueOf(this.additionalProperties.get(OPT_GENERATE_SWAGGER_ANNOTATIONS))) {
                case "swagger1": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1;
                    break;
                }
                case "swagger2": 
                case "true": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
                    break;
                }
                case "false": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
                    break;
                }
                default: {
                    throw new RuntimeException("Value \"" + value + "\" for the generateSwaggerAnnotations parameter is unsupported or misspelled");
                }
            }
        }
    }

    private void maybeSetTestTool() {
        if (this.additionalProperties.containsKey(OPT_TEST)) {
            switch ((String)this.additionalProperties.get(OPT_TEST)) {
                case "junit": 
                case "spock": {
                    this.testTool = (String)this.additionalProperties.get(OPT_TEST);
                    break;
                }
                default: {
                    throw new RuntimeException("Test tool \"" + this.additionalProperties.get(OPT_TEST) + "\" is not supported or misspelled.");
                }
            }
        }
    }

    public String testFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return (this.getOutputDir() + "/src/test/groovy/").replace('/', File.separatorChar);
        }
        return (this.getOutputDir() + "/src/test/java/").replace('/', File.separatorChar);
    }

    public abstract boolean isServer();

    public String apiTestFileFolder() {
        return this.testFileFolder() + this.apiPackage().replaceAll("\\.", "/");
    }

    public String modelTestFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.getOutputDir() + "/src/test/groovy/" + this.modelPackage().replace('.', File.separatorChar);
        }
        return this.getOutputDir() + "/src/test/java/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String toApiTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toApiName(name) + "Spec";
        }
        return this.toApiName(name) + "Test";
    }

    public String toModelTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toModelName(name) + "Spec";
        }
        return this.toModelName(name) + "Test";
    }

    public CodegenParameter fromParameter(Parameter p, Set<String> imports) {
        CodegenParameter parameter = super.fromParameter(p, imports);
        String realName = parameter.paramName;
        if (realName.startsWith("_") && !parameter.baseName.startsWith("_") && this.isReservedWord(parameter.baseName)) {
            realName = realName.replaceFirst("_", "");
        }
        parameter.vendorExtensions.put("realName", realName);
        Utils.addStrValueToEnum(parameter.items);
        return parameter;
    }

    public CodegenProperty fromProperty(String name, Schema p, boolean required, boolean schemaIsFromAdditionalProperties) {
        CodegenProperty property = super.fromProperty(name, p, required, schemaIsFromAdditionalProperties);
        String realName = property.name;
        if (realName.startsWith("_") && !property.baseName.startsWith("_") && this.isReservedWord(property.baseName)) {
            realName = realName.replaceFirst("_", "");
            property.nameInCamelCase = StringUtils.camelize((String)realName);
            property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInCamelCase);
            if (!property.getter.startsWith("get_")) {
                property.getter = "get" + this.getterAndSetterCapitalize(property.name);
            }
            if (!property.setter.startsWith("set_")) {
                property.setter = "set" + this.getterAndSetterCapitalize(property.name);
            }
        }
        property.vendorExtensions.put("realName", realName);
        return property;
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    public void setVisitable(boolean visitable) {
        this.visitable = visitable;
    }

    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public String sanitizeTag(String tag) {
        return tag;
    }

    public String toApiName(String name) {
        return Utils.toApiName(name, this.apiNamePrefix, this.apiNameSuffix);
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.generateOperationOnlyForFirstTag && !((Tag)co.tags.get(0)).getName().equals(tag)) {
            return;
        }
        super.addOperationToGroup(super.sanitizeTag(tag), resourcePath, operation, co, operations);
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (openAPI.getPaths() != null) {
            for (PathItem path : openAPI.getPaths().values()) {
                if (path.getParameters() == null || path.getParameters().isEmpty()) continue;
                for (Operation op : path.readOperations()) {
                    if (op.getParameters() == null) {
                        op.setParameters(new ArrayList());
                    }
                    for (Parameter param : path.getParameters()) {
                        boolean found = false;
                        for (Parameter opParam : op.getParameters()) {
                            if (!Objects.equals(opParam.getName(), param.getName()) || !Objects.equals(opParam.get$ref(), param.get$ref())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        op.getParameters().add(param);
                    }
                }
            }
        }
        MicronautInlineModelResolver inlineModelResolver = new MicronautInlineModelResolver(openAPI);
        inlineModelResolver.setInlineSchemaNameMapping(this.inlineSchemaNameMapping);
        inlineModelResolver.setInlineSchemaOptions(this.inlineSchemaOption);
        inlineModelResolver.flatten();
        super.preprocessOpenAPI(openAPI);
    }

    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map<String, CodegenModel> models = allModels.stream().map(ModelMap::getModel).collect(Collectors.toMap(v -> v.classname, v -> v));
        OperationMap operations = objs.getOperations();
        List operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("methodAllowsBody", op.httpMethod.equals("PUT") || op.httpMethod.equals("POST") || op.httpMethod.equals("PATCH") || op.httpMethod.equals("OPTIONS") || op.httpMethod.equals("DELETE"));
            if (op.returnType != null) {
                String groovyExample;
                String example;
                if (models.containsKey(op.returnType)) {
                    CodegenModel m = models.get(op.returnType);
                    List allowableValues = null;
                    if (m.allowableValues != null && m.allowableValues.containsKey("values")) {
                        allowableValues = (List)m.allowableValues.get("values");
                    }
                    example = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, false, false);
                    groovyExample = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, true, false);
                } else {
                    example = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, false, false);
                    groovyExample = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, true, false);
                }
                op.vendorExtensions.put("example", example);
                op.vendorExtensions.put("groovyExample", groovyExample);
            }
            if (CONTENT_TYPE_ANY.equals(op.vendorExtensions.get("x-contentType"))) {
                op.vendorExtensions.put("x-contentType", CONTENT_TYPE_APPLICATION_JSON);
            }
            op.consumes = op.consumes == null ? null : op.consumes.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            List list = op.produces = op.produces == null ? null : op.produces.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            if (op.consumes == null || op.consumes.isEmpty() || op.consumes.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.consumes.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultConsumeOrEmpty", true);
            }
            if (op.produces == null || op.produces.isEmpty() || op.produces.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.produces.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultProduceOrEmpty", true);
            }
            if (CONTENT_TYPE_APPLICATION_FORM_URLENCODED.equals(op.vendorExtensions.get("x-contentType"))) {
                op.formParams.addAll(op.bodyParams);
                op.bodyParams.forEach(p -> {
                    p.isBodyParam = false;
                    p.isFormParam = true;
                });
                op.bodyParams.clear();
            } else if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(op.vendorExtensions.get("x-contentType"))) {
                op.bodyParams.addAll(op.formParams);
                op.formParams.forEach(p -> {
                    p.isBodyParam = true;
                    p.isFormParam = false;
                });
                op.formParams.clear();
            }
            for (CodegenParameter param : op.allParams) {
                Utils.processGenericAnnotations(param, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false);
                if (!this.useBeanValidation || param.isContainer || !param.isModel) continue;
                param.vendorExtensions.put("withValid", true);
            }
            if (op.returnProperty == null) continue;
            Utils.processGenericAnnotations(op.returnProperty, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false);
            op.returnType = op.returnProperty.vendorExtensions.get("typeWithEnumWithGenericAnnotations").toString();
        }
        return objs;
    }

    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        this.allModels.put(name, codegenModel);
        return codegenModel;
    }

    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "L";
        }
        if ("Float".equals(datatype)) {
            return value + "F";
        }
        if ("BigDecimal".equals(datatype)) {
            return "new BigDecimal(\"" + value + "\")";
        }
        if ("URI".equals(datatype)) {
            return "URI.create(\"" + this.escapeText(value) + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (op.isResponseFile) {
            op.returnProperty.dataType = op.returnType = (String)this.typeMapping.get("responseFile");
            op.returnProperty.datatypeWithEnum = op.returnType;
            op.imports.add(op.returnType);
        }
        op.vendorExtensions.put("originalParams", new ArrayList(op.allParams));
        boolean hasMultipleParams = false;
        int notBodyParamsSize = 0;
        for (CodegenParameter param : op.allParams) {
            if (param.isBodyParam || ++notBodyParamsSize <= 1) continue;
            hasMultipleParams = true;
            break;
        }
        for (CodegenParameter param : op.allParams) {
            param.vendorExtensions.put("hasNotBodyParam", notBodyParamsSize > 0);
            param.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
        }
        op.vendorExtensions.put("originReturnProperty", op.returnProperty);
        if (op.responses != null && !op.responses.isEmpty()) {
            for (CodegenResponse resp : op.responses) {
                if (!resp.isDefault) continue;
                resp.code = "default";
            }
        }
        this.processParametersWithAdditionalMappings(op.allParams, op.imports);
        this.processWithResponseBodyMapping(op);
        this.processOperationWithResponseWrappers(op);
        return op;
    }

    private void processParametersWithAdditionalMappings(List<CodegenParameter> params, Set<String> imports) {
        LinkedHashMap<String, ParameterMapping> additionalMappings = new LinkedHashMap<String, ParameterMapping>();
        Iterator<CodegenParameter> iter = params.iterator();
        while (iter.hasNext()) {
            CodegenParameter param = iter.next();
            boolean paramWasMapped = false;
            for (ParameterMapping mapping : this.parameterMappings) {
                if (!mapping.doesMatch(param)) continue;
                additionalMappings.put(mapping.mappedName(), mapping);
                paramWasMapped = true;
            }
            if (paramWasMapped) {
                iter.remove();
                continue;
            }
            if (!this.plural || !param.isArray || !param.isBodyParam || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.getRef()) || "requestBody".equals(param.paramName)) continue;
            param.paramName = English.plural((String)param.paramName);
        }
        for (ParameterMapping mapping : additionalMappings.values()) {
            String typeName;
            if (mapping.mappedType() == null) continue;
            CodegenParameter newParam = new CodegenParameter();
            newParam.paramName = mapping.mappedName();
            newParam.required = true;
            newParam.isModel = mapping.isValidated();
            newParam.dataType = typeName = this.makeSureImported(mapping.mappedType(), imports);
            if (newParam.paramName == null) {
                newParam.paramName = this.toParamName(typeName);
            }
            params.add(newParam);
        }
    }

    private void processWithResponseBodyMapping(CodegenOperation op) {
        ResponseBodyMapping bodyMapping = null;
        Iterator iter = op.responseHeaders.iterator();
        while (iter.hasNext()) {
            CodegenProperty header = (CodegenProperty)iter.next();
            boolean headerWasMapped = false;
            for (ResponseBodyMapping mapping : this.responseBodyMappings) {
                if (!mapping.doesMatch(header.baseName, op.isArray)) continue;
                if (mapping.mappedBodyType() != null) {
                    bodyMapping = mapping;
                }
                headerWasMapped = true;
            }
            if (!headerWasMapped) continue;
            iter.remove();
        }
        if (bodyMapping != null) {
            this.wrapOperationReturnType(op, bodyMapping.mappedBodyType(), bodyMapping.isValidated(), bodyMapping.isListWrapper());
        }
    }

    private void wrapOperationReturnType(CodegenOperation op, String wrapperType, boolean isValidated, boolean isListWrapper) {
        String originalReturnType;
        CodegenProperty newReturnType = new CodegenProperty();
        newReturnType.required = true;
        newReturnType.isModel = isValidated;
        String typeName = this.makeSureImported(wrapperType, op.imports);
        if ((isListWrapper || this.fluxForArrays) && op.isArray && op.returnProperty.items != null) {
            if (this.fluxForArrays && wrapperType.equals(MONO_CLASS_NAME)) {
                typeName = this.makeSureImported(FLUX_CLASS_NAME, op.imports);
                op.vendorExtensions.put("isReturnFlux", true);
            }
            originalReturnType = op.returnBaseType;
            newReturnType.dataType = typeName + "<" + op.returnBaseType + ">";
            newReturnType.items = op.returnProperty.items;
        } else {
            originalReturnType = op.returnType;
            if (originalReturnType == null) {
                originalReturnType = "Void";
                op.returnProperty = new CodegenProperty();
                op.returnProperty.dataType = "Void";
                op.returnProperty.openApiType = "";
            }
            newReturnType.dataType = typeName + "<" + originalReturnType + ">";
            newReturnType.items = op.returnProperty;
        }
        newReturnType.containerTypeMapped = typeName;
        newReturnType.containerType = typeName;
        op.vendorExtensions.put("originalReturnType", originalReturnType);
        op.returnType = newReturnType.dataType;
        op.returnContainer = newReturnType.containerTypeMapped;
        op.returnProperty = newReturnType;
        op.isArray = op.returnProperty.isArray;
    }

    private void processOperationWithResponseWrappers(CodegenOperation op) {
        boolean requiresHttpResponse;
        boolean hasNon200StatusCodes = op.responses.stream().anyMatch(response -> !"200".equals(response.code) && response.code.startsWith("2"));
        boolean hasNonMappedHeaders = !op.responseHeaders.isEmpty();
        boolean bl = requiresHttpResponse = hasNon200StatusCodes || hasNonMappedHeaders;
        if (this.generateHttpResponseAlways || this.generateHttpResponseWhereRequired && requiresHttpResponse) {
            this.wrapOperationReturnType(op, "io.micronaut.http.HttpResponse", false, false);
        }
        if (this.reactive) {
            this.wrapOperationReturnType(op, MONO_CLASS_NAME, false, false);
        }
    }

    private String makeSureImported(String typeName, Set<String> imports) {
        int firstCapitalIndex = 0;
        for (int i = 0; i < typeName.length(); ++i) {
            if (!Character.isUpperCase(typeName.charAt(i))) continue;
            firstCapitalIndex = i;
            break;
        }
        if (firstCapitalIndex != 0) {
            String dataType = typeName.substring(firstCapitalIndex);
            this.importMapping.put(dataType, typeName);
            typeName = dataType;
        }
        imports.add(typeName);
        return typeName;
    }

    public String toVarName(String name) {
        Object varName = super.toVarName(name);
        if (((String)varName).chars().allMatch(c -> Character.isUpperCase(c) || c == 95)) {
            return varName;
        }
        if (((String)varName).length() >= 2 && Character.isLowerCase(((String)varName).charAt(0)) && Character.isUpperCase(((String)varName).charAt(1))) {
            varName = "" + ((String)varName).charAt(0) + Character.toLowerCase(((String)varName).charAt(1)) + ((String)varName).substring(2);
        }
        if (((String)varName).startsWith("_")) {
            char firstNameChar = ((String)varName).toCharArray()[0];
            String underscorePrefix = this.getUnderscorePrefix(name);
            varName = underscorePrefix + (Serializable)(firstNameChar == '_' && !underscorePrefix.isEmpty() ? "" : Character.valueOf(Character.toLowerCase(firstNameChar))) + ((String)varName).substring(1);
        }
        return varName;
    }

    public String getterAndSetterCapitalize(String name) {
        Object newName = super.getterAndSetterCapitalize(name);
        if (name.startsWith("_")) {
            newName = this.getUnderscorePrefix(name) + Character.toLowerCase(((String)newName).toCharArray()[0]) + ((String)newName).substring(1);
        }
        return newName;
    }

    private String getUnderscorePrefix(String name) {
        char[] nameChars = name.toCharArray();
        StringBuilder newNameBuilder = new StringBuilder();
        for (char nameChar : nameChars) {
            if (nameChar != '_') break;
            newNameBuilder.append('_');
        }
        return newNameBuilder.toString();
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        boolean isServer = this.isServer();
        for (ModelsMap models : objs.values()) {
            CodegenModel model = ((ModelMap)models.getModels().get(0)).getModel();
            ArrayList<CodegenProperty> requiredVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> requiredParentVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> allVars = new ArrayList<CodegenProperty>();
            this.processParentModel(model, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars);
            ArrayList<CodegenProperty> optionalVars = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> requiredVars = new ArrayList<CodegenProperty>();
            for (CodegenProperty v : model.vars) {
                if (v.required) {
                    requiredVars.add(v);
                    continue;
                }
                optionalVars.add(v);
            }
            model.vendorExtensions.put("withMultipleVars", model.vars.size() > 1);
            if (!requiredParentVarsWithoutDiscriminator.isEmpty()) {
                model.vendorExtensions.put("requiredParentVarsWithoutDiscriminator", requiredParentVarsWithoutDiscriminator);
            }
            if (!requiredVarsWithoutDiscriminator.isEmpty()) {
                model.vendorExtensions.put("requiredVarsWithoutDiscriminator", requiredVarsWithoutDiscriminator);
            }
            model.allVars = allVars;
            model.vendorExtensions.put("requiredVars", requiredVars);
            model.vendorExtensions.put("optionalVars", optionalVars);
            model.vendorExtensions.put("areRequiredVarsAndReadOnlyVars", !requiredVarsWithoutDiscriminator.isEmpty() && !model.readOnlyVars.isEmpty());
            model.vendorExtensions.put("serialId", this.random.nextLong());
            model.vendorExtensions.put("withRequiredVars", !model.requiredVars.isEmpty());
            if (model.discriminator != null) {
                model.vendorExtensions.put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
                model.vendorExtensions.put("hasMultipleMappedModels", model.discriminator.getMappedModels().size() > 1);
                model.discriminator.getVendorExtensions().put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
                model.discriminator.getVendorExtensions().put("hasMultipleMappedModels", model.discriminator.getMappedModels().size() > 1);
            }
            model.vendorExtensions.put("isServer", isServer);
            for (CodegenProperty property : model.vars) {
                this.processProperty(property, isServer, objs);
            }
            for (CodegenProperty property : model.requiredVars) {
                this.processProperty(property, isServer, objs);
            }
            if (model.isEnum) {
                this.addImport(model, "Function");
            }
            Utils.addStrValueToEnum(model);
        }
        return objs;
    }

    private void processProperty(CodegenProperty property, boolean isServer, Map<String, ModelsMap> models) {
        property.vendorExtensions.put("inRequiredArgsConstructor", !property.isReadOnly || isServer);
        property.vendorExtensions.put("isServer", isServer);
        property.vendorExtensions.put(OPT_USE_LOMBOK, this.lombok);
        property.vendorExtensions.put("defaultValueIsNotNull", property.defaultValue != null && !property.defaultValue.equals("null"));
        if (this.useBeanValidation && (!property.isContainer && property.isModel || property.getIsArray() && property.getComplexType() != null && models.containsKey(property.getComplexType()))) {
            property.vendorExtensions.put("withValid", true);
        }
        Utils.processGenericAnnotations(property, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false);
    }

    public boolean isGenerateHardNullable() {
        return false;
    }

    private void processParentModel(CodegenModel model, List<CodegenProperty> requiredVarsWithoutDiscriminator, List<CodegenProperty> requiredParentVarsWithoutDiscriminator, List<CodegenProperty> allVars) {
        CodegenModel parent = model.getParentModel();
        boolean hasParent = parent != null;
        allVars.addAll(model.vars);
        for (CodegenProperty v : model.requiredVars) {
            if (this.isDiscriminator(v, model) || !this.notContainsProp(v, requiredVarsWithoutDiscriminator)) continue;
            requiredVarsWithoutDiscriminator.add(v);
        }
        this.requiredParentVarsWithoutDiscriminator(model, requiredParentVarsWithoutDiscriminator);
        if (hasParent) {
            model.parentVars = parent.allVars;
        }
        if (hasParent) {
            this.processParentModel(parent, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars);
        }
    }

    private void requiredParentVarsWithoutDiscriminator(CodegenModel model, List<CodegenProperty> requiredParentVarsWithoutDiscriminator) {
        CodegenModel parent = model.parentModel;
        if (parent == null) {
            return;
        }
        for (CodegenProperty v : parent.vars) {
            boolean isDiscriminator = this.isDiscriminator(v, model);
            if (!v.required || isDiscriminator) continue;
            v.vendorExtensions.put("isServerOrNotReadOnly", !v.isReadOnly || this.isServer());
            if (!this.notContainsProp(v, requiredParentVarsWithoutDiscriminator)) continue;
            requiredParentVarsWithoutDiscriminator.add(v);
        }
    }

    private boolean notContainsProp(CodegenProperty prop, List<CodegenProperty> props) {
        for (CodegenProperty p : props) {
            if (!prop.name.equals(p.name)) continue;
            return false;
        }
        return true;
    }

    private boolean isDiscriminator(CodegenProperty prop, CodegenModel model) {
        boolean isDiscriminator = prop.isDiscriminator;
        if (isDiscriminator) {
            return true;
        }
        if (model.parentModel == null) {
            return false;
        }
        CodegenProperty parentProp = null;
        for (CodegenProperty pv : model.parentModel.allVars) {
            if (!pv.required || !pv.name.equals(prop.name)) continue;
            isDiscriminator = pv.isDiscriminator;
            parentProp = pv;
            break;
        }
        if (isDiscriminator) {
            return true;
        }
        return parentProp != null && this.isDiscriminator(parentProp, model.parentModel);
    }

    public void setParameterExampleValue(CodegenParameter p) {
        p.vendorExtensions.put("groovyExample", this.getParameterExampleValue(p, true));
        p.example = this.getParameterExampleValue(p, false);
    }

    protected String getParameterExampleValue(CodegenParameter p, boolean groovy) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, p.requiredVars, groovy, false);
    }

    protected String getPropertyExampleValue(CodegenProperty p, boolean groovy) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        CodegenModel model = this.allModels.get(p.getDataType());
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, model != null ? model.requiredVars : null, groovy, true);
    }

    public String getExampleValue(String defaultValue, String example, String dataType, Boolean isModel, List<Object> allowableValues, String itemsType, String itemsExample, List<CodegenProperty> requiredVars, boolean groovy, boolean isProperty) {
        String containerType;
        example = defaultValue != null ? defaultValue : example;
        String string = containerType = dataType == null ? null : dataType.split("<")[0];
        if ("String".equals(dataType)) {
            example = groovy ? (example != null ? "'" + this.escapeTextGroovy((String)example) + "'" : "'example'") : (example != null ? "\"" + this.escapeText((String)example) + "\"" : "\"example\"");
        } else if ("Integer".equals(dataType) || "Short".equals(dataType)) {
            example = example != null ? example : "56";
        } else if ("Long".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "56"), (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "3.4"), (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "3.4"), (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(dataType)) {
            example = example != null ? example : OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
        } else if ("File".equals(dataType)) {
            example = null;
        } else if ("OffsetDateTime".equals(dataType)) {
            example = "OffsetDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("LocalDate".equals(dataType)) {
            example = "LocalDate.of(2001, 2, 3)";
        } else if ("LocalDateTime".equals(dataType)) {
            example = "LocalDateTime.of(2001, 2, 3, 4, 5)";
        } else if ("BigDecimal".equals(dataType)) {
            example = "new BigDecimal(\"78\")";
        } else if (allowableValues != null && !allowableValues.isEmpty()) {
            Object value = example;
            if (value == null || !allowableValues.contains(value)) {
                value = allowableValues.get(0);
            }
            if (isProperty) {
                dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
            }
            example = dataType + ".fromValue(\"" + value + "\")";
        } else if (isModel != null && isModel.booleanValue() || isModel == null && !this.languageSpecificPrimitives.contains(dataType)) {
            if (requiredVars == null) {
                example = null;
            } else if (this.requiredPropertiesInConstructor) {
                StringBuilder builder = new StringBuilder();
                if (isProperty) {
                    dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
                }
                builder.append("new ").append(dataType).append("(");
                for (int i = 0; i < requiredVars.size(); ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(this.getPropertyExampleValue(requiredVars.get(i), groovy));
                }
                builder.append(")");
                example = builder.toString();
            } else {
                example = "new " + dataType + "()";
            }
        }
        if ("List".equals(containerType)) {
            Object innerExample;
            if ("String".equals(itemsType)) {
                String string2 = itemsExample = itemsExample != null ? itemsExample : "example";
                innerExample = groovy ? "'" + this.escapeTextGroovy(itemsExample) + "'" : "\"" + this.escapeText(itemsExample) + "\"";
            } else {
                Object object = innerExample = itemsExample != null ? itemsExample : "";
            }
            example = groovy ? "[" + (String)innerExample + "]" : "List.of(" + (String)innerExample + ")";
        } else if ("Set".equals(containerType)) {
            example = groovy ? "[].asSet()" : "new HashSet<>()";
        } else if ("Map".equals(containerType)) {
            example = groovy ? "[:]" : "new HashMap<>()";
        } else if (example == null) {
            example = "null";
        }
        return example;
    }

    public String escapeTextGroovy(String text) {
        if (text == null) {
            return null;
        }
        return this.escapeText(text).replace("'", "\"");
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"replaceDotsWithUnderscore", (Object)new Formatting.ReplaceDotsWithUnderscoreLambda());
    }

    public void setSerializationLibrary(String serializationLibrary) {
        try {
            this.serializationLibrary = SerializationLibraryKind.valueOf(serializationLibrary).name();
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(serializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SerializationLibraryKind availableSerializationLibrary : SerializationLibraryKind.values()) {
                sb.append("\n  ").append(availableSerializationLibrary.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public void setDateTimeLibrary(String name) {
        this.setDateLibrary(name);
    }
}

