/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;

public final class Utils {
    public static final String DEFAULT_BODY_PARAM_NAME = "requestBody";

    private Utils() {
    }

    public static void processGenericAnnotations(CodegenParameter parameter, boolean useBeanValidation, boolean isGenerateHardNullable, boolean isNullable, boolean isRequired, boolean isReadonly, boolean withNullablePostfix) {
        CodegenProperty items = parameter.isMap ? parameter.additionalProperties : parameter.items;
        String datatypeWithEnum = parameter.datatypeWithEnum == null ? parameter.dataType : parameter.datatypeWithEnum;
        Utils.processGenericAnnotations(parameter.dataType, datatypeWithEnum, parameter.isMap, parameter.containerTypeMapped, items, parameter.vendorExtensions, useBeanValidation, isGenerateHardNullable, isNullable, isRequired, isReadonly, withNullablePostfix);
    }

    public static void processGenericAnnotations(CodegenProperty property, boolean useBeanValidation, boolean isGenerateHardNullable, boolean isNullable, boolean isRequired, boolean isReadonly, boolean withNullablePostfix) {
        CodegenProperty items = property.isMap ? property.additionalProperties : property.items;
        String datatypeWithEnum = property.datatypeWithEnum == null ? property.dataType : property.datatypeWithEnum;
        Utils.processGenericAnnotations(property.dataType, datatypeWithEnum, property.isMap, property.containerTypeMapped, items, property.vendorExtensions, useBeanValidation, isGenerateHardNullable, isNullable, isRequired, isReadonly, withNullablePostfix);
    }

    public static void processGenericAnnotations(String dataType, String dataTypeWithEnum, boolean isMap, String containerType, CodegenProperty itemsProp, Map<String, Object> ext, boolean useBeanValidation, boolean isGenerateHardNullable, boolean isNullable, boolean isRequired, boolean isReadonly, boolean withNullablePostfix) {
        Object typeWithGenericAnnotations = dataType;
        Object typeWithEnumWithGenericAnnotations = dataTypeWithEnum;
        if (useBeanValidation && itemsProp != null && dataType.contains("<")) {
            if (isMap) {
                String genericAnnotations = Utils.genericAnnotations(itemsProp, isGenerateHardNullable);
                Utils.processGenericAnnotations(itemsProp, useBeanValidation, isGenerateHardNullable, itemsProp.isNullable, itemsProp.required, itemsProp.isReadOnly, withNullablePostfix);
                typeWithGenericAnnotations = "Map<String, " + genericAnnotations + itemsProp.vendorExtensions.get("typeWithGenericAnnotations") + ">";
                typeWithEnumWithGenericAnnotations = "Map<String, " + genericAnnotations + itemsProp.vendorExtensions.get("typeWithEnumWithGenericAnnotations") + ">";
            } else if (containerType != null) {
                String genericAnnotations = Utils.genericAnnotations(itemsProp, isGenerateHardNullable);
                Utils.processGenericAnnotations(itemsProp, useBeanValidation, isGenerateHardNullable, itemsProp.isNullable, itemsProp.required, itemsProp.isReadOnly, withNullablePostfix);
                typeWithGenericAnnotations = containerType + "<" + genericAnnotations + itemsProp.vendorExtensions.get("typeWithGenericAnnotations") + ">";
                typeWithEnumWithGenericAnnotations = containerType + "<" + genericAnnotations + itemsProp.vendorExtensions.get("typeWithEnumWithGenericAnnotations") + ">";
            }
        }
        ext.put("typeWithGenericAnnotations", (String)typeWithGenericAnnotations + (withNullablePostfix && (isNullable || isRequired && isReadonly) ? "?" : ""));
        ext.put("typeWithEnumWithGenericAnnotations", (String)typeWithEnumWithGenericAnnotations + (withNullablePostfix && (isNullable || isRequired && isReadonly) ? "?" : ""));
    }

    private static String genericAnnotations(CodegenProperty prop, boolean isGenerateHardNullable) {
        String type = prop.openApiType == null ? null : prop.openApiType.toLowerCase();
        StringBuilder result = new StringBuilder();
        if (prop.isModel) {
            result.append("@Valid ");
        }
        if (!Utils.isPrimitive(type)) {
            return result.toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)prop.pattern)) {
            if ("email".equals(type)) {
                result.append("@Email(regexp = \"");
            } else {
                result.append("@Pattern(regexp = \"");
            }
            result.append(prop.pattern).append("\") ");
        }
        boolean containsNotEmpty = false;
        if (prop.minLength != null || prop.maxLength != null) {
            if (prop.minLength != null && prop.minLength == 1 && prop.maxLength == null && !prop.isNullable) {
                result.append("@NotEmpty ");
                containsNotEmpty = true;
            } else {
                result.append("@Size(");
                if (prop.minLength != null) {
                    result.append("min = ").append(prop.minLength);
                }
                if (prop.maxLength != null) {
                    if (prop.minLength != null) {
                        result.append(", ");
                    }
                    result.append("max = ").append(prop.maxLength);
                }
                result.append(") ");
            }
        }
        if (prop.minItems != null || prop.maxItems != null) {
            if (prop.minItems != null && prop.minItems == 1 && prop.maxItems == null && !prop.isNullable) {
                result.append("@NotEmpty ");
                containsNotEmpty = true;
            } else {
                result.append("@Size(");
                if (prop.minItems != null) {
                    result.append("min = ").append(prop.minItems);
                }
                if (prop.maxItems != null) {
                    if (prop.minItems != null) {
                        result.append(", ");
                    }
                    result.append("max = ").append(prop.maxItems);
                }
                result.append(") ");
            }
        }
        if (prop.isNullable) {
            if (isGenerateHardNullable) {
                result.append("@Nullable(inherited = true) ");
            } else {
                result.append("@Nullable ");
            }
        } else if (!containsNotEmpty) {
            result.append("@NotNull ");
        }
        if (StringUtils.isNotEmpty((CharSequence)prop.minimum)) {
            try {
                long longNumber = Long.parseLong(prop.minimum);
                if (prop.exclusiveMinimum) {
                    ++longNumber;
                }
                if (longNumber == 0L && StringUtils.isEmpty((CharSequence)prop.maximum)) {
                    result.append("@PositiveOrZero ");
                } else if (longNumber == 1L && StringUtils.isEmpty((CharSequence)prop.maximum)) {
                    result.append("@Positive ");
                } else {
                    result.append("@Min(").append(longNumber).append(") ");
                }
            }
            catch (Exception e) {
                result.append("@DecimalMin(");
                if (prop.exclusiveMinimum) {
                    result.append("value = ");
                }
                result.append('\"').append(prop.minimum).append('\"');
                if (prop.exclusiveMinimum) {
                    result.append(", inclusive = false");
                }
                result.append(") ");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)prop.maximum)) {
            try {
                long longNumber = Long.parseLong(prop.maximum);
                if (prop.exclusiveMaximum) {
                    --longNumber;
                }
                if (longNumber == 0L && StringUtils.isEmpty((CharSequence)prop.minimum)) {
                    result.append("@NegativeOrZero ");
                } else if (longNumber == -1L && StringUtils.isEmpty((CharSequence)prop.minimum)) {
                    result.append("@Negative ");
                } else {
                    result.append("@Max(").append(longNumber).append(") ");
                }
            }
            catch (Exception e) {
                result.append("@DecimalMax(");
                if (prop.exclusiveMaximum) {
                    result.append("value = ");
                }
                result.append('\"').append(prop.maximum).append('\"');
                if (prop.exclusiveMaximum) {
                    result.append(", inclusive = false");
                }
                result.append(") ");
            }
        }
        return result.toString();
    }

    private static boolean isPrimitive(String type) {
        if (type == null) {
            return false;
        }
        return switch (type) {
            case "array", "string", "boolean", "byte", "uri", "url", "uuid", "email", "integer", "long", "float", "double", "number", "partial-time", "date", "date-time", "bigdecimal", "biginteger" -> true;
            default -> false;
        };
    }

    public static void addStrValueToEnum(CodegenProperty property) {
        if (property == null || !property.isEnum || property.allowableValues == null) {
            return;
        }
        List enumVars = (List)property.allowableValues.get("enumVars");
        Utils.addStrValueToEnum(enumVars, property.isNumeric);
    }

    public static void addStrValueToEnum(CodegenModel model) {
        if (model == null || !model.isEnum || model.allowableValues == null) {
            return;
        }
        List enumVars = (List)model.allowableValues.get("enumVars");
        Utils.addStrValueToEnum(enumVars, model.isNumeric);
    }

    public static void addStrValueToEnum(List<Object> enumVars, boolean isNumeric) {
        for (Object enumVar : enumVars) {
            Map varMap = (Map)enumVar;
            Object value = varMap.get("value").toString();
            if (isNumeric) {
                String upperValue;
                int argPos = ((String)value).indexOf(40);
                if (argPos >= 0) {
                    value = ((String)value).substring(argPos + 1, ((String)value).indexOf(41));
                }
                if ((upperValue = ((String)value).toUpperCase()).endsWith("F") || upperValue.endsWith("L") || upperValue.endsWith("D")) {
                    value = ((String)value).substring(0, ((String)value).length() - 1);
                }
                if (!((String)value).contains("\"")) {
                    value = "\"" + (String)value + "\"";
                }
            }
            varMap.put("strValue", value);
        }
    }

    public static String toApiName(String name, String prefix, String suffix) {
        if (name.isEmpty()) {
            return "DefaultApi";
        }
        return prefix + name + suffix;
    }
}

