/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.postprocessors;

import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenApiOperationsPostProcessor {
    public static final String AUTO_GENERATED_OPERATION_PREFIX = "micronautGenerated::";

    public void processOperations(OpenAPI openAPI, VisitorContext visitorContext, ClassElement classElement) {
        if (openAPI.getPaths() == null) {
            return;
        }
        List<Operation> allOperations = openAPI.getPaths().values().stream().flatMap(pathItem -> pathItem.readOperations().stream()).collect(Collectors.toList());
        Set<String> userOperationIds = this.collectUserOperationIds(allOperations, visitorContext, classElement);
        this.updateOperationIds(allOperations, userOperationIds);
    }

    private Set<String> collectUserOperationIds(List<Operation> allOperations, VisitorContext visitorContext, ClassElement classElement) {
        HashSet<String> operations = new HashSet<String>();
        allOperations.stream().filter(operation -> !this.hasGeneratedOperationId((Operation)operation)).map(Operation::getOperationId).forEach(operationId -> {
            if (operations.contains(operationId)) {
                visitorContext.warn("Found duplicate operation id: '" + operationId + "'", (Element)classElement);
            }
            operations.add((String)operationId);
        });
        return operations;
    }

    private void updateOperationIds(List<Operation> allOperations, Set<String> userOperationIds) {
        HashSet generatedOperationIds = new HashSet();
        Set duplicatedOperationIds = allOperations.stream().filter(this::hasGeneratedOperationId).map(operation -> operation.getOperationId().replaceFirst(AUTO_GENERATED_OPERATION_PREFIX, "")).filter(operationId -> !generatedOperationIds.add(operationId) || userOperationIds.contains(operationId)).collect(Collectors.toSet());
        HashMap counters = new HashMap();
        allOperations.stream().filter(this::hasGeneratedOperationId).forEach(operation -> {
            String originalOperationId = operation.getOperationId();
            String newOperationId = originalOperationId.replace(AUTO_GENERATED_OPERATION_PREFIX, "");
            if (duplicatedOperationIds.contains(newOperationId)) {
                newOperationId = this.findNextOperationId(newOperationId, counters, userOperationIds, generatedOperationIds);
                generatedOperationIds.add(newOperationId);
            }
            operation.setOperationId(newOperationId);
            OpenApiOperationsPostProcessor.fixResponseDescription(operation, originalOperationId, newOperationId);
        });
    }

    private static void fixResponseDescription(Operation operation, String originalId, String newOperationId) {
        if (operation.getResponses() != null) {
            operation.getResponses().values().stream().filter(apiResponse -> apiResponse != null && apiResponse.getDescription() != null).forEach(apiResponse -> apiResponse.setDescription(apiResponse.getDescription().replaceFirst(originalId, newOperationId)));
        }
    }

    private boolean hasGeneratedOperationId(Operation operation) {
        return operation.getOperationId().startsWith(AUTO_GENERATED_OPERATION_PREFIX);
    }

    private String findNextOperationId(String operationId, Map<String, Integer> counters, Set<String> userOperationIds, Set<String> generatedOperationIds) {
        int newIndex;
        String newOperationId;
        do {
            newIndex = counters.compute(operationId, (key, previousValue) -> previousValue == null ? 1 : previousValue + 1);
        } while (generatedOperationIds.contains(newOperationId = operationId + newIndex) || userOperationIds.contains(newOperationId));
        return newOperationId;
    }
}

