/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.Renderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SwaggerUIConfig
extends AbstractViewConfig
implements Renderer {
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>(4);
    private static final String OPTION_OAUTH2 = "oauth2";
    private static final String DOT = ".";
    private static final String PREFIX_SWAGGER_UI = "swagger-ui";
    private static final String KEY_VALUE_SEPARATOR = ": ";
    private static final String COMMNA_NEW_LINE = ",\n";
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(16);
    private static final Map<String, Function<String, Object>> VALID_OAUTH2_OPTIONS = new HashMap<String, Function<String, Object>>(9);
    RapiPDFConfig rapiPDFConfig;
    private Theme theme = Theme.DEFAULT;

    private SwaggerUIConfig() {
        super("swagger-ui.");
    }

    @NonNull
    private String toOptions() {
        return this.toOptions(VALID_OPTIONS, null);
    }

    private String toOptions(@NonNull Map<String, Function<String, Object>> validOptions, @Nullable String keyPrefix) {
        return this.options.entrySet().stream().filter(e -> validOptions.containsKey(e.getKey())).sorted(Map.Entry.comparingByKey()).map(e -> (keyPrefix != null && ((String)e.getKey()).startsWith(keyPrefix) ? ((String)e.getKey()).substring(keyPrefix.length()) : (String)e.getKey()) + KEY_VALUE_SEPARATOR + e.getValue()).collect(Collectors.joining(COMMNA_NEW_LINE));
    }

    @NonNull
    private String toOauth2Options() {
        String properties = this.toOptions(VALID_OAUTH2_OPTIONS, "oauth2.");
        if (StringUtils.hasText((CharSequence)properties)) {
            return "ui.initOAuth({\n" + properties + "\n});";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean hasOauth2Option(Map<String, Object> options) {
        if (options.containsKey("oauth2RedirectUrl")) return true;
        if (!VALID_OAUTH2_OPTIONS.keySet().stream().anyMatch(options::containsKey)) return false;
        return true;
    }

    static SwaggerUIConfig fromProperties(Map<String, String> properties) {
        SwaggerUIConfig cfg = new SwaggerUIConfig();
        cfg.theme = Theme.valueOf(properties.getOrDefault("swagger-ui.theme", cfg.theme.name()).toUpperCase(Locale.US));
        return AbstractViewConfig.fromProperties(cfg, DEFAULT_OPTIONS, properties);
    }

    @Override
    public String render(String template) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.SWAGGER_UI);
        template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.version", this.version, "@");
        template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.attributes", this.toOptions(), "");
        template = template.replace("{{swagger-ui.theme}}", this.theme == null || Theme.DEFAULT.equals((Object)this.theme) ? "" : "<link rel='stylesheet' type='text/css' href='https://unpkg.com/swagger-ui-themes@3.0.0/themes/3.x/" + this.theme.getCss() + ".css' />");
        template = template.replace("{{swagger-ui.oauth2}}", SwaggerUIConfig.hasOauth2Option(this.options) ? this.toOauth2Options() : "");
        return template;
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return (VALID_OPTIONS.containsKey(key) ? VALID_OPTIONS : VALID_OAUTH2_OPTIONS).get(key);
    }

    static {
        VALID_OPTIONS.put("layout", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("deepLinking", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("displayOperationId", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("defaultModelsExpandDepth", AbstractViewConfig::asString);
        VALID_OPTIONS.put("defaultModelRendering", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("displayRequestDuration", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("docExpansion", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("filter", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("maxDisplayedTags", AbstractViewConfig::asString);
        VALID_OPTIONS.put("operationsSorter", AbstractViewConfig::asString);
        VALID_OPTIONS.put("showExtensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("showCommonExtensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("tagsSorter", AbstractViewConfig::asString);
        VALID_OPTIONS.put("oauth2RedirectUrl", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("showMutatedRequest", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("supportedSubmitMethods", AbstractViewConfig::asString);
        VALID_OPTIONS.put("validatorUrl", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("withCredentials", AbstractViewConfig::asBoolean);
        VALID_OAUTH2_OPTIONS.put("oauth2.clientId", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.clientSecret", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.realm", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.appName", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.scopeSeparator", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.scopes", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.additionalQueryStringParams", AbstractViewConfig::asString);
        VALID_OAUTH2_OPTIONS.put("oauth2.useBasicAuthenticationWithAccessCodeGrant", AbstractViewConfig::asBoolean);
        VALID_OAUTH2_OPTIONS.put("oauth2.usePkceWithAuthorizationCodeGrant", AbstractViewConfig::asBoolean);
        DEFAULT_OPTIONS.put("layout", "\"StandaloneLayout\"");
        DEFAULT_OPTIONS.put("deepLinking", Boolean.TRUE);
        DEFAULT_OPTIONS.put("validatorUrl", null);
    }

    static enum Theme {
        DEFAULT(null),
        MATERIAL("theme-material"),
        FEELING_BLUE("theme-feeling-blue"),
        FLATTOP("theme-flattop"),
        MONOKAI("theme-monokai"),
        MUTED("theme-muted"),
        NEWSPAPER("theme-newspaper"),
        OUTLINE("theme-outline");

        private String css;

        private Theme(String css) {
            this.css = css;
        }

        public String getCss() {
            return this.css;
        }
    }
}

