/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElementExt;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class JavaClassElementExt
extends JavaClassElement {
    private final JavaClassElement javaClassElement;

    public JavaClassElementExt(ClassElement ce, VisitorContext visitorContext) {
        this((JavaClassElement)ce, (JavaVisitorContext)visitorContext);
    }

    private JavaClassElementExt(JavaClassElement jce, JavaVisitorContext visitorContext) {
        super((TypeElement)jce.getNativeType(), jce.getAnnotationMetadata(), visitorContext, jce.getGenericTypeInfo(), jce.getArrayDimensions());
        this.javaClassElement = jce;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new JavaClassElementExt(this.javaClassElement.withArrayDimensions(arrayDimensions), (VisitorContext)this.visitorContext);
    }

    private static boolean sameType(String type, DeclaredType dt) {
        Element elt = dt.asElement();
        return elt instanceof TypeElement && type.equals(((TypeElement)elt).getQualifiedName().toString());
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.visitorContext.getElements().getDocComment(this.classElement));
    }

    public Optional<ClassElement> getSuperType() {
        TypeElement te = (TypeElement)this.getNativeType();
        TypeMirror dt = te.getSuperclass();
        if (dt instanceof DeclaredType && !((DeclaredType)dt).getTypeArguments().isEmpty()) {
            ClassElement sup = this.parameterizedClassElement(dt, this.visitorContext, this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo((Element)te));
            return Optional.of(new JavaClassElementExt(sup, (VisitorContext)this.visitorContext));
        }
        return super.getSuperType();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaClassElementExt) {
            return this.javaClassElement.equals((Object)((JavaClassElementExt)((Object)o)).javaClassElement);
        }
        return this.javaClassElement.equals(o);
    }

    public int hashCode() {
        return this.javaClassElement.hashCode();
    }

    public static ClassElement getReturnType(MethodElement method, VisitorContext visitorContext) {
        boolean isSuspend;
        ParameterElement[] parameters = method.getParameters();
        boolean bl = isSuspend = parameters.length > 0 && parameters[parameters.length - 1].getGenericType().isAssignable("kotlin.coroutines.Continuation");
        if (isSuspend) {
            return JavaClassElementExt.continuationReturnType(parameters[parameters.length - 1], visitorContext, Collections.emptyMap());
        }
        return method.getReturnType();
    }

    public static ClassElement getGenericReturnType(MethodElement method, VisitorContext visitorContext) {
        boolean isSuspend;
        ParameterElement[] parameters = method.getParameters();
        boolean bl = isSuspend = parameters.length > 0 && parameters[parameters.length - 1].getGenericType().isAssignable("kotlin.coroutines.Continuation");
        if (isSuspend) {
            return JavaClassElementExt.continuationReturnType(parameters[parameters.length - 1], visitorContext, ((JavaClassElement)method.getOwningType()).getGenericTypeInfo());
        }
        return method.getGenericReturnType();
    }

    private static ClassElement continuationReturnType(ParameterElement parameter, VisitorContext visitorContext, Map<String, Map<String, TypeMirror>> info) {
        JavaVisitorContext jcontext = (JavaVisitorContext)visitorContext;
        VariableElement varElement = (VariableElement)parameter.getNativeType();
        DeclaredType dType = (DeclaredType)varElement.asType();
        WildcardType wType = (WildcardType)dType.getTypeArguments().iterator().next();
        TypeMirror tm = wType.getSuperBound();
        if (tm instanceof DeclaredType && JavaClassElementExt.sameType("kotlin.Unit", (DeclaredType)tm)) {
            return PrimitiveElement.VOID;
        }
        return ((JavaParameterElement)parameter).parameterizedClassElement(tm, jcontext, info);
    }

    private static String findDocumentation(Set<TypeMirror> superTypes, ExecutableElement method, Elements elements, Types types) {
        String doc = elements.getDocComment(method);
        if (doc == null) {
            for (TypeMirror tm : superTypes) {
                TypeElement te = (TypeElement)types.asElement(tm);
                for (ExecutableElement m : ElementFilter.methodsIn(te.getEnclosedElements())) {
                    if (!method.equals(m) && !elements.hides(method, m) && !elements.overrides(method, m, (TypeElement)method.getEnclosingElement())) continue;
                    doc = elements.getDocComment(m);
                    break;
                }
                if (doc == null) continue;
                break;
            }
        }
        return doc;
    }

    private static Set<TypeMirror> superTypes(TypeElement typeElement, Types types) {
        TypeElement te;
        List<? extends TypeMirror> superTypes = types.directSupertypes(typeElement.asType());
        LinkedHashSet<TypeMirror> typeMirrors = new LinkedHashSet<TypeMirror>();
        for (TypeMirror typeMirror : superTypes) {
            te = (TypeElement)types.asElement(typeMirror);
            if (te.getKind() == ElementKind.CLASS && te.getSuperclass().getKind() == TypeKind.NONE) continue;
            typeMirrors.add(typeMirror);
        }
        for (TypeMirror typeMirror : superTypes) {
            te = (TypeElement)types.asElement(typeMirror);
            if (te.getKind() == ElementKind.CLASS && te.getSuperclass().getKind() == TypeKind.NONE) continue;
            typeMirrors.addAll(JavaClassElementExt.superTypes((TypeElement)types.asElement(typeMirror), types));
        }
        return typeMirrors;
    }

    private static boolean isObjectClassMethod(ExecutableElement method, Elements elements) {
        TypeElement te = (TypeElement)method.getEnclosingElement();
        return te.equals(elements.getTypeElement("java.lang.Object"));
    }

    private static boolean isCandidateMethod(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE) && !method.getSimpleName().toString().contains("$");
    }

    private boolean isCandidateBeanMethod(ExecutableElement method) {
        if (!this.checkModifiers(method)) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        if (methodName.contains("$")) {
            return false;
        }
        if (NameUtils.isGetterName((String)methodName) && method.getParameters().isEmpty()) {
            return true;
        }
        return NameUtils.isSetterName((String)methodName) && method.getParameters().size() == 1;
    }

    private boolean checkModifiers(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return method.getModifiers().contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE) && !method.getSimpleName().toString().contains("$");
    }

    private boolean isCandidateFluentBeanMethod(ExecutableElement method, Set<String> fieldNames) {
        if (!this.checkModifiers(method)) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        return fieldNames.contains(methodName) && (method.getParameters().isEmpty() || method.getParameters().size() == 1);
    }

    public List<MethodElement> getCandidateMethods() {
        Elements elements = this.visitorContext.getElements();
        Types types = this.visitorContext.getTypes();
        AnnotationUtils annotations = this.visitorContext.getAnnotationUtils();
        Set<TypeMirror> superTypes = JavaClassElementExt.superTypes(this.classElement, types);
        return ElementFilter.methodsIn(elements.getAllMembers(this.classElement)).stream().filter(method -> !JavaClassElementExt.isObjectClassMethod(method, elements)).filter(JavaClassElementExt::isCandidateMethod).map(method -> new JavaMethodElementExt(this.javaClassElement, (ExecutableElement)method, annotations.getAnnotationMetadata((Element)method), this.visitorContext, JavaClassElementExt.findDocumentation(superTypes, method, elements, types))).collect(Collectors.toList());
    }

    public List<PropertyElement> beanProperties() {
        LinkedHashMap<String, BeanPropertyData> props = new LinkedHashMap<String, BeanPropertyData>();
        LinkedHashMap<String, VariableElement> fields = new LinkedHashMap<String, VariableElement>();
        Elements elements = this.visitorContext.getElements();
        ElementFilter.fieldsIn(elements.getAllMembers(this.classElement)).forEach(v -> fields.put(v.getSimpleName().toString(), (VariableElement)v));
        ElementFilter.methodsIn(elements.getAllMembers(this.classElement)).stream().filter(method -> !JavaClassElementExt.isObjectClassMethod(method, elements)).filter(this::isCandidateBeanMethod).forEach(executableElement -> this.beanProperty((Map<String, BeanPropertyData>)props, (ExecutableElement)executableElement));
        return this.processPropertyElements(props, fields);
    }

    public List<PropertyElement> fluentBeanProperties() {
        LinkedHashMap<String, BeanPropertyData> props = new LinkedHashMap<String, BeanPropertyData>();
        LinkedHashMap<String, VariableElement> fields = new LinkedHashMap<String, VariableElement>();
        Elements elements = this.visitorContext.getElements();
        ElementFilter.fieldsIn(elements.getAllMembers(this.classElement)).forEach(v -> fields.put(v.getSimpleName().toString(), (VariableElement)v));
        Set fieldNames = fields.keySet();
        ElementFilter.methodsIn(elements.getAllMembers(this.classElement)).stream().filter(method -> !JavaClassElementExt.isObjectClassMethod(method, elements)).filter(method -> this.isCandidateFluentBeanMethod((ExecutableElement)method, fieldNames)).forEach(executableElement -> this.fluentBeanProperty((Map<String, BeanPropertyData>)props, (ExecutableElement)executableElement));
        return this.processPropertyElements(props, fields);
    }

    private List<PropertyElement> processPropertyElements(Map<String, BeanPropertyData> props, Map<String, VariableElement> fields) {
        if (props.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JavaPropertyElement> propertyElements = new ArrayList<JavaPropertyElement>();
        for (Map.Entry<String, BeanPropertyData> entry : props.entrySet()) {
            String propertyName = entry.getKey();
            BeanPropertyData value = entry.getValue();
            VariableElement fieldElement = fields.get(propertyName);
            if (value.getter == null) continue;
            AnnotationMetadata annotationMetadata = fieldElement == null ? this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.getter) : this.visitorContext.getAnnotationUtils().getAnnotationMetadata((Element)fieldElement, (Element)value.getter);
            propertyElements.add(this.toPropertyElement(propertyName, value, annotationMetadata));
        }
        return Collections.unmodifiableList(propertyElements);
    }

    private JavaPropertyElement toPropertyElement(String propertyName, final BeanPropertyData value, final AnnotationMetadata annotationMetadata) {
        return new JavaPropertyElement((ClassElement)(value.declaringType == null ? this : value.declaringType), value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

            public Optional<String> getDocumentation() {
                Elements elements = JavaClassElementExt.this.visitorContext.getElements();
                String docComment = elements.getDocComment(value.getter);
                return Optional.ofNullable(docComment);
            }

            public Optional<MethodElement> getWriteMethod() {
                if (value.setter != null) {
                    return Optional.of(new JavaMethodElement((JavaClassElement)JavaClassElementExt.this, value.setter, JavaClassElementExt.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.setter), JavaClassElementExt.this.visitorContext));
                }
                return Optional.empty();
            }

            public Optional<MethodElement> getReadMethod() {
                return Optional.of(new JavaMethodElement((JavaClassElement)JavaClassElementExt.this, value.getter, annotationMetadata, JavaClassElementExt.this.visitorContext));
            }
        };
    }

    private void beanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement) {
        String methodName = executableElement.getSimpleName().toString();
        TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
        if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().isEmpty()) {
            this.getterBeanProperty(props, executableElement, methodName, declaringTypeElement);
        } else if (NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1) {
            this.setterBeanProperty(props, executableElement, methodName, declaringTypeElement);
        }
    }

    private void fluentBeanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement) {
        String methodName = executableElement.getSimpleName().toString();
        TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
        if (executableElement.getParameters().isEmpty()) {
            this.getterBeanProperty(props, executableElement, methodName, declaringTypeElement);
        } else if (executableElement.getParameters().size() == 1) {
            this.setterBeanProperty(props, executableElement, methodName, declaringTypeElement);
        }
    }

    private void getterBeanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement, String methodName, TypeElement declaringTypeElement) {
        TypeMirror typeMirror;
        ClassElement setterParameterType;
        ClassElement getterReturnType;
        String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)returnType;
            String tvn = tv.toString();
            ClassElement ce = (ClassElement)this.getTypeArguments().get(tvn);
            getterReturnType = ce == null ? this.mirrorToClassElement(returnType, this.visitorContext, this.getGenericTypeInfo()) : ce;
        } else {
            getterReturnType = this.mirrorToClassElement(returnType, this.visitorContext, this.getGenericTypeInfo());
        }
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        this.configureDeclaringType(declaringTypeElement, beanPropertyData);
        beanPropertyData.type = getterReturnType;
        beanPropertyData.getter = executableElement;
        if (beanPropertyData.setter != null && !(setterParameterType = this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), this.visitorContext, this.getGenericTypeInfo())).getName().equals(getterReturnType.getName())) {
            beanPropertyData.setter = null;
        }
    }

    private void setterBeanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement, String methodName, TypeElement declaringTypeElement) {
        String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
        TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
        ClassElement setterParameterType = this.mirrorToClassElement(typeMirror, this.visitorContext, this.getGenericTypeInfo());
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        this.configureDeclaringType(declaringTypeElement, beanPropertyData);
        ClassElement propertyType = beanPropertyData.type;
        if (propertyType == null) {
            beanPropertyData.setter = executableElement;
        } else if (propertyType.getName().equals(setterParameterType.getName())) {
            beanPropertyData.setter = executableElement;
        }
    }

    private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
        if (beanPropertyData.declaringType == null && !this.classElement.equals(declaringTypeElement)) {
            beanPropertyData.declaringType = this.mirrorToClassElement(declaringTypeElement.asType(), this.visitorContext, this.getGenericTypeInfo());
        }
    }

    private static class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

