/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.annotation.processing.visitor.JavaClassElementExt;
import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestBean;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractOpenApiEndpointVisitor
extends AbstractOpenApiVisitor {
    protected List<io.swagger.v3.oas.models.tags.Tag> classTags;
    protected PropertyPlaceholderResolver propertyPlaceholderResolver;

    AbstractOpenApiEndpointVisitor() {
    }

    private static boolean isAnnotationPresent(Element element, String className) {
        return element.findAnnotation(className).isPresent();
    }

    private static RequestBody mergeRequestBody(RequestBody rq1, RequestBody rq2) {
        if (rq1.getRequired() == null) {
            rq1.setRequired(rq2.getRequired());
        }
        if (rq1.get$ref() == null) {
            rq1.set$ref(rq2.get$ref());
        }
        if (rq1.getDescription() == null) {
            rq1.setDescription(rq2.getDescription());
        }
        if (rq1.getExtensions() == null) {
            rq1.setExtensions(rq2.getExtensions());
        } else if (rq2.getExtensions() != null) {
            rq1.getExtensions().forEach((key, value) -> rq1.getExtensions().putIfAbsent(key, value));
        }
        if (rq1.getContent() == null) {
            rq1.setContent(rq2.getContent());
        } else if (rq2.getContent() != null) {
            Content c1 = rq1.getContent();
            Content c2 = rq2.getContent();
            c2.forEach((key, value) -> {
                io.swagger.v3.oas.models.media.MediaType cfr_ignored_0 = (io.swagger.v3.oas.models.media.MediaType)c1.putIfAbsent(key, value);
            });
        }
        return rq1;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (this.ignore(element, context)) {
            return;
        }
        this.incrementVisitedElements(context);
        this.processSecuritySchemes(element, context);
        this.processTags(element, context);
    }

    private void processTags(ClassElement element, VisitorContext context) {
        this.classTags = this.readTags(element, context);
        List<io.swagger.v3.oas.models.tags.Tag> userDefinedClassTags = this.classTags(element, context);
        if (this.classTags == null || this.classTags.isEmpty()) {
            this.classTags = userDefinedClassTags == null ? Collections.emptyList() : userDefinedClassTags;
        } else if (userDefinedClassTags != null) {
            for (io.swagger.v3.oas.models.tags.Tag tag : userDefinedClassTags) {
                if (this.containsTag(tag.getName(), this.classTags)) continue;
                this.classTags.add(tag);
            }
        }
    }

    private boolean containsTag(String name, List<io.swagger.v3.oas.models.tags.Tag> tags) {
        return tags.stream().anyMatch(tag -> name.equals(tag.getName()));
    }

    protected abstract List<SecurityRequirement> methodSecurityRequirements(MethodElement var1, VisitorContext var2);

    protected abstract List<Server> methodServers(MethodElement var1, VisitorContext var2);

    protected abstract List<io.swagger.v3.oas.models.tags.Tag> classTags(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(MethodElement var1, VisitorContext var2);

    protected abstract HttpMethod httpMethod(MethodElement var1);

    protected abstract List<UriMatchTemplate> uriMatchTemplates(MethodElement var1);

    protected abstract List<MediaType> consumesMediaTypes(MethodElement var1);

    protected abstract List<MediaType> producesMediaTypes(MethodElement var1);

    protected abstract String description(MethodElement var1);

    private boolean hasNoBindingAnnotationOrType(TypedElement parameter) {
        return !parameter.isAnnotationPresent(io.swagger.v3.oas.annotations.parameters.RequestBody.class) && !parameter.isAnnotationPresent(QueryValue.class) && !parameter.isAnnotationPresent(PathVariable.class) && !parameter.isAnnotationPresent(Body.class) && !parameter.isAnnotationPresent(Part.class) && !parameter.isAnnotationPresent(CookieValue.class) && !parameter.isAnnotationPresent(Header.class) && !parameter.isAnnotationPresent(RequestBean.class) && !this.isResponseType(parameter.getType());
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        Optional<RequestBody> requestBody;
        if (this.ignore(element, context)) {
            return;
        }
        HttpMethod httpMethod = this.httpMethod(element);
        if (httpMethod == null) {
            return;
        }
        Iterator<UriMatchTemplate> matchTemplates = this.uriMatchTemplates(element).iterator();
        if (!matchTemplates.hasNext()) {
            return;
        }
        this.incrementVisitedElements(context);
        UriMatchTemplate matchTemplate = matchTemplates.next();
        PathItem pathItem = this.resolvePathItem(context, matchTemplate);
        OpenAPI openAPI = this.resolveOpenAPI(context);
        Operation swaggerOperation = this.readOperation(element, context);
        this.readTags(element, swaggerOperation, this.classTags == null ? Collections.emptyList() : this.classTags);
        this.readSecurityRequirements(element, context, swaggerOperation);
        this.readApiResponses(element, context, swaggerOperation);
        this.readServers(element, context, swaggerOperation);
        this.readCallbacks(element, context, swaggerOperation);
        JavadocDescription javadocDescription = this.getMethodDescription(element, swaggerOperation);
        swaggerOperation = this.setOperationOnPathItem(pathItem, swaggerOperation, httpMethod);
        if (element.isAnnotationPresent(Deprecated.class)) {
            swaggerOperation.setDeprecated(Boolean.valueOf(true));
        }
        this.readResponse(element, context, openAPI, swaggerOperation, javadocDescription);
        boolean permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        if (permitsRequestBody && (requestBody = this.readSwaggerRequestBody((Element)element, context)).isPresent()) {
            RequestBody currentRequestBody = swaggerOperation.getRequestBody();
            if (currentRequestBody != null) {
                swaggerOperation.setRequestBody(AbstractOpenApiEndpointVisitor.mergeRequestBody(currentRequestBody, requestBody.get()));
            } else {
                swaggerOperation.setRequestBody(requestBody.get());
            }
        }
        Map<String, UriMatchVariable> pathVariables = this.pathVariables(matchTemplate);
        List<MediaType> consumesMediaTypes = this.consumesMediaTypes(element);
        ArrayList<TypedElement> extraBodyParameters = new ArrayList<TypedElement>();
        this.processParameterAnnotationInMethod(element, openAPI, matchTemplate, httpMethod);
        this.processParameters(element, context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, extraBodyParameters);
        this.processExtraBodyParameters(context, httpMethod, openAPI, swaggerOperation, javadocDescription, consumesMediaTypes, extraBodyParameters);
        while (matchTemplates.hasNext()) {
            pathItem = this.resolvePathItem(context, matchTemplates.next());
            swaggerOperation = this.setOperationOnPathItem(pathItem, swaggerOperation, httpMethod);
        }
    }

    private void processExtraBodyParameters(VisitorContext context, HttpMethod httpMethod, OpenAPI openAPI, Operation swaggerOperation, JavadocDescription javadocDescription, List<MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters) {
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod) && !extraBodyParameters.isEmpty() && requestBody == null) {
            requestBody = new RequestBody();
            Content content = new Content();
            requestBody.setContent(content);
            requestBody.setRequired(Boolean.valueOf(true));
            swaggerOperation.setRequestBody(requestBody);
            consumesMediaTypes = consumesMediaTypes.isEmpty() ? Collections.singletonList(MediaType.APPLICATION_JSON_TYPE) : consumesMediaTypes;
            consumesMediaTypes.forEach(mediaType -> {
                io.swagger.v3.oas.models.media.MediaType mt = new io.swagger.v3.oas.models.media.MediaType();
                mt.setSchema((Schema)new ObjectSchema());
                content.addMediaType(mediaType.toString(), mt);
            });
        }
        if (requestBody != null && !extraBodyParameters.isEmpty()) {
            requestBody.getContent().forEach((mediaTypeName, mediaType) -> {
                Schema schema = mediaType.getSchema();
                if (schema.get$ref() != null) {
                    ComposedSchema composedSchema = new ComposedSchema();
                    Schema extraBodyParametersSchema = new Schema();
                    composedSchema.addAllOfItem(schema);
                    composedSchema.addAllOfItem(extraBodyParametersSchema);
                    schema = extraBodyParametersSchema;
                    mediaType.setSchema((Schema)composedSchema);
                }
                for (TypedElement parameter : extraBodyParameters) {
                    this.processBodyParameter(context, openAPI, javadocDescription, MediaType.of((String)mediaTypeName), schema, parameter);
                }
            });
        }
    }

    private void processParameters(MethodElement element, VisitorContext context, OpenAPI openAPI, Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters) {
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters = swaggerOperation.getParameters();
        if (CollectionUtils.isEmpty((Collection)swaggerParameters)) {
            swaggerParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            swaggerOperation.setParameters(swaggerParameters);
        }
        for (ParameterElement parameter : element.getParameters()) {
            if (this.alreadyProcessedParameter(swaggerParameters, parameter)) continue;
            this.processParameter(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, (TypedElement)parameter, extraBodyParameters);
        }
    }

    private boolean alreadyProcessedParameter(List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, ParameterElement parameter) {
        return swaggerParameters.stream().anyMatch(p -> p.getName().equals(parameter.getName()));
    }

    private void processParameterAnnotationInMethod(MethodElement element, OpenAPI openAPI, UriMatchTemplate matchTemplate, HttpMethod httpMethod) {
        List parameterAnnotations = element.getDeclaredAnnotationValuesByType(Parameter.class);
        for (AnnotationValue paramAnn : parameterAnnotations) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameter.schema(new Schema());
            paramAnn.stringValue("name").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).name(arg_0));
            paramAnn.enumValue("in", ParameterIn.class).ifPresent(in -> parameter.in(in.toString()));
            paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).description(arg_0));
            paramAnn.booleanValue("required").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).required(arg_0));
            paramAnn.booleanValue("deprecated").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).deprecated(arg_0));
            paramAnn.booleanValue("allowEmptyValue").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).allowEmptyValue(arg_0));
            paramAnn.booleanValue("allowReserved").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).allowReserved(arg_0));
            paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).example(arg_0));
            paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).$ref(arg_0));
            PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)matchTemplate.toPathString());
            switch (httpMethod) {
                case GET: {
                    pathItem.getGet().addParametersItem(parameter);
                    break;
                }
                case POST: {
                    pathItem.getPost().addParametersItem(parameter);
                    break;
                }
                case PUT: {
                    pathItem.getPut().addParametersItem(parameter);
                    break;
                }
                case DELETE: {
                    pathItem.getDelete().addParametersItem(parameter);
                    break;
                }
                case PATCH: {
                    pathItem.getPatch().addParametersItem(parameter);
                    break;
                }
            }
        }
    }

    private void processParameter(VisitorContext context, OpenAPI openAPI, Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters) {
        CharSequence desc;
        Object parameterType = parameter.getGenericType();
        if (this.ignoreParameter(parameter)) {
            return;
        }
        if (AbstractOpenApiEndpointVisitor.isJavaElement(parameterType, context)) {
            parameterType = new JavaClassElementExt((ClassElement)parameterType, context);
        }
        if (permitsRequestBody && swaggerOperation.getRequestBody() == null) {
            this.readSwaggerRequestBody((Element)parameter, context).ifPresent(arg_0 -> ((Operation)swaggerOperation).setRequestBody(arg_0));
        }
        if (parameter.isAnnotationPresent(Body.class)) {
            this.processBody(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, consumesMediaTypes, parameter, (ClassElement)parameterType);
            return;
        }
        if (parameter.isAnnotationPresent(RequestBean.class)) {
            this.processRequestBean(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, parameter, extraBodyParameters);
            return;
        }
        io.swagger.v3.oas.models.parameters.Parameter newParameter = this.processMethodParameterAnnotation(context, permitsRequestBody, pathVariables, parameter, extraBodyParameters);
        if (newParameter == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)newParameter.getName())) {
            newParameter.setName(parameter.getName());
        }
        if (newParameter.getRequired() == null) {
            newParameter.setRequired(Boolean.valueOf(!parameter.isNullable() && !parameter.getType().isOptional()));
        }
        if (javadocDescription != null && StringUtils.isEmpty((CharSequence)newParameter.getDescription()) && (desc = javadocDescription.getParameters().get(parameter.getName())) != null) {
            newParameter.setDescription(desc.toString());
        }
        swaggerParameters.add(newParameter);
        Schema schema = newParameter.getSchema();
        if (schema == null) {
            schema = this.resolveSchema(openAPI, (Element)parameter, (ClassElement)parameterType, context, consumesMediaTypes);
        }
        if (schema != null) {
            schema = this.bindSchemaForElement(context, (Element)parameter, (ClassElement)parameterType, schema);
            newParameter.setSchema(schema);
        }
    }

    private void processBodyParameter(VisitorContext context, OpenAPI openAPI, JavadocDescription javadocDescription, MediaType mediaType, Schema schema, TypedElement parameter) {
        Schema propertySchema = this.resolveSchema(openAPI, (Element)parameter, parameter.getType(), context, Collections.singletonList(mediaType));
        if (propertySchema != null) {
            CharSequence doc;
            Optional description = parameter.getValue(Parameter.class, "description", String.class);
            if (description.isPresent()) {
                propertySchema.setDescription((String)description.get());
            }
            this.processSchemaProperty(context, (Element)parameter, parameter.getType(), null, schema, propertySchema);
            if (parameter.isNullable() || parameter.getType().isOptional()) {
                propertySchema.setNullable(Boolean.valueOf(true));
            }
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)propertySchema.getDescription()) && (doc = javadocDescription.getParameters().get(parameter.getName())) != null) {
                propertySchema.setDescription(doc.toString());
            }
        }
    }

    private io.swagger.v3.oas.models.parameters.Parameter processMethodParameterAnnotation(VisitorContext context, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, TypedElement parameter, List<TypedElement> extraBodyParameters) {
        AnnotationValue paramAnn;
        AnnotationValue parameterAnnotation;
        QueryParameter newParameter = null;
        String parameterName = parameter.getName();
        if (!parameter.hasStereotype(Bindable.class) && pathVariables.containsKey(parameterName)) {
            UriMatchVariable var = pathVariables.get(parameterName);
            newParameter = var.isQuery() ? new QueryParameter() : new PathParameter();
            newParameter.setName(parameterName);
            boolean exploded = var.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(exploded));
            }
        } else if (parameter.isAnnotationPresent(PathVariable.class)) {
            String paramName = parameter.getValue(PathVariable.class, String.class).orElse(parameterName);
            UriMatchVariable var = pathVariables.get(paramName);
            if (var == null) {
                context.fail("Path variable name: '" + paramName + "' not found in path.", (Element)parameter);
                return null;
            }
            newParameter = new PathParameter();
            newParameter.setName(paramName);
            boolean exploded = var.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(exploded));
            }
        } else if (parameter.isAnnotationPresent(Header.class)) {
            String headerName = parameter.getValue(Header.class, "name", String.class).orElse(parameter.getValue(Header.class, String.class).orElseGet(() -> NameUtils.hyphenate((String)parameterName)));
            newParameter = new HeaderParameter();
            newParameter.setName(headerName);
        } else if (parameter.isAnnotationPresent(CookieValue.class)) {
            String cookieName = parameter.getValue(CookieValue.class, String.class).orElse(parameterName);
            newParameter = new CookieParameter();
            newParameter.setName(cookieName);
        } else if (parameter.isAnnotationPresent(QueryValue.class)) {
            String queryVar = parameter.getValue(QueryValue.class, String.class).orElse(parameterName);
            newParameter = new QueryParameter();
            newParameter.setName(queryVar);
        } else if (parameter.hasAnnotation("io.micronaut.management.endpoint.annotation.Selector")) {
            newParameter = new PathParameter();
            newParameter.setName(parameterName);
        } else if (this.hasNoBindingAnnotationOrType(parameter) && ((parameterAnnotation = parameter.getAnnotation(Parameter.class)) == null || !parameterAnnotation.booleanValue("hidden").orElse(false).booleanValue() && !parameterAnnotation.stringValue("in").isPresent())) {
            if (permitsRequestBody) {
                extraBodyParameters.add(parameter);
            } else {
                newParameter = new QueryParameter();
                newParameter.setName(parameterName);
            }
        }
        if (parameter.isAnnotationPresent(Parameter.class) && (paramAnn = (AnnotationValue)parameter.findAnnotation(Parameter.class).orElse(null)) != null) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) {
                return null;
            }
            Map<CharSequence, Object> paramValues = this.toValueMap(paramAnn.getValues(), context);
            this.normalizeEnumValues(paramValues, Collections.singletonMap("in", ParameterIn.class));
            if (parameter.isAnnotationPresent(Header.class)) {
                paramValues.put("in", ParameterIn.HEADER.toString());
            } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                paramValues.put("in", ParameterIn.COOKIE.toString());
            } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                paramValues.put("in", ParameterIn.QUERY.toString());
            }
            this.processExplode((AnnotationValue<Parameter>)paramAnn, paramValues);
            JsonNode jsonNode = this.jsonMapper.valueToTree(paramValues);
            if (newParameter == null) {
                try {
                    newParameter = this.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class);
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                }
            } else {
                try {
                    io.swagger.v3.oas.models.parameters.Parameter v = this.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class);
                    if (v == null) {
                        BeanMap target = BeanMap.of((Object)newParameter);
                        for (CharSequence name : paramValues.keySet()) {
                            Object o = paramValues.get(name.toString());
                            try {
                                target.put((Object)name.toString(), o);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        BeanMap beanMap = BeanMap.of((Object)v);
                        BeanMap target = BeanMap.of((Object)newParameter);
                        for (CharSequence name : paramValues.keySet()) {
                            Object o = beanMap.get((Object)name.toString());
                            target.put((Object)name.toString(), o);
                        }
                    }
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                }
            }
            if (newParameter != null) {
                AnnotationValue schemaAnn;
                Schema parameterSchema = newParameter.getSchema();
                if (paramAnn.contains("schema") && parameterSchema != null && (schemaAnn = (AnnotationValue)paramAnn.get((CharSequence)"schema", AnnotationValue.class).orElse(null)) != null) {
                    this.bindSchemaAnnotationValue(context, (Element)parameter, parameterSchema, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
                }
            }
        }
        return newParameter;
    }

    private void processBody(VisitorContext context, OpenAPI openAPI, Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, List<MediaType> consumesMediaTypes, TypedElement parameter, ClassElement parameterType) {
        CharSequence desc;
        if (!permitsRequestBody) {
            return;
        }
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (requestBody == null) {
            requestBody = new RequestBody();
            swaggerOperation.setRequestBody(requestBody);
        }
        if (requestBody.getDescription() == null && javadocDescription != null && (desc = javadocDescription.getParameters().get(parameter.getName())) != null) {
            requestBody.setDescription(desc.toString());
        }
        if (requestBody.getRequired() == null) {
            requestBody.setRequired(Boolean.valueOf(!parameter.isNullable() && !parameterType.isOptional()));
        }
        Content content = consumesMediaTypes.isEmpty() ? this.buildContent((Element)parameter, parameterType, Collections.singletonList(MediaType.APPLICATION_JSON_TYPE), openAPI, context) : this.buildContent((Element)parameter, parameterType, consumesMediaTypes, openAPI, context);
        if (requestBody.getContent() == null) {
            requestBody.setContent(content);
        } else {
            Content currentContent = requestBody.getContent();
            content.forEach((key, value) -> {
                io.swagger.v3.oas.models.media.MediaType cfr_ignored_0 = (io.swagger.v3.oas.models.media.MediaType)currentContent.putIfAbsent(key, value);
            });
        }
    }

    private void processRequestBean(VisitorContext context, OpenAPI openAPI, Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters) {
        for (FieldElement field : parameter.getType().getFields()) {
            if (field.isStatic()) continue;
            this.processParameter(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, (TypedElement)field, extraBodyParameters);
        }
    }

    private void readResponse(MethodElement element, VisitorContext context, OpenAPI openAPI, Operation swaggerOperation, JavadocDescription javadocDescription) {
        HttpStatus methodResponseStatus = element.enumValue(Status.class, HttpStatus.class).orElse(HttpStatus.OK);
        String responseCode = String.valueOf(methodResponseStatus.getCode());
        ApiResponses responses = swaggerOperation.getResponses();
        ApiResponse response = null;
        if (responses == null) {
            responses = new ApiResponses();
            swaggerOperation.setResponses(responses);
        } else {
            ApiResponse defaultResponse = (ApiResponse)responses.remove((Object)"default");
            response = (ApiResponse)responses.get((Object)responseCode);
            if (response == null && defaultResponse != null) {
                response = defaultResponse;
                responses.put((Object)responseCode, (Object)response);
            }
        }
        if (response == null) {
            response = new ApiResponse();
            if (javadocDescription == null) {
                response.setDescription(swaggerOperation.getOperationId() + " " + responseCode + " response");
            } else {
                response.setDescription(javadocDescription.getReturnDescription());
            }
            this.addResponseContent(element, context, openAPI, response);
            responses.put((Object)responseCode, (Object)response);
        } else if (response.getContent() == null) {
            this.addResponseContent(element, context, openAPI, response);
        }
    }

    private void addResponseContent(MethodElement element, VisitorContext context, OpenAPI openAPI, ApiResponse response) {
        ClassElement returnType = this.returnType(element, context);
        if (returnType != null) {
            List<MediaType> producesMediaTypes = this.producesMediaTypes(element);
            Content content = producesMediaTypes.isEmpty() ? this.buildContent((Element)element, returnType, Collections.singletonList(MediaType.APPLICATION_JSON_TYPE), openAPI, context) : this.buildContent((Element)element, returnType, producesMediaTypes, openAPI, context);
            response.setContent(content);
        }
    }

    private ClassElement returnType(MethodElement element, VisitorContext context) {
        Object returnType;
        ClassElement classElement = returnType = AbstractOpenApiEndpointVisitor.isJavaElement(element.getOwningType(), context) ? JavaClassElementExt.getGenericReturnType(element, context) : element.getGenericReturnType();
        if (this.isVoid((ClassElement)returnType) || this.isReactiveAndVoid((ClassElement)returnType)) {
            returnType = null;
        } else if (this.isResponseType((ClassElement)returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        } else if (this.isSingleResponseType((ClassElement)returnType)) {
            returnType = (ClassElement)returnType.getFirstTypeArgument().get();
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        }
        if (AbstractOpenApiEndpointVisitor.isJavaElement(returnType, context)) {
            returnType = new JavaClassElementExt((ClassElement)returnType, context);
        }
        return returnType;
    }

    private Map<String, UriMatchVariable> pathVariables(UriMatchTemplate matchTemplate) {
        List pv = matchTemplate.getVariables();
        LinkedHashMap<String, UriMatchVariable> pathVariables = new LinkedHashMap<String, UriMatchVariable>(pv.size());
        for (UriMatchVariable variable : pv) {
            pathVariables.put(variable.getName(), variable);
        }
        return pathVariables;
    }

    private JavadocDescription getMethodDescription(MethodElement element, Operation swaggerOperation) {
        JavadocDescription javadocDescription;
        String descr = this.description(element);
        if (StringUtils.isNotEmpty((CharSequence)descr) && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
            swaggerOperation.setDescription(descr);
            swaggerOperation.setSummary(descr);
        }
        if ((javadocDescription = (JavadocDescription)element.getDocumentation().map(s -> new JavadocParser().parse((String)s)).orElse(null)) != null && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
            swaggerOperation.setDescription(javadocDescription.getMethodDescription());
            swaggerOperation.setSummary(javadocDescription.getMethodDescription());
        }
        return javadocDescription;
    }

    private Operation readOperation(MethodElement element, VisitorContext context) {
        Optional operationAnnotation = element.findAnnotation(io.swagger.v3.oas.annotations.Operation.class);
        Operation swaggerOperation = operationAnnotation.flatMap(o -> this.toValue(o.getValues(), context, Operation.class)).orElse(new Operation());
        if (StringUtils.isEmpty((CharSequence)swaggerOperation.getOperationId())) {
            swaggerOperation.setOperationId(element.getName());
        }
        return swaggerOperation;
    }

    private void readSecurityRequirements(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        for (SecurityRequirement securityItem : this.methodSecurityRequirements(element, context)) {
            swaggerOperation.addSecurityItem(securityItem);
        }
    }

    private void processExplode(AnnotationValue<Parameter> paramAnn, Map<CharSequence, Object> paramValues) {
        Optional explode = paramAnn.enumValue("explode", Explode.class);
        if (explode.isPresent()) {
            Explode ex = (Explode)explode.get();
            block0 : switch (ex) {
                case TRUE: {
                    paramValues.put("explode", Boolean.TRUE);
                    break;
                }
                case FALSE: {
                    paramValues.put("explode", Boolean.FALSE);
                    break;
                }
                default: {
                    String in = (String)paramValues.get("in");
                    if (in == null || in.isEmpty()) {
                        in = "DEFAULT";
                    }
                    switch (ParameterIn.valueOf((String)in.toUpperCase(Locale.US))) {
                        case COOKIE: 
                        case QUERY: {
                            paramValues.put("explode", Boolean.TRUE);
                            break block0;
                        }
                    }
                    paramValues.put("explode", Boolean.FALSE);
                }
            }
        }
    }

    private boolean ignoreParameter(TypedElement parameter) {
        return parameter.isAnnotationPresent(Hidden.class) || parameter.isAnnotationPresent(JsonIgnore.class) || parameter.getValue(Parameter.class, "hidden", Boolean.class).orElse(false) != false || AbstractOpenApiEndpointVisitor.isAnnotationPresent((Element)parameter, "io.micronaut.session.annotation.SessionValue") || this.isIgnoredParameterType(parameter.getType());
    }

    private boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.session.Session") || parameterType.isAssignable("io.micronaut.security.authentication.Authentication") || parameterType.isAssignable("kotlin.coroutines.Continuation") || parameterType.isAssignable(HttpRequest.class) || parameterType.isAssignable("io.micronaut.http.BasicAuth");
    }

    private boolean isResponseType(ClassElement returnType) {
        return returnType.isAssignable(HttpResponse.class) || returnType.isAssignable("org.springframework.http.HttpEntity");
    }

    private boolean isSingleResponseType(ClassElement returnType) {
        boolean assignable = returnType.isAssignable("io.reactivex.Single") || returnType.isAssignable("org.reactivestreams.Publisher");
        return assignable && returnType.getFirstTypeArgument().isPresent() && this.isResponseType((ClassElement)returnType.getFirstTypeArgument().get());
    }

    private boolean isVoid(ClassElement returnType) {
        return returnType.isAssignable(Void.TYPE) || returnType.isAssignable("java.lang.Void");
    }

    private boolean isReactiveAndVoid(ClassElement returnType) {
        return returnType.isAssignable("io.reactivex.Completable") || Stream.of("reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "io.reactivex.Flowable", "io.reactivex.Maybe").anyMatch(t -> returnType.isAssignable(t) && returnType.getFirstTypeArgument().isPresent() && this.isVoid((ClassElement)returnType.getFirstTypeArgument().get()));
    }

    private Operation setOperationOnPathItem(PathItem pathItem, Operation swaggerOperation, HttpMethod httpMethod) {
        Operation operation = swaggerOperation;
        switch (httpMethod) {
            case GET: {
                if (pathItem.getGet() != null) {
                    operation = pathItem.getGet();
                    break;
                }
                pathItem.get(swaggerOperation);
                break;
            }
            case POST: {
                if (pathItem.getPost() != null) {
                    operation = pathItem.getPost();
                    break;
                }
                pathItem.post(swaggerOperation);
                break;
            }
            case PUT: {
                if (pathItem.getPut() != null) {
                    operation = pathItem.getPut();
                    break;
                }
                pathItem.put(swaggerOperation);
                break;
            }
            case PATCH: {
                if (pathItem.getPatch() != null) {
                    operation = pathItem.getPatch();
                    break;
                }
                pathItem.patch(swaggerOperation);
                break;
            }
            case DELETE: {
                if (pathItem.getDelete() != null) {
                    operation = pathItem.getDelete();
                    break;
                }
                pathItem.delete(swaggerOperation);
                break;
            }
            case HEAD: {
                if (pathItem.getHead() != null) {
                    operation = pathItem.getHead();
                    break;
                }
                pathItem.head(swaggerOperation);
                break;
            }
            case OPTIONS: {
                if (pathItem.getOptions() != null) {
                    operation = pathItem.getOptions();
                    break;
                }
                pathItem.options(swaggerOperation);
                break;
            }
            case TRACE: {
                if (pathItem.getTrace() != null) {
                    operation = pathItem.getTrace();
                    break;
                }
                pathItem.trace(swaggerOperation);
                break;
            }
            default: {
                operation = swaggerOperation;
            }
        }
        return operation;
    }

    private void readApiResponses(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List responseAnnotations = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        if (CollectionUtils.isNotEmpty((Collection)responseAnnotations)) {
            ApiResponses apiResponses = new ApiResponses();
            for (AnnotationValue r : responseAnnotations) {
                Optional<ApiResponse> newResponse = this.toValue(r.getValues(), context, ApiResponse.class);
                newResponse.ifPresent(apiResponse -> {
                    ApiResponse cfr_ignored_0 = (ApiResponse)apiResponses.put((Object)r.get((CharSequence)"responseCode", String.class).orElse("default"), apiResponse);
                });
            }
            swaggerOperation.setResponses(apiResponses);
        }
    }

    private Optional<RequestBody> readSwaggerRequestBody(Element element, VisitorContext context) {
        return element.findAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class).flatMap(annotation -> this.toValue(annotation.getValues(), context, RequestBody.class));
    }

    private void readServers(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        for (Server server : this.methodServers(element, context)) {
            swaggerOperation.addServersItem(server);
        }
    }

    private void readCallbacks(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List callbackAnnotations = element.getAnnotationValuesByType(Callback.class);
        if (CollectionUtils.isEmpty((Collection)callbackAnnotations)) {
            return;
        }
        for (AnnotationValue callbackAnn : callbackAnnotations) {
            Optional name = callbackAnn.get((CharSequence)"name", String.class);
            if (!name.isPresent()) continue;
            String callbackName = (String)name.get();
            Optional expr = callbackAnn.get((CharSequence)"callbackUrlExpression", String.class);
            if (expr.isPresent()) {
                this.processUrlCallbackExpression(context, swaggerOperation, (AnnotationValue<Callback>)callbackAnn, callbackName, (String)expr.get());
                continue;
            }
            this.processCallbackReference(context, swaggerOperation, callbackName);
        }
    }

    private void processCallbackReference(VisitorContext context, Operation swaggerOperation, String callbackName) {
        Components components = this.resolveComponents(this.resolveOpenAPI(context));
        Map callbackComponents = components.getCallbacks();
        if (callbackComponents != null && callbackComponents.containsKey(callbackName)) {
            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
            io.swagger.v3.oas.models.callbacks.Callback callbackRef = new io.swagger.v3.oas.models.callbacks.Callback();
            callbackRef.set$ref("#/components/callbacks/" + callbackName);
            callbacks.put(callbackName, callbackRef);
        }
    }

    private void processUrlCallbackExpression(VisitorContext context, Operation swaggerOperation, AnnotationValue<Callback> callbackAnn, String callbackName, String callbackUrl) {
        List operations = callbackAnn.getAnnotations("operation", io.swagger.v3.oas.annotations.Operation.class);
        if (CollectionUtils.isEmpty((Collection)operations)) {
            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
            io.swagger.v3.oas.models.callbacks.Callback c = new io.swagger.v3.oas.models.callbacks.Callback();
            c.addPathItem(callbackUrl, new PathItem());
            callbacks.put(callbackName, c);
        } else {
            PathItem pathItem = new PathItem();
            for (AnnotationValue operation : operations) {
                Optional operationMethod = operation.get((CharSequence)"method", HttpMethod.class);
                operationMethod.ifPresent(httpMethod -> this.toValue(operation.getValues(), context, Operation.class).ifPresent(op -> this.setOperationOnPathItem(pathItem, (Operation)op, (HttpMethod)httpMethod)));
            }
            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
            io.swagger.v3.oas.models.callbacks.Callback c = new io.swagger.v3.oas.models.callbacks.Callback();
            c.addPathItem(callbackUrl, pathItem);
            callbacks.put(callbackName, c);
        }
    }

    private Map<String, io.swagger.v3.oas.models.callbacks.Callback> initCallbacks(Operation swaggerOperation) {
        LinkedHashMap callbacks = swaggerOperation.getCallbacks();
        if (callbacks == null) {
            callbacks = new LinkedHashMap();
            swaggerOperation.setCallbacks(callbacks);
        }
        return callbacks;
    }

    private void addTagIfNotPresent(String tag, Operation swaggerOperation) {
        List tags = swaggerOperation.getTags();
        if (tags == null || !tags.contains(tag)) {
            swaggerOperation.addTagsItem(tag);
        }
    }

    private void readTags(MethodElement element, Operation swaggerOperation, List<io.swagger.v3.oas.models.tags.Tag> classTags) {
        element.getAnnotationValuesByType(Tag.class).forEach(av -> av.get((CharSequence)"name", String.class).ifPresent(arg_0 -> ((Operation)swaggerOperation).addTagsItem(arg_0)));
        element.getValues(Tags.class, AnnotationValue.class).forEach((k, v) -> v.get((CharSequence)"name", String.class).ifPresent(name -> this.addTagIfNotPresent((String)name, swaggerOperation)));
        classTags.forEach(tag -> this.addTagIfNotPresent(tag.getName(), swaggerOperation));
    }

    private List<io.swagger.v3.oas.models.tags.Tag> readTags(ClassElement element, VisitorContext context) {
        return this.readTags(element.getAnnotationValuesByType(Tag.class), context);
    }

    List<io.swagger.v3.oas.models.tags.Tag> readTags(List<AnnotationValue<Tag>> annotations, VisitorContext context) {
        return annotations.stream().map(av -> this.toValue(av.getValues(), context, io.swagger.v3.oas.models.tags.Tag.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Content buildContent(Element definingElement, ClassElement type, List<MediaType> mediaTypes, OpenAPI openAPI, VisitorContext context) {
        Content content = new Content();
        mediaTypes.forEach(mediaType -> {
            io.swagger.v3.oas.models.media.MediaType mt = new io.swagger.v3.oas.models.media.MediaType();
            mt.setSchema(this.resolveSchema(openAPI, definingElement, type, context, Collections.singletonList(mediaType)));
            content.addMediaType(mediaType.toString(), mt);
        });
        return content;
    }

    PropertyPlaceholderResolver getPropertyPlaceholderResolver() {
        if (this.propertyPlaceholderResolver == null) {
            this.propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(new PropertyResolver(){

                public boolean containsProperty(@NonNull String name) {
                    return false;
                }

                public boolean containsProperties(@NonNull String name) {
                    return false;
                }

                @NonNull
                public <T> Optional<T> getProperty(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
                    return Optional.empty();
                }

                @NonNull
                public Collection<String> getPropertyEntries(@NonNull String name) {
                    return null;
                }
            }, (ConversionService)new DefaultConversionService());
        }
        return this.propertyPlaceholderResolver;
    }
}

