/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;

abstract class AbstractOpenApiVisitor {
    static final String ATTR_OPENAPI = "io.micronaut.OPENAPI";
    static OpenAPI testReference;
    static String testYamlReference;
    private static final String ATTR_TEST_MODE = "io.micronaut.OPENAPI_TEST";
    private static final Lock VISITED_ELEMENTS_LOCK;
    private static final String ATTR_VISITED_ELEMENTS = "io.micronaut.OPENAPI.visited.elements";
    private static final Schema<?> EMPTY_SCHEMA;
    ObjectMapper jsonMapper = Json.mapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    ObjectMapper yamlMapper = Yaml.mapper();
    private List<String> inProgressSchemas = new ArrayList<String>(10);
    private Map<String, PropertyNamingStrategy> propertyNamingStrategyInstances = new HashMap<String, PropertyNamingStrategy>();

    AbstractOpenApiVisitor() {
    }

    void incrementVisitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            context.put((CharSequence)ATTR_VISITED_ELEMENTS, (Object)(AbstractOpenApiVisitor.getVisitedElements(context) + 1));
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    int visitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            int n = AbstractOpenApiVisitor.getVisitedElements(context);
            return n;
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    private static Integer getVisitedElements(VisitorContext context) {
        Integer visitedElements = context.get((CharSequence)ATTR_VISITED_ELEMENTS, Integer.class).orElse(null);
        if (visitedElements == null) {
            visitedElements = 0;
            context.put((CharSequence)ATTR_VISITED_ELEMENTS, (Object)visitedElements);
        }
        return visitedElements;
    }

    JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context) {
        Map<CharSequence, Object> newValues = this.toValueMap(values, context);
        return this.jsonMapper.valueToTree(newValues);
    }

    <T> Optional<T> toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type) {
        JsonNode node = this.toJson(values, context);
        try {
            return Optional.of(this.treeToValue(node, type));
        }
        catch (JsonProcessingException e) {
            context.warn("Error converting  [" + node + "]: to " + type + ": " + e.getMessage(), null);
            return Optional.empty();
        }
    }

    List<SecurityRequirement> readSecurityRequirements(Element element) {
        return this.readSecurityRequirements(element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class));
    }

    List<SecurityRequirement> readSecurityRequirements(List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> annotations) {
        return annotations.stream().map(this::mapToSecurityRequirement).collect(Collectors.toList());
    }

    PathItem resolvePathItem(VisitorContext context, UriMatchTemplate matchTemplate) {
        OpenAPI openAPI = this.resolveOpenAPI(context);
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            openAPI.setPaths(paths);
        }
        String pathString = matchTemplate.toPathString();
        return (PathItem)paths.computeIfAbsent((Object)pathString, key -> new PathItem());
    }

    OpenAPI resolveOpenAPI(VisitorContext context) {
        OpenAPI openAPI = context.get((CharSequence)ATTR_OPENAPI, OpenAPI.class).orElse(null);
        if (openAPI == null) {
            openAPI = new OpenAPI();
            context.put((CharSequence)ATTR_OPENAPI, (Object)openAPI);
            if (this.isTestMode()) {
                testReference = openAPI;
            }
        }
        return openAPI;
    }

    protected <T> T treeToValue(JsonNode jn, Class<T> clazz) throws JsonProcessingException {
        Object value = this.jsonMapper.treeToValue((TreeNode)jn, clazz);
        if (value != null) {
            this.resolveExtensions(jn).ifPresent(extensions -> BeanMap.of((Object)value).put((Object)"extensions", extensions));
        }
        return (T)value;
    }

    protected Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                Map<CharSequence, Object> valueMap;
                AnnotationValue av = (AnnotationValue)value;
                if (av.getAnnotationName().equals(io.swagger.v3.oas.annotations.media.ArraySchema.class.getName())) {
                    valueMap = this.resolveArraySchemaAnnotationValues(context, av);
                    newValues.put("schema", valueMap);
                    continue;
                }
                valueMap = this.resolveAnnotationValues(context, av);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                Optional type = acv.getType();
                type.ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Object first = a[0];
                    boolean areAnnotationValues = first instanceof AnnotationValue;
                    boolean areClassValues = first instanceof AnnotationClassValue;
                    if (areClassValues) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (areAnnotationValues) {
                        Map<CharSequence, Object> valueMap;
                        Map<CharSequence, Object> map;
                        String name2;
                        AnnotationValue sv;
                        Map params;
                        String annotationName = ((AnnotationValue)first).getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(this.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            HashMap<CharSequence, Object> extensions = new HashMap<CharSequence, Object>();
                            for (Object o : a) {
                                this.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Content.class.getName().equals(annotationName)) {
                            Map mediaTypes = this.annotationValueArrayToSubmap(a, "mediaType", context);
                            newValues.put(key, mediaTypes);
                            continue;
                        }
                        if (Link.class.getName().equals(annotationName) || Header.class.getName().equals(annotationName)) {
                            Map links = this.annotationValueArrayToSubmap(a, "name", context);
                            newValues.put(key, links);
                            continue;
                        }
                        if (LinkParameter.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "expression");
                            newValues.put(key, params);
                            continue;
                        }
                        if (OAuthScope.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "description");
                            newValues.put(key, params);
                            continue;
                        }
                        if (ApiResponse.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> responses = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.get((CharSequence)"responseCode", String.class).orElse("200");
                                map = this.toValueMap(sv.getValues(), context);
                                responses.put(name2, map);
                            }
                            newValues.put(key, responses);
                            continue;
                        }
                        if (ExampleObject.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> examples = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.get((CharSequence)"name", String.class).orElse("example");
                                map = this.toValueMap(sv.getValues(), context);
                                examples.put(name2, map);
                            }
                            newValues.put(key, examples);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList servers = new ArrayList();
                            for (Object o : a) {
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>();
                                AnnotationValue sv2 = (AnnotationValue)o;
                                variables.putAll(this.toValueMap(sv2.getValues(), context));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                Optional n = sv.get((CharSequence)"name", String.class);
                                n.ifPresent(name -> {
                                    Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (DiscriminatorMapping.class.getName().equals(annotationName)) {
                            HashMap<String, String> mappings = new HashMap<String, String>();
                            for (Object o : a) {
                                AnnotationValue dv = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, dv);
                                mappings.put(valueMap.get("value").toString(), valueMap.get("$ref").toString());
                            }
                            Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                            discriminatorMap.put("mapping", mappings);
                            newValues.put("discriminator", discriminatorMap);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap2 = this.resolveAnnotationValues(context, av);
                            newValues.put(key, this.toValueMap(valueMap2, context));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, av);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            if (key.equals("discriminatorProperty")) {
                Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                discriminatorMap.put("propertyName", this.parseJsonString(value).orElse(value));
                newValues.put("discriminator", discriminatorMap);
                continue;
            }
            if (key.equals("accessMode")) {
                if (Schema.AccessMode.READ_ONLY.toString().equals(value)) {
                    newValues.put("readOnly", Boolean.TRUE);
                    continue;
                }
                if (!Schema.AccessMode.WRITE_ONLY.toString().equals(value)) continue;
                newValues.put("writeOnly", Boolean.TRUE);
                continue;
            }
            newValues.put(key, this.parseJsonString(value).orElse(value));
        }
        return newValues;
    }

    private Map<String, Object> getDiscriminatorMap(Map<CharSequence, Object> newValues) {
        return newValues.containsKey("discriminator") ? (Map)newValues.get("discriminator") : new HashMap();
    }

    private void processExtensions(Map<CharSequence, Object> map, AnnotationValue<Extension> extension) {
        String name = extension.stringValue("name").orElse("");
        String key = name.length() > 0 ? StringUtils.prependIfMissing((String)name, (CharSequence)"x-", (CharSequence[])new CharSequence[0]) : name;
        for (AnnotationValue prop : extension.getAnnotations("properties", ExtensionProperty.class)) {
            String propertyName = (String)prop.getRequiredValue("name", String.class);
            String propertyValue = (String)prop.getRequiredValue(String.class);
            JsonNode processedValue = null;
            boolean propertyAsJson = (Boolean)prop.get((CharSequence)"parseValue", Boolean.TYPE, (Object)false);
            if (!StringUtils.isNotBlank((CharSequence)propertyName) || !StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
            if (key.isEmpty()) {
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), processedValue);
                    }
                    catch (Exception e) {
                        map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                    }
                    continue;
                }
                map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                continue;
            }
            LinkedHashMap value = map.get(key);
            if (!(value instanceof Map)) {
                value = new LinkedHashMap();
                map.put(key, value);
            }
            Map mapValue = value;
            if (propertyAsJson) {
                try {
                    processedValue = Json.mapper().readTree(propertyValue);
                    mapValue.put(propertyName, processedValue);
                }
                catch (Exception e) {
                    mapValue.put(propertyName, propertyValue);
                }
                continue;
            }
            mapValue.put(propertyName, propertyValue);
        }
    }

    private Optional<Object> parseJsonString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Optional.of(this.jsonMapper.readValue(string, Map.class));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private <T extends Schema> void processAnnotationValue(VisitorContext context, AnnotationValue<?> annotationValue, Map<CharSequence, Object> arraySchemaMap, List<String> filters, Class<T> type) {
        Map<CharSequence, Object> values = annotationValue.getValues().entrySet().stream().filter(entry -> filters == null || !filters.contains(entry.getKey())).collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schema = this.toValue(values, context, type);
        schema.ifPresent(s -> this.schemaToValueMap(arraySchemaMap, (Schema)s));
    }

    private Map<CharSequence, Object> resolveArraySchemaAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        HashMap<CharSequence, Object> arraySchemaMap = new HashMap<CharSequence, Object>(10);
        av.get((CharSequence)"arraySchema", AnnotationValue.class).ifPresent(annotationValue -> this.processAnnotationValue(context, (AnnotationValue<?>)annotationValue, (Map<CharSequence, Object>)arraySchemaMap, Arrays.asList("ref", "implementation"), (Class)Schema.class));
        av.get((CharSequence)"schema", AnnotationValue.class).ifPresent(annotationValue -> {
            Optional impl = annotationValue.get((CharSequence)"implementation", String.class);
            Optional type = annotationValue.get((CharSequence)"type", String.class);
            Optional format = annotationValue.get((CharSequence)"format", String.class);
            Optional classElement = Optional.empty();
            PrimitiveType primitiveType = null;
            if (impl.isPresent()) {
                classElement = context.getClassElement((String)impl.get());
            } else if (type.isPresent()) {
                primitiveType = PrimitiveType.fromName((String)(format.isPresent() && ((String)format.get()).equals("binary") ? (String)format.get() : (String)type.get()));
                classElement = primitiveType == null ? context.getClassElement((String)type.get()) : context.getClassElement(primitiveType.getKeyClass());
            }
            if (classElement.isPresent()) {
                if (primitiveType == null) {
                    ArraySchema schema = this.arraySchema(this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList()));
                    this.schemaToValueMap(arraySchemaMap, (Schema)schema);
                } else {
                    Schema items = primitiveType.createProperty();
                    items.setDescription((String)annotationValue.get((CharSequence)"description", String.class).orElse(null));
                    ArraySchema schema = this.arraySchema(items);
                    this.schemaToValueMap(arraySchemaMap, (Schema)schema);
                }
            } else {
                arraySchemaMap.putAll(this.resolveAnnotationValues(context, (AnnotationValue<?>)annotationValue));
            }
        });
        this.processAnnotationValue(context, av, arraySchemaMap, Arrays.asList("schema", "arraySchema"), ArraySchema.class);
        return arraySchemaMap;
    }

    private Map<CharSequence, Object> resolveAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        Map<CharSequence, Object> valueMap = this.toValueMap(av.getValues(), context);
        this.bindSchemaIfNeccessary(context, av, valueMap);
        String annotationName = av.getAnnotationName();
        if (Parameter.class.getName().equals(annotationName)) {
            this.normalizeEnumValues(valueMap, CollectionUtils.mapOf((Object[])new Object[]{"in", ParameterIn.class, "style", ParameterStyle.class}));
        }
        return valueMap;
    }

    private Map toTupleSubMap(Object[] a, String entryKey, String entryValue) {
        LinkedHashMap params = new LinkedHashMap();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            Optional n = sv.get((CharSequence)entryKey, String.class);
            Optional expr = sv.get((CharSequence)entryValue, String.class);
            if (!n.isPresent() || !expr.isPresent()) continue;
            params.put(n.get(), expr.get());
        }
        return params;
    }

    private boolean isTypeNullable(ClassElement type) {
        return type.isAssignable("java.util.Optional");
    }

    @Nullable
    protected Schema resolveSchema(@Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes) {
        return this.resolveSchema(this.resolveOpenAPI(context), definingElement, type, context, mediaTypes);
    }

    @Nullable
    protected Schema resolveSchema(OpenAPI openAPI, @Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes) {
        Object schema = null;
        AnnotationValue schemaAnnotationValue = null;
        if (definingElement != null) {
            schemaAnnotationValue = definingElement.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (type != null && schemaAnnotationValue == null) {
            schemaAnnotationValue = type.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (schemaAnnotationValue != null) {
            type = schemaAnnotationValue.stringValue("implementation").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(type);
        }
        if (type instanceof EnumElement) {
            schema = this.getSchemaDefinition(openAPI, context, type, definingElement, mediaTypes);
        } else {
            boolean isPublisher = false;
            boolean isObservable = false;
            boolean isNullable = false;
            if (!type.isAssignable("io.micronaut.http.multipart.StreamingFileUpload") && this.isContainerType(type)) {
                isPublisher = type.isAssignable(Publisher.class.getName()) && !type.isAssignable("reactor.core.publisher.Mono");
                isObservable = type.isAssignable("io.reactivex.Observable") && !type.isAssignable("reactor.core.publisher.Mono");
                type = type.getFirstTypeArgument().orElse(null);
            } else if (this.isTypeNullable(type)) {
                isNullable = true;
                type = type.getFirstTypeArgument().orElse(null);
            }
            if (type != null) {
                String typeName = type.getName();
                if ("io.micronaut.http.multipart.StreamingFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedPart".equals(typeName) || "io.micronaut.http.multipart.PartData".equals(typeName)) {
                    isPublisher = isPublisher && !"io.micronaut.http.multipart.PartData".equals(typeName);
                    typeName = PrimitiveType.BINARY.name();
                }
                PrimitiveType primitiveType = PrimitiveType.fromName((String)typeName);
                if (!type.isArray() && ClassUtils.isJavaLangType((String)typeName)) {
                    schema = this.getPrimitiveType(typeName);
                } else if (!type.isArray() && primitiveType != null) {
                    schema = primitiveType.createProperty();
                } else if (type.isAssignable(Map.class.getName())) {
                    schema = new MapSchema();
                    if (type.getTypeArguments().isEmpty()) {
                        schema.setAdditionalProperties((Object)true);
                    } else {
                        ClassElement valueType = (ClassElement)type.getTypeArguments().get("V");
                        if (valueType.getName().equals(Object.class.getName())) {
                            schema.setAdditionalProperties((Object)true);
                        } else {
                            schema.setAdditionalProperties((Object)this.resolveSchema(openAPI, (Element)type, valueType, context, mediaTypes));
                        }
                    }
                } else if (type.isIterable()) {
                    Optional componentType;
                    schema = type.isArray() ? this.resolveSchema(openAPI, (Element)type, type.fromArray(), context, mediaTypes) : ((componentType = type.getFirstTypeArgument()).isPresent() ? this.resolveSchema(openAPI, (Element)type, (ClassElement)componentType.get(), context, mediaTypes) : this.getPrimitiveType(Object.class.getName()));
                    if (schema != null) {
                        schema = this.arraySchema((Schema)schema);
                    }
                } else if (this.isReturnTypeFile(type)) {
                    schema = new StringSchema();
                    schema.setFormat("binary");
                } else {
                    schema = type.isAssignable(UUID.class) ? new UUIDSchema() : this.getSchemaDefinition(openAPI, context, type, definingElement, mediaTypes);
                }
            }
            if (schema != null) {
                boolean isStream = false;
                for (MediaType mediaType : mediaTypes) {
                    if (!MediaType.TEXT_EVENT_STREAM_TYPE.equals((Object)mediaType) && !MediaType.APPLICATION_JSON_STREAM_TYPE.equals((Object)mediaType)) continue;
                    isStream = true;
                    break;
                }
                if (!isStream && (isPublisher || isObservable)) {
                    schema = this.arraySchema((Schema)schema);
                } else if (isNullable) {
                    schema.setNullable(Boolean.valueOf(true));
                }
            }
        }
        return schema;
    }

    protected Components resolveComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            components = new Components();
            openAPI.setComponents(components);
        }
        return components;
    }

    private void handleUnwrapped(VisitorContext context, Element element, ClassElement elementType, Schema parentSchema, AnnotationValue<JsonUnwrapped> uw) {
        String schemaName;
        Map<String, Schema> schemas = this.resolveSchemas(this.resolveOpenAPI(context));
        Schema wrappedPropertySchema = schemas.get(schemaName = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(this.computeDefaultSchemaName(null, (Element)elementType)));
        Map properties = wrappedPropertySchema.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String prefix = uw.stringValue("prefix").orElse("");
        String suffix = uw.stringValue("suffix").orElse("");
        for (Map.Entry prop : properties.entrySet()) {
            try {
                boolean isRequired;
                String propertyName = (String)prop.getKey();
                Schema propertySchema = (Schema)prop.getValue();
                boolean bl = isRequired = wrappedPropertySchema.getRequired() != null && wrappedPropertySchema.getRequired().contains(propertyName);
                if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)suffix) || io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)prefix)) {
                    propertyName = prefix + propertyName + suffix;
                    propertySchema = (Schema)this.jsonMapper.readValue(Json.pretty(prop.getValue()), Schema.class);
                    propertySchema.setName(propertyName);
                }
                this.addProperty(parentSchema, propertyName, propertySchema, isRequired);
            }
            catch (IOException e) {
                context.warn("Exception cloning property " + e.getMessage(), null);
            }
        }
    }

    protected void processSchemaProperty(VisitorContext context, Element element, ClassElement elementType, @Nullable Element classElement, Schema parentSchema, Schema propertySchema) {
        if (propertySchema != null) {
            AnnotationValue uw = element.getAnnotation(JsonUnwrapped.class);
            if (uw != null && uw.booleanValue("enabled").orElse(Boolean.TRUE).booleanValue()) {
                this.handleUnwrapped(context, element, elementType, parentSchema, (AnnotationValue<JsonUnwrapped>)uw);
            } else {
                boolean required = this.hasElementSchemaRequired(element).orElseGet(() -> this.isElementNotNullable(element, classElement));
                propertySchema = this.bindSchemaForElement(context, element, elementType, propertySchema);
                String propertyName = this.resolvePropertyName(element, classElement, propertySchema);
                this.addProperty(parentSchema, propertyName, propertySchema, required);
            }
        }
    }

    private Optional<Boolean> hasElementSchemaRequired(Element element) {
        AnnotationValue schemaAnnotationValue = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (schemaAnnotationValue != null) {
            return schemaAnnotationValue.get((CharSequence)"required", Argument.of(Boolean.TYPE));
        }
        return Optional.empty();
    }

    private boolean isElementNotNullable(Element element, @Nullable Element classElement) {
        return element.isAnnotationPresent(NotNull.class) || element.isAnnotationPresent(NotBlank.class) || element.isAnnotationPresent(NotEmpty.class) || element.isNonNull() || this.doesParamExistsMandatoryInConstructor(element, classElement) || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    private boolean doesParamExistsMandatoryInConstructor(Element element, @Nullable Element classElement) {
        if (classElement instanceof ClassElement) {
            return ((ClassElement)classElement).getPrimaryConstructor().flatMap(methodElement -> Arrays.stream(methodElement.getParameters()).filter(parameterElement -> parameterElement.getName().equals(element.getName())).map(parameterElement -> !parameterElement.isNullable()).findFirst()).orElse(false);
        }
        return false;
    }

    private void addProperty(Schema parentSchema, String name, Schema propertySchema, boolean required) {
        List requiredList;
        parentSchema.addProperties(name, propertySchema);
        if (required && ((requiredList = parentSchema.getRequired()) == null || !requiredList.contains(name))) {
            parentSchema.addRequiredItem(name);
        }
    }

    private String resolvePropertyName(Element element, Element classElement, Schema propertySchema) {
        String name = Optional.ofNullable(propertySchema.getName()).orElse(element.getName());
        if (element.hasAnnotation(JsonProperty.class)) {
            return element.stringValue(JsonProperty.class, "value").orElse(name);
        }
        if (classElement != null && classElement.hasAnnotation(JsonNaming.class)) {
            Optional propertyNamingStrategyClass = classElement.stringValue(JsonNaming.class);
            if (!propertyNamingStrategyClass.isPresent()) {
                return name;
            }
            PropertyNamingStrategy strategy = this.propertyNamingStrategyInstances.computeIfAbsent((String)propertyNamingStrategyClass.get(), clazz -> {
                try {
                    return (PropertyNamingStrategy)Class.forName((String)propertyNamingStrategyClass.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate: " + clazz);
                }
            });
            if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                return ((PropertyNamingStrategy.PropertyNamingStrategyBase)strategy).translate(name);
            }
        }
        return name;
    }

    protected Schema bindSchemaForElement(VisitorContext context, Element element, ClassElement elementType, Schema schemaToBind) {
        String defaultJacksonValue;
        Boolean isSchemaNullable;
        String defaultValue;
        boolean isIterableOrMap;
        AnnotationValue arraySchemaAnn;
        AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        Schema originalSchema = schemaToBind;
        if (originalSchema.get$ref() != null) {
            schemaToBind = new Schema();
        }
        if (originalSchema.get$ref() == null && schemaAnn != null) {
            schemaToBind = this.bindSchemaAnnotationValue(context, element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
            Optional schemaName = schemaAnn.get((CharSequence)"name", String.class);
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
            elementType = schemaAnn.stringValue("implementation").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(elementType);
        }
        if ((arraySchemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class)) != null) {
            schemaToBind = this.bindArraySchemaAnnotationValue(context, element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema>)arraySchemaAnn);
            Optional schemaName = arraySchemaAnn.get((CharSequence)"name", String.class);
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
        }
        Schema finalSchemaToBind = schemaToBind;
        boolean bl = isIterableOrMap = elementType.isIterable() || elementType.isAssignable(Map.class);
        if (isIterableOrMap) {
            if (element.isAnnotationPresent(NotEmpty.class)) {
                finalSchemaToBind.setMinItems(Integer.valueOf(1));
            }
            element.getValue(Size.class, "min", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinItems(arg_0));
            element.getValue(Size.class, "max", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaxItems(arg_0));
        } else {
            if ("string".equals(finalSchemaToBind.getType())) {
                if (element.isAnnotationPresent(NotEmpty.class) || element.isAnnotationPresent(NotBlank.class)) {
                    finalSchemaToBind.setMinLength(Integer.valueOf(1));
                }
                element.getValue(Size.class, "min", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinLength(arg_0));
                element.getValue(Size.class, "max", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaxLength(arg_0));
            }
            if (element.isAnnotationPresent(Negative.class)) {
                finalSchemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent(NegativeOrZero.class)) {
                finalSchemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent(Positive.class)) {
                finalSchemaToBind.setMinimum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent(PositiveOrZero.class)) {
                finalSchemaToBind.setMinimum(BigDecimal.ZERO);
            }
            element.getValue(Max.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaximum(arg_0));
            element.getValue(Min.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinimum(arg_0));
            element.getValue(DecimalMax.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaximum(arg_0));
            element.getValue(DecimalMin.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinimum(arg_0));
            if (element.isAnnotationPresent(Email.class)) {
                finalSchemaToBind.setFormat("email");
            }
            element.findAnnotation(Pattern.class).flatMap(p -> p.get((CharSequence)"regexp", String.class)).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setPattern(arg_0));
            element.getValue(Part.class, String.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setName(arg_0));
        }
        this.setSchemaDocumentation(element, schemaToBind);
        if (element.isAnnotationPresent(Deprecated.class)) {
            schemaToBind.setDeprecated(Boolean.valueOf(true));
        }
        if ((defaultValue = (String)element.getValue(Bindable.class, "defaultValue", String.class).orElse(null)) != null && schemaToBind.getDefault() == null) {
            schemaToBind.setDefault((Object)defaultValue);
        }
        if ((isSchemaNullable = (Boolean)element.booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "nullable").orElse(null)) == null && element.isNullable() || Boolean.TRUE.equals(isSchemaNullable) && element.isNullable()) {
            schemaToBind.setNullable(Boolean.valueOf(true));
        }
        if ((defaultJacksonValue = (String)element.stringValue(JsonProperty.class, "defaultValue").orElse(null)) != null && schemaToBind.getDefault() == null) {
            schemaToBind.setDefault((Object)defaultJacksonValue);
        }
        return originalSchema.get$ref() != null && !schemaToBind.equals(EMPTY_SCHEMA) ? new ComposedSchema().addAllOfItem(originalSchema).addAllOfItem(schemaToBind) : originalSchema;
    }

    private void setSchemaDocumentation(Element element, Schema schemaToBind) {
        Optional documentation;
        String doc;
        if (io.micronaut.core.util.StringUtils.isEmpty((CharSequence)schemaToBind.getDescription()) && (doc = (String)(documentation = element.getDocumentation()).orElse(null)) != null) {
            JavadocDescription desc = new JavadocParser().parse(doc);
            schemaToBind.setDescription(desc.getMethodDescription());
        }
    }

    protected Schema bindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, schemaAnn.get((CharSequence)"defaultValue", String.class).orElse(null), schemaAnn.get((CharSequence)"allowableValues", String[].class).orElse(null));
    }

    private Schema doBindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, JsonNode schemaJson, String defaultValue, String ... allowableValues) {
        try {
            schemaToBind = (Schema)this.jsonMapper.readerForUpdating((Object)schemaToBind).readValue(schemaJson);
            if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                schemaToBind.setDefault((Object)defaultValue);
            }
            if (ArrayUtils.isNotEmpty((Object[])allowableValues)) {
                for (String allowableValue : allowableValues) {
                    if (schemaToBind.getEnum() != null && schemaToBind.getEnum().contains(allowableValue)) continue;
                    schemaToBind.addEnumItemObject((Object)allowableValue);
                }
            }
        }
        catch (IOException e) {
            context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
        }
        return schemaToBind;
    }

    protected Schema bindArraySchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema> schemaAnn) {
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
        if (schemaJson.isObject()) {
            ArraySchema arrSchemaToBind;
            JsonNode items;
            ObjectNode objNode = (ObjectNode)schemaJson;
            JsonNode arraySchema = objNode.remove("arraySchema");
            if (arraySchema != null && arraySchema.isObject()) {
                ((ObjectNode)arraySchema).remove("implementation");
                objNode.setAll((ObjectNode)arraySchema);
            }
            if ((items = objNode.remove("schema")) != null && schemaToBind instanceof ArraySchema && ((ArraySchema)schemaToBind).getItems() != null && (arrSchemaToBind = (ArraySchema)schemaToBind).getItems().get$ref() == null) {
                try {
                    arrSchemaToBind.items((Schema)this.jsonMapper.readerForUpdating((Object)arrSchemaToBind.getItems()).readValue(items));
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
                }
            }
        }
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, null, new String[0]);
    }

    private Optional<Map<String, Object>> resolveExtensions(JsonNode jn) {
        try {
            JsonNode extensionsNode = jn.get("extensions");
            if (extensionsNode != null) {
                return Optional.ofNullable(this.jsonMapper.treeToValue((TreeNode)extensionsNode, Map.class));
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private Map annotationValueArrayToSubmap(Object[] a, String classifier, VisitorContext context) {
        LinkedHashMap<String, Map<CharSequence, Object>> mediaTypes = new LinkedHashMap<String, Map<CharSequence, Object>>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            String name = sv.get((CharSequence)classifier, String.class).orElse(null);
            if (name == null && classifier.equals("mediaType")) {
                name = "application/json";
            }
            if (name == null) continue;
            Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
            mediaTypes.put(name, map);
        }
        return mediaTypes;
    }

    private void schemaToValueMap(Map<CharSequence, Object> valueMap, Schema schema) {
        if (schema != null) {
            BeanMap beanMap = BeanMap.of((Object)schema);
            for (Map.Entry e : beanMap.entrySet()) {
                Object v = e.getValue();
                if (v == null) continue;
                valueMap.put((CharSequence)e.getKey(), v);
            }
            if (schema.get$ref() != null) {
                valueMap.put("$ref", schema.get$ref());
            }
        }
    }

    private void bindSchemaIfNeccessary(VisitorContext context, AnnotationValue<?> av, Map<CharSequence, Object> valueMap) {
        String className;
        boolean isSchema;
        Optional impl = av.get((CharSequence)"implementation", String.class);
        Optional schema = av.get((CharSequence)"schema", String.class);
        Optional anyOf = av.get((CharSequence)"anyOf", Argument.of(String[].class));
        Optional oneOf = av.get((CharSequence)"oneOf", Argument.of(String[].class));
        Optional allOf = av.get((CharSequence)"allOf", Argument.of(String[].class));
        Object o = valueMap.remove("defaultValue");
        if (o != null) {
            valueMap.put("default", o);
        }
        if ((o = valueMap.remove("allowableValues")) != null) {
            valueMap.put("enum", o);
        }
        if ((isSchema = io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(av.getAnnotationName())) && impl.isPresent()) {
            className = (String)impl.get();
            this.bindSchemaForClassName(context, valueMap, className);
        }
        if (DiscriminatorMapping.class.getName().equals(av.getAnnotationName()) && schema.isPresent()) {
            className = (String)schema.get();
            this.bindSchemaForClassName(context, valueMap, className);
        }
        if (isSchema && (anyOf.isPresent() || oneOf.isPresent() || allOf.isPresent())) {
            anyOf.ifPresent(anyOfList -> this.bindSchemaForComposite(context, valueMap, (String[])anyOfList, "anyOf"));
            oneOf.ifPresent(oneOfList -> this.bindSchemaForComposite(context, valueMap, (String[])oneOfList, "oneOf"));
            allOf.ifPresent(allOfList -> this.bindSchemaForComposite(context, valueMap, (String[])allOfList, "allOf"));
        }
    }

    private void bindSchemaForComposite(VisitorContext context, Map<CharSequence, Object> valueMap, String[] classNames, String key) {
        List namesToSchemas = Arrays.stream(classNames).map(className -> {
            Optional classElement = context.getClassElement(className);
            HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
            if (classElement.isPresent()) {
                Schema schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList());
                this.schemaToValueMap(schemaMap, schema);
            }
            return schemaMap;
        }).collect(Collectors.toList());
        valueMap.put(key, namesToSchemas);
    }

    private void bindSchemaForClassName(VisitorContext context, Map<CharSequence, Object> valueMap, String className) {
        Optional classElement = context.getClassElement(className);
        if (classElement.isPresent()) {
            Schema schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList());
            this.schemaToValueMap(valueMap, schema);
        }
    }

    private void checkAllOf(ComposedSchema composedSchema) {
        if (composedSchema != null && composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty() && composedSchema.getProperties() != null && !composedSchema.getProperties().isEmpty()) {
            ObjectSchema propSchema = new ObjectSchema();
            propSchema.properties(composedSchema.getProperties());
            propSchema.setDescription(composedSchema.getDescription());
            propSchema.setRequired(composedSchema.getRequired());
            composedSchema.setProperties(null);
            composedSchema.setDescription(null);
            composedSchema.setRequired(null);
            composedSchema.setType(null);
            composedSchema.addAllOfItem((Schema)propSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema getSchemaDefinition(OpenAPI openAPI, VisitorContext context, ClassElement type, @Nullable Element definingElement, List<MediaType> mediaTypes) {
        Schema schema;
        AnnotationValue schemaValue;
        AnnotationValue annotationValue = schemaValue = definingElement == null ? null : definingElement.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (schemaValue == null) {
            schemaValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        Map<String, Schema> schemas = this.resolveSchemas(openAPI);
        if (schemaValue == null) {
            boolean isBasicType = ClassUtils.isJavaBasicType((String)type.getName());
            PrimitiveType primitiveType = isBasicType ? (PrimitiveType)ClassUtils.forName((String)type.getName(), (ClassLoader)this.getClass().getClassLoader()).map(PrimitiveType::fromType).orElse(null) : null;
            if (primitiveType != null) return primitiveType.createProperty();
            String schemaName = this.computeDefaultSchemaName(definingElement, (Element)type);
            schema = schemas.get(schemaName);
            if (schema == null) {
                if (type instanceof EnumElement) {
                    schema = new Schema();
                    schema.setName(schemaName);
                    schemas.put(schemaName, schema);
                    schema.setType("string");
                    schema.setEnum(((EnumElement)type).values());
                } else {
                    if (type instanceof TypedElement) {
                        Optional superType;
                        ClassElement classElement = type.getType();
                        Optional optional = superType = classElement == null ? Optional.empty() : classElement.getSuperType();
                        if (superType.isPresent() && !type.isRecord()) {
                            schema = new ComposedSchema();
                            while (superType.isPresent()) {
                                ClassElement superElement = (ClassElement)superType.get();
                                String parentSchemaName = this.computeDefaultSchemaName(definingElement, (Element)superElement);
                                if (schemas.get(parentSchemaName) != null || this.getSchemaDefinition(openAPI, context, superElement, null, mediaTypes) != null) {
                                    Schema parentSchema = new Schema();
                                    parentSchema.set$ref(this.schemaRef(parentSchemaName));
                                    ((ComposedSchema)schema).addAllOfItem(parentSchema);
                                }
                                superType = superElement.getSuperType();
                            }
                        } else {
                            schema = new Schema();
                        }
                    } else {
                        schema = new Schema();
                    }
                    schema.setType("object");
                    schema.setName(schemaName);
                    schemas.put(schemaName, schema);
                    this.populateSchemaProperties(openAPI, context, (Element)type, schema, mediaTypes);
                    if (schema instanceof ComposedSchema) {
                        this.checkAllOf((ComposedSchema)schema);
                    }
                }
            }
        } else {
            String schemaName = schemaValue.get((CharSequence)"name", String.class).orElse(this.computeDefaultSchemaName(definingElement, (Element)type));
            schema = schemas.get(schemaName);
            if (schema == null) {
                if (this.inProgressSchemas.contains(schemaName)) {
                    return new Schema().$ref(this.schemaRef(schemaName));
                }
                this.inProgressSchemas.add(schemaName);
                try {
                    schema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaValue, openAPI, context, (Element)type, mediaTypes);
                    if (schema != null) {
                        schema.setName(schemaName);
                        schemas.put(schemaName, schema);
                    }
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading Swagger Parameter for element [" + type + "]: " + e.getMessage(), (Element)type);
                }
                finally {
                    this.inProgressSchemas.remove(schemaName);
                }
            }
        }
        if (schema == null) return null;
        this.setSchemaDocumentation((Element)type, schema);
        Schema schemaRef = new Schema();
        schemaRef.set$ref(this.schemaRef(schema.getName()));
        schemaRef.setDescription(schema.getDescription());
        return schemaRef;
    }

    protected Schema readSchema(AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaValue, OpenAPI openAPI, VisitorContext context, @Nullable Element type, List<MediaType> mediaTypes) throws JsonProcessingException {
        Map<CharSequence, Object> values = schemaValue.getValues().entrySet().stream().collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schemaOpt = this.toValue(values, context, Schema.class);
        if (!schemaOpt.isPresent()) {
            return null;
        }
        Schema schema = schemaOpt.get();
        ComposedSchema composedSchema = null;
        if (schema instanceof ComposedSchema) {
            Optional oneof;
            Optional anyOf;
            composedSchema = (ComposedSchema)schema;
            Optional allOf = schemaValue.get((CharSequence)"allOf", String[].class);
            if (allOf.isPresent() && ((String[])allOf.get()).length > 0) {
                String[] names = (String[])allOf.get();
                List<Schema> schemaList = this.namesToSchemas(openAPI, context, names, mediaTypes);
                for (Schema schema2 : schemaList) {
                    composedSchema.addAllOfItem(schema2);
                }
            }
            if ((anyOf = schemaValue.get((CharSequence)"anyOf", String[].class)).isPresent() && ((String[])anyOf.get()).length > 0) {
                String[] names = (String[])anyOf.get();
                List<Schema> schemaList = this.namesToSchemas(openAPI, context, names, mediaTypes);
                for (Schema s : schemaList) {
                    composedSchema.addAnyOfItem(s);
                }
            }
            if ((oneof = schemaValue.get((CharSequence)"oneOf", String[].class)).isPresent() && ((String[])oneof.get()).length > 0) {
                String[] names = (String[])oneof.get();
                List<Schema> list = this.namesToSchemas(openAPI, context, names, mediaTypes);
                for (Schema s : list) {
                    composedSchema.addOneOfItem(s);
                }
            }
            schema.setType("object");
        }
        if (type instanceof EnumElement) {
            schema.setType("string");
            schema.setEnum(((EnumElement)type).values());
        } else if (schema instanceof ObjectSchema || composedSchema != null) {
            this.populateSchemaProperties(openAPI, context, type, schema, mediaTypes);
            this.checkAllOf(composedSchema);
        }
        return schema;
    }

    private List<Schema> namesToSchemas(OpenAPI openAPI, VisitorContext context, String[] names, List<MediaType> mediaTypes) {
        return Arrays.stream(names).flatMap(className -> {
            Schema schemaDefinition;
            Optional classElement = context.getClassElement(className);
            if (classElement.isPresent() && (schemaDefinition = this.getSchemaDefinition(openAPI, context, (ClassElement)classElement.get(), null, mediaTypes)) != null) {
                return Stream.of(schemaDefinition);
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private String schemaRef(String schemaName) {
        return "#/components/schemas/" + schemaName;
    }

    private String computeDefaultSchemaName(Element definingElement, Element type) {
        String metaAnnName;
        String string = metaAnnName = definingElement == null ? null : (String)definingElement.getAnnotationNameByStereotype(io.swagger.v3.oas.annotations.media.Schema.class).orElse(null);
        if (metaAnnName != null && !io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(metaAnnName)) {
            return NameUtils.getSimpleName((String)metaAnnName);
        }
        String javaName = type instanceof TypedElement ? this.computeNameWithGenerics(((TypedElement)type).getType()) : type.getSimpleName();
        return javaName.replace("$", ".");
    }

    private String computeNameWithGenerics(ClassElement classElement) {
        StringBuilder builder = new StringBuilder(classElement.getSimpleName());
        this.computeNameWithGenerics(classElement, builder, new HashSet<String>());
        return builder.toString();
    }

    private void computeNameWithGenerics(ClassElement classElement, StringBuilder builder, Set<String> computed) {
        computed.add(classElement.getName());
        Map typeArguments = classElement.getTypeArguments();
        Iterator i = typeArguments.values().iterator();
        if (i.hasNext()) {
            builder.append('_');
            while (i.hasNext()) {
                ClassElement ce = (ClassElement)i.next();
                builder.append(ce.getSimpleName());
                if (!computed.contains(ce.getName())) {
                    this.computeNameWithGenerics(ce, builder, computed);
                }
                if (!i.hasNext()) continue;
                builder.append('.');
            }
            builder.append('_');
        }
    }

    static boolean isJavaElement(ClassElement classElement, VisitorContext context) {
        return classElement != null && "io.micronaut.annotation.processing.visitor.JavaClassElement".equals(classElement.getClass().getName()) && "io.micronaut.annotation.processing.visitor.JavaVisitorContext".equals(context.getClass().getName());
    }

    private void populateSchemaProperties(OpenAPI openAPI, VisitorContext context, Element type, Schema schema, List<MediaType> mediaTypes) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            classElement = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            classElement = ((TypedElement)type).getType();
        }
        if (classElement != null) {
            List beanProperties;
            try {
                beanProperties = classElement.getBeanProperties().stream().filter(p -> !"groovy.lang.MetaClass".equals(p.getType().getName())).collect(Collectors.toList());
            }
            catch (Exception e) {
                beanProperties = Collections.emptyList();
            }
            this.processPropertyElements(openAPI, context, type, schema, beanProperties, mediaTypes);
            List publicFields = classElement.getEnclosedElements(ElementQuery.ALL_FIELDS.modifiers(mods -> mods.contains(ElementModifier.PUBLIC) && mods.size() == 1));
            this.processPropertyElements(openAPI, context, type, schema, publicFields, mediaTypes);
        }
    }

    private void processPropertyElements(OpenAPI openAPI, VisitorContext context, Element type, Schema schema, List<? extends TypedElement> publicFields, List<MediaType> mediaTypes) {
        for (TypedElement typedElement : publicFields) {
            if (typedElement.isAnnotationPresent(JsonIgnore.class) || typedElement.isAnnotationPresent(Hidden.class) || !(typedElement instanceof MemberElement) || !((MemberElement)typedElement).getDeclaringType().getType().getName().equals(type.getName().toString())) continue;
            Schema propertySchema = this.resolveSchema(openAPI, (Element)typedElement, typedElement.getType(), context, mediaTypes);
            this.processSchemaProperty(context, (Element)typedElement, typedElement.getType(), type, schema, propertySchema);
        }
    }

    private Map<String, Schema> resolveSchemas(OpenAPI openAPI) {
        Components components = this.resolveComponents(openAPI);
        LinkedHashMap schemas = components.getSchemas();
        if (schemas == null) {
            schemas = new LinkedHashMap();
            components.setSchemas(schemas);
        }
        return schemas;
    }

    private ArraySchema arraySchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(schema);
        return arraySchema;
    }

    private Schema getPrimitiveType(String typeName) {
        Class concreteType;
        Class wrapperType;
        PrimitiveType primitiveType;
        Schema schema = null;
        Optional aClass = ClassUtils.getPrimitiveType((String)typeName);
        if (!aClass.isPresent()) {
            aClass = ClassUtils.forName((String)typeName, (ClassLoader)this.getClass().getClassLoader());
        }
        if (aClass.isPresent() && (primitiveType = PrimitiveType.fromType((Type)(wrapperType = ReflectionUtils.getWrapperType((Class)(concreteType = (Class)aClass.get()))))) != null) {
            schema = primitiveType.createProperty();
        }
        return schema;
    }

    private boolean isContainerType(ClassElement type) {
        return CollectionUtils.setOf((Object[])new String[]{Optional.class.getName(), Future.class.getName(), Publisher.class.getName(), "io.reactivex.Single", "io.reactivex.Observable", "io.reactivex.Maybe", "io.reactivex.rxjava3.core.Single", "io.reactivex.rxjava3.core.Observable", "io.reactivex.rxjava3.core.Maybe"}).stream().anyMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0));
    }

    private boolean isReturnTypeFile(ClassElement type) {
        return CollectionUtils.setOf((Object[])new String[]{FileCustomizableResponseType.class.getName(), File.class.getName(), InputStream.class.getName(), ByteBuffer.class.getName()}).stream().anyMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0));
    }

    protected void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(SecurityScheme.class);
        OpenAPI openAPI = this.resolveOpenAPI(context);
        for (AnnotationValue securityRequirementAnnotationValue : values) {
            Optional n = securityRequirementAnnotationValue.get((CharSequence)"name", String.class);
            n.ifPresent(name -> {
                Map<CharSequence, Object> map = this.toValueMap(securityRequirementAnnotationValue.getValues(), context);
                if (map.containsKey("paramName")) {
                    map.put("name", map.remove("paramName"));
                } else {
                    map.putIfAbsent("name", name);
                }
                this.normalizeEnumValues(map, CollectionUtils.mapOf((Object[])new Object[]{"type", SecurityScheme.Type.class, "in", SecurityScheme.In.class}));
                Optional<io.swagger.v3.oas.models.security.SecurityScheme> securityRequirement = this.toValue(map, context, io.swagger.v3.oas.models.security.SecurityScheme.class);
                securityRequirement.ifPresent(securityScheme -> {
                    try {
                        securityScheme.setIn(Enum.valueOf(SecurityScheme.In.class, map.get("in").toString().toUpperCase(Locale.ENGLISH)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.resolveComponents(openAPI).addSecuritySchemes(name, securityScheme);
                });
            });
        }
    }

    protected void normalizeEnumValues(Map<CharSequence, Object> paramValues, Map<String, Class<? extends Enum>> enumTypes) {
        for (Map.Entry<String, Class<? extends Enum>> entry : enumTypes.entrySet()) {
            String name = entry.getKey();
            Class<? extends Enum> enumType = entry.getValue();
            Object in = paramValues.get(name);
            if (in == null) continue;
            try {
                Enum enumInstance = Enum.valueOf(enumType, in.toString());
                paramValues.put(name, enumInstance.toString());
            }
            catch (Exception exception) {}
        }
    }

    protected SecurityRequirement mapToSecurityRequirement(AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> r) {
        String name = (String)r.getRequiredValue("name", String.class);
        List scopes = r.get((CharSequence)"scopes", String[].class).map(Arrays::asList).orElse(Collections.emptyList());
        SecurityRequirement securityRequirement = new SecurityRequirement();
        securityRequirement.addList(name, scopes);
        return securityRequirement;
    }

    <T, A extends Annotation> List<T> processOpenApiAnnotation(Element element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                Map values;
                if (tag.getAnnotationName().equals(SecurityRequirement.class.getName()) && tag.getValues().size() > 0) {
                    Object name = tag.getValues().get("name");
                    ArrayList scopes = Optional.ofNullable(tag.getValues().get("scopes")).orElse(new ArrayList());
                    values = Collections.singletonMap((CharSequence)name, scopes);
                } else {
                    values = tag.getValues();
                }
                this.toValue(values, context, modelType).ifPresent(tagList::add);
            }
        }
        return tagList;
    }

    boolean isTestMode() {
        return Boolean.getBoolean(ATTR_TEST_MODE);
    }

    static {
        VISITED_ELEMENTS_LOCK = new ReentrantLock();
        EMPTY_SCHEMA = new Schema();
    }
}

