/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.javadoc;

import com.github.chhorz.javadoc.JavaDoc;
import com.github.chhorz.javadoc.JavaDocParser;
import com.github.chhorz.javadoc.JavaDocParserBuilder;
import com.github.chhorz.javadoc.OutputType;
import com.github.chhorz.javadoc.tags.ParamTag;
import com.github.chhorz.javadoc.tags.ReturnTag;
import com.github.chhorz.javadoc.tags.Tag;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.openapi.javadoc.JavadocDescription;
import java.util.Collection;
import java.util.Set;

public class JavadocParser {
    private static final Set<String> IGNORED = CollectionUtils.setOf((Object[])new String[]{"see", "since", "author", "version", "deprecated", "throws", "exception", "category"});

    public JavadocDescription parse(String text) {
        if (text == null) {
            return null;
        }
        JavaDocParser javaDocParser = JavaDocParserBuilder.withBasicTags().withOutputType(OutputType.HTML).build();
        FlexmarkHtmlConverter htmlToMarkdownConverter = FlexmarkHtmlConverter.builder().build();
        JavaDoc javaDoc = javaDocParser.parse(text.trim());
        JavadocDescription javadocDescription = new JavadocDescription();
        javadocDescription.setMethodSummary(htmlToMarkdownConverter.convert(javaDoc.getSummary()).trim());
        javadocDescription.setMethodDescription(htmlToMarkdownConverter.convert(javaDoc.getDescription()).trim());
        if (CollectionUtils.isNotEmpty((Collection)javaDoc.getTags())) {
            for (Tag tag : javaDoc.getTags()) {
                if (IGNORED.contains(tag.getTagName())) continue;
                if (tag instanceof ReturnTag) {
                    javadocDescription.setReturnDescription(htmlToMarkdownConverter.convert(((ReturnTag)tag).getDescription()).trim());
                    continue;
                }
                if (!(tag instanceof ParamTag)) continue;
                ParamTag paramTag = (ParamTag)tag;
                String paramDesc = htmlToMarkdownConverter.convert(paramTag.getParamDescription()).trim();
                javadocDescription.getParameters().put(paramTag.getParamName(), paramDesc);
            }
        }
        return javadocDescription;
    }
}

