/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericArgument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.postprocessors.JacksonDiscriminatorPostProcessor;
import io.micronaut.openapi.postprocessors.OpenApiOperationsPostProcessor;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.server.context.path", "micronaut.openapi.property.naming.strategy", "micronaut.openapi.views.spec", "micronaut.openapi.json.format", "micronaut.openapi.environments", "micronaut.openapi.target.file", "micronaut.openapi.additional.files", "micronaut.openapi.config.file"})
public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_CONFIG_FILE = "micronaut.openapi.config.file";
    public static final String MICRONAUT_OPENAPI_EXPAND_PREFIX = "micronaut.openapi.expand.";
    public static final String MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH = "micronaut.openapi.server.context.path";
    public static final String MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY = "micronaut.openapi.property.naming.strategy";
    public static final String MICRONAUT_OPENAPI_VIEWS_SPEC = "micronaut.openapi.views.spec";
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    public static final String MICRONAUT_OPENAPI_ADDITIONAL_FILES = "micronaut.openapi.additional.files";
    public static final String OPENAPI_CONFIG_FILE = "openapi.properties";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_CLASS_TAGS = "micronaut.openapi.endpoint.class.tags";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_SERVERS = "micronaut.openapi.endpoint.servers";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_SECURITY_REQUIREMENTS = "micronaut.openapi.endpoint.security.requirements";
    public static final String MICRONAUT_OPENAPI_JSON_FORMAT = "micronaut.openapi.json.format";
    public static final String MICRONAUT_OPENAPI_ENVIRONMENTS = "micronaut.openapi.environments";
    private static final String MICRONAUT_OPENAPI_PROPERTIES = "micronaut.openapi.properties";
    private static final String MICRONAUT_OPENAPI_ENDPOINTS = "micronaut.openapi.endpoints";
    private static final String MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES = "micronaut.internal.expandable.props";
    private static final String MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED = "micronaut.internal.expandable.props.loaded";
    private static final Argument<List<Map.Entry<String, String>>> EXPANDABLE_PROPERTIES_ARGUMENT = new GenericArgument<List<Map.Entry<String, String>>>(){};
    private ClassElement classElement;
    private int visitedElements = -1;

    public void visitClass(ClassElement element, VisitorContext context) {
        this.incrementVisitedElements(context);
        context.info("Generating OpenAPI Documentation");
        OpenAPI openAPI = this.readOpenAPI(element, context);
        this.mergeAdditionalSwaggerFiles(element, context, openAPI);
        List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openAPI.getTags());
        openAPI.setTags(tagList);
        List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
        if (openAPI.getSecurity() != null) {
            securityRequirements.addAll(openAPI.getSecurity());
        }
        openAPI.setSecurity(securityRequirements);
        List<io.swagger.v3.oas.models.servers.Server> servers = this.processOpenApiAnnotation((Element)element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, openAPI.getServers());
        openAPI.setServers(servers);
        this.processSecuritySchemes(element, context);
        Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        if (attr.isPresent()) {
            OpenAPI existing = (OpenAPI)attr.get();
            Optional.ofNullable(openAPI.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
            this.copyOpenAPI(existing, openAPI);
        } else {
            context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openAPI);
        }
        if (Utils.isTestMode()) {
            Utils.resolveOpenAPI(context);
        }
        this.classElement = element;
    }

    private String getConfigurationProperty(String key, VisitorContext context) {
        return System.getProperty(key, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(key));
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = this.getConfigurationProperty(MICRONAUT_OPENAPI_ADDITIONAL_FILES, context);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles)) {
            Path directory = OpenApiApplicationVisitor.resolve(context, java.nio.file.Paths.get(additionalSwaggerFiles, new String[0]));
            if (Files.isDirectory(directory, new LinkOption[0])) {
                context.info("Merging Swagger OpenAPI YAML and JSON files from location: " + directory);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, path -> path.toString().endsWith(".yml") || path.toString().endsWith(".json"));){
                    stream.forEach(path -> {
                        boolean isYaml = path.toString().endsWith(".yml");
                        context.info("Reading Swagger OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + path.getFileName());
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)(isYaml ? ConvertUtils.getYamlMapper() : ConvertUtils.getJsonMapper()).readValue(path.toFile(), OpenAPI.class);
                        }
                        catch (IOException e) {
                            context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)element);
                        }
                        this.copyOpenAPI(openAPI, parsedOpenApi);
                    });
                }
                catch (IOException e) {
                    context.warn("Unable to read  file from " + directory + ": " + e.getMessage(), (Element)element);
                }
            } else {
                context.warn(directory + " does not exist or is not a directory", (Element)element);
            }
        }
    }

    private static Path resolve(VisitorContext context, Path path) {
        Optional projectDir;
        if (!path.isAbsolute() && (projectDir = context.getProjectDir()).isPresent()) {
            path = ((Path)projectDir.get()).resolve(path);
        }
        return path.toAbsolutePath();
    }

    static EndpointsConfiguration endPointsConfiguration(VisitorContext context) {
        Optional cfg = context.get((CharSequence)MICRONAUT_OPENAPI_ENDPOINTS, EndpointsConfiguration.class);
        if (cfg.isPresent()) {
            return (EndpointsConfiguration)cfg.get();
        }
        EndpointsConfiguration conf = new EndpointsConfiguration(context, OpenApiApplicationVisitor.readOpenApiConfigFile(context));
        context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINTS, (Object)conf);
        return conf;
    }

    public static Properties readOpenApiConfigFile(VisitorContext context) {
        Optional props = context.get((CharSequence)MICRONAUT_OPENAPI_PROPERTIES, Properties.class);
        if (props.isPresent()) {
            return (Properties)props.get();
        }
        Properties openApiProperties = new Properties();
        String cfgFile = System.getProperty(MICRONAUT_OPENAPI_CONFIG_FILE, OPENAPI_CONFIG_FILE);
        if (StringUtils.isNotEmpty((CharSequence)cfgFile)) {
            Path cfg = OpenApiApplicationVisitor.resolve(context, java.nio.file.Paths.get(cfgFile, new String[0]));
            if (Files.isReadable(cfg)) {
                try (BufferedReader reader = Files.newBufferedReader(cfg);){
                    openApiProperties.load(reader);
                }
                catch (IOException e) {
                    context.warn("Fail to read OpenAPI configuration file: " + e.getMessage(), null);
                }
            } else if (Files.exists(cfg, new LinkOption[0])) {
                context.warn("Can not read configuration file: " + cfg, null);
            }
        }
        context.put((CharSequence)MICRONAUT_OPENAPI_PROPERTIES, (Object)openApiProperties);
        return openApiProperties;
    }

    private void copyOpenAPI(OpenAPI to, OpenAPI from) {
        if (to != null && from != null) {
            Optional.ofNullable(from.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)to).addTagsItem(arg_0)));
            Optional.ofNullable(from.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)to).addServersItem(arg_0)));
            Optional.ofNullable(from.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)to).addSecurityItem(arg_0)));
            Optional.ofNullable(from.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)to).path(arg_0, arg_1)));
            Optional.ofNullable(from.getComponents()).ifPresent(components -> {
                Map securitySchemes;
                Map schemas = components.getSchemas();
                if (schemas != null && !schemas.isEmpty()) {
                    schemas.forEach((k, v) -> {
                        if (v.getName() == null) {
                            v.setName(k);
                        }
                    });
                    schemas.forEach((arg_0, arg_1) -> ((OpenAPI)to).schema(arg_0, arg_1));
                }
                if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                    securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)to).schemaRequirement(arg_0, arg_1));
                }
            });
            Optional.ofNullable(from.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)to).externalDocs(arg_0));
            Optional.ofNullable(from.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)to).addExtension(arg_0, arg_1)));
        }
    }

    private OpenAPI readOpenAPI(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            Optional<OpenAPI> result = this.toValue(o.getValues(), context, OpenAPI.class);
            result.ifPresent(openAPI -> {
                List securityRequirements = o.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class).stream().map(ConvertUtils::mapToSecurityRequirement).collect(Collectors.toList());
                openAPI.setSecurity(securityRequirements);
            });
            return result;
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, String specFile, Path destinationDir, VisitorContext visitorContext) throws IOException {
        String viewSpecification = System.getProperty(MICRONAUT_OPENAPI_VIEWS_SPEC);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, OpenApiApplicationVisitor.readOpenApiConfigFile(visitorContext));
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            cfg.setSpecFile(specFile);
            cfg.setServerContextPath(this.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH, visitorContext));
            cfg.render(destinationDir.resolve("views"), visitorContext);
        }
    }

    private static PropertyNamingStrategies.NamingBase fromName(String name) {
        if (name == null) {
            return null;
        }
        switch (name.toUpperCase(Locale.US)) {
            case "LOWER_CAMEL_CASE": {
                return new LowerCamelCasePropertyNamingStrategy();
            }
            case "UPPER_CAMEL_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_CAMEL_CASE;
            }
            case "SNAKE_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.SNAKE_CASE;
            }
            case "UPPER_SNAKE_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_SNAKE_CASE;
            }
            case "LOWER_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CASE;
            }
            case "KEBAB_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.KEBAB_CASE;
            }
            case "LOWER_DOT_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_DOT_CASE;
            }
        }
        return null;
    }

    private Optional<Path> openApiSpecFile(String fileName, VisitorContext visitorContext) {
        URI uri;
        Optional<Path> path = this.userDefinedSpecFile(visitorContext);
        if (path.isPresent()) {
            return path;
        }
        Optional generatedFile = visitorContext.visitMetaInfFile("swagger/" + fileName, Element.EMPTY_ELEMENT_ARRAY);
        if (generatedFile.isPresent() && (uri = ((GeneratedFile)generatedFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path specPath = java.nio.file.Paths.get(uri);
            OpenApiApplicationVisitor.createDirectories(specPath, visitorContext);
            return Optional.of(specPath);
        }
        visitorContext.warn("Unable to get swagger/" + fileName + " file.", null);
        return Optional.empty();
    }

    private Optional<Path> userDefinedSpecFile(VisitorContext visitorContext) {
        String targetFile = this.getConfigurationProperty(MICRONAUT_OPENAPI_TARGET_FILE, visitorContext);
        if (StringUtils.isEmpty((CharSequence)targetFile)) {
            return Optional.empty();
        }
        Path specFile = OpenApiApplicationVisitor.resolve(visitorContext, java.nio.file.Paths.get(targetFile, new String[0]));
        OpenApiApplicationVisitor.createDirectories(specFile, visitorContext);
        return Optional.of(specFile);
    }

    private static void createDirectories(Path f, VisitorContext visitorContext) {
        if (f.getParent() != null) {
            try {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                visitorContext.warn("Fail to create directories for" + f + ": " + e.getMessage(), null);
            }
        }
    }

    private void applyPropertyNamingStrategy(OpenAPI openAPI, VisitorContext visitorContext) {
        String namingStrategyName = this.getConfigurationProperty(MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY, visitorContext);
        PropertyNamingStrategies.NamingBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
        if (propertyNamingStrategy != null) {
            visitorContext.info("Using " + namingStrategyName + " property naming strategy.");
            if (openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)openAPI.getComponents().getSchemas())) {
                openAPI.getComponents().getSchemas().values().forEach(model -> {
                    List required;
                    Map properties = model.getProperties();
                    if (properties != null) {
                        Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                        model.getProperties().clear();
                        model.setProperties(newProperties);
                    }
                    if ((required = model.getRequired()) != null) {
                        List updatedRequired = required.stream().map(arg_0 -> ((PropertyNamingStrategies.NamingBase)propertyNamingStrategy).translate(arg_0)).collect(Collectors.toList());
                        required.clear();
                        required.addAll(updatedRequired);
                    }
                });
            }
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openAPI, VisitorContext visitorContext) {
        String serverContextPath = this.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH, visitorContext);
        if (serverContextPath == null || serverContextPath.isEmpty()) {
            return;
        }
        visitorContext.info("Applying server context path: " + serverContextPath + " to Paths.");
        Paths paths = openAPI.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Paths newPaths = new Paths();
        for (Map.Entry path : paths.entrySet()) {
            String mapping = (String)path.getKey();
            newPaths.addPathItem(mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping), (PathItem)path.getValue());
        }
        openAPI.setPaths(newPaths);
    }

    public static JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, OpenApiApplicationVisitor.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    public static JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.isEmpty()) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), OpenApiApplicationVisitor.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    public static JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.trim().isEmpty()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    public static String expandProperties(String s, List<Map.Entry<String, String>> properties) {
        if (StringUtils.isEmpty((CharSequence)s) || CollectionUtils.isEmpty(properties)) {
            return s;
        }
        for (Map.Entry<String, String> entry : properties) {
            s = s.replace(entry.getKey(), entry.getValue());
        }
        return s;
    }

    public static List<Map.Entry<String, String>> getExpandableProperties(VisitorContext context) {
        List expandableProperties;
        Optional propertiesLoaded = context.get((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED, Boolean.class);
        if (!propertiesLoaded.orElse(false).booleanValue()) {
            expandableProperties = OpenApiApplicationVisitor.readOpenApiConfigFile(context).entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>("${" + entry.getKey().toString().substring(MICRONAUT_OPENAPI_EXPAND_PREFIX.length()) + '}', entry.getValue().toString())).collect(Collectors.toList());
            context.put((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES, expandableProperties);
            context.put((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED, (Object)true);
        } else {
            expandableProperties = context.get((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES, EXPANDABLE_PROPERTIES_ARGUMENT).orElse(null);
        }
        return expandableProperties;
    }

    private static OpenAPI resolvePropertyPlaceHolders(OpenAPI openAPI, VisitorContext visitorContext) {
        List<Map.Entry<String, String>> expandableProperties = OpenApiApplicationVisitor.getExpandableProperties(visitorContext);
        if (CollectionUtils.isEmpty(expandableProperties)) {
            return openAPI;
        }
        visitorContext.info("Expanding properties: " + expandableProperties);
        JsonNode root = OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)Yaml.mapper().convertValue((Object)openAPI, ObjectNode.class), s -> OpenApiApplicationVisitor.expandProperties(s, expandableProperties));
        return (OpenAPI)Yaml.mapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext visitorContext) {
        String isJson;
        if (this.visitedElements == this.visitedElements(visitorContext)) {
            return;
        }
        Optional attr = visitorContext.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        if (!attr.isPresent()) {
            return;
        }
        OpenAPI openAPI = (OpenAPI)attr.get();
        this.processEndpoints(visitorContext);
        this.applyPropertyNamingStrategy(openAPI, visitorContext);
        this.applyPropertyServerContextPath(openAPI, visitorContext);
        openAPI = OpenApiApplicationVisitor.resolvePropertyPlaceHolders(openAPI, visitorContext);
        this.sortOpenAPI(openAPI);
        new JacksonDiscriminatorPostProcessor().addMissingDiscriminatorType(openAPI);
        new OpenApiOperationsPostProcessor().processOperations(openAPI);
        if (Utils.isTestMode()) {
            Utils.setTestReferenceAfterPlaceholders(openAPI);
        }
        boolean isYaml = !StringUtils.isNotEmpty((CharSequence)(isJson = this.getConfigurationProperty(MICRONAUT_OPENAPI_JSON_FORMAT, visitorContext))) || !isJson.equals("true");
        String ext = isYaml ? ".yml" : ".json";
        String fileName = "swagger" + ext;
        String documentTitle = "OpenAPI";
        Info info = openAPI.getInfo();
        if (info != null) {
            documentTitle = Optional.ofNullable(info.getTitle()).orElse("application");
            documentTitle = documentTitle.toLowerCase(Locale.US).replace(' ', '-');
            String version = info.getVersion();
            if (version != null) {
                documentTitle = documentTitle + '-' + version;
            }
            fileName = documentTitle + ext;
        }
        this.writeYamlToFile(openAPI, fileName, documentTitle, visitorContext, isYaml);
        this.visitedElements = this.visitedElements(visitorContext);
    }

    private void sortOpenAPI(OpenAPI openAPI) {
        if (openAPI.getPaths() != null) {
            Paths sortedPaths = new Paths();
            new TreeMap<String, PathItem>((Map<String, PathItem>)openAPI.getPaths()).forEach((arg_0, arg_1) -> ((Paths)sortedPaths).addPathItem(arg_0, arg_1));
            if (openAPI.getPaths().getExtensions() != null) {
                sortedPaths.setExtensions(new TreeMap(openAPI.getPaths().getExtensions()));
            }
            openAPI.setPaths(sortedPaths);
        }
        Components components = openAPI.getComponents();
        this.sortComponent(components, Components::getSchemas, Components::setSchemas);
        this.sortComponent(components, Components::getResponses, Components::setResponses);
        this.sortComponent(components, Components::getParameters, Components::setParameters);
        this.sortComponent(components, Components::getExamples, Components::setExamples);
        this.sortComponent(components, Components::getRequestBodies, Components::setRequestBodies);
        this.sortComponent(components, Components::getHeaders, Components::setHeaders);
        this.sortComponent(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
        this.sortComponent(components, Components::getLinks, Components::setLinks);
        this.sortComponent(components, Components::getCallbacks, Components::setCallbacks);
    }

    private <T> void sortComponent(Components components, Function<Components, Map<String, T>> getter, BiConsumer<Components, Map<String, T>> setter) {
        if (components != null && getter.apply(components) != null) {
            Map<String, T> component = getter.apply(components);
            setter.accept(components, new TreeMap<String, T>(component));
        }
    }

    private void writeYamlToFile(OpenAPI openAPI, String fileName, String documentTitle, VisitorContext visitorContext, boolean isYaml) {
        Optional<Path> specFile = this.openApiSpecFile(fileName, visitorContext);
        try (Writer writer = this.getFileWriter(specFile);){
            (isYaml ? ConvertUtils.getYamlMapper() : ConvertUtils.getJsonMapper()).writeValue(writer, (Object)openAPI);
            if (Utils.isTestMode()) {
                if (isYaml) {
                    Utils.setTestYamlReference(writer.toString());
                } else {
                    Utils.setTestJsonReference(writer.toString());
                }
            } else {
                Path specPath = specFile.get();
                visitorContext.info("Writing OpenAPI file to destination: " + specPath);
                visitorContext.getClassesOutputPath().ifPresent(path -> {
                    visitorContext.addGeneratedResource(path.relativize(specPath).toString());
                    visitorContext.addGeneratedResource(path.relativize(specPath.getParent()).toString());
                });
                this.renderViews(documentTitle, specPath.getFileName().toString(), specPath.getParent(), visitorContext);
            }
        }
        catch (Exception e) {
            visitorContext.warn("Unable to generate swagger." + (isYaml ? "yml" : "json") + ": " + specFile.orElse(null) + " - " + e.getMessage(), (Element)this.classElement);
        }
    }

    private Writer getFileWriter(Optional<Path> specFile) throws IOException {
        if (Utils.isTestMode()) {
            return new StringWriter();
        }
        if (specFile.isPresent()) {
            return Files.newBufferedWriter(specFile.get(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        throw new IOException("Swagger spec file location is not present");
    }

    private void processEndpoints(VisitorContext visitorContext) {
        EndpointsConfiguration endpointsCfg = OpenApiApplicationVisitor.endPointsConfiguration(visitorContext);
        if ("io.micronaut.annotation.processing.visitor.JavaVisitorContext".equals(visitorContext.getClass().getName()) && endpointsCfg.isEnabled() && !endpointsCfg.getEndpoints().isEmpty()) {
            OpenApiEndpointVisitor visitor = new OpenApiEndpointVisitor(true);
            endpointsCfg.getEndpoints().values().stream().filter(endpoint -> endpoint.getClassElement().isPresent()).forEach(endpoint -> {
                ClassElement element = endpoint.getClassElement().get();
                visitorContext.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_CLASS_TAGS, endpoint.getTags());
                visitorContext.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_SERVERS, endpoint.getServers());
                visitorContext.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_SECURITY_REQUIREMENTS, endpoint.getSecurityRequirements());
                visitor.visitClass(element, visitorContext);
                element.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$"))).forEach(method -> visitor.visitMethod((MethodElement)method, visitorContext));
            });
        }
    }

    static class LowerCamelCasePropertyNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private static final long serialVersionUID = -2750503285679998670L;

        LowerCamelCasePropertyNamingStrategy() {
        }

        public String translate(String propertyName) {
            return propertyName;
        }
    }
}

