/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.AbstractOpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenApiControllerVisitor
extends AbstractOpenApiEndpointVisitor
implements TypeElementVisitor<Object, HttpMethodMapping> {
    private final String customUri;
    private final List<AnnotationValue<Tag>> additionalTags;
    private final List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements;

    public OpenApiControllerVisitor() {
        this.additionalTags = Collections.emptyList();
        this.additionalSecurityRequirements = Collections.emptyList();
        this.customUri = null;
    }

    public OpenApiControllerVisitor(List<AnnotationValue<Tag>> additionalTags, List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements, String customUri) {
        this.additionalTags = additionalTags;
        this.additionalSecurityRequirements = additionalSecurityRequirements;
        this.customUri = customUri;
    }

    private List<String> getActiveEnvironments(VisitorContext context) {
        Optional activeEnvsOpt = context.get((CharSequence)"micronaut.openapi.environments", Argument.LIST_OF_STRING);
        if (activeEnvsOpt.isPresent()) {
            return (List)activeEnvsOpt.get();
        }
        String activeEnv = this.getConfigurationProperty("micronaut.openapi.environments", context);
        List<String> activeEnvs = StringUtils.isNotEmpty((CharSequence)activeEnv) ? Stream.of(activeEnv).filter(StringUtils::isNotEmpty).flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).collect(Collectors.toList()) : new ArrayList<String>();
        context.put((CharSequence)"micronaut.openapi.environments", activeEnvs);
        return activeEnvs;
    }

    private boolean ignoreByRequires(Element element, VisitorContext context) {
        List requiresAnnotations = element.getDeclaredAnnotationValuesByType(Requires.class);
        if (CollectionUtils.isEmpty((Collection)requiresAnnotations)) {
            return false;
        }
        List<String> activeEnvs = this.getActiveEnvironments(context);
        if (activeEnvs.isEmpty()) {
            return false;
        }
        for (AnnotationValue requiresAnn : requiresAnnotations) {
            Optional reqNotEnvs;
            Optional reqEnvs = requiresAnn.get((CharSequence)"env", String[].class);
            if (reqEnvs.isPresent()) {
                boolean result = Arrays.stream((String[])reqEnvs.get()).anyMatch(activeEnvs::contains);
                if (!result) {
                    return true;
                }
            }
            if (!(reqNotEnvs = requiresAnn.get((CharSequence)"notEnv", String[].class)).isPresent()) continue;
            boolean result = Arrays.stream((String[])reqNotEnvs.get()).noneMatch(activeEnvs::contains);
            if (result) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean ignore(ClassElement element, VisitorContext context) {
        return !element.isAnnotationPresent(Controller.class) || this.ignoreByRequires((Element)element, context);
    }

    @Override
    protected boolean ignore(MethodElement element, VisitorContext context) {
        AnnotationValue operationAnn = element.getAnnotation(Operation.class);
        boolean isHidden = operationAnn != null && operationAnn.get((CharSequence)"hidden", Boolean.class).orElse(false) != false;
        return isHidden || this.ignore(element.getDeclaringType(), context) || element.isPrivate() || element.isStatic() || element.isAnnotationPresent(Hidden.class) || this.ignoreByRequires((Element)element, context);
    }

    private String getConfigurationProperty(String key, VisitorContext context) {
        return System.getProperty(key, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(key));
    }

    @Override
    protected HttpMethod httpMethod(MethodElement element) {
        Optional httpMethodOpt = element.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        if (!httpMethodOpt.isPresent()) {
            return null;
        }
        try {
            return HttpMethod.valueOf((String)((Class)httpMethodOpt.get()).getSimpleName().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    protected List<MediaType> consumesMediaTypes(MethodElement element) {
        return this.mediaTypes(element, Consumes.class);
    }

    @Override
    protected List<MediaType> producesMediaTypes(MethodElement element) {
        return this.mediaTypes(element, Produces.class);
    }

    private List<MediaType> mediaTypes(MethodElement element, Class<? extends Annotation> ann) {
        String[] values = element.stringValues(ann);
        if (values.length == 0) {
            return Utils.DEFAULT_MEDIA_TYPES;
        }
        return Arrays.stream(values).map(MediaType::of).distinct().collect(Collectors.toList());
    }

    @Override
    protected List<UriMatchTemplate> uriMatchTemplates(MethodElement element) {
        String controllerValue = element.getOwningType().getValue(UriMapping.class, String.class).orElse(element.getDeclaringType().getValue(UriMapping.class, String.class).orElse("/"));
        if (StringUtils.isNotEmpty((CharSequence)this.customUri)) {
            controllerValue = this.customUri;
        }
        controllerValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(controllerValue).orElse(controllerValue);
        UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)controllerValue);
        String[] uris = element.stringValues(HttpMethodMapping.class, "uris");
        if (uris.length == 0) {
            String methodValue = element.getValue(HttpMethodMapping.class, String.class).orElse("/");
            methodValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(methodValue).orElse(methodValue);
            return Collections.singletonList(matchTemplate.nest((CharSequence)methodValue));
        }
        ArrayList<UriMatchTemplate> matchTemplates = new ArrayList<UriMatchTemplate>(uris.length);
        for (String methodValue : uris) {
            methodValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(methodValue).orElse(methodValue);
            matchTemplates.add(matchTemplate.nest((CharSequence)methodValue));
        }
        return matchTemplates;
    }

    @Override
    protected String description(MethodElement element) {
        return null;
    }

    @Override
    protected List<io.swagger.v3.oas.models.tags.Tag> classTags(ClassElement element, VisitorContext context) {
        return this.readTags(this.additionalTags, context);
    }

    @Override
    protected List<Server> methodServers(MethodElement element, VisitorContext context) {
        return this.processOpenApiAnnotation((Element)element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, Collections.emptyList());
    }

    @Override
    protected List<SecurityRequirement> methodSecurityRequirements(MethodElement element, VisitorContext context) {
        List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
        if (!this.additionalSecurityRequirements.isEmpty()) {
            securityRequirements = new ArrayList<SecurityRequirement>(securityRequirements);
            securityRequirements.addAll(this.readSecurityRequirements(this.additionalSecurityRequirements));
        }
        return securityRequirements;
    }
}

