/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractViewConfig {
    protected String prefix;
    protected String jsUrl = "";
    protected boolean isDefaultJsUrl = true;
    protected Map<String, Object> options = new HashMap<String, Object>();

    protected AbstractViewConfig(String prefix) {
        this.prefix = prefix;
    }

    protected abstract Function<String, Object> getConverter(String var1);

    protected abstract List<String> getResources();

    protected void addAttribute(Map.Entry<String, String> entry) {
        String key = entry.getKey().substring(this.prefix.length());
        Function<String, Object> converter = this.getConverter(key);
        if (converter != null) {
            this.options.put(key, converter.apply(entry.getValue()));
        }
    }

    protected String toHtmlAttributes() {
        return this.options.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + e.getValue() + '\"').collect(Collectors.joining(" "));
    }

    static <T extends AbstractViewConfig> T fromProperties(T cfg, Map<String, Object> defaultOptions, Map<String, String> properties) {
        String jsUrl = properties.get(cfg.prefix + "js.url");
        if (StringUtils.isNotEmpty((CharSequence)jsUrl)) {
            cfg.jsUrl = jsUrl;
            cfg.isDefaultJsUrl = false;
        }
        cfg.options.putAll(defaultOptions);
        properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(cfg.prefix)).forEach(cfg::addAttribute);
        return cfg;
    }

    static Object asBoolean(String v) {
        return Boolean.valueOf(v);
    }

    static Object asInt(String v) {
        return Integer.valueOf(v);
    }

    static Object asString(String v) {
        return v;
    }

    static Object asQuotedString(String v) {
        return v == null ? null : '\"' + v + '\"';
    }

    static class EnumConverter<T extends Enum<T>>
    implements Function<String, Object> {
        private final Class<T> type;

        EnumConverter(Class<T> type) {
            this.type = type;
        }

        @Override
        public Object apply(String v) {
            return v == null ? null : Enum.valueOf(this.type, v.toUpperCase(Locale.US));
        }
    }
}

