/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.reactivestreams.Publisher;

abstract class AbstractOpenApiVisitor {
    private static final Lock VISITED_ELEMENTS_LOCK = new ReentrantLock();
    private static final Schema<?> EMPTY_SCHEMA = new Schema();
    private static final ComposedSchema EMPTY_COMPOSED_SCHEMA = new ComposedSchema();
    private List<String> inProgressSchemas = new ArrayList<String>(10);
    private Map<String, PropertyNamingStrategy> propertyNamingStrategyInstances = new HashMap<String, PropertyNamingStrategy>();

    AbstractOpenApiVisitor() {
    }

    void incrementVisitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            context.put((CharSequence)"io.micronaut.OPENAPI.visited.elements", (Object)(ContextUtils.getVisitedElements(context) + 1));
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    int visitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            int n = ContextUtils.getVisitedElements(context);
            return n;
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context) {
        Map<CharSequence, Object> newValues = this.toValueMap(values, context);
        return ConvertUtils.getJsonMapper().valueToTree(newValues);
    }

    <T> Optional<T> toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type) {
        JsonNode node = this.toJson(values, context);
        try {
            return Optional.ofNullable(ConvertUtils.treeToValue(node, type));
        }
        catch (JsonProcessingException e) {
            context.warn("Error converting  [" + node + "]: to " + type + ": " + e.getMessage(), null);
            return Optional.empty();
        }
    }

    List<SecurityRequirement> readSecurityRequirements(Element element) {
        return this.readSecurityRequirements(element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class));
    }

    List<SecurityRequirement> readSecurityRequirements(List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> annotations) {
        return annotations.stream().map(ConvertUtils::mapToSecurityRequirement).collect(Collectors.toList());
    }

    List<PathItem> resolvePathItems(VisitorContext context, List<UriMatchTemplate> matchTemplates) {
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            openAPI.setPaths(paths);
        }
        ArrayList<PathItem> resultPaths = new ArrayList<PathItem>();
        for (UriMatchTemplate matchTemplate : matchTemplates) {
            StringBuilder result = new StringBuilder();
            boolean varProcess = false;
            boolean valueProcess = false;
            boolean isFirstVarChar = true;
            boolean needToSkip = false;
            String pathString = matchTemplate.toPathString();
            for (char c : pathString.toCharArray()) {
                if (varProcess) {
                    if (isFirstVarChar) {
                        isFirstVarChar = false;
                        if (c == '?' || c == '.') {
                            needToSkip = true;
                            result.deleteCharAt(result.length() - 1);
                            continue;
                        }
                        if (c == '+' || c == '0') continue;
                        if (c == '/') {
                            result.deleteCharAt(result.length() - 1).append(c).append('{');
                            continue;
                        }
                    }
                    if (c == ':') {
                        valueProcess = true;
                        continue;
                    }
                    if (c == '}') {
                        varProcess = false;
                        valueProcess = false;
                        if (!needToSkip) {
                            result.append('}');
                        }
                        needToSkip = false;
                        continue;
                    }
                    if (valueProcess || needToSkip) continue;
                }
                if (c == '{') {
                    varProcess = true;
                    isFirstVarChar = true;
                }
                result.append(c);
            }
            String resultPath = result.toString();
            Environment environment = OpenApiApplicationVisitor.getEnv(context);
            if (environment != null) {
                resultPath = environment.getPlaceholderResolver().resolvePlaceholders(resultPath).orElse(resultPath);
            }
            if (!resultPath.startsWith("/") && !resultPath.startsWith("$")) {
                resultPath = "/" + resultPath;
            }
            resultPaths.add((PathItem)paths.computeIfAbsent((Object)resultPath, key -> new PathItem()));
        }
        return resultPaths;
    }

    protected Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        block4: for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                Map<CharSequence, Object> valueMap;
                AnnotationValue av = (AnnotationValue)value;
                if (av.getAnnotationName().equals(io.swagger.v3.oas.annotations.media.ArraySchema.class.getName())) {
                    valueMap = this.resolveArraySchemaAnnotationValues(context, av);
                    newValues.put("schema", valueMap);
                    continue;
                }
                valueMap = this.resolveAnnotationValues(context, av);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                Optional type = acv.getType();
                type.ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Parameter.StyleEnum[] first = a[0];
                    boolean areAnnotationValues = first instanceof AnnotationValue;
                    boolean areClassValues = first instanceof AnnotationClassValue;
                    if (areClassValues) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (areAnnotationValues) {
                        Map<CharSequence, Object> valueMap;
                        Object ref;
                        Map<CharSequence, Object> map;
                        String name2;
                        AnnotationValue sv;
                        Map<String, String> params;
                        String annotationName = ((AnnotationValue)first).getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            HashMap<CharSequence, Object> extensions = new HashMap<CharSequence, Object>();
                            for (Object o : a) {
                                this.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Encoding.class.getName().equals(annotationName)) {
                            Map<String, Object> encodings = this.annotationValueArrayToSubmap(a, "name", context);
                            newValues.put(key, encodings);
                            continue;
                        }
                        if (Content.class.getName().equals(annotationName)) {
                            Map<String, Object> mediaTypes = this.annotationValueArrayToSubmap(a, "mediaType", context);
                            newValues.put(key, mediaTypes);
                            continue;
                        }
                        if (Link.class.getName().equals(annotationName) || Header.class.getName().equals(annotationName)) {
                            Map<String, Object> linksOrHeaders = this.annotationValueArrayToSubmap(a, "name", context);
                            for (Object linkOrHeader : linksOrHeaders.values()) {
                                Map linkOrHeaderMap = (Map)linkOrHeader;
                                if (linkOrHeaderMap.containsKey("ref")) {
                                    linkOrHeaderMap.put("$ref", linkOrHeaderMap.remove("ref"));
                                }
                                if (!linkOrHeaderMap.containsKey("schema")) continue;
                                Map schemaMap = (Map)linkOrHeaderMap.get("schema");
                                if (schemaMap.containsKey("ref")) {
                                    Object ref2 = schemaMap.get("ref");
                                    schemaMap.clear();
                                    schemaMap.put("$ref", ref2);
                                }
                                if (schemaMap.containsKey("defaultValue")) {
                                    schemaMap.put("default", schemaMap.remove("defaultValue"));
                                }
                                if (!schemaMap.containsKey("allowableValues")) continue;
                                schemaMap.put("enum", schemaMap.remove("allowableValues"));
                            }
                            newValues.put(key, linksOrHeaders);
                            continue;
                        }
                        if (LinkParameter.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "expression");
                            newValues.put(key, params);
                            continue;
                        }
                        if (OAuthScope.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "description");
                            newValues.put(key, params);
                            continue;
                        }
                        if (ApiResponse.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> responses = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.get((CharSequence)"responseCode", String.class).orElse("default");
                                map = this.toValueMap(sv.getValues(), context);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                responses.put(name2, map);
                            }
                            newValues.put(key, responses);
                            continue;
                        }
                        if (ExampleObject.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> examples = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.get((CharSequence)"name", String.class).orElse("example");
                                map = this.toValueMap(sv.getValues(), context);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                examples.put(name2, map);
                            }
                            newValues.put(key, examples);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList<LinkedHashMap<CharSequence, Object>> servers = new ArrayList<LinkedHashMap<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>(this.toValueMap(sv.getValues(), context));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                Optional n = sv.get((CharSequence)"name", String.class);
                                n.ifPresent(name -> {
                                    Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (DiscriminatorMapping.class.getName().equals(annotationName)) {
                            HashMap<String, String> mappings = new HashMap<String, String>();
                            for (Object o : a) {
                                AnnotationValue dv = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, dv);
                                mappings.put(valueMap.get("value").toString(), valueMap.get("$ref").toString());
                            }
                            Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                            discriminatorMap.put("mapping", mappings);
                            newValues.put("discriminator", discriminatorMap);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap2 = this.resolveAnnotationValues(context, av);
                            newValues.put(key, this.toValueMap(valueMap2, context));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, av);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            if (key.equals("discriminatorProperty")) {
                Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                discriminatorMap.put("propertyName", this.parseJsonString(value).orElse(value));
                newValues.put("discriminator", discriminatorMap);
                continue;
            }
            if (key.equals("style")) {
                Parameter.StyleEnum paramStyle = null;
                try {
                    paramStyle = Parameter.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception first) {
                    // empty catch block
                }
                if (paramStyle == null) {
                    for (Parameter.StyleEnum styleValue : Parameter.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        paramStyle = styleValue;
                        newValues.put(key, styleValue.toString());
                        break;
                    }
                } else {
                    newValues.put(key, paramStyle.toString());
                }
                if (paramStyle != null) continue;
                Encoding.StyleEnum encodingStyle = null;
                try {
                    encodingStyle = Encoding.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (encodingStyle == null) {
                    for (Encoding.StyleEnum styleValue : Encoding.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        encodingStyle = styleValue;
                        newValues.put(key, styleValue.toString());
                        continue block4;
                    }
                    continue;
                }
                newValues.put(key, encodingStyle.toString());
                continue;
            }
            if (key.equals("ref")) {
                newValues.put("$ref", value);
                continue;
            }
            if (key.equals("accessMode")) {
                if (Schema.AccessMode.READ_ONLY.toString().equals(value)) {
                    newValues.put("readOnly", Boolean.TRUE);
                    continue;
                }
                if (!Schema.AccessMode.WRITE_ONLY.toString().equals(value)) continue;
                newValues.put("writeOnly", Boolean.TRUE);
                continue;
            }
            newValues.put(key, this.parseJsonString(value).orElse(value));
        }
        return newValues;
    }

    private Map<String, Object> getDiscriminatorMap(Map<CharSequence, Object> newValues) {
        return newValues.containsKey("discriminator") ? (Map)newValues.get("discriminator") : new HashMap();
    }

    private void processExtensions(Map<CharSequence, Object> map, AnnotationValue<Extension> extension) {
        String name = extension.stringValue("name").orElse("");
        String key = !name.isEmpty() ? StringUtils.prependIfMissing((String)name, (CharSequence)"x-", (CharSequence[])new CharSequence[0]) : name;
        for (AnnotationValue prop : extension.getAnnotations("properties", ExtensionProperty.class)) {
            JsonNode processedValue;
            String propertyName = (String)prop.getRequiredValue("name", String.class);
            String propertyValue = (String)prop.getRequiredValue(String.class);
            boolean propertyAsJson = (Boolean)prop.get((CharSequence)"parseValue", Boolean.TYPE, (Object)false);
            if (!StringUtils.isNotBlank((CharSequence)propertyName) || !StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
            if (key.isEmpty()) {
                if (propertyAsJson) {
                    try {
                        processedValue = ConvertUtils.getJsonMapper().readTree(propertyValue);
                        map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), processedValue);
                    }
                    catch (Exception e) {
                        map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                    }
                    continue;
                }
                map.put(StringUtils.prependIfMissing((String)propertyName, (CharSequence)"x-", (CharSequence[])new CharSequence[0]), propertyValue);
                continue;
            }
            LinkedHashMap value = map.get(key);
            if (!(value instanceof Map)) {
                value = new LinkedHashMap();
                map.put(key, value);
            }
            Map mapValue = value;
            if (propertyAsJson) {
                try {
                    processedValue = ConvertUtils.getJsonMapper().readTree(propertyValue);
                    mapValue.put(propertyName, processedValue);
                }
                catch (Exception e) {
                    mapValue.put(propertyName, propertyValue);
                }
                continue;
            }
            mapValue.put(propertyName, propertyValue);
        }
    }

    private Optional<Object> parseJsonString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Optional.of(ConvertUtils.getConvertJsonMapper().readValue(string, Map.class));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private <T extends Schema> void processAnnotationValue(VisitorContext context, AnnotationValue<?> annotationValue, Map<CharSequence, Object> arraySchemaMap, List<String> filters, Class<T> type) {
        Map<CharSequence, Object> values = annotationValue.getValues().entrySet().stream().filter(entry -> filters == null || !filters.contains((String)entry.getKey())).collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schema = this.toValue(values, context, type);
        schema.ifPresent(s -> this.schemaToValueMap(arraySchemaMap, (Schema)s));
    }

    private Map<CharSequence, Object> resolveArraySchemaAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        HashMap<CharSequence, Object> arraySchemaMap = new HashMap<CharSequence, Object>(10);
        av.get((CharSequence)"arraySchema", AnnotationValue.class).ifPresent(annotationValue -> this.processAnnotationValue(context, (AnnotationValue<?>)annotationValue, (Map<CharSequence, Object>)arraySchemaMap, Arrays.asList("ref", "implementation"), (Class)Schema.class));
        av.get((CharSequence)"schema", AnnotationValue.class).ifPresent(annotationValue -> {
            Optional impl = annotationValue.get((CharSequence)"implementation", String.class);
            Optional type = annotationValue.get((CharSequence)"type", String.class);
            Optional format = annotationValue.get((CharSequence)"format", String.class);
            Optional classElement = Optional.empty();
            PrimitiveType primitiveType = null;
            if (impl.isPresent()) {
                classElement = context.getClassElement((String)impl.get());
            } else if (type.isPresent()) {
                primitiveType = PrimitiveType.fromName((String)(format.isPresent() && ((String)format.get()).equals(PrimitiveType.BINARY.getCommonName()) ? (String)format.get() : (String)type.get()));
                classElement = primitiveType == null ? context.getClassElement((String)type.get()) : context.getClassElement(primitiveType.getKeyClass());
            }
            if (classElement.isPresent()) {
                if (primitiveType == null) {
                    ArraySchema schema = SchemaUtils.arraySchema(this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList()));
                    this.schemaToValueMap(arraySchemaMap, (Schema)schema);
                } else {
                    Schema items = primitiveType.createProperty();
                    items.setDescription((String)annotationValue.get((CharSequence)"description", String.class).orElse(null));
                    ArraySchema schema = SchemaUtils.arraySchema(items);
                    this.schemaToValueMap(arraySchemaMap, (Schema)schema);
                }
            } else {
                arraySchemaMap.putAll(this.resolveAnnotationValues(context, (AnnotationValue<?>)annotationValue));
            }
        });
        this.processAnnotationValue(context, av, arraySchemaMap, Arrays.asList("schema", "arraySchema"), ArraySchema.class);
        return arraySchemaMap;
    }

    private Map<CharSequence, Object> resolveAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        Map<CharSequence, Object> valueMap = this.toValueMap(av.getValues(), context);
        this.bindSchemaIfNeccessary(context, av, valueMap);
        String annotationName = av.getAnnotationName();
        if (Parameter.class.getName().equals(annotationName)) {
            Utils.normalizeEnumValues(valueMap, CollectionUtils.mapOf((Object[])new Object[]{"in", ParameterIn.class, "style", ParameterStyle.class}));
        }
        return valueMap;
    }

    private Map<String, String> toTupleSubMap(Object[] a, String entryKey, String entryValue) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            Optional n = sv.get((CharSequence)entryKey, String.class);
            Optional expr = sv.get((CharSequence)entryValue, String.class);
            if (!n.isPresent() || !expr.isPresent()) continue;
            params.put((String)n.get(), (String)expr.get());
        }
        return params;
    }

    private boolean isTypeNullable(ClassElement type) {
        return type.isAssignable(Optional.class);
    }

    @Nullable
    protected Schema resolveSchema(@Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes) {
        return this.resolveSchema(Utils.resolveOpenAPI(context), definingElement, type, context, mediaTypes, null, null);
    }

    @Nullable
    protected Schema resolveSchema(OpenAPI openAPI, @Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes, JavadocDescription fieldJavadoc, JavadocDescription classJavadoc) {
        Object schema = null;
        AnnotationValue schemaAnnotationValue = null;
        if (definingElement != null) {
            schemaAnnotationValue = definingElement.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (type != null && schemaAnnotationValue == null) {
            schemaAnnotationValue = type.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (schemaAnnotationValue != null) {
            String impl = schemaAnnotationValue.stringValue("implementation").orElse(null);
            if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)impl)) {
                type = context.getClassElement(impl).orElse(type);
            } else {
                PrimitiveType primitiveType;
                String schemaType = schemaAnnotationValue.stringValue("type").orElse(null);
                if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)schemaType) && !(type instanceof EnumElement) && (primitiveType = PrimitiveType.fromName((String)schemaType)) != null && primitiveType != PrimitiveType.OBJECT) {
                    type = context.getClassElement(primitiveType.getKeyClass()).orElse(type);
                }
            }
        }
        if (type instanceof EnumElement) {
            schema = this.getSchemaDefinition(openAPI, context, type, definingElement, mediaTypes);
        } else {
            boolean isPublisher = false;
            boolean isObservable = false;
            boolean isNullable = false;
            if (!type.isAssignable("io.micronaut.http.multipart.StreamingFileUpload") && Utils.isContainerType(type)) {
                isPublisher = type.isAssignable(Publisher.class.getName()) && !type.isAssignable("reactor.core.publisher.Mono");
                isObservable = type.isAssignable("io.reactivex.Observable") && !type.isAssignable("reactor.core.publisher.Mono");
                type = type.getFirstTypeArgument().orElse(null);
            } else if (this.isTypeNullable(type)) {
                isNullable = true;
                type = type.getFirstTypeArgument().orElse(null);
            }
            if (type != null) {
                String typeName = type.getName();
                if ("io.micronaut.http.multipart.StreamingFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedPart".equals(typeName) || "io.micronaut.http.multipart.PartData".equals(typeName)) {
                    isPublisher = isPublisher && !"io.micronaut.http.multipart.PartData".equals(typeName);
                    typeName = PrimitiveType.BINARY.name();
                }
                PrimitiveType primitiveType = PrimitiveType.fromName((String)typeName);
                if (!type.isArray() && ClassUtils.isJavaLangType((String)typeName)) {
                    schema = this.getPrimitiveType(typeName);
                } else if (!type.isArray() && primitiveType != null) {
                    schema = primitiveType.createProperty();
                } else if (type.isAssignable(Map.class.getName())) {
                    schema = new MapSchema();
                    if (type.getTypeArguments().isEmpty()) {
                        schema.setAdditionalProperties((Object)true);
                    } else {
                        ClassElement valueType = (ClassElement)type.getTypeArguments().get("V");
                        if (valueType.getName().equals(Object.class.getName())) {
                            schema.setAdditionalProperties((Object)true);
                        } else {
                            schema.setAdditionalProperties((Object)this.resolveSchema(openAPI, (Element)type, valueType, context, mediaTypes, null, classJavadoc));
                        }
                    }
                } else if (type.isIterable()) {
                    if (type.isArray()) {
                        schema = this.resolveSchema(openAPI, (Element)type, type.fromArray(), context, mediaTypes, null, classJavadoc);
                        if (schema != null) {
                            schema = SchemaUtils.arraySchema(schema);
                        }
                    } else {
                        Optional componentType = type.getFirstTypeArgument();
                        schema = componentType.isPresent() ? this.resolveSchema(openAPI, (Element)type, (ClassElement)componentType.get(), context, mediaTypes, null, classJavadoc) : this.getPrimitiveType(Object.class.getName());
                        List fields = type.getFields();
                        schema = schema != null && fields.isEmpty() ? SchemaUtils.arraySchema(schema) : this.getSchemaDefinition(openAPI, context, type, definingElement, mediaTypes);
                    }
                } else if (Utils.isReturnTypeFile(type)) {
                    schema = new StringSchema();
                    schema.setFormat(PrimitiveType.BINARY.getCommonName());
                } else {
                    schema = type.isAssignable(UUID.class) ? new UUIDSchema() : this.getSchemaDefinition(openAPI, context, type, definingElement, mediaTypes);
                }
            }
            if (schema != null) {
                if (definingElement != null && io.micronaut.core.util.StringUtils.isEmpty((CharSequence)schema.getDescription())) {
                    String paramJavadoc;
                    if (fieldJavadoc != null) {
                        if (io.micronaut.core.util.StringUtils.hasText((CharSequence)fieldJavadoc.getMethodDescription())) {
                            schema.setDescription(fieldJavadoc.getMethodDescription());
                        }
                    } else if (classJavadoc != null && io.micronaut.core.util.StringUtils.hasText((CharSequence)(paramJavadoc = classJavadoc.getParameters().get(definingElement.getName())))) {
                        schema.setDescription(paramJavadoc);
                    }
                }
                boolean isStream = false;
                for (MediaType mediaType : mediaTypes) {
                    if (!MediaType.TEXT_EVENT_STREAM_TYPE.equals((Object)mediaType) && !MediaType.APPLICATION_JSON_STREAM_TYPE.equals((Object)mediaType)) continue;
                    isStream = true;
                    break;
                }
                if (!isStream && (isPublisher || isObservable)) {
                    schema = SchemaUtils.arraySchema(schema);
                } else if (isNullable) {
                    schema.setNullable(Boolean.valueOf(true));
                }
            }
        }
        return schema;
    }

    private void handleUnwrapped(VisitorContext context, Element element, ClassElement elementType, Schema parentSchema, AnnotationValue<JsonUnwrapped> uw) {
        String schemaName;
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(Utils.resolveOpenAPI(context));
        Schema wrappedPropertySchema = schemas.get(schemaName = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(this.computeDefaultSchemaName(null, (Element)elementType)));
        Map properties = wrappedPropertySchema.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String prefix = uw.stringValue("prefix").orElse("");
        String suffix = uw.stringValue("suffix").orElse("");
        for (Map.Entry prop : properties.entrySet()) {
            try {
                boolean isRequired;
                String propertyName = (String)prop.getKey();
                Schema propertySchema = (Schema)prop.getValue();
                boolean bl = isRequired = wrappedPropertySchema.getRequired() != null && wrappedPropertySchema.getRequired().contains(propertyName);
                if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)suffix) || io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)prefix)) {
                    propertyName = prefix + propertyName + suffix;
                    propertySchema = (Schema)ConvertUtils.getJsonMapper().readValue(Json.pretty(prop.getValue()), Schema.class);
                    propertySchema.setName(propertyName);
                }
                this.addProperty(parentSchema, propertyName, propertySchema, isRequired);
            }
            catch (IOException e) {
                context.warn("Exception cloning property " + e.getMessage(), null);
            }
        }
    }

    protected void processSchemaProperty(VisitorContext context, Element element, ClassElement elementType, @Nullable Element classElement, Schema parentSchema, Schema propertySchema) {
        if (propertySchema != null) {
            AnnotationValue uw = element.getAnnotation(JsonUnwrapped.class);
            if (uw != null && uw.booleanValue("enabled").orElse(Boolean.TRUE).booleanValue()) {
                this.handleUnwrapped(context, element, elementType, parentSchema, (AnnotationValue<JsonUnwrapped>)uw);
            } else {
                AnnotationValue schemaAnnotationValue = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                Optional elementSchemaRequired = Optional.empty();
                boolean isRequiredDefaultValueSet = false;
                if (schemaAnnotationValue != null) {
                    elementSchemaRequired = schemaAnnotationValue.get((CharSequence)"required", Argument.of(Boolean.TYPE));
                    isRequiredDefaultValueSet = !schemaAnnotationValue.contains("required");
                }
                boolean isNotNullable = this.isElementNotNullable(element, classElement);
                boolean isMandatoryInConstructor = this.doesParamExistsMandatoryInConstructor(element, classElement);
                boolean required = elementSchemaRequired.orElse(isNotNullable || isMandatoryInConstructor);
                if (isRequiredDefaultValueSet && isNotNullable) {
                    required = true;
                }
                propertySchema = this.bindSchemaForElement(context, element, elementType, propertySchema);
                String propertyName = this.resolvePropertyName(element, classElement, propertySchema);
                propertySchema.setRequired(null);
                Schema propertySchemaFinal = propertySchema;
                this.addProperty(parentSchema, propertyName, propertySchema, required);
                if (schemaAnnotationValue != null) {
                    schemaAnnotationValue.get((CharSequence)"defaultValue", String.class).ifPresent(value -> {
                        String elType = schemaAnnotationValue.get((CharSequence)"type", String.class).orElse(null);
                        try {
                            propertySchemaFinal.setDefault(ConvertUtils.normalizeValue(value, elType));
                        }
                        catch (JsonProcessingException e) {
                            context.warn("Can't parse value " + value + " to " + elType + ": " + e.getMessage(), element);
                            propertySchemaFinal.setDefault(value);
                        }
                    });
                }
            }
        }
    }

    protected boolean isElementNotNullable(Element element, @Nullable Element classElement) {
        return element.isAnnotationPresent(NotNull.class) || element.isAnnotationPresent(NotBlank.class) || element.isAnnotationPresent(NotEmpty.class) || element.isNonNull() || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    private boolean doesParamExistsMandatoryInConstructor(Element element, @Nullable Element classElement) {
        if (classElement instanceof ClassElement) {
            return ((ClassElement)classElement).getPrimaryConstructor().flatMap(methodElement -> Arrays.stream(methodElement.getParameters()).filter(parameterElement -> parameterElement.getName().equals(element.getName())).map(parameterElement -> !parameterElement.isNullable()).findFirst()).orElse(false);
        }
        return false;
    }

    private void addProperty(Schema parentSchema, String name, Schema propertySchema, boolean required) {
        List requiredList;
        parentSchema.addProperty(name, propertySchema);
        if (required && ((requiredList = parentSchema.getRequired()) == null || !requiredList.contains(name))) {
            parentSchema.addRequiredItem(name);
        }
    }

    private String resolvePropertyName(Element element, Element classElement, Schema propertySchema) {
        Optional nameFromSchema;
        String name = Optional.ofNullable(propertySchema.getName()).orElse(element.getName());
        if (element.hasAnnotation(io.swagger.v3.oas.annotations.media.Schema.class) && (nameFromSchema = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name")).isPresent()) {
            return (String)nameFromSchema.get();
        }
        if (element.hasAnnotation(JsonProperty.class)) {
            return element.stringValue(JsonProperty.class, "value").orElse(name);
        }
        if (classElement != null && classElement.hasAnnotation(JsonNaming.class)) {
            Optional propertyNamingStrategyClass = classElement.stringValue(JsonNaming.class);
            if (!propertyNamingStrategyClass.isPresent()) {
                return name;
            }
            PropertyNamingStrategy strategy = this.propertyNamingStrategyInstances.computeIfAbsent((String)propertyNamingStrategyClass.get(), clazz -> {
                try {
                    return (PropertyNamingStrategy)Class.forName((String)propertyNamingStrategyClass.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate: " + clazz);
                }
            });
            if (strategy instanceof PropertyNamingStrategies.NamingBase) {
                return ((PropertyNamingStrategies.NamingBase)strategy).translate(name);
            }
        }
        return name;
    }

    protected Schema bindSchemaForElement(VisitorContext context, Element element, ClassElement elementType, Schema schemaToBind) {
        String defaultJacksonValue;
        Boolean isSchemaNullable;
        boolean isNullable;
        String defaultValue;
        Schema topLevelSchema;
        ComposedSchema composedSchema;
        AnnotationValue arraySchemaAnn;
        Schema schemaFromAnn;
        AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        Schema originalSchema = schemaToBind;
        if (originalSchema.get$ref() != null && (schemaFromAnn = this.shemaFromAnnotation(context, element, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn)) != null) {
            schemaToBind = schemaFromAnn;
        }
        if (originalSchema.get$ref() == null && schemaAnn != null) {
            schemaToBind = this.bindSchemaAnnotationValue(context, element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
            Optional schemaName = schemaAnn.get((CharSequence)"name", String.class);
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
            elementType = schemaAnn.stringValue("implementation").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(elementType);
        }
        if ((arraySchemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class)) != null) {
            schemaToBind = this.bindArraySchemaAnnotationValue(context, element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema>)arraySchemaAnn);
            Optional schemaName = arraySchemaAnn.get((CharSequence)"name", String.class);
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
        }
        Schema finalSchemaToBind = schemaToBind;
        this.processJavaxValidationAnnotations(element, elementType, finalSchemaToBind);
        if (originalSchema.get$ref() != null) {
            composedSchema = new ComposedSchema();
            topLevelSchema = composedSchema;
        } else {
            composedSchema = null;
            topLevelSchema = schemaToBind;
        }
        boolean notOnlyRef = false;
        this.setSchemaDocumentation(element, topLevelSchema);
        if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)topLevelSchema.getDescription())) {
            notOnlyRef = true;
        }
        if (element.isAnnotationPresent(Deprecated.class)) {
            topLevelSchema.setDeprecated(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultValue = (String)element.getValue(Bindable.class, "defaultValue", String.class).orElse(null)) != null && schemaToBind.getDefault() == null) {
            try {
                topLevelSchema.setDefault(ConvertUtils.normalizeValue(defaultValue, schemaToBind.getType()));
            }
            catch (JsonProcessingException e) {
                context.warn("Can't convert " + defaultValue + " to " + schemaToBind.getType() + ": " + e.getMessage(), element);
                topLevelSchema.setDefault((Object)defaultValue);
            }
            notOnlyRef = true;
        }
        boolean bl = isNullable = (isSchemaNullable = (Boolean)element.booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "nullable").orElse(null)) == null && (element.isNullable() || this.isTypeNullable(elementType)) || Boolean.TRUE.equals(isSchemaNullable);
        if (isNullable) {
            topLevelSchema.setNullable(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultJacksonValue = (String)element.stringValue(JsonProperty.class, "defaultValue").orElse(null)) != null && schemaToBind.getDefault() == null) {
            try {
                topLevelSchema.setDefault(ConvertUtils.normalizeValue(defaultJacksonValue, schemaToBind.getType()));
            }
            catch (JsonProcessingException e) {
                context.warn("Can't convert " + defaultJacksonValue + " to " + schemaToBind.getType() + ": " + e.getMessage(), element);
                topLevelSchema.setDefault((Object)defaultJacksonValue);
            }
            notOnlyRef = true;
        }
        if (composedSchema != null) {
            boolean addSchemaToBind;
            boolean bl2 = addSchemaToBind = !schemaToBind.equals(EMPTY_SCHEMA);
            if (addSchemaToBind) {
                composedSchema.addAllOfItem(originalSchema);
            } else if (isNullable && CollectionUtils.isEmpty((Collection)composedSchema.getAllOf())) {
                composedSchema.addOneOfItem(originalSchema);
            }
            if (addSchemaToBind && !schemaToBind.equals((Object)originalSchema)) {
                composedSchema.addAllOfItem(schemaToBind);
            }
            if (!composedSchema.equals((Object)EMPTY_COMPOSED_SCHEMA) && (CollectionUtils.isNotEmpty((Collection)composedSchema.getAllOf()) && composedSchema.getAllOf().size() > 1 || CollectionUtils.isNotEmpty((Collection)composedSchema.getOneOf()) || notOnlyRef)) {
                return composedSchema;
            }
        }
        return originalSchema;
    }

    protected void processJavaxValidationAnnotations(Element element, ClassElement elementType, Schema schemaToBind) {
        boolean isIterableOrMap;
        boolean bl = isIterableOrMap = elementType.isIterable() || elementType.isAssignable(Map.class);
        if (isIterableOrMap) {
            if (element.isAnnotationPresent(NotEmpty.class)) {
                schemaToBind.setMinItems(Integer.valueOf(1));
            }
            element.getValue(Size.class, "min", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0));
            element.getValue(Size.class, "max", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0));
        } else {
            if (PrimitiveType.STRING.getCommonName().equals(schemaToBind.getType())) {
                if (element.isAnnotationPresent(NotEmpty.class) || element.isAnnotationPresent(NotBlank.class)) {
                    schemaToBind.setMinLength(Integer.valueOf(1));
                }
                element.getValue(Size.class, "min", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                element.getValue(Size.class, "max", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
            }
            if (element.isAnnotationPresent(Negative.class)) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent(NegativeOrZero.class)) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent(Positive.class)) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent(PositiveOrZero.class)) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            element.getValue(Max.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
            element.getValue(Min.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
            element.getValue(DecimalMax.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
            element.getValue(DecimalMin.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
            if (element.isAnnotationPresent(Email.class)) {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
            }
            element.findAnnotation(Pattern.class).flatMap(p -> p.get((CharSequence)"regexp", String.class)).ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
            element.getValue(Part.class, String.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setName(arg_0));
        }
    }

    Schema shemaFromAnnotation(VisitorContext context, Element element, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        String string;
        Object[] oneOf;
        Object[] anyOf;
        Object[] allOf;
        Schema.AccessMode schemaAccessMode;
        String accessModeStr;
        Boolean schemaDeprecated;
        String schemaExample;
        String schemaDefaultValue;
        Double schemaMultipleOf;
        Boolean schemaExclusiveMaximum;
        Boolean schemaExclusiveMinimum;
        String schemaMaximum;
        String schemaMinimum;
        if (schemaAnn == null) {
            return null;
        }
        Schema schemaToBind = new Schema();
        Map annValues = schemaAnn.getValues();
        if (annValues.containsKey("description")) {
            schemaToBind.setDescription((String)annValues.get("description"));
        }
        if (annValues.containsKey("type")) {
            schemaToBind.setType((String)annValues.get("type"));
        }
        if (annValues.containsKey("format")) {
            schemaToBind.setFormat((String)annValues.get("format"));
        }
        if (annValues.containsKey("title")) {
            schemaToBind.setTitle((String)annValues.get("title"));
        }
        if (annValues.containsKey("minLength")) {
            schemaToBind.setMinLength((Integer)annValues.get("minLength"));
        }
        if (annValues.containsKey("maxLength")) {
            schemaToBind.setMaxLength((Integer)annValues.get("maxLength"));
        }
        if (annValues.containsKey("minProperties")) {
            schemaToBind.setMinProperties((Integer)annValues.get("minProperties"));
        }
        if (annValues.containsKey("maxProperties")) {
            schemaToBind.setMaxProperties((Integer)annValues.get("maxProperties"));
        }
        if (annValues.containsKey("pattern")) {
            schemaToBind.setPattern((String)annValues.get("pattern"));
        }
        if (NumberUtils.isCreatable((String)(schemaMinimum = (String)annValues.get("minimum")))) {
            schemaToBind.setMinimum(new BigDecimal(schemaMinimum));
        }
        if (NumberUtils.isCreatable((String)(schemaMaximum = (String)annValues.get("maximum")))) {
            schemaToBind.setMaximum(new BigDecimal(schemaMaximum));
        }
        if ((schemaExclusiveMinimum = (Boolean)annValues.get("exclusiveMinimum")) != null && schemaExclusiveMinimum.booleanValue()) {
            schemaToBind.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if ((schemaExclusiveMaximum = (Boolean)annValues.get("exclusiveMaximum")) != null && schemaExclusiveMaximum.booleanValue()) {
            schemaToBind.setExclusiveMaximum(Boolean.valueOf(true));
        }
        if ((schemaMultipleOf = (Double)annValues.get("multipleOf")) != null) {
            schemaToBind.setMultipleOf(BigDecimal.valueOf(schemaMultipleOf));
        }
        AnnotationValue schemaExtDocs = (AnnotationValue)annValues.get("externalDocs");
        ExternalDocumentation externalDocs = null;
        if (schemaExtDocs != null) {
            externalDocs = this.toValue(schemaExtDocs.getValues(), context, ExternalDocumentation.class).orElse(null);
        }
        if (externalDocs != null) {
            schemaToBind.setExternalDocs(externalDocs);
        }
        if ((schemaDefaultValue = (String)annValues.get("defaultValue")) != null) {
            try {
                schemaToBind.setDefault(ConvertUtils.normalizeValue(schemaDefaultValue, schemaToBind.getType()));
            }
            catch (JsonProcessingException e) {
                context.warn("Can't convert " + schemaDefaultValue + " to " + schemaToBind.getType() + ": " + e.getMessage(), element);
                schemaToBind.setDefault((Object)schemaDefaultValue);
            }
        }
        if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)(schemaExample = (String)annValues.get("example")))) {
            try {
                schemaToBind.setExample(ConvertUtils.getConvertJsonMapper().readValue(schemaExample, Map.class));
            }
            catch (JsonProcessingException e) {
                schemaToBind.setExample((Object)schemaExample);
            }
        }
        if ((schemaDeprecated = (Boolean)annValues.get("deprecated")) != null && schemaDeprecated.booleanValue()) {
            schemaToBind.setDeprecated(Boolean.valueOf(true));
        }
        if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)(accessModeStr = (String)annValues.get("accessMode"))) && (schemaAccessMode = Schema.AccessMode.valueOf((String)accessModeStr)) != Schema.AccessMode.AUTO) {
            if (schemaAccessMode == Schema.AccessMode.READ_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(true));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.WRITE_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(false));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.READ_WRITE) {
                schemaToBind.setReadOnly(null);
                schemaToBind.setWriteOnly(null);
            }
        }
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        Components components = Utils.resolveComponents(openAPI);
        AnnotationClassValue not = (AnnotationClassValue)annValues.get("not");
        if (not != null) {
            Schema schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement(not.getName()).get(), context, Collections.emptyList());
            schemaToBind.setNot(schemaNot);
        }
        if (ArrayUtils.isNotEmpty((Object[])(allOf = (AnnotationClassValue[])annValues.get("allOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])allOf, Collections.emptyList());
            for (Schema<?> schema : schemaList) {
                schemaToBind.addAllOfItem(schema);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(anyOf = (AnnotationClassValue[])annValues.get("anyOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])anyOf, Collections.emptyList());
            for (Schema<?> schema : schemaList) {
                schemaToBind.addAnyOfItem(schema);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(oneOf = (AnnotationClassValue[])annValues.get("oneOf")))) {
            List<Schema<?>> list = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])oneOf, Collections.emptyList());
            for (Schema<?> schema : list) {
                schemaToBind.addOneOfItem(schema);
            }
        }
        if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)(string = (String)annValues.get("additionalProperties")))) {
            Schema.AdditionalPropertiesValue additionalPropertiesValue = Schema.AdditionalPropertiesValue.valueOf((String)string);
            if (additionalPropertiesValue == Schema.AdditionalPropertiesValue.TRUE) {
                schemaToBind.additionalProperties((Object)true);
            } else if (additionalPropertiesValue == Schema.AdditionalPropertiesValue.FALSE) {
                schemaToBind.additionalProperties((Object)false);
            }
        }
        return schemaToBind;
    }

    private void setSchemaDocumentation(Element element, Schema schemaToBind) {
        if (io.micronaut.core.util.StringUtils.isEmpty((CharSequence)schemaToBind.getDescription())) {
            JavadocDescription desc;
            List fields;
            String doc = element.getDocumentation().orElse(null);
            if (io.micronaut.core.util.StringUtils.isEmpty((CharSequence)doc) && element instanceof MemberElement && CollectionUtils.isNotEmpty((Collection)(fields = ((MemberElement)element).getDeclaringType().getFields()))) {
                for (FieldElement field : fields) {
                    if (!field.getName().equals(element.getName())) continue;
                    doc = field.getDocumentation().orElse(null);
                    break;
                }
            }
            if (doc != null && io.micronaut.core.util.StringUtils.hasText((CharSequence)(desc = Utils.getJavadocParser().parse(doc)).getMethodDescription())) {
                schemaToBind.setDescription(desc.getMethodDescription());
            }
        }
    }

    protected Schema bindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, schemaAnn.get((CharSequence)"type", String.class).orElse(null), schemaAnn.get((CharSequence)"defaultValue", String.class).orElse(null), schemaAnn.get((CharSequence)"allowableValues", String[].class).orElse(null));
    }

    private Schema doBindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, JsonNode schemaJson, String elType, String defaultValue, String ... allowableValues) {
        schemaJson = OpenApiApplicationVisitor.resolvePlaceholders(schemaJson, s -> OpenApiApplicationVisitor.expandProperties(s, OpenApiApplicationVisitor.getExpandableProperties(context), context));
        try {
            schemaToBind = (Schema)ConvertUtils.getJsonMapper().readerForUpdating((Object)schemaToBind).readValue(schemaJson);
        }
        catch (IOException e) {
            context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
        }
        if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            try {
                schemaToBind.setDefault(ConvertUtils.normalizeValue(defaultValue, elType));
            }
            catch (IOException e) {
                context.warn("Can't convert " + defaultValue + " to " + elType + ": " + e.getMessage(), element);
                schemaToBind.setDefault((Object)defaultValue);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])allowableValues)) {
            for (String allowableValue : allowableValues) {
                if (schemaToBind.getEnum() != null && schemaToBind.getEnum().contains(allowableValue)) continue;
                try {
                    schemaToBind.addEnumItemObject(ConvertUtils.normalizeValue(allowableValue, elType));
                }
                catch (IOException e) {
                    context.warn("Can't convert " + allowableValue + " to " + elType + ": " + e.getMessage(), element);
                    schemaToBind.addEnumItemObject((Object)allowableValue);
                }
            }
        }
        return schemaToBind;
    }

    protected Schema bindArraySchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema> schemaAnn) {
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
        if (schemaJson.isObject()) {
            JsonNode items;
            ObjectNode objNode = (ObjectNode)schemaJson;
            JsonNode arraySchema = objNode.remove("arraySchema");
            if (arraySchema != null && arraySchema.isObject()) {
                ((ObjectNode)arraySchema).remove("implementation");
                objNode.setAll((ObjectNode)arraySchema);
            }
            if ((items = objNode.remove("schema")) != null && schemaToBind != null && schemaToBind.getType().equals("array") && schemaToBind.getItems() != null && schemaToBind.getItems().get$ref() == null) {
                try {
                    schemaToBind.items((Schema)ConvertUtils.getJsonMapper().readerForUpdating((Object)schemaToBind.getItems()).readValue(items));
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
                }
            }
        }
        String elType = schemaJson.has("type") ? schemaJson.get("type").textValue() : null;
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, elType, null, new String[0]);
    }

    private Map<String, Object> annotationValueArrayToSubmap(Object[] a, String classifier, VisitorContext context) {
        LinkedHashMap<String, Object> mediaTypes = new LinkedHashMap<String, Object>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            String name = sv.get((CharSequence)classifier, String.class).orElse(null);
            if (name == null && classifier.equals("mediaType")) {
                name = "application/json";
            }
            if (name == null) continue;
            Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
            mediaTypes.put(name, map);
        }
        return mediaTypes;
    }

    private void schemaToValueMap(Map<CharSequence, Object> valueMap, Schema schema) {
        if (schema != null) {
            BeanMap beanMap = BeanMap.of((Object)schema);
            for (Map.Entry e : beanMap.entrySet()) {
                Object v = e.getValue();
                if (v == null) continue;
                valueMap.put((CharSequence)e.getKey(), v);
            }
            if (schema.get$ref() != null) {
                valueMap.put("$ref", schema.get$ref());
            }
        }
    }

    private void bindSchemaIfNeccessary(VisitorContext context, AnnotationValue<?> av, Map<CharSequence, Object> valueMap) {
        String className;
        boolean isSchema;
        Optional impl = av.get((CharSequence)"implementation", String.class);
        Optional not = av.get((CharSequence)"not", String.class);
        Optional schema = av.get((CharSequence)"schema", String.class);
        Optional anyOf = av.get((CharSequence)"anyOf", Argument.of(String[].class));
        Optional oneOf = av.get((CharSequence)"oneOf", Argument.of(String[].class));
        Optional allOf = av.get((CharSequence)"allOf", Argument.of(String[].class));
        Object o = valueMap.remove("defaultValue");
        if (o != null) {
            valueMap.put("default", o);
        }
        if ((o = valueMap.remove("allowableValues")) != null) {
            valueMap.put("enum", o);
        }
        if (isSchema = io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(av.getAnnotationName())) {
            if (impl.isPresent()) {
                className = (String)impl.get();
                this.bindSchemaForClassName(context, valueMap, className);
            }
            if (not.isPresent()) {
                Schema schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement((String)not.get()).get(), context, Collections.emptyList());
                HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
                this.schemaToValueMap(schemaMap, schemaNot);
                valueMap.put("not", schemaMap);
            }
            anyOf.ifPresent(anyOfList -> this.bindSchemaForComposite(context, valueMap, (String[])anyOfList, "anyOf"));
            oneOf.ifPresent(oneOfList -> this.bindSchemaForComposite(context, valueMap, (String[])oneOfList, "oneOf"));
            allOf.ifPresent(allOfList -> this.bindSchemaForComposite(context, valueMap, (String[])allOfList, "allOf"));
        }
        if (DiscriminatorMapping.class.getName().equals(av.getAnnotationName()) && schema.isPresent()) {
            className = (String)schema.get();
            this.bindSchemaForClassName(context, valueMap, className);
        }
    }

    private void bindSchemaForComposite(VisitorContext context, Map<CharSequence, Object> valueMap, String[] classNames, String key) {
        List namesToSchemas = Arrays.stream(classNames).map(className -> {
            Optional classElement = context.getClassElement(className);
            HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
            if (classElement.isPresent()) {
                Schema schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList());
                this.schemaToValueMap(schemaMap, schema);
            }
            return schemaMap;
        }).collect(Collectors.toList());
        valueMap.put(key, namesToSchemas);
    }

    private void bindSchemaForClassName(VisitorContext context, Map<CharSequence, Object> valueMap, String className) {
        Optional classElement = context.getClassElement(className);
        if (classElement.isPresent()) {
            Schema schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList());
            this.schemaToValueMap(valueMap, schema);
        }
    }

    private void checkAllOf(Schema<Object> composedSchema) {
        if (composedSchema != null && composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty() && composedSchema.getProperties() != null && !composedSchema.getProperties().isEmpty()) {
            ObjectSchema propSchema = new ObjectSchema();
            propSchema.properties(composedSchema.getProperties());
            propSchema.setDescription(composedSchema.getDescription());
            propSchema.setRequired(composedSchema.getRequired());
            composedSchema.setProperties(null);
            composedSchema.setDescription(null);
            composedSchema.setRequired(null);
            composedSchema.setType(null);
            composedSchema.addAllOfItem((Schema)propSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema getSchemaDefinition(OpenAPI openAPI, VisitorContext context, ClassElement type, @Nullable Element definingElement, List<MediaType> mediaTypes) {
        Schema schema;
        AnnotationValue schemaValue;
        AnnotationValue annotationValue = schemaValue = definingElement == null ? null : definingElement.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (schemaValue == null) {
            schemaValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(openAPI);
        if (schemaValue == null) {
            boolean isBasicType = ClassUtils.isJavaBasicType((String)type.getName());
            PrimitiveType primitiveType = isBasicType ? (PrimitiveType)ClassUtils.forName((String)type.getName(), (ClassLoader)this.getClass().getClassLoader()).map(PrimitiveType::fromType).orElse(null) : null;
            if (primitiveType != null) return primitiveType.createProperty();
            String schemaName = this.computeDefaultSchemaName(definingElement, (Element)type);
            schema = schemas.get(schemaName);
            JavadocDescription javadoc = Utils.getJavadocParser().parse(type.getDocumentation().orElse(null));
            if (schema == null) {
                if (type instanceof EnumElement) {
                    schema = new Schema();
                    schema.setName(schemaName);
                    if (javadoc != null && io.micronaut.core.util.StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    schemas.put(schemaName, schema);
                    if (schema.getType() == null) {
                        schema.setType(PrimitiveType.STRING.getCommonName());
                    }
                    if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                        schema.setEnum(this.getEnumValues((EnumElement)type, schema.getType(), context));
                    }
                } else {
                    if (type instanceof TypedElement) {
                        ClassElement classElement = type.getType();
                        ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
                        Collection parentInterfaces = classElement.getInterfaces();
                        if (classElement.isInterface() && !parentInterfaces.isEmpty()) {
                            for (ClassElement parentInterface : parentInterfaces) {
                                if (ClassUtils.isJavaLangType((String)parentInterface.getName()) || parentInterface.getBeanProperties().isEmpty()) continue;
                                superTypes.add(parentInterface);
                            }
                        } else {
                            classElement.getSuperType().ifPresent(superTypes::add);
                        }
                        if (!type.isRecord() && !superTypes.isEmpty()) {
                            schema = new ComposedSchema();
                            for (ClassElement sType : superTypes) {
                                if (type.isRecord()) continue;
                                this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, sType, schemas);
                            }
                        } else {
                            schema = new Schema();
                        }
                    } else {
                        schema = new Schema();
                    }
                    schema.setType("object");
                    schema.setName(schemaName);
                    if (javadoc != null && io.micronaut.core.util.StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    schemas.put(schemaName, schema);
                    this.populateSchemaProperties(openAPI, context, (Element)type, schema, mediaTypes, javadoc);
                    this.checkAllOf((Schema<Object>)schema);
                }
            }
        } else {
            String schemaName = schemaValue.get((CharSequence)"name", String.class).orElse(this.computeDefaultSchemaName(definingElement, (Element)type));
            schema = schemas.get(schemaName);
            if (schema == null) {
                if (this.inProgressSchemas.contains(schemaName)) {
                    return new Schema().$ref(SchemaUtils.schemaRef(schemaName));
                }
                this.inProgressSchemas.add(schemaName);
                try {
                    Schema originalTypeSchema;
                    schema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaValue, openAPI, context, (Element)type, mediaTypes);
                    AnnotationValue typeSchema = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                    if (typeSchema != null && (originalTypeSchema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)typeSchema, openAPI, context, (Element)type, mediaTypes)) != null && schema != null) {
                        if (io.micronaut.core.util.StringUtils.isNotEmpty((CharSequence)originalTypeSchema.getDescription())) {
                            schema.setDescription(originalTypeSchema.getDescription());
                        }
                        schema.setNullable(originalTypeSchema.getNullable());
                        schema.setRequired(originalTypeSchema.getRequired());
                    }
                    if (schema != null) {
                        ClassElement classElement = type.getType();
                        ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
                        Collection parentInterfaces = classElement.getInterfaces();
                        if (classElement.isInterface() && !parentInterfaces.isEmpty()) {
                            for (ClassElement parentInterface : parentInterfaces) {
                                if (ClassUtils.isJavaLangType((String)parentInterface.getName()) || parentInterface.getBeanProperties().isEmpty()) continue;
                                superTypes.add(parentInterface);
                            }
                        }
                        if (!superTypes.isEmpty()) {
                            ComposedSchema schema1 = new ComposedSchema();
                            schema1.addAllOfItem(schema);
                            for (ClassElement sType : superTypes) {
                                String schemaName2 = this.computeDefaultSchemaName(definingElement, (Element)sType);
                                Schema parentSchema = new Schema();
                                parentSchema.set$ref(SchemaUtils.schemaRef(schemaName2));
                                schema1.addAllOfItem(parentSchema);
                            }
                            schema = schema1;
                        }
                        schema.setName(schemaName);
                        schemas.put(schemaName, schema);
                    }
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading Swagger Parameter for element [" + type + "]: " + e.getMessage(), (Element)type);
                }
                finally {
                    this.inProgressSchemas.remove(schemaName);
                }
            }
        }
        if (schema == null) return null;
        AnnotationValue externalDocsValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        ExternalDocumentation externalDocs = null;
        if (externalDocsValue != null) {
            externalDocs = this.toValue(externalDocsValue.getValues(), context, ExternalDocumentation.class).orElse(null);
        }
        if (externalDocs != null) {
            schema.setExternalDocs(externalDocs);
        }
        this.setSchemaDocumentation((Element)type, schema);
        Schema schemaRef = new Schema();
        schemaRef.set$ref(SchemaUtils.schemaRef(schema.getName()));
        if (!(definingElement instanceof ClassElement) || !((ClassElement)definingElement).isIterable()) return schemaRef;
        schemaRef.setDescription(schema.getDescription());
        return schemaRef;
    }

    private void readAllInterfaces(OpenAPI openAPI, VisitorContext context, @Nullable Element definingElement, List<MediaType> mediaTypes, Schema schema, ClassElement superType, Map<String, Schema> schemas) {
        String parentSchemaName = this.computeDefaultSchemaName(definingElement, (Element)superType);
        if (schemas.get(parentSchemaName) != null || this.getSchemaDefinition(openAPI, context, superType, null, mediaTypes) != null) {
            Schema parentSchema = new Schema();
            parentSchema.set$ref(SchemaUtils.schemaRef(parentSchemaName));
            schema.addAllOfItem(parentSchema);
        }
        if (superType.isInterface()) {
            for (ClassElement interfaceElement : superType.getInterfaces()) {
                if (ClassUtils.isJavaLangType((String)interfaceElement.getName()) || interfaceElement.getBeanProperties().isEmpty()) continue;
                this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, interfaceElement, schemas);
            }
        } else if (superType.getSuperType().isPresent()) {
            this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, (ClassElement)superType.getSuperType().get(), schemas);
        }
    }

    protected Schema readSchema(AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaValue, OpenAPI openAPI, VisitorContext context, @Nullable Element type, List<MediaType> mediaTypes) throws JsonProcessingException {
        Object[] oneOf;
        Object[] anyOf;
        Object[] allOf;
        Object[] allowableValues;
        Map<CharSequence, Object> values = schemaValue.getValues().entrySet().stream().collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schemaOpt = this.toValue(values, context, Schema.class);
        if (!schemaOpt.isPresent()) {
            return null;
        }
        Schema schema = schemaOpt.get();
        String elType = (String)values.get("type");
        if (values.containsKey("allowableValues") && ArrayUtils.isNotEmpty((Object[])(allowableValues = (String[])values.get("allowableValues")))) {
            for (Object allowableValue : allowableValues) {
                if (schema.getEnum() != null && schema.getEnum().contains(allowableValue)) continue;
                try {
                    schema.addEnumItemObject(ConvertUtils.normalizeValue((String)allowableValue, elType));
                }
                catch (IOException e2) {
                    context.warn("Can't convert " + (String)allowableValue + " to " + elType + ": " + e2.getMessage(), type);
                    schema.addEnumItemObject(allowableValue);
                }
            }
        }
        String defaultValue = schemaValue.get((CharSequence)"defaultValue", String.class).orElse(null);
        try {
            schema.setDefault(ConvertUtils.normalizeValue(defaultValue, elType));
        }
        catch (IOException e3) {
            context.warn("Can't convert " + defaultValue + " to " + elType + ": " + e3.getMessage(), type);
            schema.setDefault((Object)defaultValue);
        }
        Schema composedSchema = schema;
        AnnotationClassValue not = (AnnotationClassValue)values.get("not");
        if (not != null) {
            Schema schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement(not.getName()).get(), context, Collections.emptyList());
            composedSchema.setNot(schemaNot);
        }
        if (ArrayUtils.isNotEmpty((Object[])(allOf = (AnnotationClassValue[])values.get("allOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])allOf, mediaTypes);
            for (Schema<?> schema2 : schemaList) {
                composedSchema.addAllOfItem(schema2);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(anyOf = (AnnotationClassValue[])values.get("anyOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])anyOf, mediaTypes);
            for (Schema<?> schema3 : schemaList) {
                composedSchema.addAnyOfItem(schema3);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(oneOf = (AnnotationClassValue[])values.get("oneOf")))) {
            List<Schema<?>> list = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])oneOf, mediaTypes);
            for (Schema<?> s : list) {
                composedSchema.addOneOfItem(s);
            }
        }
        if (schema.getType() == null) {
            schema.setType("object");
        }
        if (type instanceof EnumElement) {
            elType = elType != null ? elType : PrimitiveType.STRING.getCommonName();
            schema.setType(elType);
            if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                schema.setEnum(this.getEnumValues((EnumElement)type, elType, context));
            }
        } else {
            JavadocDescription javadocDescription = Utils.getJavadocParser().parse(type.getDescription());
            this.populateSchemaProperties(openAPI, context, type, schema, mediaTypes, javadocDescription);
            this.checkAllOf((Schema<Object>)composedSchema);
        }
        return schema;
    }

    private List<Object> getEnumValues(EnumElement type, String schemaType, VisitorContext context) {
        ArrayList<Object> enumValues = new ArrayList<Object>();
        for (EnumConstantElement element : type.elements()) {
            String jacksonValue;
            AnnotationValue jsonProperty = element.getAnnotation(JsonProperty.class);
            String string = jacksonValue = jsonProperty != null ? (String)jsonProperty.get((CharSequence)"value", String.class).get() : null;
            if (io.micronaut.core.util.StringUtils.hasText(jacksonValue)) {
                try {
                    enumValues.add(ConvertUtils.normalizeValue(jacksonValue, schemaType));
                }
                catch (JsonProcessingException e) {
                    context.warn("Error converting jacksonValue " + jacksonValue + " : to " + type + ": " + e.getMessage(), (Element)element);
                    enumValues.add(element.getSimpleName());
                }
                continue;
            }
            enumValues.add(element.getSimpleName());
        }
        return enumValues;
    }

    private List<Schema<?>> namesToSchemas(OpenAPI openAPI, VisitorContext context, AnnotationClassValue<?>[] names, List<MediaType> mediaTypes) {
        return Arrays.stream(names).flatMap(classAnn -> {
            Schema schemaDefinition;
            Optional classElement = context.getClassElement(classAnn.getName());
            if (classElement.isPresent() && (schemaDefinition = this.getSchemaDefinition(openAPI, context, (ClassElement)classElement.get(), null, mediaTypes)) != null) {
                return Stream.of(schemaDefinition);
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private String computeDefaultSchemaName(Element definingElement, Element type) {
        String metaAnnName;
        String string = metaAnnName = definingElement == null ? null : (String)definingElement.getAnnotationNameByStereotype(io.swagger.v3.oas.annotations.media.Schema.class).orElse(null);
        if (metaAnnName != null && !io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(metaAnnName)) {
            return NameUtils.getSimpleName((String)metaAnnName);
        }
        String javaName = type instanceof TypedElement ? this.computeNameWithGenerics(((TypedElement)type).getType()) : type.getSimpleName();
        return javaName.replace("$", ".");
    }

    private String computeNameWithGenerics(ClassElement classElement) {
        StringBuilder builder = new StringBuilder(classElement.getSimpleName());
        this.computeNameWithGenerics(classElement, builder, new HashSet<String>());
        return builder.toString();
    }

    private void computeNameWithGenerics(ClassElement classElement, StringBuilder builder, Set<String> computed) {
        computed.add(classElement.getName());
        Map typeArguments = classElement.getTypeArguments();
        Iterator i = typeArguments.values().iterator();
        if (i.hasNext()) {
            builder.append('_');
            while (i.hasNext()) {
                ClassElement ce = (ClassElement)i.next();
                builder.append(ce.getSimpleName());
                if (!computed.contains(ce.getName())) {
                    this.computeNameWithGenerics(ce, builder, computed);
                }
                if (!i.hasNext()) continue;
                builder.append('.');
            }
            builder.append('_');
        }
    }

    static boolean isJavaElement(ClassElement classElement, VisitorContext context) {
        return classElement != null && "io.micronaut.annotation.processing.visitor.JavaClassElement".equals(classElement.getClass().getName()) && "io.micronaut.annotation.processing.visitor.JavaVisitorContext".equals(context.getClass().getName());
    }

    private void populateSchemaProperties(OpenAPI openAPI, VisitorContext context, Element type, Schema schema, List<MediaType> mediaTypes, JavadocDescription classJavadoc) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            classElement = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            classElement = ((TypedElement)type).getType();
        }
        if (classElement != null) {
            List beanProperties;
            try {
                beanProperties = classElement.getBeanProperties().stream().filter(p -> !"groovy.lang.MetaClass".equals(p.getType().getName())).collect(Collectors.toList());
            }
            catch (Exception e) {
                beanProperties = Collections.emptyList();
            }
            this.processPropertyElements(openAPI, context, type, schema, beanProperties, mediaTypes, classJavadoc);
            List publicFields = classElement.getEnclosedElements(ElementQuery.ALL_FIELDS.modifiers(mods -> mods.contains(ElementModifier.PUBLIC) && mods.size() == 1));
            this.processPropertyElements(openAPI, context, type, schema, publicFields, mediaTypes, classJavadoc);
        }
    }

    private void processPropertyElements(OpenAPI openAPI, VisitorContext context, Element type, Schema schema, List<? extends TypedElement> publicFields, List<MediaType> mediaTypes, JavadocDescription classJavadoc) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            classElement = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            classElement = ((TypedElement)type).getType();
        }
        for (TypedElement typedElement : publicFields) {
            boolean isHidden = typedElement.getAnnotationMetadata().booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "hidden").orElse(false);
            AnnotationValue jsonAnySetterAnn = typedElement.getAnnotation(JsonAnySetter.class);
            if (typedElement.isAnnotationPresent(JsonIgnore.class) || typedElement.isAnnotationPresent(Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.get((CharSequence)"enabled", Boolean.class).orElse(true).booleanValue() || isHidden) continue;
            JavadocDescription fieldJavadoc = null;
            if (classElement != null) {
                for (FieldElement field : classElement.getFields()) {
                    if (!field.getName().equals(typedElement.getName())) continue;
                    fieldJavadoc = Utils.getJavadocParser().parse(field.getDocumentation().orElse(null));
                    break;
                }
            }
            if (!(typedElement instanceof MemberElement) || !((MemberElement)typedElement).getDeclaringType().getType().getName().equals(type.getName())) continue;
            Schema propertySchema = this.resolveSchema(openAPI, (Element)typedElement, typedElement.getType(), context, mediaTypes, fieldJavadoc, classJavadoc);
            this.processSchemaProperty(context, (Element)typedElement, typedElement.getType(), type, schema, propertySchema);
        }
    }

    private Schema getPrimitiveType(String typeName) {
        Class concreteType;
        Class wrapperType;
        PrimitiveType primitiveType;
        Schema schema = null;
        Optional aClass = ClassUtils.getPrimitiveType((String)typeName);
        if (!aClass.isPresent()) {
            aClass = ClassUtils.forName((String)typeName, (ClassLoader)this.getClass().getClassLoader());
        }
        if (aClass.isPresent() && (primitiveType = PrimitiveType.fromType((Type)(wrapperType = ReflectionUtils.getWrapperType((Class)(concreteType = (Class)aClass.get()))))) != null) {
            schema = primitiveType.createProperty();
        }
        return schema;
    }

    protected void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(SecurityScheme.class);
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        for (AnnotationValue securityRequirementAnnotationValue : values) {
            Optional n = securityRequirementAnnotationValue.get((CharSequence)"name", String.class);
            n.ifPresent(name -> {
                Map<CharSequence, Object> map = this.toValueMap(securityRequirementAnnotationValue.getValues(), context);
                if (map.containsKey("paramName")) {
                    map.put("name", map.remove("paramName"));
                } else {
                    map.putIfAbsent("name", name);
                }
                Utils.normalizeEnumValues(map, CollectionUtils.mapOf((Object[])new Object[]{"type", SecurityScheme.Type.class, "in", SecurityScheme.In.class}));
                if (map.containsKey("ref")) {
                    map.put("$ref", map.remove("ref"));
                }
                try {
                    JsonNode node = this.toJson(map, context);
                    io.swagger.v3.oas.models.security.SecurityScheme securityScheme = ConvertUtils.treeToValue(node, io.swagger.v3.oas.models.security.SecurityScheme.class);
                    if (securityScheme != null) {
                        ConvertUtils.resolveExtensions(node).ifPresent(extensions -> BeanMap.of((Object)securityScheme).put((Object)"extensions", extensions));
                        Utils.resolveComponents(openAPI).addSecuritySchemes(name, securityScheme);
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
        }
    }

    protected <T, A extends Annotation> List<T> processOpenApiAnnotation(Element element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                Optional<T> tagOpt;
                Map values;
                if (tag.getAnnotationName().equals(io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName()) && !tag.getValues().isEmpty()) {
                    Object name = tag.getValues().get("name");
                    ArrayList scopes = Optional.ofNullable(tag.getValues().get("scopes")).orElse(new ArrayList());
                    values = Collections.singletonMap((CharSequence)name, scopes);
                } else {
                    values = tag.getValues();
                }
                if (!(tagOpt = this.toValue(values, context, modelType)).isPresent()) continue;
                T tagObj = tagOpt.get();
                boolean alreadyExists = false;
                if (CollectionUtils.isNotEmpty(tagList) && tag.getAnnotationName().equals(Tag.class.getName())) {
                    for (T existedTag : tagList) {
                        if (!((io.swagger.v3.oas.models.tags.Tag)existedTag).getName().equals(((io.swagger.v3.oas.models.tags.Tag)tagObj).getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                }
                if (alreadyExists) continue;
                tagList.add(tagObj);
            }
        }
        return tagList;
    }
}

