/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.env.ActiveEnvironment;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.file.DefaultFileSystemResourceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnnProcessorEnvironment
extends DefaultEnvironment {
    private final List<String> annotationProcessingConfigLocations = new ArrayList<String>();
    private String projectResourcesPath;
    private String projectDir = "";

    public AnnProcessorEnvironment(ApplicationContextConfiguration configuration, VisitorContext context) {
        super(configuration);
        boolean isEnabled = context.get((CharSequence)"micronaut.environment.enabled", Boolean.class).orElse(false);
        if (isEnabled) {
            Path projectPath = context.getProjectDir().orElse(Utils.isTestMode() ? Paths.get(System.getProperty("user.dir"), new String[0]) : null);
            if (projectPath != null) {
                this.projectDir = "file:" + projectPath.toString().replaceAll("\\\\", "/");
                this.projectResourcesPath = this.projectDir + (this.projectDir.endsWith("/") ? "" : "/") + "src/main/resources/";
            } else {
                context.warn("Can't identificate projectPath", null);
            }
            String configFileLocations = System.getProperty("micronaut.openapi.config.file.locations");
            if (this.projectResourcesPath != null && StringUtils.isEmpty((CharSequence)configFileLocations)) {
                this.annotationProcessingConfigLocations.add(this.projectResourcesPath);
            } else if (StringUtils.isNotEmpty((CharSequence)configFileLocations)) {
                for (String configFileLocation : configFileLocations.split(",")) {
                    if (!(configFileLocation.startsWith("classpath") || configFileLocation.startsWith("file") || configFileLocation.startsWith("project"))) {
                        throw new ConfigurationException("Unsupported config location format: " + configFileLocation);
                    }
                    if (configFileLocation.startsWith("project")) {
                        configFileLocation = configFileLocation.replace("project:", this.projectDir);
                    }
                    this.annotationProcessingConfigLocations.add(configFileLocation);
                }
            }
        }
    }

    protected void readPropertySources(String name) {
        String propertySourcesEnv;
        this.refreshablePropertySources.clear();
        List<PropertySource> propertySources = this.readPropertySourceList(name);
        this.addDefaultPropertySources(propertySources);
        String propertySourcesSystemProperty = CachedEnvironment.getProperty((String)"micronaut.config.files");
        if (propertySourcesSystemProperty != null) {
            if (propertySourcesSystemProperty.startsWith("project")) {
                propertySourcesSystemProperty = propertySourcesSystemProperty.replaceAll("project:", this.projectDir);
            }
            propertySources.addAll(this.readPropertySourceListFromFiles(propertySourcesSystemProperty));
        }
        if ((propertySourcesEnv = this.readPropertySourceListKeyFromEnvironment()) != null) {
            if (propertySourcesEnv.startsWith("project")) {
                propertySourcesEnv = propertySourcesEnv.replaceAll("project:", this.projectDir);
            }
            propertySources.addAll(this.readPropertySourceListFromFiles(propertySourcesEnv));
        }
        this.refreshablePropertySources.addAll(propertySources);
        this.readConstantPropertySources(name, propertySources);
        propertySources.addAll(this.propertySources.values());
        OrderUtil.sort(propertySources);
        for (PropertySource propertySource : propertySources) {
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
    }

    private void readConstantPropertySources(String name, List<PropertySource> propertySources) {
        Set propertySourceNames = Stream.concat(Stream.of(name), this.getActiveNames().stream().map(env -> name + "-" + env)).collect(Collectors.toSet());
        this.getConstantPropertySources().stream().filter(p -> propertySourceNames.contains(p.getName())).forEach(propertySources::add);
    }

    protected List<PropertySource> readPropertySourceList(String name) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        for (String configLocation : this.annotationProcessingConfigLocations) {
            AnnProcessorEnvironment resourceLoader;
            if (configLocation.equals("classpath:/")) {
                resourceLoader = this;
            } else if (configLocation.startsWith("classpath:")) {
                resourceLoader = this.forBase(configLocation);
            } else if (configLocation.startsWith("file:")) {
                Path configLocationPath = Paths.get(configLocation = configLocation.substring(5), new String[0]);
                if (!Files.exists(configLocationPath, new LinkOption[0]) || !Files.isDirectory(configLocationPath, new LinkOption[0]) || !Files.isReadable(configLocationPath)) continue;
                resourceLoader = new DefaultFileSystemResourceLoader(configLocationPath);
            } else {
                throw new ConfigurationException("Unsupported config location format: " + configLocation);
            }
            this.readPropertySourceList(name, (ResourceLoader)resourceLoader, propertySources);
        }
        return propertySources;
    }

    private void readPropertySourceList(String name, ResourceLoader resourceLoader, List<PropertySource> propertySources) {
        Collection propertySourceLoaders = this.getPropertySourceLoaders();
        if (propertySourceLoaders.isEmpty()) {
            this.loadPropertySourceFromLoader(name, (PropertySourceLoader)new PropertiesPropertySourceLoader(), propertySources, resourceLoader);
        } else {
            for (PropertySourceLoader propertySourceLoader : propertySourceLoaders) {
                this.loadPropertySourceFromLoader(name, propertySourceLoader, propertySources, resourceLoader);
            }
        }
    }

    private void loadPropertySourceFromLoader(String name, PropertySourceLoader propertySourceLoader, List<PropertySource> propertySources, ResourceLoader resourceLoader) {
        Optional defaultPropertySource = propertySourceLoader.load(name, resourceLoader);
        defaultPropertySource.ifPresent(propertySources::add);
        Set activeNames = this.getActiveNames();
        int i = 0;
        for (String activeName : activeNames) {
            Optional propertySource = propertySourceLoader.loadEnv(name, resourceLoader, ActiveEnvironment.of((String)activeName, (int)i));
            propertySource.ifPresent(propertySources::add);
            ++i;
        }
    }
}

