/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.annotation.Controller;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIInclude;
import io.micronaut.openapi.annotation.OpenAPIIncludes;
import io.micronaut.openapi.visitor.OpenApiControllerVisitor;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Optional;

public class OpenApiIncludeVisitor
implements TypeElementVisitor<OpenAPIIncludes, Object> {
    public void visitClass(ClassElement element, VisitorContext visitorContext) {
        for (AnnotationValue includeAnnotation : element.getAnnotationValuesByType(OpenAPIInclude.class)) {
            Object[] classes = includeAnnotation.stringValues();
            if (!ArrayUtils.isNotEmpty((Object[])classes)) continue;
            List tags = includeAnnotation.getAnnotations("tags", Tag.class);
            List security = includeAnnotation.getAnnotations("security", SecurityRequirement.class);
            Optional customUri = includeAnnotation.stringValue("uri");
            OpenApiControllerVisitor controllerVisitor = new OpenApiControllerVisitor(tags, security, customUri.orElse(null));
            OpenApiEndpointVisitor endpointVisitor = new OpenApiEndpointVisitor(true, tags.isEmpty() ? null : tags, security.isEmpty() ? null : security);
            for (Object className : classes) {
                visitorContext.getClassElement((String)className).ifPresent(ce -> {
                    if (ce.isAnnotationPresent(Controller.class)) {
                        this.visit(controllerVisitor, visitorContext, (ClassElement)ce);
                    } else if (ce.isAnnotationPresent("io.micronaut.management.endpoint.annotation.Endpoint")) {
                        this.visit(endpointVisitor, visitorContext, (ClassElement)ce);
                    }
                });
            }
        }
    }

    private void visit(TypeElementVisitor<?, ?> visitor, VisitorContext visitorContext, ClassElement ce) {
        visitor.visitClass(ce, visitorContext);
        ce.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$"))).forEach(method -> visitor.visitMethod(method, visitorContext));
    }
}

