/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.MediaType;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;

public final class Utils {
    public static final String ATTR_OPENAPI = "io.micronaut.OPENAPI";
    public static final String ATTR_TEST_MODE = "io.micronaut.OPENAPI_TEST";
    public static final String ATTR_VISITED_ELEMENTS = "io.micronaut.OPENAPI.visited.elements";
    public static final List<MediaType> DEFAULT_MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private static PropertyPlaceholderResolver propertyPlaceholderResolver;
    private static OpenAPI testReference;
    private static OpenAPI testReferenceAfterPlaceholders;
    private static String testYamlReference;
    private static String testJsonReference;
    private static JavadocParser javadocParser;

    private Utils() {
    }

    public static Path getProjectPath(VisitorContext context) {
        return context.getProjectDir().orElse(Utils.isTestMode() ? Paths.get(System.getProperty("user.dir"), new String[0]) : null);
    }

    public static PropertyPlaceholderResolver getPropertyPlaceholderResolver() {
        if (propertyPlaceholderResolver == null) {
            propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(new PropertyResolver(){

                public boolean containsProperty(@NonNull String name) {
                    return false;
                }

                public boolean containsProperties(@NonNull String name) {
                    return false;
                }

                @NonNull
                public <T> Optional<T> getProperty(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
                    return Optional.empty();
                }
            }, (ConversionService)new DefaultConversionService());
        }
        return propertyPlaceholderResolver;
    }

    public static boolean isContainerType(ClassElement type) {
        return CollectionUtils.setOf((Object[])new String[]{Optional.class.getName(), Future.class.getName(), "org.reactivestreams.Publisher", "io.reactivex.Single", "io.reactivex.Observable", "io.reactivex.Maybe", "io.reactivex.rxjava3.core.Single", "io.reactivex.rxjava3.core.Observable", "io.reactivex.rxjava3.core.Maybe"}).stream().anyMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0));
    }

    public static boolean isReturnTypeFile(ClassElement type) {
        return CollectionUtils.setOf((Object[])new String[]{"io.micronaut.http.server.types.files.FileCustomizableResponseType", File.class.getName(), InputStream.class.getName(), ByteBuffer.class.getName()}).stream().anyMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0));
    }

    public static <T extends Enum<T>> void normalizeEnumValues(Map<CharSequence, Object> paramValues, Map<String, Class<T>> enumTypes) {
        for (Map.Entry<String, Class<T>> entry : enumTypes.entrySet()) {
            String name = entry.getKey();
            Class<T> enumType = entry.getValue();
            Object in = paramValues.get(name);
            if (in == null) continue;
            try {
                T enumInstance = Enum.valueOf(enumType, in.toString());
                paramValues.put(name, ((Enum)enumInstance).toString());
            }
            catch (Exception exception) {}
        }
    }

    public static Components resolveComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            components = new Components();
            openAPI.setComponents(components);
        }
        return components;
    }

    public static OpenAPI resolveOpenAPI(VisitorContext context) {
        OpenAPI openAPI = context.get((CharSequence)ATTR_OPENAPI, OpenAPI.class).orElse(null);
        if (openAPI == null) {
            openAPI = new OpenAPI();
            context.put((CharSequence)ATTR_OPENAPI, (Object)openAPI);
            if (Utils.isTestMode()) {
                Utils.setTestReference(openAPI);
            }
        }
        return openAPI;
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean(ATTR_TEST_MODE);
    }

    public static OpenAPI getTestReference() {
        return testReference;
    }

    public static void setTestReference(OpenAPI testReference) {
        Utils.testReference = testReference;
    }

    public static OpenAPI getTestReferenceAfterPlaceholders() {
        return testReferenceAfterPlaceholders;
    }

    public static void setTestReferenceAfterPlaceholders(OpenAPI testReferenceAfterPlaceholders) {
        Utils.testReferenceAfterPlaceholders = testReferenceAfterPlaceholders;
    }

    public static String getTestYamlReference() {
        return testYamlReference;
    }

    public static void setTestYamlReference(String testYamlReference) {
        Utils.testYamlReference = testYamlReference;
    }

    public static String getTestJsonReference() {
        return testJsonReference;
    }

    public static void setTestJsonReference(String testJsonReference) {
        Utils.testJsonReference = testJsonReference;
    }

    public static JavadocParser getJavadocParser() {
        return javadocParser;
    }

    public static void setJavadocParser(JavadocParser javadocParser) {
        Utils.javadocParser = javadocParser;
    }

    static {
        javadocParser = new JavadocParser();
    }
}

