/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractViewConfig {
    protected String prefix;
    protected String jsUrl = "";
    protected String finalUrlPrefix;
    protected String resourcesContextPath = "/res";
    protected String templatePath;
    protected boolean isDefaultJsUrl = true;
    protected boolean copyResources = true;
    protected boolean withFinalUrlPrefixCache = true;
    protected Map<String, Object> options = new HashMap<String, Object>();

    protected AbstractViewConfig(String prefix) {
        this.prefix = prefix;
    }

    protected abstract Function<String, Object> getConverter(String var1);

    protected abstract List<String> getResources();

    public String getTemplatePath() {
        return this.templatePath;
    }

    public abstract String render(String var1, VisitorContext var2);

    protected void addAttribute(Map.Entry<String, String> entry) {
        String key = entry.getKey().substring(this.prefix.length());
        Function<String, Object> converter = this.getConverter(key);
        if (converter != null) {
            this.options.put(key, converter.apply(entry.getValue()));
        }
    }

    protected String toHtmlAttributes() {
        return this.options.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + e.getValue() + '\"').collect(Collectors.joining(" "));
    }

    protected String getFinalUrlPrefix(OpenApiViewConfig.RendererType rendererType, VisitorContext context) {
        String contextPath;
        String finalUrl;
        if (this.finalUrlPrefix != null && this.withFinalUrlPrefixCache) {
            return this.finalUrlPrefix;
        }
        String serverContextPath = OpenApiApplicationVisitor.getConfigurationProperty("micronaut.openapi.server.context.path", context);
        if (serverContextPath == null) {
            serverContextPath = "";
        }
        String string = finalUrl = serverContextPath.startsWith("/") ? serverContextPath : "/" + serverContextPath;
        if (!finalUrl.endsWith("/")) {
            finalUrl = finalUrl + "/";
        }
        if ((contextPath = OpenApiApplicationVisitor.getConfigurationProperty("micronaut.server.context-path", context)) == null) {
            contextPath = "";
        }
        if (!(finalUrl = finalUrl + (contextPath.startsWith("/") ? contextPath.substring(1) : contextPath)).endsWith("/")) {
            finalUrl = finalUrl + "/";
        }
        finalUrl = finalUrl + rendererType.getTemplatePath();
        if (!(finalUrl = finalUrl + (finalUrl.endsWith("/") ? this.resourcesContextPath.substring(1) : this.resourcesContextPath)).endsWith("/")) {
            finalUrl = finalUrl + "/";
        }
        this.finalUrlPrefix = finalUrl;
        return finalUrl;
    }

    static <T extends AbstractViewConfig> T fromProperties(T cfg, Map<String, Object> defaultOptions, Map<String, String> properties) {
        String jsUrl;
        String copyResources = properties.get(cfg.prefix + "copy-resources");
        if (StringUtils.isNotEmpty((CharSequence)copyResources) && "false".equalsIgnoreCase(copyResources)) {
            cfg.copyResources = false;
        }
        if (StringUtils.isNotEmpty((CharSequence)(jsUrl = properties.get(cfg.prefix + "js.url")))) {
            cfg.jsUrl = jsUrl;
            cfg.isDefaultJsUrl = false;
        } else {
            String resourcesContextPath = properties.get(cfg.prefix + "resources.context.path");
            if (StringUtils.isNotEmpty((CharSequence)resourcesContextPath)) {
                cfg.resourcesContextPath = resourcesContextPath.startsWith("/") ? resourcesContextPath : "/" + resourcesContextPath;
            }
        }
        String templatePath = properties.get(cfg.prefix + "template.path");
        if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            cfg.templatePath = templatePath;
        }
        cfg.options.putAll(defaultOptions);
        properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(cfg.prefix)).forEach(cfg::addAttribute);
        return cfg;
    }

    static Object asBoolean(String v) {
        return Boolean.valueOf(v);
    }

    static Object asInt(String v) {
        return Integer.valueOf(v);
    }

    static Object asString(String v) {
        return v;
    }

    static Object asQuotedString(String v) {
        return v == null ? null : '\"' + v + '\"';
    }

    static class EnumConverter<T extends Enum<T>>
    implements Function<String, Object> {
        private final Class<T> type;

        EnumConverter(Class<T> type) {
            this.type = type;
        }

        @Override
        public Object apply(String v) {
            return v == null ? null : Enum.valueOf(this.type, v.toUpperCase(Locale.US));
        }
    }
}

