/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestBean;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIDecorator;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.TypeElementUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callbacks;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractOpenApiEndpointVisitor
extends AbstractOpenApiVisitor {
    public static final String COMPONENTS_CALLBACKS_PREFIX = "#/components/callbacks/";
    protected static final String CONTEXT_CHILD_PATH = "internal.child.path";
    protected static final String CONTEXT_CHILD_OP_ID_PREFIX = "internal.opId.prefix";
    protected static final String CONTEXT_CHILD_OP_ID_SUFFIX = "internal.opId.suffix";
    protected static final String CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS = "internal.opId.suffixes.add.always";
    protected static final String IS_PROCESS_PARENT_CLASS = "internal.is.process.parent";
    private static final TypeReference<Map<CharSequence, Object>> MAP_TYPE = new TypeReference<Map<CharSequence, Object>>(){};
    private static final int MAX_SUMMARY_LENGTH = 200;
    private static final String THREE_DOTS = "...";
    protected List<io.swagger.v3.oas.models.tags.Tag> classTags;
    protected ExternalDocumentation classExternalDocs;

    private static boolean isAnnotationPresent(Element element, String className) {
        return element.findAnnotation(className).isPresent();
    }

    private static RequestBody mergeRequestBody(RequestBody rq1, RequestBody rq2) {
        if (rq1.getRequired() == null) {
            rq1.setRequired(rq2.getRequired());
        }
        if (rq1.get$ref() == null) {
            rq1.set$ref(rq2.get$ref());
        }
        if (rq1.getDescription() == null) {
            rq1.setDescription(rq2.getDescription());
        }
        if (rq1.getExtensions() == null) {
            rq1.setExtensions(rq2.getExtensions());
        } else if (rq2.getExtensions() != null) {
            rq1.getExtensions().forEach((key, value) -> rq1.getExtensions().putIfAbsent(key, value));
        }
        if (rq1.getContent() == null) {
            rq1.setContent(rq2.getContent());
        } else if (rq2.getContent() != null) {
            Content c1 = rq1.getContent();
            Content c2 = rq2.getContent();
            c2.forEach((arg_0, arg_1) -> c1.putIfAbsent(arg_0, arg_1));
        }
        return rq1;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (this.ignore(element, context)) {
            return;
        }
        this.incrementVisitedElements(context);
        this.processSecuritySchemes(element, context);
        this.processTags(element, context);
        this.processExternalDocs(element, context);
        context.remove((CharSequence)CONTEXT_CHILD_PATH);
        if (element.isAnnotationPresent(Controller.class)) {
            String url = element.stringValue(UriMapping.class).orElse(null);
            if (url != null) {
                context.put((CharSequence)CONTEXT_CHILD_PATH, (Object)url);
            }
            String prefix = "";
            String suffix = "";
            boolean addAlways = true;
            AnnotationValue apiDecorator = element.getDeclaredAnnotation(OpenAPIDecorator.class);
            if (apiDecorator != null) {
                prefix = apiDecorator.stringValue().orElse("");
                suffix = apiDecorator.stringValue("opIdSuffix").orElse("");
                addAlways = apiDecorator.booleanValue("addAlways").orElse(true);
            }
            context.put((CharSequence)CONTEXT_CHILD_OP_ID_PREFIX, (Object)prefix);
            context.put((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX, (Object)suffix);
            context.put((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS, (Object)addAlways);
            ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
            Collection parentInterfaces = element.getInterfaces();
            if (element.isInterface() && !parentInterfaces.isEmpty()) {
                for (ClassElement parentInterface : parentInterfaces) {
                    if (ClassUtils.isJavaLangType((String)parentInterface.getName())) continue;
                    superTypes.add(parentInterface);
                }
            } else {
                element.getSuperType().ifPresent(superTypes::add);
            }
            if (CollectionUtils.isNotEmpty(superTypes)) {
                context.put((CharSequence)IS_PROCESS_PARENT_CLASS, (Object)true);
                List methods = element.getEnclosedElements(ElementQuery.ALL_METHODS);
                for (MethodElement method : methods) {
                    this.visitMethod(method, context);
                }
                context.remove((CharSequence)IS_PROCESS_PARENT_CLASS);
            }
            context.remove((CharSequence)CONTEXT_CHILD_OP_ID_PREFIX);
            context.remove((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX);
            context.remove((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS);
        }
    }

    private void processTags(ClassElement element, VisitorContext context) {
        this.classTags = this.readTags(element, context);
        List<io.swagger.v3.oas.models.tags.Tag> userDefinedClassTags = this.classTags(element, context);
        if (this.classTags == null || this.classTags.isEmpty()) {
            this.classTags = userDefinedClassTags == null ? Collections.emptyList() : userDefinedClassTags;
        } else if (userDefinedClassTags != null) {
            for (io.swagger.v3.oas.models.tags.Tag tag : userDefinedClassTags) {
                if (this.containsTag(tag.getName(), this.classTags)) continue;
                this.classTags.add(tag);
            }
        }
    }

    private void processExternalDocs(ClassElement element, VisitorContext context) {
        Optional externalDocsAnn = element.findAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        this.classExternalDocs = externalDocsAnn.flatMap(o -> this.toValue(o.getValues(), context, ExternalDocumentation.class)).orElse(null);
    }

    private boolean containsTag(String name, List<io.swagger.v3.oas.models.tags.Tag> tags) {
        return tags.stream().anyMatch(tag -> name.equals(tag.getName()));
    }

    protected abstract List<SecurityRequirement> methodSecurityRequirements(MethodElement var1, VisitorContext var2);

    protected abstract List<Server> methodServers(MethodElement var1, VisitorContext var2);

    protected abstract List<io.swagger.v3.oas.models.tags.Tag> classTags(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(MethodElement var1, VisitorContext var2);

    protected abstract HttpMethod httpMethod(MethodElement var1);

    protected abstract List<UriMatchTemplate> uriMatchTemplates(MethodElement var1, VisitorContext var2);

    protected abstract List<io.micronaut.http.MediaType> consumesMediaTypes(MethodElement var1);

    protected abstract List<io.micronaut.http.MediaType> producesMediaTypes(MethodElement var1);

    protected abstract String description(MethodElement var1);

    private boolean hasNoBindingAnnotationOrType(TypedElement parameter) {
        return !parameter.isAnnotationPresent(io.swagger.v3.oas.annotations.parameters.RequestBody.class) && !parameter.isAnnotationPresent(QueryValue.class) && !parameter.isAnnotationPresent(PathVariable.class) && !parameter.isAnnotationPresent(Body.class) && !parameter.isAnnotationPresent(Part.class) && !parameter.isAnnotationPresent(CookieValue.class) && !parameter.isAnnotationPresent(Header.class) && !parameter.isAnnotationPresent(RequestBean.class) && !this.isResponseType(parameter.getType());
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        Optional<RequestBody> requestBody;
        if (this.ignore(element, context)) {
            return;
        }
        HttpMethod httpMethod = this.httpMethod(element);
        if (httpMethod == null) {
            return;
        }
        List<UriMatchTemplate> matchTemplates = this.uriMatchTemplates(element, context);
        if (CollectionUtils.isEmpty(matchTemplates)) {
            return;
        }
        this.incrementVisitedElements(context);
        List<PathItem> pathItems = this.resolvePathItems(context, matchTemplates);
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        io.swagger.v3.oas.models.Operation swaggerOperation = this.readOperation(element, context);
        ExternalDocumentation externalDocs = this.readExternalDocs(element, context);
        if (externalDocs == null) {
            externalDocs = this.classExternalDocs;
        }
        if (externalDocs != null) {
            swaggerOperation.setExternalDocs(externalDocs);
        }
        this.readTags(element, context, swaggerOperation, this.classTags == null ? Collections.emptyList() : this.classTags, openAPI);
        this.readSecurityRequirements(element, context, swaggerOperation);
        this.readApiResponses(element, context, swaggerOperation);
        this.readServers(element, context, swaggerOperation);
        this.readCallbacks(element, context, swaggerOperation);
        JavadocDescription javadocDescription = this.getMethodDescription(element, swaggerOperation);
        if (element.isAnnotationPresent(Deprecated.class)) {
            swaggerOperation.setDeprecated(Boolean.valueOf(true));
        }
        this.readResponse(element, context, openAPI, swaggerOperation, javadocDescription);
        boolean permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        if (permitsRequestBody && (requestBody = this.readSwaggerRequestBody((Element)element, context)).isPresent()) {
            RequestBody currentRequestBody = swaggerOperation.getRequestBody();
            if (currentRequestBody != null) {
                swaggerOperation.setRequestBody(AbstractOpenApiEndpointVisitor.mergeRequestBody(currentRequestBody, requestBody.get()));
            } else {
                swaggerOperation.setRequestBody(requestBody.get());
            }
        }
        ArrayList<io.swagger.v3.oas.models.Operation> swaggerOperations = new ArrayList<io.swagger.v3.oas.models.Operation>(pathItems.size());
        int i = 0;
        for (PathItem pathItem : pathItems) {
            if (i == 0) {
                swaggerOperation = this.setOperationOnPathItem(pathItem, swaggerOperation, httpMethod);
                swaggerOperations.add(swaggerOperation);
            } else {
                io.swagger.v3.oas.models.Operation copyOperation = new io.swagger.v3.oas.models.Operation();
                copyOperation.setTags(swaggerOperation.getTags());
                copyOperation.setSummary(swaggerOperation.getSummary());
                copyOperation.setDescription(swaggerOperation.getDescription());
                copyOperation.setExternalDocs(swaggerOperation.getExternalDocs());
                copyOperation.setOperationId(swaggerOperation.getOperationId());
                copyOperation.setParameters(swaggerOperation.getParameters());
                copyOperation.setRequestBody(swaggerOperation.getRequestBody());
                copyOperation.setResponses(swaggerOperation.getResponses());
                copyOperation.setCallbacks(swaggerOperation.getCallbacks());
                copyOperation.setDeprecated(swaggerOperation.getDeprecated());
                copyOperation.setSecurity(swaggerOperation.getSecurity());
                copyOperation.setServers(swaggerOperation.getServers());
                copyOperation.setExtensions(swaggerOperation.getExtensions());
                copyOperation = this.setOperationOnPathItem(pathItem, copyOperation, httpMethod);
                swaggerOperations.add(copyOperation);
            }
            ++i;
        }
        HashMap<String, UriMatchVariable> pathVariables = new HashMap<String, UriMatchVariable>();
        for (UriMatchTemplate matchTemplate : matchTemplates) {
            pathVariables.putAll(this.pathVariables(matchTemplate));
            this.processParameterAnnotationInMethod(element, openAPI, matchTemplate, httpMethod);
        }
        List<io.micronaut.http.MediaType> list = this.consumesMediaTypes(element);
        ArrayList<TypedElement> extraBodyParameters = new ArrayList<TypedElement>();
        for (io.swagger.v3.oas.models.Operation operation : swaggerOperations) {
            this.processParameters(element, context, openAPI, operation, javadocDescription, permitsRequestBody, pathVariables, list, extraBodyParameters);
            this.processExtraBodyParameters(context, httpMethod, openAPI, operation, javadocDescription, list, extraBodyParameters);
        }
    }

    private void processExtraBodyParameters(VisitorContext context, HttpMethod httpMethod, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, List<io.micronaut.http.MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters) {
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod) && !extraBodyParameters.isEmpty() && requestBody == null) {
            requestBody = new RequestBody();
            Content content = new Content();
            requestBody.setContent(content);
            requestBody.setRequired(Boolean.valueOf(true));
            swaggerOperation.setRequestBody(requestBody);
            consumesMediaTypes = consumesMediaTypes.isEmpty() ? Utils.DEFAULT_MEDIA_TYPES : consumesMediaTypes;
            consumesMediaTypes.forEach(mediaType -> {
                MediaType mt = new MediaType();
                mt.setSchema((Schema)new ObjectSchema());
                content.addMediaType(mediaType.toString(), mt);
            });
        }
        if (requestBody != null && !extraBodyParameters.isEmpty()) {
            requestBody.getContent().forEach((mediaTypeName, mediaType) -> {
                Schema schema = mediaType.getSchema();
                if (schema.get$ref() != null) {
                    ComposedSchema composedSchema = new ComposedSchema();
                    Schema extraBodyParametersSchema = new Schema();
                    composedSchema.addAllOfItem(schema);
                    composedSchema.addAllOfItem(extraBodyParametersSchema);
                    schema = extraBodyParametersSchema;
                    mediaType.setSchema((Schema)composedSchema);
                }
                for (TypedElement parameter : extraBodyParameters) {
                    this.processBodyParameter(context, openAPI, javadocDescription, io.micronaut.http.MediaType.of((String)mediaTypeName), schema, parameter);
                }
            });
        }
    }

    private void processParameters(MethodElement element, VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<io.micronaut.http.MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters) {
        if (ArrayUtils.isEmpty((Object[])element.getParameters())) {
            return;
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters = swaggerOperation.getParameters();
        if (CollectionUtils.isEmpty((Collection)swaggerParameters)) {
            swaggerParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        }
        for (ParameterElement parameter : element.getParameters()) {
            if (this.alreadyProcessedParameter(swaggerParameters, parameter)) continue;
            this.processParameter(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, (TypedElement)parameter, extraBodyParameters);
        }
        if (CollectionUtils.isNotEmpty(swaggerParameters)) {
            swaggerOperation.setParameters(swaggerParameters);
        }
    }

    private boolean alreadyProcessedParameter(List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, ParameterElement parameter) {
        return swaggerParameters.stream().anyMatch(p -> p.getName().equals(parameter.getName()));
    }

    private void processParameterAnnotationInMethod(MethodElement element, OpenAPI openAPI, UriMatchTemplate matchTemplate, HttpMethod httpMethod) {
        List parameterAnnotations = element.getDeclaredAnnotationValuesByType(Parameter.class);
        for (AnnotationValue paramAnn : parameterAnnotations) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameter.schema(new Schema());
            paramAnn.stringValue("name").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).name(arg_0));
            paramAnn.enumValue("in", ParameterIn.class).ifPresent(in -> parameter.in(in.toString()));
            paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).description(arg_0));
            paramAnn.booleanValue("required").ifPresent(value -> parameter.setRequired(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("deprecated").ifPresent(value -> parameter.setDeprecated(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("allowEmptyValue").ifPresent(value -> parameter.setAllowEmptyValue(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("allowReserved").ifPresent(value -> parameter.setAllowReserved(value != false ? Boolean.valueOf(true) : null));
            paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).example(arg_0));
            paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).$ref(arg_0));
            paramAnn.enumValue("style", ParameterStyle.class).ifPresent(style -> parameter.setStyle(this.paramStyle((ParameterStyle)style)));
            PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)matchTemplate.toPathString());
            switch (httpMethod) {
                case GET: {
                    pathItem.getGet().addParametersItem(parameter);
                    break;
                }
                case POST: {
                    pathItem.getPost().addParametersItem(parameter);
                    break;
                }
                case PUT: {
                    pathItem.getPut().addParametersItem(parameter);
                    break;
                }
                case DELETE: {
                    pathItem.getDelete().addParametersItem(parameter);
                    break;
                }
                case PATCH: {
                    pathItem.getPatch().addParametersItem(parameter);
                    break;
                }
            }
        }
    }

    private void processParameter(VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters) {
        ClassElement parameterType = parameter.getGenericType();
        if (this.ignoreParameter(parameter)) {
            return;
        }
        if (permitsRequestBody && swaggerOperation.getRequestBody() == null) {
            this.readSwaggerRequestBody((Element)parameter, context).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)swaggerOperation).setRequestBody(arg_0));
        }
        List<io.micronaut.http.MediaType> list = consumesMediaTypes = CollectionUtils.isNotEmpty(consumesMediaTypes) ? consumesMediaTypes : Utils.DEFAULT_MEDIA_TYPES;
        if (parameter.isAnnotationPresent(Body.class)) {
            this.processBody(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, consumesMediaTypes, parameter, parameterType);
            RequestBody requestBody = swaggerOperation.getRequestBody();
            if (requestBody != null && requestBody.getContent() != null) {
                for (Map.Entry entry : requestBody.getContent().entrySet()) {
                    boolean found = false;
                    for (io.micronaut.http.MediaType mediaType : consumesMediaTypes) {
                        if (!((String)entry.getKey()).equals(mediaType.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    MediaType mediaType = (MediaType)entry.getValue();
                    Schema propertySchema = this.bindSchemaForElement(context, parameter, parameterType, mediaType.getSchema());
                    String bodyAnnValue = parameter.getAnnotation(Body.class).getValue(String.class).orElse(null);
                    if (!StringUtils.isNotEmpty((CharSequence)bodyAnnValue)) continue;
                    ObjectSchema wrapperSchema = new ObjectSchema();
                    if (this.isElementNotNullable((Element)parameter, (Element)parameterType)) {
                        wrapperSchema.addRequiredItem(bodyAnnValue);
                    }
                    wrapperSchema.addProperty(bodyAnnValue, propertySchema);
                    mediaType.setSchema((Schema)wrapperSchema);
                }
            }
            return;
        }
        if (parameter.isAnnotationPresent(RequestBean.class)) {
            this.processRequestBean(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, parameter, extraBodyParameters);
            return;
        }
        io.swagger.v3.oas.models.parameters.Parameter newParameter = this.processMethodParameterAnnotation(context, permitsRequestBody, pathVariables, parameter, extraBodyParameters);
        if (newParameter == null) {
            return;
        }
        if (newParameter.getExplode() != null && newParameter.getExplode().booleanValue() && "query".equals(newParameter.getIn()) && !parameterType.isIterable()) {
            Schema explodedSchema = this.resolveSchema(openAPI, (Element)parameter, parameterType, context, consumesMediaTypes, null, null);
            if (explodedSchema != null) {
                if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null && StringUtils.isNotEmpty((CharSequence)explodedSchema.get$ref())) {
                    explodedSchema = (Schema)openAPI.getComponents().getSchemas().get(explodedSchema.get$ref().substring("#/components/schemas/".length()));
                }
                if (CollectionUtils.isNotEmpty((Map)explodedSchema.getProperties())) {
                    Map props = explodedSchema.getProperties();
                    for (Map.Entry entry : props.entrySet()) {
                        QueryParameter unwrappedParameter = new QueryParameter();
                        if (CollectionUtils.isNotEmpty((Collection)explodedSchema.getRequired()) && explodedSchema.getRequired().contains(entry.getKey())) {
                            unwrappedParameter.setRequired(Boolean.valueOf(true));
                        }
                        unwrappedParameter.setName((String)entry.getKey());
                        unwrappedParameter.setSchema((Schema)entry.getValue());
                        swaggerParameters.add((io.swagger.v3.oas.models.parameters.Parameter)unwrappedParameter);
                    }
                }
            }
        } else {
            CharSequence desc;
            if (StringUtils.isEmpty((CharSequence)newParameter.getName())) {
                newParameter.setName(parameter.getName());
            }
            if (newParameter.getRequired() == null && !TypeElementUtils.isNullable(parameter)) {
                newParameter.setRequired(Boolean.valueOf(true));
            }
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)newParameter.getDescription()) && (desc = (CharSequence)javadocDescription.getParameters().get(parameter.getName())) != null) {
                newParameter.setDescription(desc.toString());
            }
            swaggerParameters.add(newParameter);
            Schema schema = newParameter.getSchema();
            if (schema == null) {
                schema = this.resolveSchema(openAPI, (Element)parameter, parameterType, context, consumesMediaTypes, null, null);
            }
            if (schema != null) {
                schema = this.bindSchemaForElement(context, parameter, parameterType, schema);
                newParameter.setSchema(schema);
            }
        }
    }

    private void processBodyParameter(VisitorContext context, OpenAPI openAPI, JavadocDescription javadocDescription, io.micronaut.http.MediaType mediaType, Schema schema, TypedElement parameter) {
        Schema propertySchema = this.resolveSchema(openAPI, (Element)parameter, parameter.getType(), context, Collections.singletonList(mediaType), null, null);
        if (propertySchema != null) {
            String doc;
            Optional description = parameter.getValue(Parameter.class, "description", String.class);
            description.ifPresent(arg_0 -> ((Schema)propertySchema).setDescription(arg_0));
            this.processSchemaProperty(context, parameter, parameter.getType(), null, schema, propertySchema);
            if (TypeElementUtils.isNullable(parameter)) {
                propertySchema.setNullable(Boolean.valueOf(true));
            }
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)propertySchema.getDescription()) && (doc = javadocDescription.getParameters().get(parameter.getName())) != null) {
                propertySchema.setDescription(doc);
            }
        }
    }

    private io.swagger.v3.oas.models.parameters.Parameter processMethodParameterAnnotation(VisitorContext context, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, TypedElement parameter, List<TypedElement> extraBodyParameters) {
        AnnotationValue paramAnn;
        AnnotationValue parameterAnnotation;
        QueryParameter newParameter = null;
        String parameterName = parameter.getName();
        if (!parameter.hasStereotype(Bindable.class) && pathVariables.containsKey(parameterName)) {
            UriMatchVariable urlVar = pathVariables.get(parameterName);
            newParameter = urlVar.isQuery() ? new QueryParameter() : new PathParameter();
            newParameter.setName(parameterName);
            boolean exploded = urlVar.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(exploded));
            }
        } else if (parameter.isAnnotationPresent(PathVariable.class)) {
            String paramName = parameter.getValue(PathVariable.class, String.class).orElse(parameterName);
            UriMatchVariable variable = pathVariables.get(paramName);
            if (variable == null) {
                context.fail("Path variable name: '" + paramName + "' not found in path.", (Element)parameter);
                return null;
            }
            newParameter = new PathParameter();
            newParameter.setName(paramName);
            boolean exploded = variable.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(exploded));
            }
        } else if (parameter.isAnnotationPresent(Header.class)) {
            String headerName = parameter.getValue(Header.class, "name", String.class).orElse(parameter.getValue(Header.class, String.class).orElseGet(() -> NameUtils.hyphenate((String)parameterName)));
            if ("Authorization".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName) || "Accept".equalsIgnoreCase(headerName)) {
                return null;
            }
            newParameter = new HeaderParameter();
            newParameter.setName(headerName);
        } else if (parameter.isAnnotationPresent(CookieValue.class)) {
            String cookieName = parameter.getValue(CookieValue.class, String.class).orElse(parameterName);
            newParameter = new CookieParameter();
            newParameter.setName(cookieName);
        } else if (parameter.isAnnotationPresent(QueryValue.class)) {
            String queryVar = parameter.getValue(QueryValue.class, String.class).orElse(parameterName);
            newParameter = new QueryParameter();
            newParameter.setName(queryVar);
        } else if (parameter.isAnnotationPresent(Part.class) && permitsRequestBody) {
            extraBodyParameters.add(parameter);
        } else if (parameter.hasAnnotation("io.micronaut.management.endpoint.annotation.Selector")) {
            newParameter = new PathParameter();
            newParameter.setName(parameterName);
        } else if (this.hasNoBindingAnnotationOrType(parameter) && ((parameterAnnotation = parameter.getAnnotation(Parameter.class)) == null || !parameterAnnotation.booleanValue("hidden").orElse(false).booleanValue() && !parameterAnnotation.stringValue("in").isPresent())) {
            if (permitsRequestBody) {
                extraBodyParameters.add(parameter);
            } else {
                newParameter = new QueryParameter();
                newParameter.setName(parameterName);
            }
        }
        if (parameter.isAnnotationPresent(Parameter.class) && (paramAnn = (AnnotationValue)parameter.findAnnotation(Parameter.class).orElse(null)) != null) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) {
                return null;
            }
            Map<CharSequence, Object> paramValues = this.toValueMap(paramAnn.getValues(), context);
            Utils.normalizeEnumValues(paramValues, Collections.singletonMap("in", ParameterIn.class));
            if (parameter.isAnnotationPresent(Header.class)) {
                paramValues.put("in", ParameterIn.HEADER.toString());
            } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                paramValues.put("in", ParameterIn.COOKIE.toString());
            } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                paramValues.put("in", ParameterIn.QUERY.toString());
            }
            this.processExplode((AnnotationValue<Parameter>)paramAnn, paramValues);
            JsonNode jsonNode = ConvertUtils.getJsonMapper().valueToTree(paramValues);
            if (newParameter == null) {
                try {
                    JsonNode schemaNode;
                    newParameter = ConvertUtils.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class, context);
                    if (jsonNode.has("schema") && (schemaNode = jsonNode.get("schema")).has("$ref")) {
                        if (newParameter == null) {
                            newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                        }
                        newParameter.schema(new Schema().$ref(schemaNode.get("$ref").asText()));
                    }
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                }
            } else {
                try {
                    io.swagger.v3.oas.models.parameters.Parameter v = ConvertUtils.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class, context);
                    if (v == null) {
                        Map target = (Map)ConvertUtils.getConvertJsonMapper().convertValue((Object)newParameter, MAP_TYPE);
                        for (CharSequence name : paramValues.keySet()) {
                            Object o = paramValues.get(name.toString());
                            target.put(name.toString(), o);
                        }
                        newParameter = (io.swagger.v3.oas.models.parameters.Parameter)ConvertUtils.getConvertJsonMapper().convertValue((Object)target, io.swagger.v3.oas.models.parameters.Parameter.class);
                    } else {
                        BeanMap beanMap = BeanMap.of((Object)v);
                        BeanMap target = BeanMap.of((Object)newParameter);
                        for (CharSequence name : paramValues.keySet()) {
                            Object o = beanMap.get((Object)name.toString());
                            target.put((Object)name.toString(), o);
                        }
                    }
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                }
            }
            if (newParameter != null) {
                AnnotationValue schemaAnn;
                Schema parameterSchema = newParameter.getSchema();
                if (paramAnn.contains("schema") && parameterSchema != null && (schemaAnn = (AnnotationValue)paramAnn.get((CharSequence)"schema", AnnotationValue.class).orElse(null)) != null) {
                    this.bindSchemaAnnotationValue(context, (Element)parameter, parameterSchema, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
                }
            }
        }
        if (newParameter != null && TypeElementUtils.isNullable(parameter)) {
            newParameter.setRequired(null);
        }
        return newParameter;
    }

    private void processBody(VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, List<io.micronaut.http.MediaType> consumesMediaTypes, TypedElement parameter, ClassElement parameterType) {
        CharSequence desc;
        if (!permitsRequestBody) {
            return;
        }
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (requestBody == null) {
            requestBody = new RequestBody();
            swaggerOperation.setRequestBody(requestBody);
        }
        if (requestBody.getDescription() == null && javadocDescription != null && (desc = (CharSequence)javadocDescription.getParameters().get(parameter.getName())) != null) {
            requestBody.setDescription(desc.toString());
        }
        if (requestBody.getRequired() == null && !TypeElementUtils.isNullable((TypedElement)parameterType)) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
        Content content = this.buildContent((Element)parameter, parameterType, consumesMediaTypes, openAPI, context);
        if (requestBody.getContent() == null) {
            requestBody.setContent(content);
        } else {
            Content currentContent = requestBody.getContent();
            for (Map.Entry entry : content.entrySet()) {
                MediaType mediaType = (MediaType)entry.getValue();
                MediaType existedMediaType = (MediaType)currentContent.get(entry.getKey());
                if (existedMediaType == null) {
                    currentContent.put((Object)((String)entry.getKey()), (Object)mediaType);
                    continue;
                }
                if (existedMediaType.getSchema() == null) {
                    existedMediaType.setSchema(mediaType.getSchema());
                }
                if (existedMediaType.getEncoding() == null) {
                    existedMediaType.setEncoding(mediaType.getEncoding());
                }
                if (existedMediaType.getExtensions() == null) {
                    existedMediaType.setExtensions(mediaType.getExtensions());
                }
                if (existedMediaType.getExamples() == null) {
                    existedMediaType.setExamples(mediaType.getExamples());
                }
                if (existedMediaType.getExample() != null || !mediaType.getExampleSetFlag()) continue;
                existedMediaType.setExample(mediaType.getExample());
            }
        }
    }

    private void processRequestBean(VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters) {
        for (FieldElement field : parameter.getType().getFields()) {
            if (field.isStatic()) continue;
            this.processParameter(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, (TypedElement)field, extraBodyParameters);
        }
    }

    private void readResponse(MethodElement element, VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription) {
        boolean withMethodResponses = element.hasDeclaredAnnotation(io.swagger.v3.oas.annotations.responses.ApiResponse.class) || element.hasDeclaredAnnotation(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        HttpStatus methodResponseStatus = element.enumValue(Status.class, HttpStatus.class).orElse(HttpStatus.OK);
        String responseCode = String.valueOf(methodResponseStatus.getCode());
        ApiResponses responses = swaggerOperation.getResponses();
        ApiResponse response = null;
        if (responses == null) {
            responses = new ApiResponses();
            swaggerOperation.setResponses(responses);
        } else {
            ApiResponse defaultResponse = (ApiResponse)responses.remove((Object)"default");
            response = (ApiResponse)responses.get((Object)responseCode);
            if (response == null && defaultResponse != null) {
                response = defaultResponse;
                responses.put((Object)responseCode, (Object)response);
            }
        }
        if (response == null && !withMethodResponses) {
            response = new ApiResponse();
            if (javadocDescription == null || StringUtils.isEmpty((CharSequence)javadocDescription.getReturnDescription())) {
                response.setDescription(swaggerOperation.getOperationId() + " " + responseCode + " response");
            } else {
                response.setDescription(javadocDescription.getReturnDescription());
            }
            this.addResponseContent(element, context, openAPI, response);
            responses.put((Object)responseCode, (Object)response);
        } else if (response != null && response.getContent() == null) {
            this.addResponseContent(element, context, openAPI, response);
        }
    }

    private void addResponseContent(MethodElement element, VisitorContext context, OpenAPI openAPI, ApiResponse response) {
        ClassElement returnType = this.returnType(element, context);
        if (returnType != null && !returnType.getCanonicalName().equals(Void.class.getName())) {
            List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
            Content content = producesMediaTypes.isEmpty() ? this.buildContent((Element)element, returnType, Utils.DEFAULT_MEDIA_TYPES, openAPI, context) : this.buildContent((Element)element, returnType, producesMediaTypes, openAPI, context);
            response.setContent(content);
        }
    }

    private ClassElement returnType(MethodElement element, VisitorContext context) {
        ClassElement returnType = element.getGenericReturnType();
        if (this.isVoid(returnType) || this.isReactiveAndVoid(returnType)) {
            returnType = null;
        } else if (this.isResponseType(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        } else if (this.isSingleResponseType(returnType)) {
            returnType = (ClassElement)returnType.getFirstTypeArgument().get();
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        }
        return returnType;
    }

    private Map<String, UriMatchVariable> pathVariables(UriMatchTemplate matchTemplate) {
        List pv = matchTemplate.getVariables();
        LinkedHashMap<String, UriMatchVariable> pathVariables = new LinkedHashMap<String, UriMatchVariable>(pv.size());
        for (UriMatchVariable variable : pv) {
            pathVariables.put(variable.getName(), variable);
        }
        return pathVariables;
    }

    private JavadocDescription getMethodDescription(MethodElement element, io.swagger.v3.oas.models.Operation swaggerOperation) {
        String descr = this.description(element);
        if (StringUtils.isNotEmpty((CharSequence)descr) && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
            swaggerOperation.setDescription(descr);
            String summary = descr.substring(0, descr.indexOf(46) + 1);
            if (summary.length() > 200) {
                summary = summary.substring(0, 200) + THREE_DOTS;
            }
            swaggerOperation.setSummary(summary);
        }
        JavadocDescription javadocDescription = element.getDocumentation().map(Utils.getJavadocParser()::parse).orElse(null);
        if (javadocDescription != null) {
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription()) && StringUtils.hasText((CharSequence)javadocDescription.getMethodDescription())) {
                swaggerOperation.setDescription(javadocDescription.getMethodDescription());
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getSummary()) && StringUtils.hasText((CharSequence)javadocDescription.getMethodSummary())) {
                swaggerOperation.setSummary(javadocDescription.getMethodSummary());
            }
        }
        return javadocDescription;
    }

    private io.swagger.v3.oas.models.Operation readOperation(MethodElement element, VisitorContext context) {
        boolean addAlways;
        String suffix;
        String prefix;
        AnnotationValue apiDecorator;
        List params;
        Object[] methodParams;
        Optional operationAnnotation = element.findAnnotation(Operation.class);
        io.swagger.v3.oas.models.Operation swaggerOperation = operationAnnotation.flatMap(o -> this.toValue(o.getValues(), context, io.swagger.v3.oas.models.Operation.class)).orElse(new io.swagger.v3.oas.models.Operation());
        if (CollectionUtils.isNotEmpty((Collection)swaggerOperation.getParameters())) {
            swaggerOperation.getParameters().removeIf(Objects::isNull);
        }
        if (ArrayUtils.isNotEmpty((Object[])(methodParams = element.getParameters())) && operationAnnotation.isPresent() && CollectionUtils.isNotEmpty((Collection)(params = ((AnnotationValue)operationAnnotation.get()).getAnnotations("parameters", Parameter.class)))) {
            for (Object methodParam : methodParams) {
                Optional allowReserved;
                Optional allowEmptyValue;
                Optional deprecated;
                AnnotationValue paramAnn = null;
                for (AnnotationValue param : params) {
                    String paramName = param.stringValue("name").orElse(null);
                    if (!methodParam.getName().equals(paramName)) continue;
                    paramAnn = param;
                    break;
                }
                if (paramAnn == null || paramAnn.booleanValue("hidden").orElse(false).booleanValue()) continue;
                io.swagger.v3.oas.models.parameters.Parameter swaggerParam = null;
                String paramName = paramAnn.stringValue("name").orElse(null);
                if (paramName != null && CollectionUtils.isNotEmpty((Collection)swaggerOperation.getParameters())) {
                    for (io.swagger.v3.oas.models.parameters.Parameter createdParameter : swaggerOperation.getParameters()) {
                        if (!createdParameter.getName().equals(paramName)) continue;
                        swaggerParam = createdParameter;
                        break;
                    }
                }
                if (swaggerParam == null) {
                    if (swaggerOperation.getParameters() == null) {
                        swaggerOperation.setParameters(new ArrayList());
                    }
                    swaggerParam = new io.swagger.v3.oas.models.parameters.Parameter();
                    swaggerOperation.getParameters().add(swaggerParam);
                }
                if (paramName != null) {
                    swaggerParam.setName(paramName);
                }
                paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).setDescription(arg_0));
                Optional required = paramAnn.booleanValue("required");
                if (required.isPresent()) {
                    swaggerParam.setRequired((Boolean)required.get() != false ? Boolean.valueOf(true) : null);
                }
                if ((deprecated = paramAnn.booleanValue("deprecated")).isPresent()) {
                    swaggerParam.setDeprecated((Boolean)deprecated.get() != false ? Boolean.valueOf(true) : null);
                }
                if ((allowEmptyValue = paramAnn.booleanValue("allowEmptyValue")).isPresent()) {
                    swaggerParam.setAllowEmptyValue((Boolean)allowEmptyValue.get() != false ? Boolean.valueOf(true) : null);
                }
                if ((allowReserved = paramAnn.booleanValue("allowReserved")).isPresent()) {
                    swaggerParam.setAllowReserved((Boolean)allowReserved.get() != false ? Boolean.valueOf(true) : null);
                }
                paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).setExample(arg_0));
                Optional style = paramAnn.get((CharSequence)"style", ParameterStyle.class);
                if (style.isPresent()) {
                    swaggerParam.setStyle(this.paramStyle((ParameterStyle)style.get()));
                }
                paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).set$ref(arg_0));
                Optional in = paramAnn.get((CharSequence)"in", ParameterIn.class);
                if (!in.isPresent()) continue;
                if (in.get() == ParameterIn.DEFAULT) {
                    swaggerParam.setIn(this.calcIn((ParameterElement)methodParam));
                    continue;
                }
                swaggerParam.setIn(((ParameterIn)in.get()).toString());
            }
        }
        if ((apiDecorator = element.getDeclaredAnnotation(OpenAPIDecorator.class)) != null) {
            prefix = apiDecorator.stringValue().orElse("");
            suffix = apiDecorator.stringValue("opIdSuffix").orElse("");
            addAlways = apiDecorator.booleanValue("addAlways").orElse(true);
        } else {
            prefix = context.get((CharSequence)CONTEXT_CHILD_OP_ID_PREFIX, String.class).orElse("");
            suffix = context.get((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX, String.class).orElse("");
            addAlways = context.get((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS, Boolean.class).orElse(true);
        }
        if (StringUtils.isEmpty((CharSequence)swaggerOperation.getOperationId())) {
            swaggerOperation.setOperationId(prefix + element.getName() + suffix);
        } else if (addAlways) {
            swaggerOperation.setOperationId(prefix + swaggerOperation.getOperationId() + suffix);
        }
        if (swaggerOperation.getDescription() != null && swaggerOperation.getDescription().isEmpty()) {
            swaggerOperation.setDescription(null);
        }
        return swaggerOperation;
    }

    private String calcIn(ParameterElement methodParam) {
        Set paramAnnNames = methodParam.getAnnotationNames();
        if (CollectionUtils.isNotEmpty((Collection)paramAnnNames)) {
            if (paramAnnNames.contains(QueryValue.class.getName())) {
                return ParameterIn.QUERY.toString();
            }
            if (paramAnnNames.contains(PathVariable.class.getName())) {
                return ParameterIn.PATH.toString();
            }
            if (paramAnnNames.contains(Header.class.getName())) {
                return ParameterIn.HEADER.toString();
            }
            if (paramAnnNames.contains(CookieValue.class.getName())) {
                return ParameterIn.COOKIE.toString();
            }
        }
        return null;
    }

    private Parameter.StyleEnum paramStyle(ParameterStyle paramAnnStyle) {
        if (paramAnnStyle == null) {
            return null;
        }
        switch (paramAnnStyle) {
            case MATRIX: {
                return Parameter.StyleEnum.MATRIX;
            }
            case LABEL: {
                return Parameter.StyleEnum.LABEL;
            }
            case FORM: {
                return Parameter.StyleEnum.FORM;
            }
            case SPACEDELIMITED: {
                return Parameter.StyleEnum.SPACEDELIMITED;
            }
            case PIPEDELIMITED: {
                return Parameter.StyleEnum.PIPEDELIMITED;
            }
            case DEEPOBJECT: {
                return Parameter.StyleEnum.DEEPOBJECT;
            }
            case SIMPLE: {
                return Parameter.StyleEnum.SIMPLE;
            }
        }
        return null;
    }

    private ExternalDocumentation readExternalDocs(MethodElement element, VisitorContext context) {
        Optional externalDocsAnn = element.findAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        ExternalDocumentation externalDocs = externalDocsAnn.flatMap(o -> this.toValue(o.getValues(), context, ExternalDocumentation.class)).orElse(null);
        return externalDocs;
    }

    private void readSecurityRequirements(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        for (SecurityRequirement securityItem : this.methodSecurityRequirements(element, context)) {
            swaggerOperation.addSecurityItem(securityItem);
        }
    }

    private void processExplode(AnnotationValue<Parameter> paramAnn, Map<CharSequence, Object> paramValues) {
        Optional explode = paramAnn.enumValue("explode", Explode.class);
        if (explode.isPresent()) {
            Explode ex = (Explode)explode.get();
            block0 : switch (ex) {
                case TRUE: {
                    paramValues.put("explode", Boolean.TRUE);
                    break;
                }
                case FALSE: {
                    paramValues.put("explode", Boolean.FALSE);
                    break;
                }
                default: {
                    String in = (String)paramValues.get("in");
                    if (in == null || in.isEmpty()) {
                        in = "DEFAULT";
                    }
                    switch (ParameterIn.valueOf((String)in.toUpperCase(Locale.US))) {
                        case COOKIE: 
                        case QUERY: {
                            paramValues.put("explode", Boolean.TRUE);
                            break block0;
                        }
                    }
                    paramValues.put("explode", Boolean.FALSE);
                }
            }
        }
    }

    private boolean ignoreParameter(TypedElement parameter) {
        AnnotationValue schemaAnn = parameter.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
        return isHidden || parameter.isAnnotationPresent(Hidden.class) || parameter.isAnnotationPresent(JsonIgnore.class) || parameter.booleanValue(Parameter.class, "hidden").orElse(false) != false || AbstractOpenApiEndpointVisitor.isAnnotationPresent((Element)parameter, "io.micronaut.session.annotation.SessionValue") || this.isIgnoredParameterType(parameter.getType());
    }

    private boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.session.Session") || parameterType.isAssignable("io.micronaut.security.authentication.Authentication") || parameterType.isAssignable("io.micronaut.http.HttpHeaders") || parameterType.isAssignable("kotlin.coroutines.Continuation") || parameterType.isAssignable(HttpRequest.class) || parameterType.isAssignable("io.micronaut.http.BasicAuth");
    }

    private boolean isResponseType(ClassElement returnType) {
        return returnType.isAssignable(HttpResponse.class) || returnType.isAssignable("org.springframework.http.HttpEntity");
    }

    private boolean isSingleResponseType(ClassElement returnType) {
        boolean assignable = returnType.isAssignable("io.reactivex.Single") || returnType.isAssignable("org.reactivestreams.Publisher");
        return assignable && returnType.getFirstTypeArgument().isPresent() && this.isResponseType((ClassElement)returnType.getFirstTypeArgument().get());
    }

    private boolean isVoid(ClassElement returnType) {
        return returnType.isAssignable(Void.TYPE) || returnType.isAssignable(Void.class) || returnType.isAssignable("kotlin.Unit");
    }

    private boolean isReactiveAndVoid(ClassElement returnType) {
        return returnType.isAssignable("io.reactivex.Completable") || Stream.of("reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "io.reactivex.Flowable", "io.reactivex.Maybe").anyMatch(t -> returnType.isAssignable(t) && returnType.getFirstTypeArgument().isPresent() && this.isVoid((ClassElement)returnType.getFirstTypeArgument().get()));
    }

    private io.swagger.v3.oas.models.Operation setOperationOnPathItem(PathItem pathItem, io.swagger.v3.oas.models.Operation swaggerOperation, HttpMethod httpMethod) {
        io.swagger.v3.oas.models.Operation operation = swaggerOperation;
        switch (httpMethod) {
            case GET: {
                if (pathItem.getGet() != null) {
                    operation = pathItem.getGet();
                    break;
                }
                pathItem.get(swaggerOperation);
                break;
            }
            case POST: {
                if (pathItem.getPost() != null) {
                    operation = pathItem.getPost();
                    break;
                }
                pathItem.post(swaggerOperation);
                break;
            }
            case PUT: {
                if (pathItem.getPut() != null) {
                    operation = pathItem.getPut();
                    break;
                }
                pathItem.put(swaggerOperation);
                break;
            }
            case PATCH: {
                if (pathItem.getPatch() != null) {
                    operation = pathItem.getPatch();
                    break;
                }
                pathItem.patch(swaggerOperation);
                break;
            }
            case DELETE: {
                if (pathItem.getDelete() != null) {
                    operation = pathItem.getDelete();
                    break;
                }
                pathItem.delete(swaggerOperation);
                break;
            }
            case HEAD: {
                if (pathItem.getHead() != null) {
                    operation = pathItem.getHead();
                    break;
                }
                pathItem.head(swaggerOperation);
                break;
            }
            case OPTIONS: {
                if (pathItem.getOptions() != null) {
                    operation = pathItem.getOptions();
                    break;
                }
                pathItem.options(swaggerOperation);
                break;
            }
            case TRACE: {
                if (pathItem.getTrace() != null) {
                    operation = pathItem.getTrace();
                    break;
                }
                pathItem.trace(swaggerOperation);
                break;
            }
            default: {
                operation = swaggerOperation;
            }
        }
        return operation;
    }

    private void readApiResponses(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        List classResponseAnnotations = element.getDeclaringType().getDeclaredAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        List methodResponseAnnotations = element.getDeclaredAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        this.processResponses(swaggerOperation, classResponseAnnotations, element, context);
        this.processResponses(swaggerOperation, methodResponseAnnotations, element, context);
    }

    private void processResponses(io.swagger.v3.oas.models.Operation operation, List<AnnotationValue<io.swagger.v3.oas.annotations.responses.ApiResponse>> responseAnnotations, MethodElement element, VisitorContext context) {
        ApiResponses apiResponses = operation.getResponses();
        if (apiResponses == null) {
            apiResponses = new ApiResponses();
            operation.setResponses(apiResponses);
        }
        if (CollectionUtils.isNotEmpty(responseAnnotations)) {
            for (AnnotationValue<io.swagger.v3.oas.annotations.responses.ApiResponse> response : responseAnnotations) {
                Optional<ApiResponse> newResponse = this.toValue(response.getValues(), context, ApiResponse.class);
                if (!newResponse.isPresent()) continue;
                ApiResponse newApiResponse = newResponse.get();
                if (response.booleanValue("useReturnTypeSchema").orElse(false).booleanValue() && element != null) {
                    this.addResponseContent(element, context, Utils.resolveOpenAPI(context), newApiResponse);
                } else {
                    Content newContent;
                    List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
                    Object[] contentAnns = response.get((CharSequence)"content", io.swagger.v3.oas.annotations.media.Content[].class).orElse(null);
                    ArrayList<String> mediaTypes = new ArrayList<String>();
                    if (ArrayUtils.isNotEmpty((Object[])contentAnns)) {
                        for (Object contentAnn : contentAnns) {
                            if (StringUtils.isNotEmpty((CharSequence)contentAnn.mediaType())) {
                                mediaTypes.add(contentAnn.mediaType());
                                continue;
                            }
                            mediaTypes.add("application/json");
                        }
                    }
                    if ((newContent = newApiResponse.getContent()) != null) {
                        MediaType defaultMediaType = (MediaType)newContent.get((Object)"application/json");
                        Content contentFromProduces = new Content();
                        for (String mt : mediaTypes) {
                            if (mt.equals("application/json")) {
                                for (io.micronaut.http.MediaType mediaType : producesMediaTypes) {
                                    contentFromProduces.put((Object)mediaType.toString(), (Object)defaultMediaType);
                                }
                                continue;
                            }
                            contentFromProduces.put((Object)mt, (Object)((MediaType)newContent.get((Object)mt)));
                        }
                        newApiResponse.setContent(contentFromProduces);
                    }
                }
                apiResponses.put((Object)response.get((CharSequence)"responseCode", String.class).orElse("default"), (Object)newApiResponse);
            }
            operation.setResponses(apiResponses);
        }
    }

    private Optional<RequestBody> readSwaggerRequestBody(Element element, VisitorContext context) {
        return element.findAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class).flatMap(annotation -> this.toValue(annotation.getValues(), context, RequestBody.class));
    }

    private void readServers(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        for (Server server : this.methodServers(element, context)) {
            swaggerOperation.addServersItem(server);
        }
    }

    private void readCallbacks(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        AnnotationValue callbacksAnnotation = element.getAnnotation(Callbacks.class);
        List callbackAnnotations = callbacksAnnotation != null ? callbacksAnnotation.getAnnotations("value") : element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.callbacks.Callback.class);
        if (CollectionUtils.isEmpty((Collection)callbackAnnotations)) {
            return;
        }
        for (AnnotationValue callbackAnn : callbackAnnotations) {
            Optional name = callbackAnn.stringValue("name");
            if (!name.isPresent()) continue;
            String callbackName = (String)name.get();
            Optional ref = callbackAnn.stringValue("ref");
            if (ref.isPresent()) {
                String refCallback = ((String)ref.get()).substring(COMPONENTS_CALLBACKS_PREFIX.length());
                this.processCallbackReference(context, swaggerOperation, callbackName, refCallback);
                continue;
            }
            Optional expr = callbackAnn.stringValue("callbackUrlExpression");
            if (expr.isPresent()) {
                this.processUrlCallbackExpression(context, swaggerOperation, (AnnotationValue<io.swagger.v3.oas.annotations.callbacks.Callback>)callbackAnn, callbackName, (String)expr.get());
                continue;
            }
            this.processCallbackReference(context, swaggerOperation, callbackName, null);
        }
    }

    private void processCallbackReference(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, String callbackName, String refCallback) {
        Components components = Utils.resolveComponents(Utils.resolveOpenAPI(context));
        Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
        Callback callbackRef = new Callback();
        if (refCallback != null) {
            callbackRef.set$ref(refCallback);
        } else {
            callbackRef.set$ref(COMPONENTS_CALLBACKS_PREFIX + callbackName);
        }
        callbacks.put(callbackName, callbackRef);
    }

    private void processUrlCallbackExpression(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, AnnotationValue<io.swagger.v3.oas.annotations.callbacks.Callback> callbackAnn, String callbackName, String callbackUrl) {
        List operations = callbackAnn.getAnnotations("operation", Operation.class);
        if (CollectionUtils.isEmpty((Collection)operations)) {
            Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
            Callback c = new Callback();
            c.addPathItem(callbackUrl, new PathItem());
            callbacks.put(callbackName, c);
        } else {
            PathItem pathItem = new PathItem();
            for (AnnotationValue operation : operations) {
                Optional operationMethod = operation.get((CharSequence)"method", HttpMethod.class);
                operationMethod.ifPresent(httpMethod -> this.toValue(operation.getValues(), context, io.swagger.v3.oas.models.Operation.class).ifPresent(op -> this.setOperationOnPathItem(pathItem, (io.swagger.v3.oas.models.Operation)op, (HttpMethod)httpMethod)));
            }
            Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
            Callback c = new Callback();
            c.addPathItem(callbackUrl, pathItem);
            callbacks.put(callbackName, c);
        }
    }

    private Map<String, Callback> initCallbacks(io.swagger.v3.oas.models.Operation swaggerOperation) {
        LinkedHashMap callbacks = swaggerOperation.getCallbacks();
        if (callbacks == null) {
            callbacks = new LinkedHashMap();
            swaggerOperation.setCallbacks(callbacks);
        }
        return callbacks;
    }

    private void addTagIfNotPresent(String tag, io.swagger.v3.oas.models.Operation swaggerOperation) {
        List tags = swaggerOperation.getTags();
        if (tags == null || !tags.contains(tag)) {
            swaggerOperation.addTagsItem(tag);
        }
    }

    private void readTags(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, List<io.swagger.v3.oas.models.tags.Tag> classTags, OpenAPI openAPI) {
        element.getAnnotationValuesByType(Tag.class).forEach(av -> av.stringValue("name").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)swaggerOperation).addTagsItem(arg_0)));
        ArrayList copyTags = openAPI.getTags() != null ? new ArrayList(openAPI.getTags()) : null;
        List<io.swagger.v3.oas.models.tags.Tag> operationTags = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, copyTags);
        ArrayList<io.swagger.v3.oas.models.tags.Tag> complexTags = null;
        if (CollectionUtils.isNotEmpty(operationTags)) {
            complexTags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>();
            for (io.swagger.v3.oas.models.tags.Tag operationTag : operationTags) {
                if (!StringUtils.hasText((CharSequence)operationTag.getDescription()) && !CollectionUtils.isNotEmpty((Map)operationTag.getExtensions()) && operationTag.getExternalDocs() == null) continue;
                complexTags.add(operationTag);
            }
        }
        if (CollectionUtils.isNotEmpty(complexTags)) {
            if (CollectionUtils.isEmpty((Collection)openAPI.getTags())) {
                openAPI.setTags(complexTags);
            } else {
                for (io.swagger.v3.oas.models.tags.Tag complexTag : complexTags) {
                    boolean alreadyExists = false;
                    for (io.swagger.v3.oas.models.tags.Tag apiTag : openAPI.getTags()) {
                        if (!apiTag.getName().equals(complexTag.getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    openAPI.getTags().add(complexTag);
                }
            }
        }
        element.getValues(Tags.class, AnnotationValue.class).forEach((k, v) -> v.stringValue("name").ifPresent(name -> this.addTagIfNotPresent((String)name, swaggerOperation)));
        classTags.forEach(tag -> this.addTagIfNotPresent(tag.getName(), swaggerOperation));
    }

    private List<io.swagger.v3.oas.models.tags.Tag> readTags(ClassElement element, VisitorContext context) {
        return this.readTags(element.getAnnotationValuesByType(Tag.class), context);
    }

    final List<io.swagger.v3.oas.models.tags.Tag> readTags(List<AnnotationValue<Tag>> annotations, VisitorContext context) {
        return annotations.stream().map(av -> this.toValue(av.getValues(), context, io.swagger.v3.oas.models.tags.Tag.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Content buildContent(Element definingElement, ClassElement type, List<io.micronaut.http.MediaType> mediaTypes, OpenAPI openAPI, VisitorContext context) {
        Content content = new Content();
        mediaTypes.forEach(mediaType -> {
            MediaType mt = new MediaType();
            mt.setSchema(this.resolveSchema(openAPI, definingElement, type, context, Collections.singletonList(mediaType), null, null));
            content.addMediaType(mediaType.toString(), mt);
        });
        return content;
    }
}

