/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.swagger.PrimitiveType;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.NumberUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.TypeElementUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.VisibilityLevel;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;

@Internal
abstract class AbstractOpenApiVisitor {
    private static final Lock VISITED_ELEMENTS_LOCK = new ReentrantLock();
    private static final Schema<?> EMPTY_SCHEMA = new Schema();
    private static final ComposedSchema EMPTY_COMPOSED_SCHEMA = new ComposedSchema();
    private List<String> inProgressSchemas = new ArrayList<String>(10);
    private Map<String, PropertyNamingStrategy> propertyNamingStrategyInstances = new HashMap<String, PropertyNamingStrategy>();

    AbstractOpenApiVisitor() {
    }

    void incrementVisitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            context.put((CharSequence)"io.micronaut.OPENAPI.visited.elements", (Object)(ContextUtils.getVisitedElements(context) + 1));
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    int visitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            int n = ContextUtils.getVisitedElements(context);
            return n;
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context) {
        Map<CharSequence, Object> newValues = this.toValueMap(values, context);
        return ConvertUtils.getJsonMapper().valueToTree(newValues);
    }

    <T> Optional<T> toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type) {
        JsonNode node = this.toJson(values, context);
        try {
            return Optional.ofNullable(ConvertUtils.treeToValue(node, type, context));
        }
        catch (JsonProcessingException e) {
            context.warn("Error converting  [" + node + "]: to " + type + ": " + e.getMessage(), null);
            return Optional.empty();
        }
    }

    List<SecurityRequirement> readSecurityRequirements(Element element) {
        return this.readSecurityRequirements(element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class));
    }

    List<SecurityRequirement> readSecurityRequirements(List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> annotations) {
        return annotations.stream().map(ConvertUtils::mapToSecurityRequirement).collect(Collectors.toList());
    }

    List<PathItem> resolvePathItems(VisitorContext context, List<UriMatchTemplate> matchTemplates) {
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            openAPI.setPaths(paths);
        }
        ArrayList<PathItem> resultPaths = new ArrayList<PathItem>();
        for (UriMatchTemplate matchTemplate : matchTemplates) {
            String contextPath;
            StringBuilder result = new StringBuilder();
            boolean varProcess = false;
            boolean valueProcess = false;
            boolean isFirstVarChar = true;
            boolean needToSkip = false;
            String pathString = matchTemplate.toPathString();
            for (char c : pathString.toCharArray()) {
                if (varProcess) {
                    if (isFirstVarChar) {
                        isFirstVarChar = false;
                        if (c == '?' || c == '.') {
                            needToSkip = true;
                            result.deleteCharAt(result.length() - 1);
                            continue;
                        }
                        if (c == '+' || c == '0') continue;
                        if (c == '/') {
                            result.deleteCharAt(result.length() - 1).append(c).append('{');
                            continue;
                        }
                    }
                    if (c == ':') {
                        valueProcess = true;
                        continue;
                    }
                    if (c == '}') {
                        varProcess = false;
                        valueProcess = false;
                        if (!needToSkip) {
                            result.append('}');
                        }
                        needToSkip = false;
                        continue;
                    }
                    if (valueProcess || needToSkip) continue;
                }
                if (c == '{') {
                    varProcess = true;
                    isFirstVarChar = true;
                }
                result.append(c);
            }
            String resultPath = OpenApiApplicationVisitor.replacePlaceholders(result.toString(), context);
            if (!resultPath.startsWith("/") && !resultPath.startsWith("$")) {
                resultPath = "/" + resultPath;
            }
            if (StringUtils.isNotEmpty((CharSequence)(contextPath = OpenApiApplicationVisitor.getConfigurationProperty("micronaut.server.context-path", context)))) {
                if (!contextPath.startsWith("/") && !contextPath.startsWith("$")) {
                    contextPath = "/" + contextPath;
                }
                if (contextPath.endsWith("/")) {
                    contextPath = contextPath.substring(0, contextPath.length() - 1);
                }
                resultPath = contextPath + resultPath;
            }
            resultPaths.add((PathItem)paths.computeIfAbsent((Object)resultPath, key -> new PathItem()));
        }
        return resultPaths;
    }

    protected Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        block4: for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                Map<CharSequence, Object> valueMap;
                AnnotationValue av = (AnnotationValue)value;
                if (av.getAnnotationName().equals(io.swagger.v3.oas.annotations.media.ArraySchema.class.getName())) {
                    valueMap = this.resolveArraySchemaAnnotationValues(context, av);
                    newValues.put("schema", valueMap);
                    continue;
                }
                valueMap = this.resolveAnnotationValues(context, av);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                Optional type = acv.getType();
                type.ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Parameter.StyleEnum[] first = a[0];
                    boolean areAnnotationValues = first instanceof AnnotationValue;
                    boolean areClassValues = first instanceof AnnotationClassValue;
                    if (areClassValues) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (areAnnotationValues) {
                        Map<CharSequence, Object> valueMap;
                        Object ref;
                        Map<CharSequence, Object> map;
                        String name2;
                        AnnotationValue sv;
                        Map<String, String> params;
                        String annotationName = ((AnnotationValue)first).getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            HashMap<CharSequence, Object> extensions = new HashMap<CharSequence, Object>();
                            for (Object o : a) {
                                this.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Encoding.class.getName().equals(annotationName)) {
                            Map<String, Object> encodings = this.annotationValueArrayToSubmap(a, "name", context);
                            newValues.put(key, encodings);
                            continue;
                        }
                        if (Content.class.getName().equals(annotationName)) {
                            Map<String, Object> mediaTypes = this.annotationValueArrayToSubmap(a, "mediaType", context);
                            newValues.put(key, mediaTypes);
                            continue;
                        }
                        if (Link.class.getName().equals(annotationName) || Header.class.getName().equals(annotationName)) {
                            Map<String, Object> linksOrHeaders = this.annotationValueArrayToSubmap(a, "name", context);
                            for (Object linkOrHeader : linksOrHeaders.values()) {
                                Map linkOrHeaderMap = (Map)linkOrHeader;
                                if (linkOrHeaderMap.containsKey("ref")) {
                                    linkOrHeaderMap.put("$ref", linkOrHeaderMap.remove("ref"));
                                }
                                if (!linkOrHeaderMap.containsKey("schema")) continue;
                                Map schemaMap = (Map)linkOrHeaderMap.get("schema");
                                if (schemaMap.containsKey("ref")) {
                                    Object ref2 = schemaMap.get("ref");
                                    schemaMap.clear();
                                    schemaMap.put("$ref", ref2);
                                }
                                if (schemaMap.containsKey("defaultValue")) {
                                    schemaMap.put("default", schemaMap.remove("defaultValue"));
                                }
                                if (!schemaMap.containsKey("allowableValues")) continue;
                                schemaMap.put("enum", schemaMap.remove("allowableValues"));
                            }
                            newValues.put(key, linksOrHeaders);
                            continue;
                        }
                        if (LinkParameter.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "expression");
                            newValues.put(key, params);
                            continue;
                        }
                        if (OAuthScope.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "description");
                            newValues.put(key, params);
                            continue;
                        }
                        if (ApiResponse.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> responses = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.stringValue("responseCode").orElse("default");
                                map = this.toValueMap(sv.getValues(), context);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                responses.put(name2, map);
                            }
                            newValues.put(key, responses);
                            continue;
                        }
                        if (ExampleObject.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> examples = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.stringValue("name").orElse("example");
                                map = this.toValueMap(sv.getValues(), context);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                examples.put(name2, map);
                            }
                            newValues.put(key, examples);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList<LinkedHashMap<CharSequence, Object>> servers = new ArrayList<LinkedHashMap<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>(this.toValueMap(sv.getValues(), context));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                Optional n = sv.stringValue("name");
                                n.ifPresent(name -> {
                                    Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (DiscriminatorMapping.class.getName().equals(annotationName)) {
                            HashMap<String, String> mappings = new HashMap<String, String>();
                            for (Object o : a) {
                                AnnotationValue dv = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, dv);
                                mappings.put(valueMap.get("value").toString(), valueMap.get("$ref").toString());
                            }
                            Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                            discriminatorMap.put("mapping", mappings);
                            newValues.put("discriminator", discriminatorMap);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap2 = this.resolveAnnotationValues(context, av);
                            newValues.put(key, this.toValueMap(valueMap2, context));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, av);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            if (key.equals("discriminatorProperty")) {
                Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                discriminatorMap.put("propertyName", this.parseJsonString(value).orElse(value));
                newValues.put("discriminator", discriminatorMap);
                continue;
            }
            if (key.equals("style")) {
                Parameter.StyleEnum paramStyle = null;
                try {
                    paramStyle = Parameter.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception first) {
                    // empty catch block
                }
                if (paramStyle == null) {
                    for (Parameter.StyleEnum styleValue : Parameter.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        paramStyle = styleValue;
                        newValues.put(key, styleValue.toString());
                        break;
                    }
                } else {
                    newValues.put(key, paramStyle.toString());
                }
                if (paramStyle != null) continue;
                Encoding.StyleEnum encodingStyle = null;
                try {
                    encodingStyle = Encoding.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (encodingStyle == null) {
                    for (Encoding.StyleEnum styleValue : Encoding.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        encodingStyle = styleValue;
                        newValues.put(key, styleValue.toString());
                        continue block4;
                    }
                    continue;
                }
                newValues.put(key, encodingStyle.toString());
                continue;
            }
            if (key.equals("ref")) {
                newValues.put("$ref", value);
                continue;
            }
            if (key.equals("accessMode")) {
                if (Schema.AccessMode.READ_ONLY.toString().equals(value)) {
                    newValues.put("readOnly", Boolean.TRUE);
                    continue;
                }
                if (!Schema.AccessMode.WRITE_ONLY.toString().equals(value)) continue;
                newValues.put("writeOnly", Boolean.TRUE);
                continue;
            }
            newValues.put(key, this.parseJsonString(value).orElse(value));
        }
        return newValues;
    }

    private Map<String, Object> getDiscriminatorMap(Map<CharSequence, Object> newValues) {
        return newValues.containsKey("discriminator") ? (Map)newValues.get("discriminator") : new HashMap();
    }

    private void processExtensions(Map<CharSequence, Object> map, AnnotationValue<Extension> extension) {
        String name = extension.stringValue("name").orElse("");
        String key = !name.isEmpty() ? AbstractOpenApiVisitor.prependIfMissing(name, "x-") : name;
        for (AnnotationValue prop : extension.getAnnotations("properties", ExtensionProperty.class)) {
            JsonNode processedValue;
            String propertyName = (String)prop.getRequiredValue("name", String.class);
            String propertyValue = (String)prop.getRequiredValue(String.class);
            boolean propertyAsJson = (Boolean)prop.get((CharSequence)"parseValue", Boolean.TYPE, (Object)false);
            if (!StringUtils.hasText((CharSequence)propertyName) || !StringUtils.hasText((CharSequence)propertyValue)) continue;
            if (key.isEmpty()) {
                if (propertyAsJson) {
                    try {
                        processedValue = ConvertUtils.getJsonMapper().readTree(propertyValue);
                        map.put(AbstractOpenApiVisitor.prependIfMissing(propertyName, "x-"), processedValue);
                    }
                    catch (Exception e) {
                        map.put(AbstractOpenApiVisitor.prependIfMissing(propertyName, "x-"), propertyValue);
                    }
                    continue;
                }
                map.put(AbstractOpenApiVisitor.prependIfMissing(propertyName, "x-"), propertyValue);
                continue;
            }
            LinkedHashMap value = map.get(key);
            if (!(value instanceof Map)) {
                value = new LinkedHashMap();
                map.put(key, value);
            }
            Map mapValue = value;
            if (propertyAsJson) {
                try {
                    processedValue = ConvertUtils.getJsonMapper().readTree(propertyValue);
                    mapValue.put(propertyName, processedValue);
                }
                catch (Exception e) {
                    mapValue.put(propertyName, propertyValue);
                }
                continue;
            }
            mapValue.put(propertyName, propertyValue);
        }
    }

    public static String prependIfMissing(String str, String prefix) {
        if (str == null || StringUtils.isEmpty((CharSequence)prefix) || str.startsWith(prefix)) {
            return str;
        }
        return prefix + str;
    }

    private Optional<Object> parseJsonString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Optional.of(ConvertUtils.getConvertJsonMapper().readValue(string, Map.class));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private <T extends Schema> void processAnnotationValue(VisitorContext context, AnnotationValue<?> annotationValue, Map<CharSequence, Object> arraySchemaMap, List<String> filters, Class<T> type) {
        Map<CharSequence, Object> values = annotationValue.getValues().entrySet().stream().filter(entry -> filters == null || !filters.contains((String)entry.getKey())).collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schema = this.toValue(values, context, type);
        schema.ifPresent(s -> this.schemaToValueMap(arraySchemaMap, (Schema)s));
    }

    private Map<CharSequence, Object> resolveArraySchemaAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        HashMap<CharSequence, Object> arraySchemaMap = new HashMap<CharSequence, Object>(10);
        av.get((CharSequence)"arraySchema", AnnotationValue.class).ifPresent(annotationValue -> this.processAnnotationValue(context, (AnnotationValue<?>)annotationValue, (Map<CharSequence, Object>)arraySchemaMap, Arrays.asList("ref", "implementation"), (Class)Schema.class));
        av.get((CharSequence)"schema", AnnotationValue.class).ifPresent(annotationValue -> {
            Optional impl = annotationValue.stringValue("implementation");
            Optional type = annotationValue.stringValue("type");
            Optional format = annotationValue.stringValue("format");
            Optional classElement = Optional.empty();
            PrimitiveType primitiveType = null;
            if (impl.isPresent()) {
                classElement = context.getClassElement((String)impl.get());
            } else if (type.isPresent()) {
                primitiveType = PrimitiveType.fromName(format.isPresent() && ((String)format.get()).equals("binary") ? (String)format.get() : (String)type.get());
                classElement = primitiveType == null ? context.getClassElement((String)type.get()) : context.getClassElement(primitiveType.getKeyClass());
            }
            if (classElement.isPresent()) {
                if (primitiveType == null) {
                    ArraySchema schema = SchemaUtils.arraySchema(this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList()));
                    this.schemaToValueMap(arraySchemaMap, (Schema)schema);
                } else {
                    Schema items = primitiveType.createProperty();
                    items.setDescription((String)annotationValue.stringValue("description").orElse(null));
                    ArraySchema schema = SchemaUtils.arraySchema(items);
                    this.schemaToValueMap(arraySchemaMap, (Schema)schema);
                }
            } else {
                arraySchemaMap.putAll(this.resolveAnnotationValues(context, (AnnotationValue<?>)annotationValue));
            }
        });
        this.processAnnotationValue(context, av, arraySchemaMap, Arrays.asList("schema", "arraySchema"), ArraySchema.class);
        return arraySchemaMap;
    }

    private Map<CharSequence, Object> resolveAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        Map<CharSequence, Object> valueMap = this.toValueMap(av.getValues(), context);
        this.bindSchemaIfNeccessary(context, av, valueMap);
        String annotationName = av.getAnnotationName();
        if (Parameter.class.getName().equals(annotationName)) {
            Utils.normalizeEnumValues(valueMap, CollectionUtils.mapOf((Object[])new Object[]{"in", ParameterIn.class, "style", ParameterStyle.class}));
        }
        return valueMap;
    }

    private Map<String, String> toTupleSubMap(Object[] a, String entryKey, String entryValue) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            Optional n = sv.stringValue(entryKey);
            Optional expr = sv.stringValue(entryValue);
            if (!n.isPresent() || !expr.isPresent()) continue;
            params.put((String)n.get(), (String)expr.get());
        }
        return params;
    }

    private boolean isTypeNullable(ClassElement type) {
        return type.isAssignable(Optional.class);
    }

    @Nullable
    protected Schema resolveSchema(@Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes) {
        return this.resolveSchema(Utils.resolveOpenAPI(context), definingElement, type, context, mediaTypes, null, null);
    }

    @Nullable
    protected Schema resolveSchema(OpenAPI openAPI, @Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes, JavadocDescription fieldJavadoc, JavadocDescription classJavadoc) {
        AnnotationValue schemaAnnotationValue = null;
        if (definingElement != null) {
            schemaAnnotationValue = definingElement.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (type != null && schemaAnnotationValue == null) {
            schemaAnnotationValue = type.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        boolean isSubstitudedType = false;
        if (schemaAnnotationValue != null) {
            String impl = schemaAnnotationValue.stringValue("implementation").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)impl)) {
                type = context.getClassElement(impl).orElse(type);
                isSubstitudedType = true;
            } else {
                PrimitiveType primitiveType;
                String schemaType = schemaAnnotationValue.stringValue("type").orElse(null);
                if (StringUtils.isNotEmpty((CharSequence)schemaType) && !(type instanceof EnumElement) && (primitiveType = PrimitiveType.fromName(schemaType)) != null && primitiveType != PrimitiveType.OBJECT) {
                    type = context.getClassElement(primitiveType.getKeyClass()).orElse(type);
                    isSubstitudedType = true;
                }
            }
        }
        ClassElement componentType = type.getFirstTypeArgument().orElse(null);
        Map typeArgs = type.getTypeArguments();
        Object schema = null;
        if (type instanceof EnumElement) {
            schema = this.getSchemaDefinition(openAPI, context, type, typeArgs, definingElement, mediaTypes);
        } else {
            boolean isPublisher = false;
            boolean isObservable = false;
            boolean isNullable = false;
            if (type.isAssignable("io.micronaut.http.server.multipart.MultipartBody")) {
                isPublisher = true;
                type = type.getInterfaces().stream().filter(i -> i.isAssignable("org.reactivestreams.Publisher")).findFirst().flatMap(ClassElement::getFirstTypeArgument).orElse(null);
            } else if (!type.isAssignable("io.micronaut.http.multipart.StreamingFileUpload") && Utils.isContainerType(type)) {
                isPublisher = type.isAssignable("org.reactivestreams.Publisher") && !type.isAssignable("reactor.core.publisher.Mono");
                isObservable = type.isAssignable("io.reactivex.Observable") && !type.isAssignable("reactor.core.publisher.Mono");
                type = componentType;
                if (componentType != null) {
                    typeArgs = componentType.getTypeArguments();
                    componentType = componentType.getFirstTypeArgument().orElse(null);
                }
            } else if (this.isTypeNullable(type)) {
                isNullable = true;
                type = componentType;
                if (componentType != null) {
                    typeArgs = componentType.getTypeArguments();
                    componentType = componentType.getFirstTypeArgument().orElse(null);
                }
            }
            if (type != null) {
                String typeName = type.getName();
                ClassElement customTypeSchema = OpenApiApplicationVisitor.getCustomSchema(typeName, typeArgs, context);
                if (customTypeSchema != null) {
                    type = customTypeSchema;
                }
                if ("io.micronaut.http.multipart.StreamingFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedPart".equals(typeName) || "io.micronaut.http.multipart.PartData".equals(typeName)) {
                    isPublisher = isPublisher && !"io.micronaut.http.multipart.PartData".equals(typeName);
                    typeName = PrimitiveType.BINARY.name();
                }
                PrimitiveType primitiveType = PrimitiveType.fromName(typeName);
                if (!type.isArray() && ClassUtils.isJavaLangType((String)typeName)) {
                    schema = this.getPrimitiveType(typeName);
                } else if (!type.isArray() && primitiveType != null) {
                    schema = primitiveType.createProperty();
                } else if (type.isAssignable(Map.class.getName())) {
                    schema = new MapSchema();
                    if (typeArgs.isEmpty()) {
                        schema.setAdditionalProperties((Object)true);
                    } else {
                        ClassElement valueType = (ClassElement)typeArgs.get("V");
                        if (valueType.getName().equals(Object.class.getName())) {
                            schema.setAdditionalProperties((Object)true);
                        } else {
                            schema.setAdditionalProperties((Object)this.resolveSchema(openAPI, (Element)type, valueType, context, mediaTypes, null, classJavadoc));
                        }
                    }
                } else if (type.isIterable()) {
                    if (type.isArray()) {
                        schema = this.resolveSchema(openAPI, (Element)type, type.fromArray(), context, mediaTypes, null, classJavadoc);
                        if (schema != null) {
                            schema = SchemaUtils.arraySchema(schema);
                        }
                    } else {
                        List fields;
                        schema = componentType != null ? this.resolveSchema(openAPI, (Element)type, componentType, context, mediaTypes, null, classJavadoc) : this.getPrimitiveType(Object.class.getName());
                        List list = fields = type.getPackageName().startsWith("java.util") ? Collections.emptyList() : type.getFields();
                        schema = schema != null && fields.isEmpty() ? SchemaUtils.arraySchema(schema) : this.getSchemaDefinition(openAPI, context, type, typeArgs, definingElement, mediaTypes);
                    }
                } else {
                    schema = Utils.isReturnTypeFile(type) ? PrimitiveType.FILE.createProperty() : (type.isAssignable(Boolean.class) || type.isAssignable(Boolean.TYPE) ? PrimitiveType.BOOLEAN.createProperty() : (type.isAssignable(Byte.class) || type.isAssignable(Byte.TYPE) ? PrimitiveType.BYTE.createProperty() : (type.isAssignable(UUID.class) ? PrimitiveType.UUID.createProperty() : (type.isAssignable(URL.class) ? PrimitiveType.URL.createProperty() : (type.isAssignable(URI.class) ? PrimitiveType.URI.createProperty() : (type.isAssignable(Character.class) || type.isAssignable(Character.TYPE) ? PrimitiveType.STRING.createProperty() : (type.isAssignable(Integer.class) || type.isAssignable(Integer.TYPE) || type.isAssignable(Short.class) || type.isAssignable(Short.TYPE) ? PrimitiveType.INT.createProperty() : (type.isAssignable(Long.class) || type.isAssignable(Long.TYPE) ? PrimitiveType.LONG.createProperty() : (type.isAssignable(Float.class) || type.isAssignable(Float.TYPE) ? PrimitiveType.FLOAT.createProperty() : (type.isAssignable(Double.class) || type.isAssignable(Double.TYPE) ? PrimitiveType.DOUBLE.createProperty() : (type.isAssignable(BigInteger.class) ? PrimitiveType.INTEGER.createProperty() : (type.isAssignable(BigDecimal.class) ? PrimitiveType.DECIMAL.createProperty() : (type.isAssignable(Date.class) || type.isAssignable(Calendar.class) || type.isAssignable(LocalDateTime.class) || type.isAssignable(ZonedDateTime.class) || type.isAssignable(OffsetDateTime.class) || type.isAssignable(Instant.class) || type.isAssignable(XMLGregorianCalendar.class) ? new StringSchema().format("date-time") : (type.isAssignable(LocalDate.class) ? new StringSchema().format("date") : (type.isAssignable(LocalTime.class) ? new StringSchema().format("partial-time") : (type.isAssignable(Number.class) ? PrimitiveType.NUMBER.createProperty() : (type.getName().equals(Object.class.getName()) ? PrimitiveType.OBJECT.createProperty() : this.getSchemaDefinition(openAPI, context, type, typeArgs, definingElement, mediaTypes))))))))))))))))));
                }
            }
            if (schema != null) {
                if (isSubstitudedType) {
                    this.processShemaAnn((Schema)schema, context, definingElement, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnnotationValue);
                }
                if (definingElement != null && StringUtils.isEmpty((CharSequence)schema.getDescription())) {
                    String paramJavadoc;
                    if (fieldJavadoc != null) {
                        if (StringUtils.hasText((CharSequence)fieldJavadoc.getMethodDescription())) {
                            schema.setDescription(fieldJavadoc.getMethodDescription());
                        }
                    } else if (classJavadoc != null && StringUtils.hasText((CharSequence)(paramJavadoc = classJavadoc.getParameters().get(definingElement.getName())))) {
                        schema.setDescription(paramJavadoc);
                    }
                }
                boolean isStream = false;
                for (MediaType mediaType : mediaTypes) {
                    if (!MediaType.TEXT_EVENT_STREAM_TYPE.equals((Object)mediaType) && !MediaType.APPLICATION_JSON_STREAM_TYPE.equals((Object)mediaType)) continue;
                    isStream = true;
                    break;
                }
                if (!isStream && (isPublisher || isObservable)) {
                    schema = SchemaUtils.arraySchema(schema);
                } else if (isNullable) {
                    schema.setNullable(Boolean.valueOf(true));
                }
            }
        }
        return schema;
    }

    private void handleUnwrapped(VisitorContext context, Element element, ClassElement elementType, Schema parentSchema, AnnotationValue<JsonUnwrapped> uw) {
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(Utils.resolveOpenAPI(context));
        ClassElement customElementType = OpenApiApplicationVisitor.getCustomSchema(elementType.getName(), elementType.getTypeArguments(), context);
        String schemaName = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(this.computeDefaultSchemaName(null, (Element)(customElementType != null ? customElementType : elementType), elementType.getTypeArguments(), context));
        Schema wrappedPropertySchema = schemas.get(schemaName);
        Map properties = wrappedPropertySchema.getProperties();
        if (CollectionUtils.isEmpty((Map)properties)) {
            return;
        }
        String prefix = uw.stringValue("prefix").orElse("");
        String suffix = uw.stringValue("suffix").orElse("");
        for (Map.Entry prop : properties.entrySet()) {
            try {
                boolean isRequired;
                String propertyName = (String)prop.getKey();
                Schema propertySchema = (Schema)prop.getValue();
                boolean bl = isRequired = wrappedPropertySchema.getRequired() != null && wrappedPropertySchema.getRequired().contains(propertyName);
                if (StringUtils.isNotEmpty((CharSequence)suffix) || StringUtils.isNotEmpty((CharSequence)prefix)) {
                    propertyName = prefix + propertyName + suffix;
                    propertySchema = (Schema)ConvertUtils.getJsonMapper().readValue(ConvertUtils.getJsonMapper().writeValueAsString(prop.getValue()), Schema.class);
                    propertySchema.setName(propertyName);
                }
                this.addProperty(parentSchema, propertyName, propertySchema, isRequired);
            }
            catch (IOException e) {
                context.warn("Exception cloning property " + e.getMessage(), null);
            }
        }
    }

    protected void processSchemaProperty(VisitorContext context, TypedElement element, ClassElement elementType, @Nullable Element classElement, Schema parentSchema, Schema propertySchema) {
        if (propertySchema != null) {
            AnnotationValue uw = element.getAnnotation(JsonUnwrapped.class);
            if (uw != null && uw.booleanValue("enabled").orElse(Boolean.TRUE).booleanValue()) {
                this.handleUnwrapped(context, (Element)element, elementType, parentSchema, (AnnotationValue<JsonUnwrapped>)uw);
            } else {
                AnnotationValue schemaAnnotationValue = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                Optional elementSchemaRequired = Optional.empty();
                boolean isRequiredDefaultValueSet = false;
                if (schemaAnnotationValue != null) {
                    elementSchemaRequired = schemaAnnotationValue.get((CharSequence)"required", Argument.of(Boolean.TYPE));
                    isRequiredDefaultValueSet = !schemaAnnotationValue.contains("required");
                }
                boolean isNotNullable = this.isElementNotNullable((Element)element, classElement);
                boolean isMandatoryInConstructor = this.doesParamExistsMandatoryInConstructor((Element)element, classElement);
                boolean required = elementSchemaRequired.orElse(isNotNullable || isMandatoryInConstructor);
                if (isRequiredDefaultValueSet && isNotNullable) {
                    required = true;
                }
                propertySchema = this.bindSchemaForElement(context, element, elementType, propertySchema);
                String propertyName = this.resolvePropertyName((Element)element, classElement, propertySchema);
                propertySchema.setRequired(null);
                Schema propertySchemaFinal = propertySchema;
                this.addProperty(parentSchema, propertyName, propertySchema, required);
                if (schemaAnnotationValue != null) {
                    schemaAnnotationValue.stringValue("defaultValue").ifPresent(value -> {
                        String elType = schemaAnnotationValue.stringValue("type").orElse(null);
                        String elFormat = schemaAnnotationValue.stringValue("format").orElse(null);
                        if (elType == null && elementType != null) {
                            Pair<String, String> typeAndFormat = ConvertUtils.getTypeAndFormatByClass(elementType.getName(), elementType.isArray());
                            elType = typeAndFormat.getFirst();
                            if (elFormat == null) {
                                elFormat = typeAndFormat.getSecond();
                            }
                        }
                        try {
                            propertySchemaFinal.setDefault(ConvertUtils.normalizeValue(value, elType, elFormat, context));
                        }
                        catch (JsonProcessingException e) {
                            context.warn("Can't parse value " + value + " to " + elType + ": " + e.getMessage(), (Element)element);
                            propertySchemaFinal.setDefault(value);
                        }
                    });
                }
            }
        }
    }

    protected boolean isElementNotNullable(Element element, @Nullable Element classElement) {
        return element.isAnnotationPresent("javax.validation.constraints.NotNull$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotNull$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List") || element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isNonNull() || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    private boolean doesParamExistsMandatoryInConstructor(Element element, @Nullable Element classElement) {
        if (classElement instanceof ClassElement) {
            return ((ClassElement)classElement).getPrimaryConstructor().flatMap(methodElement -> Arrays.stream(methodElement.getParameters()).filter(parameterElement -> parameterElement.getName().equals(element.getName())).map(parameterElement -> !parameterElement.isNullable()).findFirst()).orElse(false);
        }
        return false;
    }

    private void addProperty(Schema parentSchema, String name, Schema propertySchema, boolean required) {
        List requiredList;
        parentSchema.addProperty(name, propertySchema);
        if (required && ((requiredList = parentSchema.getRequired()) == null || !requiredList.contains(name))) {
            parentSchema.addRequiredItem(name);
        }
    }

    private String resolvePropertyName(Element element, Element classElement, Schema propertySchema) {
        Optional nameFromSchema;
        String name = Optional.ofNullable(propertySchema.getName()).orElse(element.getName());
        if (element.hasAnnotation(io.swagger.v3.oas.annotations.media.Schema.class) && (nameFromSchema = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name")).isPresent()) {
            return (String)nameFromSchema.get();
        }
        if (element.hasAnnotation(JsonProperty.class)) {
            return element.stringValue(JsonProperty.class, "value").orElse(name);
        }
        if (classElement != null && classElement.hasAnnotation(JsonNaming.class)) {
            Optional propertyNamingStrategyClass = classElement.stringValue(JsonNaming.class);
            if (!propertyNamingStrategyClass.isPresent()) {
                return name;
            }
            PropertyNamingStrategy strategy = this.propertyNamingStrategyInstances.computeIfAbsent((String)propertyNamingStrategyClass.get(), clazz -> {
                try {
                    return (PropertyNamingStrategy)Class.forName((String)propertyNamingStrategyClass.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate: " + clazz);
                }
            });
            if (strategy instanceof PropertyNamingStrategies.NamingBase) {
                return ((PropertyNamingStrategies.NamingBase)strategy).translate(name);
            }
        }
        return name;
    }

    protected Schema bindSchemaForElement(VisitorContext context, TypedElement element, ClassElement elementType, Schema schemaToBind) {
        String defaultJacksonValue;
        Boolean isSchemaNullable;
        boolean isNullable;
        String defaultValue;
        Schema topLevelSchema;
        ComposedSchema composedSchema;
        AnnotationValue arraySchemaAnn;
        Schema schemaFromAnn;
        AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        Schema originalSchema = schemaToBind;
        if (originalSchema.get$ref() != null && (schemaFromAnn = this.shemaFromAnnotation(context, (Element)element, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn)) != null) {
            schemaToBind = schemaFromAnn;
        }
        if (originalSchema.get$ref() == null && schemaAnn != null) {
            schemaToBind = this.bindSchemaAnnotationValue(context, (Element)element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
            Optional schemaName = schemaAnn.stringValue("name");
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
            elementType = schemaAnn.stringValue("implementation").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(elementType);
        }
        if ((arraySchemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class)) != null) {
            schemaToBind = this.bindArraySchemaAnnotationValue(context, (Element)element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema>)arraySchemaAnn);
            Optional schemaName = arraySchemaAnn.stringValue("name");
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
        }
        Schema finalSchemaToBind = schemaToBind;
        this.processJavaxValidationAnnotations((Element)element, elementType, finalSchemaToBind);
        if (originalSchema.get$ref() != null) {
            composedSchema = new ComposedSchema();
            topLevelSchema = composedSchema;
        } else {
            composedSchema = null;
            topLevelSchema = schemaToBind;
        }
        boolean notOnlyRef = false;
        this.setSchemaDocumentation((Element)element, topLevelSchema);
        if (StringUtils.isNotEmpty((CharSequence)topLevelSchema.getDescription())) {
            notOnlyRef = true;
        }
        if (element.isAnnotationPresent(Deprecated.class)) {
            topLevelSchema.setDeprecated(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultValue = (String)element.getValue(Bindable.class, "defaultValue", String.class).orElse(null)) != null && schemaToBind.getDefault() == null) {
            try {
                topLevelSchema.setDefault(ConvertUtils.normalizeValue(defaultValue, schemaToBind.getType(), schemaToBind.getFormat(), context, true));
            }
            catch (JsonProcessingException e) {
                context.warn("Can't convert " + defaultValue + " to " + schemaToBind.getType() + ": " + e.getMessage(), (Element)element);
                topLevelSchema.setDefault((Object)defaultValue);
            }
            notOnlyRef = true;
        }
        boolean bl = isNullable = (isSchemaNullable = (Boolean)element.booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "nullable").orElse(null)) == null && TypeElementUtils.isNullable(element) || Boolean.TRUE.equals(isSchemaNullable);
        if (isNullable) {
            topLevelSchema.setNullable(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultJacksonValue = (String)element.stringValue(JsonProperty.class, "defaultValue").orElse(null)) != null && schemaToBind.getDefault() == null) {
            try {
                topLevelSchema.setDefault(ConvertUtils.normalizeValue(defaultJacksonValue, schemaToBind.getType(), schemaToBind.getFormat(), context));
            }
            catch (JsonProcessingException e) {
                context.warn("Can't convert " + defaultJacksonValue + " to " + schemaToBind.getType() + ": " + e.getMessage(), (Element)element);
                topLevelSchema.setDefault((Object)defaultJacksonValue);
            }
            notOnlyRef = true;
        }
        if (composedSchema != null) {
            boolean addSchemaToBind;
            boolean bl2 = addSchemaToBind = !schemaToBind.equals(EMPTY_SCHEMA);
            if (addSchemaToBind) {
                composedSchema.addAllOfItem(originalSchema);
            } else if (isNullable && CollectionUtils.isEmpty((Collection)composedSchema.getAllOf())) {
                composedSchema.addOneOfItem(originalSchema);
            }
            if (addSchemaToBind && !schemaToBind.equals((Object)originalSchema)) {
                composedSchema.addAllOfItem(schemaToBind);
            }
            if (!composedSchema.equals((Object)EMPTY_COMPOSED_SCHEMA) && (CollectionUtils.isNotEmpty((Collection)composedSchema.getAllOf()) && composedSchema.getAllOf().size() > 1 || CollectionUtils.isNotEmpty((Collection)composedSchema.getOneOf()) || notOnlyRef)) {
                return composedSchema;
            }
        }
        return originalSchema;
    }

    protected void processJavaxValidationAnnotations(Element element, ClassElement elementType, Schema schemaToBind) {
        boolean isIterableOrMap;
        boolean bl = isIterableOrMap = elementType.isIterable() || elementType.isAssignable(Map.class);
        if (isIterableOrMap) {
            if (element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List")) {
                schemaToBind.setMinItems(Integer.valueOf(1));
            }
            element.findAnnotation("javax.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.get((CharSequence)"min", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0))));
            element.findAnnotation("jakarta.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.get((CharSequence)"min", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0))));
            element.findAnnotation("javax.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.get((CharSequence)"max", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0))));
            element.findAnnotation("jakarta.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.get((CharSequence)"max", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0))));
        } else {
            if (PrimitiveType.STRING.getCommonName().equals(schemaToBind.getType())) {
                if (element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List")) {
                    schemaToBind.setMinLength(Integer.valueOf(1));
                }
                element.findAnnotation("javax.validation.constraints.Size$List").ifPresent(listAnn -> {
                    for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                        ann.get((CharSequence)"min", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                        ann.get((CharSequence)"max", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
                    }
                });
                element.findAnnotation("jakarta.validation.constraints.Size$List").ifPresent(listAnn -> {
                    for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                        ann.get((CharSequence)"min", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                        ann.get((CharSequence)"max", Integer.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
                    }
                });
            }
            if (element.isAnnotationPresent("javax.validation.constraints.Negative$List") || element.isAnnotationPresent("jakarta.validation.constraints.Negative$List")) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent("javax.validation.constraints.NegativeOrZero$List") || element.isAnnotationPresent("jakarta.validation.constraints.NegativeOrZero$List")) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent("javax.validation.constraints.Positive$List") || element.isAnnotationPresent("jakarta.validation.constraints.Positive$List")) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent("javax.validation.constraints.PositiveOrZero$List") || element.isAnnotationPresent("jakarta.validation.constraints.PositiveOrZero$List")) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            element.findAnnotation("javax.validation.constraints.Min$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Min$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.Max$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Max$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.DecimalMin$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.DecimalMin$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.DecimalMax$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.DecimalMax$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.Email$List").ifPresent(listAnn -> {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Email$List").ifPresent(listAnn -> {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.Pattern$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Pattern$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : (Set)listAnn.getValues().get("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.getValue("io.micronaut.http.annotation.Part", String.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setName(arg_0));
        }
    }

    Schema shemaFromAnnotation(VisitorContext context, Element element, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        if (schemaAnn == null) {
            return null;
        }
        Schema schemaToBind = new Schema();
        this.processShemaAnn(schemaToBind, context, element, schemaAnn);
        return schemaToBind;
    }

    void processShemaAnn(Schema schemaToBind, VisitorContext context, Element element, @NonNull AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        String string;
        Object[] oneOf;
        Object[] anyOf;
        Object[] allOf;
        Schema.AccessMode schemaAccessMode;
        String accessModeStr;
        Boolean schemaDeprecated;
        String schemaExample;
        String schemaDefaultValue;
        Double schemaMultipleOf;
        Boolean schemaExclusiveMaximum;
        Boolean schemaExclusiveMinimum;
        String schemaMaximum;
        String schemaMinimum;
        Map annValues = schemaAnn.getValues();
        if (annValues.containsKey("description")) {
            schemaToBind.setDescription((String)annValues.get("description"));
        }
        if (annValues.containsKey("type")) {
            schemaToBind.setType((String)annValues.get("type"));
        }
        if (annValues.containsKey("format")) {
            schemaToBind.setFormat((String)annValues.get("format"));
        }
        if (annValues.containsKey("title")) {
            schemaToBind.setTitle((String)annValues.get("title"));
        }
        if (annValues.containsKey("minLength")) {
            schemaToBind.setMinLength((Integer)annValues.get("minLength"));
        }
        if (annValues.containsKey("maxLength")) {
            schemaToBind.setMaxLength((Integer)annValues.get("maxLength"));
        }
        if (annValues.containsKey("minProperties")) {
            schemaToBind.setMinProperties((Integer)annValues.get("minProperties"));
        }
        if (annValues.containsKey("maxProperties")) {
            schemaToBind.setMaxProperties((Integer)annValues.get("maxProperties"));
        }
        if (annValues.containsKey("pattern")) {
            schemaToBind.setPattern((String)annValues.get("pattern"));
        }
        if (NumberUtils.isCreatable(schemaMinimum = (String)annValues.get("minimum"))) {
            schemaToBind.setMinimum(new BigDecimal(schemaMinimum));
        }
        if (NumberUtils.isCreatable(schemaMaximum = (String)annValues.get("maximum"))) {
            schemaToBind.setMaximum(new BigDecimal(schemaMaximum));
        }
        if ((schemaExclusiveMinimum = (Boolean)annValues.get("exclusiveMinimum")) != null && schemaExclusiveMinimum.booleanValue()) {
            schemaToBind.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if ((schemaExclusiveMaximum = (Boolean)annValues.get("exclusiveMaximum")) != null && schemaExclusiveMaximum.booleanValue()) {
            schemaToBind.setExclusiveMaximum(Boolean.valueOf(true));
        }
        if ((schemaMultipleOf = (Double)annValues.get("multipleOf")) != null) {
            schemaToBind.setMultipleOf(BigDecimal.valueOf(schemaMultipleOf));
        }
        AnnotationValue schemaExtDocs = (AnnotationValue)annValues.get("externalDocs");
        ExternalDocumentation externalDocs = null;
        if (schemaExtDocs != null) {
            externalDocs = this.toValue(schemaExtDocs.getValues(), context, ExternalDocumentation.class).orElse(null);
        }
        if (externalDocs != null) {
            schemaToBind.setExternalDocs(externalDocs);
        }
        if ((schemaDefaultValue = (String)annValues.get("defaultValue")) != null) {
            try {
                schemaToBind.setDefault(ConvertUtils.normalizeValue(schemaDefaultValue, schemaToBind.getType(), schemaToBind.getFormat(), context));
            }
            catch (JsonProcessingException e) {
                context.warn("Can't convert " + schemaDefaultValue + " to " + schemaToBind.getType() + ": " + e.getMessage(), element);
                schemaToBind.setDefault((Object)schemaDefaultValue);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(schemaExample = (String)annValues.get("example")))) {
            try {
                schemaToBind.setExample(ConvertUtils.getConvertJsonMapper().readValue(schemaExample, Map.class));
            }
            catch (JsonProcessingException e) {
                schemaToBind.setExample((Object)schemaExample);
            }
        }
        if ((schemaDeprecated = (Boolean)annValues.get("deprecated")) != null && schemaDeprecated.booleanValue()) {
            schemaToBind.setDeprecated(Boolean.valueOf(true));
        }
        if (StringUtils.isNotEmpty((CharSequence)(accessModeStr = (String)annValues.get("accessMode"))) && (schemaAccessMode = Schema.AccessMode.valueOf((String)accessModeStr)) != Schema.AccessMode.AUTO) {
            if (schemaAccessMode == Schema.AccessMode.READ_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(true));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.WRITE_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(false));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.READ_WRITE) {
                schemaToBind.setReadOnly(null);
                schemaToBind.setWriteOnly(null);
            }
        }
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        Components components = Utils.resolveComponents(openAPI);
        AnnotationClassValue not = (AnnotationClassValue)annValues.get("not");
        if (not != null) {
            Schema schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement(not.getName()).get(), context, Collections.emptyList());
            schemaToBind.setNot(schemaNot);
        }
        if (ArrayUtils.isNotEmpty((Object[])(allOf = (AnnotationClassValue[])annValues.get("allOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])allOf, Collections.emptyList());
            for (Schema<?> schema : schemaList) {
                schemaToBind.addAllOfItem(schema);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(anyOf = (AnnotationClassValue[])annValues.get("anyOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])anyOf, Collections.emptyList());
            for (Schema<?> schema : schemaList) {
                schemaToBind.addAnyOfItem(schema);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(oneOf = (AnnotationClassValue[])annValues.get("oneOf")))) {
            List<Schema<?>> list = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])oneOf, Collections.emptyList());
            for (Schema<?> schema : list) {
                schemaToBind.addOneOfItem(schema);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(string = (String)annValues.get("additionalProperties")))) {
            Schema.AdditionalPropertiesValue additionalPropertiesValue = Schema.AdditionalPropertiesValue.valueOf((String)string);
            if (additionalPropertiesValue == Schema.AdditionalPropertiesValue.TRUE) {
                schemaToBind.additionalProperties((Object)true);
            } else if (additionalPropertiesValue == Schema.AdditionalPropertiesValue.FALSE) {
                schemaToBind.additionalProperties((Object)false);
            }
        }
    }

    private void setSchemaDocumentation(Element element, Schema schemaToBind) {
        if (StringUtils.isEmpty((CharSequence)schemaToBind.getDescription())) {
            JavadocDescription desc;
            List fields;
            String doc = element.getDocumentation().orElse(null);
            if (StringUtils.isEmpty((CharSequence)doc) && element instanceof MemberElement && CollectionUtils.isNotEmpty((Collection)(fields = ((MemberElement)element).getDeclaringType().getFields()))) {
                for (FieldElement field : fields) {
                    if (!field.getName().equals(element.getName())) continue;
                    doc = field.getDocumentation().orElse(null);
                    break;
                }
            }
            if (doc != null && StringUtils.hasText((CharSequence)(desc = Utils.getJavadocParser().parse(doc)).getMethodDescription())) {
                schemaToBind.setDescription(desc.getMethodDescription());
            }
        }
    }

    protected Schema bindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        ClassElement classElement = ((TypedElement)element).getType();
        Pair<String, Object> typeAndFormat = classElement.isIterable() ? Pair.of("array", null) : ConvertUtils.getTypeAndFormatByClass(classElement.getName(), classElement.isArray());
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, schemaAnn.stringValue("type").orElse(typeAndFormat.getFirst()), schemaAnn.stringValue("format").orElse(typeAndFormat.getSecond()), schemaAnn.stringValue("defaultValue").orElse(null), schemaAnn.get((CharSequence)"allowableValues", String[].class).orElse(null));
    }

    private Schema doBindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, JsonNode schemaJson, String elType, String elFormat, String defaultValue, String ... allowableValues) {
        schemaJson = OpenApiApplicationVisitor.resolvePlaceholders(schemaJson, s -> OpenApiApplicationVisitor.expandProperties(s, OpenApiApplicationVisitor.getExpandableProperties(context), context));
        try {
            schemaToBind = (Schema)ConvertUtils.getJsonMapper().readerForUpdating((Object)schemaToBind).readValue(schemaJson);
        }
        catch (IOException e) {
            context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
        }
        if (elType == null && element != null) {
            ClassElement typeEl = ((TypedElement)element).getType();
            Pair<String, String> typeAndFormat = ConvertUtils.getTypeAndFormatByClass(typeEl.getName(), typeEl.isArray());
            elType = typeAndFormat.getFirst();
            if (elFormat == null) {
                elFormat = typeAndFormat.getSecond();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            try {
                schemaToBind.setDefault(ConvertUtils.normalizeValue(defaultValue, elType, elFormat, context));
            }
            catch (IOException e) {
                context.warn("Can't convert " + defaultValue + " to " + elType + ", format: " + elFormat + ": " + e.getMessage(), element);
                schemaToBind.setDefault((Object)defaultValue);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])allowableValues)) {
            for (String allowableValue : allowableValues) {
                if (schemaToBind.getEnum() != null && schemaToBind.getEnum().contains(allowableValue)) continue;
                try {
                    schemaToBind.addEnumItemObject(ConvertUtils.normalizeValue(allowableValue, elType, elFormat, context));
                }
                catch (IOException e) {
                    context.warn("Can't convert " + allowableValue + " to " + elType + ", format: " + elFormat + ": " + e.getMessage(), element);
                    schemaToBind.addEnumItemObject((Object)allowableValue);
                }
            }
        }
        return schemaToBind;
    }

    protected Schema bindArraySchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema> schemaAnn) {
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
        if (schemaJson.isObject()) {
            JsonNode items;
            ObjectNode objNode = (ObjectNode)schemaJson;
            JsonNode arraySchema = objNode.remove("arraySchema");
            if (arraySchema != null && arraySchema.isObject()) {
                ((ObjectNode)arraySchema).remove("implementation");
                objNode.setAll((ObjectNode)arraySchema);
            }
            if ((items = objNode.remove("schema")) != null && schemaToBind != null && schemaToBind.getType().equals("array") && schemaToBind.getItems() != null && schemaToBind.getItems().get$ref() == null) {
                try {
                    schemaToBind.items((Schema)ConvertUtils.getJsonMapper().readerForUpdating((Object)schemaToBind.getItems()).readValue(items));
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
                }
            }
        }
        String elType = schemaJson.has("type") ? schemaJson.get("type").textValue() : null;
        String elFormat = schemaJson.has("format") ? schemaJson.get("format").textValue() : null;
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, elType, elFormat, null, new String[0]);
    }

    private Map<String, Object> annotationValueArrayToSubmap(Object[] a, String classifier, VisitorContext context) {
        LinkedHashMap<String, Object> mediaTypes = new LinkedHashMap<String, Object>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            String name = sv.stringValue(classifier).orElse(null);
            if (name == null && classifier.equals("mediaType")) {
                name = "application/json";
            }
            if (name == null) continue;
            Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
            mediaTypes.put(name, map);
        }
        return mediaTypes;
    }

    private void schemaToValueMap(Map<CharSequence, Object> valueMap, Schema schema) {
        if (schema != null) {
            BeanMap beanMap = BeanMap.of((Object)schema);
            for (Map.Entry e : beanMap.entrySet()) {
                Object v = e.getValue();
                if (v == null) continue;
                valueMap.put((CharSequence)e.getKey(), v);
            }
            if (schema.get$ref() != null) {
                valueMap.put("$ref", schema.get$ref());
            }
        }
    }

    private void bindSchemaIfNeccessary(VisitorContext context, AnnotationValue<?> av, Map<CharSequence, Object> valueMap) {
        String className;
        boolean isSchema;
        Optional impl = av.stringValue("implementation");
        Optional not = av.stringValue("not");
        Optional schema = av.stringValue("schema");
        Optional anyOf = av.get((CharSequence)"anyOf", Argument.of(String[].class));
        Optional oneOf = av.get((CharSequence)"oneOf", Argument.of(String[].class));
        Optional allOf = av.get((CharSequence)"allOf", Argument.of(String[].class));
        Object o = valueMap.remove("defaultValue");
        if (o != null) {
            valueMap.put("default", o);
        }
        if ((o = valueMap.remove("allowableValues")) != null) {
            valueMap.put("enum", o);
        }
        if (isSchema = io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(av.getAnnotationName())) {
            if (impl.isPresent()) {
                className = (String)impl.get();
                this.bindSchemaForClassName(context, valueMap, className);
            }
            if (not.isPresent()) {
                Schema schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement((String)not.get()).get(), context, Collections.emptyList());
                HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
                this.schemaToValueMap(schemaMap, schemaNot);
                valueMap.put("not", schemaMap);
            }
            anyOf.ifPresent(anyOfList -> this.bindSchemaForComposite(context, valueMap, (String[])anyOfList, "anyOf"));
            oneOf.ifPresent(oneOfList -> this.bindSchemaForComposite(context, valueMap, (String[])oneOfList, "oneOf"));
            allOf.ifPresent(allOfList -> this.bindSchemaForComposite(context, valueMap, (String[])allOfList, "allOf"));
        }
        if (DiscriminatorMapping.class.getName().equals(av.getAnnotationName()) && schema.isPresent()) {
            className = (String)schema.get();
            this.bindSchemaForClassName(context, valueMap, className);
        }
    }

    private void bindSchemaForComposite(VisitorContext context, Map<CharSequence, Object> valueMap, String[] classNames, String key) {
        List namesToSchemas = Arrays.stream(classNames).map(className -> {
            Optional classElement = context.getClassElement(className);
            HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
            if (classElement.isPresent()) {
                Schema schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList());
                this.schemaToValueMap(schemaMap, schema);
            }
            return schemaMap;
        }).collect(Collectors.toList());
        valueMap.put(key, namesToSchemas);
    }

    private void bindSchemaForClassName(VisitorContext context, Map<CharSequence, Object> valueMap, String className) {
        Optional classElement = context.getClassElement(className);
        if (classElement.isPresent()) {
            Schema schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList());
            this.schemaToValueMap(valueMap, schema);
        }
    }

    private void checkAllOf(Schema<Object> composedSchema) {
        if (composedSchema != null && composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty() && composedSchema.getProperties() != null && !composedSchema.getProperties().isEmpty()) {
            ObjectSchema propSchema = new ObjectSchema();
            propSchema.properties(composedSchema.getProperties());
            propSchema.setDescription(composedSchema.getDescription());
            propSchema.setRequired(composedSchema.getRequired());
            composedSchema.setProperties(null);
            composedSchema.setDescription(null);
            composedSchema.setRequired(null);
            composedSchema.setType(null);
            composedSchema.addAllOfItem((Schema)propSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema getSchemaDefinition(OpenAPI openAPI, VisitorContext context, ClassElement type, Map<String, ClassElement> typeArgs, @Nullable Element definingElement, List<MediaType> mediaTypes) {
        Schema schema;
        AnnotationValue schemaValue;
        AnnotationValue annotationValue = schemaValue = definingElement == null ? null : definingElement.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (schemaValue == null) {
            schemaValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(openAPI);
        if (schemaValue == null) {
            boolean isBasicType = ClassUtils.isJavaBasicType((String)type.getName());
            PrimitiveType primitiveType = isBasicType ? (PrimitiveType)ClassUtils.forName((String)type.getName(), (ClassLoader)this.getClass().getClassLoader()).map(PrimitiveType::fromType).orElse(null) : null;
            if (primitiveType != null) return primitiveType.createProperty();
            String schemaName = this.computeDefaultSchemaName(definingElement, (Element)type, typeArgs, context);
            schema = schemas.get(schemaName);
            JavadocDescription javadoc = Utils.getJavadocParser().parse(type.getDocumentation().orElse(null));
            if (schema == null) {
                if (type instanceof EnumElement) {
                    schema = new Schema();
                    schema.setName(schemaName);
                    if (javadoc != null && StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    schemas.put(schemaName, schema);
                    EnumElement enumEl = (EnumElement)type;
                    Pair<String, String> typeAndFormat = this.checkEnumJsonValueType(enumEl, schema.getType(), schema.getFormat());
                    schema.setType(typeAndFormat.getFirst());
                    schema.setFormat(typeAndFormat.getSecond());
                    if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                        schema.setEnum(this.getEnumValues(enumEl, schema.getType(), schema.getFormat(), context));
                    }
                } else {
                    Schema schemaWithSuperTypes = this.processSuperTypes(null, schemaName, type, definingElement, openAPI, mediaTypes, schemas, context);
                    if (schemaWithSuperTypes != null) {
                        schema = schemaWithSuperTypes;
                    }
                    if (javadoc != null && StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    this.populateSchemaProperties(openAPI, context, (Element)type, typeArgs, schema, mediaTypes, javadoc);
                    this.checkAllOf((Schema<Object>)schema);
                }
            }
        } else {
            String schemaName = schemaValue.stringValue("name").orElse(this.computeDefaultSchemaName(definingElement, (Element)type, typeArgs, context));
            schema = schemas.get(schemaName);
            if (schema == null) {
                if (this.inProgressSchemas.contains(schemaName)) {
                    return new Schema().$ref(SchemaUtils.schemaRef(schemaName));
                }
                this.inProgressSchemas.add(schemaName);
                try {
                    Schema originalTypeSchema;
                    schema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaValue, openAPI, context, (Element)type, typeArgs, mediaTypes);
                    AnnotationValue typeSchema = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                    if (typeSchema != null && (originalTypeSchema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)typeSchema, openAPI, context, (Element)type, typeArgs, mediaTypes)) != null && schema != null) {
                        if (StringUtils.isNotEmpty((CharSequence)originalTypeSchema.getDescription())) {
                            schema.setDescription(originalTypeSchema.getDescription());
                        }
                        schema.setNullable(originalTypeSchema.getNullable());
                        schema.setRequired(originalTypeSchema.getRequired());
                    }
                    if (schema != null) {
                        this.processSuperTypes(schema, schemaName, type, definingElement, openAPI, mediaTypes, schemas, context);
                    }
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading Swagger Parameter for element [" + type + "]: " + e.getMessage(), (Element)type);
                }
                finally {
                    this.inProgressSchemas.remove(schemaName);
                }
            }
        }
        if (schema == null) return null;
        AnnotationValue externalDocsValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        ExternalDocumentation externalDocs = null;
        if (externalDocsValue != null) {
            externalDocs = this.toValue(externalDocsValue.getValues(), context, ExternalDocumentation.class).orElse(null);
        }
        if (externalDocs != null) {
            schema.setExternalDocs(externalDocs);
        }
        this.setSchemaDocumentation((Element)type, schema);
        Schema schemaRef = new Schema();
        schemaRef.set$ref(SchemaUtils.schemaRef(schema.getName()));
        if (!(definingElement instanceof ClassElement) || !((ClassElement)definingElement).isIterable()) return schemaRef;
        schemaRef.setDescription(schema.getDescription());
        return schemaRef;
    }

    private Schema processSuperTypes(Schema schema, String schemaName, ClassElement type, @Nullable Element definingElement, OpenAPI openAPI, List<MediaType> mediaTypes, Map<String, Schema> schemas, VisitorContext context) {
        if (type.getName().equals(Object.class.getName())) {
            return null;
        }
        ClassElement classElement = type.getType();
        ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
        Collection parentInterfaces = classElement.getInterfaces();
        if (classElement.isInterface() && !parentInterfaces.isEmpty()) {
            for (ClassElement parentInterface : parentInterfaces) {
                if (ClassUtils.isJavaLangType((String)parentInterface.getName()) || parentInterface.getBeanProperties().isEmpty()) continue;
                superTypes.add(parentInterface);
            }
        } else {
            classElement.getSuperType().ifPresent(superTypes::add);
        }
        if (!type.isRecord() && !superTypes.isEmpty()) {
            String firstSuperTypeName = ((ClassElement)superTypes.get(0)).getName();
            if (superTypes.size() == 1 && (firstSuperTypeName.equals(Enum.class.getName()) || firstSuperTypeName.equals(Object.class.getName()))) {
                schema.setName(schemaName);
                schemas.put(schemaName, schema);
                return null;
            }
            if (schema == null) {
                schema = new ComposedSchema();
                schema.setType("object");
            }
            for (ClassElement sType : superTypes) {
                Map sTypeArgs = sType.getTypeArguments();
                ClassElement customStype = OpenApiApplicationVisitor.getCustomSchema(sType.getName(), sTypeArgs, context);
                if (customStype != null) {
                    sType = customStype;
                }
                this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, sType, schemas, sTypeArgs);
            }
        } else if (schema == null) {
            schema = new Schema();
            schema.setType("object");
        }
        schema.setName(schemaName);
        schemas.put(schemaName, schema);
        return schema;
    }

    private void readAllInterfaces(OpenAPI openAPI, VisitorContext context, @Nullable Element definingElement, List<MediaType> mediaTypes, Schema schema, ClassElement superType, Map<String, Schema> schemas, Map<String, ClassElement> superTypeArgs) {
        String parentSchemaName = superType.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(this.computeDefaultSchemaName(definingElement, (Element)superType, superTypeArgs, context));
        if (schemas.get(parentSchemaName) != null || this.getSchemaDefinition(openAPI, context, superType, superTypeArgs, null, mediaTypes) != null) {
            Schema parentSchema = new Schema();
            parentSchema.set$ref(SchemaUtils.schemaRef(parentSchemaName));
            if (schema.getAllOf() == null || !schema.getAllOf().contains(parentSchema)) {
                schema.addAllOfItem(parentSchema);
            }
        }
        if (superType.isInterface()) {
            for (ClassElement interfaceElement : superType.getInterfaces()) {
                if (ClassUtils.isJavaLangType((String)interfaceElement.getName()) || interfaceElement.getBeanProperties().isEmpty()) continue;
                Map interfaceTypeArgs = interfaceElement.getTypeArguments();
                ClassElement customInterfaceType = OpenApiApplicationVisitor.getCustomSchema(interfaceElement.getName(), interfaceTypeArgs, context);
                if (customInterfaceType != null) {
                    interfaceElement = customInterfaceType;
                }
                this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, interfaceElement, schemas, interfaceTypeArgs);
            }
        } else if (superType.getSuperType().isPresent()) {
            ClassElement superSuperType = (ClassElement)superType.getSuperType().get();
            Map superSuperTypeArgs = superSuperType.getTypeArguments();
            ClassElement customSuperSuperType = OpenApiApplicationVisitor.getCustomSchema(superSuperType.getName(), superSuperTypeArgs, context);
            if (customSuperSuperType != null) {
                superSuperType = customSuperSuperType;
            }
            this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, superSuperType, schemas, superSuperTypeArgs);
        }
    }

    protected Schema readSchema(AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaValue, OpenAPI openAPI, VisitorContext context, @Nullable Element type, Map<String, ClassElement> typeArgs, List<MediaType> mediaTypes) throws JsonProcessingException {
        Object[] oneOf;
        Object[] anyOf;
        Object[] allOf;
        Object[] allowableValues;
        Map<CharSequence, Object> values = schemaValue.getValues().entrySet().stream().collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schemaOpt = this.toValue(values, context, Schema.class);
        if (!schemaOpt.isPresent()) {
            return null;
        }
        Schema schema = schemaOpt.get();
        String elType = (String)values.get("type");
        String elFormat = (String)values.get("format");
        if (elType == null && type instanceof TypedElement) {
            TypedElement typedType = (TypedElement)type;
            Object[] typeAndFormat = ConvertUtils.getTypeAndFormatByClass(typedType.getName(), typedType.isArray());
            elType = typeAndFormat.getFirst();
            if (elFormat == null) {
                elFormat = (String)typeAndFormat.getSecond();
            }
        }
        if (values.containsKey("allowableValues") && ArrayUtils.isNotEmpty((Object[])(allowableValues = (String[])values.get("allowableValues")))) {
            for (Object allowableValue : allowableValues) {
                if (schema.getEnum() != null && schema.getEnum().contains(allowableValue)) continue;
                try {
                    schema.addEnumItemObject(ConvertUtils.normalizeValue((String)allowableValue, elType, elFormat, context));
                }
                catch (IOException e2) {
                    context.warn("Can't convert " + (String)allowableValue + " to " + elType + ": " + e2.getMessage(), type);
                    schema.addEnumItemObject(allowableValue);
                }
            }
        }
        String defaultValue = schemaValue.stringValue("defaultValue").orElse(null);
        try {
            schema.setDefault(ConvertUtils.normalizeValue(defaultValue, elType, elFormat, context));
        }
        catch (IOException e3) {
            context.warn("Can't convert " + defaultValue + " to " + elType + ": " + e3.getMessage(), type);
            schema.setDefault((Object)defaultValue);
        }
        Schema composedSchema = schema;
        AnnotationClassValue not = (AnnotationClassValue)values.get("not");
        if (not != null) {
            Schema schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement(not.getName()).get(), context, Collections.emptyList());
            composedSchema.setNot(schemaNot);
        }
        if (ArrayUtils.isNotEmpty((Object[])(allOf = (AnnotationClassValue[])values.get("allOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])allOf, mediaTypes);
            for (Schema<?> schema2 : schemaList) {
                composedSchema.addAllOfItem(schema2);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(anyOf = (AnnotationClassValue[])values.get("anyOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])anyOf, mediaTypes);
            for (Schema<?> schema3 : schemaList) {
                composedSchema.addAnyOfItem(schema3);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(oneOf = (AnnotationClassValue[])values.get("oneOf")))) {
            List<Schema<?>> list = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])oneOf, mediaTypes);
            for (Schema<?> schema4 : list) {
                composedSchema.addOneOfItem(schema4);
            }
        }
        if (schema.getType() == null) {
            schema.setType("object");
        }
        if (type instanceof EnumElement) {
            EnumElement enumElement = (EnumElement)type;
            Pair<String, String> pair = this.checkEnumJsonValueType(enumElement, elType != null ? elType : PrimitiveType.STRING.getCommonName(), null);
            schema.setType(pair.getFirst());
            if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                schema.setEnum(this.getEnumValues((EnumElement)type, schema.getType(), elFormat, context));
            }
        } else {
            JavadocDescription javadocDescription = Utils.getJavadocParser().parse(type.getDescription());
            this.populateSchemaProperties(openAPI, context, type, typeArgs, schema, mediaTypes, javadocDescription);
            this.checkAllOf((Schema<Object>)composedSchema);
        }
        return schema;
    }

    @NonNull
    private Pair<String, String> checkEnumJsonValueType(@NonNull EnumElement type, @Nullable String schemaType, @Nullable String schemaFormat) {
        if (schemaType != null && !schemaType.equals(PrimitiveType.STRING.getCommonName())) {
            return Pair.of(schemaType, schemaFormat);
        }
        Pair<String, String> result = null;
        for (MethodElement method : type.getEnclosedElements(ElementQuery.ALL_METHODS)) {
            if (!method.isAnnotationPresent(JsonValue.class)) continue;
            result = ConvertUtils.getTypeAndFormatByClass(method.getReturnType().getName(), method.getReturnType().isArray());
            break;
        }
        return result != null ? result : Pair.of(PrimitiveType.STRING.getCommonName(), schemaFormat);
    }

    private List<Object> getEnumValues(EnumElement type, String schemaType, String schemaFormat, VisitorContext context) {
        ArrayList<Object> enumValues = new ArrayList<Object>();
        for (EnumConstantElement element : type.elements()) {
            String jacksonValue;
            AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
            boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
            if (isHidden || element.isAnnotationPresent(Hidden.class) || element.isAnnotationPresent(JsonIgnore.class)) continue;
            AnnotationValue jsonProperty = element.getAnnotation(JsonProperty.class);
            String string = jacksonValue = jsonProperty != null ? (String)jsonProperty.stringValue("value").get() : null;
            if (StringUtils.hasText(jacksonValue)) {
                try {
                    enumValues.add(ConvertUtils.normalizeValue(jacksonValue, schemaType, schemaFormat, context));
                }
                catch (JsonProcessingException e) {
                    context.warn("Error converting jacksonValue " + jacksonValue + " : to " + type + ": " + e.getMessage(), (Element)element);
                    enumValues.add(element.getSimpleName());
                }
                continue;
            }
            enumValues.add(element.getSimpleName());
        }
        return enumValues;
    }

    private List<Schema<?>> namesToSchemas(OpenAPI openAPI, VisitorContext context, AnnotationClassValue<?>[] names, List<MediaType> mediaTypes) {
        return Arrays.stream(names).flatMap(classAnn -> {
            Optional classElementOpt = context.getClassElement(classAnn.getName());
            if (classElementOpt.isPresent()) {
                Schema schemaDefinition;
                ClassElement classElement = (ClassElement)classElementOpt.get();
                Map classElementTypeArgs = classElement.getTypeArguments();
                ClassElement customClassElement = OpenApiApplicationVisitor.getCustomSchema(classElement.getName(), classElementTypeArgs, context);
                if (customClassElement != null) {
                    classElement = customClassElement;
                }
                if ((schemaDefinition = this.getSchemaDefinition(openAPI, context, classElement, classElementTypeArgs, null, mediaTypes)) != null) {
                    return Stream.of(schemaDefinition);
                }
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private String computeDefaultSchemaName(Element definingElement, Element type, Map<String, ClassElement> typeArgs, VisitorContext context) {
        String javaName;
        String packageName;
        String metaAnnName;
        String string = metaAnnName = definingElement == null ? null : (String)definingElement.getAnnotationNameByStereotype(io.swagger.v3.oas.annotations.media.Schema.class).orElse(null);
        if (metaAnnName != null && !io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(metaAnnName)) {
            return NameUtils.getSimpleName((String)metaAnnName);
        }
        if (type instanceof TypedElement && !(type instanceof EnumElement)) {
            ClassElement typeType = ((TypedElement)type).getType();
            packageName = typeType.getPackageName();
            javaName = CollectionUtils.isNotEmpty((Map)typeType.getTypeArguments()) ? this.computeNameWithGenerics(typeType, typeArgs, context) : this.computeNameWithGenerics(typeType, Collections.emptyMap(), context);
        } else {
            javaName = type.getSimpleName();
            packageName = NameUtils.getPackageName((String)type.getName());
        }
        OpenApiApplicationVisitor.SchemaDecorator schemaDecorator = OpenApiApplicationVisitor.getSchemaDecoration(packageName, context);
        javaName = javaName.replace("$", ".");
        if (schemaDecorator != null) {
            javaName = (StringUtils.hasText((CharSequence)schemaDecorator.getPrefix()) ? schemaDecorator.getPrefix() : "") + javaName + (StringUtils.hasText((CharSequence)schemaDecorator.getPostfix()) ? schemaDecorator.getPostfix() : "");
        }
        return javaName;
    }

    private String computeNameWithGenerics(ClassElement classElement, Map<String, ClassElement> typeArgs, VisitorContext context) {
        StringBuilder builder = new StringBuilder(classElement.getSimpleName());
        this.computeNameWithGenerics(classElement, builder, new HashSet<String>(), typeArgs, context);
        return builder.toString();
    }

    private void computeNameWithGenerics(ClassElement classElement, StringBuilder builder, Set<String> computed, Map<String, ClassElement> typeArgs, VisitorContext context) {
        computed.add(classElement.getName());
        Map<String, ClassElement> typeArguments = typeArgs;
        Iterator<ClassElement> i = typeArguments.values().iterator();
        if (i.hasNext()) {
            builder.append('_');
            while (i.hasNext()) {
                ClassElement ce = i.next();
                builder.append(ce.getSimpleName());
                Map ceTypeArgs = ce.getTypeArguments();
                ClassElement customElement = OpenApiApplicationVisitor.getCustomSchema(ce.getName(), ceTypeArgs, context);
                if (customElement != null) {
                    ce = customElement;
                }
                if (!computed.contains(ce.getName())) {
                    this.computeNameWithGenerics(ce, builder, computed, ceTypeArgs, context);
                }
                if (!i.hasNext()) continue;
                builder.append('.');
            }
            builder.append('_');
        }
    }

    static boolean isJavaElement(ClassElement classElement, VisitorContext context) {
        return classElement != null && "io.micronaut.annotation.processing.visitor.JavaClassElement".equals(classElement.getClass().getName()) && "io.micronaut.annotation.processing.visitor.JavaVisitorContext".equals(context.getClass().getName());
    }

    private void populateSchemaProperties(OpenAPI openAPI, VisitorContext context, Element type, Map<String, ClassElement> typeArgs, Schema schema, List<MediaType> mediaTypes, JavadocDescription classJavadoc) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            classElement = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            classElement = ((TypedElement)type).getType();
        }
        if (classElement != null) {
            List<Object> beanProperties;
            try {
                beanProperties = classElement.getBeanProperties().stream().filter(p -> !"groovy.lang.MetaClass".equals(p.getType().getName())).collect(Collectors.toList());
            }
            catch (Exception e) {
                beanProperties = Collections.emptyList();
            }
            this.processPropertyElements(openAPI, context, type, typeArgs, schema, beanProperties, mediaTypes, classJavadoc);
            String visibilityLevelProp = OpenApiApplicationVisitor.getConfigurationProperty("micronaut.openapi.field.visibility.level", context);
            VisibilityLevel visibilityLevel = VisibilityLevel.PUBLIC;
            if (StringUtils.hasText((CharSequence)visibilityLevelProp)) {
                try {
                    visibilityLevel = VisibilityLevel.valueOf(visibilityLevelProp.toUpperCase());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Wrong value for visibility level property: " + OpenApiApplicationVisitor.getConfigurationProperty("micronaut.openapi.field.visibility.level", context));
                }
            }
            ArrayList<FieldElement> publicFields = new ArrayList<FieldElement>();
            for (FieldElement field : classElement.getFields()) {
                if (field.isStatic() || visibilityLevel == VisibilityLevel.PUBLIC && !field.isPublic() || visibilityLevel == VisibilityLevel.PROTECTED && !field.isPublic() && !field.isProtected() || visibilityLevel == VisibilityLevel.PACKAGE && !field.isPublic() && !field.isProtected() && !field.isPackagePrivate()) continue;
                boolean alreadyProcessed = false;
                for (PropertyElement prop : beanProperties) {
                    if (!prop.getName().equals(field.getName())) continue;
                    alreadyProcessed = true;
                    break;
                }
                if (alreadyProcessed) continue;
                publicFields.add(field);
            }
            this.processPropertyElements(openAPI, context, type, typeArgs, schema, publicFields, mediaTypes, classJavadoc);
        }
    }

    private void processPropertyElements(OpenAPI openAPI, VisitorContext context, Element type, Map<String, ClassElement> typeArgs, Schema schema, List<? extends TypedElement> publicFields, List<MediaType> mediaTypes, JavadocDescription classJavadoc) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            classElement = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            classElement = ((TypedElement)type).getType();
        }
        for (TypedElement typedElement : publicFields) {
            ClassElement genericType;
            boolean isHidden = typedElement.getAnnotationMetadata().booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "hidden").orElse(false);
            AnnotationValue jsonAnySetterAnn = typedElement.getAnnotation(JsonAnySetter.class);
            if (typedElement.isAnnotationPresent(JsonIgnore.class) || typedElement.isAnnotationPresent(Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.booleanValue("enabled").orElse(true).booleanValue() || isHidden) continue;
            JavadocDescription fieldJavadoc = null;
            if (classElement != null) {
                for (FieldElement field : classElement.getFields()) {
                    if (!field.getName().equals(typedElement.getName())) continue;
                    fieldJavadoc = Utils.getJavadocParser().parse(field.getDocumentation().orElse(null));
                    break;
                }
            }
            if (!(typedElement instanceof MemberElement) || !((MemberElement)typedElement).getDeclaringType().getType().getName().equals(type.getName())) continue;
            ClassElement fieldType = typedElement.getType();
            if (typedElement.getType() instanceof GenericPlaceholderElement && (genericType = typeArgs.get(((GenericPlaceholderElement)typedElement.getType()).getVariableName())) != null) {
                fieldType = genericType;
            }
            Schema propertySchema = this.resolveSchema(openAPI, (Element)typedElement, fieldType, context, mediaTypes, fieldJavadoc, classJavadoc);
            this.processSchemaProperty(context, typedElement, fieldType, type, schema, propertySchema);
        }
    }

    private Schema getPrimitiveType(String typeName) {
        Class concreteType;
        Class wrapperType;
        PrimitiveType primitiveType;
        Schema schema = null;
        Optional aClass = ClassUtils.getPrimitiveType((String)typeName);
        if (!aClass.isPresent()) {
            aClass = ClassUtils.forName((String)typeName, (ClassLoader)this.getClass().getClassLoader());
        }
        if (aClass.isPresent() && (primitiveType = PrimitiveType.fromType(wrapperType = ReflectionUtils.getWrapperType((Class)(concreteType = (Class)aClass.get())))) != null) {
            schema = primitiveType.createProperty();
        }
        return schema;
    }

    protected void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(SecurityScheme.class);
        OpenAPI openAPI = Utils.resolveOpenAPI(context);
        for (AnnotationValue securityRequirementAnnotationValue : values) {
            Map<CharSequence, Object> map = this.toValueMap(securityRequirementAnnotationValue.getValues(), context);
            securityRequirementAnnotationValue.stringValue("name").ifPresent(name -> {
                if (map.containsKey("paramName")) {
                    map.put("name", map.remove("paramName"));
                }
                Utils.normalizeEnumValues(map, CollectionUtils.mapOf((Object[])new Object[]{"type", SecurityScheme.Type.class, "in", SecurityScheme.In.class}));
                String type = (String)map.get("type");
                if (!SecurityScheme.Type.APIKEY.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "name", context, false);
                    this.removeAndWarnSecSchemeProp(map, "in", context);
                }
                if (!SecurityScheme.Type.OAUTH2.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "flows", context);
                }
                if (!SecurityScheme.Type.OPENIDCONNECT.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "openIdConnectUrl", context);
                }
                if (!SecurityScheme.Type.HTTP.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "scheme", context);
                    this.removeAndWarnSecSchemeProp(map, "bearerFormat", context);
                }
                if (SecurityScheme.Type.HTTP.toString().equals(type)) {
                    if (!map.containsKey("scheme")) {
                        context.warn("Can't use http security scheme without 'scheme' property", null);
                    } else if (!map.get("scheme").equals("bearer") && map.containsKey("bearerFormat")) {
                        context.warn("Should NOT have a `bearerFormat` property without `scheme: bearer` being set", null);
                    }
                }
                if (map.containsKey("ref") || map.containsKey("$ref")) {
                    Object ref = map.get("ref");
                    if (ref == null) {
                        ref = map.get("$ref");
                    }
                    map.clear();
                    map.put("$ref", ref);
                }
                try {
                    JsonNode node = this.toJson(map, context);
                    io.swagger.v3.oas.models.security.SecurityScheme securityScheme = ConvertUtils.treeToValue(node, io.swagger.v3.oas.models.security.SecurityScheme.class, context);
                    if (securityScheme != null) {
                        ConvertUtils.resolveExtensions(node).ifPresent(extensions -> BeanMap.of((Object)securityScheme).put((Object)"extensions", extensions));
                        Utils.resolveComponents(openAPI).addSecuritySchemes(name, securityScheme);
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
        }
    }

    private void removeAndWarnSecSchemeProp(Map<CharSequence, Object> map, String prop, VisitorContext context) {
        this.removeAndWarnSecSchemeProp(map, prop, context, true);
    }

    private void removeAndWarnSecSchemeProp(Map<CharSequence, Object> map, String prop, VisitorContext context, boolean withWarn) {
        if (map.containsKey(prop) && withWarn) {
            context.warn("'" + prop + "' property can't set for securityScheme with type " + map.get("type") + ". Skip it", null);
        }
        map.remove(prop);
    }

    protected <T, A extends Annotation> List<T> processOpenApiAnnotation(Element element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                Optional<T> tagOpt;
                Map values;
                if (tag.getAnnotationName().equals(io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName()) && !tag.getValues().isEmpty()) {
                    Object name = tag.getValues().get("name");
                    ArrayList scopes = Optional.ofNullable(tag.getValues().get("scopes")).orElse(new ArrayList());
                    values = Collections.singletonMap((CharSequence)name, scopes);
                } else {
                    values = tag.getValues();
                }
                if (!(tagOpt = this.toValue(values, context, modelType)).isPresent()) continue;
                T tagObj = tagOpt.get();
                boolean alreadyExists = false;
                if (CollectionUtils.isNotEmpty(tagList) && tag.getAnnotationName().equals(Tag.class.getName())) {
                    for (T existedTag : tagList) {
                        if (!((io.swagger.v3.oas.models.tags.Tag)existedTag).getName().equals(((io.swagger.v3.oas.models.tags.Tag)tagObj).getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                }
                if (alreadyExists) continue;
                tagList.add(tagObj);
            }
        }
        return tagList;
    }
}

