/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.swagger.ObjectMapperFactory;
import io.micronaut.openapi.visitor.Pair;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;

public final class ConvertUtils {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper JSON_MAPPER = ObjectMapperFactory.createJson().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static final ObjectMapper JSON_MAPPER_31 = ObjectMapperFactory.createJson31().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static final ObjectMapper CONVERT_JSON_MAPPER = ObjectMapperFactory.buildStrictGenericObjectMapper().enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS, new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING, new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
    private static final ObjectMapper YAML_MAPPER = ObjectMapperFactory.createYaml();

    private ConvertUtils() {
    }

    public static <T> T treeToValue(JsonNode jn, Class<T> clazz, VisitorContext context) throws JsonProcessingException {
        JsonNode allowableValuesNode;
        Object defaultValue;
        Object value = CONVERT_JSON_MAPPER.treeToValue((TreeNode)jn, clazz);
        if (value == null) {
            return null;
        }
        ConvertUtils.resolveExtensions(jn).ifPresent(extensions -> BeanMap.of((Object)value).put((Object)"extensions", extensions));
        String elType = jn.has("type") ? jn.get("type").textValue() : null;
        String elFormat = jn.has("format") ? jn.get("format").textValue() : null;
        JsonNode defaultValueNode = jn.get("defaultValue");
        try {
            defaultValue = ConvertUtils.normalizeValue(defaultValueNode != null ? defaultValueNode.textValue() : null, elType, elFormat, context);
        }
        catch (JsonProcessingException e) {
            defaultValue = defaultValueNode != null ? defaultValueNode.textValue() : null;
        }
        BeanMap beanMap = BeanMap.of((Object)value);
        if (defaultValue != null) {
            beanMap.put((Object)"default", defaultValue);
        }
        if ((allowableValuesNode = jn.get("allowableValues")) != null && allowableValuesNode.isArray()) {
            ArrayList<Object> allowableValues = new ArrayList<Object>(allowableValuesNode.size());
            for (JsonNode allowableValueNode : allowableValuesNode) {
                if (allowableValueNode == null) continue;
                try {
                    allowableValues.add(ConvertUtils.normalizeValue(allowableValueNode.textValue(), elType, elFormat, context));
                }
                catch (IOException e) {
                    allowableValues.add(allowableValueNode.textValue());
                }
            }
            beanMap.put((Object)"allowableValues", allowableValues);
        }
        return (T)value;
    }

    public static Object normalizeValue(String valueStr, String type, String format, VisitorContext context) throws JsonProcessingException {
        return ConvertUtils.normalizeValue(valueStr, type, format, context, false);
    }

    public static Object normalizeValue(String valueStr, String type, String format, VisitorContext context, boolean isMicronautFormat) throws JsonProcessingException {
        if (valueStr == null) {
            return null;
        }
        if (type == null || type.equals("object")) {
            return CONVERT_JSON_MAPPER.readValue(valueStr, Map.class);
        }
        return ConvertUtils.parseByTypeAndFormat(valueStr, type, format, context, isMicronautFormat);
    }

    public static Optional<Map<String, Object>> resolveExtensions(JsonNode jn) {
        try {
            JsonNode extensionsNode = jn.get("extensions");
            if (extensionsNode != null) {
                return Optional.ofNullable((Map)CONVERT_JSON_MAPPER.convertValue((Object)extensionsNode, MAP_TYPE_REFERENCE));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static SecurityRequirement mapToSecurityRequirement(AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> r) {
        String name = (String)r.getRequiredValue("name", String.class);
        List scopes = r.get((CharSequence)"scopes", String[].class).map(Arrays::asList).orElse(Collections.emptyList());
        SecurityRequirement securityRequirement = new SecurityRequirement();
        securityRequirement.addList(name, scopes);
        return securityRequirement;
    }

    public static Pair<String, String> getTypeAndFormatByClass(String className, boolean isArray) {
        if (className == null) {
            return Pair.of("object", null);
        }
        if (String.class.getName().equals(className) || Character.TYPE.getName().equals(className) || Character.class.getName().equals(className)) {
            return Pair.of("string", null);
        }
        if (Boolean.class.getName().equals(className) || Boolean.TYPE.getName().equals(className)) {
            return Pair.of("boolean", null);
        }
        if (Integer.class.getName().equals(className) || Integer.TYPE.getName().equals(className) || Short.class.getName().equals(className) || Short.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int32");
        }
        if (BigInteger.class.getName().equals(className)) {
            return Pair.of("integer", null);
        }
        if (Long.class.getName().equals(className) || Long.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int64");
        }
        if (Float.class.getName().equals(className) || Float.TYPE.getName().equals(className)) {
            return Pair.of("number", "float");
        }
        if (Double.class.getName().equals(className) || Double.TYPE.getName().equals(className)) {
            return Pair.of("number", "double");
        }
        if (isArray && (Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className))) {
            return Pair.of("string", "byte");
        }
        if (Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int32");
        }
        if (BigDecimal.class.getName().equals(className)) {
            return Pair.of("number", null);
        }
        if (URI.class.getName().equals(className)) {
            return Pair.of("string", "uri");
        }
        if (URL.class.getName().equals(className)) {
            return Pair.of("string", "url");
        }
        if (UUID.class.getName().equals(className)) {
            return Pair.of("string", "uuid");
        }
        if (Number.class.getName().equals(className)) {
            return Pair.of("number", null);
        }
        if (File.class.getName().equals(className)) {
            return Pair.of("string", "binary");
        }
        if (LocalDate.class.getName().equals(className)) {
            return Pair.of("string", "date");
        }
        if (Date.class.getName().equals(className) || Calendar.class.getName().equals(className) || Instant.class.getName().equals(className) || LocalDateTime.class.getName().equals(className) || OffsetDateTime.class.getName().equals(className) || XMLGregorianCalendar.class.getName().equals(className) || ZonedDateTime.class.getName().equals(className)) {
            return Pair.of("string", "date-time");
        }
        if (LocalTime.class.getName().equals(className)) {
            return Pair.of("string", "partial-time");
        }
        return Pair.of("object", null);
    }

    public static Object parseByTypeAndFormat(String valueStr, String type, String format, VisitorContext context, boolean isMicronautFormat) {
        if (valueStr == null) {
            return null;
        }
        if ("array".equals(type) && isMicronautFormat) {
            return valueStr.split(",");
        }
        if (valueStr.isEmpty()) {
            return null;
        }
        try {
            if ("string".equals(type)) {
                if ("uri".equals(format)) {
                    return new URI(valueStr);
                }
                if ("url".equals(format)) {
                    return new URL(valueStr);
                }
                if ("uuid".equals(format)) {
                    return UUID.fromString(valueStr);
                }
                if (format == null) {
                    return valueStr;
                }
            } else {
                if ("boolean".equals(type)) {
                    return Boolean.parseBoolean(valueStr);
                }
                if ("array".equals(type)) {
                    return JSON_MAPPER.readValue(valueStr, List.class);
                }
                if ("integer".equals(type)) {
                    if ("int32".equals(format)) {
                        return Integer.parseInt(valueStr);
                    }
                    if ("int64".equals(format)) {
                        return Long.parseLong(valueStr);
                    }
                    return new BigInteger(valueStr);
                }
                if ("number".equals(type)) {
                    if ("float".equals(format)) {
                        return Float.valueOf(Float.parseFloat(valueStr));
                    }
                    if ("double".equals(format)) {
                        return Double.parseDouble(valueStr);
                    }
                    return new BigDecimal(valueStr);
                }
            }
        }
        catch (Exception e) {
            context.warn("Can't parse value " + valueStr + " with type " + type + " and format " + format, null);
        }
        return valueStr;
    }

    public static ObjectMapper getJsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper getJsonMapper31() {
        return JSON_MAPPER_31;
    }

    public static ObjectMapper getConvertJsonMapper() {
        return CONVERT_JSON_MAPPER;
    }

    public static ObjectMapper getYamlMapper() {
        return YAML_MAPPER;
    }
}

