/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericArgument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.postprocessors.JacksonDiscriminatorPostProcessor;
import io.micronaut.openapi.postprocessors.OpenApiOperationsPostProcessor;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.AnnProcessorEnvironment;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.security.InterceptUrlMapConverter;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import io.micronaut.openapi.visitor.security.SecurityProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled", "micronaut.openapi.server.context.path", "micronaut.openapi.property.naming.strategy", "micronaut.openapi.views.spec", "micronaut.openapi.filename", "micronaut.openapi.json.format", "micronaut.openapi.environments", "micronaut.environment.enabled", "micronaut.openapi.field.visibility.level", "micronaut.openapi.config.file.locations", "micronaut.openapi.target.file", "micronaut.openapi.views.dest.dir", "micronaut.openapi.additional.files", "micronaut.openapi.config.file", "micronaut.openapi.security.enabled"})
public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_ENABLED = "micronaut.openapi.enabled";
    public static final String MICRONAUT_OPENAPI_CONFIG_FILE = "micronaut.openapi.config.file";
    public static final String MICRONAUT_OPENAPI_EXPAND_PREFIX = "micronaut.openapi.expand.";
    public static final String MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH = "micronaut.openapi.server.context.path";
    public static final String MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY = "micronaut.openapi.property.naming.strategy";
    public static final String MICRONAUT_OPENAPI_VIEWS_SPEC = "micronaut.openapi.views.spec";
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    public static final String MICRONAUT_OPENAPI_VIEWS_DEST_DIR = "micronaut.openapi.views.dest.dir";
    public static final String MICRONAUT_OPENAPI_ADDITIONAL_FILES = "micronaut.openapi.additional.files";
    public static final String MICRONAUT_OPENAPI_SECURITY_DEFAULT_SCHEMA_NAME = "micronaut.openapi.security.default-schema-name";
    public static final String MICRONAUT_OPENAPI_FIELD_VISIBILITY_LEVEL = "micronaut.openapi.field.visibility.level";
    public static final String OPENAPI_CONFIG_FILE = "openapi.properties";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_CLASS_TAGS = "micronaut.openapi.endpoint.class.tags";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_SERVERS = "micronaut.openapi.endpoint.servers";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_SECURITY_REQUIREMENTS = "micronaut.openapi.endpoint.security.requirements";
    public static final String MICRONAUT_OPENAPI_JSON_FORMAT = "micronaut.openapi.json.format";
    public static final String MICRONAUT_OPENAPI_FILENAME = "micronaut.openapi.filename";
    public static final String MICRONAUT_OPENAPI_ENVIRONMENTS = "micronaut.openapi.environments";
    public static final String MICRONAUT_ENVIRONMENT_ENABLED = "micronaut.environment.enabled";
    public static final String MICRONAUT_OPENAPI_SECURITY_ENABLED = "micronaut.openapi.security.enabled";
    public static final String MICRONAUT_CONFIG_FILE_LOCATIONS = "micronaut.openapi.config.file.locations";
    private static final String MICRONAUT_ENVIRONMENT = "micronaut.environment";
    private static final String MICRONAUT_ENVIRONMENT_CREATED = "micronaut.environment.created";
    private static final String MICRONAUT_OPENAPI_PROPERTIES = "micronaut.openapi.properties";
    private static final String MICRONAUT_OPENAPI_ENDPOINTS = "micronaut.openapi.endpoints";
    private static final String MICRONAUT_OPENAPI_SCHEMA = "micronaut.openapi.schema";
    private static final String MICRONAUT_CUSTOM_SCHEMAS = "micronaut.internal.custom.schemas";
    private static final String MICRONAUT_OPENAPI_SCHEMA_PREFIX = "micronaut.openapi.schema-prefix";
    private static final String MICRONAUT_OPENAPI_SCHEMA_POSTFIX = "micronaut.openapi.schema-postfix";
    private static final String MICRONAUT_SCHEMA_DECORATORS = "micronaut.internal.schema-decorators";
    private static final String MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES = "micronaut.internal.expandable.props";
    private static final String MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED = "micronaut.internal.expandable.props.loaded";
    private static final String MICRONAUT_INTERNAL_SECURITY_PROPERTIES = "micronaut.internal.security.properties";
    private static final String MICRONAUT_INTERNAL_OPENAPI_ENABLED = "micronaut.internal.openapi.enabled";
    private static final String DEFAULT_SECURITY_SCHEMA_NAME = "Authorization";
    private static final Argument<List<Map.Entry<String, String>>> EXPANDABLE_PROPERTIES_ARGUMENT = new GenericArgument<List<Map.Entry<String, String>>>(){};
    private static final String EXT_YML = ".yml";
    private static final String EXT_YAML = ".yaml";
    private static final String EXT_JSON = ".json";
    private ClassElement classElement;
    private int visitedElements = -1;

    public static boolean isOpenApiEnabled(VisitorContext context) {
        Boolean loadedValue = context.get((CharSequence)MICRONAUT_INTERNAL_OPENAPI_ENABLED, Boolean.class).orElse(null);
        if (loadedValue == null) {
            boolean value = OpenApiApplicationVisitor.getBooleanProperty(MICRONAUT_OPENAPI_ENABLED, true, context);
            context.put((CharSequence)MICRONAUT_INTERNAL_OPENAPI_ENABLED, (Object)value);
            return value;
        }
        return loadedValue;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        try {
            this.incrementVisitedElements(context);
            if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
                return;
            }
            context.info("Generating OpenAPI Documentation");
            OpenAPI openAPI = this.readOpenAPI(element, context);
            this.processSecuritySchemes(element, context);
            this.mergeAdditionalSwaggerFiles(element, context, openAPI);
            List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openAPI.getTags());
            openAPI.setTags(tagList);
            List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
            if (openAPI.getSecurity() != null) {
                securityRequirements.addAll(openAPI.getSecurity());
            }
            openAPI.setSecurity(securityRequirements);
            List<Server> servers = this.processOpenApiAnnotation((Element)element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, openAPI.getServers());
            openAPI.setServers(servers);
            Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            if (attr.isPresent()) {
                OpenAPI existing = (OpenAPI)attr.get();
                Optional.ofNullable(openAPI.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
                this.copyOpenAPI(existing, openAPI);
            } else {
                context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openAPI);
            }
            if (Utils.isTestMode()) {
                Utils.resolveOpenAPI(context);
            }
            this.classElement = element;
        }
        catch (Throwable t) {
            context.warn("Error with processing class:\n" + Utils.printStackTrace(t), (Element)this.classElement);
        }
    }

    public static SchemaDecorator getSchemaDecoration(String packageName, VisitorContext context) {
        HashMap<String, SchemaDecorator> schemaDecorators = context.get((CharSequence)MICRONAUT_SCHEMA_DECORATORS, Map.class).orElse(null);
        if (schemaDecorators != null) {
            return (SchemaDecorator)schemaDecorators.get(packageName);
        }
        schemaDecorators = new HashMap<String, SchemaDecorator>();
        Properties sysProps = System.getProperties();
        OpenApiApplicationVisitor.readSchemaDecorators(sysProps, schemaDecorators, context);
        Properties fileProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
        OpenApiApplicationVisitor.readSchemaDecorators(fileProps, schemaDecorators, context);
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            SchemaDecorator decorator;
            String configuredPackageName;
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_SCHEMA_PREFIX, StringConvention.RAW).entrySet()) {
                configuredPackageName = (String)entry.getKey();
                decorator = (SchemaDecorator)schemaDecorators.get(entry.getKey());
                if (decorator == null) {
                    decorator = new SchemaDecorator();
                    schemaDecorators.put((String)entry.getKey(), decorator);
                }
                decorator.setPrefix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_SCHEMA_POSTFIX, StringConvention.RAW).entrySet()) {
                configuredPackageName = (String)entry.getKey();
                decorator = (SchemaDecorator)schemaDecorators.get(entry.getKey());
                if (decorator == null) {
                    decorator = new SchemaDecorator();
                    schemaDecorators.put((String)entry.getKey(), decorator);
                }
                decorator.setPostfix((String)entry.getValue());
            }
        }
        context.put((CharSequence)MICRONAUT_SCHEMA_DECORATORS, schemaDecorators);
        return (SchemaDecorator)schemaDecorators.get(packageName);
    }

    private static void readSchemaDecorators(Properties props, Map<String, SchemaDecorator> schemaDecorators, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            boolean isPrefix = false;
            String packageName = null;
            if (prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_PREFIX)) {
                packageName = prop.substring(MICRONAUT_OPENAPI_SCHEMA_PREFIX.length() + 1);
                isPrefix = true;
            } else if (prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_POSTFIX)) {
                packageName = prop.substring(MICRONAUT_OPENAPI_SCHEMA_POSTFIX.length() + 1);
            }
            if (StringUtils.isEmpty(packageName)) continue;
            SchemaDecorator schemaDecorator = schemaDecorators.get(packageName);
            if (schemaDecorator == null) {
                schemaDecorator = new SchemaDecorator();
                schemaDecorators.put(packageName, schemaDecorator);
            }
            if (isPrefix) {
                schemaDecorator.setPrefix(props.getProperty(prop));
                continue;
            }
            schemaDecorator.setPostfix(props.getProperty(prop));
        }
    }

    public static ClassElement getCustomSchema(String className, Map<String, ClassElement> typeArgs, VisitorContext context) {
        HashMap<String, CustomSchema> customSchemas = context.get((CharSequence)MICRONAUT_CUSTOM_SCHEMAS, Map.class).orElse(null);
        if (customSchemas != null) {
            String key = OpenApiApplicationVisitor.getClassNameWithGenerics(className, typeArgs);
            CustomSchema customSchema = (CustomSchema)customSchemas.get(key);
            if (customSchema != null) {
                return customSchema.classElement;
            }
            customSchema = (CustomSchema)customSchemas.get(className);
            return customSchema != null ? customSchema.classElement : null;
        }
        customSchemas = new HashMap<String, CustomSchema>();
        Properties sysProps = System.getProperties();
        OpenApiApplicationVisitor.readCustomSchemas(sysProps, customSchemas, context);
        Properties fileProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
        OpenApiApplicationVisitor.readCustomSchemas(fileProps, customSchemas, context);
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_SCHEMA, StringConvention.RAW).entrySet()) {
                String configuredClassName = (String)entry.getKey();
                String targetClassName = (String)entry.getValue();
                OpenApiApplicationVisitor.readCustomSchema(configuredClassName, targetClassName, customSchemas, context);
            }
        }
        context.put((CharSequence)MICRONAUT_CUSTOM_SCHEMAS, customSchemas);
        if (customSchemas.isEmpty()) {
            return null;
        }
        String key = OpenApiApplicationVisitor.getClassNameWithGenerics(className, typeArgs);
        CustomSchema customSchema = (CustomSchema)customSchemas.get(key);
        if (customSchema != null) {
            return customSchema.classElement;
        }
        customSchema = (CustomSchema)customSchemas.get(className);
        return customSchema != null ? customSchema.classElement : null;
    }

    private static String getClassNameWithGenerics(String className, Map<String, ClassElement> typeArgs) {
        StringBuilder key = new StringBuilder(className);
        if (!typeArgs.isEmpty()) {
            key.append('<');
            boolean isFirst = true;
            for (ClassElement typeArg : typeArgs.values()) {
                if (!isFirst) {
                    key.append(',');
                }
                key.append(typeArg.getName());
                isFirst = false;
            }
            key.append('>');
        }
        return key.toString();
    }

    private static void readCustomSchemas(Properties props, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            if (!prop.startsWith(MICRONAUT_OPENAPI_SCHEMA) || prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_PREFIX) || prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_POSTFIX)) continue;
            String className = prop.substring(MICRONAUT_OPENAPI_SCHEMA.length() + 1);
            String targetClassName = props.getProperty(prop);
            OpenApiApplicationVisitor.readCustomSchema(className, targetClassName, customSchemas, context);
        }
    }

    private static void readCustomSchema(String className, String targetClassName, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        if (customSchemas.containsKey(className)) {
            return;
        }
        ClassElement targetClassElement = context.getClassElement(targetClassName).orElse(null);
        if (targetClassElement == null) {
            context.warn("Can't find class " + targetClassName + " in classpath. Skip it.", null);
            return;
        }
        ArrayList<String> configuredTypeArgs = null;
        int genericNameStart = className.indexOf(60);
        if (genericNameStart > 0) {
            String[] generics = className.substring(genericNameStart + 1, className.indexOf(62)).split(",");
            configuredTypeArgs = new ArrayList<String>();
            for (String generic : generics) {
                configuredTypeArgs.add(generic.trim());
            }
        }
        customSchemas.put(className, new CustomSchema(configuredTypeArgs, targetClassElement));
    }

    public static String getConfigurationProperty(String key, VisitorContext context) {
        String value = System.getProperty(key, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(key));
        if (value != null) {
            return value;
        }
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        return environment != null ? (String)environment.get((CharSequence)key, String.class).orElse(null) : null;
    }

    public static SecurityProperties getSecurityProperties(VisitorContext context) {
        SecurityProperties securityProperties = context.get((CharSequence)MICRONAUT_INTERNAL_SECURITY_PROPERTIES, SecurityProperties.class).orElse(null);
        if (securityProperties != null) {
            return securityProperties;
        }
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        List<InterceptUrlMapPattern> interceptUrlMapPatterns = environment != null ? environment.get((CharSequence)"micronaut.security.intercept-url-map", Argument.listOf(InterceptUrlMapPattern.class)).orElse(Collections.emptyList()) : Collections.emptyList();
        String defaultSchemaName = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_SECURITY_DEFAULT_SCHEMA_NAME, context);
        if (StringUtils.isEmpty((CharSequence)defaultSchemaName)) {
            defaultSchemaName = DEFAULT_SECURITY_SCHEMA_NAME;
        }
        boolean tokenEnabled = OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.enabled", false, context);
        securityProperties = new SecurityProperties(OpenApiApplicationVisitor.getBooleanProperty(MICRONAUT_OPENAPI_SECURITY_ENABLED, true, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.enabled", false, context), defaultSchemaName, interceptUrlMapPatterns, tokenEnabled, OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.jwt.enabled", tokenEnabled, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.jwt.bearer", tokenEnabled, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.jwt.cookie.enabled", false, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.oauth2.enabled", false, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.basic-auth.enabled", false, context));
        context.put((CharSequence)MICRONAUT_INTERNAL_SECURITY_PROPERTIES, (Object)securityProperties);
        return securityProperties;
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue, VisitorContext context) {
        String str = OpenApiApplicationVisitor.getConfigurationProperty(property, context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return !"false".equalsIgnoreCase(str);
    }

    @Nullable
    public static Environment getEnv(VisitorContext context) {
        Boolean envCreated;
        if (!OpenApiApplicationVisitor.isEnvEnabled(context)) {
            return null;
        }
        Environment existedEnvironment = context != null ? (Environment)context.get((CharSequence)MICRONAUT_ENVIRONMENT, Environment.class).orElse(null) : null;
        Boolean bl = envCreated = context != null ? (Boolean)context.get((CharSequence)MICRONAUT_ENVIRONMENT_CREATED, Boolean.class).orElse(null) : null;
        if (envCreated != null && envCreated.booleanValue()) {
            return existedEnvironment;
        }
        Environment environment = OpenApiApplicationVisitor.createEnv(context);
        if (context != null) {
            context.put((CharSequence)MICRONAUT_ENVIRONMENT, (Object)environment);
            context.put((CharSequence)MICRONAUT_ENVIRONMENT_CREATED, (Object)true);
        }
        return environment;
    }

    private static boolean isEnvEnabled(VisitorContext context) {
        String isEnabledStr = System.getProperty(MICRONAUT_ENVIRONMENT_ENABLED, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(MICRONAUT_ENVIRONMENT_ENABLED));
        boolean isEnabled = true;
        if (StringUtils.isNotEmpty((CharSequence)isEnabledStr)) {
            isEnabled = Boolean.parseBoolean(isEnabledStr);
        }
        if (context != null) {
            context.put((CharSequence)MICRONAUT_ENVIRONMENT_ENABLED, (Object)isEnabled);
        }
        return isEnabled;
    }

    public static List<String> getActiveEnvs(VisitorContext context) {
        if (!OpenApiApplicationVisitor.isEnvEnabled(context)) {
            return Collections.emptyList();
        }
        String activeEnvStr = System.getProperty(MICRONAUT_OPENAPI_ENVIRONMENTS, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(MICRONAUT_OPENAPI_ENVIRONMENTS));
        List<String> activeEnvs = StringUtils.isNotEmpty((CharSequence)activeEnvStr) ? Stream.of(activeEnvStr).filter(StringUtils::isNotEmpty).flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).collect(Collectors.toList()) : new ArrayList<String>();
        return activeEnvs;
    }

    private static Environment createEnv(final VisitorContext context) {
        ApplicationContextConfiguration configuration = new ApplicationContextConfiguration(){

            public ConversionService<?> getConversionService() {
                DefaultConversionService conversionService = new DefaultConversionService();
                conversionService.addConverter(Map.class, InterceptUrlMapPattern.class, (TypeConverter)new InterceptUrlMapConverter((ConversionService)conversionService));
                return conversionService;
            }

            @NonNull
            public List<String> getEnvironments() {
                return OpenApiApplicationVisitor.getActiveEnvs(context);
            }
        };
        AnnProcessorEnvironment environment = null;
        try {
            environment = new AnnProcessorEnvironment(configuration, context);
            environment.start();
            return environment;
        }
        catch (Exception e) {
            if (context != null) {
                context.warn("Can't create environment: " + e.getMessage(), null);
            }
            return environment;
        }
    }

    private ClassLoader resolveClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return DefaultApplicationContextBuilder.class.getClassLoader();
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_ADDITIONAL_FILES, context);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles)) {
            Path directory = OpenApiApplicationVisitor.resolve(context, Paths.get(additionalSwaggerFiles, new String[0]));
            if (Files.isDirectory(directory, new LinkOption[0])) {
                context.info("Merging Swagger OpenAPI YAML and JSON files from location: " + directory);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, path -> this.isYaml(path.toString().toLowerCase()) || path.toString().toLowerCase().endsWith(EXT_JSON));){
                    stream.forEach(path -> {
                        boolean isYaml = this.isYaml(path.toString().toLowerCase());
                        context.info("Reading Swagger OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + path.getFileName());
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)(isYaml ? ConvertUtils.getYamlMapper() : ConvertUtils.getJsonMapper()).readValue(path.toFile(), OpenAPI.class);
                        }
                        catch (IOException e) {
                            context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)element);
                        }
                        this.copyOpenAPI(openAPI, parsedOpenApi);
                    });
                }
                catch (IOException e) {
                    context.warn("Unable to read  file from " + directory + ": " + e.getMessage(), (Element)element);
                }
            } else {
                context.warn(directory + " does not exist or is not a directory", (Element)element);
            }
        }
    }

    private boolean isYaml(String path) {
        return path.endsWith(EXT_YML) || path.endsWith(EXT_YAML);
    }

    public static Path resolve(VisitorContext context, Path path) {
        Path projectPath;
        if (!path.isAbsolute() && context != null && (projectPath = Utils.getProjectPath(context)) != null) {
            path = projectPath.resolve(path);
        }
        return path.toAbsolutePath();
    }

    static EndpointsConfiguration endpointsConfiguration(VisitorContext context) {
        Optional cfg = context.get((CharSequence)MICRONAUT_OPENAPI_ENDPOINTS, EndpointsConfiguration.class);
        if (cfg.isPresent()) {
            return (EndpointsConfiguration)cfg.get();
        }
        EndpointsConfiguration conf = new EndpointsConfiguration(context, OpenApiApplicationVisitor.readOpenApiConfigFile(context));
        context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINTS, (Object)conf);
        return conf;
    }

    public static Properties readOpenApiConfigFile(VisitorContext context) {
        Properties openApiProperties;
        block14: {
            Optional props;
            Optional optional = props = context != null ? context.get((CharSequence)MICRONAUT_OPENAPI_PROPERTIES, Properties.class) : Optional.empty();
            if (props.isPresent()) {
                return (Properties)props.get();
            }
            openApiProperties = new Properties();
            String cfgFile = System.getProperty(MICRONAUT_OPENAPI_CONFIG_FILE, OPENAPI_CONFIG_FILE);
            if (StringUtils.isNotEmpty((CharSequence)cfgFile)) {
                Path cfg = OpenApiApplicationVisitor.resolve(context, Paths.get(cfgFile, new String[0]));
                if (Files.isReadable(cfg)) {
                    try (BufferedReader reader = Files.newBufferedReader(cfg);){
                        openApiProperties.load(reader);
                        break block14;
                    }
                    catch (IOException e) {
                        if (context != null) {
                            context.warn("Fail to read OpenAPI configuration file: " + e.getMessage(), null);
                        }
                        break block14;
                    }
                }
                if (Files.exists(cfg, new LinkOption[0]) && context != null) {
                    context.warn("Can not read configuration file: " + cfg, null);
                }
            }
        }
        if (context != null) {
            context.put((CharSequence)MICRONAUT_OPENAPI_PROPERTIES, (Object)openApiProperties);
        }
        return openApiProperties;
    }

    private void copyOpenAPI(OpenAPI to, OpenAPI from) {
        if (to != null && from != null) {
            Optional.ofNullable(from.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)to).addTagsItem(arg_0)));
            Optional.ofNullable(from.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)to).addServersItem(arg_0)));
            Optional.ofNullable(from.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)to).addSecurityItem(arg_0)));
            Optional.ofNullable(from.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)to).path(arg_0, arg_1)));
            Optional.ofNullable(from.getComponents()).ifPresent(components -> {
                Map securitySchemes;
                Map schemas = components.getSchemas();
                if (schemas != null && !schemas.isEmpty()) {
                    schemas.forEach((k, v) -> {
                        if (v.getName() == null) {
                            v.setName(k);
                        }
                    });
                    schemas.forEach((arg_0, arg_1) -> ((OpenAPI)to).schema(arg_0, arg_1));
                }
                if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                    securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)to).schemaRequirement(arg_0, arg_1));
                }
            });
            Optional.ofNullable(from.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)to).externalDocs(arg_0));
            Optional.ofNullable(from.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)to).addExtension(arg_0, arg_1)));
        }
    }

    private OpenAPI readOpenAPI(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            Optional<OpenAPI> result = this.toValue(o.getValues(), context, OpenAPI.class);
            result.ifPresent(openAPI -> {
                List securityRequirements = o.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class).stream().map(ConvertUtils::mapToSecurityRequirement).collect(Collectors.toList());
                openAPI.setSecurity(securityRequirements);
            });
            return result;
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, String specFile, Path destinationDir, VisitorContext context) throws IOException {
        String viewSpecification = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_VIEWS_SPEC, context);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, OpenApiApplicationVisitor.readOpenApiConfigFile(context));
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            cfg.setSpecFile(specFile);
            cfg.setServerContextPath(OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH, context));
            cfg.render(destinationDir, context);
        }
    }

    private static PropertyNamingStrategies.NamingBase fromName(String name) {
        if (name == null) {
            return null;
        }
        switch (name.toUpperCase(Locale.US)) {
            case "LOWER_CAMEL_CASE": {
                return new LowerCamelCasePropertyNamingStrategy();
            }
            case "UPPER_CAMEL_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_CAMEL_CASE;
            }
            case "SNAKE_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.SNAKE_CASE;
            }
            case "UPPER_SNAKE_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_SNAKE_CASE;
            }
            case "LOWER_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CASE;
            }
            case "KEBAB_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.KEBAB_CASE;
            }
            case "LOWER_DOT_CASE": {
                return (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_DOT_CASE;
            }
        }
        return null;
    }

    private Optional<Path> getDefaultFilePath(String fileName, VisitorContext context) {
        URI uri;
        Optional generatedFile = context.visitMetaInfFile("swagger/" + fileName, Element.EMPTY_ELEMENT_ARRAY);
        if (generatedFile.isPresent() && (uri = ((GeneratedFile)generatedFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path specPath = Paths.get(uri);
            OpenApiApplicationVisitor.createDirectories(specPath, context);
            return Optional.of(specPath);
        }
        context.warn("Unable to get swagger/" + fileName + " file.", null);
        return Optional.empty();
    }

    private Optional<Path> openApiSpecFile(String fileName, VisitorContext visitorContext) {
        Optional<Path> path = this.userDefinedSpecFile(visitorContext);
        if (path.isPresent()) {
            return path;
        }
        return this.getDefaultFilePath(fileName, visitorContext);
    }

    private Optional<Path> userDefinedSpecFile(VisitorContext context) {
        String targetFile = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_TARGET_FILE, context);
        if (StringUtils.isEmpty((CharSequence)targetFile)) {
            return Optional.empty();
        }
        Path specFile = OpenApiApplicationVisitor.resolve(context, Paths.get(targetFile, new String[0]));
        OpenApiApplicationVisitor.createDirectories(specFile, context);
        return Optional.of(specFile);
    }

    private Path getViewsDestDir(Path defaultSwaggerFilePath, VisitorContext context) {
        String destDir = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_VIEWS_DEST_DIR, context);
        if (StringUtils.isNotEmpty((CharSequence)destDir)) {
            Path destPath = OpenApiApplicationVisitor.resolve(context, Paths.get(destDir, new String[0]));
            OpenApiApplicationVisitor.createDirectories(destPath, context);
            return destPath;
        }
        return defaultSwaggerFilePath.getParent().resolve("views");
    }

    private static void createDirectories(Path f, VisitorContext visitorContext) {
        if (f.getParent() != null) {
            try {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                visitorContext.warn("Fail to create directories for" + f + ": " + e.getMessage(), null);
            }
        }
    }

    private void applyPropertyNamingStrategy(OpenAPI openAPI, VisitorContext visitorContext) {
        String namingStrategyName = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY, visitorContext);
        PropertyNamingStrategies.NamingBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
        if (propertyNamingStrategy != null) {
            visitorContext.info("Using " + namingStrategyName + " property naming strategy.");
            if (openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)openAPI.getComponents().getSchemas())) {
                openAPI.getComponents().getSchemas().values().forEach(model -> {
                    List required;
                    Map properties = model.getProperties();
                    if (properties != null) {
                        Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                        model.getProperties().clear();
                        model.setProperties(newProperties);
                    }
                    if ((required = model.getRequired()) != null) {
                        List updatedRequired = required.stream().map(arg_0 -> ((PropertyNamingStrategies.NamingBase)propertyNamingStrategy).translate(arg_0)).collect(Collectors.toList());
                        required.clear();
                        required.addAll(updatedRequired);
                    }
                });
            }
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openAPI, VisitorContext visitorContext) {
        String serverContextPath = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH, visitorContext);
        if (serverContextPath == null || serverContextPath.isEmpty()) {
            return;
        }
        visitorContext.info("Applying server context path: " + serverContextPath + " to Paths.");
        io.swagger.v3.oas.models.Paths paths = openAPI.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        io.swagger.v3.oas.models.Paths newPaths = new io.swagger.v3.oas.models.Paths();
        for (Map.Entry path : paths.entrySet()) {
            String newPath;
            String mapping = (String)path.getKey();
            String string = newPath = mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping);
            if (!newPath.startsWith("/") && !newPath.startsWith("$")) {
                newPath = "/" + newPath;
            }
            newPaths.addPathItem(newPath, (PathItem)path.getValue());
        }
        openAPI.setPaths(newPaths);
    }

    public static JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, OpenApiApplicationVisitor.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    public static JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.isEmpty()) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), OpenApiApplicationVisitor.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    public static JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.trim().isEmpty()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    public static String expandProperties(String s, List<Map.Entry<String, String>> properties, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.contains("${")) {
            return s;
        }
        if (CollectionUtils.isNotEmpty(properties)) {
            for (Map.Entry<String, String> entry : properties) {
                s = s.replace(entry.getKey(), entry.getValue());
            }
        }
        return OpenApiApplicationVisitor.replacePlaceholders(s, context);
    }

    public static String replacePlaceholders(String value, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)value) || !value.contains("${")) {
            return value;
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> sysProp : System.getProperties().entrySet()) {
                value = value.replace("${" + sysProp.getKey().toString() + "}", sysProp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> fileProp : OpenApiApplicationVisitor.readOpenApiConfigFile(context).entrySet()) {
            value = value.replace("${" + fileProp.getKey().toString() + "}", fileProp.getValue().toString());
        }
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            value = environment.getPlaceholderResolver().resolvePlaceholders(value).orElse(value);
        }
        return value;
    }

    public static List<Map.Entry<String, String>> getExpandableProperties(VisitorContext context) {
        ArrayList<Map.Entry<String, String>> expandableProperties = new ArrayList();
        Optional propertiesLoaded = context.get((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED, Boolean.class);
        if (!propertiesLoaded.orElse(false).booleanValue()) {
            String key;
            AnnProcessorEnvironment env = (AnnProcessorEnvironment)OpenApiApplicationVisitor.getEnv(context);
            Map propertiesFromEnv = null;
            if (env != null) {
                try {
                    propertiesFromEnv = env.getProperties("micronaut.openapi.expand", null);
                }
                catch (Exception e) {
                    context.warn("Error:\n" + Utils.printStackTrace(e), null);
                }
            }
            HashMap<String, String> expandedPropsMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty((Map)propertiesFromEnv)) {
                for (Map.Entry entry : propertiesFromEnv.entrySet()) {
                    expandedPropsMap.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            Properties openapiProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
            for (Map.Entry<Object, Object> entry : openapiProps.entrySet()) {
                key = entry.getKey().toString();
                if (!key.startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)) continue;
                expandedPropsMap.put(key, entry.getValue().toString());
            }
            if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
                for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                    key = entry.getKey().toString();
                    if (!key.startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)) continue;
                    expandedPropsMap.put(key, entry.getValue().toString());
                }
            }
            for (Map.Entry<Object, Object> entry : expandedPropsMap.entrySet()) {
                key = (String)entry.getKey();
                if (key.startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)) {
                    key = key.substring(MICRONAUT_OPENAPI_EXPAND_PREFIX.length());
                }
                expandableProperties.add(new AbstractMap.SimpleImmutableEntry<String, String>("${" + key + '}', (String)entry.getValue()));
            }
            context.put((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES, expandableProperties);
            context.put((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED, (Object)true);
        } else {
            expandableProperties = context.get((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES, EXPANDABLE_PROPERTIES_ARGUMENT).orElse(null);
        }
        return expandableProperties;
    }

    private static OpenAPI resolvePropertyPlaceHolders(OpenAPI openAPI, VisitorContext visitorContext) {
        List<Map.Entry<String, String>> expandableProperties = OpenApiApplicationVisitor.getExpandableProperties(visitorContext);
        if (CollectionUtils.isNotEmpty(expandableProperties)) {
            visitorContext.info("Expanding properties: " + expandableProperties);
        }
        JsonNode root = OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)ConvertUtils.getYamlMapper().convertValue((Object)openAPI, ObjectNode.class), s -> OpenApiApplicationVisitor.expandProperties(s, expandableProperties, visitorContext));
        return (OpenAPI)ConvertUtils.getYamlMapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext context) {
        try {
            String fileNameFromConfig;
            if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
                return;
            }
            if (this.visitedElements == this.visitedElements(context)) {
                return;
            }
            Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            if (!attr.isPresent()) {
                return;
            }
            OpenAPI openAPI = (OpenAPI)attr.get();
            this.processEndpoints(context);
            this.applyPropertyNamingStrategy(openAPI, context);
            this.applyPropertyServerContextPath(openAPI, context);
            openAPI = OpenApiApplicationVisitor.resolvePropertyPlaceHolders(openAPI, context);
            this.sortOpenAPI(openAPI);
            new JacksonDiscriminatorPostProcessor().addMissingDiscriminatorType(openAPI);
            new OpenApiOperationsPostProcessor().processOperations(openAPI);
            if (Utils.isTestMode()) {
                Utils.setTestReferenceAfterPlaceholders(openAPI);
            }
            try {
                Map schemas;
                if (openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)(schemas = openAPI.getComponents().getSchemas()))) {
                    String openApiJson = ConvertUtils.getJsonMapper().writeValueAsString((Object)openAPI);
                    HashSet keySet = new HashSet(schemas.keySet());
                    for (String schemaName : keySet) {
                        if (openApiJson.contains("#/components/schemas/" + schemaName)) continue;
                        schemas.remove(schemaName);
                    }
                }
            }
            catch (JsonProcessingException schemas) {
                // empty catch block
            }
            this.removeEmtpyComponents(openAPI);
            String isJson = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_JSON_FORMAT, context);
            boolean isYaml = !StringUtils.isNotEmpty((CharSequence)isJson) || !isJson.equalsIgnoreCase("true");
            String ext = isYaml ? EXT_YML : EXT_JSON;
            String fileName = "swagger" + ext;
            String documentTitle = "OpenAPI";
            Info info = openAPI.getInfo();
            if (info != null) {
                documentTitle = Optional.ofNullable(info.getTitle()).orElse("application");
                documentTitle = documentTitle.toLowerCase(Locale.US).replace(' ', '-');
                String version = info.getVersion();
                if (version != null) {
                    documentTitle = documentTitle + '-' + version;
                }
                fileName = documentTitle + ext;
            }
            if (StringUtils.isNotEmpty((CharSequence)(fileNameFromConfig = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_FILENAME, context)))) {
                fileName = OpenApiApplicationVisitor.replacePlaceholders(fileNameFromConfig, context) + ext;
                if (fileName.contains("${version}")) {
                    fileName = fileName.replaceAll("\\$\\{version}", info != null && info.getVersion() != null ? info.getVersion() : "");
                }
                if (fileName.contains("${")) {
                    context.warn("Can't set some placeholders in fileName: " + fileName, null);
                }
            }
            this.writeYamlToFile(openAPI, fileName, documentTitle, context, isYaml);
            this.visitedElements = this.visitedElements(context);
        }
        catch (Throwable t) {
            context.warn("Error:\n" + Utils.printStackTrace(t), null);
            throw t;
        }
    }

    public int getOrder() {
        return 100;
    }

    private void removeEmtpyComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas())) {
            components.setSchemas(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getResponses())) {
            components.setResponses(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getParameters())) {
            components.setParameters(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExamples())) {
            components.setExamples(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getRequestBodies())) {
            components.setRequestBodies(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getHeaders())) {
            components.setHeaders(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
            components.setSecuritySchemes(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getLinks())) {
            components.setLinks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getCallbacks())) {
            components.setCallbacks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExtensions())) {
            components.setExtensions(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas()) && CollectionUtils.isEmpty((Map)components.getResponses()) && CollectionUtils.isEmpty((Map)components.getParameters()) && CollectionUtils.isEmpty((Map)components.getExamples()) && CollectionUtils.isEmpty((Map)components.getRequestBodies()) && CollectionUtils.isEmpty((Map)components.getHeaders()) && CollectionUtils.isEmpty((Map)components.getSecuritySchemes()) && CollectionUtils.isEmpty((Map)components.getLinks()) && CollectionUtils.isEmpty((Map)components.getCallbacks()) && CollectionUtils.isEmpty((Map)components.getExtensions())) {
            openAPI.setComponents(null);
        }
    }

    private void sortOpenAPI(OpenAPI openAPI) {
        Components components;
        if (openAPI.getPaths() != null) {
            io.swagger.v3.oas.models.Paths sortedPaths = new io.swagger.v3.oas.models.Paths();
            new TreeMap<String, PathItem>((Map<String, PathItem>)openAPI.getPaths()).forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.Paths)sortedPaths).addPathItem(arg_0, arg_1));
            if (openAPI.getPaths().getExtensions() != null) {
                sortedPaths.setExtensions(new TreeMap(openAPI.getPaths().getExtensions()));
            }
            openAPI.setPaths(sortedPaths);
        }
        if ((components = openAPI.getComponents()) == null) {
            return;
        }
        this.sortAllOf(components.getSchemas());
        this.sortComponent(components, Components::getSchemas, Components::setSchemas);
        this.sortComponent(components, Components::getResponses, Components::setResponses);
        this.sortComponent(components, Components::getParameters, Components::setParameters);
        this.sortComponent(components, Components::getExamples, Components::setExamples);
        this.sortComponent(components, Components::getRequestBodies, Components::setRequestBodies);
        this.sortComponent(components, Components::getHeaders, Components::setHeaders);
        this.sortComponent(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
        this.sortComponent(components, Components::getLinks, Components::setLinks);
        this.sortComponent(components, Components::getCallbacks, Components::setCallbacks);
    }

    private <T> void sortComponent(Components components, Function<Components, Map<String, T>> getter, BiConsumer<Components, Map<String, T>> setter) {
        if (components != null && getter.apply(components) != null) {
            Map<String, T> component = getter.apply(components);
            setter.accept(components, new TreeMap<String, T>(component));
        }
    }

    private void sortAllOf(Map<String, Schema> schemas) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        for (Schema schema : schemas.values()) {
            if (CollectionUtils.isEmpty((Collection)schema.getAllOf()) || schema.getAllOf().size() == 1) continue;
            ArrayList<Object> finalList = new ArrayList<Object>(schema.getAllOf().size());
            ArrayList<Schema> schemasWithoutRef = new ArrayList<Schema>(schema.getAllOf().size() - 1);
            for (Schema schemaAllOf : schema.getAllOf()) {
                if (StringUtils.isEmpty((CharSequence)schemaAllOf.get$ref())) {
                    schemasWithoutRef.add(schemaAllOf);
                    if (!StringUtils.isNotEmpty((CharSequence)schema.getDescription()) || !StringUtils.isNotEmpty((CharSequence)schemaAllOf.getDescription())) continue;
                    schemaAllOf.setDescription(null);
                    continue;
                }
                finalList.add(schemaAllOf);
            }
            finalList.addAll(schemasWithoutRef);
            schema.setAllOf(finalList);
        }
    }

    private void writeYamlToFile(OpenAPI openAPI, String fileName, String documentTitle, VisitorContext context, boolean isYaml) {
        Optional<Path> specFile = this.openApiSpecFile(fileName, context);
        try (Writer writer = this.getFileWriter(specFile);){
            (isYaml ? ConvertUtils.getYamlMapper() : ConvertUtils.getJsonMapper()).writeValue(writer, (Object)openAPI);
            if (Utils.isTestMode()) {
                Utils.setTestFileName(fileName);
                if (isYaml) {
                    Utils.setTestYamlReference(writer.toString());
                } else {
                    Utils.setTestJsonReference(writer.toString());
                }
            } else {
                Path specPath = specFile.get();
                context.info("Writing OpenAPI file to destination: " + specPath);
                Path viewsDestDirs = this.getViewsDestDir(this.getDefaultFilePath(fileName, context).get(), context);
                context.info("Writing OpenAPI views to destination: " + viewsDestDirs);
                context.getClassesOutputPath().ifPresent(path -> {
                    context.addGeneratedResource(path.relativize(specPath).toString());
                    context.addGeneratedResource(path.relativize(specPath.getParent()).toString());
                    context.addGeneratedResource(path.relativize(viewsDestDirs).toString());
                });
                this.renderViews(documentTitle, specPath.getFileName().toString(), viewsDestDirs, context);
            }
        }
        catch (Exception e) {
            context.warn("Unable to generate swagger" + (isYaml ? EXT_YML : EXT_JSON) + ": " + specFile.orElse(null) + " - " + e.getMessage(), (Element)this.classElement);
        }
    }

    private Writer getFileWriter(Optional<Path> specFile) throws IOException {
        if (Utils.isTestMode()) {
            return new StringWriter();
        }
        if (specFile.isPresent()) {
            return Files.newBufferedWriter(specFile.get(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        throw new IOException("Swagger spec file location is not present");
    }

    private void processEndpoints(VisitorContext context) {
        EndpointsConfiguration endpointsCfg = OpenApiApplicationVisitor.endpointsConfiguration(context);
        if (endpointsCfg.isEnabled() && !endpointsCfg.getEndpoints().isEmpty()) {
            OpenApiEndpointVisitor visitor = new OpenApiEndpointVisitor(true);
            endpointsCfg.getEndpoints().values().stream().filter(endpoint -> endpoint.getClassElement().isPresent()).forEach(endpoint -> {
                ClassElement element = endpoint.getClassElement().get();
                context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_CLASS_TAGS, endpoint.getTags());
                context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_SERVERS, endpoint.getServers());
                context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_SECURITY_REQUIREMENTS, endpoint.getSecurityRequirements());
                visitor.visitClass(element, context);
                element.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$"))).forEach(method -> visitor.visitMethod((MethodElement)method, context));
            });
        }
    }

    static final class SchemaDecorator {
        private String prefix;
        private String postfix;

        SchemaDecorator() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }
    }

    static final class CustomSchema {
        private final List<String> typeArgs;
        private final ClassElement classElement;

        private CustomSchema(List<String> typeArgs, ClassElement classElement) {
            this.typeArgs = typeArgs;
            this.classElement = classElement;
        }

        public List<String> getTypeArgs() {
            return this.typeArgs;
        }

        public ClassElement getClassElement() {
            return this.classElement;
        }
    }

    static class LowerCamelCasePropertyNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private static final long serialVersionUID = -2750503285679998670L;

        LowerCamelCasePropertyNamingStrategy() {
        }

        public String translate(String propertyName) {
            return propertyName;
        }
    }
}

