/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SchemaUtils {
    public static final String TYPE_OBJECT = "object";

    private SchemaUtils() {
    }

    public static Map<String, Schema> resolveSchemas(OpenAPI openAPI) {
        Components components = Utils.resolveComponents(openAPI);
        LinkedHashMap schemas = components.getSchemas();
        if (schemas == null) {
            schemas = new LinkedHashMap();
            components.setSchemas(schemas);
        }
        return schemas;
    }

    public static ArraySchema arraySchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(schema);
        return arraySchema;
    }

    public static String schemaRef(String schemaName) {
        return "#/components/schemas/" + schemaName;
    }
}

