/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.micronaut.core.annotation.Internal;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.IOException;
import java.util.Map;

@Internal
public class ApiResponsesSerializer
extends JsonSerializer<ApiResponses> {
    public void serialize(ApiResponses value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null && value.getExtensions() != null && !value.getExtensions().isEmpty()) {
            jgen.writeStartObject();
            if (!value.isEmpty()) {
                for (Map.Entry entry : value.entrySet()) {
                    jgen.writeObjectField((String)entry.getKey(), entry.getValue());
                }
            }
            for (Map.Entry entry : value.getExtensions().entrySet()) {
                jgen.writeObjectField((String)entry.getKey(), entry.getValue());
            }
            jgen.writeEndObject();
        } else {
            provider.defaultSerializeValue((Object)value, jgen);
        }
    }
}

