/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.SimpleSchema;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.JsonSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

@Internal
public class ModelDeserializer
extends JsonDeserializer<Schema> {
    protected boolean openapi31;

    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String format;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Schema schema = null;
        if (this.openapi31) {
            schema = this.deserializeJsonSchema(node);
            return schema;
        }
        if (node.isBoolean()) {
            return new Schema().booleanSchemaValue(Boolean.valueOf(node.booleanValue()));
        }
        List<String> composed = Arrays.asList("allOf", "anyOf", "oneOf");
        for (String field : composed) {
            if (node.get(field) == null) continue;
            return (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, ComposedSchema.class);
        }
        JsonNode type = node.get("type");
        String string = format = node.get("format") == null ? "" : node.get("format").textValue();
        if (type != null && "array".equals(type.textValue())) {
            schema = (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, ArraySchema.class);
        } else if (type != null) {
            if (type.textValue().equals("integer")) {
                schema = (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, IntegerSchema.class);
                if (!StringUtils.hasText((CharSequence)format)) {
                    schema.setFormat(null);
                }
            } else if (type.textValue().equals("number")) {
                schema = (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, NumberSchema.class);
            } else if (type.textValue().equals("boolean")) {
                schema = (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, BooleanSchema.class);
            } else if (type.textValue().equals("string")) {
                schema = "date".equals(format) ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, DateSchema.class) : ("date-time".equals(format) ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, DateTimeSchema.class) : ("email".equals(format) ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, EmailSchema.class) : ("password".equals(format) ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, PasswordSchema.class) : ("uuid".equals(format) ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, UUIDSchema.class) : (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, StringSchema.class)))));
            } else if (type.textValue().equals("object")) {
                schema = this.deserializeObjectSchema(node, true);
            }
        } else {
            schema = node.get("$ref") != null ? new Schema().$ref(node.get("$ref").asText()) : this.deserializeObjectSchema(node, false);
        }
        return schema;
    }

    private Schema deserializeObjectSchema(JsonNode node, boolean withType) {
        Schema schema;
        JsonNode additionalProperties = node.get("additionalProperties");
        if (additionalProperties != null) {
            if (additionalProperties.isBoolean()) {
                Boolean additionalPropsBoolean = (Boolean)ConvertUtils.getJsonMapper().convertValue((Object)additionalProperties, Boolean.class);
                ((ObjectNode)node).remove("additionalProperties");
                schema = additionalPropsBoolean != false ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, MapSchema.class) : (withType ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, ObjectSchema.class) : (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, SimpleSchema.class));
                schema.setAdditionalProperties((Object)additionalPropsBoolean);
            } else {
                Schema innerSchema = (Schema)ConvertUtils.getJsonMapper().convertValue((Object)additionalProperties, Schema.class);
                ((ObjectNode)node).remove("additionalProperties");
                MapSchema ms = (MapSchema)ConvertUtils.getJsonMapper().convertValue((Object)node, MapSchema.class);
                ms.setAdditionalProperties((Object)innerSchema);
                schema = ms;
            }
        } else {
            schema = withType ? (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, ObjectSchema.class) : (Schema)ConvertUtils.getJsonMapper().convertValue((Object)node, SimpleSchema.class);
        }
        if (schema != null) {
            try {
                schema.jsonSchema((Map)ConvertUtils.getJsonMapper31().readValue(ConvertUtils.getJsonMapper31().writeValueAsString((Object)node), Map.class));
            }
            catch (JsonProcessingException e) {
                System.err.println("Exception converting jsonSchema to Map " + e.getMessage());
            }
        }
        return schema;
    }

    private Schema deserializeJsonSchema(JsonNode node) {
        Schema schema;
        block12: {
            if (node.isBoolean()) {
                return new Schema().booleanSchemaValue(Boolean.valueOf(node.booleanValue()));
            }
            JsonNode additionalProperties = node.get("additionalProperties");
            JsonNode type = node.get("type");
            if (type != null || additionalProperties != null) {
                if (type != null) {
                    ((ObjectNode)node).remove("type");
                }
                if (additionalProperties != null) {
                    ((ObjectNode)node).remove("additionalProperties");
                }
                schema = (Schema)ConvertUtils.getJsonMapper31().convertValue((Object)node, JsonSchema.class);
                if (type instanceof TextNode) {
                    schema.types(new LinkedHashSet<String>(Collections.singletonList(type.textValue())));
                } else if (type instanceof ArrayNode) {
                    LinkedHashSet types = new LinkedHashSet();
                    type.elements().forEachRemaining(n -> types.add(n.textValue()));
                    schema.types(types);
                }
                if (additionalProperties != null) {
                    try {
                        if (additionalProperties.isBoolean()) {
                            schema.setAdditionalProperties((Object)additionalProperties.booleanValue());
                            break block12;
                        }
                        Schema innerSchema = this.deserializeJsonSchema(additionalProperties);
                        schema.setAdditionalProperties((Object)innerSchema);
                    }
                    catch (Exception e) {
                        Boolean additionalPropsBoolean = (Boolean)ConvertUtils.getJsonMapper31().convertValue((Object)additionalProperties, Boolean.class);
                        schema.setAdditionalProperties((Object)additionalPropsBoolean);
                    }
                }
            } else {
                schema = (Schema)ConvertUtils.getJsonMapper31().convertValue((Object)node, JsonSchema.class);
            }
        }
        return schema;
    }
}

