/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericArgument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.postprocessors.JacksonDiscriminatorPostProcessor;
import io.micronaut.openapi.postprocessors.OpenApiOperationsPostProcessor;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.AnnProcessorEnvironment;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.micronaut.openapi.visitor.group.RouterVersioningProperties;
import io.micronaut.openapi.visitor.security.InterceptUrlMapConverter;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import io.micronaut.openapi.visitor.security.SecurityProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled", "micronaut.openapi.server.context.path", "micronaut.openapi.property.naming.strategy", "micronaut.openapi.views.spec", "micronaut.openapi.filename", "micronaut.openapi.json.format", "micronaut.openapi.environments", "micronaut.environment.enabled", "micronaut.openapi.field.visibility.level", "micronaut.openapi.config.file.locations", "micronaut.openapi.target.file", "micronaut.openapi.views.dest.dir", "micronaut.openapi.additional.files", "micronaut.openapi.config.file", "micronaut.openapi.security.enabled", "micronaut.openapi.versioning.enabled"})
public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_ENABLED = "micronaut.openapi.enabled";
    public static final String MICRONAUT_OPENAPI_CONFIG_FILE = "micronaut.openapi.config.file";
    public static final String MICRONAUT_OPENAPI_EXPAND_PREFIX = "micronaut.openapi.expand.";
    public static final String MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH = "micronaut.openapi.server.context.path";
    public static final String MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY = "micronaut.openapi.property.naming.strategy";
    public static final String MICRONAUT_OPENAPI_VIEWS_SPEC = "micronaut.openapi.views.spec";
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    public static final String MICRONAUT_OPENAPI_VIEWS_DEST_DIR = "micronaut.openapi.views.dest.dir";
    public static final String MICRONAUT_OPENAPI_ADDITIONAL_FILES = "micronaut.openapi.additional.files";
    public static final String MICRONAUT_OPENAPI_SECURITY_DEFAULT_SCHEMA_NAME = "micronaut.openapi.security.default-schema-name";
    public static final String MICRONAUT_OPENAPI_FIELD_VISIBILITY_LEVEL = "micronaut.openapi.field.visibility.level";
    public static final String OPENAPI_CONFIG_FILE = "openapi.properties";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_CLASS_TAGS = "micronaut.openapi.endpoint.class.tags";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_SERVERS = "micronaut.openapi.endpoint.servers";
    public static final String MICRONAUT_OPENAPI_ENDPOINT_SECURITY_REQUIREMENTS = "micronaut.openapi.endpoint.security.requirements";
    public static final String MICRONAUT_OPENAPI_JSON_FORMAT = "micronaut.openapi.json.format";
    public static final String MICRONAUT_OPENAPI_FILENAME = "micronaut.openapi.filename";
    public static final String MICRONAUT_OPENAPI_ENVIRONMENTS = "micronaut.openapi.environments";
    public static final String MICRONAUT_ENVIRONMENT_ENABLED = "micronaut.environment.enabled";
    public static final String MICRONAUT_OPENAPI_SECURITY_ENABLED = "micronaut.openapi.security.enabled";
    public static final String MICRONAUT_OPENAPI_VERSIONING_ENABLED = "micronaut.openapi.versioning.enabled";
    public static final String MICRONAUT_CONFIG_FILE_LOCATIONS = "micronaut.openapi.config.file.locations";
    public static final String MICRONAUT_SERVER_CONTEXT_PATH = "micronaut.server.context-path";
    public static final String MICRONAUT_INTERNAL_OPENAPI_FILENAMES = "micronaut.internal.openapi.filenames";
    private static final String MICRONAUT_ENVIRONMENT = "micronaut.environment";
    private static final String MICRONAUT_ENVIRONMENT_CREATED = "micronaut.environment.created";
    private static final String MICRONAUT_OPENAPI_PROPERTIES = "micronaut.openapi.properties";
    private static final String MICRONAUT_OPENAPI_ENDPOINTS = "micronaut.openapi.endpoints";
    private static final String MICRONAUT_OPENAPI_SCHEMA = "micronaut.openapi.schema";
    private static final String MICRONAUT_CUSTOM_SCHEMAS = "micronaut.internal.custom.schemas";
    private static final String MICRONAUT_OPENAPI_SCHEMA_PREFIX = "micronaut.openapi.schema-prefix";
    private static final String MICRONAUT_OPENAPI_SCHEMA_POSTFIX = "micronaut.openapi.schema-postfix";
    private static final String MICRONAUT_SCHEMA_DECORATORS = "micronaut.internal.schema-decorators";
    private static final String MICRONAUT_OPENAPI_GROUPS = "micronaut.openapi.groups";
    private static final String MICRONAUT_INTERNAL_GROUPS = "micronaut.internal.groups";
    private static final String MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES = "micronaut.internal.expandable.props";
    private static final String MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED = "micronaut.internal.expandable.props.loaded";
    private static final String MICRONAUT_INTERNAL_SECURITY_PROPERTIES = "micronaut.internal.security.properties";
    private static final String MICRONAUT_INTERNAL_ROUTER_VERSIONING_PROPERTIES = "micronaut.internal.router.versioning.properties";
    private static final String MICRONAUT_INTERNAL_OPENAPI_ENABLED = "micronaut.internal.openapi.enabled";
    private static final String DEFAULT_SECURITY_SCHEMA_NAME = "Authorization";
    private static final Argument<List<Map.Entry<String, String>>> EXPANDABLE_PROPERTIES_ARGUMENT = new GenericArgument<List<Map.Entry<String, String>>>(){};
    private static final String EXT_YML = ".yml";
    private static final String EXT_YAML = ".yaml";
    private static final String EXT_JSON = ".json";
    private ClassElement classElement;
    private int visitedElements = -1;

    public static boolean isOpenApiEnabled(VisitorContext context) {
        Boolean loadedValue = context.get((CharSequence)MICRONAUT_INTERNAL_OPENAPI_ENABLED, Boolean.class).orElse(null);
        if (loadedValue == null) {
            boolean value = OpenApiApplicationVisitor.getBooleanProperty(MICRONAUT_OPENAPI_ENABLED, true, context);
            context.put((CharSequence)MICRONAUT_INTERNAL_OPENAPI_ENABLED, (Object)value);
            System.setProperty(MICRONAUT_OPENAPI_ENABLED, Boolean.toString(value));
            return value;
        }
        return loadedValue;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        try {
            this.incrementVisitedElements(context);
            if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
                return;
            }
            context.info("Generating OpenAPI Documentation");
            OpenAPI openApi = this.readOpenApi(element, context);
            this.processSecuritySchemes(element, context);
            this.mergeAdditionalSwaggerFiles(element, context, openApi);
            List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openApi.getTags());
            openApi.setTags(tagList);
            List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
            if (openApi.getSecurity() != null) {
                securityRequirements.addAll(openApi.getSecurity());
            }
            openApi.setSecurity(securityRequirements);
            List<Server> servers = this.processOpenApiAnnotation((Element)element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, openApi.getServers());
            openApi.setServers(servers);
            Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            if (attr.isPresent()) {
                OpenAPI existing = (OpenAPI)attr.get();
                Optional.ofNullable(openApi.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
                this.copyOpenApi(existing, openApi);
            } else {
                context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openApi);
            }
            if (Utils.isTestMode()) {
                Utils.resolveOpenApi(context);
            }
            this.classElement = element;
        }
        catch (Throwable t) {
            context.warn("Error with processing class:\n" + Utils.printStackTrace(t), (Element)this.classElement);
        }
    }

    public static SchemaDecorator getSchemaDecoration(String packageName, VisitorContext context) {
        HashMap<String, SchemaDecorator> schemaDecorators = context.get((CharSequence)MICRONAUT_SCHEMA_DECORATORS, Map.class).orElse(null);
        if (schemaDecorators != null) {
            return (SchemaDecorator)schemaDecorators.get(packageName);
        }
        schemaDecorators = new HashMap<String, SchemaDecorator>();
        Properties sysProps = System.getProperties();
        OpenApiApplicationVisitor.readSchemaDecorators(sysProps, schemaDecorators, context);
        Properties fileProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
        OpenApiApplicationVisitor.readSchemaDecorators(fileProps, schemaDecorators, context);
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            SchemaDecorator decorator;
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_SCHEMA_PREFIX, StringConvention.RAW).entrySet()) {
                decorator = (SchemaDecorator)schemaDecorators.get(entry.getKey());
                if (decorator == null) {
                    decorator = new SchemaDecorator();
                    schemaDecorators.put((String)entry.getKey(), decorator);
                }
                decorator.setPrefix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_SCHEMA_POSTFIX, StringConvention.RAW).entrySet()) {
                decorator = (SchemaDecorator)schemaDecorators.get(entry.getKey());
                if (decorator == null) {
                    decorator = new SchemaDecorator();
                    schemaDecorators.put((String)entry.getKey(), decorator);
                }
                decorator.setPostfix((String)entry.getValue());
            }
        }
        context.put((CharSequence)MICRONAUT_SCHEMA_DECORATORS, schemaDecorators);
        return (SchemaDecorator)schemaDecorators.get(packageName);
    }

    private static void readSchemaDecorators(Properties props, Map<String, SchemaDecorator> schemaDecorators, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            boolean isPrefix = false;
            String packageName = null;
            if (prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_PREFIX)) {
                packageName = prop.substring(MICRONAUT_OPENAPI_SCHEMA_PREFIX.length() + 1);
                isPrefix = true;
            } else if (prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_POSTFIX)) {
                packageName = prop.substring(MICRONAUT_OPENAPI_SCHEMA_POSTFIX.length() + 1);
            }
            if (StringUtils.isEmpty(packageName)) continue;
            SchemaDecorator schemaDecorator = schemaDecorators.get(packageName);
            if (schemaDecorator == null) {
                schemaDecorator = new SchemaDecorator();
                schemaDecorators.put(packageName, schemaDecorator);
            }
            if (isPrefix) {
                schemaDecorator.setPrefix(props.getProperty(prop));
                continue;
            }
            schemaDecorator.setPostfix(props.getProperty(prop));
        }
    }

    public static ClassElement getCustomSchema(String className, Map<String, ClassElement> typeArgs, VisitorContext context) {
        HashMap<String, CustomSchema> customSchemas = context.get((CharSequence)MICRONAUT_CUSTOM_SCHEMAS, Map.class).orElse(null);
        if (customSchemas != null) {
            String key = OpenApiApplicationVisitor.getClassNameWithGenerics(className, typeArgs);
            CustomSchema customSchema = (CustomSchema)customSchemas.get(key);
            if (customSchema != null) {
                return customSchema.classElement;
            }
            customSchema = (CustomSchema)customSchemas.get(className);
            return customSchema != null ? customSchema.classElement : null;
        }
        customSchemas = new HashMap<String, CustomSchema>();
        Properties sysProps = System.getProperties();
        OpenApiApplicationVisitor.readCustomSchemas(sysProps, customSchemas, context);
        Properties fileProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
        OpenApiApplicationVisitor.readCustomSchemas(fileProps, customSchemas, context);
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_SCHEMA, StringConvention.RAW).entrySet()) {
                String configuredClassName = (String)entry.getKey();
                String targetClassName = (String)entry.getValue();
                OpenApiApplicationVisitor.readCustomSchema(configuredClassName, targetClassName, customSchemas, context);
            }
        }
        context.put((CharSequence)MICRONAUT_CUSTOM_SCHEMAS, customSchemas);
        if (customSchemas.isEmpty()) {
            return null;
        }
        String key = OpenApiApplicationVisitor.getClassNameWithGenerics(className, typeArgs);
        CustomSchema customSchema = (CustomSchema)customSchemas.get(key);
        if (customSchema != null) {
            return customSchema.classElement;
        }
        customSchema = (CustomSchema)customSchemas.get(className);
        return customSchema != null ? customSchema.classElement : null;
    }

    private static String getClassNameWithGenerics(String className, Map<String, ClassElement> typeArgs) {
        StringBuilder key = new StringBuilder(className);
        if (!typeArgs.isEmpty()) {
            key.append('<');
            boolean isFirst = true;
            for (ClassElement typeArg : typeArgs.values()) {
                if (!isFirst) {
                    key.append(',');
                }
                key.append(typeArg.getName());
                isFirst = false;
            }
            key.append('>');
        }
        return key.toString();
    }

    private static void readCustomSchemas(Properties props, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            if (!prop.startsWith(MICRONAUT_OPENAPI_SCHEMA) || prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_PREFIX) || prop.startsWith(MICRONAUT_OPENAPI_SCHEMA_POSTFIX)) continue;
            String className = prop.substring(MICRONAUT_OPENAPI_SCHEMA.length() + 1);
            String targetClassName = props.getProperty(prop);
            OpenApiApplicationVisitor.readCustomSchema(className, targetClassName, customSchemas, context);
        }
    }

    private static void readCustomSchema(String className, String targetClassName, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        if (customSchemas.containsKey(className)) {
            return;
        }
        ClassElement targetClassElement = context.getClassElement(targetClassName).orElse(null);
        if (targetClassElement == null) {
            context.warn("Can't find class " + targetClassName + " in classpath. Skip it.", null);
            return;
        }
        ArrayList<String> configuredTypeArgs = null;
        int genericNameStart = className.indexOf(60);
        if (genericNameStart > 0) {
            String[] generics = className.substring(genericNameStart + 1, className.indexOf(62)).split(",");
            configuredTypeArgs = new ArrayList<String>();
            for (String generic : generics) {
                configuredTypeArgs.add(generic.trim());
            }
        }
        customSchemas.put(className, new CustomSchema(configuredTypeArgs, targetClassElement));
    }

    public static String getConfigurationProperty(String key, VisitorContext context) {
        String value = System.getProperty(key);
        if (value == null) {
            value = OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(key);
        }
        if (value != null) {
            return value;
        }
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        return environment != null ? (String)environment.get((CharSequence)key, String.class).orElse(null) : null;
    }

    public static SecurityProperties getSecurityProperties(VisitorContext context) {
        SecurityProperties securityProperties = context.get((CharSequence)MICRONAUT_INTERNAL_SECURITY_PROPERTIES, SecurityProperties.class).orElse(null);
        if (securityProperties != null) {
            return securityProperties;
        }
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        List<InterceptUrlMapPattern> interceptUrlMapPatterns = environment != null ? environment.get((CharSequence)"micronaut.security.intercept-url-map", Argument.listOf(InterceptUrlMapPattern.class)).orElse(Collections.emptyList()) : Collections.emptyList();
        String defaultSchemaName = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_SECURITY_DEFAULT_SCHEMA_NAME, context);
        if (StringUtils.isEmpty((CharSequence)defaultSchemaName)) {
            defaultSchemaName = DEFAULT_SECURITY_SCHEMA_NAME;
        }
        boolean tokenEnabled = OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.enabled", false, context);
        securityProperties = new SecurityProperties(OpenApiApplicationVisitor.getBooleanProperty(MICRONAUT_OPENAPI_SECURITY_ENABLED, true, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.enabled", false, context), defaultSchemaName, interceptUrlMapPatterns, tokenEnabled, OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.jwt.enabled", tokenEnabled, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.jwt.bearer", tokenEnabled, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.token.jwt.cookie.enabled", false, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.oauth2.enabled", false, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.security.basic-auth.enabled", false, context));
        context.put((CharSequence)MICRONAUT_INTERNAL_SECURITY_PROPERTIES, (Object)securityProperties);
        return securityProperties;
    }

    public static RouterVersioningProperties getRouterVersioningProperties(VisitorContext context) {
        RouterVersioningProperties routerVersioningProperties = context.get((CharSequence)MICRONAUT_INTERNAL_ROUTER_VERSIONING_PROPERTIES, RouterVersioningProperties.class).orElse(null);
        if (routerVersioningProperties != null) {
            return routerVersioningProperties;
        }
        routerVersioningProperties = new RouterVersioningProperties(OpenApiApplicationVisitor.getBooleanProperty(MICRONAUT_OPENAPI_VERSIONING_ENABLED, true, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.router.versioning.enabled", false, context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.router.versioning.header.enabled", false, context), OpenApiApplicationVisitor.getListStringsProperty("micronaut.router.versioning.header.names", Collections.singletonList("X-API-VERSION"), context), OpenApiApplicationVisitor.getBooleanProperty("micronaut.router.versioning.parameter.enabled", false, context), OpenApiApplicationVisitor.getListStringsProperty("micronaut.router.versioning.parameter.names", Collections.singletonList("api-version"), context));
        context.put((CharSequence)MICRONAUT_INTERNAL_ROUTER_VERSIONING_PROPERTIES, (Object)routerVersioningProperties);
        return routerVersioningProperties;
    }

    public static GroupProperties getGroupProperties(String groupName, VisitorContext context) {
        if (groupName == null) {
            return null;
        }
        Map<String, GroupProperties> allGroupsProperties = OpenApiApplicationVisitor.getGroupsPropertiesMap(context);
        return CollectionUtils.isNotEmpty(allGroupsProperties) ? allGroupsProperties.get(groupName) : null;
    }

    public static Map<String, GroupProperties> getGroupsPropertiesMap(VisitorContext context) {
        HashMap<String, GroupProperties> groupPropertiesMap = context.get((CharSequence)MICRONAUT_INTERNAL_GROUPS, Map.class).orElse(null);
        if (groupPropertiesMap != null) {
            return groupPropertiesMap;
        }
        groupPropertiesMap = new HashMap<String, GroupProperties>();
        Properties sysProps = System.getProperties();
        OpenApiApplicationVisitor.readGroupsProperties(sysProps, groupPropertiesMap, context);
        Properties fileProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
        OpenApiApplicationVisitor.readGroupsProperties(fileProps, groupPropertiesMap, context);
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            for (Map.Entry entry : environment.getProperties(MICRONAUT_OPENAPI_GROUPS, StringConvention.RAW).entrySet()) {
                String entryKey = (String)entry.getKey();
                String[] propParts = entryKey.split("\\.");
                String propName = propParts[propParts.length - 1];
                String groupName = entryKey.substring(0, entryKey.length() - propName.length() - 1);
                OpenApiApplicationVisitor.setGroupProperty(groupName, propName, entry.getValue(), groupPropertiesMap, context);
            }
        }
        Utils.getAllKnownGroups().addAll(groupPropertiesMap.keySet());
        context.put((CharSequence)MICRONAUT_INTERNAL_GROUPS, groupPropertiesMap);
        return groupPropertiesMap;
    }

    private static void readGroupsProperties(Properties props, Map<String, GroupProperties> groupPropertiesMap, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            int groupNameIndexEnd;
            if (!prop.startsWith(MICRONAUT_OPENAPI_GROUPS) || (groupNameIndexEnd = prop.indexOf(46, MICRONAUT_OPENAPI_GROUPS.length() + 1)) < 0) continue;
            String groupName = prop.substring(MICRONAUT_OPENAPI_GROUPS.length() + 1, groupNameIndexEnd);
            String propertyName = prop.substring(groupNameIndexEnd + 1);
            String value = props.getProperty(prop);
            OpenApiApplicationVisitor.setGroupProperty(groupName, prop, value, groupPropertiesMap, context);
        }
    }

    private static void setGroupProperty(String groupName, String propertyName, Object value, Map<String, GroupProperties> groupPropertiesMap, VisitorContext context) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        GroupProperties groupProperties = groupPropertiesMap.computeIfAbsent(groupName, GroupProperties::new);
        switch (propertyName.toLowerCase()) {
            case "displayname": 
            case "display-name": {
                if (groupProperties.getDisplayName() != null) break;
                groupProperties.setDisplayName(valueStr);
                break;
            }
            case "filename": 
            case "file-name": {
                if (groupProperties.getFilename() != null) break;
                groupProperties.setFilename(valueStr);
                break;
            }
            case "packages": {
                if (groupProperties.getPackages() != null) break;
                ArrayList<GroupProperties.PackageProperties> packages = new ArrayList<GroupProperties.PackageProperties>();
                for (String groupPackage : valueStr.split(",")) {
                    packages.add(OpenApiApplicationVisitor.getPackageProperties(groupPackage));
                }
                groupProperties.setPackages(packages);
                break;
            }
            case "primary": {
                if (groupProperties.getPrimary() != null) break;
                groupProperties.setPrimary(Boolean.valueOf(valueStr));
                break;
            }
            case "commonexclude": 
            case "common-exclude": {
                if (groupProperties.getCommonExclude() != null) break;
                groupProperties.setCommonExclude(Boolean.valueOf(valueStr));
                break;
            }
            case "packagesexclude": 
            case "packages-exclude": {
                if (groupProperties.getPackagesExclude() != null) break;
                ArrayList<GroupProperties.PackageProperties> packagesExclude = new ArrayList<GroupProperties.PackageProperties>();
                for (String groupPackage : valueStr.split(",")) {
                    packagesExclude.add(OpenApiApplicationVisitor.getPackageProperties(groupPackage));
                }
                groupProperties.setPackagesExclude(packagesExclude);
                break;
            }
        }
    }

    private static GroupProperties.PackageProperties getPackageProperties(String groupPackage) {
        boolean includeSubpackages = (groupPackage = groupPackage.trim()).endsWith("*");
        if (includeSubpackages) {
            groupPackage = groupPackage.substring(0, groupPackage.length() - 2);
        }
        if (groupPackage.endsWith(".")) {
            groupPackage = groupPackage.substring(0, groupPackage.length() - 2);
        }
        return new GroupProperties.PackageProperties(groupPackage, includeSubpackages);
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue, VisitorContext context) {
        String str = OpenApiApplicationVisitor.getConfigurationProperty(property, context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return !"false".equalsIgnoreCase(str);
    }

    public static List<String> getListStringsProperty(String property, List<String> defaultValue, VisitorContext context) {
        String strValue = System.getProperty(property);
        if (StringUtils.isEmpty((CharSequence)strValue)) {
            strValue = OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(property);
        }
        if (StringUtils.isNotEmpty((CharSequence)strValue)) {
            ArrayList<String> result = new ArrayList<String>();
            for (String item : strValue.split(",")) {
                result.add(item.trim());
            }
            return result;
        }
        Environment env = OpenApiApplicationVisitor.getEnv(context);
        if (env != null) {
            return env.get((CharSequence)property, Argument.LIST_OF_STRING).orElse(defaultValue);
        }
        return defaultValue;
    }

    @Nullable
    public static Environment getEnv(VisitorContext context) {
        Boolean envCreated;
        if (!OpenApiApplicationVisitor.isEnvEnabled(context)) {
            return null;
        }
        Environment existedEnvironment = context != null ? (Environment)context.get((CharSequence)MICRONAUT_ENVIRONMENT, Environment.class).orElse(null) : null;
        Boolean bl = envCreated = context != null ? (Boolean)context.get((CharSequence)MICRONAUT_ENVIRONMENT_CREATED, Boolean.class).orElse(null) : null;
        if (envCreated != null && envCreated.booleanValue()) {
            return existedEnvironment;
        }
        Environment environment = OpenApiApplicationVisitor.createEnv(context);
        if (context != null) {
            context.put((CharSequence)MICRONAUT_ENVIRONMENT, (Object)environment);
            context.put((CharSequence)MICRONAUT_ENVIRONMENT_CREATED, (Object)true);
        }
        return environment;
    }

    private static boolean isEnvEnabled(VisitorContext context) {
        String isEnabledStr = System.getProperty(MICRONAUT_ENVIRONMENT_ENABLED, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(MICRONAUT_ENVIRONMENT_ENABLED));
        boolean isEnabled = true;
        if (StringUtils.isNotEmpty((CharSequence)isEnabledStr)) {
            isEnabled = Boolean.parseBoolean(isEnabledStr);
        }
        if (context != null) {
            context.put((CharSequence)MICRONAUT_ENVIRONMENT_ENABLED, (Object)isEnabled);
        }
        return isEnabled;
    }

    public static List<String> getActiveEnvs(VisitorContext context) {
        if (!OpenApiApplicationVisitor.isEnvEnabled(context)) {
            return Collections.emptyList();
        }
        String activeEnvStr = System.getProperty(MICRONAUT_OPENAPI_ENVIRONMENTS, OpenApiApplicationVisitor.readOpenApiConfigFile(context).getProperty(MICRONAUT_OPENAPI_ENVIRONMENTS));
        List<String> activeEnvs = StringUtils.isNotEmpty((CharSequence)activeEnvStr) ? Stream.of(activeEnvStr).filter(StringUtils::isNotEmpty).flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).collect(Collectors.toList()) : new ArrayList<String>();
        return activeEnvs;
    }

    private static Environment createEnv(final VisitorContext context) {
        ApplicationContextConfiguration configuration = new ApplicationContextConfiguration(){

            public Optional<MutableConversionService> getConversionService() {
                DefaultMutableConversionService conversionService = new DefaultMutableConversionService();
                conversionService.addConverter(Map.class, InterceptUrlMapPattern.class, (TypeConverter)new InterceptUrlMapConverter((ConversionService)conversionService));
                return Optional.of(conversionService);
            }

            public ClassPathResourceLoader getResourceLoader() {
                ClassLoader classLoader = ApplicationContextConfiguration.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassPathResourceLoader.class.getClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return new DefaultClassPathResourceLoader(classLoader, null, false, false);
            }

            @NonNull
            public List<String> getEnvironments() {
                return OpenApiApplicationVisitor.getActiveEnvs(context);
            }
        };
        AnnProcessorEnvironment environment = null;
        try {
            environment = new AnnProcessorEnvironment(configuration, context);
            environment.start();
            return environment;
        }
        catch (Exception e) {
            if (context != null) {
                context.warn("Can't create environment: " + e.getMessage() + ".\n" + Utils.printStackTrace(e), null);
            }
            return environment;
        }
    }

    private ClassLoader resolveClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return DefaultApplicationContextBuilder.class.getClassLoader();
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_ADDITIONAL_FILES, context);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles)) {
            Path directory = OpenApiApplicationVisitor.resolve(context, Paths.get(additionalSwaggerFiles, new String[0]));
            if (Files.isDirectory(directory, new LinkOption[0])) {
                context.info("Merging Swagger OpenAPI YAML and JSON files from location: " + directory);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, path -> this.isYaml(path.toString().toLowerCase()) || path.toString().toLowerCase().endsWith(EXT_JSON));){
                    stream.forEach(path -> {
                        boolean isYaml = this.isYaml(path.toString().toLowerCase());
                        context.info("Reading Swagger OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + path.getFileName());
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)(isYaml ? ConvertUtils.getYamlMapper() : ConvertUtils.getJsonMapper()).readValue(path.toFile(), OpenAPI.class);
                        }
                        catch (IOException e) {
                            context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)element);
                        }
                        this.copyOpenApi(openAPI, parsedOpenApi);
                    });
                }
                catch (IOException e) {
                    context.warn("Unable to read  file from " + directory + ": " + e.getMessage(), (Element)element);
                }
            } else {
                context.warn(directory + " does not exist or is not a directory", (Element)element);
            }
        }
    }

    private boolean isYaml(String path) {
        return path.endsWith(EXT_YML) || path.endsWith(EXT_YAML);
    }

    public static Path resolve(VisitorContext context, Path path) {
        Path projectPath;
        if (!path.isAbsolute() && context != null && (projectPath = Utils.getProjectPath(context)) != null) {
            path = projectPath.resolve(path);
        }
        return path.toAbsolutePath();
    }

    static EndpointsConfiguration endpointsConfiguration(VisitorContext context) {
        Optional cfg = context.get((CharSequence)MICRONAUT_OPENAPI_ENDPOINTS, EndpointsConfiguration.class);
        if (cfg.isPresent()) {
            return (EndpointsConfiguration)cfg.get();
        }
        EndpointsConfiguration conf = new EndpointsConfiguration(context, OpenApiApplicationVisitor.readOpenApiConfigFile(context));
        context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINTS, (Object)conf);
        return conf;
    }

    public static Properties readOpenApiConfigFile(VisitorContext context) {
        Properties openApiProperties;
        block14: {
            Optional props;
            Optional optional = props = context != null ? context.get((CharSequence)MICRONAUT_OPENAPI_PROPERTIES, Properties.class) : Optional.empty();
            if (props.isPresent()) {
                return (Properties)props.get();
            }
            openApiProperties = new Properties();
            String cfgFile = System.getProperty(MICRONAUT_OPENAPI_CONFIG_FILE, OPENAPI_CONFIG_FILE);
            if (StringUtils.isNotEmpty((CharSequence)cfgFile)) {
                Path cfg = OpenApiApplicationVisitor.resolve(context, Paths.get(cfgFile, new String[0]));
                if (Files.isReadable(cfg)) {
                    try (BufferedReader reader = Files.newBufferedReader(cfg);){
                        openApiProperties.load(reader);
                        break block14;
                    }
                    catch (IOException e) {
                        if (context != null) {
                            context.warn("Fail to read OpenAPI configuration file: " + e.getMessage(), null);
                        }
                        break block14;
                    }
                }
                if (Files.exists(cfg, new LinkOption[0]) && context != null) {
                    context.warn("Can not read configuration file: " + cfg, null);
                }
            }
        }
        if (context != null) {
            context.put((CharSequence)MICRONAUT_OPENAPI_PROPERTIES, (Object)openApiProperties);
        }
        return openApiProperties;
    }

    private void copyOpenApi(OpenAPI to, OpenAPI from) {
        if (to != null && from != null) {
            Optional.ofNullable(from.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)to).addTagsItem(arg_0)));
            Optional.ofNullable(from.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)to).addServersItem(arg_0)));
            Optional.ofNullable(from.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)to).addSecurityItem(arg_0)));
            Optional.ofNullable(from.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)to).path(arg_0, arg_1)));
            Optional.ofNullable(from.getComponents()).ifPresent(components -> {
                Map securitySchemes;
                Map schemas = components.getSchemas();
                if (CollectionUtils.isNotEmpty((Map)schemas)) {
                    schemas.forEach((k, v) -> {
                        if (v.getName() == null) {
                            v.setName(k);
                        }
                    });
                    schemas.forEach((arg_0, arg_1) -> ((OpenAPI)to).schema(arg_0, arg_1));
                }
                if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                    securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)to).schemaRequirement(arg_0, arg_1));
                }
            });
            Optional.ofNullable(from.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)to).externalDocs(arg_0));
            Optional.ofNullable(from.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)to).addExtension(arg_0, arg_1)));
        }
    }

    private OpenAPI readOpenApi(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            Optional<OpenAPI> result = this.toValue(o.getValues(), context, OpenAPI.class);
            result.ifPresent(openAPI -> {
                List securityRequirements = o.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class).stream().map(ConvertUtils::mapToSecurityRequirement).collect(Collectors.toList());
                openAPI.setSecurity(securityRequirements);
            });
            return result;
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, Map<Pair<String, String>, OpenApiInfo> openApiInfos, Path destinationDir, VisitorContext context) throws IOException {
        String viewSpecification = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_VIEWS_SPEC, context);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, openApiInfos, OpenApiApplicationVisitor.readOpenApiConfigFile(context), context);
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            cfg.setSpecFile(openApiInfos.values().iterator().next().getSpecFilePath());
            cfg.setServerContextPath(OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH, context));
            cfg.render(destinationDir, context);
        }
    }

    private static PropertyNamingStrategies.NamingBase fromName(String name) {
        if (name == null) {
            return null;
        }
        return switch (name.toUpperCase(Locale.US)) {
            case "LOWER_CAMEL_CASE" -> new LowerCamelCasePropertyNamingStrategy();
            case "UPPER_CAMEL_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_CAMEL_CASE;
            case "SNAKE_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.SNAKE_CASE;
            case "UPPER_SNAKE_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_SNAKE_CASE;
            case "LOWER_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CASE;
            case "KEBAB_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.KEBAB_CASE;
            case "LOWER_DOT_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_DOT_CASE;
            default -> null;
        };
    }

    private Optional<Path> getDefaultFilePath(String fileName, VisitorContext context) {
        URI uri;
        Optional generatedFile = context.visitMetaInfFile("swagger/" + fileName, Element.EMPTY_ELEMENT_ARRAY);
        if (generatedFile.isPresent() && (uri = ((GeneratedFile)generatedFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path specPath = Paths.get(uri);
            OpenApiApplicationVisitor.createDirectories(specPath, context);
            return Optional.of(specPath);
        }
        context.warn("Unable to get swagger/" + fileName + " file.", null);
        return Optional.empty();
    }

    private Optional<Path> openApiSpecFile(String fileName, VisitorContext visitorContext) {
        Optional<Path> path = this.userDefinedSpecFile(visitorContext);
        if (path.isPresent()) {
            return path;
        }
        return this.getDefaultFilePath(fileName, visitorContext);
    }

    private Optional<Path> userDefinedSpecFile(VisitorContext context) {
        String targetFile = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_TARGET_FILE, context);
        if (StringUtils.isEmpty((CharSequence)targetFile)) {
            return Optional.empty();
        }
        Path specFile = OpenApiApplicationVisitor.resolve(context, Paths.get(targetFile, new String[0]));
        OpenApiApplicationVisitor.createDirectories(specFile, context);
        return Optional.of(specFile);
    }

    private Path getViewsDestDir(Path defaultSwaggerFilePath, VisitorContext context) {
        String destDir = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_VIEWS_DEST_DIR, context);
        if (StringUtils.isNotEmpty((CharSequence)destDir)) {
            Path destPath = OpenApiApplicationVisitor.resolve(context, Paths.get(destDir, new String[0]));
            OpenApiApplicationVisitor.createDirectories(destPath, context);
            return destPath;
        }
        return defaultSwaggerFilePath.getParent().resolve("views");
    }

    private static void createDirectories(Path f, VisitorContext visitorContext) {
        if (f.getParent() != null) {
            try {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                visitorContext.warn("Fail to create directories for" + f + ": " + e.getMessage(), null);
            }
        }
    }

    private void applyPropertyNamingStrategy(OpenAPI openAPI, VisitorContext visitorContext) {
        String namingStrategyName = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY, visitorContext);
        PropertyNamingStrategies.NamingBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
        if (propertyNamingStrategy != null) {
            visitorContext.info("Using " + namingStrategyName + " property naming strategy.");
            if (openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)openAPI.getComponents().getSchemas())) {
                openAPI.getComponents().getSchemas().values().forEach(model -> {
                    List required;
                    Map properties = model.getProperties();
                    if (properties != null) {
                        Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                        model.getProperties().clear();
                        model.setProperties(newProperties);
                    }
                    if ((required = model.getRequired()) != null) {
                        List<String> updatedRequired = required.stream().map(arg_0 -> ((PropertyNamingStrategies.NamingBase)propertyNamingStrategy).translate(arg_0)).toList();
                        required.clear();
                        required.addAll(updatedRequired);
                    }
                });
            }
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openAPI, VisitorContext visitorContext) {
        String serverContextPath = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_CONTEXT_SERVER_PATH, visitorContext);
        if (serverContextPath == null || serverContextPath.isEmpty()) {
            return;
        }
        visitorContext.info("Applying server context path: " + serverContextPath + " to Paths.");
        io.swagger.v3.oas.models.Paths paths = openAPI.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        io.swagger.v3.oas.models.Paths newPaths = new io.swagger.v3.oas.models.Paths();
        for (Map.Entry path : paths.entrySet()) {
            Object newPath;
            String mapping = (String)path.getKey();
            Object object = newPath = mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping);
            if (!((String)newPath).startsWith("/") && !((String)newPath).startsWith("$")) {
                newPath = "/" + (String)newPath;
            }
            newPaths.addPathItem((String)newPath, (PathItem)path.getValue());
        }
        openAPI.setPaths(newPaths);
    }

    public static JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, OpenApiApplicationVisitor.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    public static JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.isEmpty()) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), OpenApiApplicationVisitor.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    public static JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.isBlank()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    public static String expandProperties(String s, List<Map.Entry<String, String>> properties, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.contains("${")) {
            return s;
        }
        if (CollectionUtils.isNotEmpty(properties)) {
            for (Map.Entry<String, String> entry : properties) {
                s = s.replace(entry.getKey(), entry.getValue());
            }
        }
        return OpenApiApplicationVisitor.replacePlaceholders(s, context);
    }

    public static String replacePlaceholders(String value, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)value) || !value.contains("${")) {
            return value;
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> sysProp : System.getProperties().entrySet()) {
                value = value.replace("${" + sysProp.getKey().toString() + "}", sysProp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> fileProp : OpenApiApplicationVisitor.readOpenApiConfigFile(context).entrySet()) {
            value = value.replace("${" + fileProp.getKey().toString() + "}", fileProp.getValue().toString());
        }
        Environment environment = OpenApiApplicationVisitor.getEnv(context);
        if (environment != null) {
            value = environment.getPlaceholderResolver().resolvePlaceholders(value).orElse(value);
        }
        return value;
    }

    public static List<Map.Entry<String, String>> getExpandableProperties(VisitorContext context) {
        ArrayList<Map.Entry<String, String>> expandableProperties = new ArrayList();
        Optional propertiesLoaded = context.get((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED, Boolean.class);
        if (!propertiesLoaded.orElse(false).booleanValue()) {
            String key;
            AnnProcessorEnvironment env = (AnnProcessorEnvironment)OpenApiApplicationVisitor.getEnv(context);
            Map propertiesFromEnv = null;
            if (env != null) {
                try {
                    propertiesFromEnv = env.getProperties("micronaut.openapi.expand", null);
                }
                catch (Exception e) {
                    context.warn("Error:\n" + Utils.printStackTrace(e), null);
                }
            }
            HashMap<String, String> expandedPropsMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty((Map)propertiesFromEnv)) {
                for (Map.Entry entry : propertiesFromEnv.entrySet()) {
                    expandedPropsMap.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            Properties openapiProps = OpenApiApplicationVisitor.readOpenApiConfigFile(context);
            for (Map.Entry<Object, Object> entry : openapiProps.entrySet()) {
                key = entry.getKey().toString();
                if (!key.startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)) continue;
                expandedPropsMap.put(key, entry.getValue().toString());
            }
            if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
                for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                    key = entry.getKey().toString();
                    if (!key.startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)) continue;
                    expandedPropsMap.put(key, entry.getValue().toString());
                }
            }
            for (Map.Entry<Object, Object> entry : expandedPropsMap.entrySet()) {
                key = (String)entry.getKey();
                if (key.startsWith(MICRONAUT_OPENAPI_EXPAND_PREFIX)) {
                    key = key.substring(MICRONAUT_OPENAPI_EXPAND_PREFIX.length());
                }
                expandableProperties.add(new AbstractMap.SimpleImmutableEntry<CallSite, String>((CallSite)((Object)("${" + key + "}")), (String)entry.getValue()));
            }
            context.put((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES, expandableProperties);
            context.put((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES_LOADED, (Object)true);
        } else {
            expandableProperties = context.get((CharSequence)MICRONAUT_INTERNAL_EXPANDBLE_PROPERTIES, EXPANDABLE_PROPERTIES_ARGUMENT).orElse(null);
        }
        return expandableProperties;
    }

    private static OpenAPI resolvePropertyPlaceHolders(OpenAPI openAPI, VisitorContext visitorContext) {
        List<Map.Entry<String, String>> expandableProperties = OpenApiApplicationVisitor.getExpandableProperties(visitorContext);
        if (CollectionUtils.isNotEmpty(expandableProperties)) {
            visitorContext.info("Expanding properties: " + expandableProperties);
        }
        JsonNode root = OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)ConvertUtils.getYamlMapper().convertValue((Object)openAPI, ObjectNode.class), s -> OpenApiApplicationVisitor.expandProperties(s, expandableProperties, visitorContext));
        return (OpenAPI)ConvertUtils.getYamlMapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext context) {
        try {
            String isJson;
            if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
                return;
            }
            if (this.visitedElements == this.visitedElements(context)) {
                return;
            }
            Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            if (attr.isEmpty()) {
                return;
            }
            OpenAPI openApi = (OpenAPI)attr.get();
            this.processEndpoints(context);
            this.mergeMicronautEndpointInfos(openApi, context);
            Map<Pair<String, String>, OpenApiInfo> openApiInfos = this.divideOpenapiByGroupsAndVersions(openApi, context);
            if (Utils.isTestMode()) {
                Utils.setTestReferences(openApiInfos);
            }
            boolean isYaml = !StringUtils.isNotEmpty((CharSequence)(isJson = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_JSON_FORMAT, context))) || !isJson.equalsIgnoreCase("true");
            Object documentTitle = "OpenAPI";
            for (Map.Entry<Pair<String, String>, OpenApiInfo> entry : openApiInfos.entrySet()) {
                OpenApiInfo openApiInfo = entry.getValue();
                openApi = openApiInfo.getOpenApi();
                openApi = this.postProcessOpenApi(openApi, context);
                if (Utils.isTestMode()) {
                    Utils.setTestReference(openApi);
                }
                String ext = isYaml ? EXT_YML : EXT_JSON;
                Object fileName = "swagger" + ext;
                Info info = openApi.getInfo();
                if (info != null) {
                    documentTitle = Optional.ofNullable(info.getTitle()).orElse("application");
                    documentTitle = ((String)documentTitle).toLowerCase(Locale.US).replace(' ', '-');
                    String version = info.getVersion();
                    if (version != null) {
                        documentTitle = (String)documentTitle + "-" + version;
                    }
                    fileName = (String)documentTitle + ext;
                }
                String versionFromInfo = info != null && info.getVersion() != null ? info.getVersion() : "";
                String fileNameFromConfig = OpenApiApplicationVisitor.getConfigurationProperty(MICRONAUT_OPENAPI_FILENAME, context);
                if (StringUtils.isNotEmpty((CharSequence)fileNameFromConfig) && ((String)(fileName = OpenApiApplicationVisitor.replacePlaceholders(fileNameFromConfig, context) + ext)).contains("${version}")) {
                    fileName = ((String)fileName).replaceAll("\\$\\{version}", versionFromInfo);
                }
                if (openApiInfos.size() > 1) {
                    fileName = StringUtils.isNotEmpty((CharSequence)openApiInfo.getFilename()) ? openApiInfo.getFilename() : ((String)fileName).substring(0, ((String)fileName).length() - ext.length()) + (String)(openApiInfo.getGroupName() != null ? "-" + openApiInfo.getGroupName() : "") + (String)(openApiInfo.getVersion() != null ? "-" + openApiInfo.getVersion() : "");
                    if (((String)(fileName = OpenApiApplicationVisitor.replacePlaceholders((String)fileName, context) + ext)).contains("${apiVersion}")) {
                        fileName = ((String)fileName).replaceAll("\\$\\{apiVersion}", openApiInfo.getVersion() != null ? openApiInfo.getVersion() : versionFromInfo);
                    }
                    if (((String)fileName).contains("${version}")) {
                        fileName = ((String)fileName).replaceAll("\\$\\{version}", versionFromInfo);
                    }
                    if (((String)fileName).contains("${group}")) {
                        fileName = ((String)fileName).replaceAll("\\$\\{group}", openApiInfo.getGroupName() != null ? openApiInfo.getGroupName() : "");
                    }
                }
                if (((String)fileName).contains("${")) {
                    context.warn("Can't set some placeholders in fileName: " + (String)fileName, null);
                }
                openApiInfo.setFilename((String)fileName);
            }
            this.writeYamlToFile(openApiInfos, (String)documentTitle, context, isYaml);
            this.visitedElements = this.visitedElements(context);
        }
        catch (Throwable t) {
            context.warn("Error:\n" + Utils.printStackTrace(t), null);
            throw t;
        }
    }

    private Map<Pair<String, String>, OpenApiInfo> divideOpenapiByGroupsAndVersions(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        Set<String> allVersions = Utils.getAllKnownVersions();
        Set<String> allGroups = Utils.getAllKnownGroups();
        if (CollectionUtils.isEmpty(endpointInfosMap) || CollectionUtils.isEmpty(allVersions) && CollectionUtils.isEmpty(allGroups)) {
            return Collections.singletonMap(Pair.NULL_STRING_PAIR, new OpenApiInfo(openApi));
        }
        ArrayList<EndpointInfo> commonEndpoints = new ArrayList<EndpointInfo>();
        HashMap<Pair<String, String>, OpenApiInfo> result = new HashMap<Pair<String, String>, OpenApiInfo>();
        for (List<EndpointInfo> list : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : list) {
                if (CollectionUtils.isEmpty(endpointInfo.getGroups()) && endpointInfo.getVersion() == null) {
                    commonEndpoints.add(endpointInfo);
                    continue;
                }
                for (String group : endpointInfo.getGroups()) {
                    if (CollectionUtils.isNotEmpty(endpointInfo.getExcludedGroups()) && endpointInfo.getExcludedGroups().contains(group)) continue;
                    OpenAPI newOpenApi = this.addOpenApiInfo(group, endpointInfo.getVersion(), openApi, result, context);
                    this.addOperation(endpointInfo, newOpenApi);
                }
                if (!CollectionUtils.isEmpty(endpointInfo.getGroups())) continue;
                OpenAPI newOpenApi = this.addOpenApiInfo(null, endpointInfo.getVersion(), openApi, result, context);
                this.addOperation(endpointInfo, newOpenApi);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String group = (String)((Pair)entry.getKey()).getFirst();
            GroupProperties groupProperties = OpenApiApplicationVisitor.getGroupProperties(group, context);
            if (groupProperties != null && groupProperties.getCommonExclude() != null && groupProperties.getCommonExclude().booleanValue()) continue;
            OpenAPI openAPI = ((OpenApiInfo)entry.getValue()).getOpenApi();
            for (EndpointInfo commonEndpoint : commonEndpoints) {
                if (CollectionUtils.isNotEmpty(commonEndpoint.getExcludedGroups()) && commonEndpoint.getExcludedGroups().contains(group)) continue;
                this.addOperation(commonEndpoint, openAPI);
            }
        }
        return result;
    }

    private void addOperation(EndpointInfo endpointInfo, OpenAPI openApi) {
        PathItem pathItem;
        Operation operation;
        if (openApi == null) {
            return;
        }
        io.swagger.v3.oas.models.Paths paths = openApi.getPaths();
        if (paths == null) {
            paths = new io.swagger.v3.oas.models.Paths();
            openApi.setPaths(paths);
        }
        if ((operation = SchemaUtils.getOperationOnPathItem(pathItem = (PathItem)paths.computeIfAbsent((Object)endpointInfo.getUrl(), pathurl -> new PathItem()), endpointInfo.getHttpMethod())) == null) {
            SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), endpointInfo.getOperation());
            return;
        }
        SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), SchemaUtils.mergeOperations(operation, endpointInfo.getOperation()));
    }

    private OpenAPI addOpenApiInfo(String group, String version, OpenAPI openApi, Map<Pair<String, String>, OpenApiInfo> openApiInfoMap, VisitorContext context) {
        OpenAPI newOpenApi;
        GroupProperties groupProperties = OpenApiApplicationVisitor.getGroupProperties(group, context);
        boolean hasGroupProperties = groupProperties != null;
        Pair<String, String> key = Pair.of(group, version);
        OpenApiInfo openApiInfo = openApiInfoMap.get(key);
        if (openApiInfo == null) {
            OpenAPI openApiCopy;
            Map<String, OpenAPI> knownOpenApis = Utils.getOpenApis();
            newOpenApi = CollectionUtils.isNotEmpty(knownOpenApis) && knownOpenApis.containsKey(group) ? knownOpenApis.get(group) : new OpenAPI();
            openApiInfo = new OpenApiInfo(version, group, hasGroupProperties ? groupProperties.getDisplayName() : null, hasGroupProperties ? groupProperties.getFilename() : null, newOpenApi);
            openApiInfoMap.put(key, openApiInfo);
            try {
                openApiCopy = (OpenAPI)ConvertUtils.getJsonMapper().treeToValue((TreeNode)ConvertUtils.getJsonMapper().valueToTree((Object)openApi), OpenAPI.class);
            }
            catch (JsonProcessingException e) {
                context.warn("Error\n" + Utils.printStackTrace(e), null);
                return null;
            }
            if (CollectionUtils.isEmpty(knownOpenApis) || !knownOpenApis.containsKey(group)) {
                newOpenApi.setTags(openApiCopy.getTags());
                newOpenApi.setServers(openApiCopy.getServers());
                newOpenApi.setInfo(openApiCopy.getInfo());
                newOpenApi.setSecurity(openApiCopy.getSecurity());
                newOpenApi.setExternalDocs(openApiCopy.getExternalDocs());
            }
            newOpenApi.setComponents(openApiCopy.getComponents());
        } else {
            newOpenApi = openApiInfo.getOpenApi();
        }
        return newOpenApi;
    }

    private void mergeMicronautEndpointInfos(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        if (CollectionUtils.isEmpty(endpointInfosMap)) {
            return;
        }
        for (List<EndpointInfo> endpointInfos : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : endpointInfos) {
                PathItem pathItem = (PathItem)openApi.getPaths().get((Object)endpointInfo.getUrl());
                Operation operation = SchemaUtils.getOperationOnPathItem(pathItem, endpointInfo.getHttpMethod());
                if (operation == null) {
                    SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), endpointInfo.getOperation());
                    continue;
                }
                if (endpointInfo.getVersion() != null) continue;
                SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), SchemaUtils.mergeOperations(operation, endpointInfo.getOperation()));
            }
        }
    }

    public int getOrder() {
        return 100;
    }

    private OpenAPI postProcessOpenApi(OpenAPI openApi, VisitorContext context) {
        this.applyPropertyNamingStrategy(openApi, context);
        this.applyPropertyServerContextPath(openApi, context);
        this.normalizeOpenApi(openApi);
        new JacksonDiscriminatorPostProcessor().addMissingDiscriminatorType(openApi);
        new OpenApiOperationsPostProcessor().processOperations(openApi);
        try {
            Map schemas;
            if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)(schemas = openApi.getComponents().getSchemas()))) {
                String openApiJson = ConvertUtils.getJsonMapper().writeValueAsString((Object)openApi);
                HashSet keySet = new HashSet(schemas.keySet());
                for (String schemaName : keySet) {
                    if (openApiJson.contains("\"#/components/schemas/" + schemaName + "\"")) continue;
                    schemas.remove(schemaName);
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        this.removeEmtpyComponents(openApi);
        openApi = OpenApiApplicationVisitor.resolvePropertyPlaceHolders(openApi, context);
        return openApi;
    }

    private void removeEmtpyComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas())) {
            components.setSchemas(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getResponses())) {
            components.setResponses(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getParameters())) {
            components.setParameters(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExamples())) {
            components.setExamples(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getRequestBodies())) {
            components.setRequestBodies(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getHeaders())) {
            components.setHeaders(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
            components.setSecuritySchemes(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getLinks())) {
            components.setLinks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getCallbacks())) {
            components.setCallbacks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExtensions())) {
            components.setExtensions(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas()) && CollectionUtils.isEmpty((Map)components.getResponses()) && CollectionUtils.isEmpty((Map)components.getParameters()) && CollectionUtils.isEmpty((Map)components.getExamples()) && CollectionUtils.isEmpty((Map)components.getRequestBodies()) && CollectionUtils.isEmpty((Map)components.getHeaders()) && CollectionUtils.isEmpty((Map)components.getSecuritySchemes()) && CollectionUtils.isEmpty((Map)components.getLinks()) && CollectionUtils.isEmpty((Map)components.getCallbacks()) && CollectionUtils.isEmpty((Map)components.getExtensions())) {
            openAPI.setComponents(null);
        }
    }

    private void normalizeOpenApi(OpenAPI openAPI) {
        Components components;
        if (openAPI.getPaths() != null) {
            io.swagger.v3.oas.models.Paths sortedPaths = new io.swagger.v3.oas.models.Paths();
            new TreeMap<String, PathItem>((Map<String, PathItem>)openAPI.getPaths()).forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.Paths)sortedPaths).addPathItem(arg_0, arg_1));
            if (openAPI.getPaths().getExtensions() != null) {
                sortedPaths.setExtensions(new TreeMap(openAPI.getPaths().getExtensions()));
            }
            openAPI.setPaths(sortedPaths);
            for (PathItem pathItem : sortedPaths.values()) {
                this.normalizeOperation(pathItem.getGet());
                this.normalizeOperation(pathItem.getPut());
                this.normalizeOperation(pathItem.getPost());
                this.normalizeOperation(pathItem.getDelete());
                this.normalizeOperation(pathItem.getOptions());
                this.normalizeOperation(pathItem.getHead());
                this.normalizeOperation(pathItem.getPatch());
                this.normalizeOperation(pathItem.getTrace());
            }
        }
        if ((components = openAPI.getComponents()) == null) {
            return;
        }
        this.normalizeSchemas(components.getSchemas());
        this.sortComponent(components, Components::getSchemas, Components::setSchemas);
        this.sortComponent(components, Components::getResponses, Components::setResponses);
        this.sortComponent(components, Components::getParameters, Components::setParameters);
        this.sortComponent(components, Components::getExamples, Components::setExamples);
        this.sortComponent(components, Components::getRequestBodies, Components::setRequestBodies);
        this.sortComponent(components, Components::getHeaders, Components::setHeaders);
        this.sortComponent(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
        this.sortComponent(components, Components::getLinks, Components::setLinks);
        this.sortComponent(components, Components::getCallbacks, Components::setCallbacks);
    }

    private void normalizeOperation(Operation operation) {
        if (operation == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter parameter : operation.getParameters()) {
                Schema paramSchema;
                if (parameter == null || (paramSchema = parameter.getSchema()) == null) continue;
                Schema normalizedSchema = this.normalizeSchema(paramSchema);
                if (normalizedSchema != null) {
                    parameter.setSchema(normalizedSchema);
                    continue;
                }
                if (!paramSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) continue;
                paramSchema.setType("object");
            }
        }
        if (operation.getRequestBody() != null) {
            this.normalizeContent(operation.getRequestBody().getContent());
        }
        if (CollectionUtils.isNotEmpty((Map)operation.getResponses())) {
            for (ApiResponse apiResponse : operation.getResponses().values()) {
                this.normalizeContent(apiResponse.getContent());
            }
        }
    }

    private void normalizeContent(Content content) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            Map paramSchemas;
            Schema mediaTypeSchema = mediaType.getSchema();
            if (mediaTypeSchema == null) continue;
            Schema normalizedSchema = this.normalizeSchema(mediaTypeSchema);
            if (normalizedSchema != null) {
                mediaType.setSchema(normalizedSchema);
            } else if (mediaTypeSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                mediaTypeSchema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty((Map)(paramSchemas = mediaTypeSchema.getProperties()))) continue;
            HashMap<String, Schema> paramNormalizedSchemas = new HashMap<String, Schema>();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema paramNormalizedSchema = this.normalizeSchema(paramSchema);
                if (paramNormalizedSchema == null) continue;
                paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
    }

    private <T> void sortComponent(Components components, Function<Components, Map<String, T>> getter, BiConsumer<Components, Map<String, T>> setter) {
        if (components != null && getter.apply(components) != null) {
            Map<String, T> component = getter.apply(components);
            setter.accept(components, new TreeMap<String, T>(component));
        }
    }

    private Schema normalizeSchema(Schema schema) {
        List allOf = schema.getAllOf();
        if (CollectionUtils.isEmpty((Collection)allOf)) {
            return null;
        }
        if (allOf.size() == 1) {
            boolean isSameType;
            String serializedAllOfDefaultValue;
            String serializedDefaultValue;
            Schema allOfSchema = (Schema)allOf.get(0);
            schema.setAllOf(null);
            Object defaultValue = schema.getDefault();
            String type = schema.getType();
            try {
                serializedDefaultValue = defaultValue != null ? ConvertUtils.getJsonMapper().writeValueAsString(defaultValue) : null;
            }
            catch (JsonProcessingException e) {
                return null;
            }
            schema.setDefault(null);
            schema.setType(null);
            Schema normalizedSchema = null;
            Object allOfDefaultValue = allOfSchema.getDefault();
            try {
                serializedAllOfDefaultValue = allOfDefaultValue != null ? ConvertUtils.getJsonMapper().writeValueAsString(allOfDefaultValue) : null;
            }
            catch (JsonProcessingException e) {
                return null;
            }
            boolean bl = isSameType = allOfSchema.getType() == null || allOfSchema.getType().equals(type);
            if (SchemaUtils.isEmptySchema(schema) && (serializedDefaultValue == null || serializedDefaultValue.equals(serializedAllOfDefaultValue)) && (type == null || allOfSchema.getType() == null || allOfSchema.getType().equals(type))) {
                normalizedSchema = allOfSchema;
            }
            schema.setType(type);
            schema.setAllOf(allOf);
            schema.setDefault(defaultValue);
            return normalizedSchema;
        }
        ArrayList<Object> finalList = new ArrayList<Object>(allOf.size());
        ArrayList<Schema> schemasWithoutRef = new ArrayList<Schema>(allOf.size() - 1);
        for (Schema schemaAllOf : allOf) {
            Map paramSchemas;
            Schema normalizedSchema = this.normalizeSchema(schemaAllOf);
            if (normalizedSchema != null) {
                schemaAllOf = normalizedSchema;
            }
            if (CollectionUtils.isNotEmpty((Map)(paramSchemas = schemaAllOf.getProperties()))) {
                HashMap<String, Schema> paramNormalizedSchemas = new HashMap<String, Schema>();
                for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                    Schema paramSchema = (Schema)paramEntry.getValue();
                    Schema paramNormalizedSchema = this.normalizeSchema(paramSchema);
                    if (paramNormalizedSchema == null) continue;
                    paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                }
                if (CollectionUtils.isNotEmpty(paramNormalizedSchemas)) {
                    paramSchemas.putAll(paramNormalizedSchemas);
                }
            }
            if (StringUtils.isEmpty((CharSequence)schemaAllOf.get$ref())) {
                schemasWithoutRef.add(schemaAllOf);
                if (StringUtils.isNotEmpty((CharSequence)schema.getDescription()) && StringUtils.isNotEmpty((CharSequence)schemaAllOf.getDescription())) {
                    schemaAllOf.setDescription(null);
                }
                if (schema.getDefault() == null || schemaAllOf.getDefault() == null || !schema.getDefault().equals(schemaAllOf.getDefault())) continue;
                schema.setDefault(null);
                continue;
            }
            finalList.add(schemaAllOf);
        }
        finalList.addAll(schemasWithoutRef);
        schema.setAllOf(finalList);
        return null;
    }

    private void normalizeSchemas(Map<String, Schema> schemas) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        HashMap<String, Schema> normalizedSchemas = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Map paramSchemas;
            Schema schema = entry.getValue();
            Schema normalizedSchema = this.normalizeSchema(schema);
            if (normalizedSchema != null) {
                normalizedSchemas.put(entry.getKey(), normalizedSchema);
            } else if (schema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                schema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty((Map)(paramSchemas = schema.getProperties()))) continue;
            HashMap<String, Schema> paramNormalizedSchemas = new HashMap<String, Schema>();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema paramNormalizedSchema = this.normalizeSchema(paramSchema);
                if (paramNormalizedSchema != null) {
                    paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                    continue;
                }
                if (!paramSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) continue;
                paramSchema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
        if (CollectionUtils.isNotEmpty(normalizedSchemas)) {
            schemas.putAll(normalizedSchemas);
        }
    }

    private void writeYamlToFile(Map<Pair<String, String>, OpenApiInfo> openApiInfos, String documentTitle, VisitorContext context, boolean isYaml) {
        Path viewsDestDirs = null;
        for (OpenApiInfo openApiInfo : openApiInfos.values()) {
            Optional<Path> specFile = this.openApiSpecFile(openApiInfo.getFilename(), context);
            try {
                Writer writer = this.getFileWriter(specFile);
                try {
                    (isYaml ? ConvertUtils.getYamlMapper() : ConvertUtils.getJsonMapper()).writeValue(writer, (Object)openApiInfo.getOpenApi());
                    if (Utils.isTestMode()) {
                        Utils.setTestFileName(openApiInfo.getFilename());
                        if (isYaml) {
                            Utils.setTestYamlReference(writer.toString());
                            continue;
                        }
                        Utils.setTestJsonReference(writer.toString());
                        continue;
                    }
                    Path specPath = specFile.get();
                    context.info("Writing OpenAPI file to destination: " + specPath);
                    viewsDestDirs = this.getViewsDestDir(this.getDefaultFilePath(openApiInfo.getFilename(), context).get(), context);
                    context.info("Writing OpenAPI views to destination: " + viewsDestDirs);
                    Path viewsDestDirsFinal = viewsDestDirs;
                    context.getClassesOutputPath().ifPresent(path -> {
                        context.addGeneratedResource(path.relativize(specPath).toString());
                        context.addGeneratedResource(path.relativize(specPath.getParent()).toString());
                        context.addGeneratedResource(path.relativize(viewsDestDirsFinal).toString());
                    });
                    openApiInfo.setSpecFilePath(specPath.getFileName().toString());
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                context.warn("Unable to generate swagger" + (isYaml ? EXT_YML : EXT_JSON) + ": " + specFile.orElse(null) + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), (Element)this.classElement);
            }
        }
        if (!Utils.isTestMode() && viewsDestDirs != null) {
            try {
                this.renderViews(documentTitle, openApiInfos, viewsDestDirs, context);
            }
            catch (Exception e) {
                context.warn("Unable to render swagger" + (isYaml ? EXT_YML : EXT_JSON) + ": " + openApiInfos.get(0).getSpecFilePath() + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), (Element)this.classElement);
            }
        }
    }

    private Writer getFileWriter(Optional<Path> specFile) throws IOException {
        if (Utils.isTestMode()) {
            return new StringWriter();
        }
        if (specFile.isPresent()) {
            return Files.newBufferedWriter(specFile.get(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        throw new IOException("Swagger spec file location is not present");
    }

    private void processEndpoints(VisitorContext context) {
        EndpointsConfiguration endpointsCfg = OpenApiApplicationVisitor.endpointsConfiguration(context);
        if (endpointsCfg.isEnabled() && CollectionUtils.isNotEmpty(endpointsCfg.getEndpoints())) {
            OpenApiEndpointVisitor visitor = new OpenApiEndpointVisitor(true);
            endpointsCfg.getEndpoints().values().stream().filter(endpoint -> endpoint.getClassElement().isPresent()).forEach(endpoint -> {
                ClassElement element = endpoint.getClassElement().get();
                context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_CLASS_TAGS, endpoint.getTags());
                context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_SERVERS, endpoint.getServers());
                context.put((CharSequence)MICRONAUT_OPENAPI_ENDPOINT_SECURITY_REQUIREMENTS, endpoint.getSecurityRequirements());
                visitor.visitClass(element, context);
                element.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$"))).forEach(method -> visitor.visitMethod((MethodElement)method, context));
            });
        }
    }

    static final class SchemaDecorator {
        private String prefix;
        private String postfix;

        SchemaDecorator() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }
    }

    static final class CustomSchema {
        private final List<String> typeArgs;
        private final ClassElement classElement;

        private CustomSchema(List<String> typeArgs, ClassElement classElement) {
            this.typeArgs = typeArgs;
            this.classElement = classElement;
        }

        public List<String> getTypeArgs() {
            return this.typeArgs;
        }

        public ClassElement getClassElement() {
            return this.classElement;
        }
    }

    static class LowerCamelCasePropertyNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private static final long serialVersionUID = -2750503285679998670L;

        LowerCamelCasePropertyNamingStrategy() {
        }

        public String translate(String propertyName) {
            return propertyName;
        }
    }
}

