/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.swagger.v3.oas.models.callbacks.Callback;
import java.io.IOException;
import java.util.Map;

@Internal
public class CallbackSerializer
extends JsonSerializer<Callback> {
    public void serialize(Callback value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null && value.getExtensions() != null && !value.getExtensions().isEmpty()) {
            jgen.writeStartObject();
            if (!StringUtils.hasText((CharSequence)value.get$ref())) {
                if (!value.isEmpty()) {
                    for (Map.Entry entry : value.entrySet()) {
                        jgen.writeObjectField((String)entry.getKey(), entry.getValue());
                    }
                }
            } else {
                jgen.writeStringField("$ref", value.get$ref());
            }
            for (String ext : value.getExtensions().keySet()) {
                jgen.writeObjectField(ext, value.getExtensions().get(ext));
            }
            jgen.writeEndObject();
        } else if (value == null || !StringUtils.hasText((CharSequence)value.get$ref())) {
            provider.defaultSerializeValue((Object)value, jgen);
        } else {
            jgen.writeStartObject();
            jgen.writeStringField("$ref", value.get$ref());
            jgen.writeEndObject();
        }
    }
}

