/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestBean;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIDecorator;
import io.micronaut.openapi.annotation.OpenAPIGroup;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.ElementUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.RouterVersioningProperties;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import io.micronaut.openapi.visitor.security.SecurityProperties;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callbacks;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractOpenApiEndpointVisitor
extends AbstractOpenApiVisitor {
    protected static final String CONTEXT_CHILD_PATH = "internal.child.path";
    protected static final String CONTEXT_CHILD_OP_ID_PREFIX = "internal.opId.prefix";
    protected static final String CONTEXT_CHILD_OP_ID_SUFFIX = "internal.opId.suffix";
    protected static final String CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS = "internal.opId.suffixes.add.always";
    protected static final String IS_PROCESS_PARENT_CLASS = "internal.is.process.parent";
    private static final TypeReference<Map<CharSequence, Object>> MAP_TYPE = new TypeReference<Map<CharSequence, Object>>(){};
    private static final int MAX_SUMMARY_LENGTH = 200;
    private static final String THREE_DOTS = "...";
    protected List<io.swagger.v3.oas.models.tags.Tag> classTags;
    protected ExternalDocumentation classExternalDocs;

    private static boolean isAnnotationPresent(Element element, String className) {
        return element.findAnnotation(className).isPresent();
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
            return;
        }
        if (this.ignore(element, context)) {
            return;
        }
        this.incrementVisitedElements(context);
        this.processSecuritySchemes(element, context);
        this.processTags(element, context);
        this.processExternalDocs(element, context);
        context.remove((CharSequence)CONTEXT_CHILD_PATH);
        if (element.isAnnotationPresent(Controller.class)) {
            element.stringValue(UriMapping.class).ifPresent(url -> context.put((CharSequence)CONTEXT_CHILD_PATH, url));
            String prefix = "";
            String suffix = "";
            boolean addAlways = true;
            AnnotationValue apiDecorator = element.getDeclaredAnnotation(OpenAPIDecorator.class);
            if (apiDecorator != null) {
                prefix = apiDecorator.stringValue().orElse("");
                suffix = apiDecorator.stringValue("opIdSuffix").orElse("");
                addAlways = apiDecorator.booleanValue("addAlways").orElse(true);
            }
            context.put((CharSequence)CONTEXT_CHILD_OP_ID_PREFIX, (Object)prefix);
            context.put((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX, (Object)suffix);
            context.put((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS, (Object)addAlways);
            ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
            Collection parentInterfaces = element.getInterfaces();
            if (element.isInterface() && !parentInterfaces.isEmpty()) {
                for (ClassElement parentInterface : parentInterfaces) {
                    if (ClassUtils.isJavaLangType((String)parentInterface.getName())) continue;
                    superTypes.add(parentInterface);
                }
            } else {
                element.getSuperType().ifPresent(superTypes::add);
            }
            if (CollectionUtils.isNotEmpty(superTypes)) {
                context.put((CharSequence)IS_PROCESS_PARENT_CLASS, (Object)true);
                List methods = element.getEnclosedElements(ElementQuery.ALL_METHODS);
                for (MethodElement method : methods) {
                    this.visitMethod(method, context);
                }
                context.remove((CharSequence)IS_PROCESS_PARENT_CLASS);
            }
            context.remove((CharSequence)CONTEXT_CHILD_OP_ID_PREFIX);
            context.remove((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX);
            context.remove((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS);
        }
        context.remove((CharSequence)CONTEXT_CHILD_PATH);
    }

    private void processTags(ClassElement element, VisitorContext context) {
        this.classTags = this.readTags(element, context);
        List<io.swagger.v3.oas.models.tags.Tag> userDefinedClassTags = this.classTags(element, context);
        if (CollectionUtils.isEmpty(this.classTags)) {
            this.classTags = userDefinedClassTags == null ? Collections.emptyList() : userDefinedClassTags;
        } else if (userDefinedClassTags != null) {
            for (io.swagger.v3.oas.models.tags.Tag tag : userDefinedClassTags) {
                if (this.containsTag(tag.getName(), this.classTags)) continue;
                this.classTags.add(tag);
            }
        }
    }

    private void processExternalDocs(ClassElement element, VisitorContext context) {
        Optional externalDocsAnn = element.findAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        this.classExternalDocs = externalDocsAnn.flatMap(o -> this.toValue(o.getValues(), context, ExternalDocumentation.class)).orElse(null);
    }

    private boolean containsTag(String name, List<io.swagger.v3.oas.models.tags.Tag> tags) {
        return tags.stream().anyMatch(tag -> name.equals(tag.getName()));
    }

    protected abstract List<SecurityRequirement> methodSecurityRequirements(MethodElement var1, VisitorContext var2);

    protected abstract List<Server> methodServers(MethodElement var1, VisitorContext var2);

    protected abstract List<io.swagger.v3.oas.models.tags.Tag> classTags(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(MethodElement var1, VisitorContext var2);

    protected abstract HttpMethod httpMethod(MethodElement var1);

    protected abstract List<UriMatchTemplate> uriMatchTemplates(MethodElement var1, VisitorContext var2);

    protected abstract List<io.micronaut.http.MediaType> consumesMediaTypes(MethodElement var1);

    protected abstract List<io.micronaut.http.MediaType> producesMediaTypes(MethodElement var1);

    protected abstract String description(MethodElement var1);

    private boolean hasNoBindingAnnotationOrType(TypedElement parameter) {
        return !parameter.isAnnotationPresent(io.swagger.v3.oas.annotations.parameters.RequestBody.class) && !parameter.isAnnotationPresent(QueryValue.class) && !parameter.isAnnotationPresent(PathVariable.class) && !parameter.isAnnotationPresent(Body.class) && !parameter.isAnnotationPresent(Part.class) && !parameter.isAnnotationPresent(CookieValue.class) && !parameter.isAnnotationPresent(Header.class) && !parameter.isAnnotationPresent(RequestBean.class) && !this.isResponseType(parameter.getType());
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
            return;
        }
        if (this.ignore(element, context)) {
            return;
        }
        HttpMethod httpMethod = this.httpMethod(element);
        if (httpMethod == null) {
            return;
        }
        List<UriMatchTemplate> matchTemplates = this.uriMatchTemplates(element, context);
        if (CollectionUtils.isEmpty(matchTemplates)) {
            return;
        }
        this.incrementVisitedElements(context);
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        boolean permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        Map<String, List<PathItem>> pathItemsMap = this.resolvePathItems(context, matchTemplates);
        List<io.micronaut.http.MediaType> consumesMediaTypes = this.consumesMediaTypes(element);
        List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
        for (Map.Entry<String, List<PathItem>> pathItemEntry : pathItemsMap.entrySet()) {
            List<PathItem> pathItems = pathItemEntry.getValue();
            Map<PathItem, io.swagger.v3.oas.models.Operation> swaggerOperations = this.readOperations(pathItemEntry.getKey(), httpMethod, pathItems, element, context);
            for (Map.Entry<PathItem, io.swagger.v3.oas.models.Operation> operationEntry : swaggerOperations.entrySet()) {
                io.swagger.v3.oas.models.Operation swaggerOperation = operationEntry.getValue();
                ExternalDocumentation externalDocs = this.readExternalDocs(element, context);
                if (externalDocs == null) {
                    externalDocs = this.classExternalDocs;
                }
                if (externalDocs != null) {
                    swaggerOperation.setExternalDocs(externalDocs);
                }
                this.readTags(element, context, swaggerOperation, this.classTags == null ? Collections.emptyList() : this.classTags, openAPI);
                this.readSecurityRequirements(element, pathItemEntry.getKey(), swaggerOperation, context);
                this.readApiResponses(element, context, swaggerOperation);
                this.readServers(element, context, swaggerOperation);
                this.readCallbacks(element, context, swaggerOperation);
                JavadocDescription javadocDescription = this.getMethodDescription(element, swaggerOperation);
                if (element.isAnnotationPresent(Deprecated.class)) {
                    swaggerOperation.setDeprecated(Boolean.valueOf(true));
                }
                this.readResponse(element, context, openAPI, swaggerOperation, javadocDescription);
                boolean isRequestBodySchemaSet = false;
                if (permitsRequestBody) {
                    Pair<RequestBody, Boolean> requestBodyPair = this.readSwaggerRequestBody((Element)element, consumesMediaTypes, context);
                    RequestBody requestBody = null;
                    if (requestBodyPair != null) {
                        requestBody = requestBodyPair.getFirst();
                        isRequestBodySchemaSet = requestBodyPair.getSecond();
                    }
                    if (requestBody != null) {
                        RequestBody currentRequestBody = swaggerOperation.getRequestBody();
                        if (currentRequestBody != null) {
                            swaggerOperation.setRequestBody(SchemaUtils.mergeRequestBody(currentRequestBody, requestBody));
                        } else {
                            swaggerOperation.setRequestBody(requestBody);
                        }
                    }
                }
                SchemaUtils.setOperationOnPathItem(operationEntry.getKey(), httpMethod, swaggerOperation);
                HashMap<String, UriMatchVariable> pathVariables = new HashMap<String, UriMatchVariable>();
                for (UriMatchTemplate matchTemplate : matchTemplates) {
                    for (Map.Entry<String, UriMatchVariable> varEntry : this.pathVariables(matchTemplate).entrySet()) {
                        if (!pathItemEntry.getKey().contains("{" + varEntry.getKey() + "}")) continue;
                        pathVariables.put(varEntry.getKey(), varEntry.getValue());
                    }
                    this.processParameterAnnotationInMethod(element, openAPI, matchTemplate, httpMethod, swaggerOperation, pathVariables);
                }
                ArrayList<TypedElement> extraBodyParameters = new ArrayList<TypedElement>();
                for (io.swagger.v3.oas.models.Operation operation : swaggerOperations.values()) {
                    this.processParameters(element, context, openAPI, operation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, extraBodyParameters, httpMethod, matchTemplates, pathItems);
                    this.processExtraBodyParameters(context, httpMethod, openAPI, operation, javadocDescription, isRequestBodySchemaSet, consumesMediaTypes, extraBodyParameters);
                    this.processMicronautVersionAndGroup(operation, pathItemEntry.getKey(), httpMethod, consumesMediaTypes, producesMediaTypes, element, context);
                }
            }
        }
    }

    private void processExtraBodyParameters(VisitorContext context, HttpMethod httpMethod, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean isRequestBodySchemaSet, List<io.micronaut.http.MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters) {
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod) && !extraBodyParameters.isEmpty() && requestBody == null) {
            requestBody = new RequestBody();
            Content content = new Content();
            requestBody.setContent(content);
            requestBody.setRequired(Boolean.valueOf(true));
            swaggerOperation.setRequestBody(requestBody);
            consumesMediaTypes = CollectionUtils.isEmpty(consumesMediaTypes) ? Utils.DEFAULT_MEDIA_TYPES : consumesMediaTypes;
            consumesMediaTypes.forEach(mediaType -> {
                MediaType mt = new MediaType();
                Schema schema = new Schema();
                schema.setType("object");
                mt.setSchema(schema);
                content.addMediaType(mediaType.toString(), mt);
            });
        }
        if (requestBody != null && !extraBodyParameters.isEmpty()) {
            requestBody.getContent().forEach((mediaTypeName, mediaType) -> {
                Schema schema = mediaType.getSchema();
                if (schema == null) {
                    schema = new Schema();
                    mediaType.setSchema(schema);
                }
                if (schema.get$ref() != null) {
                    if (isRequestBodySchemaSet) {
                        schema = (Schema)openAPI.getComponents().getSchemas().get(schema.get$ref().substring("#/components/schemas/".length()));
                    } else {
                        ComposedSchema composedSchema = new ComposedSchema();
                        Schema extraBodyParametersSchema = new Schema();
                        composedSchema.addAllOfItem(schema);
                        composedSchema.addAllOfItem(extraBodyParametersSchema);
                        schema = extraBodyParametersSchema;
                        mediaType.setSchema((Schema)composedSchema);
                    }
                }
                for (TypedElement parameter : extraBodyParameters) {
                    if (!isRequestBodySchemaSet) {
                        this.processBodyParameter(context, openAPI, javadocDescription, io.micronaut.http.MediaType.of((String)mediaTypeName), schema, parameter);
                    }
                    if (!mediaTypeName.equals("multipart/form-data") || !CollectionUtils.isNotEmpty((Map)schema.getProperties())) continue;
                    for (String prop : schema.getProperties().keySet()) {
                        Encoding encoding;
                        HashMap<String, Encoding> encodings = mediaType.getEncoding();
                        if (encodings == null) {
                            encodings = new HashMap<String, Encoding>();
                            mediaType.setEncoding(encodings);
                        }
                        if ((encoding = (Encoding)encodings.get(prop)) != null || !ElementUtils.isFileUpload(parameter.getType())) continue;
                        encoding = new Encoding();
                        encodings.put(prop, encoding);
                        encoding.setContentType("application/octet-stream");
                    }
                }
            });
        }
    }

    private void processParameters(MethodElement element, VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<io.micronaut.http.MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates, List<PathItem> pathItems) {
        if (ArrayUtils.isEmpty((Object[])element.getParameters())) {
            return;
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters = swaggerOperation.getParameters();
        if (CollectionUtils.isEmpty((Collection)swaggerParameters)) {
            swaggerParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        }
        for (ParameterElement parameter : element.getParameters()) {
            if (this.alreadyProcessedParameter(swaggerParameters, parameter)) continue;
            this.processParameter(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, (TypedElement)parameter, extraBodyParameters, httpMethod, matchTemplates, pathItems);
        }
        if (CollectionUtils.isNotEmpty(swaggerParameters)) {
            swaggerOperation.setParameters(swaggerParameters);
        }
    }

    private boolean alreadyProcessedParameter(List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, ParameterElement parameter) {
        return swaggerParameters.stream().anyMatch(p -> p.getName().equals(parameter.getName()) && p.getIn() != null);
    }

    private void processParameterAnnotationInMethod(MethodElement element, OpenAPI openAPI, UriMatchTemplate matchTemplate, HttpMethod httpMethod, io.swagger.v3.oas.models.Operation operation, Map<String, UriMatchVariable> pathVariables) {
        List parameterAnnotations = element.getDeclaredAnnotationValuesByType(Parameter.class);
        for (AnnotationValue paramAnn : parameterAnnotations) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameter.schema(new Schema());
            paramAnn.stringValue("name").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).name(arg_0));
            paramAnn.enumValue("in", ParameterIn.class).ifPresent(in -> parameter.in(in.toString()));
            paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).description(arg_0));
            paramAnn.booleanValue("required").ifPresent(value -> parameter.setRequired(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("deprecated").ifPresent(value -> parameter.setDeprecated(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("allowEmptyValue").ifPresent(value -> parameter.setAllowEmptyValue(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("allowReserved").ifPresent(value -> parameter.setAllowReserved(value != false ? Boolean.valueOf(true) : null));
            paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).example(arg_0));
            paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).$ref(arg_0));
            paramAnn.enumValue("style", ParameterStyle.class).ifPresent(style -> parameter.setStyle(this.paramStyle((ParameterStyle)style)));
            if (parameter.getIn() == null) {
                for (ParameterElement paramEl : element.getParameters()) {
                    if (!paramEl.getName().equals(parameter.getName())) continue;
                    if (paramEl.isAnnotationPresent(PathVariable.class)) {
                        parameter.setIn("path");
                        continue;
                    }
                    if (paramEl.isAnnotationPresent(QueryValue.class)) {
                        parameter.setIn("query");
                        continue;
                    }
                    if (paramEl.isAnnotationPresent(CookieValue.class)) {
                        parameter.setIn("cookie");
                        continue;
                    }
                    if (paramEl.isAnnotationPresent(Header.class)) {
                        parameter.setIn("header");
                        continue;
                    }
                    UriMatchVariable pathVariable = pathVariables.get(parameter.getName());
                    if (pathVariable == null) {
                        UriMatchVariable variable;
                        Iterator iterator = matchTemplate.getVariables().iterator();
                        while (iterator.hasNext() && (!(variable = (UriMatchVariable)iterator.next()).getName().equals(parameter.getName()) || !variable.isOptional() || variable.isQuery() || variable.isExploded())) {
                        }
                    }
                    if (!(pathVariable == null || pathVariable.isOptional() || pathVariable.isQuery() || pathVariable.isExploded())) {
                        parameter.setIn("path");
                    }
                    if (parameter.getIn() != null || httpMethod != HttpMethod.GET) continue;
                    parameter.setIn("query");
                }
            }
            operation.addParametersItem(parameter);
            PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)matchTemplate.toPathString());
            SchemaUtils.setOperationOnPathItem(pathItem, httpMethod, operation);
        }
    }

    private void processParameter(VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates, List<PathItem> pathItems) {
        Pair<RequestBody, Boolean> requestBodyPair;
        ClassElement parameterType = parameter.getGenericType();
        if (this.ignoreParameter(parameter)) {
            return;
        }
        if (permitsRequestBody && swaggerOperation.getRequestBody() == null && (requestBodyPair = this.readSwaggerRequestBody((Element)parameter, consumesMediaTypes, context)) != null && requestBodyPair.getFirst() != null) {
            swaggerOperation.setRequestBody(requestBodyPair.getFirst());
        }
        List<io.micronaut.http.MediaType> list = consumesMediaTypes = CollectionUtils.isNotEmpty(consumesMediaTypes) ? consumesMediaTypes : Utils.DEFAULT_MEDIA_TYPES;
        if (parameter.isAnnotationPresent(Body.class)) {
            Object pathItem;
            io.swagger.v3.oas.models.Operation existedOpertion = null;
            Iterator<PathItem> iterator = pathItems.iterator();
            while (iterator.hasNext() && (existedOpertion = SchemaUtils.getOperationOnPathItem((PathItem)(pathItem = iterator.next()), httpMethod)) == null) {
            }
            this.processBody(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, consumesMediaTypes, parameter, parameterType);
            RequestBody requestBody = swaggerOperation.getRequestBody();
            if (requestBody != null && requestBody.getContent() != null && existedOpertion != null) {
                for (Map.Entry entry : existedOpertion.getRequestBody().getContent().entrySet()) {
                    boolean found = false;
                    for (io.micronaut.http.MediaType mediaType : consumesMediaTypes) {
                        if (!((String)entry.getKey()).equals(mediaType.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    MediaType mediaType = (MediaType)entry.getValue();
                    Schema<?> propertySchema = this.bindSchemaForElement(context, parameter, parameterType, mediaType.getSchema());
                    String bodyAnnValue = parameter.getAnnotation(Body.class).getValue(String.class).orElse(null);
                    if (!StringUtils.isNotEmpty((CharSequence)bodyAnnValue)) continue;
                    Schema wrapperSchema = new Schema();
                    wrapperSchema.setType("object");
                    if (this.isElementNotNullable((Element)parameter, (Element)parameterType)) {
                        wrapperSchema.addRequiredItem(bodyAnnValue);
                    }
                    wrapperSchema.addProperty(bodyAnnValue, propertySchema);
                    mediaType.setSchema(wrapperSchema);
                }
            }
            return;
        }
        if (parameter.isAnnotationPresent(RequestBean.class)) {
            this.processRequestBean(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, parameter, extraBodyParameters, httpMethod, matchTemplates, pathItems);
            return;
        }
        io.swagger.v3.oas.models.parameters.Parameter newParameter = this.processMethodParameterAnnotation(context, swaggerOperation, permitsRequestBody, pathVariables, parameter, extraBodyParameters, httpMethod, matchTemplates);
        if (newParameter == null) {
            return;
        }
        if (newParameter.get$ref() != null) {
            this.addSwaggerParamater(newParameter, swaggerParameters);
            return;
        }
        if (newParameter.getExplode() != null && newParameter.getExplode().booleanValue() && "query".equals(newParameter.getIn()) && !parameterType.isIterable()) {
            Schema explodedSchema = this.resolveSchema(openAPI, (Element)parameter, parameterType, context, consumesMediaTypes, null, null);
            if (explodedSchema != null) {
                if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null && StringUtils.isNotEmpty((CharSequence)explodedSchema.get$ref())) {
                    explodedSchema = (Schema)openAPI.getComponents().getSchemas().get(explodedSchema.get$ref().substring("#/components/schemas/".length()));
                }
                if (CollectionUtils.isNotEmpty((Map)explodedSchema.getProperties())) {
                    Map props = explodedSchema.getProperties();
                    for (Map.Entry entry : props.entrySet()) {
                        QueryParameter unwrappedParameter = new QueryParameter();
                        if (CollectionUtils.isNotEmpty((Collection)explodedSchema.getRequired()) && explodedSchema.getRequired().contains(entry.getKey())) {
                            unwrappedParameter.setRequired(Boolean.valueOf(true));
                        }
                        unwrappedParameter.setName((String)entry.getKey());
                        unwrappedParameter.setSchema((Schema)entry.getValue());
                        this.addSwaggerParamater((io.swagger.v3.oas.models.parameters.Parameter)unwrappedParameter, swaggerParameters);
                    }
                }
            }
        } else {
            CharSequence desc;
            if (StringUtils.isEmpty((CharSequence)newParameter.getName())) {
                newParameter.setName(parameter.getName());
            }
            if (newParameter.getRequired() == null && !ElementUtils.isNullable(parameter)) {
                newParameter.setRequired(Boolean.valueOf(true));
            }
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)newParameter.getDescription()) && (desc = (CharSequence)javadocDescription.getParameters().get(parameter.getName())) != null) {
                newParameter.setDescription(desc.toString());
            }
            this.addSwaggerParamater(newParameter, swaggerParameters);
            Schema<?> schema = newParameter.getSchema();
            if (schema == null) {
                schema = this.resolveSchema(openAPI, (Element)parameter, parameterType, context, consumesMediaTypes, null, null);
            }
            if (schema != null) {
                schema = this.bindSchemaForElement(context, parameter, parameterType, schema);
                newParameter.setSchema(schema);
            }
        }
    }

    private void addSwaggerParamater(io.swagger.v3.oas.models.parameters.Parameter newParameter, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters) {
        if (newParameter.get$ref() != null) {
            swaggerParameters.add(newParameter);
            return;
        }
        for (io.swagger.v3.oas.models.parameters.Parameter swaggerParameter : swaggerParameters) {
            if (!newParameter.getName().equals(swaggerParameter.getName())) continue;
            return;
        }
        swaggerParameters.add(newParameter);
    }

    private void processBodyParameter(VisitorContext context, OpenAPI openAPI, JavadocDescription javadocDescription, io.micronaut.http.MediaType mediaType, Schema schema, TypedElement parameter) {
        Schema<?> propertySchema = this.resolveSchema(openAPI, (Element)parameter, parameter.getType(), context, Collections.singletonList(mediaType), null, null);
        if (propertySchema != null) {
            String doc;
            Optional description = parameter.getValue(Parameter.class, "description", String.class);
            description.ifPresent(arg_0 -> propertySchema.setDescription(arg_0));
            this.processSchemaProperty(context, parameter, parameter.getType(), null, schema, propertySchema);
            if (ElementUtils.isNullable(parameter)) {
                propertySchema.setNullable(Boolean.valueOf(true));
            }
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)propertySchema.getDescription()) && (doc = javadocDescription.getParameters().get(parameter.getName())) != null) {
                propertySchema.setDescription(doc);
            }
        }
    }

    private io.swagger.v3.oas.models.parameters.Parameter processMethodParameterAnnotation(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, TypedElement parameter, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates) {
        AnnotationValue paramAnn;
        AnnotationValue parameterAnnotation;
        QueryParameter newParameter = null;
        String parameterName = parameter.getName();
        if (!parameter.hasStereotype(Bindable.class) && pathVariables.containsKey(parameterName)) {
            UriMatchVariable urlVar = pathVariables.get(parameterName);
            newParameter = urlVar.isQuery() ? new QueryParameter() : new PathParameter();
            newParameter.setName(parameterName);
            boolean exploded = urlVar.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(exploded));
            }
        } else if (parameter.isAnnotationPresent(PathVariable.class)) {
            String paramName = parameter.getValue(PathVariable.class, String.class).orElse(parameterName);
            UriMatchVariable variable = pathVariables.get(paramName);
            if (variable == null) {
                context.warn("Path variable name: '" + paramName + "' not found in path, operation: " + swaggerOperation.getOperationId(), (Element)parameter);
                return null;
            }
            newParameter = new PathParameter();
            newParameter.setName(paramName);
            boolean exploded = variable.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(true));
            }
        } else if (parameter.isAnnotationPresent(Header.class)) {
            String headerName = parameter.getValue(Header.class, "name", String.class).orElse(parameter.getValue(Header.class, String.class).orElseGet(() -> NameUtils.hyphenate((String)parameterName)));
            if ("Authorization".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName) || "Accept".equalsIgnoreCase(headerName)) {
                return null;
            }
            newParameter = new HeaderParameter();
            newParameter.setName(headerName);
        } else if (parameter.isAnnotationPresent(CookieValue.class)) {
            String cookieName = parameter.getValue(CookieValue.class, String.class).orElse(parameterName);
            newParameter = new CookieParameter();
            newParameter.setName(cookieName);
        } else if (parameter.isAnnotationPresent(QueryValue.class)) {
            String queryVar = parameter.getValue(QueryValue.class, String.class).orElse(parameterName);
            newParameter = new QueryParameter();
            newParameter.setName(queryVar);
        } else if (parameter.isAnnotationPresent(Part.class) && permitsRequestBody) {
            extraBodyParameters.add(parameter);
        } else if (parameter.hasAnnotation("io.micronaut.management.endpoint.annotation.Selector")) {
            newParameter = new PathParameter();
            newParameter.setName(parameterName);
        } else if (this.hasNoBindingAnnotationOrType(parameter) && ((parameterAnnotation = parameter.getAnnotation(Parameter.class)) == null || !parameterAnnotation.booleanValue("hidden").orElse(false).booleanValue() && parameterAnnotation.stringValue("in").isEmpty())) {
            if (permitsRequestBody) {
                extraBodyParameters.add(parameter);
            } else {
                UriMatchVariable pathVariable = pathVariables.get(parameterName);
                boolean isExploded = false;
                if (pathVariable == null) {
                    block4: for (UriMatchTemplate matchTemplate : matchTemplates) {
                        for (UriMatchVariable variable : matchTemplate.getVariables()) {
                            if (!variable.getName().equals(parameterName)) continue;
                            isExploded = variable.isExploded();
                            if (!variable.isOptional() || variable.isQuery() || isExploded) continue block4;
                            return null;
                        }
                    }
                }
                if (pathVariable != null && !pathVariable.isOptional() && !pathVariable.isQuery()) {
                    newParameter = new PathParameter();
                    newParameter.setName(parameterName);
                    if (pathVariable.isExploded()) {
                        newParameter.setExplode(Boolean.valueOf(true));
                    }
                }
                if (newParameter == null && httpMethod == HttpMethod.GET) {
                    newParameter = new QueryParameter();
                    newParameter.setName(parameterName);
                }
                if (newParameter != null && isExploded) {
                    newParameter.setExplode(Boolean.valueOf(true));
                }
            }
        }
        if (parameter.isAnnotationPresent(Parameter.class) && (paramAnn = (AnnotationValue)parameter.findAnnotation(Parameter.class).orElse(null)) != null) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) {
                return null;
            }
            Map<CharSequence, Object> paramValues = this.toValueMap(paramAnn.getValues(), context);
            Utils.normalizeEnumValues(paramValues, Collections.singletonMap("in", ParameterIn.class));
            if (parameter.isAnnotationPresent(Header.class)) {
                paramValues.put("in", ParameterIn.HEADER.toString());
            } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                paramValues.put("in", ParameterIn.COOKIE.toString());
            } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                paramValues.put("in", ParameterIn.QUERY.toString());
            }
            this.processExplode((AnnotationValue<Parameter>)paramAnn, paramValues);
            JsonNode jsonNode = ConvertUtils.getJsonMapper().valueToTree(paramValues);
            if (newParameter == null) {
                try {
                    JsonNode schemaNode;
                    newParameter = ConvertUtils.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class, context);
                    if (jsonNode.has("schema") && (schemaNode = jsonNode.get("schema")).has("$ref")) {
                        if (newParameter == null) {
                            newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                        }
                        newParameter.schema(new Schema().$ref(schemaNode.get("$ref").asText()));
                    }
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                }
            } else {
                try {
                    io.swagger.v3.oas.models.parameters.Parameter v = ConvertUtils.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class, context);
                    if (v == null) {
                        Map target = (Map)ConvertUtils.getConvertJsonMapper().convertValue((Object)newParameter, MAP_TYPE);
                        for (CharSequence name : paramValues.keySet()) {
                            Object o = paramValues.get(name.toString());
                            if (o == null) continue;
                            target.put(name.toString(), o);
                        }
                        newParameter = (io.swagger.v3.oas.models.parameters.Parameter)ConvertUtils.getConvertJsonMapper().convertValue((Object)target, io.swagger.v3.oas.models.parameters.Parameter.class);
                    } else {
                        BeanMap beanMap = BeanMap.of((Object)v);
                        Map target = (Map)ConvertUtils.getConvertJsonMapper().convertValue((Object)newParameter, MAP_TYPE);
                        for (CharSequence name : beanMap.keySet()) {
                            Object o = beanMap.get((Object)name.toString());
                            if (o == null) continue;
                            target.put(name.toString(), o);
                        }
                        newParameter = (io.swagger.v3.oas.models.parameters.Parameter)ConvertUtils.getConvertJsonMapper().convertValue((Object)target, io.swagger.v3.oas.models.parameters.Parameter.class);
                    }
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                }
            }
            if (newParameter != null && newParameter.get$ref() != null) {
                return newParameter;
            }
            if (newParameter != null) {
                Schema parameterSchema = newParameter.getSchema();
                if (paramAnn.contains("schema") && parameterSchema != null) {
                    paramAnn.get((CharSequence)"schema", AnnotationValue.class).ifPresent(schemaAnn -> this.bindSchemaAnnotationValue(context, (Element)parameter, parameterSchema, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn));
                }
            }
        }
        if (newParameter != null && ElementUtils.isNullable(parameter)) {
            newParameter.setRequired(null);
        }
        return newParameter;
    }

    private void processBody(VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, List<io.micronaut.http.MediaType> consumesMediaTypes, TypedElement parameter, ClassElement parameterType) {
        CharSequence desc;
        if (!permitsRequestBody) {
            return;
        }
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (requestBody == null) {
            requestBody = new RequestBody();
            swaggerOperation.setRequestBody(requestBody);
        }
        if (requestBody.getDescription() == null && javadocDescription != null && (desc = (CharSequence)javadocDescription.getParameters().get(parameter.getName())) != null) {
            requestBody.setDescription(desc.toString());
        }
        if (requestBody.getRequired() == null && !ElementUtils.isNullable((TypedElement)parameterType)) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
        Content content = this.buildContent((Element)parameter, parameterType, consumesMediaTypes, openAPI, context);
        if (requestBody.getContent() == null) {
            requestBody.setContent(content);
        } else {
            Content currentContent = requestBody.getContent();
            for (Map.Entry entry : content.entrySet()) {
                MediaType mediaType = (MediaType)entry.getValue();
                MediaType existedMediaType = (MediaType)currentContent.get(entry.getKey());
                if (existedMediaType == null) {
                    currentContent.put((Object)((String)entry.getKey()), (Object)mediaType);
                    continue;
                }
                if (existedMediaType.getSchema() == null) {
                    existedMediaType.setSchema(mediaType.getSchema());
                }
                if (existedMediaType.getEncoding() == null) {
                    existedMediaType.setEncoding(mediaType.getEncoding());
                }
                if (existedMediaType.getExtensions() == null) {
                    existedMediaType.setExtensions(mediaType.getExtensions());
                }
                if (existedMediaType.getExamples() == null) {
                    existedMediaType.setExamples(mediaType.getExamples());
                }
                if (existedMediaType.getExample() != null || !mediaType.getExampleSetFlag()) continue;
                existedMediaType.setExample(mediaType.getExample());
            }
        }
    }

    private void processRequestBean(VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates, List<PathItem> pathItems) {
        for (FieldElement field : parameter.getType().getFields()) {
            if (field.isStatic()) continue;
            this.processParameter(context, openAPI, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, consumesMediaTypes, swaggerParameters, (TypedElement)field, extraBodyParameters, httpMethod, matchTemplates, pathItems);
        }
    }

    private void readResponse(MethodElement element, VisitorContext context, OpenAPI openAPI, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription) {
        boolean withMethodResponses = element.hasDeclaredAnnotation(io.swagger.v3.oas.annotations.responses.ApiResponse.class) || element.hasDeclaredAnnotation(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        HttpStatus methodResponseStatus = element.enumValue(Status.class, HttpStatus.class).orElse(HttpStatus.OK);
        String responseCode = String.valueOf(methodResponseStatus.getCode());
        ApiResponses responses = swaggerOperation.getResponses();
        ApiResponse response = null;
        if (responses == null) {
            responses = new ApiResponses();
            swaggerOperation.setResponses(responses);
        } else {
            ApiResponse defaultResponse = (ApiResponse)responses.remove((Object)"default");
            response = (ApiResponse)responses.get((Object)responseCode);
            if (response == null && defaultResponse != null) {
                response = defaultResponse;
                responses.put((Object)responseCode, (Object)response);
            }
        }
        if (response == null && !withMethodResponses) {
            response = new ApiResponse();
            if (javadocDescription == null || StringUtils.isEmpty((CharSequence)javadocDescription.getReturnDescription())) {
                response.setDescription(swaggerOperation.getOperationId() + " " + responseCode + " response");
            } else {
                response.setDescription(javadocDescription.getReturnDescription());
            }
            this.addResponseContent(element, context, openAPI, response);
            responses.put((Object)responseCode, (Object)response);
        } else if (response != null && response.getContent() == null) {
            this.addResponseContent(element, context, openAPI, response);
        }
    }

    private void addResponseContent(MethodElement element, VisitorContext context, OpenAPI openAPI, ApiResponse response) {
        ClassElement returnType = this.returnType(element, context);
        if (returnType != null && !returnType.getCanonicalName().equals(Void.class.getName())) {
            List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
            Content content = producesMediaTypes.isEmpty() ? this.buildContent((Element)element, returnType, Utils.DEFAULT_MEDIA_TYPES, openAPI, context) : this.buildContent((Element)element, returnType, producesMediaTypes, openAPI, context);
            response.setContent(content);
        }
    }

    private ClassElement returnType(MethodElement element, VisitorContext context) {
        ClassElement returnType = element.getGenericReturnType();
        if (ElementUtils.isVoid(returnType) || ElementUtils.isReactiveAndVoid(returnType)) {
            returnType = null;
        } else if (this.isResponseType(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        } else if (this.isSingleResponseType(returnType)) {
            returnType = (ClassElement)returnType.getFirstTypeArgument().get();
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        }
        return returnType;
    }

    private Map<String, UriMatchVariable> pathVariables(UriMatchTemplate matchTemplate) {
        List pv = matchTemplate.getVariables();
        LinkedHashMap<String, UriMatchVariable> pathVariables = new LinkedHashMap<String, UriMatchVariable>(pv.size());
        for (UriMatchVariable variable : pv) {
            pathVariables.put(variable.getName(), variable);
        }
        return pathVariables;
    }

    private JavadocDescription getMethodDescription(MethodElement element, io.swagger.v3.oas.models.Operation swaggerOperation) {
        String descr = this.description(element);
        if (StringUtils.isNotEmpty((CharSequence)descr) && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
            swaggerOperation.setDescription(descr);
            Object summary = descr.substring(0, descr.indexOf(46) + 1);
            if (((String)summary).length() > 200) {
                summary = ((String)summary).substring(0, 200) + THREE_DOTS;
            }
            swaggerOperation.setSummary((String)summary);
        }
        JavadocDescription javadocDescription = element.getDocumentation().map(Utils.getJavadocParser()::parse).orElse(null);
        if (javadocDescription != null) {
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription()) && StringUtils.hasText((CharSequence)javadocDescription.getMethodDescription())) {
                swaggerOperation.setDescription(javadocDescription.getMethodDescription());
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getSummary()) && StringUtils.hasText((CharSequence)javadocDescription.getMethodSummary())) {
                swaggerOperation.setSummary(javadocDescription.getMethodSummary());
            }
        }
        return javadocDescription;
    }

    private Map<PathItem, io.swagger.v3.oas.models.Operation> readOperations(String path, HttpMethod httpMethod, List<PathItem> pathItems, MethodElement element, VisitorContext context) {
        HashMap<PathItem, io.swagger.v3.oas.models.Operation> swaggerOperations = new HashMap<PathItem, io.swagger.v3.oas.models.Operation>(pathItems.size());
        Optional operationAnnotation = element.findAnnotation(Operation.class);
        for (PathItem pathItem : pathItems) {
            boolean addAlways;
            String suffix;
            String prefix;
            AnnotationValue apiDecorator;
            List params;
            Object[] methodParams;
            io.swagger.v3.oas.models.Operation swaggerOperation = operationAnnotation.flatMap(o -> this.toValue(o.getValues(), context, io.swagger.v3.oas.models.Operation.class)).orElse(new io.swagger.v3.oas.models.Operation());
            if (CollectionUtils.isNotEmpty((Collection)swaggerOperation.getParameters())) {
                swaggerOperation.getParameters().removeIf(Objects::isNull);
            }
            if (ArrayUtils.isNotEmpty((Object[])(methodParams = element.getParameters())) && operationAnnotation.isPresent() && CollectionUtils.isNotEmpty((Collection)(params = ((AnnotationValue)operationAnnotation.get()).getAnnotations("parameters", Parameter.class)))) {
                for (Object methodParam : methodParams) {
                    AnnotationValue paramAnn = null;
                    for (AnnotationValue param : params) {
                        String paramName = param.stringValue("name").orElse(null);
                        if (!methodParam.getName().equals(paramName)) continue;
                        paramAnn = param;
                        break;
                    }
                    io.swagger.v3.oas.models.parameters.Parameter swaggerParam = null;
                    if (paramAnn != null && !paramAnn.booleanValue("hidden").orElse(false).booleanValue()) {
                        Optional allowReserved;
                        Optional allowEmptyValue;
                        Optional deprecated;
                        String paramName = paramAnn.stringValue("name").orElse(null);
                        if (paramName != null && CollectionUtils.isNotEmpty((Collection)swaggerOperation.getParameters())) {
                            for (io.swagger.v3.oas.models.parameters.Parameter createdParameter : swaggerOperation.getParameters()) {
                                if (!createdParameter.getName().equals(paramName)) continue;
                                swaggerParam = createdParameter;
                                break;
                            }
                        }
                        if (swaggerParam == null) {
                            if (swaggerOperation.getParameters() == null) {
                                swaggerOperation.setParameters(new ArrayList());
                            }
                            swaggerParam = new io.swagger.v3.oas.models.parameters.Parameter();
                            swaggerOperation.getParameters().add(swaggerParam);
                        }
                        if (paramName != null) {
                            swaggerParam.setName(paramName);
                        }
                        paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).setDescription(arg_0));
                        Optional required = paramAnn.booleanValue("required");
                        if (required.isPresent()) {
                            swaggerParam.setRequired((Boolean)required.get() != false ? Boolean.valueOf(true) : null);
                        }
                        if ((deprecated = paramAnn.booleanValue("deprecated")).isPresent()) {
                            swaggerParam.setDeprecated((Boolean)deprecated.get() != false ? Boolean.valueOf(true) : null);
                        }
                        if ((allowEmptyValue = paramAnn.booleanValue("allowEmptyValue")).isPresent()) {
                            swaggerParam.setAllowEmptyValue((Boolean)allowEmptyValue.get() != false ? Boolean.valueOf(true) : null);
                        }
                        if ((allowReserved = paramAnn.booleanValue("allowReserved")).isPresent()) {
                            swaggerParam.setAllowReserved((Boolean)allowReserved.get() != false ? Boolean.valueOf(true) : null);
                        }
                        paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).setExample(arg_0));
                        Optional style = paramAnn.get((CharSequence)"style", ParameterStyle.class);
                        if (style.isPresent()) {
                            swaggerParam.setStyle(this.paramStyle((ParameterStyle)style.get()));
                        }
                        paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).set$ref(arg_0));
                        Optional in = paramAnn.get((CharSequence)"in", ParameterIn.class);
                        if (in.isPresent()) {
                            if (in.get() == ParameterIn.DEFAULT) {
                                swaggerParam.setIn(this.calcIn(path, httpMethod, (ParameterElement)methodParam));
                            } else {
                                swaggerParam.setIn(((ParameterIn)in.get()).toString());
                            }
                        }
                    }
                    if (swaggerParam == null || !StringUtils.isEmpty((CharSequence)swaggerParam.getIn())) continue;
                    swaggerParam.setIn(this.calcIn(path, httpMethod, (ParameterElement)methodParam));
                }
            }
            if ((apiDecorator = element.getDeclaredAnnotation(OpenAPIDecorator.class)) != null) {
                prefix = apiDecorator.stringValue().orElse("");
                suffix = apiDecorator.stringValue("opIdSuffix").orElse("");
                addAlways = apiDecorator.booleanValue("addAlways").orElse(true);
            } else {
                prefix = context.get((CharSequence)CONTEXT_CHILD_OP_ID_PREFIX, String.class).orElse("");
                suffix = context.get((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX, String.class).orElse("");
                addAlways = context.get((CharSequence)CONTEXT_CHILD_OP_ID_SUFFIX_ADD_ALWAYS, Boolean.class).orElse(true);
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getOperationId())) {
                swaggerOperation.setOperationId(prefix + element.getName() + suffix);
            } else if (addAlways) {
                swaggerOperation.setOperationId(prefix + swaggerOperation.getOperationId() + suffix);
            }
            if (swaggerOperation.getDescription() != null && swaggerOperation.getDescription().isEmpty()) {
                swaggerOperation.setDescription(null);
            }
            swaggerOperations.put(pathItem, swaggerOperation);
        }
        return swaggerOperations;
    }

    private String calcIn(String path, HttpMethod httpMethod, ParameterElement methodParam) {
        String paramName = methodParam.getName();
        Set paramAnnNames = methodParam.getAnnotationNames();
        if (CollectionUtils.isNotEmpty((Collection)paramAnnNames)) {
            if (paramAnnNames.contains(QueryValue.class.getName())) {
                return ParameterIn.QUERY.toString();
            }
            if (paramAnnNames.contains(PathVariable.class.getName())) {
                return ParameterIn.PATH.toString();
            }
            if (paramAnnNames.contains(Header.class.getName())) {
                return ParameterIn.HEADER.toString();
            }
            if (paramAnnNames.contains(CookieValue.class.getName())) {
                return ParameterIn.COOKIE.toString();
            }
        }
        if (httpMethod == HttpMethod.GET) {
            if (path.contains("{" + paramName + "}")) {
                return ParameterIn.PATH.toString();
            }
            return ParameterIn.QUERY.toString();
        }
        if (path.contains("{" + paramName + "}")) {
            return ParameterIn.PATH.toString();
        }
        return null;
    }

    private Parameter.StyleEnum paramStyle(ParameterStyle paramAnnStyle) {
        if (paramAnnStyle == null) {
            return null;
        }
        return switch (paramAnnStyle) {
            default -> throw new IncompatibleClassChangeError();
            case ParameterStyle.MATRIX -> Parameter.StyleEnum.MATRIX;
            case ParameterStyle.LABEL -> Parameter.StyleEnum.LABEL;
            case ParameterStyle.FORM -> Parameter.StyleEnum.FORM;
            case ParameterStyle.SPACEDELIMITED -> Parameter.StyleEnum.SPACEDELIMITED;
            case ParameterStyle.PIPEDELIMITED -> Parameter.StyleEnum.PIPEDELIMITED;
            case ParameterStyle.DEEPOBJECT -> Parameter.StyleEnum.DEEPOBJECT;
            case ParameterStyle.SIMPLE -> Parameter.StyleEnum.SIMPLE;
            case ParameterStyle.DEFAULT -> null;
        };
    }

    private ExternalDocumentation readExternalDocs(MethodElement element, VisitorContext context) {
        Optional externalDocsAnn = element.findAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        return externalDocsAnn.flatMap(o -> this.toValue(o.getValues(), context, ExternalDocumentation.class)).orElse(null);
    }

    private void readSecurityRequirements(MethodElement element, String path, io.swagger.v3.oas.models.Operation operation, VisitorContext context) {
        List<SecurityRequirement> securityRequirements = this.methodSecurityRequirements(element, context);
        if (CollectionUtils.isNotEmpty(securityRequirements)) {
            for (SecurityRequirement securityItem : securityRequirements) {
                operation.addSecurityItem(securityItem);
            }
            return;
        }
        this.processMicronautSecurityConfig(element, path, operation, context);
    }

    private void processMicronautSecurityConfig(MethodElement element, String path, io.swagger.v3.oas.models.Operation operation, VisitorContext context) {
        String securitySchemeName;
        SecurityProperties securityProperties = OpenApiApplicationVisitor.getSecurityProperties(context);
        if (!(securityProperties.isEnabled() && securityProperties.isMicronautSecurityEnabled() && (securityProperties.isTokenEnabled() || securityProperties.isJwtEnabled() || securityProperties.isBasicAuthEnabled() || securityProperties.isOauth2Enabled()))) {
            return;
        }
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        Components components = openAPI.getComponents();
        if (components != null && CollectionUtils.isNotEmpty((Map)components.getSecuritySchemes())) {
            securitySchemeName = (String)components.getSecuritySchemes().keySet().iterator().next();
        } else {
            if (components == null) {
                components = new Components();
                openAPI.setComponents(components);
            }
            if (components.getSecuritySchemes() == null) {
                components.setSecuritySchemes(new HashMap());
            }
            securitySchemeName = securityProperties.getDefaultSchemaName();
            SecurityScheme securityScheme = (SecurityScheme)components.getSecuritySchemes().get(securitySchemeName);
            if (securityScheme == null) {
                securityScheme = new SecurityScheme();
                if (securityProperties.isOauth2Enabled()) {
                    securityScheme.setType(SecurityScheme.Type.OAUTH2);
                } else if (securityProperties.isBasicAuthEnabled() || securityProperties.isTokenEnabled() || securityProperties.isJwtEnabled()) {
                    securityScheme.setType(SecurityScheme.Type.HTTP);
                    if (securityProperties.isJwtEnabled()) {
                        securityScheme.setBearerFormat("JWT");
                    }
                }
                if (securityProperties.isJwtEnabled() || securityProperties.isJwtBearerEnabled()) {
                    securityScheme.setScheme("bearer");
                } else if (securityProperties.isBasicAuthEnabled()) {
                    securityScheme.setScheme("basic");
                }
                components.addSecuritySchemes(securitySchemeName, securityScheme);
            }
        }
        AnnotationValue classLevelSecured = element.getOwningType().getAnnotation("io.micronaut.security.annotation.Secured");
        AnnotationValue methodLevelSecured = element.getAnnotation("io.micronaut.security.annotation.Secured");
        List access = null;
        if (methodLevelSecured != null) {
            access = methodLevelSecured.getValue(Argument.LIST_OF_STRING).orElse(null);
        } else if (classLevelSecured != null) {
            access = classLevelSecured.getValue(Argument.LIST_OF_STRING).orElse(null);
        }
        this.processSecurityAccess(securitySchemeName, access, operation);
        List<InterceptUrlMapPattern> securityRules = securityProperties.getInterceptUrlMapPatterns();
        if (CollectionUtils.isNotEmpty(securityRules)) {
            HttpMethod httpMethod = this.httpMethod(element);
            for (InterceptUrlMapPattern securityRule : securityRules) {
                if (!PathMatcher.ANT.matches(securityRule.getPattern(), path) || httpMethod != null && !securityRule.getHttpMethod().isEmpty() && httpMethod != securityRule.getHttpMethod().get()) continue;
                this.processSecurityAccess(securitySchemeName, securityRule.getAccess(), operation);
            }
        }
    }

    private void processSecurityAccess(String securitySchemeName, List<String> access, io.swagger.v3.oas.models.Operation operation) {
        if (CollectionUtils.isEmpty(access)) {
            return;
        }
        String firstAccessItem = access.get(0);
        if (access.size() == 1 && (firstAccessItem.equals("isAnonymous()") || firstAccessItem.equals("denyAll()"))) {
            return;
        }
        if (access.size() == 1 && firstAccessItem.equals("isAuthenticated()")) {
            access = Collections.emptyList();
        }
        SecurityRequirement existedSecurityRequirement = null;
        List existedSecList = null;
        if (CollectionUtils.isNotEmpty((Collection)operation.getSecurity())) {
            for (SecurityRequirement securityRequirement : operation.getSecurity()) {
                if (!securityRequirement.containsKey((Object)securitySchemeName)) continue;
                existedSecList = (List)securityRequirement.get((Object)securitySchemeName);
                existedSecurityRequirement = securityRequirement;
                break;
            }
        }
        if (existedSecList != null) {
            if (access.isEmpty()) {
                return;
            }
            if (existedSecList.isEmpty()) {
                existedSecurityRequirement.put((Object)securitySchemeName, access);
            } else {
                HashSet<String> finalAccess = new HashSet<String>(existedSecList);
                finalAccess.addAll(access);
                existedSecurityRequirement.put((Object)securitySchemeName, new ArrayList(finalAccess));
            }
        } else {
            SecurityRequirement securityRequirement = new SecurityRequirement();
            securityRequirement.put((Object)securitySchemeName, access);
            operation.addSecurityItem(securityRequirement);
        }
    }

    private void processExplode(AnnotationValue<Parameter> paramAnn, Map<CharSequence, Object> paramValues) {
        Optional explode = paramAnn.enumValue("explode", Explode.class);
        if (explode.isPresent()) {
            Explode ex = (Explode)explode.get();
            block0 : switch (ex) {
                case TRUE: {
                    paramValues.put("explode", Boolean.TRUE);
                    break;
                }
                case FALSE: {
                    paramValues.put("explode", Boolean.FALSE);
                    break;
                }
                default: {
                    String in = (String)paramValues.get("in");
                    if (StringUtils.isEmpty((CharSequence)in)) {
                        in = "DEFAULT";
                    }
                    switch (ParameterIn.valueOf((String)in.toUpperCase(Locale.US))) {
                        case COOKIE: 
                        case QUERY: {
                            paramValues.put("explode", Boolean.TRUE);
                            break block0;
                        }
                    }
                    paramValues.put("explode", Boolean.FALSE);
                }
            }
        }
    }

    private boolean ignoreParameter(TypedElement parameter) {
        AnnotationValue schemaAnn = parameter.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
        return isHidden || parameter.isAnnotationPresent(Hidden.class) || parameter.isAnnotationPresent(JsonIgnore.class) || parameter.booleanValue(Parameter.class, "hidden").orElse(false) != false || AbstractOpenApiEndpointVisitor.isAnnotationPresent((Element)parameter, "io.micronaut.session.annotation.SessionValue") || this.isIgnoredParameterType(parameter.getType());
    }

    private boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.session.Session") || parameterType.isAssignable("io.micronaut.security.authentication.Authentication") || parameterType.isAssignable("io.micronaut.http.HttpHeaders") || parameterType.isAssignable("kotlin.coroutines.Continuation") || parameterType.isAssignable(HttpRequest.class) || parameterType.isAssignable("io.micronaut.http.BasicAuth");
    }

    private boolean isResponseType(ClassElement returnType) {
        return returnType.isAssignable(HttpResponse.class) || returnType.isAssignable("org.springframework.http.HttpEntity");
    }

    private boolean isSingleResponseType(ClassElement returnType) {
        return (returnType.isAssignable("io.reactivex.Single") || returnType.isAssignable("io.reactivex.rxjava3.core.Single") || returnType.isAssignable("org.reactivestreams.Publisher")) && returnType.getFirstTypeArgument().isPresent() && this.isResponseType((ClassElement)returnType.getFirstTypeArgument().get());
    }

    private void readApiResponses(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        List methodResponseAnnotations = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        this.processResponses(swaggerOperation, methodResponseAnnotations, element, context);
        List classResponseAnnotations = element.getDeclaringType().getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        this.processResponses(swaggerOperation, classResponseAnnotations, element, context);
    }

    private void processResponses(io.swagger.v3.oas.models.Operation operation, List<AnnotationValue<io.swagger.v3.oas.annotations.responses.ApiResponse>> responseAnnotations, MethodElement element, VisitorContext context) {
        ApiResponses apiResponses = operation.getResponses();
        if (apiResponses == null) {
            apiResponses = new ApiResponses();
            operation.setResponses(apiResponses);
        }
        if (CollectionUtils.isNotEmpty(responseAnnotations)) {
            for (AnnotationValue<io.swagger.v3.oas.annotations.responses.ApiResponse> response : responseAnnotations) {
                Optional<ApiResponse> newResponse;
                String responseCode = response.stringValue("responseCode").orElse("default");
                if (apiResponses.containsKey((Object)responseCode) || !(newResponse = this.toValue(response.getValues(), context, ApiResponse.class)).isPresent()) continue;
                ApiResponse newApiResponse = newResponse.get();
                if (response.booleanValue("useReturnTypeSchema").orElse(false).booleanValue() && element != null) {
                    this.addResponseContent(element, context, Utils.resolveOpenApi(context), newApiResponse);
                } else {
                    Content newContent;
                    List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
                    Object[] contentAnns = response.get((CharSequence)"content", io.swagger.v3.oas.annotations.media.Content[].class).orElse(null);
                    ArrayList<String> mediaTypes = new ArrayList<String>();
                    if (ArrayUtils.isNotEmpty((Object[])contentAnns)) {
                        for (Object contentAnn : contentAnns) {
                            if (StringUtils.isNotEmpty((CharSequence)contentAnn.mediaType())) {
                                mediaTypes.add(contentAnn.mediaType());
                                continue;
                            }
                            mediaTypes.add("application/json");
                        }
                    }
                    if ((newContent = newApiResponse.getContent()) != null) {
                        MediaType defaultMediaType = (MediaType)newContent.get((Object)"application/json");
                        Content contentFromProduces = new Content();
                        for (String mt : mediaTypes) {
                            if (mt.equals("application/json")) {
                                for (io.micronaut.http.MediaType mediaType : producesMediaTypes) {
                                    contentFromProduces.put((Object)mediaType.toString(), (Object)defaultMediaType);
                                }
                                continue;
                            }
                            contentFromProduces.put((Object)mt, (Object)((MediaType)newContent.get((Object)mt)));
                        }
                        newApiResponse.setContent(contentFromProduces);
                    }
                }
                try {
                    if (StringUtils.isEmpty((CharSequence)newApiResponse.getDescription())) {
                        newApiResponse.setDescription(responseCode.equals("default") ? "OK response" : HttpStatus.getDefaultReason((int)Integer.parseInt(responseCode)));
                    }
                }
                catch (Exception e) {
                    newApiResponse.setDescription("Response " + responseCode);
                }
                apiResponses.put((Object)responseCode, (Object)newApiResponse);
            }
            operation.setResponses(apiResponses);
        }
    }

    private Pair<RequestBody, Boolean> readSwaggerRequestBody(Element element, List<io.micronaut.http.MediaType> consumesMediaTypes, VisitorContext context) {
        AnnotationValue swaggerSchema;
        AnnotationValue requestBodyAnnValue = element.findAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class).orElse(null);
        if (requestBodyAnnValue == null) {
            return null;
        }
        boolean hasSchemaImplementation = false;
        AnnotationValue content = requestBodyAnnValue.getAnnotation("content", io.swagger.v3.oas.annotations.media.Content.class).orElse(null);
        if (content != null && (swaggerSchema = (AnnotationValue)content.getAnnotation("schema", io.swagger.v3.oas.annotations.media.Schema.class).orElse(null)) != null) {
            hasSchemaImplementation = swaggerSchema.stringValue("implementation").orElse(null) != null;
        }
        RequestBody requestBody = this.toValue(requestBodyAnnValue.getValues(), context, RequestBody.class).orElse(null);
        if (content != null && content.stringValue("mediaType").isEmpty() && requestBody != null && requestBody.getContent() != null && !consumesMediaTypes.equals(Utils.DEFAULT_MEDIA_TYPES)) {
            MediaType defaultSwaggerMediaType = (MediaType)requestBody.getContent().remove((Object)"application/json");
            for (io.micronaut.http.MediaType mediaType : consumesMediaTypes) {
                requestBody.getContent().put((Object)mediaType.toString(), (Object)defaultSwaggerMediaType);
            }
        }
        return Pair.of(requestBody, hasSchemaImplementation);
    }

    private void readServers(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        for (Server server : this.methodServers(element, context)) {
            swaggerOperation.addServersItem(server);
        }
    }

    private void readCallbacks(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        AnnotationValue callbacksAnnotation = element.getAnnotation(Callbacks.class);
        List callbackAnnotations = callbacksAnnotation != null ? callbacksAnnotation.getAnnotations("value") : element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.callbacks.Callback.class);
        if (CollectionUtils.isEmpty((Collection)callbackAnnotations)) {
            return;
        }
        for (AnnotationValue callbackAnn : callbackAnnotations) {
            Optional name = callbackAnn.stringValue("name");
            if (name.isEmpty()) continue;
            String callbackName = (String)name.get();
            Optional ref = callbackAnn.stringValue("ref");
            if (ref.isPresent()) {
                String refCallback = ((String)ref.get()).substring("#/components/callbacks/".length());
                this.processCallbackReference(context, swaggerOperation, callbackName, refCallback);
                continue;
            }
            Optional expr = callbackAnn.stringValue("callbackUrlExpression");
            if (expr.isPresent()) {
                this.processUrlCallbackExpression(context, swaggerOperation, (AnnotationValue<io.swagger.v3.oas.annotations.callbacks.Callback>)callbackAnn, callbackName, (String)expr.get());
                continue;
            }
            this.processCallbackReference(context, swaggerOperation, callbackName, null);
        }
    }

    private void processCallbackReference(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, String callbackName, String refCallback) {
        Components components = Utils.resolveComponents(Utils.resolveOpenApi(context));
        Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
        Callback callbackRef = new Callback();
        callbackRef.set$ref((String)(refCallback != null ? refCallback : "#/components/callbacks/" + callbackName));
        callbacks.put(callbackName, callbackRef);
    }

    private void processUrlCallbackExpression(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, AnnotationValue<io.swagger.v3.oas.annotations.callbacks.Callback> callbackAnn, String callbackName, String callbackUrl) {
        List operations = callbackAnn.getAnnotations("operation", Operation.class);
        if (CollectionUtils.isEmpty((Collection)operations)) {
            Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
            Callback c = new Callback();
            c.addPathItem(callbackUrl, new PathItem());
            callbacks.put(callbackName, c);
        } else {
            PathItem pathItem = new PathItem();
            for (AnnotationValue operation : operations) {
                Optional operationMethod = operation.get((CharSequence)"method", HttpMethod.class);
                operationMethod.ifPresent(httpMethod -> this.toValue(operation.getValues(), context, io.swagger.v3.oas.models.Operation.class).ifPresent(op -> SchemaUtils.setOperationOnPathItem(pathItem, httpMethod, op)));
            }
            Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
            Callback c = new Callback();
            c.addPathItem(callbackUrl, pathItem);
            callbacks.put(callbackName, c);
        }
    }

    private Map<String, Callback> initCallbacks(io.swagger.v3.oas.models.Operation swaggerOperation) {
        LinkedHashMap callbacks = swaggerOperation.getCallbacks();
        if (callbacks == null) {
            callbacks = new LinkedHashMap();
            swaggerOperation.setCallbacks(callbacks);
        }
        return callbacks;
    }

    private void addTagIfNotPresent(String tag, io.swagger.v3.oas.models.Operation swaggerOperation) {
        List tags = swaggerOperation.getTags();
        if (tags == null || !tags.contains(tag)) {
            swaggerOperation.addTagsItem(tag);
        }
    }

    private void processMicronautVersionAndGroup(io.swagger.v3.oas.models.Operation swaggerOperation, String url, HttpMethod httpMethod, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.micronaut.http.MediaType> producesMediaTypes, MethodElement methodEl, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap;
        String methodKey = httpMethod.name() + "#" + url + "#" + CollectionUtils.toString(CollectionUtils.isEmpty(consumesMediaTypes) ? Utils.DEFAULT_MEDIA_TYPES : consumesMediaTypes) + "#" + CollectionUtils.toString(CollectionUtils.isEmpty(producesMediaTypes) ? Utils.DEFAULT_MEDIA_TYPES : producesMediaTypes);
        Map<String, GroupProperties> groupPropertiesMap = OpenApiApplicationVisitor.getGroupsPropertiesMap(context);
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> excludedGroups = new ArrayList<String>();
        ClassElement classEl = methodEl.getDeclaringType();
        PackageElement packageEl = classEl.getPackage();
        String packageName = packageEl.getName();
        this.processGroups(groups, excludedGroups, methodEl.getAnnotationValuesByType(OpenAPIGroup.class), groupPropertiesMap);
        this.processGroups(groups, excludedGroups, packageEl.getAnnotationValuesByType(OpenAPIGroup.class), groupPropertiesMap);
        this.processGroupsFromIncludedEndpoints(groups, excludedGroups, classEl.getName(), groupPropertiesMap);
        for (GroupProperties groupProperties : groupPropertiesMap.values()) {
            if (CollectionUtils.isNotEmpty(groupProperties.getPackages())) {
                for (GroupProperties.PackageProperties groupPackage : groupProperties.getPackages()) {
                    boolean isInclude = groupPackage.isIncludeSubpackages() ? packageName.startsWith(groupPackage.getName()) : packageName.equals(groupPackage.getName());
                    if (!isInclude) continue;
                    groups.add(groupProperties.getName());
                }
            }
            if (!CollectionUtils.isNotEmpty(groupProperties.getPackagesExclude())) continue;
            for (GroupProperties.PackageProperties excludePackage : groupProperties.getPackagesExclude()) {
                boolean isExclude = excludePackage.isIncludeSubpackages() ? packageName.startsWith(excludePackage.getName()) : packageName.equals(excludePackage.getName());
                if (!isExclude) continue;
                excludedGroups.add(groupProperties.getName());
            }
        }
        RouterVersioningProperties versioningProperties = OpenApiApplicationVisitor.getRouterVersioningProperties(context);
        boolean isVersioningEnabled = versioningProperties.isEnabled() && versioningProperties.isRouterVersiningEnabled() && (versioningProperties.isHeaderEnabled() || versioningProperties.isParameterEnabled());
        String version = null;
        if (isVersioningEnabled) {
            List versionsAnnotations = methodEl.getAnnotationValuesByType(Version.class);
            if (CollectionUtils.isNotEmpty((Collection)versionsAnnotations)) {
                version = ((AnnotationValue)versionsAnnotations.get(0)).stringValue().orElse(null);
            }
            if (version != null) {
                Utils.getAllKnownVersions().add(version);
            }
            if (versioningProperties.isParameterEnabled()) {
                this.addVersionParameters(swaggerOperation, versioningProperties.getParameterNames(), false);
            }
            if (versioningProperties.isHeaderEnabled()) {
                this.addVersionParameters(swaggerOperation, versioningProperties.getHeaderNames(), true);
            }
        }
        if ((endpointInfosMap = Utils.getEndpointInfos()) == null) {
            endpointInfosMap = new HashMap<String, List<EndpointInfo>>();
            Utils.setEndpointInfos(endpointInfosMap);
        }
        List endpointInfos = endpointInfosMap.computeIfAbsent(methodKey, k -> new ArrayList());
        endpointInfos.add(new EndpointInfo(url, httpMethod, methodEl, swaggerOperation, version, groups, excludedGroups));
    }

    private void processGroups(List<String> groups, List<String> excludedGroups, List<AnnotationValue<OpenAPIGroup>> annotationValues, Map<String, GroupProperties> groupPropertiesMap) {
        if (CollectionUtils.isEmpty(annotationValues)) {
            return;
        }
        for (AnnotationValue<OpenAPIGroup> annValue : annotationValues) {
            groups.addAll(Arrays.asList(annValue.stringValues("value")));
            excludedGroups.addAll(Arrays.asList(annValue.stringValues("exclude")));
        }
        Set<String> allKnownGroups = Utils.getAllKnownGroups();
        allKnownGroups.addAll(groups);
        allKnownGroups.addAll(excludedGroups);
    }

    private void processGroupsFromIncludedEndpoints(List<String> groups, List<String> excludedGroups, String className, Map<String, GroupProperties> groupPropertiesMap) {
        if (CollectionUtils.isEmpty(Utils.getIncludedClassesGroups()) && CollectionUtils.isEmpty(Utils.getIncludedClassesGroupsExcluded())) {
            return;
        }
        List classGroups = Utils.getIncludedClassesGroups() != null ? Utils.getIncludedClassesGroups().get(className) : Collections.emptyList();
        List classExcludedGroups = Utils.getIncludedClassesGroupsExcluded() != null ? Utils.getIncludedClassesGroupsExcluded().get(className) : Collections.emptyList();
        groups.addAll(classGroups);
        excludedGroups.addAll(classExcludedGroups);
        Set<String> allKnownGroups = Utils.getAllKnownGroups();
        allKnownGroups.addAll(classGroups);
        allKnownGroups.addAll(classExcludedGroups);
    }

    private void addVersionParameters(io.swagger.v3.oas.models.Operation swaggerOperation, List<String> names, boolean isHeader) {
        String in = isHeader ? ParameterIn.HEADER.toString() : ParameterIn.QUERY.toString();
        for (String parameterName : names) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameter.in(in).description("API version").name(parameterName).schema(PrimitiveType.STRING.createProperty());
            swaggerOperation.addParametersItem(parameter);
        }
    }

    private void readTags(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, List<io.swagger.v3.oas.models.tags.Tag> classTags, OpenAPI openAPI) {
        element.getAnnotationValuesByType(Tag.class).forEach(av -> av.stringValue("name").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)swaggerOperation).addTagsItem(arg_0)));
        ArrayList copyTags = openAPI.getTags() != null ? new ArrayList(openAPI.getTags()) : null;
        List<io.swagger.v3.oas.models.tags.Tag> operationTags = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, copyTags);
        ArrayList<io.swagger.v3.oas.models.tags.Tag> complexTags = null;
        if (CollectionUtils.isNotEmpty(operationTags)) {
            complexTags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>();
            for (io.swagger.v3.oas.models.tags.Tag operationTag : operationTags) {
                if (!StringUtils.hasText((CharSequence)operationTag.getDescription()) && !CollectionUtils.isNotEmpty((Map)operationTag.getExtensions()) && operationTag.getExternalDocs() == null) continue;
                complexTags.add(operationTag);
            }
        }
        if (CollectionUtils.isNotEmpty(complexTags)) {
            if (CollectionUtils.isEmpty((Collection)openAPI.getTags())) {
                openAPI.setTags(complexTags);
            } else {
                for (io.swagger.v3.oas.models.tags.Tag complexTag : complexTags) {
                    boolean alreadyExists = false;
                    for (io.swagger.v3.oas.models.tags.Tag apiTag : openAPI.getTags()) {
                        if (!apiTag.getName().equals(complexTag.getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    openAPI.getTags().add(complexTag);
                }
            }
        }
        element.getValues(Tags.class, AnnotationValue.class).forEach((k, v) -> v.stringValue("name").ifPresent(name -> this.addTagIfNotPresent((String)name, swaggerOperation)));
        classTags.forEach(tag -> this.addTagIfNotPresent(tag.getName(), swaggerOperation));
        if (CollectionUtils.isNotEmpty((Collection)swaggerOperation.getTags())) {
            swaggerOperation.getTags().sort(Comparator.naturalOrder());
        }
    }

    private List<io.swagger.v3.oas.models.tags.Tag> readTags(ClassElement element, VisitorContext context) {
        return this.readTags(element.getAnnotationValuesByType(Tag.class), context);
    }

    final List<io.swagger.v3.oas.models.tags.Tag> readTags(List<AnnotationValue<Tag>> annotations, VisitorContext context) {
        return annotations.stream().map(av -> this.toValue(av.getValues(), context, io.swagger.v3.oas.models.tags.Tag.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Content buildContent(Element definingElement, ClassElement type, List<io.micronaut.http.MediaType> mediaTypes, OpenAPI openAPI, VisitorContext context) {
        Content content = new Content();
        mediaTypes.forEach(mediaType -> {
            MediaType mt = new MediaType();
            mt.setSchema(this.resolveSchema(openAPI, definingElement, type, context, Collections.singletonList(mediaType), null, null));
            content.addMediaType(mediaType.toString(), mt);
        });
        return content;
    }
}

