/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiJacksonVisitor
implements TypeElementVisitor<Object, Object> {
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{"com.fasterxml.jackson.annotation.JsonSubTypes", "com.fasterxml.jackson.annotation.JsonTypeInfo"});
    }

    public int getOrder() {
        return -10;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!OpenApiApplicationVisitor.isOpenApiEnabled(context)) {
            return;
        }
        AnnotationValue jsonSubTypesDecAnn = element.getDeclaredAnnotation(JsonSubTypes.class);
        AnnotationValue jsonTypeInfoDecAnn = element.getDeclaredAnnotation(JsonTypeInfo.class);
        AnnotationValue schemaAnn = element.getDeclaredAnnotation(Schema.class);
        if (jsonTypeInfoDecAnn != null && jsonSubTypesDecAnn != null && schemaAnn == null) {
            JsonTypeInfo.Id use = jsonTypeInfoDecAnn.enumValue("use", JsonTypeInfo.Id.class).orElse(null);
            String discriminatorProp = jsonTypeInfoDecAnn.stringValue("property").orElse(null);
            if (use != JsonTypeInfo.Id.NAME || discriminatorProp == null) {
                return;
            }
            ArrayList<AnnotationClassValue> discriminatorClasses = new ArrayList<AnnotationClassValue>();
            ArrayList<AnnotationValue> discriminatorMappings = new ArrayList<AnnotationValue>();
            for (AnnotationValue av : jsonSubTypesDecAnn.getAnnotations("value")) {
                AnnotationClassValue mappingClass = av.annotationClassValue("value").orElse(null);
                String subTypeName = av.stringValue("name").orElse(null);
                if (mappingClass == null || subTypeName == null) continue;
                AnnotationValue discriminatorMapping = AnnotationValue.builder(DiscriminatorMapping.class).member("value", subTypeName).member("schema", new AnnotationClassValue[]{mappingClass}).build();
                discriminatorMappings.add(discriminatorMapping);
                discriminatorClasses.add(mappingClass);
            }
            element.annotate(Schema.class, builder -> {
                builder.member("oneOf", discriminatorClasses.toArray(new AnnotationClassValue[0]));
                builder.member("discriminatorProperty", discriminatorProp);
                builder.member("discriminatorMapping", discriminatorMappings.toArray(new AnnotationValue[0]));
            });
        }
    }
}

