/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import io.micronaut.core.annotation.Internal;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;

@Internal
public class Schema31Serializer
extends JsonSerializer<Schema>
implements ResolvableSerializer {
    private JsonSerializer<Object> defaultSerializer;

    public Schema31Serializer(JsonSerializer<Object> serializer) {
        this.defaultSerializer = serializer;
    }

    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)this.defaultSerializer).resolve(serializerProvider);
        }
    }

    public void serialize(Schema value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.getBooleanSchemaValue() != null) {
            jgen.writeBoolean(value.getBooleanSchemaValue().booleanValue());
            return;
        }
        if (value.getExampleSetFlag() && value.getExample() == null) {
            jgen.writeStartObject();
            this.defaultSerializer.unwrappingSerializer(null).serialize((Object)value, jgen, provider);
            jgen.writeNullField("example");
            jgen.writeEndObject();
        } else {
            this.defaultSerializer.serialize((Object)value, jgen, provider);
        }
    }
}

