/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.ElementUtils;
import io.micronaut.openapi.visitor.NumberUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.VisibilityLevel;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;

@Internal
abstract class AbstractOpenApiVisitor {
    private static final Lock VISITED_ELEMENTS_LOCK = new ReentrantLock();
    private final Map<String, String> schemaNameToClassNameMap = new HashMap<String, String>();
    private final Map<String, Integer> shemaNameSuffixCounterMap = new HashMap<String, Integer>();
    private final List<String> inProgressSchemas = new ArrayList<String>(10);
    private final Map<String, PropertyNamingStrategy> propertyNamingStrategyInstances = new HashMap<String, PropertyNamingStrategy>();

    AbstractOpenApiVisitor() {
    }

    void incrementVisitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            context.put((CharSequence)"io.micronaut.OPENAPI.visited.elements", (Object)(ContextUtils.getVisitedElements(context) + 1));
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    int visitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            int n = ContextUtils.getVisitedElements(context);
            return n;
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        Map<CharSequence, Object> newValues = this.toValueMap(values, context, jsonViewClass);
        return ConvertUtils.getJsonMapper().valueToTree(newValues);
    }

    <T> Optional<T> toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type, @Nullable ClassElement jsonViewClass) {
        JsonNode node = this.toJson(values, context, jsonViewClass);
        try {
            return Optional.ofNullable(ConvertUtils.treeToValue(node, type, context));
        }
        catch (JsonProcessingException e) {
            context.warn("Error converting  [" + node + "]: to " + type + ": " + e.getMessage(), null);
            return Optional.empty();
        }
    }

    List<SecurityRequirement> readSecurityRequirements(Element element) {
        return this.readSecurityRequirements(element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class));
    }

    List<SecurityRequirement> readSecurityRequirements(List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> annotations) {
        return annotations.stream().map(ConvertUtils::mapToSecurityRequirement).collect(Collectors.toList());
    }

    Map<String, List<PathItem>> resolvePathItems(VisitorContext context, List<UriMatchTemplate> matchTemplates) {
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            openAPI.setPaths(paths);
        }
        HashMap<String, List<PathItem>> resultPathItemsMap = new HashMap<String, List<PathItem>>();
        for (UriMatchTemplate matchTemplate : matchTemplates) {
            Object contextPath;
            StringBuilder result = new StringBuilder();
            boolean optionalPathVar = false;
            boolean varProcess = false;
            boolean valueProcess = false;
            boolean isFirstVarChar = true;
            boolean needToSkip = false;
            String pathString = matchTemplate.toPathString();
            for (char c : pathString.toCharArray()) {
                if (varProcess) {
                    if (isFirstVarChar) {
                        isFirstVarChar = false;
                        if (c == '?' || c == '.') {
                            needToSkip = true;
                            result.deleteCharAt(result.length() - 1);
                            continue;
                        }
                        if (c == '+' || c == '0') continue;
                        if (c == '/') {
                            needToSkip = true;
                            result.deleteCharAt(result.length() - 1);
                            continue;
                        }
                    }
                    if (c == ':') {
                        valueProcess = true;
                        continue;
                    }
                    if (c == '}') {
                        varProcess = false;
                        valueProcess = false;
                        if (!needToSkip) {
                            result.append('}');
                        }
                        needToSkip = false;
                        continue;
                    }
                    if (valueProcess || needToSkip) continue;
                }
                if (c == '{') {
                    varProcess = true;
                    isFirstVarChar = true;
                }
                result.append(c);
            }
            Object resultPath = OpenApiApplicationVisitor.replacePlaceholders(result.toString(), context);
            if (!((String)resultPath).startsWith("/") && !((String)resultPath).startsWith("$")) {
                resultPath = "/" + (String)resultPath;
            }
            if (StringUtils.isNotEmpty((CharSequence)(contextPath = ConfigUtils.getConfigProperty("micronaut.server.context-path", context)))) {
                if (!((String)contextPath).startsWith("/") && !((String)contextPath).startsWith("$")) {
                    contextPath = "/" + (String)contextPath;
                }
                if (((String)contextPath).endsWith("/")) {
                    contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
                }
                resultPath = (String)contextPath + (String)resultPath;
            }
            HashMap<Integer, Object> finalPaths = new HashMap<Integer, Object>();
            finalPaths.put(-1, resultPath);
            if (CollectionUtils.isNotEmpty((Collection)matchTemplate.getVariables())) {
                ArrayList<String> optionalVars = new ArrayList<String>();
                for (Object var : matchTemplate.getVariables()) {
                    if (var.isQuery() || !var.isOptional() || var.isExploded()) continue;
                    optionalVars.add(var.getName());
                }
                if (CollectionUtils.isNotEmpty(optionalVars)) {
                    Object var;
                    int i = 0;
                    var = optionalVars.iterator();
                    while (var.hasNext()) {
                        String var2 = (String)var.next();
                        if (finalPaths.isEmpty()) {
                            finalPaths.put(i, (String)resultPath + "/{" + var2 + "}");
                            ++i;
                            continue;
                        }
                        for (Map.Entry entry : finalPaths.entrySet()) {
                            if ((Integer)entry.getKey() + 1 < i) continue;
                            finalPaths.put(i, (String)entry.getValue() + "/{" + var2 + "}");
                        }
                        ++i;
                    }
                }
            }
            for (String finalPath : finalPaths.values()) {
                List resultPathItems = resultPathItemsMap.computeIfAbsent(finalPath, k -> new ArrayList());
                resultPathItems.add((PathItem)paths.computeIfAbsent((Object)finalPath, key -> new PathItem()));
            }
        }
        return resultPathItemsMap;
    }

    private List<String> addOptionalVars(List<String> paths, String var, int level) {
        ArrayList<String> additionalPaths = new ArrayList<String>(paths);
        if (paths.isEmpty()) {
            additionalPaths.add("/{" + var + "}");
        } else {
            for (String path : paths) {
                additionalPaths.add(path + "/{" + var + "}");
            }
        }
        return additionalPaths;
    }

    protected Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                Map<CharSequence, Object> valueMap;
                AnnotationValue av = (AnnotationValue)value;
                if (av.getAnnotationName().equals(io.swagger.v3.oas.annotations.media.ArraySchema.class.getName())) {
                    valueMap = this.resolveArraySchemaAnnotationValues(context, av, jsonViewClass);
                    newValues.put("schema", valueMap);
                    continue;
                }
                valueMap = this.resolveAnnotationValues(context, av, jsonViewClass);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                Optional type = acv.getType();
                type.ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Parameter.StyleEnum[] first = a[0];
                    if (first instanceof AnnotationClassValue) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (first instanceof AnnotationValue) {
                        Map<CharSequence, Object> valueMap;
                        Object ref;
                        Map<CharSequence, Object> map;
                        String name2;
                        AnnotationValue sv;
                        Map<String, String> params;
                        AnnotationValue annValue = (AnnotationValue)first;
                        String annotationName = annValue.getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            HashMap<CharSequence, Object> extensions = new HashMap<CharSequence, Object>();
                            for (Object o : a) {
                                SchemaUtils.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Encoding.class.getName().equals(annotationName)) {
                            Map<String, Object> encodings = this.annotationValueArrayToSubmap(a, "name", context, null);
                            newValues.put(key, encodings);
                            continue;
                        }
                        if (Content.class.getName().equals(annotationName)) {
                            Map<String, Object> mediaTypes = this.annotationValueArrayToSubmap(a, "mediaType", context, jsonViewClass);
                            newValues.put(key, mediaTypes);
                            continue;
                        }
                        if (Link.class.getName().equals(annotationName) || Header.class.getName().equals(annotationName)) {
                            Map<String, Object> linksOrHeaders = this.annotationValueArrayToSubmap(a, "name", context, jsonViewClass);
                            for (Object linkOrHeader : linksOrHeaders.values()) {
                                Map linkOrHeaderMap = (Map)linkOrHeader;
                                if (linkOrHeaderMap.containsKey("ref")) {
                                    linkOrHeaderMap.put("$ref", linkOrHeaderMap.remove("ref"));
                                }
                                if (!linkOrHeaderMap.containsKey("schema")) continue;
                                Map schemaMap = (Map)linkOrHeaderMap.get("schema");
                                if (schemaMap.containsKey("ref")) {
                                    Object ref2 = schemaMap.get("ref");
                                    schemaMap.clear();
                                    schemaMap.put("$ref", ref2);
                                }
                                if (schemaMap.containsKey("defaultValue")) {
                                    schemaMap.put("default", schemaMap.remove("defaultValue"));
                                }
                                if (!schemaMap.containsKey("allowableValues")) continue;
                                schemaMap.put("enum", schemaMap.remove("allowableValues"));
                            }
                            newValues.put(key, linksOrHeaders);
                            continue;
                        }
                        if (LinkParameter.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "expression");
                            newValues.put(key, params);
                            continue;
                        }
                        if (OAuthScope.class.getName().equals(annotationName)) {
                            params = this.toTupleSubMap(a, "name", "description");
                            newValues.put(key, params);
                            continue;
                        }
                        if (ApiResponse.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> responses = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.stringValue("responseCode").orElse("default");
                                map = this.toValueMap(sv.getValues(), context, jsonViewClass);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                try {
                                    if (!map.containsKey("description")) {
                                        map.put("description", name2.equals("default") ? "OK response" : HttpStatus.valueOf((int)Integer.parseInt(name2)).getReason());
                                    }
                                }
                                catch (Exception e) {
                                    map.put("description", "Response " + name2);
                                }
                                responses.put(name2, map);
                            }
                            newValues.put(key, responses);
                            continue;
                        }
                        if (ExampleObject.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> examples = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.stringValue("name").orElse("example");
                                map = this.toValueMap(sv.getValues(), context, null);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                examples.put(name2, map);
                            }
                            newValues.put(key, examples);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList<LinkedHashMap<CharSequence, Object>> servers = new ArrayList<LinkedHashMap<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>(this.toValueMap(sv.getValues(), context, null));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                Optional n = sv.stringValue("name");
                                n.ifPresent(name -> {
                                    Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context, null);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (DiscriminatorMapping.class.getName().equals(annotationName)) {
                            HashMap<String, String> mappings = new HashMap<String, String>();
                            for (Object o : a) {
                                AnnotationValue dv = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, dv, null);
                                mappings.put(valueMap.get("value").toString(), valueMap.get("$ref").toString());
                            }
                            Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                            discriminatorMap.put("mapping", mappings);
                            newValues.put("discriminator", discriminatorMap);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap2 = this.resolveAnnotationValues(context, av, jsonViewClass);
                            newValues.put(key, this.toValueMap(valueMap2, context, jsonViewClass));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                valueMap = this.resolveAnnotationValues(context, av, jsonViewClass);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            if (key.equals("additionalProperties")) {
                if (!Schema.AdditionalPropertiesValue.TRUE.toString().equals(value.toString())) continue;
                newValues.put("additionalProperties", true);
                continue;
            }
            if (key.equals("discriminatorProperty")) {
                Map<String, Object> discriminatorMap = this.getDiscriminatorMap(newValues);
                discriminatorMap.put("propertyName", ConvertUtils.parseJsonString(value).orElse(value));
                newValues.put("discriminator", discriminatorMap);
                continue;
            }
            if (key.equals("style")) {
                Parameter.StyleEnum paramStyle = null;
                try {
                    paramStyle = Parameter.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception first) {
                    // empty catch block
                }
                if (paramStyle == null) {
                    for (Parameter.StyleEnum styleValue : Parameter.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        paramStyle = styleValue;
                        newValues.put(key, styleValue.toString());
                        break;
                    }
                } else {
                    newValues.put(key, paramStyle.toString());
                }
                if (paramStyle != null) continue;
                Encoding.StyleEnum encodingStyle = null;
                try {
                    encodingStyle = Encoding.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (encodingStyle == null) {
                    for (Encoding.StyleEnum styleValue : Encoding.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        encodingStyle = styleValue;
                        break;
                    }
                }
                if (encodingStyle == null) continue;
                newValues.put(key, encodingStyle.toString());
                continue;
            }
            if (key.equals("ref")) {
                newValues.put("$ref", value);
                continue;
            }
            if (key.equals("accessMode")) {
                if (Schema.AccessMode.READ_ONLY.toString().equals(value)) {
                    newValues.put("readOnly", Boolean.TRUE);
                    continue;
                }
                if (!Schema.AccessMode.WRITE_ONLY.toString().equals(value)) continue;
                newValues.put("writeOnly", Boolean.TRUE);
                continue;
            }
            newValues.put(key, ConvertUtils.parseJsonString(value).orElse(value));
        }
        return newValues;
    }

    private Map<String, Object> getDiscriminatorMap(Map<CharSequence, Object> newValues) {
        return newValues.containsKey("discriminator") ? (Map)newValues.get("discriminator") : new HashMap();
    }

    private <T extends Schema<?>> void processAnnotationValue(VisitorContext context, AnnotationValue<?> annotationValue, Map<CharSequence, Object> arraySchemaMap, List<String> filters, Class<T> type, @Nullable ClassElement jsonViewClass) {
        Map<CharSequence, Object> values = annotationValue.getValues().entrySet().stream().filter(entry -> filters == null || !filters.contains((String)entry.getKey())).collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schema = this.toValue(values, context, type, jsonViewClass);
        schema.ifPresent(s -> this.schemaToValueMap(arraySchemaMap, (Schema<?>)s));
    }

    private Map<CharSequence, Object> resolveArraySchemaAnnotationValues(VisitorContext context, AnnotationValue<?> av, @Nullable ClassElement jsonViewClass) {
        HashMap<CharSequence, Object> arraySchemaMap = new HashMap<CharSequence, Object>(10);
        av.get((CharSequence)"arraySchema", AnnotationValue.class).ifPresent(annotationValue -> this.processAnnotationValue(context, (AnnotationValue<?>)annotationValue, (Map<CharSequence, Object>)arraySchemaMap, Arrays.asList("ref", "implementation"), (Class)Schema.class, null));
        av.get((CharSequence)"schema", AnnotationValue.class).ifPresent(annotationValue -> {
            Optional impl = annotationValue.stringValue("implementation");
            Optional type = annotationValue.stringValue("type");
            Optional format = annotationValue.stringValue("format");
            Optional classElement = Optional.empty();
            PrimitiveType primitiveType = null;
            if (impl.isPresent()) {
                classElement = context.getClassElement((String)impl.get());
            } else if (type.isPresent()) {
                primitiveType = PrimitiveType.fromName(format.isPresent() && ((String)format.get()).equals("binary") ? (String)format.get() : (String)type.get());
                classElement = primitiveType == null ? context.getClassElement((String)type.get()) : context.getClassElement(primitiveType.getKeyClass());
            }
            if (classElement.isPresent()) {
                if (primitiveType == null) {
                    ArraySchema schema = SchemaUtils.arraySchema(this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList(), jsonViewClass));
                    this.schemaToValueMap(arraySchemaMap, (Schema<?>)schema);
                } else {
                    Schema items = primitiveType.createProperty();
                    items.setDescription((String)annotationValue.stringValue("description").orElse(null));
                    ArraySchema schema = SchemaUtils.arraySchema(items);
                    this.schemaToValueMap(arraySchemaMap, (Schema<?>)schema);
                }
            } else {
                arraySchemaMap.putAll(this.resolveAnnotationValues(context, (AnnotationValue<?>)annotationValue, jsonViewClass));
            }
        });
        this.processAnnotationValue(context, av, arraySchemaMap, Arrays.asList("schema", "arraySchema"), ArraySchema.class, null);
        return arraySchemaMap;
    }

    private Map<CharSequence, Object> resolveAnnotationValues(VisitorContext context, AnnotationValue<?> av, @Nullable ClassElement jsonViewClass) {
        Map<CharSequence, Object> valueMap = this.toValueMap(av.getValues(), context, jsonViewClass);
        this.bindSchemaIfNeccessary(context, av, valueMap, jsonViewClass);
        String annotationName = av.getAnnotationName();
        if (Parameter.class.getName().equals(annotationName)) {
            Utils.normalizeEnumValues(valueMap, CollectionUtils.mapOf((Object[])new Object[]{"in", ParameterIn.class, "style", ParameterStyle.class}));
        }
        return valueMap;
    }

    private Map<String, String> toTupleSubMap(Object[] a, String entryKey, String entryValue) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            Optional n = sv.stringValue(entryKey);
            Optional expr = sv.stringValue(entryValue);
            if (!n.isPresent() || !expr.isPresent()) continue;
            params.put((String)n.get(), (String)expr.get());
        }
        return params;
    }

    private boolean isTypeNullable(ClassElement type) {
        return type.isAssignable(Optional.class);
    }

    @Nullable
    protected Schema<?> resolveSchema(@Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) {
        return this.resolveSchema(Utils.resolveOpenApi(context), definingElement, type, context, mediaTypes, jsonViewClass, null, null);
    }

    @Nullable
    protected Schema<?> resolveSchema(OpenAPI openAPI, @Nullable Element definingElement, ClassElement type, VisitorContext context, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass, JavadocDescription fieldJavadoc, JavadocDescription classJavadoc) {
        ClassElement componentType;
        AnnotationValue schemaAnnotationValue = null;
        if (definingElement != null) {
            schemaAnnotationValue = definingElement.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (type != null && schemaAnnotationValue == null) {
            schemaAnnotationValue = type.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        boolean isSubstitudedType = false;
        if (schemaAnnotationValue != null) {
            String impl = schemaAnnotationValue.stringValue("implementation").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)impl)) {
                type = context.getClassElement(impl).orElse(type);
                isSubstitudedType = true;
            } else {
                PrimitiveType primitiveType;
                String schemaType = schemaAnnotationValue.stringValue("type").orElse(null);
                if (StringUtils.isNotEmpty((CharSequence)schemaType) && !(type instanceof EnumElement) && (primitiveType = PrimitiveType.fromName(schemaType)) != null && primitiveType != PrimitiveType.OBJECT) {
                    type = context.getClassElement(primitiveType.getKeyClass()).orElse(type);
                    isSubstitudedType = true;
                }
            }
        }
        Boolean isArray = null;
        Boolean isIterable = null;
        ClassElement classElement = componentType = type != null ? (ClassElement)type.getFirstTypeArgument().orElse(null) : null;
        if (type instanceof WildcardElement) {
            WildcardElement wildcardEl = (WildcardElement)type;
            type = CollectionUtils.isNotEmpty((Collection)wildcardEl.getUpperBounds()) ? (ClassElement)wildcardEl.getUpperBounds().get(0) : null;
        } else if (type instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderEl = (GenericPlaceholderElement)type;
            isArray = type.isArray();
            isIterable = type.isIterable();
            type = placeholderEl.getResolved().orElse(CollectionUtils.isNotEmpty((Collection)placeholderEl.getBounds()) ? (ClassElement)placeholderEl.getBounds().get(0) : null);
        }
        Map typeArgs = type != null ? type.getTypeArguments() : null;
        Object schema = null;
        if (type instanceof EnumElement) {
            EnumElement enumEl = (EnumElement)type;
            schema = this.getSchemaDefinition(openAPI, context, (ClassElement)enumEl, typeArgs, definingElement, mediaTypes, jsonViewClass);
            if (isArray != null && isArray.booleanValue()) {
                schema = SchemaUtils.arraySchema(schema);
            }
        } else if (type != null) {
            boolean isPublisher = false;
            boolean isObservable = false;
            boolean isNullable = false;
            if (type.isAssignable("io.micronaut.http.server.multipart.MultipartBody")) {
                isPublisher = true;
                type = type.getInterfaces().stream().filter(i -> i.isAssignable("org.reactivestreams.Publisher")).findFirst().flatMap(ClassElement::getFirstTypeArgument).orElse(null);
            } else if (!type.isAssignable("io.micronaut.http.multipart.StreamingFileUpload") && ElementUtils.isContainerType(type)) {
                isPublisher = (type.isAssignable("org.reactivestreams.Publisher") || type.isAssignable("kotlinx.coroutines.flow.Flow")) && !type.isAssignable("reactor.core.publisher.Mono");
                isObservable = (type.isAssignable("io.reactivex.Observable") || type.isAssignable("io.reactivex.rxjava3.core.Observable")) && !type.isAssignable("reactor.core.publisher.Mono");
                type = componentType;
                if (componentType != null) {
                    typeArgs = componentType.getTypeArguments();
                    componentType = componentType.getFirstTypeArgument().orElse(null);
                }
            } else if (this.isTypeNullable(type)) {
                isNullable = true;
                type = componentType;
                if (componentType != null) {
                    typeArgs = componentType.getTypeArguments();
                    componentType = componentType.getFirstTypeArgument().orElse(null);
                }
            }
            if (type != null) {
                String typeName;
                ClassElement customTypeSchema;
                if (isArray == null) {
                    isArray = type.isArray();
                }
                if (isIterable == null) {
                    isIterable = type.isIterable();
                }
                if ((customTypeSchema = ConfigUtils.getCustomSchema(typeName = type.getName(), typeArgs, context)) != null) {
                    type = customTypeSchema;
                }
                if (ElementUtils.isFileUpload(type)) {
                    isPublisher = isPublisher && !"io.micronaut.http.multipart.PartData".equals(typeName);
                    typeName = PrimitiveType.BINARY.name();
                }
                PrimitiveType primitiveType = PrimitiveType.fromName(typeName);
                if (!isArray.booleanValue() && ClassUtils.isJavaLangType((String)typeName)) {
                    schema = this.getPrimitiveType(typeName);
                } else if (!isArray.booleanValue() && primitiveType != null) {
                    schema = primitiveType.createProperty();
                } else if (type.isAssignable(Map.class.getName())) {
                    schema = new MapSchema();
                    if (CollectionUtils.isEmpty((Map)typeArgs)) {
                        schema.setAdditionalProperties((Object)true);
                    } else {
                        ClassElement valueType = (ClassElement)typeArgs.get("V");
                        if (valueType.getName().equals(Object.class.getName())) {
                            schema.setAdditionalProperties((Object)true);
                        } else {
                            schema.setAdditionalProperties(this.resolveSchema(openAPI, (Element)type, valueType, context, mediaTypes, jsonViewClass, null, classJavadoc));
                        }
                    }
                } else if (isIterable.booleanValue()) {
                    if (isArray.booleanValue()) {
                        schema = this.resolveSchema(openAPI, (Element)type, type.fromArray(), context, mediaTypes, jsonViewClass, null, classJavadoc);
                        if (schema != null) {
                            schema = SchemaUtils.arraySchema(schema);
                        }
                    } else {
                        List fields;
                        schema = componentType != null ? this.resolveSchema(openAPI, (Element)type, componentType, context, mediaTypes, jsonViewClass, null, classJavadoc) : this.getPrimitiveType(Object.class.getName());
                        List list = fields = type.getPackageName().startsWith("java.util") ? Collections.emptyList() : type.getFields();
                        schema = schema != null && fields.isEmpty() ? SchemaUtils.arraySchema(schema) : this.getSchemaDefinition(openAPI, context, type, typeArgs, definingElement, mediaTypes, jsonViewClass);
                    }
                } else {
                    schema = ElementUtils.isReturnTypeFile(type) ? PrimitiveType.FILE.createProperty() : (type.isAssignable(Boolean.class) || type.isAssignable(Boolean.TYPE) ? PrimitiveType.BOOLEAN.createProperty() : (type.isAssignable(Byte.class) || type.isAssignable(Byte.TYPE) ? PrimitiveType.BYTE.createProperty() : (type.isAssignable(UUID.class) ? PrimitiveType.UUID.createProperty() : (type.isAssignable(URL.class) ? PrimitiveType.URL.createProperty() : (type.isAssignable(URI.class) ? PrimitiveType.URI.createProperty() : (type.isAssignable(Character.class) || type.isAssignable(Character.TYPE) ? PrimitiveType.STRING.createProperty() : (type.isAssignable(Integer.class) || type.isAssignable(Integer.TYPE) || type.isAssignable(Short.class) || type.isAssignable(Short.TYPE) ? PrimitiveType.INT.createProperty() : (type.isAssignable(Long.class) || type.isAssignable(Long.TYPE) ? PrimitiveType.LONG.createProperty() : (type.isAssignable(Float.class) || type.isAssignable(Float.TYPE) ? PrimitiveType.FLOAT.createProperty() : (type.isAssignable(Double.class) || type.isAssignable(Double.TYPE) ? PrimitiveType.DOUBLE.createProperty() : (type.isAssignable(BigInteger.class) ? PrimitiveType.INTEGER.createProperty() : (type.isAssignable(BigDecimal.class) ? PrimitiveType.DECIMAL.createProperty() : (type.isAssignable(Date.class) || type.isAssignable(Calendar.class) || type.isAssignable(LocalDateTime.class) || type.isAssignable(ZonedDateTime.class) || type.isAssignable(OffsetDateTime.class) || type.isAssignable(Instant.class) || type.isAssignable(XMLGregorianCalendar.class) ? new StringSchema().format("date-time") : (type.isAssignable(LocalDate.class) ? new StringSchema().format("date") : (type.isAssignable(LocalTime.class) ? new StringSchema().format("partial-time") : (type.isAssignable(Number.class) ? PrimitiveType.NUMBER.createProperty() : (type.getName().equals(Object.class.getName()) ? PrimitiveType.OBJECT.createProperty() : this.getSchemaDefinition(openAPI, context, type, typeArgs, definingElement, mediaTypes, jsonViewClass))))))))))))))))));
                }
            }
            if (schema != null) {
                if (isSubstitudedType) {
                    this.processShemaAnn((Schema<?>)schema, context, definingElement, type, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnnotationValue);
                }
                if (definingElement != null && StringUtils.isEmpty((CharSequence)schema.getDescription())) {
                    String paramJavadoc;
                    if (fieldJavadoc != null) {
                        if (StringUtils.hasText((CharSequence)fieldJavadoc.getMethodDescription())) {
                            schema.setDescription(fieldJavadoc.getMethodDescription());
                        }
                    } else if (classJavadoc != null && StringUtils.hasText((CharSequence)(paramJavadoc = classJavadoc.getParameters().get(definingElement.getName())))) {
                        schema.setDescription(paramJavadoc);
                    }
                }
                boolean isStream = false;
                for (MediaType mediaType : mediaTypes) {
                    if (!MediaType.TEXT_EVENT_STREAM_TYPE.equals((Object)mediaType) && !MediaType.APPLICATION_JSON_STREAM_TYPE.equals((Object)mediaType)) continue;
                    isStream = true;
                    break;
                }
                if (!isStream && (isPublisher || isObservable)) {
                    schema = SchemaUtils.arraySchema(schema);
                } else if (isNullable) {
                    schema.setNullable(Boolean.valueOf(true));
                }
            }
        }
        return schema;
    }

    private void handleUnwrapped(VisitorContext context, Element element, ClassElement elementType, Schema<?> parentSchema, AnnotationValue<JsonUnwrapped> uw) {
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(Utils.resolveOpenApi(context));
        ClassElement customElementType = ConfigUtils.getCustomSchema(elementType.getName(), elementType.getTypeArguments(), context);
        String schemaName = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(this.computeDefaultSchemaName(null, (Element)(customElementType != null ? customElementType : elementType), elementType.getTypeArguments(), context, null));
        Schema wrappedPropertySchema = schemas.get(schemaName);
        Map properties = wrappedPropertySchema.getProperties();
        if (CollectionUtils.isEmpty((Map)properties)) {
            return;
        }
        String prefix = uw.stringValue("prefix").orElse("");
        String suffix = uw.stringValue("suffix").orElse("");
        for (Map.Entry prop : properties.entrySet()) {
            try {
                boolean isRequired;
                Object propertyName = (String)prop.getKey();
                Schema propertySchema = (Schema)prop.getValue();
                boolean bl = isRequired = wrappedPropertySchema.getRequired() != null && wrappedPropertySchema.getRequired().contains(propertyName);
                if (StringUtils.isNotEmpty((CharSequence)suffix) || StringUtils.isNotEmpty((CharSequence)prefix)) {
                    propertyName = prefix + (String)propertyName + suffix;
                    propertySchema = (Schema)ConvertUtils.getJsonMapper().readValue(ConvertUtils.getJsonMapper().writeValueAsString(prop.getValue()), Schema.class);
                    propertySchema.setName((String)propertyName);
                }
                this.addProperty(parentSchema, (String)propertyName, propertySchema, isRequired);
            }
            catch (IOException e) {
                context.warn("Exception cloning property " + e.getMessage(), null);
            }
        }
    }

    protected void processSchemaProperty(VisitorContext context, TypedElement element, ClassElement elementType, @Nullable Element classElement, Schema<?> parentSchema, Schema<?> propertySchema) {
        if (propertySchema == null) {
            return;
        }
        AnnotationValue uw = element.getAnnotation(JsonUnwrapped.class);
        if (uw != null && uw.booleanValue("enabled").orElse(Boolean.TRUE).booleanValue()) {
            this.handleUnwrapped(context, (Element)element, elementType, parentSchema, (AnnotationValue<JsonUnwrapped>)uw);
        } else {
            AnnotationValue schemaAnnotationValue = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
            Optional<Boolean> elementSchemaRequired = Optional.empty();
            boolean isAutoRequiredMode = true;
            boolean isRequiredDefaultValueSet = false;
            if (schemaAnnotationValue != null) {
                elementSchemaRequired = schemaAnnotationValue.get((CharSequence)"required", Argument.of(Boolean.TYPE));
                isRequiredDefaultValueSet = !schemaAnnotationValue.contains("required");
                Schema.RequiredMode requiredMode = schemaAnnotationValue.enumValue("requiredMode", Schema.RequiredMode.class).orElse(null);
                if (requiredMode == Schema.RequiredMode.REQUIRED) {
                    elementSchemaRequired = Optional.of(true);
                    isAutoRequiredMode = false;
                } else if (requiredMode == Schema.RequiredMode.NOT_REQUIRED) {
                    elementSchemaRequired = Optional.of(false);
                    isAutoRequiredMode = false;
                }
            }
            boolean isNotNullable = this.isElementNotNullable((Element)element, classElement);
            boolean isMandatoryInConstructor = this.doesParamExistsMandatoryInConstructor((Element)element, classElement);
            boolean required = elementSchemaRequired.orElse(isNotNullable || isMandatoryInConstructor);
            if (isRequiredDefaultValueSet && isAutoRequiredMode && isNotNullable) {
                required = true;
            }
            propertySchema = this.bindSchemaForElement(context, element, elementType, propertySchema, null);
            String propertyName = this.resolvePropertyName((Element)element, classElement, propertySchema);
            propertySchema.setRequired(null);
            Schema<?> propertySchemaFinal = propertySchema;
            this.addProperty(parentSchema, propertyName, propertySchema, required);
            if (schemaAnnotationValue != null) {
                schemaAnnotationValue.stringValue("defaultValue").ifPresent(value -> {
                    String elType = schemaAnnotationValue.stringValue("type").orElse(null);
                    String elFormat = schemaAnnotationValue.stringValue("format").orElse(null);
                    if (elType == null && elementType != null) {
                        Pair<String, String> typeAndFormat;
                        if (elementType instanceof EnumElement) {
                            EnumElement enumEl = (EnumElement)elementType;
                            typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, null, elFormat);
                        } else {
                            typeAndFormat = ConvertUtils.getTypeAndFormatByClass(elementType.getName(), elementType.isArray());
                        }
                        elType = typeAndFormat.getFirst();
                        if (elFormat == null) {
                            elFormat = typeAndFormat.getSecond();
                        }
                    }
                    ConvertUtils.setDefaultValueObject(propertySchemaFinal, value, (Element)element, elType, elFormat, false, context);
                });
            }
        }
    }

    protected boolean isElementNotNullable(Element element, @Nullable Element classElement) {
        return element.isAnnotationPresent("javax.validation.constraints.NotNull$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotNull$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List") || element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isNonNull() || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    private boolean doesParamExistsMandatoryInConstructor(Element element, @Nullable Element classElement) {
        if (classElement instanceof ClassElement) {
            ClassElement classEl = (ClassElement)classElement;
            return classEl.getPrimaryConstructor().flatMap(methodElement -> Arrays.stream(methodElement.getParameters()).filter(parameterElement -> parameterElement.getName().equals(element.getName())).map(parameterElement -> !parameterElement.isNullable()).findFirst()).orElse(false);
        }
        return false;
    }

    private void addProperty(Schema<?> parentSchema, String name, Schema<?> propertySchema, boolean required) {
        List requiredList;
        parentSchema.addProperty(name, propertySchema);
        if (required && ((requiredList = parentSchema.getRequired()) == null || !requiredList.contains(name))) {
            parentSchema.addRequiredItem(name);
        }
    }

    private String resolvePropertyName(Element element, Element classElement, Schema<?> propertySchema) {
        Optional nameFromSchema;
        String name = Optional.ofNullable(propertySchema.getName()).orElse(element.getName());
        if (element.hasAnnotation(io.swagger.v3.oas.annotations.media.Schema.class) && (nameFromSchema = element.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name")).isPresent()) {
            return (String)nameFromSchema.get();
        }
        if (element.hasAnnotation(JsonProperty.class)) {
            return element.stringValue(JsonProperty.class, "value").orElse(name);
        }
        if (classElement != null && classElement.hasAnnotation(JsonNaming.class)) {
            Optional propertyNamingStrategyClass = classElement.stringValue(JsonNaming.class);
            if (propertyNamingStrategyClass.isEmpty()) {
                return name;
            }
            PropertyNamingStrategy strategy = this.propertyNamingStrategyInstances.computeIfAbsent((String)propertyNamingStrategyClass.get(), clazz -> {
                try {
                    return (PropertyNamingStrategy)Class.forName((String)propertyNamingStrategyClass.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate: " + clazz);
                }
            });
            if (strategy instanceof PropertyNamingStrategies.NamingBase) {
                PropertyNamingStrategies.NamingBase namingBase = (PropertyNamingStrategies.NamingBase)strategy;
                return namingBase.translate(name);
            }
        }
        return name;
    }

    protected Schema<?> bindSchemaForElement(VisitorContext context, TypedElement element, ClassElement elementType, Schema<?> schemaToBind, @Nullable ClassElement jsonViewClass) {
        boolean addSchemaToBind;
        String defaultJacksonValue;
        Boolean isSchemaNullable;
        boolean isNullable;
        String defaultValue;
        Schema topLevelSchema;
        Schema composedSchema;
        AnnotationValue arraySchemaAnn;
        Schema<?> schemaFromAnn;
        AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        Schema originalSchema = schemaToBind;
        if (originalSchema.get$ref() != null && (schemaFromAnn = this.schemaFromAnnotation(context, (Element)element, elementType, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn)) != null) {
            schemaToBind = schemaFromAnn;
        }
        if (originalSchema.get$ref() == null && schemaAnn != null) {
            schemaToBind = this.bindSchemaAnnotationValue(context, (Element)element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn, jsonViewClass);
            Optional schemaName = schemaAnn.stringValue("name");
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
            elementType = schemaAnn.stringValue("implementation").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(elementType);
        }
        if ((arraySchemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.ArraySchema.class)) != null) {
            schemaToBind = this.bindArraySchemaAnnotationValue(context, (Element)element, schemaToBind, (AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema>)arraySchemaAnn, jsonViewClass);
            Optional schemaName = arraySchemaAnn.stringValue("name");
            if (schemaName.isPresent()) {
                schemaToBind.setName((String)schemaName.get());
            }
        }
        this.processJavaxValidationAnnotations((Element)element, elementType, schemaToBind);
        if (originalSchema.get$ref() != null) {
            topLevelSchema = composedSchema = new Schema();
        } else {
            composedSchema = new ComposedSchema();
            topLevelSchema = schemaToBind;
        }
        boolean notOnlyRef = false;
        this.setSchemaDocumentation((Element)element, topLevelSchema);
        if (StringUtils.isNotEmpty((CharSequence)topLevelSchema.getDescription())) {
            notOnlyRef = true;
        }
        if (element.isAnnotationPresent(Deprecated.class)) {
            topLevelSchema.setDeprecated(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultValue = (String)element.stringValue(Bindable.class, "defaultValue").orElse(null)) != null && schemaToBind.getDefault() == null) {
            ConvertUtils.setDefaultValueObject(schemaToBind, defaultValue, (Element)elementType, schemaToBind.getType(), schemaToBind.getFormat(), true, context);
            notOnlyRef = true;
        }
        boolean bl = isNullable = (isSchemaNullable = (Boolean)element.booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "nullable").orElse(null)) == null && ElementUtils.isNullable(element) || Boolean.TRUE.equals(isSchemaNullable);
        if (isNullable) {
            topLevelSchema.setNullable(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultJacksonValue = (String)element.stringValue(JsonProperty.class, "defaultValue").orElse(null)) != null && schemaToBind.getDefault() == null) {
            ConvertUtils.setDefaultValueObject(topLevelSchema, defaultJacksonValue, (Element)elementType, schemaToBind.getType(), schemaToBind.getFormat(), false, context);
            notOnlyRef = true;
        }
        boolean bl2 = addSchemaToBind = !SchemaUtils.isEmptySchema(schemaToBind);
        if (addSchemaToBind) {
            if ("object".equals(originalSchema.getType()) && !(originalSchema instanceof MapSchema)) {
                if (composedSchema.getType() == null) {
                    composedSchema.setType("object");
                }
                originalSchema.setType(null);
            }
            if (!SchemaUtils.isEmptySchema(originalSchema)) {
                composedSchema.addAllOfItem(originalSchema);
            }
        } else if (isNullable && CollectionUtils.isEmpty((Collection)composedSchema.getAllOf())) {
            composedSchema.addAllOfItem(originalSchema);
        }
        if (addSchemaToBind && !schemaToBind.equals(originalSchema)) {
            if ("object".equals(schemaToBind.getType()) && !(originalSchema instanceof MapSchema)) {
                if (composedSchema.getType() == null) {
                    composedSchema.setType("object");
                }
                originalSchema.setType(null);
            }
            composedSchema.addAllOfItem(schemaToBind);
        }
        if (!SchemaUtils.isEmptySchema(composedSchema) && (CollectionUtils.isNotEmpty((Collection)composedSchema.getAllOf()) && composedSchema.getAllOf().size() > 1 || CollectionUtils.isNotEmpty((Collection)composedSchema.getOneOf()) || CollectionUtils.isNotEmpty((Collection)composedSchema.getAnyOf()) || notOnlyRef)) {
            return composedSchema;
        }
        if (CollectionUtils.isNotEmpty((Collection)composedSchema.getAllOf()) && composedSchema.getAllOf().size() == 1) {
            return (Schema)composedSchema.getAllOf().get(0);
        }
        return originalSchema;
    }

    protected void processJavaxValidationAnnotations(Element element, ClassElement elementType, Schema<?> schemaToBind) {
        boolean isIterableOrMap;
        boolean bl = isIterableOrMap = elementType.isIterable() || elementType.isAssignable(Map.class);
        if (isIterableOrMap) {
            if (element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List")) {
                schemaToBind.setMinItems(Integer.valueOf(1));
            }
            element.findAnnotation("javax.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0))));
            element.findAnnotation("jakarta.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0))));
            element.findAnnotation("javax.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0))));
            element.findAnnotation("jakarta.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0))));
        } else {
            if (PrimitiveType.STRING.getCommonName().equals(schemaToBind.getType())) {
                if (element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List")) {
                    schemaToBind.setMinLength(Integer.valueOf(1));
                }
                element.findAnnotation("javax.validation.constraints.Size$List").ifPresent(listAnn -> {
                    for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                        ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                        ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
                    }
                });
                element.findAnnotation("jakarta.validation.constraints.Size$List").ifPresent(listAnn -> {
                    for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                        ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                        ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
                    }
                });
            }
            if (element.isAnnotationPresent("javax.validation.constraints.Negative$List") || element.isAnnotationPresent("jakarta.validation.constraints.Negative$List")) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent("javax.validation.constraints.NegativeOrZero$List") || element.isAnnotationPresent("jakarta.validation.constraints.NegativeOrZero$List")) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent("javax.validation.constraints.Positive$List") || element.isAnnotationPresent("jakarta.validation.constraints.Positive$List")) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            if (element.isAnnotationPresent("javax.validation.constraints.PositiveOrZero$List") || element.isAnnotationPresent("jakarta.validation.constraints.PositiveOrZero$List")) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            element.findAnnotation("javax.validation.constraints.Min$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Min$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.Max$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Max$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.DecimalMin$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.DecimalMin$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.DecimalMax$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.DecimalMax$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.Email$List").ifPresent(listAnn -> {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Email$List").ifPresent(listAnn -> {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.findAnnotation("javax.validation.constraints.Pattern$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.findAnnotation("jakarta.validation.constraints.Pattern$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.getValue("io.micronaut.http.annotation.Part", String.class).ifPresent(arg_0 -> schemaToBind.setName(arg_0));
        }
    }

    Schema<?> schemaFromAnnotation(VisitorContext context, Element element, ClassElement type, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        if (schemaAnn == null) {
            return null;
        }
        Schema schemaToBind = new Schema();
        this.processShemaAnn(schemaToBind, context, element, type, schemaAnn);
        return schemaToBind;
    }

    void processShemaAnn(Schema<?> schemaToBind, VisitorContext context, Element element, ClassElement type, @NonNull AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        Schema.AccessMode schemaAccessMode;
        String accessModeStr;
        Boolean schemaDeprecated;
        String schemaExample;
        String schemaDefaultValue;
        Double schemaMultipleOf;
        Boolean schemaExclusiveMaximum;
        Boolean schemaExclusiveMinimum;
        String schemaMaximum;
        String schemaMinimum;
        Map annValues = schemaAnn.getValues();
        if (annValues.containsKey("description")) {
            schemaToBind.setDescription((String)annValues.get("description"));
        }
        if (annValues.containsKey("type")) {
            schemaToBind.setType((String)annValues.get("type"));
        }
        if (annValues.containsKey("format")) {
            schemaToBind.setFormat((String)annValues.get("format"));
        }
        if (annValues.containsKey("title")) {
            schemaToBind.setTitle((String)annValues.get("title"));
        }
        if (annValues.containsKey("minLength")) {
            schemaToBind.setMinLength((Integer)annValues.get("minLength"));
        }
        if (annValues.containsKey("maxLength")) {
            schemaToBind.setMaxLength((Integer)annValues.get("maxLength"));
        }
        if (annValues.containsKey("minProperties")) {
            schemaToBind.setMinProperties((Integer)annValues.get("minProperties"));
        }
        if (annValues.containsKey("maxProperties")) {
            schemaToBind.setMaxProperties((Integer)annValues.get("maxProperties"));
        }
        if (annValues.containsKey("pattern")) {
            schemaToBind.setPattern((String)annValues.get("pattern"));
        }
        if (NumberUtils.isCreatable(schemaMinimum = (String)annValues.get("minimum"))) {
            schemaToBind.setMinimum(new BigDecimal(schemaMinimum));
        }
        if (NumberUtils.isCreatable(schemaMaximum = (String)annValues.get("maximum"))) {
            schemaToBind.setMaximum(new BigDecimal(schemaMaximum));
        }
        if ((schemaExclusiveMinimum = (Boolean)annValues.get("exclusiveMinimum")) != null && schemaExclusiveMinimum.booleanValue()) {
            schemaToBind.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if ((schemaExclusiveMaximum = (Boolean)annValues.get("exclusiveMaximum")) != null && schemaExclusiveMaximum.booleanValue()) {
            schemaToBind.setExclusiveMaximum(Boolean.valueOf(true));
        }
        if ((schemaMultipleOf = (Double)annValues.get("multipleOf")) != null) {
            schemaToBind.setMultipleOf(BigDecimal.valueOf(schemaMultipleOf));
        }
        AnnotationValue schemaExtDocs = (AnnotationValue)annValues.get("externalDocs");
        ExternalDocumentation externalDocs = null;
        if (schemaExtDocs != null) {
            externalDocs = this.toValue(schemaExtDocs.getValues(), context, ExternalDocumentation.class, null).orElse(null);
        }
        if (externalDocs != null) {
            schemaToBind.setExternalDocs(externalDocs);
        }
        if ((schemaDefaultValue = (String)annValues.get("defaultValue")) != null) {
            ConvertUtils.setDefaultValueObject(schemaToBind, schemaDefaultValue, (Element)type, schemaToBind.getType(), schemaToBind.getFormat(), false, context);
        }
        if (StringUtils.isNotEmpty((CharSequence)(schemaExample = (String)annValues.get("example")))) {
            try {
                schemaToBind.setExample(ConvertUtils.getConvertJsonMapper().readValue(schemaExample, Map.class));
            }
            catch (JsonProcessingException e) {
                schemaToBind.setExample((Object)schemaExample);
            }
        }
        if ((schemaDeprecated = (Boolean)annValues.get("deprecated")) != null && schemaDeprecated.booleanValue()) {
            schemaToBind.setDeprecated(Boolean.valueOf(true));
        }
        if (StringUtils.isNotEmpty((CharSequence)(accessModeStr = (String)annValues.get("accessMode"))) && (schemaAccessMode = Schema.AccessMode.valueOf((String)accessModeStr)) != Schema.AccessMode.AUTO) {
            if (schemaAccessMode == Schema.AccessMode.READ_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(true));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.WRITE_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(false));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.READ_WRITE) {
                schemaToBind.setReadOnly(null);
                schemaToBind.setWriteOnly(null);
            }
        }
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        Components components = Utils.resolveComponents(openAPI);
        this.processClassValues(schemaToBind, annValues, Collections.emptyList(), context, null);
        String addProps = (String)annValues.get("additionalProperties");
        if (StringUtils.isNotEmpty((CharSequence)addProps)) {
            Schema.AdditionalPropertiesValue schemaAdditionalProperties = Schema.AdditionalPropertiesValue.valueOf((String)addProps);
            if (schemaAdditionalProperties == Schema.AdditionalPropertiesValue.TRUE) {
                schemaToBind.additionalProperties((Object)true);
            } else if (schemaAdditionalProperties == Schema.AdditionalPropertiesValue.FALSE) {
                schemaToBind.additionalProperties((Object)false);
            }
        }
    }

    private void setSchemaDocumentation(Element element, Schema<?> schemaToBind) {
        if (StringUtils.isEmpty((CharSequence)schemaToBind.getDescription())) {
            JavadocDescription desc;
            MemberElement memberEl;
            List fields;
            String doc = element.getDocumentation().orElse(null);
            if (StringUtils.isEmpty((CharSequence)doc) && element instanceof MemberElement && CollectionUtils.isNotEmpty((Collection)(fields = (memberEl = (MemberElement)element).getDeclaringType().getFields()))) {
                for (FieldElement field : fields) {
                    if (!field.getName().equals(element.getName())) continue;
                    doc = field.getDocumentation().orElse(null);
                    break;
                }
            }
            if (doc != null && StringUtils.hasText((CharSequence)(desc = Utils.getJavadocParser().parse(doc)).getMethodDescription())) {
                schemaToBind.setDescription(desc.getMethodDescription());
            }
        }
    }

    protected Schema<?> bindSchemaAnnotationValue(VisitorContext context, Element element, Schema<?> schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn, @Nullable ClassElement jsonViewClass) {
        Pair<String, Object> typeAndFormat;
        ClassElement classElement = ((TypedElement)element).getType();
        if (classElement.isIterable()) {
            typeAndFormat = Pair.of("array", null);
        } else if (classElement instanceof EnumElement) {
            EnumElement enumEl = (EnumElement)classElement;
            typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, null, null);
        } else {
            typeAndFormat = ConvertUtils.getTypeAndFormatByClass(classElement.getName(), classElement.isArray());
        }
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context, jsonViewClass);
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, schemaAnn.stringValue("type").orElse(typeAndFormat.getFirst()), schemaAnn.stringValue("format").orElse((String)typeAndFormat.getSecond()), schemaAnn, jsonViewClass);
    }

    private Schema<?> doBindSchemaAnnotationValue(VisitorContext context, Element element, Schema schemaToBind, JsonNode schemaJson, String elType, String elFormat, AnnotationValue<?> schemaAnn, @Nullable ClassElement jsonViewClass) {
        schemaJson = OpenApiApplicationVisitor.resolvePlaceholders(schemaJson, s -> OpenApiApplicationVisitor.expandProperties(s, ConfigUtils.getExpandableProperties(context), context));
        try {
            schemaToBind = (Schema)ConvertUtils.getJsonMapper().readerForUpdating((Object)schemaToBind).readValue(schemaJson);
        }
        catch (IOException e) {
            context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
        }
        String defaultValue = null;
        String[] allowableValues = null;
        if (schemaAnn != null) {
            defaultValue = schemaAnn.stringValue("defaultValue").orElse(null);
            allowableValues = schemaAnn.get((CharSequence)"allowableValues", String[].class).orElse(null);
            Map annValues = schemaAnn.getValues();
            Map<CharSequence, Object> valueMap = this.toValueMap(annValues, context, jsonViewClass);
            this.bindSchemaIfNeccessary(context, schemaAnn, valueMap, jsonViewClass);
            this.processClassValues(schemaToBind, annValues, Collections.emptyList(), context, jsonViewClass);
        }
        if (elType == null && element != null) {
            Pair<String, String> typeAndFormat;
            ClassElement typeEl = ((TypedElement)element).getType();
            if (typeEl instanceof EnumElement) {
                EnumElement enumEl = (EnumElement)typeEl;
                typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, null, elFormat);
            } else {
                typeAndFormat = ConvertUtils.getTypeAndFormatByClass(typeEl.getName(), typeEl.isArray());
            }
            elType = typeAndFormat.getFirst();
            if (elFormat == null) {
                elFormat = typeAndFormat.getSecond();
            }
        }
        if (StringUtils.isNotEmpty(defaultValue)) {
            ConvertUtils.setDefaultValueObject(schemaToBind, defaultValue, element, elType, elFormat, false, context);
        }
        if (ArrayUtils.isNotEmpty(allowableValues)) {
            for (String allowableValue : allowableValues) {
                if (schemaToBind.getEnum() != null && schemaToBind.getEnum().contains(allowableValue)) continue;
                try {
                    schemaToBind.addEnumItemObject(ConvertUtils.normalizeValue(allowableValue, elType, elFormat, context));
                }
                catch (IOException e) {
                    context.warn("Can't convert " + allowableValue + " to " + elType + ", format: " + elFormat + ": " + e.getMessage(), element);
                    schemaToBind.addEnumItemObject((Object)allowableValue);
                }
            }
        }
        return schemaToBind;
    }

    protected Schema<?> bindArraySchemaAnnotationValue(VisitorContext context, Element element, Schema<?> schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema> schemaAnn, @Nullable ClassElement jsonViewClass) {
        JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context, jsonViewClass);
        if (schemaJson.isObject()) {
            JsonNode items;
            ObjectNode objNode = (ObjectNode)schemaJson;
            JsonNode arraySchema = objNode.remove("arraySchema");
            if (arraySchema != null && arraySchema.isObject()) {
                ((ObjectNode)arraySchema).remove("implementation");
                objNode.setAll((ObjectNode)arraySchema);
            }
            if ((items = objNode.remove("schema")) != null && schemaToBind != null && schemaToBind.getType().equals("array") && schemaToBind.getItems() != null && schemaToBind.getItems().get$ref() == null) {
                try {
                    schemaToBind.items((Schema)ConvertUtils.getJsonMapper().readerForUpdating((Object)schemaToBind.getItems()).readValue(items));
                }
                catch (IOException e) {
                    context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
                }
            }
        }
        String elType = schemaJson.has("type") ? schemaJson.get("type").textValue() : null;
        String elFormat = schemaJson.has("format") ? schemaJson.get("format").textValue() : null;
        return this.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, elType, elFormat, null, jsonViewClass);
    }

    private Map<String, Object> annotationValueArrayToSubmap(Object[] a, String classifier, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        LinkedHashMap<String, Object> mediaTypes = new LinkedHashMap<String, Object>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            String name = sv.stringValue(classifier).orElse(null);
            if (name == null && classifier.equals("mediaType")) {
                name = "application/json";
            }
            if (name == null) continue;
            Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context, jsonViewClass);
            mediaTypes.put(name, map);
        }
        return mediaTypes;
    }

    private void schemaToValueMap(Map<CharSequence, Object> valueMap, Schema<?> schema) {
        if (schema != null) {
            BeanMap beanMap = BeanMap.of(schema);
            for (Map.Entry e : beanMap.entrySet()) {
                Object v = e.getValue();
                if (v == null) continue;
                valueMap.put((CharSequence)e.getKey(), v);
            }
            if (schema.get$ref() != null) {
                valueMap.put("$ref", schema.get$ref());
            }
        }
    }

    private void bindSchemaIfNeccessary(VisitorContext context, AnnotationValue<?> av, Map<CharSequence, Object> valueMap, @Nullable ClassElement jsonViewClass) {
        String className;
        boolean isSchema;
        Optional impl = av.stringValue("implementation");
        Optional not = av.stringValue("not");
        Optional schema = av.stringValue("schema");
        Optional anyOf = av.get((CharSequence)"anyOf", Argument.of(String[].class));
        Optional oneOf = av.get((CharSequence)"oneOf", Argument.of(String[].class));
        Optional allOf = av.get((CharSequence)"allOf", Argument.of(String[].class));
        Object o = valueMap.remove("defaultValue");
        if (o != null) {
            valueMap.put("default", o);
        }
        if ((o = valueMap.remove("allowableValues")) != null) {
            valueMap.put("enum", o);
        }
        if (isSchema = io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(av.getAnnotationName())) {
            if (impl.isPresent()) {
                className = (String)impl.get();
                this.bindSchemaForClassName(context, valueMap, className, jsonViewClass);
            }
            if (not.isPresent()) {
                Schema<?> schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement((String)not.get()).get(), context, Collections.emptyList(), jsonViewClass);
                HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
                this.schemaToValueMap(schemaMap, schemaNot);
                valueMap.put("not", schemaMap);
            }
            anyOf.ifPresent(anyOfList -> this.bindSchemaForComposite(context, valueMap, (String[])anyOfList, "anyOf", jsonViewClass));
            oneOf.ifPresent(oneOfList -> this.bindSchemaForComposite(context, valueMap, (String[])oneOfList, "oneOf", jsonViewClass));
            allOf.ifPresent(allOfList -> this.bindSchemaForComposite(context, valueMap, (String[])allOfList, "allOf", jsonViewClass));
        }
        if (DiscriminatorMapping.class.getName().equals(av.getAnnotationName()) && schema.isPresent()) {
            className = (String)schema.get();
            this.bindSchemaForClassName(context, valueMap, className, jsonViewClass);
        }
    }

    private void bindSchemaForComposite(VisitorContext context, Map<CharSequence, Object> valueMap, String[] classNames, String key, @Nullable ClassElement jsonViewClass) {
        List namesToSchemas = Arrays.stream(classNames).map(className -> {
            Optional classElement = context.getClassElement(className);
            HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
            if (classElement.isPresent()) {
                Schema<?> schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList(), jsonViewClass);
                this.schemaToValueMap(schemaMap, schema);
            }
            return schemaMap;
        }).collect(Collectors.toList());
        valueMap.put(key, namesToSchemas);
    }

    private void bindSchemaForClassName(VisitorContext context, Map<CharSequence, Object> valueMap, String className, @Nullable ClassElement jsonViewClass) {
        Optional classElement = context.getClassElement(className);
        if (classElement.isPresent()) {
            Schema<?> schema = this.resolveSchema(null, (ClassElement)classElement.get(), context, Collections.emptyList(), jsonViewClass);
            this.schemaToValueMap(valueMap, schema);
        }
    }

    private void checkAllOf(Schema<Object> composedSchema) {
        if (composedSchema == null || CollectionUtils.isEmpty((Collection)composedSchema.getAllOf()) || CollectionUtils.isEmpty((Map)composedSchema.getProperties())) {
            return;
        }
        if (composedSchema.getType() == null) {
            composedSchema.setType("object");
        }
        Schema propSchema = new Schema();
        propSchema.properties(composedSchema.getProperties());
        propSchema.setDescription(composedSchema.getDescription());
        propSchema.setRequired(composedSchema.getRequired());
        propSchema.setType(null);
        composedSchema.setProperties(null);
        composedSchema.setDescription(null);
        composedSchema.setRequired(null);
        composedSchema.addAllOfItem(propSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema<?> getSchemaDefinition(OpenAPI openAPI, VisitorContext context, ClassElement type, Map<String, ClassElement> typeArgs, @Nullable Element definingElement, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) {
        ClassElement classEl;
        Schema schema;
        AnnotationValue schemaValue = null;
        if (definingElement != null) {
            if (definingElement instanceof PropertyElement) {
                Optional setterOpt;
                PropertyElement propertyEl = (PropertyElement)definingElement;
                Optional getterOpt = propertyEl.getReadMethod();
                if (getterOpt.isPresent()) {
                    schemaValue = ((MethodElement)getterOpt.get()).getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                }
                if (schemaValue == null && (setterOpt = propertyEl.getWriteMethod()).isPresent()) {
                    schemaValue = ((MethodElement)setterOpt.get()).getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                }
            } else {
                schemaValue = definingElement.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
            }
        }
        if (schemaValue == null) {
            schemaValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(openAPI);
        if (schemaValue == null) {
            boolean isBasicType = ClassUtils.isJavaBasicType((String)type.getName());
            PrimitiveType primitiveType = isBasicType ? (PrimitiveType)ClassUtils.forName((String)type.getName(), (ClassLoader)this.getClass().getClassLoader()).map(PrimitiveType::fromType).orElse(null) : null;
            if (primitiveType != null) return primitiveType.createProperty();
            String schemaName = this.computeDefaultSchemaName(definingElement, (Element)type, typeArgs, context, jsonViewClass);
            schema = schemas.get(schemaName);
            JavadocDescription javadoc = Utils.getJavadocParser().parse(type.getDocumentation().orElse(null));
            if (schema == null) {
                if (type instanceof EnumElement) {
                    EnumElement enumEl = (EnumElement)type;
                    schema = new Schema();
                    schema.setName(schemaName);
                    if (javadoc != null && StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    schemas.put(schemaName, schema);
                    Pair<String, String> typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, schema.getType(), schema.getFormat());
                    schema.setType(typeAndFormat.getFirst());
                    schema.setFormat(typeAndFormat.getSecond());
                    if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                        schema.setEnum(this.getEnumValues(enumEl, schema.getType(), schema.getFormat(), context));
                    }
                } else {
                    Schema schemaWithSuperTypes = this.processSuperTypes(null, schemaName, type, definingElement, openAPI, mediaTypes, schemas, context, jsonViewClass);
                    if (schemaWithSuperTypes != null) {
                        schema = schemaWithSuperTypes;
                    }
                    if (schema != null && javadoc != null && StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    this.populateSchemaProperties(openAPI, context, (Element)type, typeArgs, schema, mediaTypes, javadoc, jsonViewClass);
                    this.checkAllOf(schema);
                }
            }
        } else {
            String schemaName = schemaValue.stringValue("name").orElse(this.computeDefaultSchemaName(definingElement, (Element)type, typeArgs, context, jsonViewClass));
            schema = schemas.get(schemaName);
            if (schema == null) {
                if (this.inProgressSchemas.contains(schemaName)) {
                    return new Schema().$ref(SchemaUtils.schemaRef(schemaName));
                }
                this.inProgressSchemas.add(schemaName);
                try {
                    Schema<?> originalTypeSchema;
                    schema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaValue, openAPI, context, (Element)type, typeArgs, mediaTypes, jsonViewClass);
                    AnnotationValue typeSchema = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                    if (typeSchema != null && (originalTypeSchema = this.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)typeSchema, openAPI, context, (Element)type, typeArgs, mediaTypes, jsonViewClass)) != null && schema != null) {
                        if (StringUtils.isNotEmpty((CharSequence)originalTypeSchema.getDescription())) {
                            schema.setDescription(originalTypeSchema.getDescription());
                        }
                        schema.setNullable(originalTypeSchema.getNullable());
                        schema.setRequired(originalTypeSchema.getRequired());
                    }
                    if (schema != null) {
                        this.processSuperTypes(schema, schemaName, type, definingElement, openAPI, mediaTypes, schemas, context, jsonViewClass);
                    }
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading Swagger Parameter for element [" + type + "]: " + e.getMessage(), (Element)type);
                }
                finally {
                    this.inProgressSchemas.remove(schemaName);
                }
            }
        }
        if (schema == null) return null;
        AnnotationValue externalDocsValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        ExternalDocumentation externalDocs = null;
        if (externalDocsValue != null) {
            externalDocs = this.toValue(externalDocsValue.getValues(), context, ExternalDocumentation.class, null).orElse(null);
        }
        if (externalDocs != null) {
            schema.setExternalDocs(externalDocs);
        }
        this.setSchemaDocumentation((Element)type, schema);
        Schema schemaRef = new Schema();
        schemaRef.set$ref(SchemaUtils.schemaRef(schema.getName()));
        if (!(definingElement instanceof ClassElement) || !(classEl = (ClassElement)definingElement).isIterable()) return schemaRef;
        schemaRef.setDescription(schema.getDescription());
        return schemaRef;
    }

    private Schema<?> processSuperTypes(Schema<?> schema, String schemaName, ClassElement type, @Nullable Element definingElement, OpenAPI openAPI, List<MediaType> mediaTypes, Map<String, Schema> schemas, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        if (type.getName().equals(Object.class.getName())) {
            return null;
        }
        ClassElement classElement = type.getType();
        ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
        Collection parentInterfaces = classElement.getInterfaces();
        if (classElement.isInterface() && !parentInterfaces.isEmpty()) {
            for (ClassElement parentInterface : parentInterfaces) {
                if (ClassUtils.isJavaLangType((String)parentInterface.getName()) || parentInterface.getBeanProperties().isEmpty()) continue;
                superTypes.add(parentInterface);
            }
        } else {
            classElement.getSuperType().ifPresent(superTypes::add);
        }
        if (!type.isRecord() && !superTypes.isEmpty()) {
            String firstSuperTypeName = ((ClassElement)superTypes.get(0)).getName();
            if (superTypes.size() == 1 && (firstSuperTypeName.equals(Enum.class.getName()) || firstSuperTypeName.equals(Object.class.getName()))) {
                schema.setName(schemaName);
                schemas.put(schemaName, schema);
                return null;
            }
            if (schema == null) {
                schema = new ComposedSchema();
                schema.setType("object");
            }
            for (ClassElement sType : superTypes) {
                Map sTypeArgs = sType.getTypeArguments();
                ClassElement customStype = ConfigUtils.getCustomSchema(sType.getName(), sTypeArgs, context);
                if (customStype != null) {
                    sType = customStype;
                }
                this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, sType, schemas, sTypeArgs, jsonViewClass);
            }
        } else if (schema == null) {
            schema = new Schema();
            schema.setType("object");
        }
        schema.setName(schemaName);
        schemas.put(schemaName, schema);
        return schema;
    }

    private void readAllInterfaces(OpenAPI openAPI, VisitorContext context, @Nullable Element definingElement, List<MediaType> mediaTypes, Schema<?> schema, ClassElement superType, Map<String, Schema> schemas, Map<String, ClassElement> superTypeArgs, @Nullable ClassElement jsonViewClass) {
        String parentSchemaName = superType.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(this.computeDefaultSchemaName(definingElement, (Element)superType, superTypeArgs, context, jsonViewClass));
        if (schemas.get(parentSchemaName) != null || this.getSchemaDefinition(openAPI, context, superType, superTypeArgs, null, mediaTypes, jsonViewClass) != null) {
            Schema parentSchema = new Schema();
            parentSchema.set$ref(SchemaUtils.schemaRef(parentSchemaName));
            if (schema.getAllOf() == null || !schema.getAllOf().contains(parentSchema)) {
                schema.addAllOfItem(parentSchema);
            }
        }
        if (superType.isInterface()) {
            for (ClassElement interfaceElement : superType.getInterfaces()) {
                if (ClassUtils.isJavaLangType((String)interfaceElement.getName()) || interfaceElement.getBeanProperties().isEmpty()) continue;
                Map interfaceTypeArgs = interfaceElement.getTypeArguments();
                ClassElement customInterfaceType = ConfigUtils.getCustomSchema(interfaceElement.getName(), interfaceTypeArgs, context);
                if (customInterfaceType != null) {
                    interfaceElement = customInterfaceType;
                }
                this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, interfaceElement, schemas, interfaceTypeArgs, jsonViewClass);
            }
        } else if (superType.getSuperType().isPresent()) {
            ClassElement superSuperType = (ClassElement)superType.getSuperType().get();
            Map superSuperTypeArgs = superSuperType.getTypeArguments();
            ClassElement customSuperSuperType = ConfigUtils.getCustomSchema(superSuperType.getName(), superSuperTypeArgs, context);
            if (customSuperSuperType != null) {
                superSuperType = customSuperSuperType;
            }
            this.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, superSuperType, schemas, superSuperTypeArgs, jsonViewClass);
        }
    }

    private void processClassValues(Schema<?> schemaToBind, Map<CharSequence, Object> annValues, List<MediaType> mediaTypes, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        Object[] oneOf;
        Object[] anyOf;
        Object[] allOf;
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        AnnotationClassValue not = (AnnotationClassValue)annValues.get("not");
        if (not != null) {
            Schema<?> schemaNot = this.resolveSchema(null, (ClassElement)context.getClassElement(not.getName()).get(), context, Collections.emptyList(), jsonViewClass);
            schemaToBind.setNot(schemaNot);
        }
        if (ArrayUtils.isNotEmpty((Object[])(allOf = (AnnotationClassValue[])annValues.get("allOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])allOf, mediaTypes, jsonViewClass);
            for (Schema<?> schema : schemaList) {
                if ("object".equals(schema.getType())) {
                    if (schemaToBind.getType() == null) {
                        schemaToBind.setType("object");
                    }
                    schema.setType(null);
                }
                if (schemaToBind.getAllOf() != null && schemaToBind.getAllOf().contains(schema)) continue;
                schemaToBind.addAllOfItem(schema);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(anyOf = (AnnotationClassValue[])annValues.get("anyOf")))) {
            List<Schema<?>> schemaList = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])anyOf, mediaTypes, jsonViewClass);
            for (Schema<?> schema : schemaList) {
                if ("object".equals(schema.getType())) {
                    if (schemaToBind.getType() == null) {
                        schemaToBind.setType("object");
                    }
                    schema.setType(null);
                }
                if (schemaToBind.getAnyOf() != null && schemaToBind.getAnyOf().contains(schema)) continue;
                schemaToBind.addAnyOfItem(schema);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(oneOf = (AnnotationClassValue[])annValues.get("oneOf")))) {
            List<Schema<?>> list = this.namesToSchemas(openAPI, context, (AnnotationClassValue<?>[])oneOf, mediaTypes, jsonViewClass);
            for (Schema<?> s : list) {
                if ("object".equals(s.getType())) {
                    if (schemaToBind.getType() == null) {
                        schemaToBind.setType("object");
                    }
                    s.setType(null);
                }
                if (schemaToBind.getOneOf() != null && schemaToBind.getOneOf().contains(s)) continue;
                schemaToBind.addOneOfItem(s);
            }
        }
    }

    protected Schema<?> readSchema(AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaValue, OpenAPI openAPI, VisitorContext context, @Nullable Element type, Map<String, ClassElement> typeArgs, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) throws JsonProcessingException {
        Object[] allowableValues;
        Map<CharSequence, Object> values = schemaValue.getValues().entrySet().stream().collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        Optional<Schema> schemaOpt = this.toValue(values, context, Schema.class, jsonViewClass);
        if (schemaOpt.isEmpty()) {
            return null;
        }
        Schema schema = schemaOpt.get();
        String elType = (String)values.get("type");
        String elFormat = (String)values.get("format");
        if (elType == null && type instanceof TypedElement) {
            Object typeAndFormat;
            TypedElement typedType = (TypedElement)type;
            if (typedType instanceof EnumElement) {
                EnumElement enumEl = (EnumElement)typedType;
                typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, null, elFormat);
            } else {
                typeAndFormat = ConvertUtils.getTypeAndFormatByClass(typedType.getName(), typedType.isArray());
            }
            elType = (String)((Pair)typeAndFormat).getFirst();
            if (elFormat == null) {
                elFormat = (String)((Pair)typeAndFormat).getSecond();
            }
        }
        if (values.containsKey("allowableValues") && ArrayUtils.isNotEmpty((Object[])(allowableValues = (String[])values.get("allowableValues")))) {
            for (Object allowableValue : allowableValues) {
                if (schema.getEnum() != null && schema.getEnum().contains(allowableValue)) continue;
                try {
                    schema.addEnumItemObject(ConvertUtils.normalizeValue((String)allowableValue, elType, elFormat, context));
                }
                catch (IOException e2) {
                    context.warn("Can't convert " + (String)allowableValue + " to " + elType + ": " + e2.getMessage(), type);
                    schema.addEnumItemObject(allowableValue);
                }
            }
        }
        String defaultValue = schemaValue.stringValue("defaultValue").orElse(null);
        ConvertUtils.setDefaultValueObject(schema, defaultValue, type, elType, elFormat, false, context);
        this.processClassValues(schema, values, mediaTypes, context, jsonViewClass);
        if (schema.getType() == null) {
            schema.setType(elType);
        }
        if (schema.getFormat() == null) {
            schema.setFormat(elFormat);
        }
        if (type instanceof EnumElement) {
            EnumElement enumEl = (EnumElement)type;
            if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                schema.setEnum(this.getEnumValues(enumEl, schema.getType(), elFormat, context));
            }
        } else {
            JavadocDescription javadoc = Utils.getJavadocParser().parse(type.getDescription());
            this.populateSchemaProperties(openAPI, context, type, typeArgs, schema, mediaTypes, javadoc, jsonViewClass);
            this.checkAllOf((Schema<Object>)schema);
        }
        return schema;
    }

    private List<Object> getEnumValues(EnumElement type, String schemaType, String schemaFormat, VisitorContext context) {
        ArrayList<Object> enumValues = new ArrayList<Object>();
        for (EnumConstantElement element : type.elements()) {
            String jacksonValue;
            AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
            boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
            if (isHidden || element.isAnnotationPresent(Hidden.class) || element.isAnnotationPresent(JsonIgnore.class)) continue;
            AnnotationValue jsonProperty = element.getAnnotation(JsonProperty.class);
            String string = jacksonValue = jsonProperty != null ? (String)jsonProperty.stringValue("value").orElse(null) : null;
            if (StringUtils.hasText(jacksonValue)) {
                try {
                    enumValues.add(ConvertUtils.normalizeValue(jacksonValue, schemaType, schemaFormat, context));
                }
                catch (JsonProcessingException e) {
                    context.warn("Error converting jacksonValue " + jacksonValue + " : to " + type + ": " + e.getMessage(), (Element)element);
                    enumValues.add(element.getSimpleName());
                }
                continue;
            }
            enumValues.add(element.getSimpleName());
        }
        return enumValues;
    }

    private List<Schema<?>> namesToSchemas(OpenAPI openAPI, VisitorContext context, AnnotationClassValue<?>[] names, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) {
        return Arrays.stream(names).flatMap(classAnn -> {
            Optional classElementOpt = context.getClassElement(classAnn.getName());
            if (classElementOpt.isPresent()) {
                Schema<?> schemaDefinition;
                ClassElement classElement = (ClassElement)classElementOpt.get();
                Map classElementTypeArgs = classElement.getTypeArguments();
                ClassElement customClassElement = ConfigUtils.getCustomSchema(classElement.getName(), classElementTypeArgs, context);
                if (customClassElement != null) {
                    classElement = customClassElement;
                }
                if ((schemaDefinition = this.getSchemaDefinition(openAPI, context, classElement, classElementTypeArgs, null, mediaTypes, jsonViewClass)) != null) {
                    return Stream.of(schemaDefinition);
                }
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    /*
     * Unable to fully structure code
     */
    private String computeDefaultSchemaName(Element definingElement, Element type, Map<String, ClassElement> typeArgs, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        jsonViewPostfix = "";
        if (jsonViewClass != null) {
            jsonViewClassName = jsonViewClass.getName();
            jsonViewPostfix = "_" + ((jsonViewClassName = jsonViewClassName.replaceAll("\\$", ".")).contains(".") != false ? jsonViewClassName.substring(jsonViewClassName.lastIndexOf(46) + 1) : jsonViewClassName);
        }
        v0 = metaAnnName = definingElement == null ? null : (String)definingElement.getAnnotationNameByStereotype(io.swagger.v3.oas.annotations.media.Schema.class).orElse(null);
        if (metaAnnName != null && !io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(metaAnnName)) {
            return NameUtils.getSimpleName((String)metaAnnName) + (String)jsonViewPostfix;
        }
        if (!(type instanceof TypedElement)) ** GOTO lbl-1000
        typedEl = (TypedElement)type;
        if (!(type instanceof EnumElement)) {
            typeType = typedEl.getType();
            packageName = typeType.getPackageName();
            resultSchemaName = CollectionUtils.isNotEmpty((Map)typeType.getTypeArguments()) ? this.computeNameWithGenerics(typeType, typeArgs, context) : this.computeNameWithGenerics(typeType, Collections.emptyMap(), context);
        } else lbl-1000:
        // 2 sources

        {
            resultSchemaName = type.getSimpleName();
            packageName = NameUtils.getPackageName((String)type.getName());
        }
        schemaDecorator = ConfigUtils.getSchemaDecoration(packageName, context);
        resultSchemaName = resultSchemaName.replaceAll("\\$", ".") + (String)jsonViewPostfix;
        if (schemaDecorator != null) {
            resultSchemaName = (StringUtils.hasText((CharSequence)schemaDecorator.getPrefix()) != false ? schemaDecorator.getPrefix() : "") + (String)resultSchemaName + (StringUtils.hasText((CharSequence)schemaDecorator.getPostfix()) != false ? schemaDecorator.getPostfix() : "");
        }
        fullClassNameWithGenerics = packageName + "." + (String)resultSchemaName;
        storedClassName = this.schemaNameToClassNameMap.get(resultSchemaName);
        if (storedClassName != null && !storedClassName.equals(fullClassNameWithGenerics)) {
            index = this.shemaNameSuffixCounterMap.getOrDefault(resultSchemaName, 0);
            this.shemaNameSuffixCounterMap.put((String)resultSchemaName, ++index);
            resultSchemaName = (String)resultSchemaName + "_" + index;
        }
        this.schemaNameToClassNameMap.put((String)resultSchemaName, fullClassNameWithGenerics);
        return resultSchemaName;
    }

    private String computeNameWithGenerics(ClassElement classElement, Map<String, ClassElement> typeArgs, VisitorContext context) {
        StringBuilder builder = new StringBuilder(classElement.getSimpleName());
        this.computeNameWithGenerics(classElement, builder, new HashSet<String>(), typeArgs, context);
        return builder.toString();
    }

    private void computeNameWithGenerics(ClassElement classElement, StringBuilder builder, Set<String> computed, Map<String, ClassElement> typeArgs, VisitorContext context) {
        computed.add(classElement.getName());
        Iterator<ClassElement> i = typeArgs.values().iterator();
        if (i.hasNext()) {
            builder.append('_');
            while (i.hasNext()) {
                ClassElement ce = i.next();
                builder.append(ce.getSimpleName());
                Map ceTypeArgs = ce.getTypeArguments();
                ClassElement customElement = ConfigUtils.getCustomSchema(ce.getName(), ceTypeArgs, context);
                if (customElement != null) {
                    ce = customElement;
                }
                if (!computed.contains(ce.getName())) {
                    this.computeNameWithGenerics(ce, builder, computed, ceTypeArgs, context);
                }
                if (!i.hasNext()) continue;
                builder.append('.');
            }
            builder.append('_');
        }
    }

    private void populateSchemaProperties(OpenAPI openAPI, VisitorContext context, Element type, Map<String, ClassElement> typeArgs, Schema<?> schema, List<MediaType> mediaTypes, JavadocDescription classJavadoc, @Nullable ClassElement jsonViewClass) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            ClassElement classEl;
            classElement = classEl = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            TypedElement typedEl = (TypedElement)type;
            classElement = typedEl.getType();
        }
        if (classElement != null) {
            List<Object> beanProperties;
            try {
                beanProperties = classElement.getBeanProperties().stream().filter(p -> !"groovy.lang.MetaClass".equals(p.getType().getName())).toList();
            }
            catch (Exception e) {
                context.warn("Error with getting properties for class " + classElement.getName() + ": " + e + "\n" + Utils.printStackTrace(e), (Element)classElement);
                beanProperties = Collections.emptyList();
            }
            this.processPropertyElements(openAPI, context, type, typeArgs, schema, beanProperties, mediaTypes, classJavadoc, jsonViewClass);
            String visibilityLevelProp = ConfigUtils.getConfigProperty("micronaut.openapi.field.visibility.level", context);
            VisibilityLevel visibilityLevel = VisibilityLevel.PUBLIC;
            if (StringUtils.hasText((CharSequence)visibilityLevelProp)) {
                try {
                    visibilityLevel = VisibilityLevel.valueOf(visibilityLevelProp.toUpperCase());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Wrong value for visibility level property: " + ConfigUtils.getConfigProperty("micronaut.openapi.field.visibility.level", context));
                }
            }
            ArrayList<FieldElement> publicFields = new ArrayList<FieldElement>();
            for (FieldElement field : classElement.getFields()) {
                if (field.isStatic() || visibilityLevel == VisibilityLevel.PUBLIC && !field.isPublic() || visibilityLevel == VisibilityLevel.PROTECTED && !field.isPublic() && !field.isProtected() || visibilityLevel == VisibilityLevel.PACKAGE && !field.isPublic() && !field.isProtected() && !field.isPackagePrivate()) continue;
                boolean alreadyProcessed = false;
                for (PropertyElement propertyElement : beanProperties) {
                    if (!propertyElement.getName().equals(field.getName())) continue;
                    alreadyProcessed = true;
                    break;
                }
                if (alreadyProcessed) continue;
                publicFields.add(field);
            }
            this.processPropertyElements(openAPI, context, type, typeArgs, schema, publicFields, mediaTypes, classJavadoc, jsonViewClass);
        }
    }

    private void processPropertyElements(OpenAPI openAPI, VisitorContext context, Element type, Map<String, ClassElement> typeArgs, Schema<?> schema, List<? extends TypedElement> publicFields, List<MediaType> mediaTypes, JavadocDescription classJavadoc, @Nullable ClassElement jsonViewClass) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            ClassElement classEl;
            classElement = classEl = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            TypedElement typedEl = (TypedElement)type;
            classElement = typedEl.getType();
        }
        boolean withJsonView = jsonViewClass != null;
        String[] classLvlJsonViewClasses = null;
        if (withJsonView && classElement != null) {
            classLvlJsonViewClasses = classElement.getAnnotationMetadata().stringValues(JsonView.class);
        }
        for (TypedElement typedElement : publicFields) {
            GenericPlaceholderElement genericPlaceholderEl;
            ClassElement genericType;
            MemberElement memberEl;
            boolean isHidden = typedElement.getAnnotationMetadata().booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "hidden").orElse(false);
            AnnotationValue jsonAnySetterAnn = typedElement.getAnnotation(JsonAnySetter.class);
            if (typedElement.isAnnotationPresent(JsonIgnore.class) || typedElement.isAnnotationPresent(Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.booleanValue("enabled").orElse(true).booleanValue() || isHidden) continue;
            boolean isGetterOverriden = false;
            JavadocDescription fieldJavadoc = null;
            if (classElement != null) {
                PropertyElement propertyEl;
                MethodElement readerMethod;
                for (FieldElement field : classElement.getFields()) {
                    if (!field.getName().equals(typedElement.getName())) continue;
                    fieldJavadoc = Utils.getJavadocParser().parse(typedElement.getDocumentation().orElse(field.getDocumentation().orElse(null)));
                    break;
                }
                if (typedElement instanceof PropertyElement && (readerMethod = (MethodElement)(propertyEl = (PropertyElement)typedElement).getReadMethod().orElse(null)) != null) {
                    List methods = classElement.getEnclosedElements(ElementQuery.ALL_METHODS.includeOverriddenMethods());
                    for (MethodElement method : methods) {
                        if (!readerMethod.overrides(method)) continue;
                        isGetterOverriden = CollectionUtils.isNotEmpty((Collection)readerMethod.getAnnotationNames()) || fieldJavadoc != null;
                        break;
                    }
                }
            }
            if (!(typedElement instanceof MemberElement) || !(memberEl = (MemberElement)typedElement).getDeclaringType().getType().getName().equals(type.getName()) && !isGetterOverriden) continue;
            ClassElement fieldType = typedElement.getType();
            ClassElement classElement2 = typedElement.getType();
            if (classElement2 instanceof GenericPlaceholderElement && (genericType = typeArgs.get((genericPlaceholderEl = (GenericPlaceholderElement)classElement2).getVariableName())) != null) {
                fieldType = genericType;
            }
            if (withJsonView && !this.allowedByJsonView(typedElement, classLvlJsonViewClasses, jsonViewClass, context)) continue;
            Schema<?> propertySchema = this.resolveSchema(openAPI, (Element)typedElement, fieldType, context, mediaTypes, jsonViewClass, fieldJavadoc, classJavadoc);
            this.processSchemaProperty(context, typedElement, fieldType, type, schema, propertySchema);
        }
    }

    private boolean allowedByJsonView(TypedElement publicField, String[] classLvlJsonViewClasses, ClassElement jsonViewClassEl, VisitorContext context) {
        Object[] fieldJsonViewClasses = publicField.getAnnotationMetadata().stringValues(JsonView.class);
        if (ArrayUtils.isEmpty((Object[])fieldJsonViewClasses)) {
            fieldJsonViewClasses = classLvlJsonViewClasses;
        }
        if (ArrayUtils.isEmpty((Object[])fieldJsonViewClasses)) {
            return ConfigUtils.isJsonViewDefaultInclusion(context);
        }
        for (Object fieldJsonViewClass : fieldJsonViewClasses) {
            if (!jsonViewClassEl.isAssignable((ClassElement)context.getClassElement((String)fieldJsonViewClass).get())) continue;
            return true;
        }
        return false;
    }

    private Schema<?> getPrimitiveType(String typeName) {
        Class wrapperType;
        PrimitiveType primitiveType;
        Schema schema = null;
        Class aClass = ClassUtils.getPrimitiveType((String)typeName).orElse(null);
        if (aClass == null) {
            aClass = ClassUtils.forName((String)typeName, (ClassLoader)this.getClass().getClassLoader()).orElse(null);
        }
        if (aClass != null && (primitiveType = PrimitiveType.fromType(wrapperType = ReflectionUtils.getWrapperType((Class)aClass))) != null) {
            schema = primitiveType.createProperty();
        }
        return schema;
    }

    protected void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(SecurityScheme.class);
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        for (AnnotationValue securityRequirementAnnotationValue : values) {
            Map<CharSequence, Object> map = this.toValueMap(securityRequirementAnnotationValue.getValues(), context, null);
            securityRequirementAnnotationValue.stringValue("name").ifPresent(name -> {
                if (map.containsKey("paramName")) {
                    map.put("name", map.remove("paramName"));
                }
                Utils.normalizeEnumValues(map, CollectionUtils.mapOf((Object[])new Object[]{"type", SecurityScheme.Type.class, "in", SecurityScheme.In.class}));
                String type = (String)map.get("type");
                if (!SecurityScheme.Type.APIKEY.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "name", context, false);
                    this.removeAndWarnSecSchemeProp(map, "in", context);
                }
                if (!SecurityScheme.Type.OAUTH2.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "flows", context);
                }
                if (!SecurityScheme.Type.OPENIDCONNECT.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "openIdConnectUrl", context);
                }
                if (!SecurityScheme.Type.HTTP.toString().equals(type)) {
                    this.removeAndWarnSecSchemeProp(map, "scheme", context);
                    this.removeAndWarnSecSchemeProp(map, "bearerFormat", context);
                }
                if (SecurityScheme.Type.HTTP.toString().equals(type)) {
                    if (!map.containsKey("scheme")) {
                        context.warn("Can't use http security scheme without 'scheme' property", null);
                    } else if (!map.get("scheme").equals("bearer") && map.containsKey("bearerFormat")) {
                        context.warn("Should NOT have a `bearerFormat` property without `scheme: bearer` being set", null);
                    }
                }
                if (map.containsKey("ref") || map.containsKey("$ref")) {
                    Object ref = map.get("ref");
                    if (ref == null) {
                        ref = map.get("$ref");
                    }
                    map.clear();
                    map.put("$ref", ref);
                }
                try {
                    JsonNode node = this.toJson(map, context, null);
                    io.swagger.v3.oas.models.security.SecurityScheme securityScheme = ConvertUtils.treeToValue(node, io.swagger.v3.oas.models.security.SecurityScheme.class, context);
                    if (securityScheme != null) {
                        ConvertUtils.resolveExtensions(node).ifPresent(extensions -> BeanMap.of((Object)securityScheme).put((Object)"extensions", extensions));
                        Utils.resolveComponents(openAPI).addSecuritySchemes(name, securityScheme);
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
        }
    }

    private void removeAndWarnSecSchemeProp(Map<CharSequence, Object> map, String prop, VisitorContext context) {
        this.removeAndWarnSecSchemeProp(map, prop, context, true);
    }

    private void removeAndWarnSecSchemeProp(Map<CharSequence, Object> map, String prop, VisitorContext context, boolean withWarn) {
        if (map.containsKey(prop) && withWarn) {
            context.warn("'" + prop + "' property can't set for securityScheme with type " + map.get("type") + ". Skip it", null);
        }
        map.remove(prop);
    }

    protected <T, A extends Annotation> List<T> processOpenApiAnnotation(Element element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                Optional<T> tagOpt;
                Map values;
                if (tag.getAnnotationName().equals(io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName()) && !tag.getValues().isEmpty()) {
                    Object name = tag.getValues().get("name");
                    ArrayList scopes = Optional.ofNullable(tag.getValues().get("scopes")).orElse(new ArrayList());
                    values = Collections.singletonMap((CharSequence)name, scopes);
                } else {
                    values = tag.getValues();
                }
                if (!(tagOpt = this.toValue(values, context, modelType, null)).isPresent()) continue;
                T tagObj = tagOpt.get();
                boolean alreadyExists = false;
                if (CollectionUtils.isNotEmpty(tagList) && tag.getAnnotationName().equals(Tag.class.getName())) {
                    for (T existedTag : tagList) {
                        if (!((io.swagger.v3.oas.models.tags.Tag)existedTag).getName().equals(((io.swagger.v3.oas.models.tags.Tag)tagObj).getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                }
                if (alreadyExists) continue;
                tagList.add(tagObj);
            }
        }
        return tagList;
    }
}

