/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.MediaType;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public final class Utils {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_POSTFIX = "}";
    public static final String ATTR_OPENAPI = "io.micronaut.OPENAPI";
    public static final String ATTR_TEST_MODE = "io.micronaut.OPENAPI_TEST";
    public static final String ATTR_VISITED_ELEMENTS = "io.micronaut.OPENAPI.visited.elements";
    public static final List<MediaType> DEFAULT_MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private static Set<String> allKnownVersions;
    private static Set<String> allKnownGroups;
    private static Map<String, List<EndpointInfo>> endpointInfos;
    private static Map<String, OpenAPI> openApis;
    private static Map<String, List<String>> includedClassesGroups;
    private static Map<String, List<String>> includedClassesGroupsExcluded;
    private static PropertyPlaceholderResolver propertyPlaceholderResolver;
    private static OpenAPI testReference;
    private static Map<Pair<String, String>, OpenApiInfo> testReferences;
    private static String testFileName;
    private static String testYamlReference;
    private static String testJsonReference;
    private static JavadocParser javadocParser;

    private Utils() {
    }

    public static PropertyPlaceholderResolver getPropertyPlaceholderResolver() {
        if (propertyPlaceholderResolver == null) {
            propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(new PropertyResolver(){

                public boolean containsProperty(@NonNull String name) {
                    return false;
                }

                public boolean containsProperties(@NonNull String name) {
                    return false;
                }

                @NonNull
                public <T> Optional<T> getProperty(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
                    return Optional.empty();
                }

                public Collection<List<String>> getPropertyPathMatches(String pathPattern) {
                    return null;
                }
            }, (ConversionService)new DefaultMutableConversionService());
        }
        return propertyPlaceholderResolver;
    }

    public static <T extends Enum<T>> void normalizeEnumValues(Map<CharSequence, Object> paramValues, Map<String, Class<T>> enumTypes) {
        for (Map.Entry<String, Class<T>> entry : enumTypes.entrySet()) {
            String name = entry.getKey();
            Class<T> enumType = entry.getValue();
            Object in = paramValues.get(name);
            if (in == null) continue;
            try {
                T enumInstance = Enum.valueOf(enumType, in.toString());
                paramValues.put(name, ((Enum)enumInstance).toString());
            }
            catch (Exception exception) {}
        }
    }

    public static Components resolveComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            components = new Components();
            openAPI.setComponents(components);
        }
        return components;
    }

    public static OpenAPI resolveOpenApi(VisitorContext context) {
        OpenAPI openAPI = context.get((CharSequence)ATTR_OPENAPI, OpenAPI.class).orElse(null);
        if (openAPI == null) {
            openAPI = new OpenAPI();
            context.put((CharSequence)ATTR_OPENAPI, (Object)openAPI);
        }
        return openAPI;
    }

    public static String printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        sw.append(t.getMessage()).append('\n');
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean(ATTR_TEST_MODE);
    }

    public static OpenAPI getTestReference() {
        return testReference;
    }

    public static void setTestReference(OpenAPI testReference) {
        Utils.testReference = testReference;
    }

    public static Map<Pair<String, String>, OpenApiInfo> getTestReferences() {
        return testReferences;
    }

    public static void setTestReferences(Map<Pair<String, String>, OpenApiInfo> testReferences) {
        Utils.testReferences = testReferences;
    }

    public static String getTestYamlReference() {
        return testYamlReference;
    }

    public static void setTestYamlReference(String testYamlReference) {
        Utils.testYamlReference = testYamlReference;
    }

    public static String getTestJsonReference() {
        return testJsonReference;
    }

    public static String getTestFileName() {
        return testFileName;
    }

    public static void setTestFileName(String testFileName) {
        Utils.testFileName = testFileName;
    }

    public static void setTestJsonReference(String testJsonReference) {
        Utils.testJsonReference = testJsonReference;
    }

    public static JavadocParser getJavadocParser() {
        return javadocParser;
    }

    public static void setJavadocParser(JavadocParser javadocParser) {
        Utils.javadocParser = javadocParser;
    }

    public static Set<String> getAllKnownVersions() {
        if (allKnownVersions == null) {
            allKnownVersions = new HashSet<String>();
        }
        return allKnownVersions;
    }

    public static void setAllKnownVersions(Set<String> allKnownVersions) {
        Utils.allKnownVersions = allKnownVersions;
    }

    public static Set<String> getAllKnownGroups() {
        if (allKnownGroups == null) {
            allKnownGroups = new HashSet<String>();
        }
        return allKnownGroups;
    }

    public static void setAllKnownGroups(Set<String> allKnownGroups) {
        Utils.allKnownGroups = allKnownGroups;
    }

    public static Map<String, List<EndpointInfo>> getEndpointInfos() {
        return endpointInfos;
    }

    public static void setEndpointInfos(Map<String, List<EndpointInfo>> endpointInfos) {
        Utils.endpointInfos = endpointInfos;
    }

    public static Map<String, OpenAPI> getOpenApis() {
        return openApis;
    }

    public static void setOpenApis(Map<String, OpenAPI> openApis) {
        Utils.openApis = openApis;
    }

    public static Map<String, List<String>> getIncludedClassesGroups() {
        return includedClassesGroups;
    }

    public static void setIncludedClassesGroups(Map<String, List<String>> includedClassesGroups) {
        Utils.includedClassesGroups = includedClassesGroups;
    }

    public static Map<String, List<String>> getIncludedClassesGroupsExcluded() {
        return includedClassesGroupsExcluded;
    }

    public static void setIncludedClassesGroupsExcluded(Map<String, List<String>> includedClassesGroupsExcluded) {
        Utils.includedClassesGroupsExcluded = includedClassesGroupsExcluded;
    }

    public static void clean() {
        openApis = null;
        endpointInfos = null;
        includedClassesGroups = null;
        includedClassesGroupsExcluded = null;
        allKnownGroups = null;
        allKnownVersions = null;
        testReference = null;
        testReferences = null;
        testFileName = null;
        testYamlReference = null;
        testJsonReference = null;
    }

    static {
        javadocParser = new JavadocParser();
    }
}

