/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.annotation.OpenAPIGroupInfo;
import io.micronaut.openapi.annotation.OpenAPIGroupInfos;
import io.micronaut.openapi.postprocessors.JacksonDiscriminatorPostProcessor;
import io.micronaut.openapi.postprocessors.OpenApiOperationsPostProcessor;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.AdocModule;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.Endpoint;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.OpenApiConfigProperty;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.OpenApiNormalizeUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.EndpointGroupInfo;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<Object, Object> {
    private ClassElement classElement;
    private int visitedElements = -1;

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public Set<String> getSupportedOptions() {
        return OpenApiConfigProperty.ALL;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        try {
            if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
                return;
            }
            if (this.ignore(element, context)) {
                return;
            }
            this.incrementVisitedElements(context);
            ContextUtils.info("Generating OpenAPI Documentation", context);
            OpenAPI openApi = this.readOpenApi(element, context);
            this.processSecuritySchemes(element, context);
            this.mergeAdditionalSwaggerFiles(element, context, openApi);
            List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openApi.getTags());
            openApi.setTags(tagList);
            List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
            if (openApi.getSecurity() != null) {
                securityRequirements.addAll(openApi.getSecurity());
            }
            openApi.setSecurity(securityRequirements);
            List<io.swagger.v3.oas.models.servers.Server> servers = this.processOpenApiAnnotation((Element)element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, openApi.getServers());
            openApi.setServers(servers);
            OpenAPI existing = ContextUtils.get("io.micronaut.OPENAPI", OpenAPI.class, context);
            if (existing != null) {
                if (openApi.getInfo() != null) {
                    existing.setInfo(openApi.getInfo());
                }
                SchemaUtils.copyOpenApi(existing, openApi);
            } else {
                ContextUtils.put("io.micronaut.OPENAPI", openApi, context);
            }
            if (Utils.isTestMode()) {
                Utils.resolveOpenApi(context);
            }
            this.classElement = element;
        }
        catch (Exception e) {
            ContextUtils.warn("Error with processing class:\n" + Utils.printStackTrace(e), context, (Element)this.classElement);
        }
    }

    private boolean ignore(ClassElement element, VisitorContext context) {
        return !element.isAnnotationPresent(OpenAPIDefinition.class) && !element.isAnnotationPresent(OpenAPIGroupInfo.class) && !element.isAnnotationPresent(OpenAPIGroupInfos.class);
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = ConfigUtils.getConfigProperty("micronaut.openapi.additional.files", context);
        if (StringUtils.isEmpty((CharSequence)additionalSwaggerFiles)) {
            return;
        }
        Path directory = FileUtils.resolve(context, java.nio.file.Paths.get(additionalSwaggerFiles, new String[0]));
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            ContextUtils.warn(directory + " does not exist or is not a directory", context, (Element)element);
            return;
        }
        ContextUtils.info("Merging Swagger OpenAPI YAML and JSON files from location: " + directory, context);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, path -> FileUtils.isYaml(path.toString().toLowerCase()) || path.toString().toLowerCase().endsWith(".json"));){
            stream.forEach(path -> {
                boolean isYaml = FileUtils.isYaml(path.toString().toLowerCase());
                ContextUtils.info("Reading Swagger OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + path.getFileName(), context);
                OpenAPI parsedOpenApi = null;
                try {
                    parsedOpenApi = (OpenAPI)(isYaml ? Utils.getYamlMapper() : Utils.getJsonMapper()).readValue(path.toFile(), OpenAPI.class);
                }
                catch (IOException e) {
                    ContextUtils.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), context, (Element)element);
                }
                SchemaUtils.copyOpenApi(openAPI, parsedOpenApi);
            });
        }
        catch (IOException e) {
            ContextUtils.warn("Unable to read  file from " + directory + ": " + e.getMessage(), context, (Element)element);
        }
    }

    private OpenAPI readOpenApi(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            Optional<OpenAPI> result = this.toValue(o.getValues(), context, OpenAPI.class, null);
            result.ifPresent(openApi -> {
                if (Utils.isOpenapi31()) {
                    openApi.openapi("3.1.0").jsonSchemaDialect(ConfigUtils.getJsonSchemaDialect(context)).specVersion(SpecVersion.V31);
                }
                ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
                for (AnnotationValue secRequirementAnn : o.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class)) {
                    securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)secRequirementAnn));
                }
                openApi.setSecurity(securityRequirements);
            });
            return result;
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, Map<Pair<String, String>, OpenApiInfo> openApiInfos, Path destinationDir, VisitorContext context) throws IOException {
        String viewSpecification = ConfigUtils.getConfigProperty("micronaut.openapi.views.spec", context);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, openApiInfos, ConfigUtils.readOpenApiConfigFile(context), context);
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            if (CollectionUtils.isNotEmpty(openApiInfos)) {
                cfg.setSpecFile(openApiInfos.values().iterator().next().getSpecFilePath());
            }
            cfg.setServerContextPath(ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context));
            cfg.render(destinationDir, context);
        }
    }

    private static PropertyNamingStrategies.NamingBase fromName(String name) {
        if (name == null) {
            return null;
        }
        return switch (name.toUpperCase(Locale.US)) {
            case "LOWER_CAMEL_CASE" -> new LowerCamelCasePropertyNamingStrategy();
            case "UPPER_CAMEL_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_CAMEL_CASE;
            case "SNAKE_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.SNAKE_CASE;
            case "UPPER_SNAKE_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_SNAKE_CASE;
            case "LOWER_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CASE;
            case "KEBAB_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.KEBAB_CASE;
            case "LOWER_DOT_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_DOT_CASE;
            default -> null;
        };
    }

    private void applyPropertyNamingStrategy(OpenAPI openAPI, VisitorContext context) {
        String namingStrategyName = ConfigUtils.getConfigProperty("micronaut.openapi.property.naming.strategy", context);
        PropertyNamingStrategies.NamingBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
        if (propertyNamingStrategy != null) {
            ContextUtils.info("Using " + namingStrategyName + " property naming strategy.", context);
            if (openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)openAPI.getComponents().getSchemas())) {
                openAPI.getComponents().getSchemas().values().forEach(model -> {
                    List required;
                    Map properties = model.getProperties();
                    if (properties != null) {
                        Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                        model.getProperties().clear();
                        model.setProperties(newProperties);
                    }
                    if ((required = model.getRequired()) != null) {
                        List<String> updatedRequired = required.stream().map(arg_0 -> ((PropertyNamingStrategies.NamingBase)propertyNamingStrategy).translate(arg_0)).toList();
                        required.clear();
                        required.addAll(updatedRequired);
                    }
                });
            }
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openAPI, VisitorContext context) {
        String serverContextPath = ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context);
        if (serverContextPath == null || serverContextPath.isEmpty()) {
            return;
        }
        ContextUtils.info("Applying server context path: " + serverContextPath + " to Paths.", context);
        Paths paths = openAPI.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Paths newPaths = new Paths();
        for (Map.Entry path : paths.entrySet()) {
            Object newPath;
            String mapping = (String)path.getKey();
            Object object = newPath = mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping);
            if (!((String)newPath).startsWith("/") && !((String)newPath).startsWith("$")) {
                newPath = "/" + (String)newPath;
            }
            newPaths.addPathItem((String)newPath, (PathItem)path.getValue());
        }
        openAPI.setPaths(newPaths);
    }

    public static JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, OpenApiApplicationVisitor.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    public static JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.isEmpty()) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), OpenApiApplicationVisitor.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    public static JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.isBlank()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    public static String expandProperties(String s, List<Pair<String, String>> properties, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.contains("${")) {
            return s;
        }
        if (CollectionUtils.isNotEmpty(properties)) {
            for (Pair<String, String> entry : properties) {
                s = s.replaceAll(entry.getFirst(), entry.getSecond());
            }
        }
        return OpenApiApplicationVisitor.replacePlaceholders(s, context);
    }

    public static String replacePlaceholders(String value, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)value) || !value.contains("${")) {
            return value;
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> sysProp : System.getProperties().entrySet()) {
                value = value.replace("${" + sysProp.getKey().toString() + "}", sysProp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> fileProp : ConfigUtils.readOpenApiConfigFile(context).entrySet()) {
            value = value.replace("${" + fileProp.getKey().toString() + "}", fileProp.getValue().toString());
        }
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            value = environment.getPlaceholderResolver().resolvePlaceholders(value).orElse(value);
        }
        return value;
    }

    private static OpenAPI resolvePropertyPlaceHolders(OpenAPI openAPI, VisitorContext context) {
        List<Pair<String, String>> expandableProperties = ConfigUtils.getExpandableProperties(context);
        if (CollectionUtils.isNotEmpty(expandableProperties)) {
            ContextUtils.info("Expanding properties: " + expandableProperties, context);
        }
        JsonNode root = OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)Utils.getYamlMapper().convertValue((Object)openAPI, ObjectNode.class), s -> OpenApiApplicationVisitor.expandProperties(s, expandableProperties, context));
        return (OpenAPI)Utils.getYamlMapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext context) {
        try {
            if (!ConfigUtils.isOpenApiEnabled(context)) {
                return;
            }
            if (this.visitedElements == this.visitedElements(context)) {
                return;
            }
            Map<Pair<String, String>, OpenApiInfo> openApiInfos = null;
            String documentTitle = "OpenAPI";
            if (ConfigUtils.isSpecGenerationEnabled(context)) {
                String isJson;
                OpenAPI openApi = ContextUtils.get("io.micronaut.OPENAPI", OpenAPI.class, context);
                if (openApi == null) {
                    return;
                }
                this.processEndpoints(context);
                this.mergeMicronautEndpointInfos(openApi, context);
                openApiInfos = this.divideOpenapiByGroupsAndVersions(openApi, context);
                if (Utils.isTestMode()) {
                    Utils.setTestReferences(openApiInfos);
                }
                boolean isYaml = !StringUtils.isNotEmpty((CharSequence)(isJson = ConfigUtils.getConfigProperty("micronaut.openapi.json.format", context))) || !isJson.equalsIgnoreCase("true");
                String ext = isYaml ? ".yml" : ".json";
                for (Map.Entry<Pair<String, String>, OpenApiInfo> entry : openApiInfos.entrySet()) {
                    OpenApiInfo openApiInfo = entry.getValue();
                    openApi = openApiInfo.getOpenApi();
                    openApi = this.postProcessOpenApi(openApi, context);
                    openApiInfo.setOpenApi(openApi);
                    if (Utils.isTestMode()) {
                        Utils.setTestReference(openApi);
                    }
                    Pair<String, String> titleAndFilename = FileUtils.calcFinalFilename(openApiInfo.getFilename(), openApiInfo, openApiInfos.size() == 1, ext, context);
                    documentTitle = titleAndFilename.getFirst();
                    openApiInfo.setFilename(titleAndFilename.getSecond());
                }
                this.writeYamlToFile(openApiInfos, documentTitle, context, isYaml);
            }
            this.generateViews(documentTitle, openApiInfos, context);
            this.visitedElements = this.visitedElements(context);
        }
        catch (Exception e) {
            ContextUtils.warn("Error:\n" + Utils.printStackTrace(e), context);
            throw e;
        }
    }

    private Map<Pair<String, String>, OpenApiInfo> divideOpenapiByGroupsAndVersions(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        Set<String> allVersions = Utils.getAllKnownVersions();
        Set<String> allGroups = Utils.getAllKnownGroups();
        if (CollectionUtils.isEmpty(endpointInfosMap) || CollectionUtils.isEmpty(allVersions) && CollectionUtils.isEmpty(allGroups)) {
            return Collections.singletonMap(Pair.NULL_STRING_PAIR, new OpenApiInfo(openApi));
        }
        ArrayList<EndpointInfo> commonEndpoints = new ArrayList<EndpointInfo>();
        HashMap<Pair<String, String>, OpenApiInfo> result = new HashMap<Pair<String, String>, OpenApiInfo>();
        for (List<EndpointInfo> list : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : list) {
                if (CollectionUtils.isEmpty(endpointInfo.getGroups()) && endpointInfo.getVersion() == null) {
                    commonEndpoints.add(endpointInfo);
                    continue;
                }
                for (EndpointGroupInfo endpointGroupInfo : endpointInfo.getGroups().values()) {
                    if (CollectionUtils.isNotEmpty(endpointInfo.getExcludedGroups()) && endpointInfo.getExcludedGroups().contains(endpointGroupInfo.getName())) continue;
                    OpenAPI newOpenApi = this.addOpenApiInfo(endpointGroupInfo.getName(), endpointInfo.getVersion(), openApi, result, context);
                    this.addOperation(endpointInfo, newOpenApi, endpointGroupInfo, context);
                }
                if (!CollectionUtils.isEmpty(endpointInfo.getGroups())) continue;
                OpenAPI newOpenApi = this.addOpenApiInfo(null, endpointInfo.getVersion(), openApi, result, context);
                this.addOperation(endpointInfo, newOpenApi, null, context);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String group = (String)((Pair)entry.getKey()).getFirst();
            GroupProperties groupProperties = ConfigUtils.getGroupProperties(group, context);
            if (groupProperties != null && groupProperties.getCommonExclude() != null && groupProperties.getCommonExclude().booleanValue()) continue;
            OpenAPI groupOpenApi = ((OpenApiInfo)entry.getValue()).getOpenApi();
            for (EndpointInfo commonEndpoint : commonEndpoints) {
                if (CollectionUtils.isNotEmpty(commonEndpoint.getExcludedGroups()) && commonEndpoint.getExcludedGroups().contains(group)) continue;
                this.addOperation(commonEndpoint, groupOpenApi, null, context);
            }
        }
        return result;
    }

    private void addOperation(EndpointInfo endpointInfo, OpenAPI openApi, @Nullable EndpointGroupInfo endpointGroupInfo, VisitorContext context) {
        PathItem pathItem;
        Operation operation;
        if (openApi == null) {
            return;
        }
        Paths paths = openApi.getPaths();
        if (paths == null) {
            paths = new Paths();
            openApi.setPaths(paths);
        }
        if ((operation = SchemaUtils.getOperationOnPathItem(pathItem = (PathItem)paths.computeIfAbsent((Object)endpointInfo.getUrl(), pathUrl -> new PathItem()), endpointInfo.getHttpMethod())) == null) {
            Operation opCopy = null;
            try {
                opCopy = (Operation)OpenApiUtils.getJsonMapper().treeToValue((TreeNode)OpenApiUtils.getJsonMapper().valueToTree((Object)endpointInfo.getOperation()), Operation.class);
                if (endpointGroupInfo != null) {
                    this.addExtensions(opCopy, endpointGroupInfo.getExtensions());
                }
            }
            catch (JsonProcessingException e) {
                ContextUtils.warn("Error\n" + Utils.printStackTrace(e), context);
            }
            SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), opCopy != null ? opCopy : endpointInfo.getOperation());
            return;
        }
        Operation mergedOp = SchemaUtils.mergeOperations(operation, endpointInfo.getOperation());
        if (endpointGroupInfo != null) {
            this.addExtensions(mergedOp, endpointGroupInfo.getExtensions());
        }
        SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), mergedOp);
    }

    private void addExtensions(Operation operation, Map<CharSequence, Object> extensions) {
        if (CollectionUtils.isEmpty(extensions)) {
            return;
        }
        for (Map.Entry<CharSequence, Object> ext : extensions.entrySet()) {
            operation.addExtension(ext.getKey().toString(), ext.getValue());
        }
    }

    private OpenAPI addOpenApiInfo(String groupName, String version, OpenAPI openApi, Map<Pair<String, String>, OpenApiInfo> openApiInfoMap, VisitorContext context) {
        OpenAPI newOpenApi;
        GroupProperties groupProperties = ConfigUtils.getGroupProperties(groupName, context);
        boolean hasGroupProperties = groupProperties != null;
        Pair<String, String> key = Pair.of(groupName, version);
        OpenApiInfo openApiInfo = openApiInfoMap.get(key);
        if (openApiInfo == null) {
            Map groupSecuritySchemes;
            OpenAPI openApiCopy;
            Map<String, OpenAPI> knownOpenApis = Utils.getOpenApis();
            newOpenApi = CollectionUtils.isNotEmpty(knownOpenApis) && knownOpenApis.containsKey(groupName) ? knownOpenApis.get(groupName) : new OpenAPI();
            openApiInfo = new OpenApiInfo(version, groupName, hasGroupProperties ? groupProperties.getDisplayName() : null, hasGroupProperties ? groupProperties.getFilename() : null, !hasGroupProperties || groupProperties.getAdocEnabled() == null || groupProperties.getAdocEnabled() != false, hasGroupProperties ? groupProperties.getAdocFilename() : null, newOpenApi);
            openApiInfoMap.put(key, openApiInfo);
            try {
                openApiCopy = (OpenAPI)Utils.getJsonMapper().treeToValue((TreeNode)Utils.getJsonMapper().valueToTree((Object)openApi), OpenAPI.class);
            }
            catch (JsonProcessingException e) {
                ContextUtils.warn("Error\n" + Utils.printStackTrace(e), context);
                return null;
            }
            if (CollectionUtils.isEmpty(knownOpenApis) || !knownOpenApis.containsKey(groupName)) {
                newOpenApi.setTags(openApiCopy.getTags());
                newOpenApi.setServers(openApiCopy.getServers());
                newOpenApi.setInfo(openApiCopy.getInfo());
                newOpenApi.setSecurity(openApiCopy.getSecurity());
                newOpenApi.setExternalDocs(openApiCopy.getExternalDocs());
                newOpenApi.setExtensions(openApiCopy.getExtensions());
            }
            Map map = groupSecuritySchemes = newOpenApi.getComponents() != null ? newOpenApi.getComponents().getSecuritySchemes() : null;
            if (CollectionUtils.isNotEmpty((Map)groupSecuritySchemes) && openApiCopy.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApiCopy.getComponents().getSecuritySchemes())) {
                for (Map.Entry entry : openApiCopy.getComponents().getSecuritySchemes().entrySet()) {
                    if (groupSecuritySchemes.containsKey(entry.getKey())) continue;
                    groupSecuritySchemes.put((String)entry.getKey(), (SecurityScheme)entry.getValue());
                }
            }
            newOpenApi.setComponents(openApiCopy.getComponents());
            if (CollectionUtils.isNotEmpty((Map)groupSecuritySchemes)) {
                Utils.resolveComponents(newOpenApi).setSecuritySchemes(groupSecuritySchemes);
            }
        } else {
            newOpenApi = openApiInfo.getOpenApi();
        }
        return newOpenApi;
    }

    private void mergeMicronautEndpointInfos(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        if (CollectionUtils.isEmpty(endpointInfosMap)) {
            return;
        }
        for (List<EndpointInfo> endpointInfos : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : endpointInfos) {
                PathItem pathItem = (PathItem)openApi.getPaths().get((Object)endpointInfo.getUrl());
                Operation operation = SchemaUtils.getOperationOnPathItem(pathItem, endpointInfo.getHttpMethod());
                if (operation == null) {
                    SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), endpointInfo.getOperation());
                    continue;
                }
                if (endpointInfo.getVersion() != null || !CollectionUtils.isEmpty(endpointInfo.getGroups())) continue;
                SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), SchemaUtils.mergeOperations(operation, endpointInfo.getOperation()));
            }
        }
    }

    public int getOrder() {
        return 100;
    }

    private OpenAPI postProcessOpenApi(OpenAPI openApi, VisitorContext context) {
        this.applyPropertyNamingStrategy(openApi, context);
        this.applyPropertyServerContextPath(openApi, context);
        OpenApiNormalizeUtils.normalizeOpenApi(openApi, context);
        new JacksonDiscriminatorPostProcessor().addMissingDiscriminatorType(openApi);
        new OpenApiOperationsPostProcessor().processOperations(openApi);
        try {
            Map schemas;
            if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)(schemas = openApi.getComponents().getSchemas()))) {
                String openApiJson = Utils.getJsonMapper().writeValueAsString((Object)openApi);
                HashSet keySet = new HashSet(schemas.keySet());
                for (String schemaName : keySet) {
                    if (openApiJson.contains("\"#/components/schemas/" + schemaName + "\"")) continue;
                    schemas.remove(schemaName);
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        OpenApiNormalizeUtils.removeEmptyComponents(openApi);
        OpenApiNormalizeUtils.findAndRemoveDuplicates(openApi);
        openApi = OpenApiApplicationVisitor.resolvePropertyPlaceHolders(openApi, context);
        return openApi;
    }

    private void generateViews(@Nullable String documentTitle, @Nullable Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        Path viewsDestDirs = FileUtils.getViewsDestDir(FileUtils.getDefaultFilePath("dummy" + System.nanoTime(), context), context);
        if (viewsDestDirs == null) {
            return;
        }
        if (context != null) {
            ContextUtils.info("Writing OpenAPI views to destination: " + viewsDestDirs, context);
            Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
            if (classesOutputPath != null) {
                ContextUtils.addGeneratedResource(classesOutputPath.relativize(viewsDestDirs).toString(), context);
                ContextUtils.addGeneratedResource(classesOutputPath.relativize(viewsDestDirs.getParent()).toString(), context);
            }
        }
        try {
            this.renderViews(documentTitle, openApiInfos, viewsDestDirs, context);
        }
        catch (Exception e) {
            String swaggerFiles = "";
            if (openApiInfos != null) {
                swaggerFiles = openApiInfos.values().stream().map(OpenApiInfo::getSpecFilePath).collect(Collectors.joining(", ", "files ", ""));
            }
            ContextUtils.warn("Unable to render swagger view: " + swaggerFiles + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), context, (Element)this.classElement);
        }
    }

    private void writeYamlToFile(Map<Pair<String, String>, OpenApiInfo> openApiInfos, String documentTitle, VisitorContext context, boolean isYaml) {
        Object viewsDestDirs = null;
        boolean isAdocModuleInClassPath = false;
        boolean isGlobalAdocEnabled = ConfigUtils.getBooleanProperty("micronaut.openapi.adoc.enabled", true, context);
        try {
            Class<?> converterClass = Class.forName("io.micronaut.openapi.adoc.OpenApiToAdocConverter");
            isAdocModuleInClassPath = true;
        }
        catch (ClassNotFoundException converterClass) {
            // empty catch block
        }
        ObjectMapper objectMapper = isYaml ? Utils.getYamlMapper() : Utils.getJsonMapper();
        for (OpenApiInfo openApiInfo : openApiInfos.values()) {
            Path specFile = FileUtils.openApiSpecFile(openApiInfo.getFilename(), context);
            try {
                Writer writer = this.getFileWriter(specFile);
                try {
                    objectMapper.writeValue(writer, (Object)openApiInfo.getOpenApi());
                    if (Utils.isTestMode()) {
                        Utils.setTestFileName(openApiInfo.getFilename());
                        if (isYaml) {
                            Utils.setTestYamlReference(writer.toString());
                        } else {
                            Utils.setTestJsonReference(writer.toString());
                        }
                    } else {
                        ContextUtils.info("Writing OpenAPI file to destination: " + specFile, context);
                        Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
                        if (classesOutputPath != null) {
                            ContextUtils.addGeneratedResource(classesOutputPath.relativize(specFile).toString(), context);
                            ContextUtils.addGeneratedResource(classesOutputPath.relativize(specFile.getParent()).toString(), context);
                        }
                        openApiInfo.setSpecFilePath(specFile.getFileName().toString());
                    }
                    if (!isAdocModuleInClassPath || !isGlobalAdocEnabled || !openApiInfo.isAdocEnabled()) continue;
                    Map<String, String> adocProperties = ConfigUtils.getAdocProperties(openApiInfo, openApiInfos.size() == 1, context);
                    AdocModule.convert(openApiInfo, adocProperties, context);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                ContextUtils.warn("Unable to generate swagger" + (isYaml ? ".yml" : ".json") + ": " + specFile + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), context, (Element)this.classElement);
            }
        }
    }

    private Writer getFileWriter(Path specFile) throws IOException {
        if (Utils.isTestMode()) {
            return new StringWriter();
        }
        if (specFile != null) {
            return Files.newBufferedWriter(specFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        throw new IOException("Swagger spec file location is not present");
    }

    private void processEndpoints(VisitorContext context) {
        EndpointsConfiguration endpointsCfg = ConfigUtils.endpointsConfiguration(context);
        if (endpointsCfg.isEnabled() && CollectionUtils.isNotEmpty(endpointsCfg.getEndpoints())) {
            OpenApiEndpointVisitor visitor = new OpenApiEndpointVisitor(true);
            for (Endpoint endpoint : endpointsCfg.getEndpoints().values()) {
                ClassElement classEl = endpoint.getClassElement();
                if (classEl == null) continue;
                ContextUtils.put("micronaut.internal.openapi.endpoint.class.tags", endpoint.getTags(), context);
                ContextUtils.put("micronaut.internal.openapi.endpoint.servers", endpoint.getServers(), context);
                ContextUtils.put("micronaut.internal.openapi.endpoint.security.requirements", endpoint.getSecurityRequirements(), context);
                visitor.visitClass(classEl, context);
                for (MethodElement methodEl : classEl.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$")))) {
                    visitor.visitMethod(methodEl, context);
                }
            }
        }
    }

    static class LowerCamelCasePropertyNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private static final long serialVersionUID = -2750503285679998670L;

        LowerCamelCasePropertyNamingStrategy() {
        }

        public String translate(String propertyName) {
            return propertyName;
        }
    }
}

