/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

@Internal
public final class OpenApiNormalizeUtils {
    private OpenApiNormalizeUtils() {
    }

    public static void normalizeOpenApi(OpenAPI openAPI, VisitorContext context) {
        Components components;
        if (openAPI.getPaths() != null) {
            Paths sortedPaths = new Paths();
            new TreeMap<String, PathItem>((Map<String, PathItem>)openAPI.getPaths()).forEach((arg_0, arg_1) -> ((Paths)sortedPaths).addPathItem(arg_0, arg_1));
            if (openAPI.getPaths().getExtensions() != null) {
                sortedPaths.setExtensions(new TreeMap(openAPI.getPaths().getExtensions()));
            }
            openAPI.setPaths(sortedPaths);
            for (PathItem pathItem : sortedPaths.values()) {
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getGet(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getPut(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getPost(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getDelete(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getOptions(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getHead(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getPatch(), context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getTrace(), context);
            }
        }
        if ((components = openAPI.getComponents()) == null) {
            return;
        }
        OpenApiNormalizeUtils.normalizeSchemas(components.getSchemas(), context);
        OpenApiNormalizeUtils.sortComponent(components, Components::getSchemas, Components::setSchemas);
        OpenApiNormalizeUtils.sortComponent(components, Components::getResponses, Components::setResponses);
        OpenApiNormalizeUtils.sortComponent(components, Components::getParameters, Components::setParameters);
        OpenApiNormalizeUtils.sortComponent(components, Components::getExamples, Components::setExamples);
        OpenApiNormalizeUtils.sortComponent(components, Components::getRequestBodies, Components::setRequestBodies);
        OpenApiNormalizeUtils.sortComponent(components, Components::getHeaders, Components::setHeaders);
        OpenApiNormalizeUtils.sortComponent(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
        OpenApiNormalizeUtils.sortComponent(components, Components::getLinks, Components::setLinks);
        OpenApiNormalizeUtils.sortComponent(components, Components::getCallbacks, Components::setCallbacks);
        if (Utils.isOpenapi31()) {
            OpenApiNormalizeUtils.sortComponent(components, Components::getPathItems, Components::setPathItems);
            if (CollectionUtils.isNotEmpty((Map)openAPI.getWebhooks())) {
                openAPI.setWebhooks(new TreeMap(openAPI.getWebhooks()));
            }
        }
    }

    public static void normalizeOperation(Operation operation, VisitorContext context) {
        if (operation == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter parameter : operation.getParameters()) {
                Object object;
                Schema paramSchema;
                if (parameter == null || (paramSchema = parameter.getSchema()) == null) continue;
                Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, context);
                if (normalizedSchema != null) {
                    parameter.setSchema(normalizedSchema);
                } else if (paramSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                    paramSchema.setType("object");
                }
                if (parameter.getExample() != null && (object = parameter.getExample()) instanceof String) {
                    String exampleStr = (String)object;
                    if (parameter.getSchema() != null) {
                        parameter.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, parameter.getSchema().getType(), parameter.getSchema().getFormat(), context, false));
                    }
                }
                OpenApiNormalizeUtils.normalizeExamples(parameter.getExamples());
            }
        }
        if (operation.getRequestBody() != null) {
            OpenApiNormalizeUtils.normalizeContent(operation.getRequestBody().getContent(), context);
        }
        if (CollectionUtils.isNotEmpty((Map)operation.getResponses())) {
            for (ApiResponse apiResponse : operation.getResponses().values()) {
                OpenApiNormalizeUtils.normalizeContent(apiResponse.getContent(), context);
            }
        }
    }

    public static void normalizeContent(Content content, VisitorContext context) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            Schema mediaTypeSchema = mediaType.getSchema();
            if (mediaTypeSchema == null) continue;
            Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(mediaTypeSchema, context);
            if (normalizedSchema != null) {
                mediaType.setSchema(normalizedSchema);
            } else if (mediaTypeSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                mediaTypeSchema.setType("object");
            }
            OpenApiNormalizeUtils.normalizeExamples(mediaType.getExamples());
            Map paramSchemas = mediaTypeSchema.getProperties();
            if (!CollectionUtils.isNotEmpty((Map)paramSchemas)) continue;
            HashMap paramNormalizedSchemas = new HashMap();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema<?> paramNormalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, context);
                if (paramNormalizedSchema == null) continue;
                paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
    }

    public static void normalizeExamples(Map<String, Example> examples) {
        if (CollectionUtils.isEmpty(examples)) {
            return;
        }
        Iterator<String> iter = examples.keySet().iterator();
        while (iter.hasNext()) {
            String exampleName = iter.next();
            Example example = examples.get(exampleName);
            if (example != null) continue;
            iter.remove();
        }
    }

    public static <T> void sortComponent(Components components, Function<Components, Map<String, T>> getter, BiConsumer<Components, Map<String, T>> setter) {
        if (components != null && getter.apply(components) != null) {
            Map<String, T> component = getter.apply(components);
            setter.accept(components, new TreeMap<String, T>(component));
        }
    }

    public static Schema<?> normalizeSchema(Schema<?> schema, VisitorContext context) {
        List allOf = schema.getAllOf();
        if (CollectionUtils.isNotEmpty((Collection)allOf)) {
            if (allOf.size() == 1) {
                Object object;
                boolean isSameType;
                String serializedAllOfDefaultValue;
                String serializedDefaultValue;
                Schema allOfSchema = (Schema)allOf.get(0);
                schema.setAllOf(null);
                Object defaultValue = schema.getDefault();
                String type = schema.getType();
                try {
                    serializedDefaultValue = defaultValue != null ? Utils.getJsonMapper().writeValueAsString(defaultValue) : null;
                }
                catch (JsonProcessingException e) {
                    return null;
                }
                schema.setDefault(null);
                schema.setType(null);
                Schema normalizedSchema = null;
                Object allOfDefaultValue = allOfSchema.getDefault();
                try {
                    serializedAllOfDefaultValue = allOfDefaultValue != null ? Utils.getJsonMapper().writeValueAsString(allOfDefaultValue) : null;
                }
                catch (JsonProcessingException e) {
                    return null;
                }
                boolean bl = isSameType = allOfSchema.getType() == null || allOfSchema.getType().equals(type);
                if (SchemaUtils.isEmptySchema(schema) && (serializedDefaultValue == null || serializedDefaultValue.equals(serializedAllOfDefaultValue)) && (type == null || isSameType)) {
                    normalizedSchema = allOfSchema;
                }
                schema.setType(type);
                schema.setAllOf(allOf);
                schema.setDefault(defaultValue);
                if (schema.getExample() == null) {
                    schema.setExampleSetFlag(false);
                } else if ("string".equals(schema.getType()) && (object = schema.getExample()) instanceof String) {
                    String exampleStr = (String)object;
                    schema.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, type, schema.getFormat(), context, false));
                }
                OpenApiNormalizeUtils.normalizeSchemaProperties(schema, context);
                OpenApiNormalizeUtils.normalizeSchemaProperties(normalizedSchema, context);
                return normalizedSchema;
            }
            ArrayList<Object> finalList = new ArrayList<Object>(allOf.size());
            ArrayList schemasWithoutRef = new ArrayList(allOf.size() - 1);
            for (Schema<?> schemaAllOf : allOf) {
                Map paramSchemas;
                Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(schemaAllOf, context);
                if (normalizedSchema != null) {
                    schemaAllOf = normalizedSchema;
                }
                if (CollectionUtils.isNotEmpty((Map)(paramSchemas = schemaAllOf.getProperties()))) {
                    HashMap paramNormalizedSchemas = new HashMap();
                    for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                        Schema paramSchema = (Schema)paramEntry.getValue();
                        Schema<?> paramNormalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, context);
                        if (paramNormalizedSchema == null) continue;
                        paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                    }
                    if (CollectionUtils.isNotEmpty(paramNormalizedSchemas)) {
                        paramSchemas.putAll(paramNormalizedSchemas);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)schemaAllOf.get$ref())) {
                    schemasWithoutRef.add(schemaAllOf);
                    if (StringUtils.isNotEmpty((CharSequence)schema.getDescription()) && StringUtils.isNotEmpty((CharSequence)schemaAllOf.getDescription())) {
                        schemaAllOf.setDescription(null);
                    }
                    if (schema.getDefault() == null || schemaAllOf.getDefault() == null || !schema.getDefault().equals(schemaAllOf.getDefault())) continue;
                    schema.setDefault(null);
                    continue;
                }
                finalList.add(schemaAllOf);
            }
            finalList.addAll(schemasWithoutRef);
            schema.setAllOf(finalList);
        }
        OpenApiNormalizeUtils.normalizeSchemaProperties(schema, context);
        return null;
    }

    private static void normalizeSchemaProperties(Schema<?> schema, VisitorContext context) {
        Object object;
        if (schema == null) {
            return;
        }
        String type = schema.getType();
        if (schema.getExample() == null) {
            schema.setExampleSetFlag(false);
        } else if (!"string".equals(type) && (object = schema.getExample()) instanceof String) {
            String exampleStr = (String)object;
            schema.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, type, schema.getFormat(), context, false));
        }
    }

    public static void normalizeSchemas(Map<String, Schema> schemas, VisitorContext context) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        HashMap normalizedSchemas = new HashMap();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Map paramSchemas;
            Schema schema = entry.getValue();
            Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(schema, context);
            if (normalizedSchema != null) {
                normalizedSchemas.put(entry.getKey(), normalizedSchema);
            } else if (schema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                schema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty((Map)(paramSchemas = schema.getProperties()))) continue;
            HashMap paramNormalizedSchemas = new HashMap();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema<?> paramNormalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, context);
                if (paramNormalizedSchema != null) {
                    paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                    continue;
                }
                if (!paramSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) continue;
                paramSchema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
        if (CollectionUtils.isNotEmpty(normalizedSchemas)) {
            schemas.putAll(normalizedSchemas);
        }
    }

    public static void removeEmptyComponents(OpenAPI openAPI) {
        Components components;
        if (CollectionUtils.isEmpty((Map)openAPI.getWebhooks())) {
            openAPI.setWebhooks(null);
        }
        if ((components = openAPI.getComponents()) == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas())) {
            components.setSchemas(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getResponses())) {
            components.setResponses(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getParameters())) {
            components.setParameters(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExamples())) {
            components.setExamples(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getRequestBodies())) {
            components.setRequestBodies(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getHeaders())) {
            components.setHeaders(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
            components.setSecuritySchemes(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getLinks())) {
            components.setLinks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getCallbacks())) {
            components.setCallbacks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExtensions())) {
            components.setExtensions(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getPathItems())) {
            components.setPathItems(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas()) && CollectionUtils.isEmpty((Map)components.getResponses()) && CollectionUtils.isEmpty((Map)components.getParameters()) && CollectionUtils.isEmpty((Map)components.getExamples()) && CollectionUtils.isEmpty((Map)components.getRequestBodies()) && CollectionUtils.isEmpty((Map)components.getHeaders()) && CollectionUtils.isEmpty((Map)components.getSecuritySchemes()) && CollectionUtils.isEmpty((Map)components.getLinks()) && CollectionUtils.isEmpty((Map)components.getCallbacks()) && CollectionUtils.isEmpty((Map)components.getExtensions()) && CollectionUtils.isEmpty((Map)components.getPathItems())) {
            openAPI.setComponents(null);
        }
    }

    public static void findAndRemoveDuplicates(OpenAPI openApi) {
        openApi.setTags(Utils.findAndRemoveDuplicates(openApi.getTags(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName())));
        openApi.setServers(Utils.findAndRemoveDuplicates(openApi.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
        openApi.setSecurity(Utils.findAndRemoveDuplicates(openApi.getSecurity(), (el1, el2) -> el1 != null && el1.equals(el2)));
        if (CollectionUtils.isNotEmpty((Map)openApi.getPaths())) {
            for (PathItem path : openApi.getPaths().values()) {
                path.setServers(Utils.findAndRemoveDuplicates(path.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
                path.setParameters(Utils.findAndRemoveDuplicates(path.getParameters(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName()) && el1.getIn() != null && el1.getIn().equals(el2.getIn())));
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getGet());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getPut());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getPost());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getDelete());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getOptions());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getHead());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getPatch());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getTrace());
            }
        }
        if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApi.getComponents().getSchemas())) {
            for (Schema schema : openApi.getComponents().getSchemas().values()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(schema);
            }
        }
        if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApi.getComponents().getSchemas())) {
            for (Schema schema : openApi.getComponents().getSchemas().values()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(schema);
            }
        }
    }

    public static void findAndRemoveDuplicates(Operation operation) {
        if (operation == null) {
            return;
        }
        operation.setTags(Utils.findAndRemoveDuplicates(operation.getTags(), (el1, el2) -> el1 != null && el1.equals(el2)));
        operation.setServers(Utils.findAndRemoveDuplicates(operation.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
        operation.setSecurity(Utils.findAndRemoveDuplicates(operation.getSecurity(), (el1, el2) -> el1 != null && el1.equals(el2)));
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter param : operation.getParameters()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(param.getContent());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(param.getSchema());
            }
            operation.setParameters(Utils.findAndRemoveDuplicates(operation.getParameters(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName()) && el1.getIn() != null && el1.getIn().equals(el2.getIn())));
        }
        if (operation.getRequestBody() != null) {
            OpenApiNormalizeUtils.findAndRemoveDuplicates(operation.getRequestBody().getContent());
        }
        if (CollectionUtils.isNotEmpty((Map)operation.getResponses())) {
            for (ApiResponse response : operation.getResponses().values()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(response.getContent());
            }
        }
    }

    public static void findAndRemoveDuplicates(Content content) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            OpenApiNormalizeUtils.findAndRemoveDuplicates(mediaType.getSchema());
        }
    }

    public static void findAndRemoveDuplicates(Schema<?> schema) {
        if (schema == null) {
            return;
        }
        schema.setRequired(Utils.findAndRemoveDuplicates(schema.getRequired(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setPrefixItems(Utils.findAndRemoveDuplicates(schema.getPrefixItems(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setAllOf(Utils.findAndRemoveDuplicates(schema.getAllOf(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setAnyOf(Utils.findAndRemoveDuplicates(schema.getAnyOf(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setOneOf(Utils.findAndRemoveDuplicates(schema.getOneOf(), (el1, el2) -> el1 != null && el1.equals(el2)));
    }
}

