/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

final class RedocConfig
extends AbstractViewConfig {
    public static final String REDOC_PREFIX = "redoc.";
    private static final String DEFAULT_REDOC_JS_PATH = "res/";
    private static final List<String> RESOURCE_FILES = Collections.singletonList("res/redoc.standalone.js");
    private static final Map<String, Object> DEFAULT_OPTIONS;
    private static final Map<String, Function<String, Object>> VALID_OPTIONS;
    RapiPDFConfig rapiPDFConfig;

    private RedocConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        super(REDOC_PREFIX, openApiInfos);
        this.jsUrl = DEFAULT_REDOC_JS_PATH;
    }

    static RedocConfig fromProperties(Map<String, String> properties, Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        return AbstractViewConfig.fromProperties(new RedocConfig(openApiInfos), DEFAULT_OPTIONS, properties, OpenApiViewConfig.RendererType.REDOC, context);
    }

    @Override
    public String render(String template, @Nullable VisitorContext context) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.REDOC, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "redoc.js.url.prefix", this.isDefaultJsUrl ? this.getFinalUrlPrefix(OpenApiViewConfig.RendererType.REDOC, context) : this.jsUrl, "");
        return OpenApiViewConfig.replacePlaceHolder(template, "redoc.attributes", this.toHtmlAttributes(), "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    @Override
    protected List<String> getResources() {
        return RESOURCE_FILES;
    }

    static {
        VALID_OPTIONS = new HashMap<String, Function<String, Object>>(38);
        VALID_OPTIONS.put("disable-search", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("min-character-length-to-init-search", AbstractViewConfig::asInt);
        VALID_OPTIONS.put("expand-default-server-variables", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("expand-responses", AbstractViewConfig::asString);
        VALID_OPTIONS.put("generated-payload-samples-max-depth", AbstractViewConfig::asInt);
        VALID_OPTIONS.put("max-displayed-enum-values", AbstractViewConfig::asInt);
        VALID_OPTIONS.put("hide-download-button", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("download-file-name", AbstractViewConfig::asString);
        VALID_OPTIONS.put("download-definition-url", AbstractViewConfig::asString);
        VALID_OPTIONS.put("hide-hostname", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-loading", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-fab", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-schema-pattern", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-single-request-sample-tab", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("show-object-schema-examples", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("expand-single-schema-field", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("schema-expansion-level", AbstractViewConfig::asString);
        VALID_OPTIONS.put("json-sample-expand-level", AbstractViewConfig::asString);
        VALID_OPTIONS.put("hide-schema-titles", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("simple-one-of-type-label", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("sort-enum-values-alphabetically", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("sort-operations-alphabetically", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("sort-tags-alphabetically", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("lazy-rendering", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("menu-toggle", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("native-scrollbars", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("only-required-in-samples", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("path-in-middle-panel", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("required-props-first", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("scroll-y-offset", AbstractViewConfig::asString);
        VALID_OPTIONS.put("show-extensions", AbstractViewConfig::asString);
        VALID_OPTIONS.put("sort-props-alphabetically", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("payload-sample-idx", AbstractViewConfig::asString);
        VALID_OPTIONS.put("theme", AbstractViewConfig::asString);
        VALID_OPTIONS.put("untrusted-spec", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("nonce", AbstractViewConfig::asString);
        VALID_OPTIONS.put("side-nav-style", SideNavStyle::byCode);
        VALID_OPTIONS.put("show-webhook-verb", AbstractViewConfig::asBoolean);
        DEFAULT_OPTIONS = Collections.singletonMap("sort-tags-alphabetically", Boolean.TRUE);
    }

    static enum SideNavStyle {
        SUMMARY_ONLY("summary-only"),
        PATH_ONLY("path-only"),
        ID_ONLY("id-only");

        private static final Map<String, SideNavStyle> BY_CODE;
        private final String code;

        private SideNavStyle(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public static SideNavStyle byCode(String code) {
            SideNavStyle value = BY_CODE.get(code.toLowerCase());
            if (value == null) {
                throw new IllegalArgumentException("Unknown value " + code);
            }
            return value;
        }

        static {
            HashMap<String, SideNavStyle> byCode = new HashMap<String, SideNavStyle>(SideNavStyle.values().length);
            for (SideNavStyle navTagClick : SideNavStyle.values()) {
                byCode.put(navTagClick.code, navTagClick);
            }
            BY_CODE = Collections.unmodifiableMap(byCode);
        }
    }
}

