/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SwaggerUIConfig
extends AbstractViewConfig {
    private static final String DEFAULT_SWAGGER_JS_PATH = "res/";
    private static final List<String> RESOURCE_FILES = List.of("res/index.css", "res/swagger-ui.css", "res/favicon-16x16.png", "res/favicon-32x32.png", "res/swagger-ui-bundle.js", "res/swagger-ui-standalone-preset.js");
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>(4);
    private static final String OPTION_PRIMARY_NAME = "primaryName";
    private static final String OPTION_URLS = "urls";
    private static final String OPTION_OAUTH2 = "oauth2";
    private static final String PREFIX_SWAGGER_UI = "swagger-ui";
    private static final String KEY_VALUE_SEPARATOR = ": ";
    private static final String COMMNA_NEW_LINE = ",\n";
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(30);
    private static final Map<String, Function<String, Object>> VALID_OAUTH2_OPTIONS = new HashMap<String, Function<String, Object>>(9);
    String themeUrl;
    boolean isDefaultThemeUrl = true;
    boolean copyTheme = true;
    RapiPDFConfig rapiPDFConfig;
    Theme theme = Theme.CLASSIC;

    private SwaggerUIConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        super("swagger-ui.", openApiInfos);
        this.jsUrl = DEFAULT_SWAGGER_JS_PATH;
    }

    @NonNull
    private String toOptions() {
        return this.toOptions(VALID_OPTIONS, null);
    }

    private String toOptions(@NonNull Map<String, Function<String, Object>> validOptions, @Nullable String keyPrefix) {
        return this.options.entrySet().stream().filter(e -> validOptions.containsKey(e.getKey())).sorted(Map.Entry.comparingByKey()).map(e -> (keyPrefix != null && ((String)e.getKey()).startsWith(keyPrefix) ? ((String)e.getKey()).substring(keyPrefix.length()) : (String)e.getKey()) + KEY_VALUE_SEPARATOR + e.getValue()).collect(Collectors.joining(COMMNA_NEW_LINE));
    }

    @NonNull
    private String toOauth2Options() {
        String properties = this.toOptions(VALID_OAUTH2_OPTIONS, "oauth2.");
        if (StringUtils.hasText((CharSequence)properties)) {
            return "ui.initOAuth({\n" + properties + "\n});";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean hasOauth2Option(Map<String, Object> options) {
        if (options.containsKey("oauth2RedirectUrl")) return true;
        if (!VALID_OAUTH2_OPTIONS.keySet().stream().anyMatch(options::containsKey)) return false;
        return true;
    }

    static SwaggerUIConfig fromProperties(Map<String, String> properties, Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        String themeUrl;
        SwaggerUIConfig cfg = new SwaggerUIConfig(openApiInfos);
        cfg.theme = Theme.valueOf(properties.getOrDefault("swagger-ui.theme", cfg.theme.name()).toUpperCase(Locale.US));
        String copyTheme = properties.get(cfg.prefix + "copy-theme");
        if (StringUtils.isNotEmpty((CharSequence)copyTheme) && "false".equalsIgnoreCase(copyTheme)) {
            cfg.copyTheme = false;
        }
        if (StringUtils.isNotEmpty((CharSequence)(themeUrl = properties.get(cfg.prefix + "theme.url")))) {
            cfg.themeUrl = themeUrl;
            cfg.isDefaultThemeUrl = false;
        }
        return AbstractViewConfig.fromProperties(cfg, DEFAULT_OPTIONS, properties, OpenApiViewConfig.RendererType.SWAGGER_UI, context);
    }

    @Override
    public String render(String template, @Nullable VisitorContext context) {
        String finalUrlPrefix = this.getFinalUrlPrefix(OpenApiViewConfig.RendererType.SWAGGER_UI, context);
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.SWAGGER_UI, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.js.url.prefix", this.isDefaultJsUrl ? finalUrlPrefix : this.jsUrl, "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.attributes", this.toOptions(), "");
        if (this.theme != null && Theme.CLASSIC != this.theme) {
            String themeCssLink = this.isDefaultThemeUrl ? finalUrlPrefix + this.theme.getCss() + ".css" : this.themeUrl;
            template = template.replace("{{swagger-ui.theme}}", "link(contextPath + \"" + themeCssLink + "\", head, \"text/css\", \"stylesheet\")");
        } else {
            template = template.replace("{{swagger-ui.theme}}", "");
        }
        template = template.replace("{{swagger-ui.oauth2}}", SwaggerUIConfig.hasOauth2Option(this.options) ? this.toOauth2Options() : "");
        template = template.replace("{{swagger-ui.primaryName}}", StringUtils.isNotEmpty((CharSequence)this.primaryName) ? this.getPrimaryName(context) : "");
        template = template.replace("{{swagger-ui.urls}}", this.getUrlStr(context));
        return template;
    }

    @NonNull
    private String getPrimaryName(VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)this.primaryName)) {
            return "";
        }
        return "\"urls.primaryName\":\"" + this.primaryName + "\",";
    }

    @NonNull
    private String getUrlStr(VisitorContext context) {
        if (CollectionUtils.isEmpty((Collection)this.urls) || this.withUrls != null && !this.withUrls.booleanValue()) {
            return "";
        }
        boolean isFirst = true;
        StringBuilder result = new StringBuilder("urls: [");
        for (AbstractViewConfig.OpenApiUrl url : this.urls) {
            if (!isFirst) {
                result.append(',');
            }
            result.append("{url: contextPath + '").append(url.url()).append("', name: '").append(url.name()).append("'}");
            isFirst = false;
        }
        result.append("],");
        return result.toString();
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return (VALID_OPTIONS.containsKey(key) ? VALID_OPTIONS : VALID_OAUTH2_OPTIONS).get(key);
    }

    @Override
    protected List<String> getResources() {
        return RESOURCE_FILES;
    }

    static {
        VALID_OPTIONS.put("layout", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("deepLinking", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("displayOperationId", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("defaultModelsExpandDepth", AbstractViewConfig::asString);
        VALID_OPTIONS.put("defaultModelExpandDepth", AbstractViewConfig::asString);
        VALID_OPTIONS.put("defaultModelRendering", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("displayRequestDuration", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("docExpansion", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("filter", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("maxDisplayedTags", AbstractViewConfig::asString);
        VALID_OPTIONS.put("operationsSorter", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("showExtensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("showCommonExtensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("tagsSorter", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("useUnsafeMarkdown", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("onComplete", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("syntaxHighlight", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("syntaxHighlight.activate", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("syntaxHighlight.theme", SyntaxHighlightTheme::byCode);
        VALID_OPTIONS.put("tryItOutEnabled", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("requestSnippetsEnabled", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("requestSnippets", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("oauth2RedirectUrl", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("requestInterceptor", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("request.curlOptions", AbstractViewConfig::asString);
        VALID_OPTIONS.put("responseInterceptor", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("showMutatedRequest", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("supportedSubmitMethods", AbstractViewConfig::asString);
        VALID_OPTIONS.put("validatorUrl", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("withCredentials", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("persistAuthorization", AbstractViewConfig::asBoolean);
        VALID_OAUTH2_OPTIONS.put("oauth2.clientId", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.clientSecret", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.realm", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.appName", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.scopeSeparator", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.scopes", AbstractViewConfig::asQuotedString);
        VALID_OAUTH2_OPTIONS.put("oauth2.additionalQueryStringParams", AbstractViewConfig::asString);
        VALID_OAUTH2_OPTIONS.put("oauth2.useBasicAuthenticationWithAccessCodeGrant", AbstractViewConfig::asBoolean);
        VALID_OAUTH2_OPTIONS.put("oauth2.usePkceWithAuthorizationCodeGrant", AbstractViewConfig::asBoolean);
        DEFAULT_OPTIONS.put("layout", "\"StandaloneLayout\"");
        DEFAULT_OPTIONS.put("deepLinking", Boolean.TRUE);
        DEFAULT_OPTIONS.put("validatorUrl", null);
        DEFAULT_OPTIONS.put("tagsSorter", "\"alpha\"");
    }

    static enum Theme {
        CLASSIC("classic"),
        DARK("dark"),
        FEELING_BLUE("feeling-blue"),
        FLATTOP("flattop"),
        MATERIAL("material"),
        MONOKAI("monokai"),
        MUTED("muted"),
        NEWSPAPER("newspaper"),
        OUTLINE("toutline");

        private final String css;

        private Theme(String css) {
            this.css = css;
        }

        public String getCss() {
            return this.css;
        }
    }

    static enum SyntaxHighlightTheme {
        AGATE("agate"),
        ARTA("arta"),
        MONOKAI("monokai"),
        NORD("nord"),
        OBSIDIAN("obsidian"),
        TOMORROW_NIGHT("tomorrow-night");

        private static final Map<String, SyntaxHighlightTheme> BY_CODE;
        private final String code;

        private SyntaxHighlightTheme(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public static SyntaxHighlightTheme byCode(String code) {
            SyntaxHighlightTheme value = BY_CODE.get(code.toLowerCase());
            if (value == null) {
                throw new IllegalArgumentException("Unknown value " + code);
            }
            return value;
        }

        static {
            HashMap<String, SyntaxHighlightTheme> byCode = new HashMap<String, SyntaxHighlightTheme>(SyntaxHighlightTheme.values().length);
            for (SyntaxHighlightTheme navTagClick : SyntaxHighlightTheme.values()) {
                byCode.put(navTagClick.code, navTagClick);
            }
            BY_CODE = Collections.unmodifiableMap(byCode);
        }
    }
}

