/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.SchemaDefinitionUtils;
import io.micronaut.openapi.visitor.UrlUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Internal
abstract class AbstractOpenApiVisitor {
    private static final Lock VISITED_ELEMENTS_LOCK = new ReentrantLock();

    AbstractOpenApiVisitor() {
    }

    void incrementVisitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            ContextUtils.put("io.micronaut.OPENAPI.visited.elements", ContextUtils.getVisitedElements(context) + 1, context);
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    int visitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            int n = ContextUtils.getVisitedElements(context);
            return n;
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    List<SecurityRequirement> readSecurityRequirements(Element element) {
        return this.readSecurityRequirements(element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class));
    }

    List<SecurityRequirement> readSecurityRequirements(List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> annotations) {
        ArrayList<SecurityRequirement> result = new ArrayList<SecurityRequirement>(annotations.size());
        for (AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> ann : annotations) {
            result.add(ConvertUtils.mapToSecurityRequirement(ann));
        }
        return result;
    }

    Map<String, List<PathItem>> resolvePathItems(VisitorContext context, List<UriMatchTemplate> matchTemplates) {
        OpenAPI openAPI = Utils.resolveOpenApi(context);
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            openAPI.setPaths(paths);
        }
        HashMap<String, List<PathItem>> resultPathItemsMap = new HashMap<String, List<PathItem>>();
        for (UriMatchTemplate matchTemplate : matchTemplates) {
            List<UrlUtils.Segment> segms = UrlUtils.parsePathSegments(matchTemplate.toPathString());
            List<String> finalPaths = UrlUtils.buildUrls(segms);
            for (String finalPath : finalPaths) {
                List resultPathItems = resultPathItemsMap.computeIfAbsent(finalPath, k -> new ArrayList());
                resultPathItems.add((PathItem)paths.computeIfAbsent((Object)finalPath, key -> new PathItem()));
            }
        }
        return resultPathItemsMap;
    }

    protected void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(SecurityScheme.class);
        OpenAPI openApi = Utils.resolveOpenApi(context);
        ConvertUtils.addSecuritySchemes(openApi, values, context);
    }

    protected <T, A extends Annotation> List<T> processOpenApiAnnotation(Element element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                Optional<T> tagOpt;
                Map values;
                Map tagValues = tag.getValues();
                if (tag.getAnnotationName().equals(io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName()) && !tagValues.isEmpty()) {
                    Object name = tagValues.get("name");
                    Object scopes = tagValues.get("scopes");
                    if (scopes == null) {
                        scopes = new ArrayList();
                    }
                    values = Collections.singletonMap((CharSequence)name, scopes);
                } else {
                    values = tagValues;
                }
                if (!(tagOpt = SchemaDefinitionUtils.toValue(values, context, modelType, null)).isPresent()) continue;
                T tagObj = tagOpt.get();
                boolean alreadyExists = false;
                if (CollectionUtils.isNotEmpty(tagList) && tag.getAnnotationName().equals(Tag.class.getName())) {
                    for (T existedTag : tagList) {
                        if (!((io.swagger.v3.oas.models.tags.Tag)existedTag).getName().equals(((io.swagger.v3.oas.models.tags.Tag)tagObj).getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                }
                if (alreadyExists) continue;
                tagList.add(tagObj);
            }
        }
        return tagList;
    }
}

