/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class ProtoUtils {
    public static List<PropertyElement> filterProtobufProperties(ClassElement classElement, List<PropertyElement> beanProperties) {
        if (!ProtoUtils.isProtobufGenerated(classElement)) {
            return beanProperties;
        }
        ArrayList<PropertyElement> propertiesWithoutProto = new ArrayList<PropertyElement>();
        for (PropertyElement prop : beanProperties) {
            if (prop.getName().equals("initialized") || prop.getName().equals("defaultInstanceForType") || prop.getName().equals("initializationErrorString") || prop.getName().equals("descriptorForType") || prop.getName().equals("allFields") || prop.getName().equals("unknownFields")) continue;
            MethodElement readMethod = prop.getReadMethod().orElse(null);
            if (readMethod != null) {
                MethodElement enumMethod;
                ClassElement returnType = readMethod.getReturnType();
                if (readMethod.getName().endsWith("OrBuilderList") || readMethod.getName().endsWith("Bytes") && returnType.getName().equals("com.google.protobuf.ByteString") || returnType.getName().equals("java.util.Map") && readMethod.getName().endsWith("Map") || readMethod.getName().endsWith("Value") && (enumMethod = (MethodElement)classElement.findMethod(readMethod.getName().substring(0, readMethod.getName().lastIndexOf("Value"))).orElse(null)) != null && enumMethod.getReturnType().isEnum() || readMethod.getName().endsWith("Count") && classElement.findMethod(readMethod.getName().substring(0, readMethod.getName().lastIndexOf("Count"))).isPresent()) continue;
                if (ProtoUtils.isProtobufGenerated(returnType) && prop.getName().endsWith("OrBuilder")) {
                    String propName = prop.getName().substring(0, prop.getName().lastIndexOf("OrBuilder"));
                    boolean found = false;
                    for (PropertyElement propWithoutSuffix : beanProperties) {
                        if (!propName.equals(propWithoutSuffix.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
            }
            propertiesWithoutProto.add(prop);
        }
        return propertiesWithoutProto;
    }

    public static Schema protobufTypeSchema(ClassElement type) {
        String typeName;
        if (!ProtoUtils.isProtobufType(type)) {
            return null;
        }
        switch (typeName = type.getName()) {
            case "com.google.protobuf.ByteString": {
                return SchemaUtils.setSpecVersion(PrimitiveType.BYTE.createProperty());
            }
            case "com.google.protobuf.BytesValueOrBuilder": {
                return SchemaUtils.setNullable(SchemaUtils.setSpecVersion(PrimitiveType.BYTE.createProperty()));
            }
            case "com.google.protobuf.DoubleValueOrBuilder": {
                return SchemaUtils.setNullable(SchemaUtils.setSpecVersion(PrimitiveType.DOUBLE.createProperty()));
            }
            case "com.google.protobuf.FloatValueOrBuilder": {
                return SchemaUtils.setNullable(SchemaUtils.setSpecVersion(PrimitiveType.FLOAT.createProperty()));
            }
            case "com.google.protobuf.BoolValueOrBuilder": {
                return SchemaUtils.setNullable(SchemaUtils.setSpecVersion(PrimitiveType.BOOLEAN.createProperty()));
            }
            case "com.google.protobuf.StringValueOrBuilder": {
                return SchemaUtils.setNullable(SchemaUtils.setSpecVersion(PrimitiveType.STRING.createProperty()));
            }
            case "com.google.protobuf.Int32ValueOrBuilder": 
            case "com.google.protobuf.UInt32ValueOrBuilder": {
                return SchemaUtils.setNullable(SchemaUtils.setSpecVersion(PrimitiveType.INT.createProperty()));
            }
            case "com.google.protobuf.Int64ValueOrBuilder": 
            case "com.google.protobuf.UInt64ValueOrBuilder": {
                return SchemaUtils.setSpecVersion(PrimitiveType.LONG.createProperty());
            }
            case "com.google.protobuf.AnyOrBuilder": 
            case "com.google.protobuf.ApiOrBuilder": 
            case "com.google.protobuf.DurationOrBuilder": 
            case "com.google.protobuf.EmptyOrBuilder": {
                return null;
            }
        }
        return null;
    }

    public static String normalizePropertyName(String propertyName, ClassElement classElement, ClassElement propertyType) {
        if (!ProtoUtils.isProtobufGenerated(classElement) || !propertyType.isIterable()) {
            return propertyName;
        }
        int listIndex = propertyName.lastIndexOf("List");
        if (listIndex > 0) {
            propertyName = propertyName.substring(0, listIndex);
        }
        return propertyName;
    }

    public static String normalizeProtobufClassName(String className) {
        int endIndex = className.indexOf("OrBuilder");
        if (endIndex < 0) {
            return className;
        }
        return className.substring(0, endIndex);
    }

    public static boolean isProtobufType(ClassElement type) {
        return type != null && type.getPackageName().startsWith("com.google.protobuf");
    }

    public static boolean isProtobufGenerated(ClassElement type) {
        return type != null && (type.isAssignable("com.google.protobuf.MessageOrBuilder") || type.isAssignable("com.google.protobuf.ProtocolMessageEnum"));
    }

    public static boolean isProtobufMessageClass(ClassElement type) {
        return type != null && (type.isAssignable("com.google.protobuf.GeneratedMessageV3") || type.isAssignable("com.google.protobuf.GeneratedMessage") || type.isAssignable("com.google.protobuf.GeneratedMessageLite"));
    }
}

