/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class UrlUtils {
    private UrlUtils() {
    }

    public static List<String> buildUrls(List<Segment> segments) {
        ArrayList<StringBuilder> results = new ArrayList<StringBuilder>();
        Segment prevSegment = null;
        for (Segment segment : segments) {
            UrlUtils.appendSegment(segment, prevSegment, results);
            prevSegment = segment;
        }
        ArrayList<String> resultStrings = new ArrayList<String>();
        for (StringBuilder res : results) {
            Object url = res.toString();
            if (((String)url).endsWith("/") && ((String)url).length() > 1) {
                url = ((String)url).substring(0, ((String)url).length() - "/".length());
            } else if (!((String)url).startsWith("/") && !((String)url).startsWith("$")) {
                url = "/" + (String)url;
            } else if (((String)url).startsWith("/$")) {
                url = ((String)url).substring(1);
            }
            if (resultStrings.contains(url)) continue;
            resultStrings.add((String)url);
        }
        return resultStrings;
    }

    private static void appendSegment(Segment segment, Segment prevSegment, List<StringBuilder> results) {
        SegmentType type = segment.type;
        String value = segment.value;
        if (results.isEmpty()) {
            if (type == SegmentType.PLACEHOLDER) {
                results.add(new StringBuilder(value));
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(value);
            results.add(builder);
            if (type == SegmentType.OPT_VAR) {
                results.add(new StringBuilder());
            }
            return;
        }
        if (type == SegmentType.CONST || type == SegmentType.REQ_VAR || type == SegmentType.PLACEHOLDER) {
            for (StringBuilder result : results) {
                result.append(value);
            }
            return;
        }
        ArrayList<StringBuilder> newResults = new ArrayList<StringBuilder>();
        for (StringBuilder result : results) {
            newResults.add(new StringBuilder(result));
        }
        for (StringBuilder result : results) {
            if (prevSegment.type == SegmentType.OPT_VAR && result.indexOf(prevSegment.value) < 0) continue;
            result.append('/').append(value);
        }
        results.addAll(newResults);
    }

    public static List<Segment> parsePathSegments(String pathString) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int startPos = 0;
        while (true) {
            int startBlockPos;
            SegmentType type;
            int varStartPos;
            if ((varStartPos = pathString.indexOf(123, startPos)) < 0) break;
            int varEndPos = pathString.indexOf(125, varStartPos);
            String constSegment = pathString.substring(startPos, varStartPos);
            char nextChar = pathString.charAt(varStartPos + 1);
            if (nextChar == '?' || nextChar == '.' || nextChar == '+' || nextChar == '0') {
                UrlUtils.addConstValue(constSegment, segments);
                startPos = varEndPos + 1;
                continue;
            }
            if (varStartPos >= 1 && pathString.charAt(varStartPos - 1) == '$') {
                if (!constSegment.isEmpty()) {
                    UrlUtils.addConstValue(constSegment.substring(0, constSegment.length() - 1), segments);
                }
                segments.add(new Segment(SegmentType.PLACEHOLDER, pathString.substring(varStartPos - 1, varEndPos + 1)));
                startPos = varEndPos + 1;
                continue;
            }
            SegmentType segmentType = type = nextChar == '/' ? SegmentType.OPT_VAR : SegmentType.REQ_VAR;
            if (!constSegment.isEmpty()) {
                UrlUtils.addConstValue(constSegment, segments);
            }
            if (pathString.charAt((startBlockPos = varStartPos) + 1) == '/') {
                ++startBlockPos;
            }
            while (true) {
                int dotPos = pathString.indexOf(44, startBlockPos + 1);
                int dotPos2 = pathString.indexOf(58, startBlockPos + 1);
                int minEndPos = dotPos > 0 && dotPos < varEndPos ? dotPos : varEndPos;
                minEndPos = dotPos2 > 0 && dotPos2 < minEndPos ? dotPos2 : minEndPos;
                String varName = pathString.substring(startBlockPos + 1, minEndPos);
                segments.add(new Segment(type, "{" + varName + "}"));
                if (minEndPos != dotPos) break;
                startBlockPos = minEndPos;
            }
            startPos = varEndPos + 1;
        }
        UrlUtils.addConstValue(pathString.substring(startPos), segments);
        if (segments.isEmpty()) {
            segments.add(new Segment(SegmentType.CONST, "/"));
        }
        return segments;
    }

    private static void addConstValue(String constValue, List<Segment> segments) {
        if (!constValue.isEmpty()) {
            segments.add(new Segment(SegmentType.CONST, constValue));
        }
    }

    public record Segment(SegmentType type, String value) {
    }

    public static enum SegmentType {
        REQ_VAR,
        OPT_VAR,
        CONST,
        PLACEHOLDER;

    }
}

