/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.multipart.FileUpload;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

@Internal
public final class ElementUtils {
    public static final AnnotationValue<?>[] EMPTY_ANNOTATION_VALUES_ARRAY = new AnnotationValue[0];
    public static final List<String> CONTAINER_TYPES = List.of(AtomicReference.class.getName(), "com.google.common.base.Optional", Optional.class.getName(), Future.class.getName(), Callable.class.getName(), CompletionStage.class.getName(), "org.reactivestreams.Publisher", "io.reactivex.Single", "io.reactivex.Observable", "io.reactivex.Maybe", "io.reactivex.rxjava3.core.Single", "io.reactivex.rxjava3.core.Observable", "io.reactivex.rxjava3.core.Maybe", "kotlinx.coroutines.flow.Flow", "org.springframework.web.context.request.async.DeferredResult");
    public static final List<String> FILE_TYPES = List.of("io.micronaut.http.server.types.files.FileCustomizableResponseType", File.class.getName(), InputStream.class.getName(), ByteBuffer.class.getName());
    public static final List<String> VOID_TYPES = List.of(Void.TYPE.getName(), Void.class.getName(), "kotlin.Unit");

    private ElementUtils() {
    }

    public static boolean isSingleResponseType(ClassElement returnType) {
        return (returnType.isAssignable("io.reactivex.Single") || returnType.isAssignable("io.reactivex.rxjava3.core.Single") || returnType.isAssignable("org.reactivestreams.Publisher")) && returnType.getFirstTypeArgument().isPresent() && ElementUtils.isResponseType(returnType.getFirstTypeArgument().orElse(null));
    }

    public static boolean isResponseType(ClassElement returnType) {
        return returnType != null && (returnType.isAssignable(HttpResponse.class) || returnType.isAssignable("org.springframework.http.HttpEntity"));
    }

    public static boolean isNullable(TypedElement element) {
        ClassElement type = element.getType();
        return element.isNullable() || type.isOptional() || type.isAssignable(Optional.class) || type.isAssignable("com.google.common.base.Optional") || type.isAssignable(AtomicReference.class) || type.isAssignable(OptionalInt.class) || type.isAssignable(OptionalLong.class) || type.isAssignable(OptionalDouble.class);
    }

    public static boolean isFileUpload(ClassElement type) {
        ClassElement typeArg;
        if (ElementUtils.isContainerType(type) && (typeArg = (ClassElement)type.getFirstTypeArgument().orElse(null)) != null) {
            type = typeArg;
        }
        String typeName = type.getName();
        return type.isAssignable(FileUpload.class) || "io.micronaut.http.multipart.StreamingFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedPart".equals(typeName) || "io.micronaut.http.multipart.PartData".equals(typeName) || "org.springframework.web.multipart.MultipartFile".equals(typeName);
    }

    public static boolean isNotNullable(Element element) {
        return element.isAnnotationPresent("javax.validation.constraints.NotNull$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotNull$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List") || element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isNonNull() || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    public static boolean isReturnTypeFile(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, FILE_TYPES);
    }

    public static boolean isContainerType(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, CONTAINER_TYPES);
    }

    public static boolean isVoid(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, VOID_TYPES);
    }

    public static boolean isReactiveAndVoid(ClassElement type) {
        return type.isAssignable("io.reactivex.Completable") || type.isAssignable("io.reactivex.rxjava3.core.Completable") || ElementUtils.isContainerType(type) && type.getFirstTypeArgument().isPresent() && ElementUtils.isVoid((ClassElement)type.getFirstTypeArgument().get());
    }

    private static boolean findAnyAssignable(ClassElement type, List<String> typeNames) {
        for (String typeName : typeNames) {
            if (!type.isAssignable(typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnoredParameter(TypedElement parameter) {
        AnnotationValue schemaAnn = parameter.getAnnotation(Schema.class);
        boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
        return isHidden || parameter.isAnnotationPresent(Hidden.class) || parameter.isAnnotationPresent(JsonIgnore.class) || parameter.isAnnotationPresent(Header.class) && parameter.getType().isAssignable(Map.class) || parameter.booleanValue(Parameter.class, "hidden").orElse(false) != false || parameter.hasAnnotation("io.micronaut.session.annotation.SessionValue") || parameter.hasAnnotation("org.springframework.web.bind.annotation.SessionAttribute") || parameter.hasAnnotation("org.springframework.web.bind.annotation.SessionAttributes") || parameter.hasAnnotation("jakarta.ws.rs.core.Context") || ElementUtils.isIgnoredParameterType(parameter.getType());
    }

    public static boolean isJavaBasicType(String typeName) {
        return ClassUtils.isJavaBasicType((String)typeName) || LocalTime.class.getName().equals(typeName) || OffsetTime.class.getName().equals(typeName) || OffsetDateTime.class.getName().equals(typeName) || Period.class.getName().equals(typeName) || YearMonth.class.getName().equals(typeName) || Year.class.getName().equals(typeName) || MonthDay.class.getName().equals(typeName) || ZoneId.class.getName().equals(typeName) || ZoneOffset.class.getName().equals(typeName);
    }

    public static boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.session.Session") || parameterType.isAssignable("io.micronaut.security.authentication.Authentication") || parameterType.isAssignable("io.micronaut.http.HttpHeaders") || parameterType.isAssignable("kotlin.coroutines.Continuation") || parameterType.isAssignable(HttpRequest.class) || parameterType.isAssignable("io.micronaut.http.BasicAuth") || parameterType.isAssignable("jakarta.servlet.http.HttpServletRequest") || parameterType.isAssignable("jakarta.servlet.http.HttpServletResponse") || parameterType.isAssignable("jakarta.servlet.http.HttpSession") || parameterType.isAssignable("jakarta.servlet.ServletConfig") || parameterType.isAssignable("jakarta.servlet.ServletContext") || parameterType.isAssignable("jakarta.servlet.ServletRequest") || parameterType.isAssignable("jakarta.servlet.ServletResponse") || parameterType.isAssignable("jakarta.ws.rs.core.Application") || parameterType.isAssignable("jakarta.ws.rs.core.HttpHeaders") || parameterType.isAssignable("jakarta.ws.rs.core.Request") || parameterType.isAssignable("jakarta.ws.rs.core.SecurityContext") || parameterType.isAssignable("jakarta.ws.rs.core.UriInfo") || parameterType.isAssignable("jakarta.ws.rs.core.Configuration") || parameterType.isAssignable("jakarta.ws.rs.container.ResourceContext") || parameterType.isAssignable("jakarta.ws.rs.ext.Providers") || parameterType.isAssignable("java.io.Reader") || parameterType.isAssignable("java.io.OutputStream") || parameterType.isAssignable("java.io.Writer") || parameterType.isAssignable("org.springframework.web.util.UriComponentsBuilder") || parameterType.isAssignable("org.springframework.web.bind.support.SessionStatus") || parameterType.isAssignable("org.springframework.web.context.request.RequestAttributes") || parameterType.isAssignable("org.springframework.http.HttpEntity") || parameterType.isAssignable("org.springframework.http.HttpMethod") || parameterType.isAssignable("org.springframework.validation.BindingResult") || parameterType.isAssignable("org.springframework.validation.Errors");
    }

    public static AnnotationMetadata getAnnotationMetadata(Element el) {
        if (el == null) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        if (el instanceof MemberElement) {
            MemberElement memberEl = (MemberElement)el;
            AnnotationMetadata propMetadata = memberEl.getAnnotationMetadata();
            AnnotationMetadata constructorMetadata = null;
            MethodElement constructor = ElementUtils.getCreatorConstructor(memberEl.getOwningType());
            if (constructor != null) {
                for (ParameterElement constructorParam : constructor.getParameters()) {
                    if (!constructorParam.getName().equals(memberEl.getName())) continue;
                    constructorMetadata = constructorParam.getAnnotationMetadata();
                    break;
                }
            }
            if (constructorMetadata == null || constructorMetadata.isEmpty()) {
                return propMetadata;
            }
            return new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{propMetadata, constructorMetadata});
        }
        return el.getAnnotationMetadata();
    }

    public static Optional<AnnotationValue<Annotation>> findAnnotation(Element el, String annName) {
        if (el == null) {
            return Optional.empty();
        }
        if (el instanceof MemberElement) {
            MemberElement memberEl = (MemberElement)el;
            Optional result = memberEl.findAnnotation(annName);
            if (result.isPresent()) {
                return result;
            }
            MethodElement constructor = ElementUtils.getCreatorConstructor(memberEl.getOwningType());
            if (constructor != null) {
                for (ParameterElement constructorParam : constructor.getParameters()) {
                    if (!constructorParam.getName().equals(memberEl.getName())) continue;
                    return constructorParam.findAnnotation(annName);
                }
            }
            return Optional.empty();
        }
        return el.findAnnotation(annName);
    }

    public static <T> boolean isAnnotationPresent(Element el, Class<T> annClass) {
        return ElementUtils.isAnnotationPresent(el, annClass.getName());
    }

    public static boolean isAnnotationPresent(Element el, String annName) {
        if (el == null) {
            return false;
        }
        if (el instanceof MemberElement) {
            MemberElement memberEl = (MemberElement)el;
            boolean result = memberEl.isAnnotationPresent(annName);
            if (result) {
                return true;
            }
            MethodElement constructor = ElementUtils.getCreatorConstructor(memberEl.getOwningType());
            if (constructor != null) {
                for (ParameterElement constructorParam : constructor.getParameters()) {
                    if (!constructorParam.getName().equals(memberEl.getName())) continue;
                    return constructorParam.isAnnotationPresent(annName);
                }
            }
            return false;
        }
        return el.isAnnotationPresent(annName);
    }

    public static <T extends Annotation> Optional<String> stringValue(Element el, Class<T> annClass, String member) {
        if (el == null) {
            return Optional.empty();
        }
        if (el instanceof MemberElement) {
            MemberElement memberEl = (MemberElement)el;
            Optional result = memberEl.stringValue(annClass, member);
            if (result.isPresent()) {
                return result;
            }
            MethodElement constructor = ElementUtils.getCreatorConstructor(memberEl.getOwningType());
            if (constructor != null) {
                for (ParameterElement constructorParam : constructor.getParameters()) {
                    if (!constructorParam.getName().equals(memberEl.getName())) continue;
                    return constructorParam.stringValue(annClass, member);
                }
            }
            return result;
        }
        return el.stringValue(annClass, member);
    }

    public static <T extends Annotation> AnnotationValue<T> getAnnotation(Element el, Class<T> annClass) {
        return ElementUtils.getAnnotation(el, annClass.getName());
    }

    public static AnnotationValue getAnnotation(Element el, String annName) {
        if (el == null) {
            return null;
        }
        if (el instanceof MemberElement) {
            MemberElement memberEl = (MemberElement)el;
            AnnotationValue result = memberEl.getAnnotation(annName);
            if (result != null) {
                return result;
            }
            MethodElement constructor = ElementUtils.getCreatorConstructor(memberEl.getOwningType());
            if (constructor != null) {
                for (ParameterElement constructorParam : constructor.getParameters()) {
                    if (!constructorParam.getName().equals(memberEl.getName())) continue;
                    return constructorParam.getAnnotation(annName);
                }
            }
            return result;
        }
        return el.getAnnotation(annName);
    }

    private static MethodElement getCreatorConstructor(ClassElement classEl) {
        MethodElement cachedConstructor = Utils.getCreatorConstructorsCache().get(classEl.getName());
        if (cachedConstructor != null) {
            return cachedConstructor;
        }
        MethodElement creatorConstructor = classEl.getPrimaryConstructor().orElse(null);
        List constructors = classEl.getAccessibleConstructors();
        if (constructors.size() > 1) {
            for (ConstructorElement constructor : constructors) {
                if (!constructor.isDeclaredAnnotationPresent(JsonCreator.class)) continue;
                creatorConstructor = constructor;
            }
        }
        Utils.getCreatorConstructorsCache().put(classEl.getName(), creatorConstructor);
        return creatorConstructor;
    }

    public static ClassElement getJsonViewClass(Element element, VisitorContext context) {
        String jsonViewClassName;
        if (!ConfigUtils.isJsonViewEnabled(context)) {
            return null;
        }
        AnnotationValue jsonViewAnn = element.findAnnotation(JsonView.class).orElse(null);
        if (jsonViewAnn != null && (jsonViewClassName = (String)jsonViewAnn.stringValue().orElse(null)) != null) {
            return ContextUtils.getClassElement(jsonViewClassName, context);
        }
        return null;
    }

    public static boolean isTypeWithGenericNullable(ClassElement type) {
        return type.isAssignable(Optional.class) || type.isAssignable("com.google.common.base.Optional") || type.isAssignable(AtomicReference.class);
    }

    public static boolean isEnum(ClassElement classElement) {
        boolean isEnum = classElement.isEnum();
        AnnotationValue jsonFormatAnn = classElement.getAnnotation(JsonFormat.class);
        if (jsonFormatAnn == null) {
            return isEnum;
        }
        JsonFormat.Shape jsonShape = jsonFormatAnn.get((CharSequence)"shape", JsonFormat.Shape.class).orElse(JsonFormat.Shape.ANY);
        return jsonShape != JsonFormat.Shape.OBJECT && isEnum;
    }
}

